// Provide and create the communication webapp.
dojo.provide("webapp.communication.getHistoryLogBase");
dojo.declare("webapp.communication.getHistoryLogBase",
	[ICTouchAPI.webWidget, dijit._Templated],
	{

		_intDisplayedMenu: null,

		postCreate:function() {
			var data = webapp.history.data;
			var func={
				context: webapp.history,
				func: webapp.history.onComlogClick
				};

			data.objComlog = new UIElements.MenuList.MenuListControl({
				boolShowNormalLeftIcon: true,
				autoSelectFirst : false,
				callback: func,
				showEmptyState: true
			}, this.domLogMenu);

			data.objMissedComlog = new UIElements.MenuList.MenuListControl({
				boolShowNormalLeftIcon: true,
				autoSelectFirst : false,
				callback: func,
				showEmptyState: true
			}, this.domMissedLogMenu);

			data.loadList(false, true);
			this.switchMenuList(data.COMLOG_LIST_LOG);

			this.inherited(arguments);
		},

		switchMenuList : function(strMenu) {
			var bSwitched = false;
			// First if to avoid switching to the currently displayed menu.
			if(strMenu != this._intDisplayedMenu) {
				var data = webapp.history.data;
				if(strMenu === data.COMLOG_LIST_LOG) {
					this._intDisplayedMenu = data.COMLOG_LIST_LOG;
					dojo.toggleClass(this.domLog,"hiddenMenu",false);
					dojo.toggleClass(this.domMissedLog,"hiddenMenu",true);
					//webapp.history.data.refreshCommunicationListTitle();
				}
				if(strMenu === data.COMLOG_LIST_MISSED) {
					this._intDisplayedMenu = data.COMLOG_LIST_MISSED;
					dojo.toggleClass(this.domMissedLog,"hiddenMenu",false);
					dojo.toggleClass(this.domLog,"hiddenMenu",true);
					//webapp.history.data.refreshCommunicationListTitle();
				}
				bSwitched = true;
            }
			strMenu = null;
			return bSwitched;
		},

		getDisplayedMenu : function() {
			return this._intDisplayedMenu;
		},

		destroy : function(){
			this.inherited(arguments);
		}
	}

	);
