dojo.provide("webapp.communication.getHistoryContactCardBase");
dojo.declare("webapp.communication.getHistoryContactCardBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{

		/*Object containing all attirbutes to display in the contact card:
		 * @property
		 * @type {Object}
		 * <pre>
		 * {
		 * &nbsp;&nbsp;strContactPhotoPath {string} path of the contact image. If empty, the default image is used. If undefined, no photo is displayed.
		 * &nbsp;&nbsp;strContactCompany {string} company name.
		 * &nbsp;&nbsp;strContactPosition {string} position name.
		 * &nbsp;&nbsp;strContactLocation {string} city.
		 * &nbsp;&nbsp;strAssistantPhotoPath {string} path of the photo assitant.
		 * &nbsp;&nbsp;strCallDuration {string} Call duration string (00:00).
		 * &nbsp;&nbsp;strCallingStatusLabel {string} call status: incoming, outgoing call, ....
		 * &nbsp;&nbsp;arrDetails {string} pdetails of the contact (used to build the presentation list of the contact card).
		 * }
		 * </pre>
		 */
		objCard				: null,
		objEmptyState	: null,
		strContactPhotoPath			: "",
		strContactCompany			: "",
		strContactPosition			: "",
		strContactLocation			: "",
		strContactCallingStatusIcon : "",
		strAssistantPhotoPath		: "",
		strCallDuration				: "",
		boolHasBusinessInformation	: false,
		uiPresentation : null,
		intlastLogState : null,
		domCallDuration             : null,
		domStatusIcon				: null,
		domContactPhoto				: null,
		domAssistantPhoto			: null,
		domContactCallingStatusLabel: null,
		domContactCompany			: null,
		domContactPosition			: null,
		domContactLocation			: null,
		domEmptyState				: null,
		objContactCallingStatusLabel : null,
		_handlerTimerOngoingCall	: null,

		attributeMap: {
			strDuration: {
				node: "domCallDuration",
				type: "innerText"
				}
		},

		constructor: function() {
			// Used to keep reference of the i18n label
			this.objContactCallingStatusLabel = [_("","webapp.communication")];

			webapp.history.data.objContactCard = this;
		},

		toggleOpacity : function(boolActivate) {
			dojo.toggleClass(this.domContactContainer,"opacityZone",boolActivate);
			boolActivate=null;
		},

		postMixInProperties: function() {
			// Only show businessInformation if one of these is non null
			this.boolHasBusinessInformation =
			this.strContactCompany.length > 0 ||
			this.strContactPosition.length > 0 ||
			this.strContactLocation.length > 0;
			if(webapp.history.data.getHotelMode()){
				this.strContactPhotoClass = "ContactHotelPhoto";
			} else {
				this.strContactPhotoClass = "ContactPhoto";
			}
		},

		postCreate: function() {
			ICTouchAPI.debugServices.info("webapp.communication.getContactCardBase - postCreate");
			//register I18N callback
			var handler = this.objContactCallingStatusLabel[0].fillInnerHTML(this.domContactCallingStatusLabel);
			ICTouchAPI.i18nServices.addI18nHandler(this, handler);

			// EmptyState is only visible when status is empty
			this.objEmptyState = new UIElements.EmptyState.EmptyStateControl({}, this.domEmptyState);

			//Build the contact card from data
			this.update(this.objCard);

			FXScroll.init({
				"handler" : this.domContactContainer,
				"easing" : true,
				"scrollType" : "vertical"
			});

			this.objCard = null;
			ICTouchAPI.debugServices.info("webapp.communication.getContactCardBase - postCreate done");
		},

		startup: function() {
			if(this.uiPresentation){
				this.uiPresentation.startup();
			}
		},

		update: function(contactCard) {
			ICTouchAPI.debugServices.info("webapp.communication.getContactCardBase - update");

			this.checkEmptyContactCard();
			if (contactCard) {

				this.objContactCallingStatusLabel[0].changeText(contactCard.strCallingStatusLabel);
				this.updatePhoto(contactCard.strContactPhotoPath);
				this.updateBusinessInfo(contactCard.strContactCompany, contactCard.strContactPosition, contactCard.strContactLocation);
				// If we didn't have a strCallDuration but now we have one, start the timer
				if (contactCard.strCallDuration && !this.strCallDuration) {
					ICTouchAPI.debugServices.debug("webapp.communication.getContactCardBase - update / contactCard.strCallDuration && !this.strCallDuration -> startTimerOngoing");
					this.startTimerOngoing();
				}
				this.buildInfosList(contactCard.arrDetails);
				this.updateAssistantPhoto(contactCard.strAssistantPhotoPath);
			}

			contactCard = null;

			ICTouchAPI.debugServices.info("webapp.communication.getContactCardBase - update done");
		},

		updatePhoto : function (strNewPhoto) {
			var boolModified = false;
			if(this.strContactPhotoPath != strNewPhoto || !this.domPhoto){
				this.strContactPhotoPath = strNewPhoto;
				if(this.domPhoto){
					this.domPhoto.src = null;
					dojo.destroy(this.domPhoto);
					this.domPhoto = null;
				}
				if (typeof strNewPhoto != "undefined") {
					//this.domPhoto = dojo.create('img',{src:strNewPhoto || ICTouchAPI.tools.getDefaultPhotoPath("user", "100")}, this.domContactPhoto);
					this.domPhoto = dojo.create('div',{style: {backgroundImage: 'url('+(strNewPhoto || ICTouchAPI.tools.getDefaultPhotoPath("user", "100"))+')'}}, this.domContactPhoto);
					boolModified = true;
				}
			}
			strNewPhoto = null;
			return boolModified;
		},

		updateAssistantPhoto : function (strNewPhoto) {
			var boolModified = false;
			if(this.strAssistantPhotoPath != strNewPhoto ){

				//store the new photo path
				this.strAssistantPhotoPath = strNewPhoto;

				//delete the old photo
				if(this.domAssistantPhoto){
					this.domAssistantPhoto.src = null;
					dojo.destroy(this.domAssistantPhoto);
					this.domAssistantPhoto = null;
				}

				//add a photo
				if (strNewPhoto) {
					this.domAssistantPhoto = dojo.create('img',{src:strNewPhoto || ICTouchAPI.tools.getDefaultPhotoPath("user", "100")}, this.domStatusIcon);
					dojo.toggleClass(this.domAssistantPhoto, "AssistantPhoto", true);
				}

				boolModified = true;
			}
			strNewPhoto = null;
			return boolModified;
		},

		updateBusinessInfo : function (strCompany, strPosition, strLocation) {
			var boolModified = false;
			if(this.strContactCompany != strCompany){
				this.strContactCompany = strCompany;
				this.domContactCompany.innerText = strCompany || "";
				boolModified = true;
			}
			if(this.strContactPosition != strPosition){
				this.strContactPosition = strPosition;
				this.domContactPosition.innerText = strPosition || "";
				boolModified = true;
			}
			if(this.strContactLocation != strLocation){
				this.strContactLocation = strLocation;
				this.domContactLocation.innerText = strLocation || "";
				boolModified = true;
			}
			strCompany = null;
			strPosition = null;
			strLocation = null;
			return boolModified;
		},

		buildInfosList: function (arrItems) {
			// build UI
			if(this.uiPresentation){
				this.uiPresentation.destroy();
				this.uiPresentation = null;
			}

			if (arrItems) {
				var div = dojo.create('div');
				dojo.addClass(div, "contactDetails");
				dojo.place(div, this.domContactDetails, 'first');
				this.uiPresentation = new UIElements.PresentationList.PresentationListControl({
					arrItems : arrItems,
					boolScroll : false,
					boolShowIcon: true,
					boolShowLabel: true,
                    strDisplay:'contactcard',
					showEmptyState: true
				}, div);
			}
			arrItems = null;
		},

		checkEmptyContactCard : function () {
			var status = webapp.history.getStatus();
			var isEmpty = (status === webapp.history.data.STATUS_EMPTY);
			this.objEmptyState.setVisibility(isEmpty);
			dojo.toggleClass(this.domContactPhoto, "hiddenContactContainer", isEmpty);
			dojo.toggleClass(this.domStatusIcon, "hiddenContactContainer", isEmpty);

			// Update label in empty state
			if (isEmpty && webapp.history.comlog) {
				var data = webapp.history.data;
				var status = webapp.history.comlog.getDisplayedMenu();
				if (status === data.COMLOG_LIST_LOG && status !== this.intlastLogState) {
					this.objEmptyState.setEmptyText(_("Call history is empty", "webapp.communication"));
				}
				this.intlastLogState = status;
			}
		},

		updateContent : function(params) {
			ICTouchAPI.debugServices.info("webapp.communication.getContactCardBase - updateContent");

			this.checkEmptyContactCard();
			var contactCard = [];
			var boolModified = false;

			//Get contact card details from params
			if (params && params.objCard) {
				contactCard = params.objCard;
			}

			//Compare displaied card and contactCard
			if((contactCard.arrDetails && !this.uiPresentation)
			 || (this.uiPresentation && this.uiPresentation.isListModified(contactCard.arrDetails))) {
				boolModified = true;
			}
			else if (this.strContactCompany != contactCard.strContactCompany) {
				boolModified = true;
			}
			else if (this.strContactPosition != contactCard.strContactPosition) {
				boolModified = true;
			}
			else if (this.strContactLocation != contactCard.strContactLocation) {
				boolModified = true;
			}
			else if (this.strContactPhotoPath != contactCard.strContactPhotoPath) {
				boolModified = true;
			}
			else if (this.strAssistantPhotoPath != contactCard.assistantPhoto) {
				boolModified = true;
			}
			// If we didn't have a strCallDuration but now we have one, start the timer
			if (contactCard.strCallDuration && !this.strCallDuration) {
				ICTouchAPI.debugServices.debug("webapp.communication.getContactCardBase - updateContent / contactCard.strCallDuration && !this.strCallDuration -> startTimerOngoing");
				this.startTimerOngoing();
			}
			// If now we don't have a strCallDuration but we previously had one, stop the timer
			if (!contactCard.strCallDuration && this.strCallDuration) {
				ICTouchAPI.debugServices.debug("webapp.communication.getContactCardBase - updateContent / !contactCard.strCallDuration && this.strCallDuration -> stopTimerOngoing");
				this.stopTimerOngoing();
			}

			if (!boolModified && contactCard.strCallDuration != this.strCallDuration && !(contactCard.strCallDuration && !this.strCallDuration)) {
				ICTouchAPI.debugServices.debug("webapp.communication.getContactCardBase - updateContent / !boolModified && contactCard.strCallDuration != this.strCallDuration && !(contactCard.strCallDuration && !this.strCallDuration) -> updateTime with duration : " + contactCard.strCallDuration);
				this.updateTime(contactCard.strCallDuration);
			}

			if (!boolModified && this.objContactCallingStatusLabel[0].toTranslate != contactCard.strCallingStatusLabel) {
				this.objContactCallingStatusLabel[0].changeText(contactCard.strCallingStatusLabel);
			}

			params = null;
			ICTouchAPI.debugServices.info("webapp.communication.getContactCardBase - updateContent done $ return boolModified: " + boolModified);
			return boolModified;
		},

		updateTime: function(strTime){
			if(strTime != this.strCallDuration && this.domCallDuration){

				if(strTime){
					this.attr("strDuration", " - " + strTime);
				} else {
					this.attr("strDuration", "");
				}
				this.strCallDuration = strTime;
			}
			strTime=null;
		},

		// start Timer For on going Communication
		startTimerOngoing : function ()	{
			ICTouchAPI.debugServices.info("webapp.communication.getContactCardBase - startTimerOngoing");
			// if there is allready a timer running, just refresh the time of the selected ongoing call (don't recreate a new timer)
			if(this._handlerTimerOngoingCall){
				ICTouchAPI.debugServices.debug("webapp.communication.getContactCardBase - startTimerOngoing / this._handlerTimerOngoingCall already exists -> return");
				return;
			}
			else {
				var that = this;
				var func = function () {
					that.updateOngoingTimer();
				};
				func();
				this._handlerTimerOngoingCall = setInterval(func, 1000);
			}
			ICTouchAPI.debugServices.info("webapp.communication.getContactCardBase - startTimerOngoing done");
		},

		stopTimerOngoing : function () {
			ICTouchAPI.debugServices.info("webapp.communication.getContactCardBase - stopTimerOngoing");
			// if the timer is already null, nothing to do -> return
			if(this._handlerTimerOngoingCall == null){
				ICTouchAPI.debugServices.debug("webapp.communication.getContactCardBase - stopTimerOngoing / this._handlerTimerOngoingCall is already null -> return");
				return;
			}
			else {
				clearInterval(this._handlerTimerOngoingCall);
				this._handlerTimerOngoingCall = null;
			}
			ICTouchAPI.debugServices.info("webapp.communication.getContactCardBase - stopTimerOngoing done");
		},

		updateOngoingTimer : function() {
			var data = webapp.history.data;
			// Update only if there is no keyboard to hide the screen.
			if(!data._boolKeyboardDeployed){
				var selectedEntry = data.getSelectedEntry();
				var strTime = "";
				strTime = data.getStrCallDuration(selectedEntry);
				//ICTouchAPI.debugServices.info("webapp.communication.getContactCardBase - updateOngoingTimer / call updateTime with strTime : " + strTime);
				this.updateTime(strTime);
			}
		},

		destroy: function() {
			webapp.history.data.objContactCard = null;
			if (typeof this.uiPresentation === "object" && this.uiPresentation !== null)
			{
				this.uiPresentation.destroy();
				delete this.uiPresentation;
			}
			this.stopTimerOngoing();
			this.inherited(arguments);
		}
	}
	);
