/*Contact Webapplication*/
dojo.provide("webapp.communication.getHistoryConferenceCardBase");
dojo.declare("webapp.communication.getHistoryConferenceCardBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{		
		// Values used for the dom
		strPhotoPath		: "",
		strFirstName		: "",
		strLastName			: "",
		strJob				: "",

		// Dom references
		domPhoto			: null,
		domNameTop		: null,
		domNameBottom			: null,
		domJob				: null,
		
                attributeMap: {
                    "strLastName": {
                        node: "domNameTop",
                        type: "innerHTML"
                    }
                },

		postMixInProperties : function() {
			this.strPhotoPath		= this.strPhotoPath || ICTouchAPI.tools.getDefaultPhotoPath("user", "100");
			this.strFirstName		= this.strFirstName || "";
			this.strLastName		= this.strLastName || "";
			this.strJob			= this.strJob || "";
		},

		postCreate : function() {
			if (ICTouchAPI.tools.isFirstNameFirstDisplayed()) {
				// Set first name on top
				this.domNameTop.innerText = this.strFirstName;
				// Set last name on bottom
				this.domNameBottom.innerText = this.strLastName;
			}
			else {
				// Set last name on top
				this.domNameTop.innerText = this.strLastName;
				// Set first name on bottom
				this.domNameBottom.innerText = this.strFirstName;
			}

			// Set job
			this.domJob.innerText = this.strJob;
			this.inherited(arguments);
		},

		// Check for every parameter if it is modified or not. If at least one is modified, return true. Return false otherwise.
		updateContent : function(objConfCard) {
			var boolModified = false;

			if(this.strPhotoPath != (objConfCard.strPhotoPath || ICTouchAPI.tools.getDefaultPhotoPath("user", "100"))){
				boolModified = true;
			}
			else if(this.strFirstName != objConfCard.strFirstName){
				boolModified = true;
			}
			else if(this.strLastName != objConfCard.strLastName){
				boolModified = true;
			}
			else if(this.strJob != objConfCard.strJob){
				boolModified = true;
			}

			return boolModified;
		}
	});
