dojo.provide("webapp.communication.getHistoryBase");
dojo.declare("webapp.communication.getHistoryBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		container : null,
		menu    : null,

		constructor: function() {

		},

		postCreate:function() {
			var data = webapp.history.data;
			webapp.history.updateAppBar();
			webapp.history.objBaseView = new UIElements.ApplicationMode.ThirdControl(
			{
				menu : {
					name    : "webapp.communication.getHistoryLog",
					params  : {}
				},
				container : {
					name    : data.getContainerPath(),
					params	: {}
				},
				objMenuTitle : {
					arrItems: data.getCommunicationListTitle(),
					clickTitleCallback : function(intIndex) {
						webapp.history.data.switchMenu(intIndex);
					}
				},
				objContainerTitle : {
					strLabel: data.getContainerTitle()
				}
			}, this.mainPart);

			this.container = webapp.history.objBaseView.getContainer();
			this.menu = webapp.history.objBaseView.getMenu();
			webapp.history.mainWidget = this;
			webapp.history.comlog = webapp.history.objBaseView.getMenu().getContent();
			webapp.history.domBottom =  webapp.history.objBaseView.domBottom;
			data.selectTitleById(data.COMLOG_LIST_LOG)
			var firstItem = data.findItemByPosition(0, data.COMLOG_LIST_LOG);
			if (firstItem !== undefined){
				data.loadDetails(firstItem.intIndex);
			}
			this.inherited(arguments);

			dojo.publish("webapp.history.loaded");
		},

		reloadContainer : function() {
			// Update application bar
			var data = webapp.history.data;
			webapp.history.updateAppBar();

			//Update 2/3 from current selected entry
			var objCard;
			if(data.isInConference() && webapp.history.getStatus() != data.STATUS_LOG_CONFERENCE_PARTICIPANT_MENULIST_SELECTED){
				objCard = data.getConferenceCardParams();
			} else {
				objCard = data.getContactCardParams();
			}

			this.reloadCard(objCard);
		},

		setConferenceCard : function(arrNumber) {
			var data = webapp.history.data;

			//Get a conference card from an array of numbers
			var objCard = data.buildCurrentConferenceCard(arrNumber);

			this.reloadCard(objCard);
		},

		reloadMenu: function() {
			var data = webapp.history.data;
			this.menu.reload({
				objTitle: {
					strLabel : data.getCommunicationListTitle()
				},
				objContent: {
					name: "webapp.communication.getCommunicationLog",
					params: {}
				}
			});
		},

		emptyContactCard : function() {
 			this.reloadCard({strTitle : " "}); // to have an empty title (instead of no tilte)
		},

		contactCardFromDialedNumber: function(number) {
			var data = webapp.history.data;

			//Get a contact card from the number
			var objContactCard= data.buildOutgoingCallContactCard(number);

			this.reloadCard(objContactCard);
		},

		setContactCardHoldStatus: function(status) {
			var data = webapp.history.data;

			//Get a contact card from the current selected entry
			var objContactCard= data.getContactCardParams();

			// Set the call state label to hold.
			objContactCard.strCallingStatusLabel = data.lstCallStateLabel[data.STATUS_HOLD];

			this.reloadCard(objContactCard);

		},

		getContainer : function() {
			return this.container;
		},

		//Reload a contact/conference card from a card object
		reloadCard : function(objCard) {

			var data = webapp.history.data;
			//Title
			var objTitle = {
				strLabel: objCard.strTitle || data.getContainerTitle()
			};

			//Content
			var objContent = {
				name: objCard.strPath || data.getContainerPath(),
				params: {
				objCard: objCard
			 }
			 };

			//Reload the contact Card
			this.container.reload({objTitle: objTitle, objContent: objContent});
		},

		destroy : function(){
			dojo.destroy(this.menu);
			dojo.destroy(this.container);
			webapp.history.objBaseView.destroy();
			this.inherited(arguments);
		}
	}
	);

