dojo.provide("webapp.communication.getFiltersBase");
dojo.declare("webapp.communication.getFiltersBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		domFiltersContent	: null,
		objFiltersContent	: null,

		boolUnread			: false,

		// Constant values for the button's id
		BACK				: "BACK_BTN",
		SELECT				: "SELECT_BTN",
		DESELECT			: "DESELECT_BTN",
		UNREAD				: "UNREAD_BTN",

		postCreate : function() {
			// Create the static back button
			ICTouchAPI.AppBarServices.addExitButton("communication", "getFilters", false, {
				context: this,
				func: this.back
			});

			ICTouchAPI.AppBarServices.setAppBar("communication", "getFilters", "getFilters");

			// Create screen content
			var strTitle = _('History filters', "webapp.communication");
			var ctrl = new UIElements.ApplicationMode.FullControl(
			{
				content : {
					name    : "webapp.communication.getFiltersContent",
					params  : {}
				},
				objTitle : {
					strLabel: strTitle
				}
			}, this.domFiltersContent);
			this.objFiltersContent = ctrl.getContent().getContent();	// 1st getContent gives the ApplicationMode object ; 2nd one gives the container below the title
			webapp.history.data.objFiltersContainer = this;
			this.inherited(arguments);
		},

		back : function() {
			ICTouchAPI.transitionServices.getScreen({
				name: "webapp.communication.getHistory",
				params: {}
			});
			webapp.history.data.saveFilterIntoSetting();
		},

		selectAll : function() {
			var objList = this.objFiltersContent.objList;
			objList.selectAll();
			for (var i in objList.arrItems) {
				var filterId = objList.arrItems[i].intIndex;
				webapp.history.data._arrFilters[filterId].enabled = true;
			}
		},

		deselectAll : function() {
			var objList = this.objFiltersContent.objList;
			objList.unselectAll();
			for (var i in objList.arrItems) {
				var filterId = objList.arrItems[i].intIndex;
				webapp.history.data._arrFilters[filterId].enabled = false;
			}
		}
	}
	);
