dojo.provide("webapp.communication.getCommunicationBase");
dojo.declare("webapp.communication.getCommunicationBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		container : null,
		menu    : null,

		constructor: function() {

		},

		postCreate:function() {
			var data = webapp.communication.data;
			webapp.communication.updateAppBar();
			webapp.communication.objBaseView = new UIElements.ApplicationMode.ThirdControl(
			{
				menu : {
					name    : "webapp.communication.getCommunicationLog",
					params  : {}
				},
				container : {
					name    : data.getContainerPath(),
					params	: {}
				},
				objMenuTitle : {
					strLabel: data.getCommunicationListTitle()
				},
				objContainerTitle : {
					strLabel: data.getContainerTitle(),
					strSecondaryLabel : " "
				}
			}, this.mainPart);

			this.container = webapp.communication.objBaseView.getContainer();
			this.menu = webapp.communication.objBaseView.getMenu();
			webapp.communication.mainWidget = this;
			webapp.communication.comlog = webapp.communication.objBaseView.getMenu().getContent();
			webapp.communication.domBottom =  webapp.communication.objBaseView.domBottom;
			var firstItem = data.findItemByPosition(0, data.COMLOG_LIST_LOG);
			if (firstItem !== undefined){
				data.loadDetails(firstItem.intIndex);
			}
			this.inherited(arguments);

			dojo.publish("webapp.communication.loaded");
		},

		reloadContainer : function() {
			// Update application bar
			var data = webapp.communication.data;
			webapp.communication.updateAppBar();
			var entry = data.getSelectedEntry();

			//Update 2/3 from current selected entry
			var objCard;

			if (entry && entry.objCallData) {
			    ICTouchAPI.debugServices.debug("webapp.communication.getCommunicationBase.reloadContainer - isHold: " + entry.objCallData.isOnHold + " isHeld: " + entry.objCallData.isHeld);
			}

			if (entry &&
			    entry.objCallData &&
			    (!entry.objCallData.isHeld && !entry.objCallData.isOnHold) &&
			    data.isInVideoCall(entry.objCallData.callId) && 
				data.boolShowVideo) {
				ICTouchAPI.debugServices.debug("webapp.communication.getCommunicationBase.reloadContainer - display VIDEO");
				objCard = data.getVideoCardParams();
			} else if(data.isInConference() && entry.intStatus != data.STATUS_CONFERENCE_PARTICIPANT_MENULIST_SELECTED){
				ICTouchAPI.debugServices.debug("webapp.communication.getCommunicationBase.reloadContainer - display CONFERENCE CARD");
				objCard = data.getConferenceCardParams();
			} else {
    				ICTouchAPI.debugServices.debug("webapp.communication.getCommunicationBase.reloadContainer - display CONTACT CARD");
				objCard = data.getContactCardParams();
			}

			this.reloadCard(objCard);
		},

		setConferenceCard : function(arrNumber) {
			var data = webapp.communication.data;

			//Get a conference card from an array of numbers
			var objCard = data.buildCurrentConferenceCard(arrNumber);

			this.reloadCard(objCard);
		},

		reloadMenu: function() {
			var data = webapp.communication.data;
			this.menu.reload({
				objTitle: {
					strLabel : data.getCommunicationListTitle()
				},
				objContent: {
					name: "webapp.communication.getCommunicationLog",
					params: {}
				}
			});
		},

		emptyContactCard : function() {			
 			this.reloadCard({strTitle : " "}); // to have an empty title (instead of no tilte)
		},

		contactCardFromDialedNumber: function(number) {
			var data = webapp.communication.data;

			//Get a contact card from the number
			var objContactCard= data.buildOutgoingCallContactCard(number);

			this.reloadCard(objContactCard);
		},

		setContactCardHoldStatus: function(status) {
			var data = webapp.communication.data;

			//Get a contact card from the current selected entry
			var objContactCard= data.getContactCardParams();

			// Set the call state label to hold.
			objContactCard.strCallingStatusLabel = data.lstCallStateLabel[data.STATUS_HOLD];

			this.reloadCard(objContactCard);

		},

		getContainer : function() {
			return this.container;
		},

		//Reload a contact/conference card from a card object
		reloadCard : function(objCard) {
			// Sometimes, when several calls of reloadCard are fired too quickly, a second one was fired before the first one was really finished.
			// So, there is a new boolean to check if the last reload is really finished before beginning a new one.
			// Otherwise, store parameters and really call the reload only when the first is finished.
			if(this.bReloadInProgress){
				this.temporaryObjCard = objCard;
			} else {
				this.bReloadInProgress = true;

				var data = webapp.communication.data;
				//Title
				var objTitle = {
					strLabel: objCard.strTitle || data.getContainerTitle(),
					strSecondaryLabel : " "
				};


				// If we have a strCallDuration, start the timer and stop it otherwise.
				if(objCard.strCallDuration){
					webapp.communication.startTimerOngoing();
					var selectedEntry = this.webapp.data.getSelectedEntry();
					var strTime = this.webapp.data.getStrCallDuration(selectedEntry);
					objTitle.strSecondaryLabel = strTime;
				} else {
					webapp.communication.stopTimerOngoing();
				}

				//Content
				var objContent = {
					name: objCard.strPath || data.getContainerPath(),
					params: {
					objCard: objCard
				 }
				 };

				//Reload the contact Card
				this.container.reload({objTitle: objTitle, objContent: objContent});

				this.bReloadInProgress = false;

				if(this.temporaryObjCard){
					var temporaryObjCard = this.temporaryObjCard;
					delete this.temporaryObjCard;
					this.reloadCard(temporaryObjCard);
				}
			}
		},

		destroy : function(){
			dojo.destroy(this.menu);
			dojo.destroy(this.container);
			webapp.communication.objBaseView.destroy();
			this.inherited(arguments);
		}
	}
	);
