dojo.provide("webapp.communication.dataBase");
dojo.declare("webapp.communication.dataBase",null,{
	// Member data used for object construction
	_arrAllButtons				: [],
	_arrAppBarSkeleton			: [],
	_intCurrentEntry			: 0,
	_intCallIdToSelect			: null,
	_boolNotifsLoaded			: false,
	_intSearchCounter			: 0,
	_intLastSelected			: 0, // Last item in comlog that has been selected
	_intCountCalls				: 0,
	_boolDialKeyEntered			: false,

	_24hformat					: false,

	_undisplayedComm			: 0,
	_objHiddenComlogItems		: {},
	boolInitiateByName          : false,

	_intCountCallback			: 0,
	_intCountMissed				: 0,

	_arrParticipantsByCall		: [],
	_objFirstSelected			: null,
	_strTitle					: "",
	_strContainerPath			: "webapp.communication.getContactCard",

	_boolKeyboardDeployed		: false, // Is the dialpad deployed
	_boolDTMFKeyboardDeployed	: false, // Is the DTMF dialpad deployed

	// Semaphores for loading lists
	_intLoadingCalls			: 0,
	_boolStarted				: false,

	_boolNotifyCallByPopup		: false,
	objNewCall					: null,
	//_boolRecording				: false,

	boolOneUnread				: false,

	objCurrentContact           : null,
	strDefaultPhotoPath			: "",

	objOldAudioEventValue		: null,
	objContactCard				: null,
	objConferenceWidget			: null,
	objConferenceCard			: null,
	objActiveComlog				: null,
	objVideoCard				: null,
	objVideoTray				: null,
	domST						: null,
	clickOnArrow				: null,
	boolShowWebCamIcon			: false,
	boolShowVideo				: true,

	boolAvoidCommSwitch			: false,
	boolWasInHistoryBeforeCall	: false,

	lstComBufferedAction : {},

	// Constant values for the button's id
	BACK				: "BACK_BTN",
	CALL				: "CALL_BTN",
	NEW_CALL			: "NEW_CALL_BTN",
	DELETE_LOG			: "DELETE_LOG_BTN",
	DELETE_ALL_LOG		: "DELETE_ALL_LOG_BTN",
	FILTER				: "FILTER_BTN",
	CANCEL_CALL			: "CANCEL_CALL_BTN",
	CALL_BACK			: "CALL_BACK_BTN",
	VOICEMAIL			: "VOICEMAIL_BTN",
	END_CALL			: "END_CALL_BTN",
	HOLD				: "HOLD_BTN",
	TRANSFER			: "TRANSFER_BTN",
		TRANSFER_TO			: "TRANSFER_TO_BTN",
	DEFLECT_NUMBER		: "DEFLECT_NUMBER_BTN",
	DTMF				: "DTMF_BTN",
	//RECORD				: "RECORD_BTN",
	START_RECORDING		: "START_RECORDING_BTN",
	PAUSE_RECORDING		: "PAUSE_RECORDING_BTN",
	RESUME_RECORDING	: "RESUME_RECORDING_BTN",
	STOP_RECORDING		: "STOP_RECORDING_BTN",
	RETRIEVE			: "RETRIEVE_BTN",
	ANSWER				: "ANSWER_BTN",
	IGNORE				: "IGNORE_BTN",
	DEFLECT				: "DEFLECT_BTN",
	DEFLECT_VM			: "DEFLECT_VM_BTN",
	DEFLECT_MOBILE		: "DEFLECT_MOBILE_BTN",
	REJECT				: "REJECT_BTN",
	CONFERENCE			: "CONFERENCE_BTN",
	ADD_PARTICIPANT		: "ADD_PARTICIPANT_BTN",
	REMOVE_PARTICIPANT	: "REMOVE_PARTICIPANT_BTN",
	MERGE				: "MERGE_BTN",
	LEAVE_CONFERENCE_N	: "LEAVE_CONFERENCE_N_BTN",
	STOP_CONFERENCE_N	: "STOP_CONFERENCE_N_BTN",
	STOP_CONFERENCE_3	: "STOP_CONFERENCE_3_BTN",
	MUTE_PARTICIPANT	: "MUTE_PARTICIPANT_BTN",
	CONTACT_DETAILS		: "CONTACT_DETAILS_BTN",
	TO_DIALER			: "TO_DIALER_BTN",
	CANCEL_INIT_CONF3	: "CANCEL_INIT_CONF3_BTN",
	CANCEL_TRANSFER_TO	: "CANCEL_TRANSFER_TO_BTN",
	CANCEL_ADD_PARTICIPANT: "CANCEL_ADD_PARTICIPANT_BTN",
	CANCEL				: "CANCEL_BTN",
	LISTEN_VM			: "LISTEN_BTN",
	CALLPICKUP			: "CALLPICKUP_BTN",
	DEFLECT_DVA_BTN		: "DEFLECT_DVA_BTN",
	UNREAD				: "UNREAD_BTN",
	SEARCH				: "SEARCH_BTN",
	DOORCAM_OPENDOOR	: "DOORCAM_OPENDOOR_BTN",

	// Constant Values for the ComlogFilters id
	COMLOG_FILTER_ALL				: 0,
	COMLOG_FILTER_UNANS_INC_CALL	: 1,
	COMLOG_FILTER_VM				: 2,
	COMLOG_FILTER_CALLBACK_REQ		: 3,
	COMLOG_FILTER_IM				: 4,

	// Constant Values for the ComlogFilters business id
	COMLOG_FILTER_INC_CALL_BUSINESS_ID			: 0,
	COMLOG_FILTER_OUT_CALL_BUSINESS_ID			: 1,
	COMLOG_FILTER_ANS_INC_CALL_BUSINESS_ID		: 2,
	COMLOG_FILTER_ANS_OUT_CALL_BUSINESS_ID		: 3,
	COMLOG_FILTER_UNANS_INC_CALL_BUSINESS_ID	: 4,
	COMLOG_FILTER_UNANS_OUT_CALL_BUSINESS_ID	: 5,
	COMLOG_FILTER_CALLBACK_REQ_BUSINESS_ID		: 6,
	COMLOG_FILTER_VM_BUSINESS_ID				: 7,
	COMLOG_FILTER_ALL_BUSINESS_ID				: 8,
	COMLOG_FILTER_IM_BUSINESS_ID				: 9,
	COMLOG_FILTER_MAIL_BUSINESS_ID				: 10,
	COMLOG_FILTER_CONFERENCE_BUSINESS_ID		: 11,
	COMLOG_FILTER_MAX							: 11,

	objFiltersList : null,

	STATUS_CALLS								: 0,
	STATUS_ONGOING								: 16,
	STATUS_OUTGOING								: 17,
	STATUS_INCOMING								: 18,
	STATUS_HOLD									: 19,
	STATUS_BEEN_TRANSFERED						: 20,
	STATUS_CONFERENCE							: 21,
	STATUS_CONFERENCE_PARTICIPANT_SELECTED		: 22,
	STATUS_HELD									: 23,
	STATUS_CONFERENCE_HOLD						: 24,
	STATUS_CONFERENCE_INCOMING					: 25,
	STATUS_EMPTY_VM								: 26,
	STATUS_DOUBLE_CALL							: 27,
	STATUS_EMPTY_BAR							: 28,
	STATUS_CONFERENCE_PARTICIPANT_MENULIST_SELECTED		: 29,

	STATUS_EMPTY								: 1,
	STATUS_LOG									: 2,
	STATUS_LOG_CONFERENCE						: 3,
	STATUS_LOG_CONFERENCE_PARTICIPANT_SELECTED	: 4,
	STATUS_TRANSFER_TO							: 5,
	STATUS_TRANSFER								: 6,
	STATUS_ADD_PARTICIPANT						: 7,
	STATUS_MERGE_CALLS							: 8,
	STATUS_INIT_CONF3							: 9,
	STATUS_VM									: 10,
	STATUS_REMOTE_SESSION						: 11,
	STATUS_CONFERENCE_REMOTE_SESSION			: 12,
	STATUS_DEFLECT_TO							: 13,
	STATUS_FILTERED_RING						: 14,
	STATUS_FILTERED_CALL						: 15,

	STATUS_PROGKEYS_CALL						: 200,
	STATUS_PROGKEYS_ROUTING						: 201,
	STATUS_MDR_ROUTING							: 202,
	STATUS_MDR_OVERFLOW							: 203,
	STATUS_MDR_USER								: 204,
	STATUS_SUPERVISED_CALL						: 205,
	STATUS_BASIC_ADD_ROUTING					: 206,
	STATUS_BASIC_IMMEDIATE_ROUTING				: 207,

	//NB_STATUS								: 16,

	// Video status flag from telephony
	TELEPHONY_VIDEO_STATUS_OFF: "VIDEO_OFF",
	TELEPHONY_VIDEO_STATUS_ON: "VIDEO_ON",
	TELEPHONY_VIDEO_STATUS_ONHOLD: "VIDEO_ONHOLD",
	TELEPHONY_VIDEO_STATUS_DOORCAM				: "VIDEO_DOORCAM",
	TELEPHONY_VIDEO_STATUS_FAILED: "VIDEO_FAILED",

	// Video direction from telephony
	TELEPHONY_VIDEO_DIRECTION_UNKNOWN			: "CALL_DIR_UNKNOWN",
	TELEPHONY_VIDEO_DIRECTION_INCOMING			: "CALL_INCOMING",
	TELEPHONY_VIDEO_DIRECTION_OUTGOING			: "CALL_OUTGOING",

	//API Notifications for the refreshComlog
	NOTIF_CALL_STARTED						: "Call started",
	NOTIF_CALL_MODIFIED						: "Call modified",
	NOTIF_CALL_MODIFIED_R100				: "Call modified R100",
	NOTIF_CALL_TRANSFERED_R100				: "Call transfered R100",
	NOTIF_CALL_ENDED						: "Call ended",
	NOTIF_LOADED_PHONECALLS_WORKED			: "loadedPhoneCalls",
	NOTIF_LOADED_PHONECALLS_FAILED			: "loadedPhoneCallsFailed",
	NOTIF_PARTICIPANT_MODIFIED				: "Participant Modified",
	NOTIF_COMMUNICATION_LOADED				: "Communication Loaded",

	CREATED_CONTACT_ACTION : "createdLocalContact",
	MODIFIED_CONTACT_ACTION : "modifiedLocalContact",

	// Constants for comlog management
	COMLOG_CALL								: 1,
	COMLOG_FILTERED							: 2,

	// Constants for comlog action management
	COMLOG_ACTION_ADD						: 0,
	COMLOG_ACTION_REMOVE							: 1,
	COMLOG_ACTION_MODIFY							: 2,

	// LEDS and LEDS STATUS
	LED_MUTE : 0,
	LED_COMM : 5,

	LED_STATUS_OFF		: 0,
	LED_STATUS_ON		: 1,

	//Constants for popup types
	POPUP_INCOMING				: 1,
	POPUP_ONGOING				: 2,
	//Constants for popup call types
	CALL_INCOMING				: 0,
	CALL_OUTGOING				: 1,
	CALL_ONGOING				: 2,
	CALL_SECONDARY				: 3,
	CALL_TO_IGNORE				: 4,

	// call state label list
	lstCallStateLabel	: null,

	lstReason				: {},

	boolAskForReloadContainer: false,
	intAskForReloadContainerTimeoutid: 0,

	boolEnablePhotoInComlog : false,

	boolContactCardNotEmpty	: true,

	boolHotelMode			: false,

	boolHasVideoRights      : true,

	_userRole				: "",

	callIdRetrieving			: null,
	bStackedAction			: false,

	// Static role constants
	MANAGER_ROLE	: "Manager",
	ASSISTANT_ROLE	: "Assistant",
	UNKNOWN_ROLE	: "Unknown",

	updateAppBarSecurityFct		: null,

	// Variables for the dontRefresh mechanism
	telephonyDontRefresh	: false,
	refreshDefenceTimer		: null,

	constructor : function(){
		webapp.communication._intStatus = this.STATUS_EMPTY;

		var func={
			context: webapp.communication,
			func: webapp.communication.buttonCallback
			};

		this._boolStarted = false;

		// Store appli's enum's values.
		this.lstReason.PICKUP = "CALL_REASON_PICKED_UP";
		this.lstReason.NORMAL = "CALL_REASON_NORMAL";

		this.lstCallStateLabel = {};
		this.lstCallStateLabel[this.STATUS_OUTGOING] = "Outgoing call";
		this.lstCallStateLabel[this.STATUS_INCOMING] = "Incoming call";
		this.lstCallStateLabel[this.STATUS_ONGOING] = "Ongoing call";
		this.lstCallStateLabel[this.STATUS_HELD] = "Hold call";
		this.lstCallStateLabel[this.STATUS_HOLD] = "Hold call";
		this.lstCallStateLabel[this.STATUS_REMOTE_SESSION] = "Other device";
		this.lstCallStateLabel[this.STATUS_CONFERENCE_REMOTE_SESSION] = "Other device";
		// Only assistant side for filtered calls.
		this.lstCallStateLabel[this.STATUS_FILTERED_RING] = "Incoming call for";
		this.lstCallStateLabel[this.STATUS_FILTERED_CALL] = "Received call for";
		this.lstCallStateLabel[this.STATUS_SUPERVISED_CALL] = "Intercepted call for";

		this._arrAllButtons[this.NEW_CALL] = {strButtonName: this.NEW_CALL, strButtonLabel:_('New call', 'webapp.communication'), strButtonIcon: 'communication-new-call', callback: func, arrCapabilities: [{module : "Telephony", capability :"makeCall"}]};
		this._arrAllButtons[this.CALL] = {strButtonName: this.CALL, strButtonLabel:_('Call', "webapp.communication"), strButtonIcon: 'communication-call', callback: func};
		this._arrAllButtons[this.CANCEL_CALL] = {strButtonName: this.CANCEL_CALL, strButtonLabel:_('Cancel call', "webapp.communication"), strButtonIcon: 'communication-cancel-call', callback: func};
		this._arrAllButtons[this.VOICEMAIL] = {strButtonName: this.VOICEMAIL, strButtonLabel:_('Voicemail', "webapp.communication"), strButtonIcon: 'communication-voice-mail', callback: func, arrCapabilities: [{module : "Telephony", capability :"overflowToVM", instance: -1}]};
		this._arrAllButtons[this.END_CALL] = {strButtonName: this.END_CALL, strButtonLabel:_('End call', "webapp.communication"), strButtonIcon: 'communication-cancel-call', callback: func};
		this._arrAllButtons[this.HOLD] = {strButtonName: this.HOLD, strButtonLabel:_('Hold call', "webapp.communication"), strButtonIcon: 'communication-put-on-hold', callback: func, arrCapabilities: [{module : "Telephony", capability :"hold", instance: -1}]};
		this._arrAllButtons[this.TRANSFER] = {strButtonName: this.TRANSFER, strButtonLabel:_('Transfer', "webapp.communication"), strButtonIcon: 'communication-transfer-to', callback: func, arrCapabilities: [{module : "Telephony", capability :"consultTransfer"}]};
		this._arrAllButtons[this.TRANSFER_TO] = {strButtonName: this.TRANSFER_TO, strButtonLabel:_('Transfer to', "webapp.communication"), strButtonIcon: 'communication-deflect-to-default', callback: func, arrCapabilities: [{module : "Telephony", capability :"blindTransfer"}]};
		this._arrAllButtons[this.DEFLECT_NUMBER] = {strButtonName: this.DEFLECT_NUMBER, strButtonLabel:_('Deflect', "webapp.communication"), strButtonIcon: 'communication-transfer-to', callback: func, arrCapabilities: [{module : "Telephony", capability :"deflectToNumber", instance: -1}]};
		this._arrAllButtons[this.DTMF] = {strButtonName: this.DTMF, strButtonLabel:_('Keypad', 'webapp.communication'), strButtonIcon: 'communication-dtmf-pad2', callback: func};
		this._arrAllButtons[this.START_RECORDING] = {strButtonName: this.START_RECORDING, strButtonLabel:_('Record call', "webapp.communication"), strButtonIcon: 'communication-record-call', callback: func, arrCapabilities: [{module : "Telephony", capability :"startCommunicationRecording", instance: -1}]};
		this._arrAllButtons[this.PAUSE_RECORDING] = {strButtonName: this.PAUSE_RECORDING, strButtonLabel:_('Pause recording', "webapp.communication"), strButtonIcon: 'communication-record-call', callback: func, arrCapabilities: [{module : "Telephony", capability :"pauseRecording", instance: -1}]};
		this._arrAllButtons[this.RESUME_RECORDING] = {strButtonName: this.RESUME_RECORDING, strButtonLabel:_('Resume recording', "webapp.communication"), strButtonIcon: 'communication-record-call', callback: func, arrCapabilities: [{module : "Telephony", capability :"resumeRecording", instance: -1}]};
		this._arrAllButtons[this.STOP_RECORDING] = {strButtonName: this.STOP_RECORDING, strButtonLabel:_('Stop recording', "webapp.communication"), strButtonIcon: 'communication-record-call', callback: func, arrCapabilities: [{module : "Telephony", capability :"stopRecording", instance: -1}]};
		this._arrAllButtons[this.RETRIEVE] = {strButtonName: this.RETRIEVE, strButtonLabel:_('Retrieve call', "webapp.communication"), strButtonIcon: 'communication-put-on-hold-off', callback: func};
		this._arrAllButtons[this.ANSWER] = {strButtonName: this.ANSWER, strButtonLabel:_('Answer', "webapp.communication"), strButtonIcon: 'communication-call', callback: func};
		this._arrAllButtons[this.IGNORE] = {strButtonName: this.IGNORE, strButtonLabel:_('Ignore call', "webapp.communication"), strButtonIcon: 'communication-stop-ringing', callback: func};

		this._arrAllButtons[this.DEFLECT] = {strButtonName: this.DEFLECT, strButtonLabel:_('Default deflect', "webapp.communication"), strButtonIcon: 'communication-deflect-to-default', callback: func, arrCapabilities: [{module : "Telephony", capability :"deflectToDefault", instance: -1}]};
		this._arrAllButtons[this.DEFLECT_VM] = {strButtonName: this.DEFLECT_VM, strButtonLabel:_('Deflect to voicemail', "webapp.communication"), strButtonIcon: 'communication-deflect-to-voice-mail', callback: func, arrCapabilities: [{module : "Telephony", capability :"deflectToVM", instance: -1}]};
		this._arrAllButtons[this.DEFLECT_DVA_BTN] = {strButtonName: this.DEFLECT_DVA_BTN, strButtonLabel:_('Deflect DVA', "webapp.communication"), strButtonIcon: 'communication-deflect-dva', callback: func, arrCapabilities: [{module : "Telephony", capability :"deflectToDVA", instance: -1}]};
		this._arrAllButtons[this.DEFLECT_MOBILE] = {strButtonName: this.DEFLECT_MOBILE, strButtonLabel:_('Deflect other', "webapp.communication"), strButtonIcon: 'communication-deflect-to-mobile', callback: func, arrCapabilities: [{module : "Telephony", capability :"deflectToMobile", instance: -1}]};
		this._arrAllButtons[this.REJECT] = {strButtonName: this.REJECT, strButtonLabel:_('Reject call', "webapp.communication"), strButtonIcon: 'communication-cancel-call', callback: func, arrCapabilities: [{module : "Telephony", capability :"reject", instance: -1}]};
		this._arrAllButtons[this.CANCEL] = {strButtonName: this.CANCEL, strButtonLabel:_('Cancel', "ICTouchAPI"), strButtonIcon: 'generic-cancel', callback: func};
		this._arrAllButtons[this.SEARCH] = {strButtonName: this.SEARCH, strButtonLabel:_('Search', "ICTouchAPI"), strButtonIcon: 'generic-search-by-name', callback: func};
		//Conference Buttons for Conf-3
		this._arrAllButtons[this.CONFERENCE] = {strButtonName: this.CONFERENCE, strButtonLabel:_('Conference', "webapp.communication"), strButtonIcon: 'communication-conference', callback: func, arrCapabilities: [{module : "Telephony", capability :"conference"}]};
		this._arrAllButtons[this.STOP_CONFERENCE_3] = {strButtonName: this.STOP_CONFERENCE_3, strButtonLabel:_('Stop conference', "webapp.communication"), strButtonIcon: 'communication-conference-off', callback: func, arrCapabilities: [{module : "Telephony", capability :"cancelConference"}]};

		//Conference Buttons for Conf-n
		this._arrAllButtons[this.ADD_PARTICIPANT] = {strButtonName: this.ADD_PARTICIPANT, strButtonLabel:_('Add', 'ICTouchAPI'), strButtonIcon: 'communication-conference-add-participant', callback: func, arrCapabilities: [{module : "Telephony", capability :"addParticipant", instance: -1}]};
		this._arrAllButtons[this.MERGE] = {strButtonName: this.MERGE, strButtonLabel:_('Conference', "webapp.communication"), strButtonIcon: 'communication-conference', callback: func, arrCapabilities: [{module : "Telephony", capability :"mergePhoneCalls", instance: -1}]};
		this._arrAllButtons[this.LEAVE_CONFERENCE_N] = {strButtonName: this.LEAVE_CONFERENCE_N, strButtonLabel:_('Leave conference', "webapp.communication"), strButtonIcon: 'communication-conference-delete-participant', callback: func, arrCapabilities: [{module : "Telephony", capability :"leaveConference", instance: -1}]};
		this._arrAllButtons[this.REMOVE_PARTICIPANT] = {strButtonName: this.REMOVE_PARTICIPANT, strButtonLabel:_('Exit', 'ICTouchAPI'), strButtonIcon: 'communication-conference-remove-participant', callback: func, arrCapabilities: [{module : "Telephony", capability :"dropParticipant", instance: -1}]};
        this._arrAllButtons[this.STOP_CONFERENCE_N] = {strButtonName: this.STOP_CONFERENCE_N, strButtonLabel:_('Stop conference', "webapp.communication"), strButtonIcon: 'communication-conference-off', callback: func, arrCapabilities: [{module : "Telephony", capability :"terminateCall", instance: -1}]};
		this._arrAllButtons[this.MUTE_PARTICIPANT] = {strButtonName: this.MUTE_PARTICIPANT, strButtonLabel:_('Mute participant', 'webapp.communication'), strButtonIcon: 'communication-mute', callback: func, arrCapabilities: [{module : "Telephony", capability :"muteParticipant", instance: -1}]};

		//Doorcam Button
		this._arrAllButtons[this.DOORCAM_OPENDOOR] = {strButtonName: this.DOORCAM_OPENDOOR, strButtonLabel:_('Open door', 'webapp.communication'), strButtonIcon: 'communication-doorcam', callback: func, arrCapabilities: [{module : "Telephony", capability :"openDoor", instance: -1}]};

		//Create the skeleton for each appbar
		//Simple Strings are ID from other webapp buttons
		this._arrAppBarSkeleton[this.STATUS_EMPTY] = ["MAGNIFY","homepageBtnHelp"];
		this._arrAppBarSkeleton[this.STATUS_REMOTE_SESSION] = ["GETCALL_BTN","END_REMOTE_CALL_BTN","INTRUDE_BTN","PICK_UP_BTN","MAGNIFY","homepageBtnHelp"];
 		this._arrAppBarSkeleton[this.STATUS_OUTGOING] = [this.CANCEL_CALL,this.DTMF,this.TRANSFER,this.VOICEMAIL,"MAGNIFY","homepageBtnHelp"];
		this._arrAppBarSkeleton[this.STATUS_INCOMING] = [this.ANSWER,this.IGNORE,this.DEFLECT_VM,this.DEFLECT_NUMBER,this.DEFLECT_DVA_BTN,"ANSWER_BY_IM","MAGNIFY","homepageBtnHelp"];
		this._arrAppBarSkeleton[this.STATUS_HOLD] = [this.RETRIEVE,this.NEW_CALL, "ADD_CONTACT","ANSWER_BY_IM","MAGNIFY","homepageBtnHelp"];
		this._arrAppBarSkeleton[this.STATUS_HELD] = [this.END_CALL,"ADD_CONTACT","MAGNIFY","homepageBtnHelp"];
		this._arrAppBarSkeleton[this.STATUS_DOUBLE_CALL] = [this.END_CALL,this.DTMF,"CALL_MANAGER_BTN","CALL_ASSISTANT_BTN",this.TRANSFER,this.CONFERENCE,this.MERGE,this.HOLD,this.TRANSFER_TO,this.DOORCAM_OPENDOOR,this.NEW_CALL,"OTHER_DEVICES_BTN","TRANSFER_TO_MANAGER_BTN","TRANSFER_TO_ASSISTANT_BTN",this.ADD_PARTICIPANT,this.START_RECORDING,this.PAUSE_RECORDING,this.RESUME_RECORDING,this.STOP_RECORDING,"MAGNIFY","homepageBtnHelp"];
		//No magnify - help for this appbar
		this._arrAppBarSkeleton[this.STATUS_TRANSFER] = [this.CANCEL,"MAGNIFY","homepageBtnHelp"];
		this._arrAppBarSkeleton[this.STATUS_CONFERENCE] = [this.LEAVE_CONFERENCE_N,this.STOP_CONFERENCE_3,this.STOP_CONFERENCE_N,this.ADD_PARTICIPANT,this.NEW_CALL,this.START_RECORDING,this.PAUSE_RECORDING,this.RESUME_RECORDING,this.STOP_RECORDING,"MAGNIFY","homepageBtnHelp"];
		this._arrAppBarSkeleton[this.STATUS_CONFERENCE_PARTICIPANT_SELECTED] = [this.LEAVE_CONFERENCE_N,this.STOP_CONFERENCE_3,this.STOP_CONFERENCE_N,this.ADD_PARTICIPANT,this.REMOVE_PARTICIPANT,this.NEW_CALL,this.START_RECORDING,this.PAUSE_RECORDING,this.RESUME_RECORDING,this.STOP_RECORDING,"MAGNIFY","homepageBtnHelp"];
		this._arrAppBarSkeleton[this.STATUS_CONFERENCE_PARTICIPANT_MENULIST_SELECTED] = [this.REMOVE_PARTICIPANT,"MAGNIFY","homepageBtnHelp"];
		this._arrAppBarSkeleton[this.STATUS_CALLS] = [this.END_CALL,"CALL_MANAGER_BTN","CALL_ASSISTANT_BTN",this.DTMF,this.NEW_CALL,this.ADD_PARTICIPANT,this.HOLD,this.TRANSFER_TO,this.DOORCAM_OPENDOOR,"OTHER_DEVICES_BTN","TRANSFER_TO_MANAGER_BTN","TRANSFER_TO_ASSISTANT_BTN",this.START_RECORDING,this.PAUSE_RECORDING,this.RESUME_RECORDING,this.STOP_RECORDING,"ANSWER_BY_IM","MAGNIFY","homepageBtnHelp"];
		this._arrAppBarSkeleton[this.STATUS_CONFERENCE_HOLD] = [this.RETRIEVE,this.NEW_CALL,"MAGNIFY","homepageBtnHelp"];
		this._arrAppBarSkeleton[this.STATUS_CONFERENCE_INCOMING] = [this.ANSWER,this.IGNORE,this.DEFLECT_NUMBER,"MAGNIFY","homepageBtnHelp"];
		this._arrAppBarSkeleton[this.STATUS_EMPTY_BAR]= [];
		this._arrAppBarSkeleton[this.STATUS_INITIAL_CALLEE]= [this.CALL,"MAGNIFY","homepageBtnHelp"];

		var backFunc={
			context: webapp.communication,
			func: webapp.communication.buttonCallback,
			param: this.BACK
		};
		for(var i in this._arrAppBarSkeleton){
			var appBar = ICTouchAPI.AppBarServices.createAppBar("communication", "comstatus" + i , this._arrAppBarSkeleton[i]);
			// Create the static back button
			ICTouchAPI.AppBarServices.addExitButton("communication", "comstatus" + i, true, backFunc);
			for(var j in this._arrAppBarSkeleton[i]){
				var currentBtn = this._arrAppBarSkeleton[i][j];
				//Button from communication webapp
				if(this._arrAllButtons[currentBtn]){
					var objButton = new UIElements.AppButton.AppButtonControl(this._arrAllButtons[currentBtn]);
					appBar.addAppButton(objButton,false);
				//Button from other webapps
				}else{
					appBar.addAppButton(currentBtn,false);
				}
			}
			appBar.buildDom();
		}

		this.strDefaultPhotoPath = "http://localhost/webapp/userinfo/themes/Default/images/default-user-photo.png";
	},

	getNumAppBarFromStatus : function(numStatus) {
		var statusReturn = null;
		for(var i in this._arrAppBarSkeleton){
			if(i==numStatus){
				return i;
			}
		}
		if(numStatus == this.STATUS_FILTERED_RING || numStatus == this.STATUS_FILTERED_CALL || numStatus == this.STATUS_CONFERENCE_REMOTE_SESSION){
			statusReturn = this.STATUS_REMOTE_SESSION;
		} else if (numStatus == this.STATUS_TRANSFER_TO || numStatus == this.STATUS_ADD_PARTICIPANT || numStatus == this.STATUS_MERGE_CALLS || numStatus == this.STATUS_INIT_CONF3 || numStatus == this.STATUS_DEFLECT_TO){
			statusReturn = this.STATUS_TRANSFER_TO;
		} else if (numStatus == this.STATUS_ONGOING || numStatus == this.STATUS_BEEN_TRANSFERED){
			statusReturn = this.STATUS_CALLS;
		} else if (numStatus == this.STATUS_PROGKEYS_CALL || numStatus == this.STATUS_PROGKEYS_ROUTING || numStatus == this.STATUS_MDR_ROUTING || numStatus == this.STATUS_MDR_OVERFLOW || numStatus == this.STATUS_MDR_USER || numStatus == this.STATUS_BASIC_ADD_ROUTING || numStatus == this.STATUS_BASIC_IMMEDIATE_ROUTING){
			statusReturn = this.STATUS_EMPTY;
		}

		// Check if we must switch to double call state (if we have at least another call in hold state)
		if(statusReturn == this.STATUS_CALLS){
			var arrCalls = this.getPhoneCalls();
			if(arrCalls && arrCalls.length > 1){
				for(var j = 0 ; j < arrCalls.length ; j++){
					if(arrCalls[j].intStatus == this.STATUS_HELD || arrCalls[j].intStatus == this.STATUS_HOLD || arrCalls[j].intStatus == this.STATUS_CONFERENCE_HOLD){
						statusReturn = this.STATUS_DOUBLE_CALL;
						break;
					}
				}
			}
		}

		numStatus=null;
		return statusReturn;
	},

	setTelephonyDontRefresh : function(telephonyDontRefresh) {
		this.clearRefreshDefenceTimer();
		this.telephonyDontRefresh = telephonyDontRefresh;
		if(telephonyDontRefresh){
			this.startRefreshDefenceTimer();
		}
	},

	getTelephonyDontRefresh : function() {
		return this.telephonyDontRefresh;
	},

	startRefreshDefenceTimer : function() {
		this.refreshDefenceTimer = setTimeout(function(){
			webapp.communication.data.setTelephonyDontRefresh(false);
			webapp.communication.doStackedActions();
		}, 10000);
	},

	clearRefreshDefenceTimer : function() {
		if(this.refreshDefenceTimer){
			clearTimeout(this.refreshDefenceTimer);
		}
	},

	// Note Joel: now comlog and phone calls are loaded asynchronously to speed up things
	loadList : function(boolLoadPhoneCalls, boolLoadCallLogs, boolLoadVoicemailLog) {
		ICTouchAPI.debugServices.info("webapp.communication.dataBase.loadList");
		ICTouchAPI.debugServices.debug("webapp.communication.dataBase.loadList $ input function params | boolLoadPhoneCalls: " + boolLoadPhoneCalls + " | boolLoadCallLogs: " + boolLoadCallLogs + " | boolLoadVoicemailLog: " + boolLoadVoicemailLog);
		// List has changed so don't select the old entry
		this._intLastSelected = 0;

			this._intLoadingCalls++;
			// Load phone calls
			// Call business function
			ICTouchAPI.APIServices.Telephony.getPhoneCalls({
				context:this,
				callback:this.loadedPhoneCalls,
				errorCallback:this.loadedPhoneCallsFailed
				});
	},

	loadedPhoneCalls : function(_arr) {
		this._intLoadingCalls--;
		if (this._intLoadingCalls !== 0) {
			ICTouchAPI.debugServices.debug("webapp.communication.dataBase - loadedPhoneCalls $ Rejecting phone calls results, more recent results will arrive.");
			_arr = null;
			return;
		}
		var arrPhoneCalls = [];
		this.emptyItemsInComlogs(this.COMLOG_LIST_CALL);
		ICTouchAPI.debugServices.debug("webapp.communication.dataBase - loadedPhoneCalls $ Start loadedPhoneCalls");
		if (_arr !== undefined) {
			for (var i in _arr) {
				var callObject = _arr[i];

				var objCall = this.buildPhoneCallItem(callObject);
				arrPhoneCalls.push(objCall);
			}
		}
		ICTouchAPI.debugServices.debug("webapp.communication.dataBase - loadedPhoneCalls $ End loadedPhoneCalls");
		this.unshiftItemsInComlogs(arrPhoneCalls);

		// If comlog is not being loaded, finalize loading: select the first entry of call if it is the list currently displayed
		if (this._intLoadingLogs == 0 && this.getDisplayedComlogList() == this.COMLOG_LIST_CALL){
			this.refreshDetails();
		}
		_arr=null;
	},

	loadedPhoneCallsFailed : function() {
		ICTouchAPI.debugServices.debug("webapp.communication.dataBase - loadedPhoneCallsFailed $ loadedPhoneCalls failed");
		this._intLoadingCalls--;
		// If comlog is not being loaded, finalize loading: select the first entry of call if it is the list currently displayed
		if (this._intLoadingLogs === 0 && this.getDisplayedComlogList() == this.COMLOG_LIST_CALL){
			this.refreshDetails();
		}
	},

	refreshDetails : function() {
		if (this._intLastSelected < 0) {
			this.loadDetails(undefined);   			 // show empty contact card
		} else {
			this.loadDetails(this._intLastSelected);			// show current contact card
		}
	},

	reloadCalls : function() {
		this.loadList();
	},

	/**
	 * refresh the specified entry in 1/3 and 2/3
	 * @param {int} callEntryId : id of the entry to refresh
	 */
	refreshEntryById : function(callEntryId){
		var logObject = this.findItemById(callEntryId);
			if(logObject && logObject.objCallData){
				if(logObject.isFiltered){
					// Notification
					this.modifyInLog(logObject.objCallData, this.COMLOG_FILTERED, false);
				} else {
					// Call
					this.modifyInLog(logObject.objCallData, this.COMLOG_CALL, false);
				}
			}
		callEntryId=null;
	},

	/**
	 * refresh the specified entry in 1/3
	 * @param {object} logObject : entry to refresh
	 */
	refreshLeftEntry : function(logObject) {
		var item = null;
		var intLogType = null;
		if(logObject && logObject.objCallData){
			if(logObject.isFiltered){
				// Notification
				intLogType = this.COMLOG_FILTERED;
			} else {
				// Call
				intLogType = this.COMLOG_CALL;
			}
		}
		item = this.extractItemFromComlogObject(logObject.objCallData, intLogType, this.COMLOG_ACTION_MODIFY);
		if(item){
			this.updateItemInComlogs(item);
		}
		logObject = null;
	},

	getAllAppButtons : function() {
		return this._arrAllButtons;
	},

	/*
	 * Function getVideoDetails configure the videoCard for the 2/3 container
	 */
	getVideoDetails : function(objContact){
		ICTouchAPI.debugServices.debug('communication.dataBase.getVideoDetails - start');
		var entry = this.getSelectedEntry();
		var callId = entry.intIndex;
		ICTouchAPI.debugServices.debug('communication.dataBase.getVideoDetails - callID='+callId);
		this._strContainerPath = "webapp.communication.getVideoCard";
		//this._strTitle = _("Visio", "webapp.communication");
                var arrParticipants = this.getCallParticipants(this.getSelectedEntryId());
			if (arrParticipants && arrParticipants.length > 1){
				this._strTitle = _("Conference", "webapp.communication");
			}
			else {
				this._strTitle = ICTouchAPI.tools.getContactDisplayName(objContact);//objContact.firstName + " " + objContact.name;
			}
		this.askForReloadContainer(true);
		if (webapp.communication.mainWidget){
			webapp.communication.mainWidget.reloadContainer();
		}
	},

	/*
	 * Function loadDetails loads anything that should be displayed on 2/3 container
	 * according to what is selected on the 1/3 list.
	 */
	loadDetails : function(id, item) {
		ICTouchAPI.debugServices.info("webapp.communication.dataBase - loadDetails");
		var objContact;
		var boolNoReload = false;
		
		if(!item){
			// If id is undefined (for instance, when there's no communication at all)
			//  Show an empty contact card
			if (id === undefined) {
				ICTouchAPI.debugServices.debug("webapp.communication.dataBase - loadList $ item is undefined and id is undefined, show an empty contact card");
					webapp.communication.setStatus(this.STATUS_EMPTY);
					this._strTitle = _("No communications","webapp.communication");
				this.objCurrentContact = null;
				this._strContainerPath = "webapp.communication.getContactCard";

				//this.askForReloadContainer();
				if(webapp.communication.mainWidget) {
					webapp.communication.mainWidget.reloadCard({strTitle: this._strTitle});
					webapp.communication.updateAppBar();
				}
				else {
					this.askForReloadContainer();
				}
				id = null;
				item = null;
				return; // exit
			}
			item = this.findItemById(id);
			if(item === undefined){
				id = null;
				item = null;
				return; // exit
			}
		} else {
			boolNoReload = true;
			id = item.intIndex;
		}

		// save the item Id
		ICTouchAPI.debugServices.debug("webapp.communication.dataBase.loadDetails $ id used is: " + id);
		this.setCurrentEntry(id);
		webapp.communication._intStatus = item.intStatus;

		// if the video is displayed don't update or replace the contact card
		ICTouchAPI.debugServices.debug("webapp.communication.dataBase.loadDetails - isHeld: " + (item.objCallData && item.objCallData.isHeld));
		ICTouchAPI.debugServices.debug("webapp.communication.dataBase.loadDetails - isOnHold: " + (item.objCallData && item.objCallData.isOnHold));

		if (item.objCallData && item.objCallData.videoStatus &&
		    (item.objCallData.videoStatus === this.TELEPHONY_VIDEO_STATUS_ON || item.objCallData.videoStatus === this.TELEPHONY_VIDEO_STATUS_DOORCAM) &&
		    (!item.objCallData.isHeld && !item.objCallData.isOnHold) && this.boolShowVideo){
			ICTouchAPI.debugServices.debug('webapp.communication.dataBase.loadDetails - video is ON');
			// check if videoCard is already displayed or not
			if (!this.objVideoCard) {
				ICTouchAPI.debugServices.debug('webapp.communication.dataBase.loadDetails - call getVideoDetails()');
				objContact = this.searchContactFromLog(item);
				this.getVideoDetails(objContact);
			}
			else {
				// Update the appBar if we don't refresh the contact
				webapp.communication.updateAppBar();
			}
			ICTouchAPI.debugServices.debug('webapp.communication.dataBase.loadDetails - no objVideoCard');			

		} else {
			if (item.objCallData && item.objCallData.videoStatus &&
			   (item.objCallData.videoStatus === this.TELEPHONY_VIDEO_STATUS_ON) &&
			   (item.objCallData.isOnHold)) {
				ICTouchAPI.debugServices.debug('webapp.communication.dataBase.loadDetails - video is ONHOLD');

	/*		    var appBar = ICTouchAPI.AppBarServices._getAppBarWidget("communication", "comstatus" + data.STATUS_HOLD);
				var appButton = appBar.getButton(data.RETRIEVE);
				if (appButton) {
				appButton.show();
				}
				//Display the hold contact card
				webapp.communication.mainWidget.setContactCardHoldStatus();
	*/
			} else {
				ICTouchAPI.debugServices.debug('webapp.communication.dataBase.loadDetails - video is HIDDEN');
			}

			if (item.intStatus === this.STATUS_CONFERENCE
			||  item.intStatus === this.STATUS_CONFERENCE_HOLD
			||  item.intStatus === this.STATUS_CONFERENCE_INCOMING
			||  item.intStatus === this.STATUS_CONFERENCE_REMOTE_SESSION) {
				this._intCallIdToSelect = item.intIndex;
				this._intLogIdToSelect = null;
				this._strContainerPath = "webapp.communication.getConference";
				this._strTitle = _("Conference", "webapp.communication");
				this.loadedConferenceDetails(item, boolNoReload);
			} else {
				this._intCallIdToSelect = item.intIndex;
				this._intLogIdToSelect = null;
				this._strContainerPath = "webapp.communication.getContactCard";
				this._strTitle = "";

				if(item.objCallData && item.objCallData.isFiltered){// Notification (ManagerAssistant)
					var arrParticipants = this.getCallParticipants(item.intIndex);
					if(arrParticipants === undefined || arrParticipants.length === 0){
						objContact = null;
					} else {
						objContact = arrParticipants[0].objContact;
					}
				} else { // Call
					objContact = this.searchContactFromLog(item);
				}

				this.loadedDetails(objContact, item, boolNoReload);
				if (item.objCallData && !item.objCallData.isLocal && webapp.session) {
					webapp.session.showRemoteSession();
				}
			}
		}

		if(!this.isSecondaryItem(item) && this.isCurrentNotifCall(item)){
			webapp.communication.ongoingCallNotificationsUpdate(this.findItemById(item.objCallData.callId,this.COMLOG_LIST_CALL));
		}
		id=null;
		item=null;
	},

	isCurrentNotifCall: function(item){
		if(item && item.objCallData && (item.objCallData.isOnHold || item.objCallData.isHeld)){
			var calls = this.getActivePhoneCalls();
			if(calls){
				for(var i=0; i<calls.length; i++) {
					if(!this.isSecondaryItem(calls[i]) && calls[i].objCallData && !calls[i].objCallData.isOnHold && !calls[i].objCallData.isHeld){
						return false;
					}
				}
				return true;
			}
		}
		else if(item) {
			return true;
		}
		return false;
	},

	searchContactFromLog: function(item, id){
		ICTouchAPI.debugServices.info("webapp.communication.dataBase - searchContactFromLog");
		var phoneNumber, notCanonicalNumber, label;
		// Get call Participants
		var arrParticipants = [];
		if(item.objParticipant){
			arrParticipants[0] = item.objParticipant;
		} else {
			arrParticipants = this.getCallParticipants(item.intIndex);
		}
		// To be sure we have a real Id for the listContactSummary
		if(id === undefined || id === null){
			id = 0;
		}
		// Get the correct phoneNumber and displayName to use.
		if(arrParticipants.length == 1){
			// Existing participant
			phoneNumber = arrParticipants[0].phoneNumber;
			label = arrParticipants[0].displayName;
			ICTouchAPI.debugServices.debug("webapp.communication.dataBase - searchContactFromLog / existing participant : phoneNumber = " + phoneNumber + ", label (displayName) = " + label);
		} else if(item.objCallData) {
			// Phone call
			if (item.objCallData.phoneNumberCan) {
				phoneNumber = item.objCallData.phoneNumberCan;
				notCanonicalNumber = item.objCallData.phoneNumber;
				ICTouchAPI.debugServices.debug("webapp.communication.dataBase - searchContactFromLog / phoneNumberCan available in callObject, use it: phoneNumberCan = " + phoneNumber);
			}
			else {
				phoneNumber = item.objCallData.phoneNumber;
				ICTouchAPI.debugServices.debug("webapp.communication.dataBase - searchContactFromLog / no phoneNumberCan available in callObject, use phoneNumber: " + phoneNumber);
			}
			label = item.objCallData.displayName;
			ICTouchAPI.debugServices.debug("webapp.communication.dataBase - searchContactFromLog / use phoneCall data : phoneNumber = " + phoneNumber + ", label (displayName) = " + label);
		} else if(item.number) {
			// When we start a call with just number
			phoneNumber = item.number;
			ICTouchAPI.debugServices.debug("webapp.communication.dataBase - searchContactFromLog / only phoneNumber provided (preload) = " + phoneNumber);
		}
		// Search in dataStore.
		ICTouchAPI.debugServices.debug("webapp.communication.dataBase - searchContactFromLog / search in local contacts ussing Can fields");
		var objContact = (phoneNumber)?ICTouchAPI.dataStoreServices.getStore('contacts').find(["officePhoneCan", "personalHomeCan", "personalMobileCan", "personalFax"],phoneNumber)[0]:undefined;
		if (objContact) {
			ICTouchAPI.debugServices.debug("webapp.communication.dataBase - searchContactFromLog / local contact found"/* : " + ICTouchAPI.tools.getContactDisplayName(objContact)*/);
		}
		if (!objContact) {
			ICTouchAPI.debugServices.debug("webapp.communication.dataBase - searchContactFromLog / no local contact found");
			// If not in dataStore
			if(arrParticipants.length == 1){
				// if participant, use it
				objContact = arrParticipants[0].objContact;
				ICTouchAPI.debugServices.debug("webapp.communication.dataBase - searchContactFromLog / there is a participant, use its objContact"/*: " + ICTouchAPI.tools.getContactDisplayName(objContact)*/);
			} else {
				// If there is a participant matching the number in any call (catch the case when we search from just a number or from a conf)
				var arrAllParticipants = this.getAllParticipants();
				if(arrAllParticipants.length > 0){
					for(var i = 0; i < arrAllParticipants.length ; i++){
						if(phoneNumber == arrAllParticipants[i].phoneNumber){
							objContact = arrAllParticipants[i].objContact;
							ICTouchAPI.debugServices.debug("webapp.communication.dataBase - searchContactFromLog / there is a participant matching the phoneNumber is another call, use it"/*: " + ICTouchAPI.tools.getContactDisplayName(objContact)*/);
							break;
						}
					}
				}
				if(!objContact || (objContact && objContact.contactFromNumber)){
					// If the contact was not found, use the phonecall info
					if (notCanonicalNumber) {
						objContact = this.createContactFromNumber(label, notCanonicalNumber);
						objContact.phoneNumberCan = phoneNumber;
					}
					else {
						objContact = this.createContactFromNumber(label, phoneNumber);
					}
					ICTouchAPI.debugServices.debug("webapp.communication.dataBase - searchContactFromLog / there is no participant and no local contact, use phoneCall/log info to create fake contact"/*: " + dojo.toJson(objContact)*/);
				}
			}
		}
		item=null;
		ICTouchAPI.debugServices.info("webapp.communication.dataBase - searchContactFromLog $ return objContact: " + dojo.toJson(objContact));
		return objContact;
	},

	loadedDetails: function(objContact, item, boolNoReload) {
		ICTouchAPI.debugServices.info("webapp.communication.dataBase - loadedDetails");
		this.setCurrentContact(objContact, item);
		if(item!=null && item.strPrimaryContent!=null) {
			this._strTitle = item.strPrimaryContent;
		}
		else {
			var arrParticipants = this.getCallParticipants(this.getSelectedEntryId());
			if (arrParticipants && arrParticipants[0] && arrParticipants[0].displayName && arrParticipants[0].displayName !== ""){
				this._strTitle = arrParticipants[0].displayName;
			}
			else {
				this._strTitle = ICTouchAPI.tools.getContactDisplayName(objContact);//objContact.firstName + " " + objContact.name;
			}
		}

		var strTitleState = this.getTitleStateByStatus();

		if(strTitleState){
			this._strTitle = [strTitleState, "-", this._strTitle];
		}

		this.askForReloadContainer(boolNoReload);
		objContact=null;
		item=null;
		boolNoReload=null;
	},

	/**
	 * Return the label to put in the title of the 2/3 for the state (conference participant, initial callee...)
	 */
	getTitleStateByStatus : function() {
		var strTitleState = "";
		var status = webapp.communication.getStatus();
		// Set strTitleState according to the status.

		return strTitleState;
		/*return this.lstCallStateLabel[status] || "";*/
	},

	// Set the contact as the Current contact or create it from item it not defined. intIndex is the position of the contact if there is more than 1 contact (for conferences)
	setCurrentContact : function(objContact, item, intIndex) {
		ICTouchAPI.debugServices.info("webapp.communication.dataBase - setCurrentContact");
		if(objContact == undefined){
			objContact = this.searchContactFromLog(item, intIndex);
		}
		this.objCurrentContact = objContact;
		objContact=null;
		item=null;
	},

	loadedConferenceDetails: function(item, boolNoReload) {
		// First refresh widgets with the information we have right now
		this.askForReloadContainer(boolNoReload);
		item=null;
		boolNoReload=null;
	},

	createContactFromNumber: function(label, phoneNumber) {
		ICTouchAPI.debugServices.info("webapp.communication.dataBase - createContactFromNumber");
		if (!label || label === ""){
			label = phoneNumber;
			ICTouchAPI.debugServices.debug("webapp.communication.dataBase - createContactFromNumber / no label defined, use phoneNumber for label: " + label);
		}
		var objContact;
		if (typeof label === "object" && label[0] !== undefined && label[1] !== undefined) { // label can be an array with [LastName, FirstName]
			 objContact = {
				contactId: -1,
				name: label[0],
				firstName: label[1],
				officePhone: phoneNumber,
				officePhoneCan: phoneNumber,
				contactFromNumber: true
			};
		}
		else {
			objContact = {
				contactId: -1,
				name: label,
				firstName: "",
				officePhone: phoneNumber,
				officePhoneCan: phoneNumber,
				contactFromNumber: true
			};
		}
		label=null;
		phoneNumber=null;
		ICTouchAPI.debugServices.debug("webapp.communication.dataBase - createContactFromNumber done $ return objContact: " + dojo.toJson(objContact));
		return objContact;
	},

	extractPhoneNumber : function(objContact) {
		var numbers = [];
		if (objContact.officePhone) {
			numbers.push(objContact.officePhone);
		}
		if (objContact.personalHome) {
			numbers.push(objContact.personalHome);
		}
		if (objContact.personalMobile) {
			numbers.push(objContact.personalMobile);
		}

		objContact=null;
		return numbers;
	},

	askForReloadContainer:function(boolNoReload) {
		if(!boolNoReload){
			this.doReloadContainer();
		}
		boolNoReload=null;
	},

	doReloadContainer:function() {
		this.boolAskForReloadContainer = false;
		clearTimeout(this.intAskForReloadContainerTimeoutid);
		this.intAskForReloadContainerTimeoutid = 0;
		if (webapp.communication.mainWidget){
			webapp.communication.mainWidget.reloadContainer();
			if (webapp.communication.getSelectStatus() !== -1) { // if we are in a selection mode, toggleOpacity
				webapp.communication.toggleOpacityTwoThird(true);
			}
		}
	},

	getContactInfoList:function(contact) {
		var objLabelIcon = webapp.communication._arrContextLabelsIcons[webapp.communication.getSelectStatus()];
		return ICTouchAPI.tools.getContactPresentationList(
			contact,
			webapp.communication,
			webapp.communication.onPresentationListClick,
			"webapp.communication",
			objLabelIcon ? objLabelIcon.icon : "",
			true
			);
	},

	getSupervisedInfoList : function(objCall) {
		return [{
			strId: "CallTo",
			strLabel: _("Call to", "webapp.communication"),
			strContent: ICTouchAPI.tools.getContactDisplayName(objCall.objCallData.initialCalled),
			callback: function(){
				webapp.communication.apiCall(ICTouchAPI.tools.getContactPhone(objCall.objCallData.initialCalled, false), false, false);
			},
			strIcon: "gray-communication-call-manager-32",
			objIconLabel: {
				strIcon:"arrow-callee-supervision-26",
				width:"26"
			}
		}]
	},

	getStrCallDuration : function(objCall) {
		var strCallDuration = "";
		if(objCall && objCall.objCallData){
			// if ringing or alerting, no timer is displayed (display time for ongoing calls and other device call)
			if((objCall.objCallData.isConnected === 1 || !objCall.objCallData.isLocal) && objCall.timer) {
				// increment
				var dtStartTime = objCall.timer.start;
				var intSec = Math.floor(dojo.date.difference(dtStartTime, new Date(), "second"));
				objCall.timer.value = intSec;
				// format time
				var objDate = new Date(0,0,0,0,0,intSec);
				// create the time string

				// > 1hours : print Hours
				if(intSec > 3600) {
					strCallDuration = objDate.format('HH:mm:ss',dojo.locale);
				}
				else {
					strCallDuration = objDate.format('mm:ss',dojo.locale);
				}
			}
		}
		objCall = null;
		return strCallDuration;
	},

	refreshCommunicationListTitle : function() {
		var strTitle = this.getCommunicationListTitle();
		if(webapp.communication.mainWidget && webapp.communication.mainWidget.menu) {
			webapp.communication.mainWidget.menu.reload({
				objTitle: {
					strLabel : strTitle
				}
			});
		}
	},

	getCommunicationListTitle : function() {
		return _("Communication", "webapp.communication");
	},

	getContainerTitle : function() {
		if (this._strTitle !== ""){
			return this._strTitle;
		}
		else{
			return _("Communication", "webapp.communication");
		}
	},

	getContainerPath : function(){
		return this._strContainerPath;
	},

	setContainerPath : function(path){
		this._strContainerPath = path;
		path=null;
	},	

	getPhoneCalls : function() {
		return this.objActiveComlog ? this.objActiveComlog.arrItems : [];
	},

	getActivePhoneCalls : function() {
		var arrCalls = this.getPhoneCalls();
		var arrActiveCalls = [];
		for(var i = 0 ; i < arrCalls.length ; i++){
			// arrCalls[i] is a current call (not a notification context)
			if(!arrCalls[i].isFiltered && !this.isSecondaryItem(arrCalls[i])){
				arrActiveCalls.push(arrCalls[i]);
			}
		}
		return arrActiveCalls;
	},

	getNbActiveCalls : function() {
		var arrCalls = this.getPhoneCalls();
		var nbPhoneCalls = 0;
		for(var i = 0 ; i < arrCalls.length ; i++){
			// arrCalls[i] is a current call (not a notification context)
			if(!arrCalls[i].isFiltered && !this.isSecondaryItem(arrCalls[i])){
				nbPhoneCalls++;
			}
		}
		return nbPhoneCalls;
	},

	getSelectedEntryId : function() {
		return this._intCurrentEntry;
	},

	getSelectedEntry : function() {		
		var entry = this.findItemById(this._intCurrentEntry);
		return entry;
	},

	getSelectedEntryCallStateLabel : function(){
		var selectedEntry = this.getSelectedEntry();
		var strLabel;
		var strName;
		if (selectedEntry) {
				// Case of notification contexts
				if(selectedEntry.isFiltered){
					strLabel = [];
					if(this.getUserRole() == this.MANAGER_ROLE){
						strLabel.push("Received call by");
						strName = selectedEntry.objCallData.assistant;
					} else {
						strLabel.push("Monitored call for");
						strName = selectedEntry.objCallData.manager;
					}
				}
				// Case of calls
				else {
			// Specific case of filtered call on assistant
					if(selectedEntry.objCallData && selectedEntry.objCallData.manager){
						strLabel = [];
						if (selectedEntry.objCallData.isOnHold || selectedEntry.objCallData.isHeld) {
							strLabel = this.lstCallStateLabel[selectedEntry.intStatus] || "";
						}
						else {
						if(selectedEntry.intStatus == this.STATUS_INCOMING){
							strLabel.push(this.lstCallStateLabel[this.STATUS_FILTERED_RING]);
						} else {
							strLabel.push(this.lstCallStateLabel[this.STATUS_FILTERED_CALL]);
						}
						strName = selectedEntry.objCallData.manager;
					}
					}
				// Supervised calls (and not hold/held)
				else if (selectedEntry.isSupervised && selectedEntry.objCallData && !selectedEntry.objCallData.isOnHold && !selectedEntry.objCallData.isHeld){
					strLabel = [];
					strLabel.push(this.lstCallStateLabel[this.STATUS_SUPERVISED_CALL]);
					strLabel.push(ICTouchAPI.tools.getContactDisplayName(selectedEntry.objCallData.initialCalled));
				}
					// Other classic calls
					else {
						// Get in the list
						strLabel = this.lstCallStateLabel[selectedEntry.intStatus] || "";
					}
				}

			if(webapp.managerassistant && strName){
				// Extract the name from ManagerAssistant
				var objMA = webapp.managerassistant.data.getMAByLogin(strName);
				var objContact = objMA && objMA.objContact;

				if(objContact){
					strName = ICTouchAPI.tools.getContactDisplayName(objContact);
				}
				strLabel.push(strName);
			}
		} else {
			strLabel = "";
		}
		return strLabel;
	},

	getCurrentContact : function(){
		return this.objCurrentContact;
	},

	getNotifyCallByPopup : function(){
		return this._boolNotifyCallByPopup;
	},

	setNotifyCallByPopup : function(bNotifyCallByPopup){
		this._boolNotifyCallByPopup = bNotifyCallByPopup;
		bNotifyCallByPopup=null;
	},

	setBoolInitiateByName : function(bInitiateByName){
		this.boolInitiateByName = bInitiateByName;
		bInitiateByName=null;
	},

	getBoolInitiateByName : function(){
		return this.boolInitiateByName;
	},

	getCurrentEntry : function() {
		return this._intCurrentEntry;
	},

	setCurrentEntry : function(id) {
		this._intCurrentEntry = id;
		id=null;
	},

	//Get number of items in selected comlog
	getNbItems : function() {
		return this.objActiveComlog ? this.objActiveComlog.getNbItems() : 0;
	},

	getCallIdRetrieving : function() {
		return this.callIdRetrieving;
	},

	setCallIdRetrieving : function(callIdRetrieving) {
		this.callIdRetrieving = callIdRetrieving;
		callIdRetrieving = null;
		webapp.communication.updateAppBar();
	},

	clearCallIdRetrieving : function(callIdRetrieving) {
		if(this.callIdRetrieving == callIdRetrieving){
			this.callIdRetrieving = null;
			webapp.communication.updateAppBar();
		}
	},

	/**
	 * Return the notificationType, meaning a css class for the top bar of the notification.
	 **/
	_callNotificationType : function(intStatus) {
		var notificationType = "";
		if(intStatus == this.STATUS_CONFERENCE || intStatus == this.STATUS_CONFERENCE_HOLD || intStatus == this.STATUS_CONFERENCE_INCOMING || intStatus == this.STATUS_CONFERENCE_PARTICIPANT_SELECTED || intStatus == this.STATUS_CONFERENCE_PARTICIPANT_MENULIST_SELECTED){
			notificationType = ICTouchAPI.notificationServices.enumType.BLUE;
		} else if(intStatus == this.STATUS_HELD || intStatus == this.STATUS_HOLD){
			notificationType = ICTouchAPI.notificationServices.enumType.BLUE;
		} else if(intStatus == this.STATUS_OUTGOING || intStatus == this.STATUS_INCOMING || intStatus == this.STATUS_REMOTE_SESSION || intStatus == this.STATUS_CONFERENCE_REMOTE_SESSION){
			notificationType = ICTouchAPI.notificationServices.enumType.BLUE;
		} else {
			notificationType = ICTouchAPI.notificationServices.enumType.BLUE;
		}
		intStatus = null;
		return notificationType;
	},

	/**
	 * Return the icon to put in the notification
	 **/
	_callNotificationIcon : function(intStatus) {
		var notificationIcon = "";
		if(intStatus == this.STATUS_CONFERENCE || intStatus == this.STATUS_CONFERENCE_INCOMING || intStatus == this.STATUS_CONFERENCE_PARTICIPANT_SELECTED || intStatus == this.STATUS_CONFERENCE_PARTICIPANT_MENULIST_SELECTED){
			if( this.isInVideoCall( this.getCurrentEntry() ) ) {
				notificationIcon = "communication-log-in-conference-video-blue-64";
			} else {
			notificationIcon = "communication-log-conference-finish-64";
			}
		} else if(intStatus == this.STATUS_HELD || intStatus == this.STATUS_HOLD || intStatus == this.STATUS_CONFERENCE_HOLD){
			if( this.isInVideoCall( this.getCurrentEntry() ) ) {
			    notificationIcon = "communication-log-in-holdvideo-blue-64";
			} else {
			notificationIcon = "communication-log-hold-64";
			}
		} else if(intStatus == this.STATUS_OUTGOING || intStatus == this.STATUS_INCOMING || intStatus == this.STATUS_FILTERED_RING){
			notificationIcon = "communication-log-in-ringing-blue-64";
		} else if(intStatus == this.STATUS_REMOTE_SESSION || intStatus == this.STATUS_CONFERENCE_REMOTE_SESSION){
			notificationIcon = "communication-routing-generic-blue-64";
		} else {
			    if( this.isInVideoCall( this.getCurrentEntry() ) ) {
				notificationIcon = "communication-log-in-comvideo-blue-64";
			    } else {
			notificationIcon = "communication-log-in-com-blue-64";
		}
		}
		intStatus = null;

		ICTouchAPI.debugServices.debug("webapp.communication.dataBase._callNotificationIcon - notificationIcon: " + notificationIcon);

		return notificationIcon;
	},

	/**
	 * return the recipient displayName if present or recipient phoneNumber to be displayed
	 * in a large notification
	 **/
	_callNotificationLabel : function(objCall) {
		var objNotification = {
		    "strLabel": "",
		    "strLabelBottom": "",
		    "arrIconBottom": []
		};
		if (this.isInConference()) {
			objNotification.strLabel = _("Conference", "webapp.communication");
		}
		else {
			// If the call, is a monitored call (Manager/Assistant context)
			if(objCall.isFiltered || objCall.isSupervised) {
				// Update the name and the first name of the caller
				var objContact = this.searchContactFromLog(objCall);

				if(objContact.name || objContact.firstName) {
					objNotification.strLabel = ICTouchAPI.tools.getContactDisplayName(objContact);
			} else if(objCall.objCallData.displayName){
					objNotification.strLabel = objCall.objCallData.displayName.replace(/\"/g,'');
			} else {
					objNotification.strLabel = objCall.objCallData.phoneNumber;
			}

				var iconList = [];
				iconList[0] = {icon: "arrow-callee-notification-26", width: 26};
				iconList[1] = objCall.arrSecondaryIcon[1];

				objNotification.arrIconBottom = iconList;

				if(objCall.isSupervised){
					objNotification.strLabelBottom = ICTouchAPI.tools.getContactDisplayName(objCall.objCallData.initialCalled);
				}

				if(objCall.isFiltered) {
					// The call is monitored. Who is the manager, who is the assistant?
					if (webapp.managerassistant) {
						var objManagerAssistant;
						if (this.getUserRole() == this.MANAGER_ROLE) {
							objManagerAssistant = webapp.managerassistant.data.getMAByLogin(objCall.objCallData.assistant);
						} else {
							objManagerAssistant = webapp.managerassistant.data.getMAByLogin(objCall.objCallData.manager);
						}

						objNotification.strLabelBottom = ICTouchAPI.tools.getContactDisplayName(objManagerAssistant.objContact);
					}
				}

			} else {
				// This is the "normal" call case
				objNotification.strLabel = _("OngoingCall", "webapp.communication");
			}
		}
		objCall = null;
		return objNotification;
	},

	setHotelMode : function() {
		this.boolHotelMode = true;
		this.refreshEntryById(this.getCurrentEntry());
	},

	getHotelMode : function() {
		return this.boolHotelMode;
	},

	switchContainer: function(pageName, status, pageTitle) {
		this._strContainerPath = "webapp.communication."+pageName;
		if (pageTitle){
			this._strTitle = pageTitle;
		}
		webapp.communication._intStatus = status;
		this.askForReloadContainer();
		pageName=null;
		status=null;
		pageTitle=null;
	},

	getCallIdByPhoneNumber : function(phoneNumber) {
		var arrCall = this.getPhoneCalls();
		for (var i in arrCall){
			if(arrCall[i].objCallData && arrCall[i].objCallData.phoneNumber == phoneNumber){
				phoneNumber=null;
				return arrCall[i].objCallData.callId;
			}
		}
		phoneNumber=null;
		return null;
	},

	updateSupervisedCall : function(objSupervised) {
		ICTouchAPI.debugServices.info("webapp.communication.dataBase - updateSupervisedCall begin");
		ICTouchAPI.debugServices.debug("webapp.communication.dataBase - updateSupervisedCall / "+ dojo.toJson(objSupervised));

		var arrCalls = this.getPhoneCalls();
		for(var i in arrCalls){
			if(arrCalls[i].objCallData && arrCalls[i].objCallData.initialCalled){
				ICTouchAPI.debugServices.debug("webapp.communication.dataBase - updateSupervisedCall / index : " + i + " | arrCalls[i].objCallData.initialCalled.login : "+ arrCalls[i].objCallData.initialCalled.login);
				if(arrCalls[i].objCallData.initialCalled.login == objSupervised.identity.login){
					ICTouchAPI.debugServices.debug("webapp.communication.dataBase - updateSupervisedCall / start modifyInLog with login = " + arrCalls[i].objCallData.initialCalled.login);
					this.modifyInLog(arrCalls[i].objCallData, this.COMLOG_CALL);
				}
			}
		}

		ICTouchAPI.debugServices.info("webapp.communication.dataBase - updateSupervisedCall end");
	},

	getTimerFromStartTime : function(startTime) {
		// value of the timer of the ongoing call
		var timer = {};
		var dtStartTime;
		if(startTime.year < 0){
			dtStartTime = new Date();
		}
		else{
			dtStartTime = new Date(startTime.year, startTime.month - 1, startTime.day, startTime.hour, startTime.minute, startTime.second);
		}
		timer.start = dtStartTime;
		var floatDiff = dojo.date.difference(dtStartTime, new Date(), "second");
		timer.value = (floatDiff)?floatDiff:0;

		return timer;
	},

	buildPhoneCallItem : function(callObject) {
		// init
		var objCall = {
			strPrimaryIcon: 'communication-log-in-com-blue-48',
			strPrimaryContent: callObject.displayName ? callObject.displayName : callObject.phoneNumber,
			strSecondaryContent: " ",
			strSecondaryContentStyle: "normal",
			objCallData: callObject,
			intStatus: this.STATUS_ONGOING,
			intIndex: callObject.callId
			// Phone calls have different visual then Communication logs
			//additionalStyle: "appearSelected"
		};

		var objContact = this.searchContactFromLog(objCall);

		objCall.strPicture = (objContact.photo) ? objContact.photo : ICTouchAPI.tools.getDefaultPhotoPath("user", "50");

		if (!callObject.isConnected) {
			objCall.intStatus = (callObject.callDirection === "CALL_OUTGOING") ? this.STATUS_OUTGOING : this.STATUS_INCOMING;
			objCall.strPrimaryIcon = "communication-log-in-ringing-blue-48";
		} else if (callObject.isOnHold) {
			objCall.intStatus = this.STATUS_HOLD;
			if (callObject.videoStatus && (callObject.videoStatus === this.TELEPHONY_VIDEO_STATUS_ON ||
			 callObject.videoStatus === this.TELEPHONY_VIDEO_STATUS_DOORCAM)) {
			    objCall.strPrimaryIcon = "communication-log-in-holdvideo-blue-48";
			} else {
			    objCall.strPrimaryIcon = "communication-log-hold-48";
			}
		} else if (callObject.isHeld) {
			objCall.intStatus = this.STATUS_HELD;
			if (callObject.videoStatus && (callObject.videoStatus === this.TELEPHONY_VIDEO_STATUS_ON ||
			    callObject.videoStatus === this.TELEPHONY_VIDEO_STATUS_DOORCAM)) {
			    objCall.strPrimaryIcon = "communication-log-in-holdvideo-blue-48";
			} else {
			    objCall.strPrimaryIcon = "communication-log-hold-48";
			}
		} else if (callObject.isRinging || callObject.isAlerting) {
			   objCall.strPrimaryIcon = "communication-log-in-ringing-blue-48";
		} else if (callObject.videoStatus &&
			   (callObject.videoStatus === this.TELEPHONY_VIDEO_STATUS_ON ||
			    callObject.videoStatus === this.TELEPHONY_VIDEO_STATUS_DOORCAM)) {
			   objCall.strPrimaryIcon = "communication-log-in-comvideo-blue-48";
		}

		// If we're in R100 mode, we have to build the participants array
		// (no need for that in R200 since it's already built thanks to participant events)
		// To know if we're in R100, check if an entry already exist in participants array
		var arrParticipants = this.getCallParticipants(callObject.callId);

		if (callObject.isConference) {
			if (!callObject.isLocal && webapp.session) {
				objCall.intStatus = this.STATUS_CONFERENCE_REMOTE_SESSION;
				objCall.strPrimaryIcon = "communication-routing-generic-blue-48";
			}
			else if (callObject.isOnHold) {
				//On hold conference
				objCall.intStatus = this.STATUS_CONFERENCE_HOLD;
				if (callObject.videoStatus && callObject.videoStatus === this.TELEPHONY_VIDEO_STATUS_ON) {
					objCall.strPrimaryIcon = "communication-log-in-holdvideo-blue-48";
				} else {
					objCall.strPrimaryIcon = "communication-log-hold-48";
				}
			}
			else if ( callObject.isRinging || callObject.isAlerting || callObject.isIgnoring) {
				//Incoming conference
				objCall.intStatus = this.STATUS_CONFERENCE_INCOMING;
				objCall.strPrimaryIcon = "communication-log-conference-finish-48"; //icon is the same as an established conference
			}
			else {
				//Established conference
			objCall.intStatus = this.STATUS_CONFERENCE;
				if (callObject.videoStatus && callObject.videoStatus === this.TELEPHONY_VIDEO_STATUS_ON) {
					objCall.strPrimaryIcon = "communication-log-in-conference-video-blue-48";
				} else {
			objCall.strPrimaryIcon = "communication-log-conference-finish-48";
			}
			}
			objCall.strPrimaryContent = _("Conference", "webapp.communication");
			objCall.strPicture = ICTouchAPI.tools.getDefaultPhotoPath("conference", "50");
			this.buildSecondaryItemsArray(objCall, arrParticipants);
		}
		else {
			// Should be only 1 participant since we're not in conference
			if(objContact.name || objContact.firstName){
				objCall.strPrimaryContent = ICTouchAPI.tools.getContactDisplayName(objContact);//objContact.firstName + " " + objContact.name;
			}
			else if (arrParticipants && arrParticipants[0] && arrParticipants[0].displayName && arrParticipants[0].displayName !== ""){
				objCall.strPrimaryContent = arrParticipants[0].displayName;
			}
			else if(callObject){
				objCall.strPrimaryContent = callObject.displayName || callObject.phoneNumber;
			}
			if (!callObject.isLocal && webapp.session) {
				objCall.intStatus = this.STATUS_REMOTE_SESSION;
				objCall.strPrimaryIcon = "communication-routing-generic-blue-48";
			}

			if (objCall.strPrimaryContent.replace(/\s/g,'')==="anonymous" || objCall.strPrimaryContent.replace(/\s/g,'')==="***") {   
				objCall.strPrimaryContent=_("anonymous","ICTouchAPI");
			}
		}

		// value of the timer of the ongoing call
		objCall.timer = this.getTimerFromStartTime(objCall.objCallData.startTime.datetime);

		if(objCall.intStatus !== this.STATUS_OUTGOING && objCall.intStatus !== this.STATUS_INCOMING){
			// built the start time to be displayed in comlog
			objCall.strSecondaryContent = this.getFormatedDateForComlog(objCall.timer.start);
		}

		// Contact picture may be disabled by setting, so we delete it.
		if(!this.boolEnablePhotoInComlog){
			objCall.strPicture = null;
		}

		// If the call is filtered, add the photo of the manager/assistant
		if (callObject.isFiltered && webapp.managerassistant) {
			objCall.isFilteredAssistant = true;
			var objManagerAssistant = webapp.managerassistant.data.getMAByLogin(callObject.manager);
			if(objManagerAssistant){
				if(objManagerAssistant.objContact.photo){
					// For the Menu list
					objCall.strPicture = objManagerAssistant.objContact.photo;
					// For the contact card
					objCall.assistantPhoto = objManagerAssistant.objContact.photo;
				}
				objCall.strSecondaryContent = this.getFilteredLogSecondaryContent(objManagerAssistant.objContact);
				var objMAContact = ICTouchAPI.dataStoreServices.getStore('contacts').find(["login"], callObject.manager);
				objCall.arrSecondaryIcon = [{
					icon : "arrow-callee-history-unread-26",
					width : 26
				}, {
					icon : ICTouchAPI.tools.getTelephonyPresenceIconPath(objMAContact.telephonyPresence, '16'),
					width : 20
				}];
				objCall.strSecondaryContentStyle = "italic";
			}
		}

		// Case of supervision mode
		if(callObject.initialCalled && callObject.startReason == this.lstReason.PICKUP){
			if(callObject.initialCalled.value){
				callObject.initialCalled = callObject.initialCalled.value;
			}
			var objSupervised = ICTouchAPI.supervisionServices.getSupUserByLogin(callObject.initialCalled.login);
			var objSupervisedItem;
			if(objSupervised){
				objSupervisedItem = this.buildSupervisedItem(objSupervised);
				dojo.mixin(objCall, objSupervisedItem);
			} else {
				ICTouchAPI.debugServices.warning("webapp.communication.dataBase - buildPhoneCallItem / Supervised not found : " + callObject.initialCalled.login)
			}
		}

		callObject=null;

		ICTouchAPI.debugServices.debug("webapp.communication.dataBase.buildPhoneCallItem - strPrimaryIcon: " + objCall.strPrimaryIcon);

		return objCall;
	},

	// Build the part of phoneCallItem dedicated to supervision
	buildSupervisedItem : function(objSupervised) {
		var objCall = {};
		objCall.strSecondaryContent = ICTouchAPI.tools.getContactDisplayName(objSupervised.identity);
		objCall.arrSecondaryIcon = [{
				icon : "arrow-callee-history-unread-26",
				width : 26
			}, {
				icon : objSupervised.presence + "-16",
				width : 20
			}];
		objCall.strSecondaryContentStyle = "italic";
		objCall.isSupervised = true;

		return objCall;
	},

	/**
	 * Build a Filtered call Item to add in comlog.
	 * @Params {object} objNotificationContext : ManagerAssistant type for filtered call.
	 */
	buildFilteredCallItem : function(objNotificationContext) {
		var objParticipant = objNotificationContext.participantsList[0];

		if(!objParticipant){
			objNotificationContext = null;
			return null;
		}

		objParticipant.objContact = this.buildObjectContactFromParticipant(objParticipant);
		// little trick to be sure it doesn't go in "session" webapp
		objNotificationContext.isLocal = true;
		// primary content label has to be built following the priority order : 1) DisplayName 2) FirstName+Name 3) PhoneNumber
		var strPrimaryContentLabel = "";
		if (objParticipant.displayName) {
			strPrimaryContentLabel = objParticipant.displayName;
		}
		else if (objParticipant.objContact.firstName || objParticipant.objContact.name) {
			strPrimaryContentLabel = ICTouchAPI.tools.getContactDisplayName(objParticipant.objContact);//objParticipant.objContact.firstName + " " + objParticipant.objContact.name;
		}
		else {
			strPrimaryContentLabel = objParticipant.phoneNumber;
		}
		// init
		var objCall = {
			strPrimaryIcon: 'communication-log-in-com-blue-48',
			strPrimaryContent: strPrimaryContentLabel,
			strSecondaryContent: " ",
			objCallData: objNotificationContext,
			intStatus: this.STATUS_FILTERED_CALL,
			intIndex: objNotificationContext.callRef,
			isFiltered: true
		};

		var objContact = this.searchContactFromLog(objCall);

		// To render it compatible with usual phonecalls
		objCall.objCallData.callId = objCall.objCallData.callRef;

		if(objNotificationContext.callState === 'RINGING') {
			objCall.intStatus = this.STATUS_FILTERED_RING;
			objCall.strPrimaryIcon = "communication-log-in-ringing-blue-48";
		} else {
			// Add it to display the timer on contact card and menu list
			objCall.objCallData.isConnected = 1;
		}

		// add the photo of the manager/assistant
		if(webapp.managerassistant){
			var objManagerAssistant;
			if(webapp.managerassistant.data.getRole() === webapp.managerassistant.data.MANAGER_ROLE){
				objManagerAssistant = webapp.managerassistant.data.getMAByLogin(objNotificationContext.assistant);
			} else if (webapp.managerassistant.data.getRole() === webapp.managerassistant.data.ASSISTANT_ROLE){
				objManagerAssistant = webapp.managerassistant.data.getMAByLogin(objNotificationContext.manager);
			}
			if(objManagerAssistant){
				if(objManagerAssistant.objContact.photo){
				// For the Menu list
				objCall.strPicture = objManagerAssistant.objContact.photo;
				// For the contact card
				objCall.assistantPhoto = objManagerAssistant.objContact.photo;
			}
				// Set secondary content for menuList
				objCall.strSecondaryContent = this.getFilteredLogSecondaryContent(objManagerAssistant.objContact);
				var objMAContact = ICTouchAPI.dataStoreServices.getStore('contacts').find(["login"], objManagerAssistant.login);
				objCall.arrSecondaryIcon = [{
					icon : "arrow-callee-history-unread-26",
					width : 26
				}, {
					icon : ICTouchAPI.tools.getTelephonyPresenceIconPath(objMAContact.telephonyPresence, '16'),
					width : 20
				}];
				objCall.strSecondaryContentStyle = "italic";
			}
		} else {
		// value of the timer of the ongoing filtered call
		objCall.timer = {};
		var dtStartTime = new Date();
		objCall.timer.start = dtStartTime;
		var floatDiff = dojo.date.difference(dtStartTime, new Date(), "second");
		objCall.timer.value = (floatDiff)?floatDiff:0;

		// built the start time to be displayed in comlog
		objCall.strSecondaryContent = this.getFormatedDateForComlog(objCall.timer.start);
		}

		// Contact picture may be disabled by setting, so we delete it.
		if(!this.boolEnablePhotoInComlog){
			objCall.strPicture = null;
		}
		objNotificationContext=null;
		return objCall;
	},

	/**
	 * return a string with the arrow icon + the name corresponding to the manager / assistant
	 * @params objContact {object} the manager/assistant contact object
	 */
	getFilteredLogSecondaryContent : function(objContact) {
		var strName = ICTouchAPI.tools.getContactDisplayName(objContact);
		objContact = null;
		return strName;
	},
	

	getCallParticipants : function(phoneCallId) {
		var arrParticipant = [];
		if(this._arrParticipantsByCall[phoneCallId]){
			arrParticipant = this._arrParticipantsByCall[phoneCallId]
		}
		phoneCallId=null;
		return arrParticipant;
	},

	addParticipantInCall : function(phoneCallId, participant){
		participant.objContact = this.buildObjectContactFromParticipant(participant);
		if (!this._arrParticipantsByCall[phoneCallId]) {
			this._arrParticipantsByCall[phoneCallId] = [];
		}
		this._arrParticipantsByCall[phoneCallId].push(participant);
		phoneCallId=null;
		participant=null;
	},

	modifyParticipantInCall : function(phoneCallId, participant){
		if (!this._arrParticipantsByCall[phoneCallId]){
			phoneCallId=null;
			participant=null;
			return;
		}
		participant.objContact = this.buildObjectContactFromParticipant(participant);
		for (var i in this._arrParticipantsByCall[phoneCallId])
		{
			if(this._arrParticipantsByCall[phoneCallId][i].participantId === participant.participantId || this._arrParticipantsByCall[phoneCallId][i].phoneNumber === participant.phoneNumber)
			{
				this._arrParticipantsByCall[phoneCallId][i] = participant;
				break;
			}
		}
		phoneCallId=null;
		participant=null;
	},

	removeParticipantInCall : function(phoneCallId,participant){
		if (!this._arrParticipantsByCall[phoneCallId]){
			phoneCallId=null;
			participant=null;
			return;
		}
		for (var i in this._arrParticipantsByCall[phoneCallId])
		{
			if(this._arrParticipantsByCall[phoneCallId][i].participantId === participant.participantId || this._arrParticipantsByCall[phoneCallId][i].phoneNumber === participant.phoneNumber)
			{
				this._arrParticipantsByCall[phoneCallId].splice(i,1);
				break;
			}
		}
		if (this._arrParticipantsByCall[phoneCallId][0] === undefined){
			delete this._arrParticipantsByCall[phoneCallId];
		}
		phoneCallId=null;
		participant=null;
	},

	removeAllParticipantsInCall : function(phoneCallId) {
		if (this._arrParticipantsByCall[phoneCallId]){
			delete this._arrParticipantsByCall[phoneCallId];
		}
		phoneCallId=null;
	},

	getCallsWithParticipants : function(){
		return this._arrParticipantsByCall;
	},

	getAllParticipants : function() {
		var arrParticipants = [];
		for(var i in this._arrParticipantsByCall){
			if(this._arrParticipantsByCall[i]){
				arrParticipants = arrParticipants.concat(this._arrParticipantsByCall[i]);
			}
		}
		return arrParticipants;
	},

	setUserRole : function(strRole) {
		this._userRole = strRole;
		strRole = null;
	},

	getUserRole : function() {
		return this._userRole;
	},

	getCountCalls : function() {
		return this._intCountCalls;
	},

	increaseCountCalls : function() {
		this._intCountCalls++;
		dojo.publish("ongoingCallCountChanged");
	},

	decreaseCountCalls : function() {
		if(this._intCountCalls > 0){
			this._intCountCalls--;
			dojo.publish("ongoingCallCountChanged");
		}
	},

	//Find item by id in selected comlog
	findItemById : function(id) {
		var entry = undefined;
		if(this.objActiveComlog && this.objActiveComlog.findItem) {
			entry = this.objActiveComlog.findItem("intIndex", id);
		}
		id=null;
		return entry;
	},

	//Find item by position in selected comlog
	findItemByPosition : function(intPosition){
		var entry = undefined;
		if(this.objActiveComlog && this.objActiveComlog.arrItems){
			entry = this.objActiveComlog.arrItems[intPosition];
		}
		intPosition=null;
		return entry;
	},

	getFormatedDateForComlog : function(startDate){
		// start time
		var today = new Date();
		var strTime = ICTouchAPI.tools.getFormatedTime(startDate.getHours(), startDate.getMinutes(), this._24hformat);
		if (startDate.getDate() !== today.getDate() || startDate.getMonth() !== today.getMonth() || startDate.getFullYear() !== today.getFullYear()) {
			// not today we print the date
			strTime = ICTouchAPI.tools.getFormatedDate(startDate, "dd/mm ") + strTime;
		}
		startDate = null;
		return strTime;
	},

	//Select item by id in selected comlog
	selectComlogByIndex : function(id, boolSelect, doNotScroll){
		if(this.objActiveComlog) {
			this.objActiveComlog.selectItemByIndex(id, boolSelect, doNotScroll);
		} else {
			ICTouchAPI.debugServices.warning("webapp.communication.dataBase - selectComlogByIndex / Missing or wrong intLog parameter");
		}
		id=null;
		boolSelect=null;
	},

	//Insert items in selected comlog
	insertItemsInComlogs : function(intPosition, arrItems){
		if(this.objActiveComlog) {
			this.objActiveComlog.insertItems(intPosition, arrItems);
		}
		intPosition=null;
		arrItems=null;
	},

	unshiftItemInComlogs : function(objLog){
		if(this.objActiveComlog) {
			this.objActiveComlog.unshiftItem(objLog, true);
		} else {
			ICTouchAPI.debugServices.warning("webapp.communication.dataBase - unshiftItemInComlogs / Missing or wrong intLog parameter");
		}
		objLog=null;
	},

	sliceItemsInComlogs : function(intStart, intNb) {
		if(this.objActiveComlog) {
			this.objActiveComlog.sliceItems(intStart, intNb);
		} else {
			ICTouchAPI.debugServices.warning("webapp.communication.dataBase - sliceItemsInComlogs / Missing or wrong intLog parameter");
		}
		intStart=null;
		intNb=null;
	},

	emptyItemsInComlogs : function() {
		 if(this.objActiveComlog) {
			this.objActiveComlog.emptyItems();
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.communication.dataBase - emptyItemsInComlogs / Missing ");
		}
		intLog=null;
	},

	unshiftItemsInComlogs : function(arrLogs){
		if(this.objActiveComlog) {

			this.objActiveComlog.unshiftItems(arrLogs, true);
		} else {
			ICTouchAPI.debugServices.warning("webapp.communication.dataBase - unshiftItemsInComlogs / Missing or wrong intLog parameter");
		}
		arrLogs=null;
	},

	//Update items Comlog in all comlog
	updateItemInComlogs : function(objLog){
		if(this.objActiveComlog) {
			this.objActiveComlog.updateItem(objLog);
		}
		objLog=null;
	},

	//Remove item by id in selected comlog
	removeItemById : function(id, boolDoNotSelectNext){
		var removedItem = null;
		if(this.objActiveComlog) {
			removedItem = this.objActiveComlog.removeItemByIntIndex(id, boolDoNotSelectNext);
		} else {
			ICTouchAPI.debugServices.warning("webapp.communication.dataBase - removeItemById / Missing or wrong intLog parameter");
		}
		id=null;
		boolDoNotSelectNext=null;
		return removedItem;
	},

	showItemById : function(itemId, strHideType, boolOnComlogOnly) {
		if(this._objHiddenComlogItems[itemId] == strHideType) {
			delete(this._objHiddenComlogItems[itemId]);
			if(this.objActiveComlog) {
				this.objActiveComlog.showItemByIntIndex(itemId);
			} else {
				ICTouchAPI.debugServices.warning("webapp.communication.dataBase - showItemById / Missing or wrong intLog parameter");
			}
		}
		itemId=null;
	},

	hideItemById : function(itemId, strHideType) {
		if(!this._objHiddenComlogItems[itemId]) {
			this._objHiddenComlogItems[itemId] = strHideType;
			if(this.objActiveComlog) {
				this.objActiveComlog.hideItemByIntIndex(itemId);
			} else {
				ICTouchAPI.debugServices.warning("webapp.communication.dataBase - hideItemById / Missing or wrong intLog parameter");
			}
		}
		itemId=null;
	},

	// Return the id of the first selectable item.
	findFirstSelectableItem : function() {
		var itemId = null;

		if (this.objActiveComlog) {
			for (var i=0; i<this.objActiveComlog.arrItems.length; i++) {
				if (!this.objActiveComlog.arrItems[i].boolToHide) {
					itemId = this.objActiveComlog.arrItems[i].intIndex;
					break;
				}
			}
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.communication.dataBase - findFirstSelectableItem / list is not defined");
		}
		return itemId;
	},

	// Add a call in a buffer of calls to delete/modify/add
	// objBuffer : {actionType, logType, id, bNoRefresh, item} bNoRefresh and Item are optionnal.
	addInComBuffer : function(objBuffer) {
		if (objBuffer.actionType == this.COMLOG_ACTION_MODIFY && this.lstComBufferedAction[objBuffer.id]){
			if(this.lstComBufferedAction[objBuffer.id].actionType !== this.COMLOG_ACTION_REMOVE){
				this.lstComBufferedAction[objBuffer.id].item = objBuffer.item;
			}
		} else {
			this.lstComBufferedAction[objBuffer.id] = objBuffer;
		}
		this.bStackedAction = true;
		objBuffer = null;
	},

	getComBuffer : function() {
		return this.lstComBufferedAction;
	},

	addSimulatedItemInLog : function(number, boolIncoming){
		var phoneCall={
			callId: -1,
			phoneNumber: number,
			callDirection: (boolIncoming) ? "CALL_INCOMING" : "CALL_OUTGOING",
			isLocal: true,
			isAlerting: true,
			idCapabilities: 0,
			startTime: {
				datetime: {
					year: -1
				}
			}
		}
		var objCall = this.buildPhoneCallItem(phoneCall);
		this.loadAll(objCall,this.COMLOG_CALL, this.COMLOG_ACTION_ADD, 0, null);
	},

	addInLog : function(phoneCall, intComlogType) {
		if(this.getTelephonyDontRefresh() || this.bStackedAction){
			this.addInComBuffer({
				actionType : this.COMLOG_ACTION_ADD,
				logType : intComlogType,
				id : phoneCall.callId,
				item : phoneCall
			});
			if(!this.getTelephonyDontRefresh()){
				webapp.communication.doStackedActions();
			}
		} else {
			this._addInLog(phoneCall, intComlogType);
		}
		var objCall = this.extractItemFromComlogObject(phoneCall, intComlogType, this.COMLOG_ACTION_ADD);
		phoneCall=null;
		intComlogType=null;
		return objCall;
	},

	_addInLog : function(phoneCall, intComlogType) {
		var objCall = null;
		// build the item according to the type (call, log, notification) and insert in lists
		objCall = this.extractItemFromComlogObject(phoneCall, intComlogType, this.COMLOG_ACTION_ADD);
		this.loadAll(objCall, intComlogType, this.COMLOG_ACTION_ADD, null, null);
		if(!this._boolDTMFKeyboardDeployed) {
			webapp.communication.addPopupCall(phoneCall.callId);
		}
		phoneCall=null;
		intComlogType=null;
		return objCall;
	},

	removeFromLog : function(callId, intComlogType, boolDoNotSelectNext) {
		if(this.getTelephonyDontRefresh() || this.bStackedAction){
			this.addInComBuffer({
				actionType : this.COMLOG_ACTION_REMOVE,
				logType : intComlogType,
				id : callId,
				bNoRefresh : boolDoNotSelectNext
			});
			if(!this.getTelephonyDontRefresh()){
				webapp.communication.doStackedActions();
			}
		} else {
			return this._removeFromLog(callId, intComlogType, boolDoNotSelectNext);
		}

		callId=null;
		intComlogType=null;
		return null;
	},

	_removeFromLog : function(callId, intComlogType, boolDoNotSelectNext) {
		var log = this.findItemById(callId);
		var boolIsRemoved = false;
		if(this.isInVideoCall(callId)){
			ICTouchAPI.debugServices.debug("webapp.communication.dataBase - removeFromLog / close video for callId " + callId);
			this.closeVideoCall(callId);
		}
		// Remove it from lists
		if (log && this.removeItemById(callId, boolDoNotSelectNext)) {
			// If the item is successfully removed, continue (avoid bugs linked to duplicated events received to remove log)
			// Update the number of ongoing calls
				if(this._objFirstSelected && this._objFirstSelected.objCallData && this._objFirstSelected.intIndex == callId){
					webapp.communication.resetStatus();
				}
				this.decreaseCountCalls();
				webapp.communication.removePopupCall(callId);

			// If there is no more item, refresh with blank page
			if(this.getNbItems() === 0) {
					this.loadDetails(undefined);
			}
			boolIsRemoved = true;
		}
		// Security: if there is no ongoing calls anymore, call cleanVideoServices to reset it
		if (this.getCountCalls() === 0) {
			ICTouchAPI.VideoServices.cleanVideoServices();
		}
		callId=null;
		boolDoNotSelectNext=null;
		return boolIsRemoved;
	},

	modifyInLog : function(phoneCall, intComlogType) {
		if(this.getTelephonyDontRefresh() || this.bStackedAction){
			this.addInComBuffer({
				actionType : this.COMLOG_ACTION_MODIFY,
				logType : intComlogType,
				id : phoneCall.callId,
				item : phoneCall
			});
			if(!this.getTelephonyDontRefresh()){
				webapp.communication.doStackedActions();
			}
		} else {
			this._modifyInLog(phoneCall, intComlogType);
		}
		phoneCall=null;
		intComlogType=null;
	},

	/**
	 * Modify an entry in the Comlog
	 * @param objLog : the phoneCall / log / NotificationContext object to modify
	 * @param intComlogType : static variable meaning "call", "log" or "NotificationContext".
	 */
	_modifyInLog : function(objLog, intComlogType) {
		var objCall = null;
		var boolFound = false;
		// build the item according to the type (call, log, notification)
		objCall = this.extractItemFromComlogObject(objLog, intComlogType, this.COMLOG_ACTION_MODIFY);
		if(objCall){
			if(this.isInVideoCall(objLog.callId) && (objLog.videoStatus === this.TELEPHONY_VIDEO_STATUS_OFF)) {
				ICTouchAPI.debugServices.debug("webapp.communication.dataBase - modifyInLog / Video status: " + objLog.videoStatus + ", close video for callId " + objLog.callId);
				this.closeVideoCall(objLog.callId);
			}
			this.loadAll(objCall, intComlogType, this.COMLOG_ACTION_MODIFY);
			boolFound = true;
			if(!this._boolDTMFKeyboardDeployed) {
				webapp.communication.modifyPopupCall(objLog.callId);
			}
		}
		objLog=null;
		intComlogType=null;
		return boolFound;
	},

	/**
	 * Extract a valid item from an object from Comlog or Telephony application.
	 * @param {object} objLog : the phoneCall / log / NotificationContext object to modify
	 * @param {number} intComlogType : static variable meaning "call", "log" or "NotificationContext".
	 * @param {number} intAction : static variable meaning "add", "modify" or "remove"
	 * @return the valid item or null
	 */
	extractItemFromComlogObject : function(objLog, intComlogType, intAction) {
		var item = null;
		if(intComlogType === this.COMLOG_FILTERED){
			if(intAction != this.COMLOG_ACTION_MODIFY || this.findItemById(objLog.callRef)){
				objLog.callId = objLog.callRef;
				item = this.buildFilteredCallItem(objLog);
			}
		} else if (intComlogType === this.COMLOG_CALL){
			if(intAction != this.COMLOG_ACTION_MODIFY || this.findItemById(objLog.callId)){
				item = this.buildPhoneCallItem(objLog);
			}
		} 		objLog = null;
		intComlogType = null;
		intAction = null;
		return item;
	},

	replaceInLog : function(oldPhoneCall,newPhoneCall) {
		var boolRemoved;
		boolRemoved = this.removeFromLog(oldPhoneCall.callId, this.COMLOG_CALL, true);
		this.addInLog(newPhoneCall, this.COMLOG_CALL);
		oldPhoneCall=null;
		newPhoneCall=null;
		return boolRemoved;
	},

	buildObjectContactFromParticipant : function(objParticipant) {
		var objContact = {
			contactId:		objParticipant.localContactId,
			name:			objParticipant.name,
			firstName:		objParticipant.firstName,
			officePhone:    objParticipant.phoneNumber,
			officePhoneCan: objParticipant.phoneNumber,
			email:			objParticipant.email,
			loginName:		objParticipant.login,
			photo:			objParticipant.photoUrl
		};
		if(objParticipant.localContactId==null || objParticipant.localContactId=="") {
			objContact.contactId = -1;
		}
		if(!objParticipant.name && !objParticipant.firstName){
			objContact.name = objParticipant.phoneNumber;
		}
		if(objParticipant.anonymous==1) {
			objContact.firstName = "anonymous";
			objContact.officePhone = "anonymous";
		}
		objParticipant=null;
		return objContact;
	},

	loadAll : function(objLog, logType, action, position) {
		if(action == this.COMLOG_ACTION_ADD){
			// If it is not a log, set the calls count.
				this.increaseCountCalls();
			// Insert the entry.
			this.insertItemsInComlogs(position, [objLog]);
		} else if (action == this.COMLOG_ACTION_MODIFY) {
			// Update the entry
			this.updateItemInComlogs(objLog);
		}

		if(action == this.COMLOG_ACTION_ADD || this._intCurrentEntry == objLog.intIndex){
			this.loadDetails(null,objLog);
		this.selectComlogByIndex(objLog.intIndex, false);
			if(webapp.communication.mainWidget){
				webapp.communication.mainWidget.reloadContainer();
			}
		}
	},

	//return all details needed to build a contact card (2/3) from the current contact.
	getContactCardParams : function() {
		var objContact = this.getCurrentContact();
		var selectedEntry = this.getSelectedEntry();

		var objContactCard = {};

		//Title
		objContactCard.strTitle = this._strTitle;

		// Call state label
		objContactCard.strCallingStatusLabel = this.getSelectedEntryCallStateLabel();

		if (objContact) {

			objContactCard.objContact = objContact;

			//photo
			objContactCard.strContactPhotoPath = objContact.photo || "";

			// Business details
			objContactCard.strContactCompany = (objContact.miscMap && objContact.miscMap.company) ? objContact.miscMap.company : "";
			objContactCard.strContactPosition = (objContact.miscMap && objContact.miscMap.job) ? objContact.miscMap.job : "";
			objContactCard.strContactLocation = (objContact.miscMap && objContact.miscMap.city) ? objContact.miscMap.city : "";

			//Contact details
			if(selectedEntry.isSupervised){
				objContactCard.arrDetails = this.getSupervisedInfoList(selectedEntry);
			} else {
				objContactCard.arrDetails = this.getContactInfoList(objContact);
			}
		}

		//Call duration
		objContactCard.strCallDuration = this.getStrCallDuration(selectedEntry);

		//Add assistant photo
		if (selectedEntry) {
			objContactCard.strAssistantPhotoPath = selectedEntry.assistantPhoto;
		}

		//Webcam icon
		if(selectedEntry && selectedEntry.objCallData && ((selectedEntry.objCallData.isConnected === 1 || !selectedEntry.objCallData.isLocal) && !selectedEntry.isFiltered) && selectedEntry.intStatus != this.STATUS_CONFERENCE_PARTICIPANT_MENULIST_SELECTED && !selectedEntry.objCallData.isOnHold && !selectedEntry.objCallData.isHeld){
			ICTouchAPI.debugServices.debug("webapp.communication.data.getContactCardParams:  show webcam icon: YES");
			this.boolShowWebCamIcon = true;
		} else {
			ICTouchAPI.debugServices.debug("webapp.communication.data.getContactCardParams:  show webcam icon: NO");
			this.boolShowWebCamIcon = false;
		}

		objContactCard.strPath = "webapp.communication.getContactCard";
		return objContactCard;
	},

	//return all details needed to build a conference card (2/3) from the current contact.
	getConferenceCardParams : function() {
		ICTouchAPI.debugServices.info("webapp.communication.dataBase - getConferenceCardParams");
		//var objContact = this.getCurrentContact();
		var selectedEntry = this.getSelectedEntry();

		// Init variables
		var objCard = {};
		objCard.arrContacts = [];
		var participant;
		var arrContactSummary;
		var i;

		//Title
		objCard.strTitle = this._strTitle;

		// Case of a log object
		if(selectedEntry.objLogData){
			arrContactSummary = selectedEntry.objLogData.listContactSummary;
			for(i = 0 ; i < arrContactSummary.length ; i++){
				ICTouchAPI.debugServices.debug("webapp.communication.dataBase.getConferenceCardParams - use searchContactFromLog to search contact for conference participant " + i + ", use listContactSummary["+i+"].officePhone = " + arrContactSummary[i].officePhone);
				participant = this.getConferenceCardParticipant(this.searchContactFromLog({number:arrContactSummary[i].officePhone}));
				if(participant.strLastName == arrContactSummary[i].officePhone) { // no display name found by searchContactFromLog (contact not in datastore), use info from log
					ICTouchAPI.debugServices.debug("webapp.communication.dataBase.getConferenceCardParams - no display name found by searchContactFromLog, try to use conference participant ["+i+"]");
					if(arrContactSummary[i].name || arrContactSummary[i].firstName) {
						participant.strFirstName = arrContactSummary[i].firstName;
						participant.strLastName = arrContactSummary[i].name;
						ICTouchAPI.debugServices.debug("webapp.communication.dataBase.getConferenceCardParams - no display name found by searchContactFromLog, but arrContactSummary["+i+"] has firstName / name, use it: " + participant.strFirstName + " " + participant.strLastName);
					}
					else if (selectedEntry.objLogData.listDisplayName[i]){
						ICTouchAPI.debugServices.debug("webapp.communication.dataBase.getConferenceCardParams - no display name found by searchContactFromLog and no arrContactSummary name, but listDisplayName["+i+"] exists, use it: " + selectedEntry.objLogData.listDisplayName[i]);
						participant.strLastName = selectedEntry.objLogData.listDisplayName[i];
					}
					else {
						ICTouchAPI.debugServices.debug("webapp.communication.dataBase.getConferenceCardParams - no display name found for conference participant " + i + " and no listDisplayName["+i+"] exists, use listContactSummary["+i+"].officePhone: " + arrContactSummary[i].officePhone);
						participant.strLastName = arrContactSummary[i].officePhone;
					}
				}
				objCard.arrContacts.push(participant);
			}
		} else
		// Case of call objects
		if(selectedEntry.objCallData) {
			var arrParticipants = this.getCallParticipants(selectedEntry.objCallData.callId);
			for(i = 0 ; i < arrParticipants.length ; i++){
				participant = this.getConferenceCardParticipant(this.searchContactFromLog({number:arrParticipants[i].objContact.officePhone}));
				if(!participant.strFirstName && !participant.strLastName){
					participant.strFirstName = arrParticipants[i].objContact.officePhone;
				}
				objCard.arrContacts.push(participant);
			}
		}

		//Call duration
		objCard.strCallDuration = this.getStrCallDuration(selectedEntry);

		//Webcam icon
		if(selectedEntry && selectedEntry.objCallData && ((selectedEntry.objCallData.isConnected === 1 || !selectedEntry.objCallData.isLocal) && !selectedEntry.isFiltered)){
			ICTouchAPI.debugServices.debug("webapp.communication.data.getConferenceCardParams:  show webcam icon: YES");
			this.boolShowWebCamIcon = true;
		} else {
			ICTouchAPI.debugServices.debug("webapp.communication.data.getConferenceCardParams:  show webcam icon: NO");
			this.boolShowWebCamIcon = false;
		}
		
		objCard.strPath = "webapp.communication.getConference";
		return objCard;
	},

	getVideoCardParams : function() {
		var objCard = {};
		var selectedEntry = this.getSelectedEntry();
		objCard.strCallDuration = this.getStrCallDuration(selectedEntry);
		if(selectedEntry && selectedEntry.objCallData) {
			objCard.callId = selectedEntry.objCallData.callId;
			objCard.sipCallId = selectedEntry.objCallData.sipCallId;
			if(selectedEntry.objCallData.videoDirection === this.TELEPHONY_VIDEO_DIRECTION_INCOMING){
				// check if the incomming call is from a doorcam
				if(selectedEntry.objCallData.videoStatus === this.TELEPHONY_VIDEO_STATUS_DOORCAM){
					objCard.pip = 0;
				} else {
					objCard.pip = 2;
				}
			} else {
				objCard.pip = 1;
			}
		}
		objCard.strPath = "webapp.communication.getVideoCard";
		return objCard;
	},

	// return all details needed to build a conference card from several numbers.
	buildCurrentConferenceCard : function(arrNumbers) {
		var objCard = {};
		objCard.arrContacts = [];
		var participant;
		for(var i = 0 ; i < arrNumbers.length ; i++){
			participant = this.getConferenceCardParticipant(this.searchContactFromLog({number:arrNumbers[i]}));
			if(!participant.strFirstName && !participant.strLastName){
				participant.strFirstName = arrNumbers[i];
			}
			objCard.arrContacts.push(participant);
		}
		objCard.strTitle = _("Conference", "webapp.communication");
		objCard.strPath = "webapp.communication.getConference";
		objCard.strCallDuration = "00:00";
		return objCard;
	},

	getConferenceCardParticipant : function(objContact) {
		var participant = {
			strFirstName : objContact.firstName || "",
			strLastName : objContact.name || "",
			strJob : (objContact.miscMap && objContact.miscMap.job) ? objContact.miscMap.job : "",
			strPhotoPath : objContact.photo || ""
		};

		objContact = null;
		return participant;
	},

	//return all details needed to build a contact card from a dialed number.
	buildOutgoingCallContactCard : function(number) {

		//Use the number to retreive the contact
		var objContact = this.searchContactFromLog({number: number});

		var objContactCard = {};
		objContactCard.objContact = objContact;

		//Title
		objContactCard.strTitle = objContact.displayName || ICTouchAPI.tools.getContactDisplayName(objContact);//(objContact.name + " " + objContact.firstName);

		// Call state label
		objContactCard.strCallingStatusLabel = this.lstCallStateLabel[this.STATUS_OUTGOING];

		//photo
		objContactCard.strContactPhotoPath = objContact.photo || "";

		// Business details
		objContactCard.strContactCompany = (objContact.miscMap && objContact.miscMap.company) ? objContact.miscMap.company : "";
		objContactCard.strContactPosition = (objContact.miscMap && objContact.miscMap.job) ? objContact.miscMap.job : "";
		objContactCard.strContactLocation = (objContact.miscMap && objContact.miscMap.city) ? objContact.miscMap.city : "";

		//Call duration: empty
		objContactCard.strCallDuration = "";

		//Contact details
		objContactCard.arrDetails = this.getContactInfoListWithContactLog(objContact);

		number = null;
		return objContactCard;
	},

	// Argument is optional, by default it will take the current selected item's status
	isInActiveConference : function(objLog){
		var status = webapp.communication.getStatus();
		if(objLog) {
			status = objLog.intStatus;
		}
		return (status == this.STATUS_CONFERENCE || status == this.STATUS_CONFERENCE_HOLD || status == this.STATUS_CONFERENCE_INCOMING || status == this.STATUS_CONFERENCE_PARTICIPANT_SELECTED || status == this.STATUS_CONFERENCE_REMOTE_SESSION || status == this.STATUS_CONFERENCE_PARTICIPANT_MENULIST_SELECTED);
	},

	// Argument is optional, by default it will take the current selected item's status
	isInLogConference : function(objLog){
		var status = webapp.communication.getStatus();
		if(objLog) {
			status = objLog.intStatus;
		}
		return (status == this.STATUS_LOG_CONFERENCE || status == this.STATUS_LOG_CONFERENCE_PARTICIPANT_SELECTED);
	},

	isInConference : function(){
		return (this.isInActiveConference() || this.isInLogConference());
	},

	isInVideoCall : function(callId){
		var entry = this.findItemById(callId);

		if(entry && entry.objCallData && entry.objCallData.videoStatus){
			ICTouchAPI.debugServices.debug("webapp.communication.dataBase.isInVideoCall - " + entry.objCallData.videoStatus);
			return entry.objCallData.videoStatus === this.TELEPHONY_VIDEO_STATUS_ON||
					entry.objCallData.videoStatus === this.TELEPHONY_VIDEO_STATUS_DOORCAM;
		} else {
			ICTouchAPI.debugServices.debug("webapp.communication.dataBase.isInVideoCall - false");
			return false;
		}
	},
	
	closeVideoCall : function(callId){
		ICTouchAPI.debugServices.debug("webapp.communication.dataBase.closeVideoCall");
		ICTouchAPI.VideoServices.destroy(callId);
	},

	/*
	 * setShownLogs: this function is called when it was asked to open a transfer /to/ transfer to.
	 */
	setShownLogs : function (bCalls, bLogs, bConf) {
		// Set selectable items for 3rd peer: phone call items whose phone number are not the same as 2nd peer.
		var func = function(item){
			this._setShownLog(item, bCalls, bLogs, bConf)
		};
		this.objActiveComlog.arrItems.forEach(func, this);
		bCalls=null;
		bLogs=null;
		bConf=null;
	},

	_setShownLog : function(item, bCalls, bLogs, bConf){
		item.boolSelectable = false;
		item.boolToHide = true;
		if (item.objCallData) {
			if (this._objFirstSelected && this._objFirstSelected.objCallData && item.objCallData.phoneNumber==this._objFirstSelected.objCallData.phoneNumber) {
				item.boolSelectable = false;
				item.boolToHide = false;
			} else if(bCalls && (item.intStatus != this.STATUS_CONFERENCE || item.intStatus != this.STATUS_CONFERENCE_HOLD || bConf)) {
				item.boolSelectable = true;
				item.boolToHide = false;
			}
		} else if (bLogs && item.objLogData && (!this._objFirstSelected  || (this._objFirstSelected && item.objLogData.listContactSummary && item.objLogData.listContactSummary[0] && item.objLogData.listContactSummary[0].officePhone != this._objFirstSelected.objCallData.phoneNumber))) {
			var log = webapp.communication.getCallLogFromNumber(item.objLogData.listContactSummary[0].officePhone);
			if(!log && (item.objLogData.entryType != ICTouchAPI.tools.enumComLogEntryType.Conference || bConf)) {
				item.boolSelectable = true;
				item.boolToHide = false;
			}
		}
		if(item.boolToHide) {
			this.hideItemById(item.intIndex,"ShownLog",true);
			}
		item=null;
		bCalls=null;
		bLogs=null;
		bConf=null;
	},

	cancelShownStatus : function () {
		this.objActiveComlog.arrItems.forEach(this._cancelShownStatus, this);		
	},

	_cancelShownStatus : function(item){
		if (item.boolToHide && this._objHiddenComlogItems[item.intIndex] && this._objHiddenComlogItems[item.intIndex] == "ShownLog"){
			delete(item.boolToHide);
			delete(item.boolSelectable);
			this.showItemById(item.intIndex,"ShownLog",true);
		}
		item=null;
	},

	addCurrentComIntoLogComlog : function(activeOnly) {
		var arrComItems = [];
		for(var i=0; i<this.objActiveComlog.arrItems.length; i++) {
			if(activeOnly!==true || this.objActiveComlog.arrItems[i].objCallData) {
				arrComItems.push(dojo.clone(this.objActiveComlog.arrItems[i]));
			}
		}
	},

	//Select first active communication
	selectFirstActiveCom : function() {
		var callId = this.findFirstActiveCom();
		var found = false;
		if(callId) {
			this.selectComlogByIndex(callId, true);
			found = true;
		}
		return found;
	},

	// Return the first "active" callId ( => not held or hold ) or null otherwise
	findFirstActiveCom : function() {
		var listCom = this.getPhoneCalls();
		if(listCom.length > 0) {
			for(var i=0; i<listCom.length; i++) {
				if(listCom[i].objCallData.isActive && !listCom[i].objCallData.isOnHold && !listCom[i].objCallData.isHeld) {
					return listCom[i].intIndex;
				}
			}
				}
		return null;
	},

	getNumbersFromActiveCall : function(){
		var results = [];
		var lstActiveCalls = this.getPhoneCalls();
		for (var i = 0 ; i < lstActiveCalls.length ; i++){
			if(!this.isSecondaryItem(lstActiveCalls[i])){
			if(lstActiveCalls[i].objCallData.phoneNumber){
				results.push(lstActiveCalls[i].objCallData.phoneNumber);
			}
			if(lstActiveCalls[i].objCallData.phoneNumberCan && lstActiveCalls[i].objCallData.phoneNumberCan !== lstActiveCalls[i].objCallData.phoneNumber){
				results.push(lstActiveCalls[i].objCallData.phoneNumberCan);
			}
		}
		}
		return results;

	},

	isAvoidCommSwitch : function() {
		return this.boolAvoidCommSwitch || webapp.communication.getSelectStatus()===this.STATUS_PROGKEYS_CALL;
	},

	setAvoidCommSwitch : function(value) {
		this.boolAvoidCommSwitch = value;
	},

	isSecondaryItem : function(item) {
		return this.objActiveComlog.isSecondaryItem(item);
	},
	
	getPrincipalItem : function(item) {
		return this.objActiveComlog.getPrincipalItem(item);
	},
	
	buildSecondaryItemsArray : function(objCall, arrParticipants) {
		var secondaryItemsArray = [];
		
		for (var i = 0 ; i < arrParticipants.length ; i++){
			var item = {
				intIndex: objCall.intIndex+"_"+i,
				intStatus: this.STATUS_CONFERENCE_PARTICIPANT_MENULIST_SELECTED,
				objParticipant: arrParticipants[i],
				objCallData: objCall.objCallData
			};
			var contactName = ICTouchAPI.tools.getContactDisplayName(this.searchContactFromLog(item));
			item.strPrimaryContent = (contactName && contactName !="") ? contactName : ICTouchAPI.tools.getContactDisplayName(item);

                        if(item.objParticipant.anonymous==1) {
                                item.objParticipant.objContact.firstName = _("anonymous","ICTouchAPI");
                                item.objParticipant.objContact.officePhone = _("anonymous","ICTouchAPI");            
                        }

                        if (item.strPrimaryContent.replace(/\s/g,'')==="anonymous" || item.strPrimaryContent.replace(/\s/g,'')==="Anonymous" || item.strPrimaryContent.replace(/\s/g,'')==="***") {   
				item.strPrimaryContent=_("anonymous","ICTouchAPI");
                        }
			secondaryItemsArray.push(item);
		}
		
		objCall.arrSecondaryItems = secondaryItemsArray;
	},

	clickOnVideoButton : function() {
		var data = webapp.communication.data;
		data.boolShowVideo = true;
		data.boolShowWebCamIcon = false;
		var selectedEntry = webapp.communication.data.getSelectedEntry();
		if(selectedEntry && selectedEntry.objCallData && selectedEntry.objCallData.callId && (selectedEntry.objCallData.videoStatus == data.TELEPHONY_VIDEO_STATUS_OFF || selectedEntry.objCallData.videoStatus == data.TELEPHONY_VIDEO_STATUS_FAILED)){
			ICTouchAPI.debugServices.debug("webapp.communication.dataBase - clickOnVideoButton / apiStartSendingVideo");
			webapp.communication.apiStartSendingVideo(selectedEntry.objCallData.callId);
		}
		else if(selectedEntry && selectedEntry.objCallData && selectedEntry.objCallData.callId) {
			ICTouchAPI.debugServices.debug("webapp.communication.dataBase - clickOnVideoButton / show video");
			data.loadDetails(selectedEntry.objCallData.callId);
		}
	},

	updateVideoIcon : function(objCall)  {
		if (this.objVideoTray && this.objVideoTray.appBarUi && this.objVideoTray.appBarUi.getButton("VIDEO_BTN")) {
			if (objCall.videoStatus == "VIDEO_FAILED") {
				this.objVideoTray.appBarUi.getButton("VIDEO_BTN").attr("strButtonIcon","communication-video-ko-restart");
			}
			// This video status is forged when switching to video with a fake objCall
			else if (objCall.videoStatus == "VIDEO_PROCESSING") {
				this.objVideoTray.appBarUi.getButton("VIDEO_BTN").attr("strButtonIcon","communication-video-process");
			}
			else if (objCall.videoStatus == "VIDEO_ON") {
				this.objVideoTray.appBarUi.getButton("VIDEO_BTN").attr("strButtonIcon","communication-video-retrieve-established");
			}
			else {
				this.objVideoTray.appBarUi.getButton("VIDEO_BTN").attr("strButtonIcon","communication-video-start");
			}
		}
		
		objCall = null;
	},

	updateVideoTray : function() {

		var sEntry = this.getSelectedEntry();
		var videoCallStatus = (sEntry && sEntry.objCallData && sEntry.objCallData.videoStatus) ? sEntry.objCallData.videoStatus : null;
		var isActiveCall = (sEntry && sEntry.objCallData && (sEntry.objCallData.isOnHold || sEntry.objCallData.isHeld)) ? false : true;
		if(sEntry && sEntry.objCallData) {
			this.updateVideoIcon(sEntry.objCallData);
		}
		// create the side tray if needed
		if(!this.domST && !this.objVideoTray && (this.boolHasVideoRights || videoCallStatus == this.TELEPHONY_VIDEO_STATUS_ON) && this.boolShowWebCamIcon){
			ICTouchAPI.debugServices.debug("webapp.communication.dataBase - updateVideoTray / create video side tray");

			var videoButton = {
				strButtonName: "VIDEO_BTN",
				strButtonLabel: _("Video", "ICTouchAPI"),
				strButtonIcon: 'communication-video-start',
				callback: webapp.communication.data.clickOnVideoButton
			};

			this.domST = dojo.create('div',null, webapp.communication.mainWidget.domSideTray);
			this.objVideoTray = new UIElements.SideTray.SideTrayControl({objVideoButton : videoButton}, this.domST);
			this.clickOnArrow = dojo.connect(this.objVideoTray.domArrow, 'onclick', this.objVideoTray, 'switchState');
			webapp.communication.mainWidget.domSideTray.style.display = 'block';
		}
	
		// show the side tray if needed
		else if(this.domST && this.objVideoTray && (this.boolHasVideoRights || videoCallStatus == this.TELEPHONY_VIDEO_STATUS_ON) && this.boolShowWebCamIcon && isActiveCall){
			ICTouchAPI.debugServices.debug("webapp.communication.dataBase - updateVideoTray / show video side tray");
			webapp.communication.mainWidget.domSideTray.style.display = 'block';
		}
		
		// hide the side tray if needed
		else if(this.domST && this.objVideoTray){
			ICTouchAPI.debugServices.debug("webapp.communication.dataBase - updateVideoTray / hide video side tray");
			webapp.communication.mainWidget.domSideTray.style.display = 'none';
		}
		else {
			ICTouchAPI.debugServices.debug("webapp.communication.dataBase - updateVideoTray / nothing to do");
		}
	},
	
	removeVideoTray : function() {
		// delete the side tray if needed

		ICTouchAPI.debugServices.debug("webapp.communication.dataBase - removeVideoTray / delete video side tray");
		if(this.clickOnArrow){
			dojo.disconnect(this.clickOnArrow);
			this.clickOnArrow = null;
		}
		if(this.domST){
			dojo.destroy(this.domST);
			this.domST = null;
		}
		if(this.objVideoTray) {
				this.objVideoTray.destroy();
				this.objVideoTray = null;
		}
	}

});
