dojo.provide("webapp.communication.controlBase");
dojo.declare("webapp.communication.controlBase",[ICTouchAPI.webApplication],
{
	_intStatus					: 0,
	_intSelectStatus			: -1,	//Use getSelectStatus and setSelectStatus function
	objPopupConfirmDelete		: null,
	_handlerGetScreen			: null,
	mainWidget					: null,
	comlog						: null,
	uiConferenceList			: null,
	arrIdPopupCall				: [],
	objPopupCall				: null,
	hTimerPopupCall				: null,
	boolDTMFkeyboardOn			: false,
	objBaseView					: null,
	backToHomepageAfterCall		: true,
	_lastDTMF					: null,
	_boolDTMF					: false,
	showKeyboardOnHookOff		: true,
	strDTMFPatern				: null,

	boolNoRefresh : false,
	boolCallInitiated: false,
	boolPickupInitiated: false,
	strCallDuration             : null,
	_handlerTimerOngoingCall    : null,

	// Constant defines for dial-pad action types
	DIALACTION_CALL				: "CALL",
	DIALACTION_CALL_BY_NAME		: "CALL_BY_NAME",
	DIALACTION_CONFERENCE		: "CONFERENCE",
	DIALACTION_TRANSFER			: "TRANSFER",
	DIALACTION_DEFLECT			: "DEFLECT",
	DIALACTION_PROGKEYS_CALL	: "PROGKEYS_CALL",
	DIALACTION_PROGKEYS_ROUTING	: "PROGKEYS_ROUTING",
	DIALACTION_MDR_ROUTING		: "MDR_ROUTING",
	DIALACTION_MDR_OVERFLOW		: "MDR_OVERFLOW",
	DIALACTION_BASIC_ROUTING	: "BASIC_ROUTING",

	// Constant to define the action
	MODIF_MEDIA_VIDEO_START : 'VIDEO_START',
	MODIF_MEDIA_VIDEO_STOP : 'VIDEO_STOP',
	MODIF_MEDIA_VIDEO_NO_ACTION : 'VIDEO_NO_ACTION',
	
	// Array containing the label and icon to display in dialpad (showKeyPad method) or contact card (getContactInfoList method)
	// according to the context (call, STATUS_ADD_PARTICIPANT, STATUS_TRANSFER_TO or STATUS_DEFLECT_TO). Array filled in loaded.
	_arrContextLabelsIcons	: {},

	constructor : function() {
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getContactPreview","webapp.communication",false,true);
		ICTouchAPI.skinServices.linkWebappsStyles("UIElements.Keyboard","webapp.communication",true,true,true);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.userinfo","webapp.communication", true, false, true);

		// register to physicals Keys
		ICTouchAPI.eventServices.subscribeToEvent(this, "SENSKEY_COMM", this.eventPhysicalKeyCom);
		ICTouchAPI.eventServices.subscribeToEvent(this, "SENSKEY_DIAL", this.eventPhysicalKeyDial);
		ICTouchAPI.eventServices.subscribeToEvent(this, "SENSKEY_HOME", this.eventPhysicalKeyHomePage);

		// audio event
		ICTouchAPI.eventServices.subscribeToEvent(this, "audio_key_event", this.eventAudioMute);


		ICTouchAPI.settingServices.subscribeToSetting(this, "ShowKeyboardOnHookOff", this._gotShowKeyboardOnHookOffSetting);
		ICTouchAPI.settingServices.getSetting("ShowKeyboardOnHookOff",this, this._gotShowKeyboardOnHookOffSetting);

		ICTouchAPI.settingServices.subscribeToSetting(this, "BackToHomepageAtEndCall", this._gotBackToHomepage);
		ICTouchAPI.settingServices.getSetting("BackToHomepageAtEndCall",this, this._gotBackToHomepage);

		//Alarm event
		ICTouchAPI.eventServices.subscribeToEvent(this,"AlarmStarted", function(){
			this.data.setNotifyCallByPopup(true);
		});
		ICTouchAPI.eventServices.subscribeToEvent(this,"AlarmStopped", function(){
			this.data.setNotifyCallByPopup(false);
		});
	},
	getApplicationName : function(){
		return "webapp.communication";
	},

	loaded : function() {
		// Fill in the labels of different dialpads
		this._arrContextLabelsIcons[-1] = {
			labelOK: _("Call", "webapp.communication"),
			labelCancel: _("End call","webapp.communication"),
			icon: "communication-call"
		};
		this._arrContextLabelsIcons[this.data.STATUS_ADD_PARTICIPANT] = {
			labelOK: _("Add participant", "webapp.communication"),
			labelCancel: _("Cancel","ICTouchAPI"),
			icon: "communication-conference-add-participant"
		};
		this._arrContextLabelsIcons[this.data.STATUS_TRANSFER_TO] = {
			labelOK: _("Transfer", "webapp.communication"),
			labelCancel: _("Cancel","ICTouchAPI"),
			icon: "communication-deflect-to-default"
		};
		this._arrContextLabelsIcons[this.data.STATUS_DEFLECT_TO] = {
			labelOK: _("Deflect", "webapp.communication"),
			labelCancel: _("Cancel","ICTouchAPI"),
			icon: "communication-transfer-to"
		};
		this._arrContextLabelsIcons[this.data.STATUS_PROGKEYS_CALL] = {
			labelOK: _("Add to favorite", "webapp.progkeys"),
			labelCancel: _("Cancel","ICTouchAPI"),
			icon: "progkeys-add"
		};
		this._arrContextLabelsIcons[this.data.STATUS_PROGKEYS_ROUTING] = {
			labelOK: _("Add to favorite", "webapp.progkeys"),
			labelCancel: _("Cancel","ICTouchAPI"),
			icon: "progkeys-add"
		};

		// Event sent when several capabilities changed at the same time
		ICTouchAPI.CapabilityServices.subscribeToCapabilityList("Telephony", "");

		ICTouchAPI.settingServices.subscribeToSetting(this, "DTMFPattern", this.onDTMFPaternChanged);
		ICTouchAPI.settingServices.getSetting("DTMFPattern", this, this.onDTMFPaternChanged);
		
		// Setting containing the role, i.e manager or assistant.
		ICTouchAPI.settingServices.subscribeToSetting(this, "UserRole", this.onUserRoleChanged);
		ICTouchAPI.settingServices.getSetting("UserRole", this, this.onUserRoleChanged);

		// Preload communications main screen, UserRole only be called when we are sure that the view has been loaded
		ICTouchAPI.transitionServices.preloadScreen({
			name: "webapp.communication.getCommunication",
			params: {}
		});

		// Return to normal state when Conference Failed
		ICTouchAPI.eventServices.subscribeToEvent(this, "ConferenceFailedEvent", this.resetStatus);

		this.arrIdPopupCall[this.data.POPUP_INCOMING] = [];
		this.arrIdPopupCall[this.data.POPUP_ONGOING] = [];

		// Preload 2 main keyboard categorie
		ICTouchAPI.keyboardServices.preloadKeyboard(ICTouchAPI.KeyboardTypes.NUM);
		ICTouchAPI.keyboardServices.preloadKeyboard(ICTouchAPI.KeyboardTypes.ALPHANUM);
		dojo.subscribe("ModeHotel", this.data, this.data.setHotelMode);
		var myDS = ICTouchAPI.dataStoreServices.getStore('contacts');
		myDS.addEventListener(myDS.E_ITEM_UPDATED, this, this.OnContactReceiveDetails);
		this.initNotificationsValue();
		if(webapp.history){
			webapp.history.loaded();
		}
	},

	load : function() {
		//ICTouchAPI.tools.registerHomepageContainer(["webapp.communication.getComlogPreview", this]);
		//this.initNotificationsValue();

		// Subscribe to telephony events
		ICTouchAPI.eventServices.subscribeToEvent(this, "ParticipantsModifiedEvent", this.apiNotifyParticipantModified);
		ICTouchAPI.eventServices.subscribeToEvent(this, "CallModifiedEvent", this.apiNotifyCallModified);
		ICTouchAPI.eventServices.subscribeToEvent(this, "OutgoingCallInitiatedEvent", this.apiNotifyHookOff);
		ICTouchAPI.eventServices.subscribeToEvent(this, "OutgoingCallCancelledEvent", this.apiNotifyNumberingCancelled);
		ICTouchAPI.eventServices.subscribeToEvent(this, "OpenDTMFEvent", this.apiOpenDTMF);
		ICTouchAPI.eventServices.subscribeToEvent(this, "PhoneCallListChanged", this.apiNotifyPhoneCallListChanged);
		ICTouchAPI.eventServices.subscribeToEvent(this, "OutgoingCallAlertingEvent", this.apiNotifyCallModifiedR100);

		// Telephony R100 compatibility events
		//	Note: the goal here is to remove the call to "apiReloadPhoneCalls", and use "apiNotifyCallModified" instead
		//	This can be done as soon as the Telephony module is ready.
		//	Later these events should be completely removed, and "CallModifiedEvent" would be the only event received when a call is modified.
		ICTouchAPI.eventServices.subscribeToEvent(this, "CallStartedEvent", this.apiNotifyCallStarted);
		ICTouchAPI.eventServices.subscribeToEvent(this, "CallEndedEvent", this.apiNotifyCallEnded);
		ICTouchAPI.eventServices.subscribeToEvent(this, "CallConnectedEvent", this.apiNotifyCallConnectedR100);
		ICTouchAPI.eventServices.subscribeToEvent(this, "CallIgnoredEvent", this.apiNotifyCallModifiedR100);
		ICTouchAPI.eventServices.subscribeToEvent(this, "CallHoldEvent", this.apiNotifyCallHoldEvent);
		ICTouchAPI.eventServices.subscribeToEvent(this, "CallHoldRetrievedEvent", this.apiNotifyCallHoldRetrievedEvent);
		ICTouchAPI.eventServices.subscribeToEvent(this, "CallRetrieveFailedEvent", this.apiNotifyCallRetrieveFailedEvent);
		ICTouchAPI.eventServices.subscribeToEvent(this, "CallHeldEvent", this.apiNotifyCallModifiedR100);
		ICTouchAPI.eventServices.subscribeToEvent(this, "CallHeldRetrievedEvent", this.apiNotifyCallModifiedR100);
		ICTouchAPI.eventServices.subscribeToEvent(this, "CallTransferredEvent", this.apiNotifyCallTransferred);
		ICTouchAPI.eventServices.subscribeToEvent(this, "CallBeenTransferredEvent", this.apiNotifyCallBeenTransferedR100);

		// Conference R100 compatibility events
		ICTouchAPI.eventServices.subscribeToEvent(this, "ConferenceStartedEvent", this.apiConferenceStarted);
		ICTouchAPI.eventServices.subscribeToEvent(this, "ConferenceEndedEvent", this.apiConferenceEnded);//this.apiNotifyCallEnded);

		// ManagerAssistant events
		ICTouchAPI.eventServices.subscribeToEvent(this, "NotificationContextCreatedEvent", this.onNotificationContextCreated);
		ICTouchAPI.eventServices.subscribeToEvent(this, "NotificationContextModifiedEvent", this.onNotificationContextModified);
		ICTouchAPI.eventServices.subscribeToEvent(this, "NotificationContextRemovedEvent", this.onNotificationContextRemoved);

		// Subscribe to time format change event
		ICTouchAPI.settingServices.subscribeToSetting(this, "TimeFormat", this.onTimeFormatChanged);
		// Subscribe to date format change event
		ICTouchAPI.settingServices.subscribeToSetting(this, "DateFormat", this.onDateFormatChanged);

		ICTouchAPI.settingServices.getSetting("DateFormat", this, function(objSetting) {
			// save the setting
			if (objSetting !== null){
				this.data._dateFormat = objSetting.allowedValues[objSetting.jsValue].name;
			}
			// get another setting
			ICTouchAPI.settingServices.getSettingValue("TimeFormat", this, function(value) {
				// save the setting
				if(value !== null){
					this.data._24hformat = value;
				}
			});
		});

		// Dojo event fired when clicked on a phone number from contact card
		dojo.subscribe("ContactDataClickedPhone", this, this.onPhoneContact);
		// Dojo event fired when clicked on the extension phone number from contact card
		dojo.subscribe("ContactDataClickedotherPhone", this, this.onPhoneContact);

		// Dojo event when user click on New search button
		dojo.subscribe("search/NewSearch", this, function(boolNewSearch){
			webapp.communication.data.setBoolInitiateByName(boolNewSearch);
		//webapp.communication.data.setNotifyCallByPopup(boolNewSearch);
		});

		dojo.subscribe("communication/switchKeyboard", this, function(switchKeyboard){
			webapp.communication.data.setBoolInitiateByName(switchKeyboard);
		});

		// Dojo event when the number of ongoing call changes
		dojo.subscribe("ongoingCallCountChanged", this, this.ongoingCallNotificationsCountUpdate);

		var context = this;
		var callbackDialer = function(){
			//webapp.communication.data._boolNotifyCallByPopup = true;
			context.showKeyPad({
				searchType: context.DIALACTION_CALL,
				boolInitiatedFromGUI: true,
				boolForceDialpad: true
			});
		};
		ICTouchAPI.tools.registerHomepageButton(["webapp.communication.getCommunication", "DIALER_BTN", "communication-dialer", _("Call","webapp.communication"), null, callbackDialer]);
		ICTouchAPI.tools.registerHomepageKey(["webapp.communication.getCommunication", "DIALER_BTN", "communication-dialer", _("Call","webapp.communication"), null, callbackDialer]);

		// Only add the button if search webapp exist

		//help
		var widgetsTab = [];
		for(var i in webapp.communication.data._arrAppBarSkeleton) {
			widgetsTab.push("comstatus"+i);
		}
		dojo.publish("needHelpEvent",["communication",widgetsTab]);
		if (typeof webapp.search !== "undefined") {
			var callbackByName = function(){
				context.showKeyPad({
					searchType: context.DIALACTION_CALL_BY_NAME,
					boolInitiatedFromGUI: true,
					boolForceByname: true,
					boolInitiateByName: true
				});
			};
			ICTouchAPI.tools.registerHomepageButton(["webapp.communication.getCommunication", "BYNAME_BTN", "generic-search-by-name", _('Search',"ICTouchAPI"), null, callbackByName]);
			ICTouchAPI.tools.registerHomepageKey(["webapp.communication.getCommunication", "BYNAME_BTN", "generic-search-by-name", _('Search',"ICTouchAPI"), null, callbackByName]);
		/*var appBar = ICTouchAPI.AppBarServices._getAppBarWidget("communication", "comstatus" + webapp.communication.data.STATUS_TRANSFER_TO);

			var callbackTransferByName = function(){
				if (typeof webapp.search !== "undefined") {
					//webapp.communication.data._boolNotifyCallByPopup = true;
					webapp.communication.showKeyPad({searchType: webapp.communication.DIALACTION_TRANSFER, boolInitiatedFromGUI: true, boolForceByname: true, boolInitiateByName: true});
				}
			};
			var button = {strButtonName: this.SEARCH, strButtonLabel:_('Search', "ICTouchAPI"), strButtonIcon: 'generic-search-by-name', callback: callbackTransferByName};
			var objButton = new UIElements.AppButton.AppButtonControl(button);
			appBar.addAppButton(objButton);
			appBar.buildDom();*/
		}

		ICTouchAPI.CapabilityServices.subscribeToCapability("Video", "WebcamAvailable", this, this.webcamAvailableCallback);

		// Supervision subscriptions
		dojo.subscribe("supervision.groupModified", this, this.onSupGroupModified);

		if(webapp.history){
			webapp.history.load();
		}
	},

	dump : function(boolAdvancedOption) {
		this.inherited(arguments);
		var i ;
		var data = this.data;
		var entry;
		var idCapabilities;

		if(data.objActiveComlog){
			ICTouchAPI.debugServices.dump("Number of current calls : " + data.objActiveComlog.arrItems.length + (" (data.objActiveComlog.arrItems.length)"));
			ICTouchAPI.debugServices.dump("Global capabilities");
			ICTouchAPI.debugServices.dump(ICTouchAPI.CapabilityServices.getCapabilities("Telephony"));
			if(boolAdvancedOption){
				for(i = 0 ; i < data.objActiveComlog.arrItems.length ; i++){
					ICTouchAPI.debugServices.dump("Call number "+i);
					entry = dojo.clone(data.objActiveComlog.arrItems[i]);
					ICTouchAPI.debugServices.dump(entry.objCallData);
					idCapabilities = entry.objCallData && entry.objCallData.idCapabilities;
					delete entry.objCallData;
					ICTouchAPI.debugServices.dump(entry);
					ICTouchAPI.debugServices.dump("Instance capabilities of call " + i + " with idCapabilities " + idCapabilities);
					ICTouchAPI.debugServices.dump(ICTouchAPI.CapabilityServices.getCapabilities("Telephony", idCapabilities));
				}
			}
		}

		ICTouchAPI.debugServices.dump("Current contact : " + dojo.toJson(data.objCurrentContact));
		ICTouchAPI.debugServices.dump("Enable photo in comlog : " + data.boolEnablePhotoInComlog + " (data.boolEnablePhotoInComlog)");
		ICTouchAPI.debugServices.dump("Hotel mode : " + data.boolHotelMode + " (data.boolHotelMode)");
		ICTouchAPI.debugServices.dump("Manager/assistant role : " + data._userRole + " (data._userRole)");

		ICTouchAPI.debugServices.dump("Back to homepage after call : " + this.backToHomepageAfterCall + data.boolHotelMode + " (this.backToHomepageAfterCall)");

		ICTouchAPI.debugServices.dump("Status : " + this._intStatus + " (this._intStatus)");
		ICTouchAPI.debugServices.dump("Select status : " + this._intSelectStatus + " (this._intSelectStatus)");
		ICTouchAPI.debugServices.dump("AppBar status : " + data.getNumAppBarFromStatus((this._intSelectStatus >= 0) ? this._intSelectStatus : this._intStatus))

		ICTouchAPI.debugServices.dump("Bool Pickup Initiated : " + this.boolPickupInitiated + " (this.boolPickupInitiated)");
		ICTouchAPI.debugServices.dump("Call ID Retrieving : " + this.data.getCallIdRetrieving() + " (this.data.getCallIdRetrieving())");

		if(boolAdvancedOption){
			ICTouchAPI.debugServices.dump("Buffered actions : " + dojo.toJson(data.lstComBufferedAction));
		}
	},

	_gotShowKeyboardOnHookOffSetting : function (objSetting){
		if( objSetting ){
			this.showKeyboardOnHookOff = objSetting.jsValue;
		}
		objSetting=null;
	},

	_gotBackToHomepage : function (objSetting){
		if( objSetting ){
			this.backToHomepageAfterCall = objSetting.jsValue;
		}
		objSetting=null;
	},

	//allows other webapps to add buttons to the Communication webapp
	addButtonForStatus : function(status, button)
	{
		var numAppBar = this.data.getNumAppBarFromStatus(status);
		//var appBar = ICTouchAPI.AppBarServices._getAppBarWidget("communication", "comstatus" + status);
		var objButton = new UIElements.AppButton.AppButtonControl(button);
		ICTouchAPI.AppBarServices.addOtherWebAppButton("communication", "comstatus" + numAppBar, objButton);
		//appBar.addAppButton(objButton,true);
		//appBar.updateAppBar();
		return objButton;
		status=null;
		button=null;
	},

	// CallBack for the physical Key Event HomePage
	eventPhysicalKeyHomePage : function(objEvent) {
		if(!webapp.lock|| !webapp.lock.isLocked()){
			if(objEvent.value !== 0){
				this.hideKeyboard(ICTouchAPI.keyboardServices.CLOSE_ACTION_EXIT);
			}
		}
		objEvent=null;
	},

	// CallBack for the physical Key Event Com
	eventPhysicalKeyCom : function(objEvent) {
		if(!webapp.lock|| !webapp.lock.isLocked()){
			//if we are pressing the button
			if(objEvent.value !== 0){
				if(this.getSelectStatus() === this.data.STATUS_PROGKEYS_CALL) {
					this.resetStatus();
					dojo.publish("OpenHomepage", [{sync: true}]);
				}
				if(this.data.getCountCalls() == 0) {
					this.hideKeyboard(ICTouchAPI.keyboardServices.CLOSE_ACTION_NONE);
					webapp.history.enterHistoryBySenskey();
				}else{
					var intIndex = this.data.objActiveComlog.getCurrentSelectedItem().intIndex;
					webapp.communication.data.loadDetails(intIndex);

					if (this.getSelectStatus() !== -1) { // if we are in a selection mode, setShownLogs and toggleOpacity
						var objSearch = {
							searchType:this.getKeyPadActionFromSelectStatus()
						};
						this.showKeyPad(objSearch);
					}

					// show webapp comm
					ICTouchAPI.transitionServices.getScreen({
						name: "webapp.communication.getCommunication",
						params: {}
					});
				}
			}
			objEvent=null;
		}
	},
	
	// CallBack for the physical Key Event
	eventPhysicalKeyDial : function(objEvent) {
		if(!webapp.lock|| !webapp.lock.isLocked()){
			// If we have the capability and we are pressing (not releasing) the senskey
			if (ICTouchAPI.CapabilityServices.getCapability("Telephony", "makeCall") === ICTouchAPI.CapabilityServices.AVAILABLE && objEvent && objEvent.value !== 0) {
				if(!this.data._boolKeyboardDeployed) {
					// show the pad
					//this.data.dialLed.switchMode('ON');
					if (this.data.getCountCalls() > 0) {
						// get the callId
						this.sendDTMFaction();
					}
					else {
						if(ICTouchAPI.transitionServices.getCurrentScreenName()==="webapp.search.getSearch"){
							if(webapp.search){
								webapp.search.boolPurgeResults = false;
							}
						}
						this.showKeyPad({
							searchType: this.DIALACTION_CALL,
							boolInitiatedFromGUI: true
						});
					}
				} else {
					this.hideKeyboard(ICTouchAPI.keyboardServices.CLOSE_ACTION_EXIT);
				}
			}
		}
		objEvent=null;
	},

	OnContactReceiveDetails : function(objContact){
		var arrPhoneCalls = this.data.getPhoneCalls();
		// Refresh calls where the contact changed.
		for(var i = 0; i < arrPhoneCalls.length ; i++){
			if(arrPhoneCalls[i].objCallData && arrPhoneCalls[i].objCallData.phoneNumber == objContact.officePhone || arrPhoneCalls[i].objCallData.phoneNumber == objContact.personalHome || arrPhoneCalls[i].objCallData.phoneNumber == objContact.personalMobile){
				this.data.refreshEntryById(arrPhoneCalls[i]);
			}
				}
		objContact=null;
	},

	onDTMFPaternChanged : function(objSetting) {
		if(objSetting){
			this.strDTMFPatern = objSetting.jsValue;
		}
		objSetting=null;
	},

	onEnablePhotoInComlogChanged : function(objSetting) {
		if(objSetting){
			this.data.boolEnablePhotoInComlog = objSetting.jsValue;
			this.data.refreshPreview();
		}
		objSetting=null;
	},

	/**
	 * Callback of event NotificationContextCreatedEvent
	 * @params {event:object} NotificationContext
	 */
	onNotificationContextCreated : function(){
		ICTouchAPI.debugServices.info("webapp.communication.controlBase - onNotificationContextCreated");
		if(webapp.managerassistant){
			var objArguments = ICTouchAPI.tools.getEventArguments(arguments);
			var NotificationContext = objArguments.context;
			if(NotificationContext && NotificationContext.participantsList[0]){
				if (NotificationContext.callRef) {
					ICTouchAPI.debugServices.debug("webapp.communication.controlBase - onNotificationContextCreated / NotificationContext added with callRef " + NotificationContext.callRef);
				}
				this.data.addParticipantInCall(NotificationContext.callRef, NotificationContext.participantsList[0]);
				this.data.addInLog(NotificationContext, this.data.COMLOG_FILTERED);
				this.ongoingCallNotificationsUpdate(this.data.findItemById(NotificationContext.callRef));
			}
		}
	},

	/**
	 * Callback of event NotificationContextModifiedEvent
	 * @params {event:object}
	 */
	onNotificationContextModified : function() {
		ICTouchAPI.debugServices.info("webapp.communication.controlBase - onNotificationContextModified");
		if(webapp.managerassistant){
			var objArguments = ICTouchAPI.tools.getEventArguments(arguments);

			var NotificationContext = objArguments.context;
			if(NotificationContext){
				// remove the simulated call in the case the call was taken by assistant while the screen is pre-built (pick-up failed)
				if (this.boolPickupInitiated) {
					this.data.removeFromLog(-1, this.data.COMLOG_CALL, true);
					if (!NotificationContext.previousCallRef) {
						// add again the previous notification to restore the state before the preload of the incoming call screen after a pickup action
						this.data.addInLog(NotificationContext, this.data.COMLOG_FILTERED);
					}
					this.boolPickupInitiated = false;
				}
				if(NotificationContext.previousCallRef !== null && NotificationContext.previousCallRef !== undefined && NotificationContext.previousCallRef !== ""){
					ICTouchAPI.debugServices.debug("webapp.communication.controlBase - onNotificationContextModified / NotificationContext has changed, previousCallRef is " + NotificationContext.callRef + ", new callRef is " + NotificationContext.callRef);
					// Callref has changed, remove the old comLogEntry
					this.data.removeAllParticipantsInCall(NotificationContext.previousCallRef);
					if(this.data.removeFromLog(NotificationContext.previousCallRef, this.data.COMLOG_FILTERED, true)){
						// Then add a new entry with the new Callref
						if(NotificationContext.participantsList[0]){
							this.data.addParticipantInCall(NotificationContext.callRef, NotificationContext.participantsList[0]);
						}
						this.data.addInLog(NotificationContext, this.data.COMLOG_FILTERED);
						this.ongoingCallNotificationsUpdate(this.data.findItemById(NotificationContext.callRef));
					}
				} else {
					// Normal case, Callref did not change
					ICTouchAPI.debugServices.debug("webapp.communication.controlBase - onNotificationContextModified / NotificationContext modified for callRef " + NotificationContext.callRef);
					if(NotificationContext.participantsList[0]){
						this.data.modifyParticipantInCall(NotificationContext.callRef, NotificationContext.participantsList[0]);
					}
					this.data.modifyInLog(NotificationContext, this.data.COMLOG_FILTERED);
					this.ongoingCallNotificationsUpdate(this.data.findItemById(NotificationContext.callRef));
				// Select the appropriated entry after having removed the notification context, if it was a pre-built entry that have been removed (id -1)
				this.selectEntryAfterCallRemoved();
			}
		}
		}
	},

	/**
	 * Callback of event NotificationContextRemovedEvent
	 * @params {event:object}
	 */
	onNotificationContextRemoved : function() {
		ICTouchAPI.debugServices.info("webapp.communication.controlBase - onNotificationContextRemoved");
		var objArguments = ICTouchAPI.tools.getEventArguments(arguments);
		this.data.setTelephonyDontRefresh(objArguments.dontRefresh);
		if (this.boolPickupInitiated) {		
			this.data.removeFromLog(-1, this.data.COMLOG_CALL, true);
			this.boolPickupInitiated = false;
		}
		if(webapp.managerassistant){
			var callRef = objArguments.callRef;
			if(this.data.findItemById(callRef/*, this.data.COMLOG_LIST_CALL*/)){
				this.switchBackOnNComm(1);
				if(callRef){
					ICTouchAPI.debugServices.debug("webapp.communication.controlBase - onNotificationContextRemoved / NotificationContext removed with callRef " + callRef);
					this.data.removeAllParticipantsInCall(callRef);
					this.data.removeFromLog(callRef, this.data.COMLOG_FILTERED, true);
					// Select the appropriated entry after having removed the notification context, if this one was selected before been removed
					if(!objArguments.dontRefresh){
						this.selectEntryAfterCallRemoved();
					}
				}
			}
		}
	},

	selectEntryAfterCallRemoved : function() {
		ICTouchAPI.debugServices.info("webapp.communication.controlBase - selectEntryAfterCallRemoved");
		if(this.data.getCountCalls() == 0) {
			ICTouchAPI.ledServices.desactivate('communication','ONGOING_CALL');
		}
		// Select the right entry if the call removed was the one selected
		var firstSelectableEntryId = this.data.findFirstActiveCom() || this.data.findFirstSelectableItem();
		if(this.data.getNbItems() === 0 || firstSelectableEntryId === null){
			this.data.loadDetails(undefined);
		} else {
			//Show details of the first selectable entry
			this.data.selectComlogByIndex(firstSelectableEntryId, true);
		}
	},

	onPhoneContact : function(objEntry, objContact, boolDoDialableNumber) {
		var number = objEntry.strContent.replace(/\s/g,'');
		var phoneCall = this.getCallLogFromNumber(number);
		var doDialableNumber = (boolDoDialableNumber === false)? false:true;

		if(phoneCall){
			if(phoneCall.intStatus == this.data.STATUS_INCOMING) {
				this.apiAnswerCall(phoneCall.intIndex);
			}
		} else {
			this.doContextStatusCall(number, doDialableNumber, objContact, objEntry);
			if(this.isSelectStatusMDR()){
				ICTouchAPI.transitionServices.back();
			}else{
				ICTouchAPI.transitionServices.getScreen({
					name: "webapp.communication.getCommunication",
					params: {}
				});
			}
		}
		objEntry=null;
		objContact=null;
	},

	onPresentationListClick : function(objEntry) {
		dojo.publish("ContactDataClicked" + objEntry.strType, [objEntry, "webapp.communication", this.data.getCurrentContact()]);
		objEntry=null;
	},

	clearSecurityTimeout : function(){
		if(this.data.updateAppBarSecurityFct){
			clearTimeout(this.data.updateAppBarSecurityFct);
		}
	},
	
	updateAppBar: function()
	{
		ICTouchAPI.debugServices.info("webapp.communication.controlBase - updateAppBar");
		var status;
		if(this.data.getCallIdRetrieving() !== null || this.boolPickupInitiated){
			status = this.data.STATUS_EMPTY_BAR;
			//Launch security timeout to avoid to be stuck in empty appbar
			this.data.updateAppBarSecurityFct = setTimeout(function(){
				webapp.communication.boolPickupInitiated = false;
				webapp.communication.data.clearCallIdRetrieving(webapp.communication.data.getCallIdRetrieving());
				webapp.communication.clearSecurityTimeout();
			}, 10000);

		} else {
			this.clearSecurityTimeout();
			status = (this._intSelectStatus >= 0) ? this._intSelectStatus : this._intStatus;
		}
		// Register action bars according to state
		var numAppBar = this.data.getNumAppBarFromStatus(status);
		var isProgkey = this.isSelectStatusProgkey();
		var isMDR = this.isSelectStatusMDR();
		var backFunc;
		if(isProgkey || isMDR) {
			if(isProgkey){
				backFunc = {
					context: webapp.communication,
					func: function(){
						if(webapp.progkeys) {
							webapp.progkeys.externalBack();
						} else {
							ICTouchAPI.transitionServices.back();
						}
					},
					param: this.BACK
				};
			}else if(isMDR){
				backFunc = {
					context: webapp.communication,
					func: function(){
						ICTouchAPI.transitionServices.back();
					},
					param: this.BACK
				};
			}
		} else {
			backFunc = {
				context: webapp.communication,
				func: webapp.communication.buttonCallback,
				param: this.BACK
			};
		}
		ICTouchAPI.AppBarServices.addExitButton("communication", "comstatus" + numAppBar, !isProgkey, backFunc);
		ICTouchAPI.AppBarServices.setAppBar("communication", "comstatus"+numAppBar, "getCommunication");
		var appBar = ICTouchAPI.AppBarServices._getAppBarWidget("communication", "comstatus" + numAppBar);
		if(appBar) {
			appBar._checkArrows();
			this.updateAppButtons(appBar);
		}
		dojo.publish("ManageExternalButtonsCom", [this.data.getCurrentContact(), this.getStatus()]);
	},

	updateAppButtons: function(objActionBar)
	{
		ICTouchAPI.debugServices.info("webapp.communication.controlBase - updateAppButtons");

		// Update buttons according to current instance's capabilities
		var selectedEntry = this.data.getSelectedEntry();
		if( this.data.getSelectedEntryId() === undefined || selectedEntry === undefined){
				return;
		}
		if(! selectedEntry.objCallData){
			return;
		}
		var instanceId = selectedEntry.objCallData && selectedEntry.objCallData.idCapabilities;
		if (instanceId === undefined || instanceId === -1){
			return;
		}
		var arrButtons = objActionBar.getAllButtons();
		var objButton;
		for (var i in arrButtons)
		{
			objButton = arrButtons[i];
			//Use capabilities instance to show/hide buttons
			if (objButton.arrCapabilities && objButton.arrCapabilities.length) {
				objButton.reconnectCapabilitiesToInstance("Telephony", instanceId);
			}
			//The IGNORE button is managed locally (no capa): hidden when user clicks on it. here the button is reseted.
			else if (objButton.strButtonName === this.data.IGNORE ) {
				if (selectedEntry.ignoredCall) {
					objButton.hide();
				}
				else {
					objButton.show();
				}
			}
		}
		var arrOtherWebappButtons = objActionBar.getAllOtherWebappButtons();
		for (var j in arrOtherWebappButtons)
		{
			objButton = arrOtherWebappButtons[j];
			if (objButton.arrCapabilities) {
				objButton.reconnectCapabilitiesToInstance("Telephony", instanceId);
			}
		}
		objActionBar=null;
	},

	apiOpenDTMF : function() {
		this.sendDTMFaction();
	},

	apiCall: function(number, boolDoDialableNumber, boolKeepContactCard) {
		ICTouchAPI.debugServices.debug("webapp.communication.controlBase - apiCall $ input function params | number: " + number + " | boolDoDialableNumber: " + boolDoDialableNumber + " | boolKeepContactCard: " + boolKeepContactCard);

		if(!number || number==='') {
			ICTouchAPI.debugServices.warning("webapp.communication.controlBase - apiCall / No phone number provided, return.");
			return;
		}
		// Convert the optional parameter 'boolDoDialableNumber' if required
		// (it must be a boolean for beeing used in startPhoneCall function)
		var doDialableNumber = (boolDoDialableNumber)?true:false;

		var boolDTMF = false;
		if(number.indexOf(this.strDTMFPatern) === 0){
			boolDTMF = true;
			number = number.substr(this.strDTMFPatern.length, number.length - this.strDTMFPatern.length);
		}
		if (ICTouchAPI.CapabilityServices.getCapability("Telephony", "makeCall") == ICTouchAPI.CapabilityServices.AVAILABLE) {
			//Pre build the screen using a dummy phoneCall.
			if (!this.boolCallInitiated) {
				this.data.addSimulatedItemInLog(number);
				this.boolCallInitiated = true;
			}
			// Call the startPhoneCall function with the parameter boolDoDialableNumber
			// (true/false: call or not the numbering library to convert the phone number to a number that fits to the numbering plan)
			ICTouchAPI.APIServices.Telephony.startPhoneCall({
				params:[number, false, doDialableNumber, boolDTMF],
				context:this
			}) ;
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.communication.controlBase - apiCall / Can't call " + number + " because capability is not available.");
		}
		number=null;
		boolDoDialableNumber=null;
		boolKeepContactCard=null;
	},

	apiEndCall: function(callId) {
		ICTouchAPI.APIServices.Telephony.stopPhoneCall({
			params:[callId],
			context:this
		} ) ;
		callId=null;
	},

	apiAnswerCall: function(callId) {
		ICTouchAPI.APIServices.Telephony.answerPhoneCall({
			params:[callId, false],
			context:this
		});
		callId=null;
	},

	apiIgnoreCall: function(callId) {

		var data = this.data;

		// get the current call
		var currentCall = this.data.findItemById(callId, this.data.COMLOG_LIST_CALL);

		//Hide Ignore buttons
		var appBar = ICTouchAPI.AppBarServices.getAppBar("communication", "comstatus" + data.STATUS_INCOMING);
		appBar.getButton(data.IGNORE).hide();
		appBar = ICTouchAPI.AppBarServices.getAppBar("communication", "comstatus" + data.STATUS_CONFERENCE_INCOMING);
		appBar.getButton(data.IGNORE).hide();

		//Flag the call as ignored.
		currentCall.ignoredCall = true;

		// ignore
		ICTouchAPI.APIServices.Telephony.ignoreCall({
			params:[callId],
			context:this
		}) ;
		callId=null;
	},

	apiRejectCall: function(callId) {
		// reject
		ICTouchAPI.APIServices.Telephony.rejectCall({
			params:[callId],
			context:this
		});
		callId=null;
	},

	apiRequestCallBack: function(callId) {
		// request callback
		ICTouchAPI.APIServices.Telephony.requestCallBack({
			params:[callId],
			context:this
		});
		callId=null;
	},

	apiOverflowToVM: function(callId) {
		ICTouchAPI.APIServices.Telephony.overflowToVM({
			params:[callId],
			context:this
		});
		callId=null;
	},

	apiDeflectToDVA: function(callId) {
		ICTouchAPI.APIServices.Telephony.deflectToDVA({
			params:[callId],
			context:this
		});
		callId=null;
	},

	apiDeflectToVM: function(callId) {
		ICTouchAPI.APIServices.Telephony.deflectToVM({
			params:[callId],
			context:this
		});
		callId=null;
	},

	apiStartRecording: function(callId) {
		ICTouchAPI.APIServices.Telephony.startCallRecording({
			params:[callId],
			context:this
		});
		callId=null;
	},

	apiPauseRecording: function(callId) {
		ICTouchAPI.APIServices.Telephony.pauseCallRecording({
			params:[callId],
			context:this
		});
		callId=null;
	},

	apiResumeRecording: function(callId) {
		ICTouchAPI.APIServices.Telephony.resumeCallRecording({
			params:[callId],
			context:this
		});
	},

	apiStopRecording: function(callId) {
		ICTouchAPI.APIServices.Telephony.stopCallRecording({
			params:[callId],
			context:this
		});
		callId=null;
	},

	apiNotifyParticipantModified : function() {
		ICTouchAPI.debugServices.info("webapp.communication.controlBase - apiNotifyParticipantModified");
		var args = ICTouchAPI.tools.getEventArguments(arguments);
		var action = args.type;
		var participants = args.participants;
		var phoneCallId = args.callId.value;
		var boolNoRefresh = args.dontRefresh;
		ICTouchAPI.debugServices.debug("webapp.communication.controlBase - apiNotifyParticipantModified / Participant modified for call with id " + phoneCallId + ", boolNoRefresh is: " + boolNoRefresh);
		//boolNoRefresh = this.boolNoRefresh;
		var acted = true;
		var i;

		this.data.setTelephonyDontRefresh(boolNoRefresh);
		//var participantNb = this.data.getCallParticipants(phoneCallId).length;
		ICTouchAPI.debugServices.debug("webapp.communication.controlBase - apiNotifyParticipantModified / Action is : " + action);
		switch (action){
			case "added":
				for(i in participants){
					this.data.addParticipantInCall(phoneCallId, participants[i]);
				}
				break;
			case "modified":
				for(i in participants) {
					this.data.modifyParticipantInCall(phoneCallId, participants[i]);
				}
				break;
			case "removed":
				for(i in participants) {
					this.data.removeParticipantInCall(phoneCallId, participants[i]);
				}
				break;
			default:
				acted = false;
				break;
		}
		if (acted){
			var phoneCall = args.phoneCall;
			var arrParticipants = this.data.getCallParticipants(phoneCallId);
			if(phoneCall){
				if(phoneCall.isConference) {
					if(arrParticipants.length === 1){
						phoneCall.isConference = false;
					}
				}
				for (i in arrParticipants) {
					arrParticipants[i].conference = phoneCall.isConference;
				}
			}

			this.data.modifyInLog(phoneCall, this.data.COMLOG_CALL);
		}
	},

	apiNotifyCallStarted : function() {
		ICTouchAPI.debugServices.info("webapp.communication.controlBase - apiNotifyCallStarted");
		var args = ICTouchAPI.tools.getEventArguments(arguments);
		var objCall = args.phoneCall;
		var bNoRefresh = args.dontRefresh;
		if (objCall && objCall.callId) {
			ICTouchAPI.debugServices.debug("webapp.communication.controlBase - apiNotifyCallStarted / Call started with id " + objCall.callId);
		}
		var data = webapp.communication.data;

		this.data.setTelephonyDontRefresh(bNoRefresh);

		data._intLastSelected = 0;

		if (this.boolCallInitiated || this.boolPickupInitiated) {
			data.removeFromLog(-1, this.data.COMLOG_CALL, true);
			this.boolCallInitiated = false;
			this.boolPickupInitiated = false;
		}
		
		var objFormattedCall = data.addInLog(objCall, this.data.COMLOG_CALL);

		if(!bNoRefresh){
			var isUnlocked = (!webapp.lock|| !webapp.lock.isLocked());
			if(isUnlocked){
				if (this.data.getNbActiveCalls() === 1) {
					this.data.boolWasInHistoryBeforeCall = (ICTouchAPI.transitionServices.getCurrentScreenName().indexOf("webapp.communication") != -1);
					ICTouchAPI.debugServices.debug("webapp.communication.controlBase - apiNotifyCallStarted / Screen when first call arrived: " + ICTouchAPI.transitionServices.getCurrentScreenName() + ", boolWasInHistoryBeforeCall: " + this.data.boolWasInHistoryBeforeCall);
				}
				if(this.data.getCountCalls() > 0) {
					ICTouchAPI.ledServices.activate('communication','ONGOING_CALL');
				}
				var isIncomingCall = (objFormattedCall.intStatus === this.data.STATUS_INCOMING || objFormattedCall.intStatus === this.data.STATUS_CONFERENCE_INCOMING);
				if (!isIncomingCall || (!ICTouchAPI.keyboardServices.isKeyboardDisplayed() && !data.getNotifyCallByPopup() && !data.isAvoidCommSwitch())) {
					if(this.isSelectStatusMDR()/* || this.isSelectStatusProgkey()*/){
						this.setSelectStatus(objFormattedCall.intStatus);
						this.updateAppBar();
					}
					ICTouchAPI.toasterServices.hideAll();
					ICTouchAPI.transitionServices.getScreen({
						name: "webapp.communication.getCommunication",
						sync:true,
						params: {}
					});
				}
			}
		}
		objCall=null;
	},

	apiNotifyCallModified : function() {
		ICTouchAPI.debugServices.info("webapp.communication.controlBase - apiNotifyCallModified");
		var objArguments = ICTouchAPI.tools.getEventArguments(arguments);
		var objCall = objArguments.phoneCall;
		var data = webapp.communication.data;
		var bNoRefresh = objArguments.dontRefresh;

		this.data.setTelephonyDontRefresh(bNoRefresh);
		
		if (objCall && objCall.callId) {
			ICTouchAPI.debugServices.debug("webapp.communication.controlBase - apiNotifyCallModified: Call modify with id " + objCall.callId);

			data.modifyInLog(objCall, this.data.COMLOG_CALL);/*
			else {
				// Update the webcam icon if there is a communication failure
				if (this.data.getCurrentEntry() == objCall.callId && this.data.objContactCard) {
					this.data.updateVideoIcon(objCall);
				}
				this.ongoingCallNotificationsUpdate(this.data.findItemById(objCall.callId));
			}*/
		}
	},

	apiNotifyPhoneCallListChanged : function() {
		ICTouchAPI.debugServices.info("webapp.communication.controlBase - apiNotifyPhoneCallListChanged");
		// Keep this comment, it may be usefull one day. That retrieves every arguments of the event.
		var data = this.data;
		var objArguments = ICTouchAPI.tools.getEventArguments(arguments);
		var arrPhoneCall = objArguments.listPhoneCall;
		var arrActiveCalls = data.getPhoneCalls();
		var boolCallFound;
		var i, j;

		// Be sure we are in a safe state before launching the synchro.
		data.setTelephonyDontRefresh(false);
		this.doStackedActions();

		// Check is calls are not present anymore
		for (i = 0 ; i < arrActiveCalls.length ; i++) {
			if(!data.isSecondaryItem(arrActiveCalls[i])){
			boolCallFound = false;
			for (j = 0 ; j < arrPhoneCall.length ; j++) {
					if (arrActiveCalls[i].intIndex == arrPhoneCall[j].callId) {
					boolCallFound = true;
					break;
				}
			}
			if (!boolCallFound) { // active call is not present anymore, remove it
				data.addInComBuffer({
					actionType : data.COMLOG_ACTION_REMOVE,
					logType : data.COMLOG_CALL,
					id : arrActiveCalls[i].objCallData.callId,
					bNoRefresh : false
				});
			}
		}
		}
		// Update ongoing calls / add if was not present
		for (i = 0 ; i < arrPhoneCall.length ; i++) {
			if (data.findItemById(arrPhoneCall[i].callId)) {
				data.addInComBuffer({
					actionType : data.COMLOG_ACTION_MODIFY,
					logType : data.COMLOG_CALL,
					id : arrPhoneCall[i].callId,
					item : arrPhoneCall[i]
				});
			}
			else {
				data.addInComBuffer({
					actionType : data.COMLOG_ACTION_ADD,
					logType : data.COMLOG_CALL,
					id : arrPhoneCall[i].callId,
					item : arrPhoneCall[i]
				});
			}
		}
		this.doStackedActions();
	},

	// boolNoRefresh is optionnal. It overrides the "no refresh" state of the buffered action.
	doStackedActions : function(boolNoRefresh) {
		ICTouchAPI.debugServices.info("webapp.communication.controlBase - doStackedActions");
		var data = webapp.communication.data;
		var lstComBuffer = data.getComBuffer();
		var itemToUnstack;
		var bNoRefresh;
		var boolUnstacked = false;
		var boolAdded = false;

		data.bStackedAction = false;
		
		for(var i in lstComBuffer){
			boolUnstacked = true;
			itemToUnstack = lstComBuffer[i];
			if(itemToUnstack.actionType == data.COMLOG_ACTION_ADD){
				data.addInLog(itemToUnstack.item, itemToUnstack.logType);
				boolAdded = true;
			} else if(itemToUnstack.actionType == data.COMLOG_ACTION_MODIFY){
				data.modifyInLog(itemToUnstack.item, itemToUnstack.logType);
			} else if(itemToUnstack.actionType == data.COMLOG_ACTION_REMOVE){
				if(typeof boolNoRefresh == "boolean"){
					bNoRefresh = boolNoRefresh;
				} else {
					bNoRefresh = itemToUnstack.bNoRefresh;
				}
				data.removeFromLog(itemToUnstack.id, itemToUnstack.logType, bNoRefresh);
			}
			delete lstComBuffer[i];
		}

		if(boolUnstacked){
		//Select active communication or otherwise first communication when no entry is selected
		var listCom = this.data.getPhoneCalls();
		var found = false;
		for(i=0; i<listCom.length; i++) {
			if(listCom[i].bSelect) {
				found = true;
				break;
			}
		}
		if(found === false && !this.data.isAvoidCommSwitch()) {
			this.data.selectFirstActiveCom(true);
		}
			this.ongoingCallNotificationsUpdate(this.data.findItemByPosition(0));
			if(boolAdded && !this.data.isAvoidCommSwitch()){
				ICTouchAPI.transitionServices.getScreen({
					name: "webapp.communication.getCommunication",
					params: {}
				});
			}
		}

		
	},

	apiNotifyCallModifiedR100 : function() {
		ICTouchAPI.debugServices.info("webapp.communication.controlBase - apiNotifyCallModifiedR100");
		var args = ICTouchAPI.tools.getEventArguments(arguments);
		var objCall = args.phoneCall;
		var bNoRefresh = args.dontRefresh;
		if (objCall && objCall.callId) {
			ICTouchAPI.debugServices.debug("webapp.communication.controlBase - apiNotifyCallModifiedR100 / Call modify R100 with id " + objCall.callId);
		}
		var data = webapp.communication.data;

		this.data.setTelephonyDontRefresh(bNoRefresh);
		
		if(objCall!=null && objCall.isOnHold){
			var appBar = ICTouchAPI.AppBarServices._getAppBarWidget("communication", "comstatus" + data.STATUS_HOLD);
			var appButton = appBar.getButton(data.RETRIEVE);
			if(appButton){
				appButton.show();
			}
			//Display the hold contact card
			webapp.communication.mainWidget.setContactCardHoldStatus();
		}
		
		data.modifyInLog(objCall, this.data.COMLOG_CALL);
		
	},

	apiNotifyCallConnectedR100 : function() {
		ICTouchAPI.debugServices.info("webapp.communication.controlBase - apiNotifyCallConnectedR100");
		var args = ICTouchAPI.tools.getEventArguments(arguments);
		var objCall = args.phoneCall;
		if (objCall && objCall.callId) {
			ICTouchAPI.debugServices.debug("webapp.communication.controlBase - apiNotifyCallConnectedR100 / Call connected R100 with id " + objCall.callId);
		}
		var bDTMF = args.bDTMF;
		var bNoRefresh = args.dontRefresh;
		//bNoRefresh = this.boolNoRefresh;
		var data = webapp.communication.data;

		if(bDTMF){
			this.sendDTMFaction();
		}
		if(webapp.voicemail) {
			webapp.voicemail.checkAndStopMessage();
		}

		this.data.setTelephonyDontRefresh(bNoRefresh);

		data.modifyInLog(objCall, this.data.COMLOG_CALL);
		/*if(webapp.communication.data.objVideoTray){
			webapp.communication.data.objVideoTray.openTray();
		}*/
	},

	ongoingCallNotificationsUpdate : function(objCall) {
		// Update the state of the TopBar call notification
		if(objCall) {
			var objNotificationLabel = this.data._callNotificationLabel(objCall);

			var objNotification = {
				strNotificationType: this.data._callNotificationType(objCall.intStatus),
				strNotificationLabelIcon: this.data._callNotificationIcon(objCall.intStatus),
				strNotificationLabel: objNotificationLabel.strLabel,
				strNotificationLabelBottom: objNotificationLabel.strLabelBottom,
				arrNotificationIconBottom: objNotificationLabel.arrIconBottom,
				callId : objCall.intIndex
			//intNotificationValue: this.data.getCountCalls()
			};

			ICTouchAPI.notificationServices.refreshNotification("OngoingCall", objNotification);
		//ICTouchAPI.notificationServices.setNotificationValue("OngoingCall",this.data.getCountCalls());
		}
		objCall = null;
	},

	apiNotifyCallBeenTransferedR100 : function(){
		ICTouchAPI.debugServices.info("webapp.communication.controlBase - apiNotifyCallBeenTransferedR100");
		var args = ICTouchAPI.tools.getEventArguments(arguments);
		var oldObjCall = args.oldPhoneCall;
		var newObjCall = args.newPhoneCall;
		var bNoRefresh = args.dontRefresh;
		if (oldObjCall && oldObjCall.callId && newObjCall && newObjCall.callId) {
			ICTouchAPI.debugServices.debug("webapp.communication.controlBase - apiNotifyCallBeenTransferedR100 / Call been transferted R100 from id " + oldObjCall.callId + " to id " + newObjCall.callId + ", bNoRefresh is " + bNoRefresh);
		}

		this.data.setTelephonyDontRefresh(bNoRefresh);

		this.data.replaceInLog(oldObjCall,newObjCall);

	},

	// Fired after you initiated a transfer, simply end the two calls.
	apiNotifyCallTransferred : function() {
		ICTouchAPI.debugServices.info("webapp.communication.controlBase - apiNotifyCallTransferred");
		var objArguments = ICTouchAPI.tools.getEventArguments(arguments);
		var callId1 = objArguments.callId1 && objArguments.callId1.value;
		var callId2 = objArguments.callId2 && objArguments.callId2.value;
		this._notifyCallEnded(callId1, false);
		this._notifyCallEnded(callId2, false);
	},

	apiNotifyCallEnded : function() {
		ICTouchAPI.debugServices.info("webapp.communication.controlBase - apiNotifyCallEnded");
		var objArguments = ICTouchAPI.tools.getEventArguments(arguments);
		var objCall = objArguments.phoneCall;
		if (objCall && objCall.callId) {
			ICTouchAPI.debugServices.debug("webapp.communication.controlBase - apiNotifyCallEnded / Call ended with id " + objCall.callId);

		var boolNoRefresh = objArguments.dontRefresh;

			this._notifyCallEnded(objCall.callId, boolNoRefresh)
		} else {
			ICTouchAPI.debugServices.warning("webapp.communication.controlBase - apiNotifyCallEnded / No call in parameter");
		}
		
		objCall=null;
	},

	_notifyCallEnded : function(callId, boolNoRefresh) {
		this.data.setTelephonyDontRefresh(boolNoRefresh);

		var currentScreenName = ICTouchAPI.transitionServices.getCurrentScreenName().match("^webapp\.communication");
		if (currentScreenName!=null) {
			this.hideKeyboard(ICTouchAPI.keyboardServices.CLOSE_ACTION_EXIT);
		}

		this.stopTimerOngoing();
		if(this.getSelectStatus() !== this.data.STATUS_PROGKEYS_CALL) {
			//Go to home page in first
			this.switchBackOnNComm(1/*The released call*/);
		}

		if (this.data.removeFromLog(callId, this.data.COMLOG_CALL, true)) {
			this.selectEntryAfterCallRemoved();
		}

		delete this.data._arrParticipantsByCall[callId];

		webapp.communication.data.removeVideoTray();
		webapp.communication.data.boolShowVideo = true;
		boolNoRefresh = null;
		callId = null;
	},

	apiNotifyCallHoldRetrievedEvent : function() {
		ICTouchAPI.debugServices.info("webapp.communication.controlBase - apiNotifyCallHoldRetrievedEvent");
		var args = ICTouchAPI.tools.getEventArguments(arguments);
		var objCall = args.phoneCall;

		this.data.clearCallIdRetrieving(objCall.callId);

		this.apiNotifyCallModifiedR100.apply(this, arguments);
	},

	apiNotifyCallRetrieveFailedEvent : function() {
		ICTouchAPI.debugServices.info("webapp.communication.controlBase - apiNotifyCallRetrieveFailedEvent");
		var args = ICTouchAPI.tools.getEventArguments(arguments);
		var objCall = args.phoneCall;
		if (objCall && objCall.callId) {
			ICTouchAPI.debugServices.debug("webapp.communication.controlBase - apiNotifyCallRetrieveFailedEvent / Call retrieve failed for id " + objCall.callId);
		}

		this.data.clearCallIdRetrieving(objCall.callId);
	},

	apiNotifyCallHoldEvent : function() {
		ICTouchAPI.debugServices.info("webapp.communication.controlBase - apiNotifyCallHoldEvent");
		var args = ICTouchAPI.tools.getEventArguments(arguments);
		var objCall = args.phoneCall;
		if (objCall && objCall.callId) {
			ICTouchAPI.debugServices.debug("webapp.communication.controlBase - apiNotifyCallHoldEvent / Call hold for id " + objCall.callId);
		}

		this.data.clearCallIdRetrieving(objCall.callId);

		this.apiNotifyCallModifiedR100.apply(this, arguments);
	},

	// Go back or on homepage (according to a setting) if comm number is equal to nbCom
	switchBackOnNComm : function (nbCom){
		if(ICTouchAPI.transitionServices.getCurrentScreenName().indexOf("webapp.communication") != -1 && this.data.getCountCalls() === nbCom){
				if (this.backToHomepageAfterCall){
					dojo.publish("OpenHomepage", [{
						sync: true
					}]);
			}
			else {
					var isStealthedCom = ICTouchAPI.transitionServices.isstealth("webapp.communication.getCommunication");
					ICTouchAPI.transitionServices.stealth("webapp.communication.getCommunication");
					ICTouchAPI.transitionServices.back();
					if(!isStealthedCom) {
						ICTouchAPI.transitionServices.unstealth("webapp.communication.getCommunication");
					}
				}
			}
	},

	// This function is called when a call was initiated but not connected
	apiNotifyNumberingCancelled: function() {
		if( this.data._boolKeyboardDeployed ){
			this.hideKeyboard(ICTouchAPI.keyboardServices.CLOSE_ACTION_NONE);
		}
	},

	apiNotifyHookOff: function() {
		// Show the keypad only if a call is not beeing initiated (avoid the problem described in crms00364407)
		if (!this.boolCallInitiated) {
			// Save current screen and listen to ICTouchAPI.transitionServices.getScreen to know if the screen did change
			// Joel : do not change screen here to speed up hook-off process (feature asked by opt.team)
			if (!this.showKeyboardOnHookOff){
				ICTouchAPI.APIServices.Telephony.initiateOutgoingCallBO({});
			}
			else{
				if((!webapp.lock || !webapp.lock.isLocked()) && !(ICTouchAPI.transitionServices.getCurrentScreenName()==="webapp.search.getSearch")){
					this.showKeyPad({
						searchType: this.DIALACTION_CALL,
						boolInitiatedFromGUI: false
					});
				}
			}
		}
	},

	apiConferenceStarted : function() {
		ICTouchAPI.debugServices.info("webapp.communication.controlBase - apiConferenceStarted");
		var objArguments = ICTouchAPI.tools.getEventArguments(arguments);
		var callId1 = objArguments.callId1.value;
		var callId2 = objArguments.callId2.value;
		var phoneCall1 = objArguments.phoneCall1;
		var phoneCall2 = objArguments.phoneCall2;

		if (phoneCall1 && phoneCall1.callId && phoneCall2 && phoneCall2.callId) {
			ICTouchAPI.debugServices.debug("webapp.communication.controlBase - apiConferenceStarted / Conference started for id " + phoneCall1.callId + " and id " + phoneCall2.callId);
		}

		this.data.modifyInLog(phoneCall2, this.data.COMLOG_CALL);
		this.data.modifyInLog(phoneCall1, this.data.COMLOG_CALL);
		//this.data.modifyInLog(phoneCall2, this.data.COMLOG_CALL, true);
		if(phoneCall1.isOnHold){
			this.data.hideItemById(callId2,"Conference", false);
			this.data.setCurrentEntry(callId1);
			this.ongoingCallNotificationsUpdate(this.data.findItemById(callId1));
		} else {
			this.data.hideItemById(callId1,"Conference", false);
			this.data.setCurrentEntry(callId2);
			this.ongoingCallNotificationsUpdate(this.data.findItemById(callId2));
		}
	},

	apiConferenceEnded : function() {
		ICTouchAPI.debugServices.info("webapp.communication.controlBase - apiConferenceEnded");
		var objArguments = ICTouchAPI.tools.getEventArguments(arguments);
		var callId1 = objArguments.callId1.value;
		var callId2 = objArguments.callId2.value;
		var phoneCall1 = objArguments.phoneCall1;
		var phoneCall2 = objArguments.phoneCall2;
		if(this.data.findItemById(callId1)){
			this.data.showItemById(callId1,"Conference", false);
			ICTouchAPI.debugServices.debug("webapp.communication.controlBase - apiConferenceEnded / Conference ended for id " + phoneCall1.callId + " and id " + phoneCall2.callId);
			this.data.setCurrentEntry(callId1);
			this.data.modifyInLog(phoneCall1, this.data.COMLOG_CALL);
		}
		if(this.data.findItemById(callId2)){
			this.data.showItemById(callId2,"Conference", false);
			this.data.setCurrentEntry(callId2);
			this.data.modifyInLog(phoneCall2, this.data.COMLOG_CALL);
		}
		return;
	},

	apiReloadPhoneCalls: function() {
		webapp.communication.data.loadList(true, false);
	},

	addPopupCall : function(callId) {


		if(!callId) {
			return ;
		}

		var objCall = this.data.findItemById(callId);
		if(!objCall) {
			return ;
		}


		var callType = this.getPopupCallTypeForStatus(objCall.intStatus);
		var isPopupNeeded = this.isPopupNeeded(callType);

		var addedResult = false;

		var addFirst;
		var popupType;
		var doRemove = false;

		if(callType == this.data.CALL_TO_IGNORE) {
			if(!isPopupNeeded) {
				doRemove = true;
			}
		} else if(callType == this.data.CALL_INCOMING || callType == this.data.CALL_OUTGOING) {
			if(isPopupNeeded) {
				addFirst = false;
				popupType = this.data.POPUP_INCOMING;
			} else {
				doRemove = true;
			}
		} else if(callType == this.data.CALL_ONGOING) {
			if(isPopupNeeded) {
				addFirst = true;
				popupType = this.data.POPUP_ONGOING;
			} else {
				doRemove = true;
			}
		} else if(callType == this.data.CALL_SECONDARY) {
			if(isPopupNeeded) {
				addFirst = false;
				popupType = this.data.POPUP_ONGOING;
			} else {
				doRemove = true;
			}
		}
		if(popupType) {
			addedResult = this.addCallIdToPopups(callId,addFirst,popupType);
			if(addedResult && addedResult == 1) {
				this.refreshCallPopup(popupType);
			}
		}
		if(doRemove && this.objPopupCall) {
			ICTouchAPI.popupServices.removePopup(this.objPopupCall);
			this.objPopupCall = null;
		}
	},

	addCallIdToPopups : function(callId,doAddFirst,popupType) {
		for(var i in this.arrIdPopupCall[popupType]) {
			if(this.arrIdPopupCall[popupType][i] == callId) {
				if(i != 0 && doAddFirst) {
					this.arrIdPopupCall[popupType].splice(i,1);
					this.arrIdPopupCall[popupType].unshift(callId);
					return 1;
				} else if(i == 0) {
					return 1;
				} else {
					return null;
				}
			}
		}
		if(doAddFirst) {
			this.arrIdPopupCall[popupType].unshift(callId);
			return 1;
		} else {
			return this.arrIdPopupCall[popupType].push(callId);
		}
	},

	modifyPopupCall : function(callId) {
		if(!callId) {
			return ;
		}

		var objCall = this.data.findItemById(callId);
		if(!objCall) {
			return ;
		}


		var callType = this.getPopupCallTypeForStatus(objCall.intStatus);
		var isPopupNeeded = this.isPopupNeeded(callType);

		var modifiedResult = false;

		var addFirst;
		var popupType;
		var doRemove = false;

		if(callType == this.data.CALL_TO_IGNORE) {
			if(!isPopupNeeded) {
				doRemove = true;
			}
		} else if(callType == this.data.CALL_INCOMING || callType == this.data.CALL_OUTGOING) {
			if(isPopupNeeded && !objCall.ignoredCall) {
				addFirst = false;
				popupType = this.data.POPUP_INCOMING;
			} else {
				doRemove = true;
			}
		} else if(callType == this.data.CALL_ONGOING) {
			if(isPopupNeeded) {
				addFirst = true;
				popupType = this.data.POPUP_ONGOING;
			} else {
				doRemove = true;
			}
		} else if(callType == this.data.CALL_SECONDARY) {
			if(isPopupNeeded) {
				addFirst = false;
				popupType = this.data.POPUP_ONGOING;
			} else {
				doRemove = true;
			}
		}

		if(popupType) {
			modifiedResult = this.modifyCallIdInPopups(callId,addFirst,popupType);
			if(modifiedResult && modifiedResult == 1) {
				this.refreshCallPopup(popupType);
			}
		}
		if(doRemove && this.objPopupCall) {
			ICTouchAPI.popupServices.removePopup(this.objPopupCall);
			this.objPopupCall = null;
		}
	},

	modifyCallIdInPopups : function(callId,doPutFirst,popupType) {
		for(var i in this.arrIdPopupCall[this.data.POPUP_INCOMING]) {
			if(this.arrIdPopupCall[this.data.POPUP_INCOMING][i] == callId) {
				if(popupType == this.data.POPUP_INCOMING) {
					if(i == 0) {
						return null;
					} else if (doPutFirst) {
						this.arrIdPopupCall[this.data.POPUP_INCOMING].splice(i,1);
						this.arrIdPopupCall[this.data.POPUP_INCOMING].unshift(callId);
						return 1;
					} else {
						return null;
					}
				} else {
					this.arrIdPopupCall[this.data.POPUP_INCOMING].splice(i,1);
				}
			}
		}
		for(var i in this.arrIdPopupCall[this.data.POPUP_ONGOING]) {
			if(this.arrIdPopupCall[this.data.POPUP_ONGOING][i] == callId) {
				if(popupType == this.data.POPUP_ONGOING) {
					if(i == 0) {
						return 1;
					} else if (doPutFirst) {
						this.arrIdPopupCall[this.data.POPUP_ONGOING].splice(i,1);
						this.arrIdPopupCall[this.data.POPUP_ONGOING].unshift(callId);
						return 1;
					} else {
						return null;
					}
				} else {
					this.arrIdPopupCall[this.data.POPUP_ONGOING].splice(i,1);
				}
			}
		}
		if(doPutFirst) {
			this.arrIdPopupCall[popupType].unshift(callId);
			return 1;
		} else {
			return this.arrIdPopupCall[popupType].push(callId);
		}
	},

	removePopupCall : function(callId) {
		if(!callId) {
			return ;
		}
		for(var i in this.arrIdPopupCall[this.data.POPUP_INCOMING]) {
			if(this.arrIdPopupCall[this.data.POPUP_INCOMING][i] == callId) {
				this.arrIdPopupCall[this.data.POPUP_INCOMING].splice(i,1);
				if(i == 0 && this.objPopupCall) {
					ICTouchAPI.popupServices.removePopup(this.objPopupCall);
					this.objPopupCall = null;
				}
				break;
			}
		}
		for(var i in this.arrIdPopupCall[this.data.POPUP_ONGOING]) {
			if(this.arrIdPopupCall[this.data.POPUP_ONGOING][i] == callId) {
				this.arrIdPopupCall[this.data.POPUP_ONGOING].splice(i,1);
				if(i == 0 && this.objPopupCall) {
					ICTouchAPI.popupServices.removePopup(this.objPopupCall);
					this.objPopupCall = null;
				}
				break;
			}
		}
		this.showNextPopup();
	},

	showNextPopup : function() {
		this.cleanseTimerPopup();
		var callId;
		if(this.arrIdPopupCall[this.data.POPUP_INCOMING][0]) {
			callId = this.arrIdPopupCall[this.data.POPUP_INCOMING][0];
		} else if(this.arrIdPopupCall[this.data.POPUP_ONGOING][0]) {
			callId = this.arrIdPopupCall[this.data.POPUP_ONGOING][0];
		}
		if(!callId) {
			return ;
		}

		var objCall = this.data.findItemById(callId);
		if(!objCall) {
			return ;
		}

		var callType = this.getPopupCallTypeForStatus(objCall.intStatus);
		var isUnlocked = (!webapp.lock|| !webapp.lock.isLocked());
		if(!this.isPopupNeeded(callType)) {
			return;
		}
		this.showCallPopup(callId);
	},

	refreshCallPopup : function(popupType) {
		this.cleanseTimerPopup();
		if( (popupType == this.data.POPUP_INCOMING && this.arrIdPopupCall[this.data.POPUP_INCOMING][0])
			|| (popupType == this.data.POPUP_ONGOING && this.arrIdPopupCall[this.data.POPUP_ONGOING][0] && !this.arrIdPopupCall[this.data.POPUP_INCOMING][0])) {
			this.showCallPopup(this.arrIdPopupCall[popupType][0]);
		}
		else if(popupType == this.data.POPUP_ONGOING && this.arrIdPopupCall[this.data.POPUP_INCOMING][0]) {
			this.showCallPopup(this.arrIdPopupCall[this.data.POPUP_INCOMING][0]);
		}
	},

	showCallPopup : function(callId) {
		var isUnlocked = (!webapp.lock|| !webapp.lock.isLocked());
		if(!callId) {
			return ;
		}

		var objCall = this.data.findItemById(callId);
		if(!objCall) {
			return ;
		}

		if (this.objPopupCall) {
			ICTouchAPI.popupServices.removePopup(this.objPopupCall);
			this.objPopupCall = null;
		}
		var callType = this.getPopupCallTypeForStatus(objCall.intStatus);

		var arrButtons = [];
		var strTitlePopup = "";
		var strIconPopup = "";

		if(callType == this.data.CALL_INCOMING) {
			strTitlePopup = _("Incoming call","webapp.communication");
			strIconPopup = "dialogbox-communication-log-in-ringing-blue";

			arrButtons.push({
				strButtonName: "POPUP_ANSWER_BTN",
				strButtonLabel: _("Answer call","webapp.communication"),
				strButtonIcon: "dialogbox-communication-call",
				callback : function(){
					webapp.communication.apiAnswerCall(callId);
				}
			});
			arrButtons.push({
				strButtonName: "POPUP_IGNORE_BTN",
				strButtonLabel: _("Ignore call","webapp.communication"),
				strButtonIcon: "dialogbox-communication-stop-ringing",
				callback : function(){
					webapp.communication.apiIgnoreCall(callId);
				}
			});
		} else
		if(callType == this.data.CALL_OUTGOING) {
			strTitlePopup = _("Outgoing call","webapp.communication");
			strIconPopup = "dialogbox-communication-log-in-ringing-blue";

			arrButtons.push({
				strButtonName: "POPUP_ENDCALL_BTN",
				strButtonLabel: _("End call","webapp.communication"),
				strButtonIcon: "dialogbox-communication-cancel-call",
				callback : function(){
					webapp.communication.apiEndCall(callId);
				}
			});
		} else if(callType == this.data.CALL_ONGOING || callType == this.data.CALL_SECONDARY) {

			if(objCall.objCallData.isOnHold || objCall.objCallData.isHeld) {
				strTitlePopup = _("Hold call","webapp.communication");
			} else if (objCall.objCallData.isConference) {
				strTitlePopup = _("Conference","webapp.communication");
			} else {
				strTitlePopup = _("OngoingCall","webapp.communication");
			}
			strIconPopup = "dialogbox-communication-log-in-com-blue";

			if(objCall.objCallData.isOnHold) {
				arrButtons.push({
					strButtonName: "POPUP_RETRIEVE_BTN",
					strButtonLabel: _("Retrieve call","webapp.communication"),
					strButtonIcon: "dialogbox-communication-call",
					callback : function(){
						webapp.communication.apiRetrieveCall(callId);
					}
				});
			}

			if(!isUnlocked && webapp.lock.data && webapp.lock.data.unlockCapability) {
				arrButtons.push({
					strButtonName: "POPUP_UNLOCK_BTN",
					strButtonLabel: _("Unlock","webapp.communication"),
					strButtonIcon: "generic-delock",
					callback : function(){
						if (webapp.communication.objPopupCall) {
							ICTouchAPI.popupServices.removePopup(webapp.communication.objPopupCall);
							webapp.communication.objPopupCall = null;
							if(webapp.lock) {
								webapp.lock.deployUnlockKeyboard();
							}
						}
						webapp.communication.hTimerPopupCall = setTimeout(function(){
							webapp.communication.showNextPopup();
						}, 30000);
					}
				});
			}

			arrButtons.push({
				strButtonName: "POPUP_ENDCALL_BTN",
				strButtonLabel: _("End call","webapp.communication"),
				strButtonIcon: "dialogbox-communication-cancel-call",
				callback : function(){
					webapp.communication.apiEndCall(callId);
				}
			});
		}

		var disp = objCall.objCallData.displayName ? objCall.objCallData.displayName : objCall.objCallData.phoneNumber;

		var dataPopup = {
			strTitle: strTitlePopup,
			strContent: disp,
			boolHorizontalMode : true,
			strIcon: strIconPopup,
			params: [callId],
			arrPopupButtons: arrButtons
		};

		this.objPopupCall = ICTouchAPI.popupServices.addNewPopup(dataPopup, "LOW");
		objCall=null;
		isUnlocked=null;
	},

	getPopupCallTypeForStatus : function(intStatus) {
		var callState;
		if(intStatus == this.data.STATUS_OUTGOING){
			callState = this.data.CALL_OUTGOING;
		}
		else if(intStatus == this.data.STATUS_INCOMING || intStatus == this.data.STATUS_CONFERENCE_INCOMING){
			callState = this.data.CALL_INCOMING;
		}
		else if (intStatus == this.data.STATUS_CALLS || intStatus == this.data.STATUS_ONGOING || intStatus == this.data.STATUS_CONFERENCE || intStatus == this.data.STATUS_DOUBLE_CALL) {
			callState = this.data.CALL_ONGOING;
		}
		else if (intStatus == this.data.STATUS_HOLD || intStatus == this.data.STATUS_HELD || intStatus == this.data.STATUS_CONFERENCE_HOLD) {
			callState = this.data.CALL_SECONDARY;
		}
		else {
			callState = this.data.CALL_TO_IGNORE;
		}

		intStatus = null;
		return callState;
	},

	checkForCallToDisplay : function() {
		var calls = this.data.getPhoneCalls();
		var callType;
		if(!this.arrIdPopupCall[this.data.POPUP_INCOMING][0] && !this.arrIdPopupCall[this.data.POPUP_ONGOING][0] && calls.length > 0) {
			for (var i in calls) {
				callType = this.getPopupCallTypeForStatus(calls[i].intStatus);
				if(callType == this.data.CALL_INCOMING || callType == this.data.CALL_OUTGOING){
					this.arrIdPopupCall[this.data.POPUP_INCOMING].push(calls[i].objCallData.callId);
				} else if(callType == this.data.CALL_ONGOING){
					this.arrIdPopupCall[this.data.POPUP_ONGOING].unshift(calls[i].objCallData.callId);
				} else if(callType == this.data.CALL_SECONDARY){
					this.arrIdPopupCall[this.data.POPUP_ONGOING].push(calls[i].objCallData.callId);
				}
			}
		}
		webapp.communication.showNextPopup();
	},

	deleteAllPopupCall : function() {
		this.arrIdPopupCall[this.data.POPUP_INCOMING].splice(0,this.arrIdPopupCall[this.data.POPUP_INCOMING].length);
		this.arrIdPopupCall[this.data.POPUP_ONGOING].splice(0,this.arrIdPopupCall[this.data.POPUP_ONGOING].length);
		if(this.objPopupCall) {
			ICTouchAPI.popupServices.removePopup(this.objPopupCall);
			this.objPopupCall = null;
		}
	},

	isPopupNeeded : function(callType) {
		var isUnlocked = (!webapp.lock|| !webapp.lock.isLocked());

		if(!isUnlocked) {
			return callType <= this.data.CALL_TO_IGNORE;
		} else if (ICTouchAPI.keyboardServices.isKeyboardDisplayed() || this.data.getNotifyCallByPopup() || this.data.isAvoidCommSwitch()) {
			return callType <= this.data.CALL_INCOMING;
		} else {
			return false;
		}
	},

	cleanseTimerPopup : function() {
		if (webapp.communication.hTimerPopupCall) {
			clearTimeout(webapp.communication.hTimerPopupCall);
			webapp.communication.hTimerPopupCall = null;
		}
	},

	isSelectStatusProgkey : function() {
		var result = this.data && (this.getSelectStatus() == this.data.STATUS_PROGKEYS_CALL
		||  this.getSelectStatus() == this.data.STATUS_PROGKEYS_ROUTING);
		return result;
	},

	isSelectStatusMDR : function() {
		var result = this.data && (this.getSelectStatus() == this.data.STATUS_MDR_ROUTING
			||	this.getSelectStatus() == this.data.STATUS_MDR_OVERFLOW
			||	this.getSelectStatus() == this.data.STATUS_MDR_USER
			||	this.getSelectStatus() == this.data.STATUS_BASIC_ADD_ROUTING
			||	this.getSelectStatus() == this.data.STATUS_BASIC_IMMEDIATE_ROUTING);
		return result;
	},

	ongoingCallNotificationsCountUpdate : function() {
		// Update the state of the TopBar call notification
		var notification = ICTouchAPI.notificationServices.getNotificationByName("OngoingCall");
		if(notification){
			var calls = this.data.getPhoneCalls();
			for (var i in calls) {
				if(calls[i].intStatus == this.data.STATUS_INCOMING ||
					calls[i].intStatus == this.data.STATUS_OUTGOING){
					notification.strNotificationLabel = this.data._callNotificationLabel(calls[i]);
					notification.strNotificationLabelIcon = this.data._callNotificationIcon(calls[i].intStatus);
					notification.strNotificationType = this.data._callNotificationType(calls[i].intStatus);
					break;
				}
			}
		}
		ICTouchAPI.notificationServices.setNotificationValue("OngoingCall",this.data.getCountCalls());
	},

	// Callback of supervision.groupModified event. We care only about array "arrModifiedMember"
	onSupGroupModified : function(strGroupName, arrAddedMember, arrModifiedMember, arrDeletedLogins) {
		ICTouchAPI.debugServices.info("webapp.communication.controlBase - onSupGroupModified begin");
		ICTouchAPI.debugServices.debug("webapp.communication.controlBase - onSupGroupModified / "+ dojo.toJson(arrModifiedMember));
		if(arrModifiedMember){
			for(var i in arrModifiedMember){
				this.data.updateSupervisedCall(arrModifiedMember[i]);
			}
		}

		ICTouchAPI.debugServices.info("webapp.communication.controlBase - onSupGroupModified end");
	},

	// Called when user did hookOff and the changed screen
	screenHasChanged: function(args) {
		var name = args.name;

		// We stayed in same webapp ( communication )
		if(name.search("/^webapp\.communication\./")){
			return;
		}
		dojo.disconnect(this._handlerGetScreen);
		args=null;
	},

	apiAddCallbackRequestNotif : function(notif) {
		if(notif.value>0){
			ICTouchAPI.ledServices.activate('communication','N_CALLBACK');
		}else{
			ICTouchAPI.ledServices.desactivate('communication','N_CALLBACK');
		}
		ICTouchAPI.notificationServices.setNotificationValue("Callback",notif.value);
		notif=null;
	},

	apiAddMissedCallNotif : function(notif){
		if(notif.value>0){
			ICTouchAPI.ledServices.activate('communication','N_UNANS_CALL');
		}else{
			ICTouchAPI.ledServices.desactivate('communication','N_UNANS_CALL');
		}
		ICTouchAPI.notificationServices.setNotificationValue("Missed",notif.value);
		notif=null;
	},

	onNotificationOngoing : function() {
		webapp.communication.data.boolShowVideo = true;
		if(this.getSelectStatus() === this.data.STATUS_PROGKEYS_CALL) {
			this.resetStatus();
			dojo.publish("OpenHomepage", [{sync: true}]);
		}
		
		var currentNotifcallId = ICTouchAPI.notificationServices.getNotificationByName("OngoingCall").callId;

		// Select the entry
		webapp.communication.data.selectComlogByIndex(currentNotifcallId, true);
		
		// Manually trigger the context action
		this.doContextClickAction(currentNotifcallId)

		var objCall = this.data.findItemById(currentNotifcallId);
		if(objCall && !objCall.isFiltered){
		ICTouchAPI.transitionServices.getScreen({
			name: "webapp.communication.getCommunication",
			params: {}
		});
		}
		if (this.getSelectStatus() !== -1) {
			// open the dialpad in select mode
			var objSearch = {
				searchType:this.getKeyPadActionFromSelectStatus()
			};
			this.showKeyPad(objSearch);
		}
	},

	// Function called when the numpad is closed ( disconnect any onpress event )
	setInputFieldContent: function(number) {
		this.apiCall(number, true);
		number=null;
	},

	onComlogClick : function(comlogId, boolByClick)
	{
		// Do context action if it was a click on the list (and not the result of an internal process of the list or the webapp)
		if(boolByClick){
			this.doContextClickAction(comlogId);
		}
		
		// Refresh the 2/3 if there was no action to do or if it was not the result of a user click.
		if(this._intSelectStatus < 0 || !boolByClick){
			this.data.loadDetails(comlogId);
		}

		comlogId=null;
		boolByClick = null;
	},

	doContextClickAction : function(comlogId) {
		var data = webapp.communication.data;
		var comlogItem = data.findItemById(comlogId);
		// if we are in add participant into a conference mode
		if (this._intSelectStatus >= 0)
		{
			var callId, strNumber;
			var firstCallId = (data._objFirstSelected.objCallData)? data._objFirstSelected.objCallData.callId : null;
			switch (this._intSelectStatus) {
				case data.STATUS_INIT_CONF3:
					if(comlogItem.boolSelectable && comlogItem.objCallData){
						var firstCall = data._objFirstSelected.objCallData;
						var secondCall = comlogItem.objCallData;
						this.startConf3(firstCall, secondCall);
					}
					data.cancelShownStatus();
					break;
				case data.STATUS_MERGE_CALLS:
					// get The number
					if (comlogItem.boolSelectable && comlogItem.objCallData) {
						// remove selection Mode
						this.setSelectStatus(-1);
						callId = comlogItem.intIndex;
						ICTouchAPI.APIServices.Telephony.mergePhoneCalls({
							params: [firstCallId, callId]
						});
						data.cancelShownStatus();
					}
					break;
				case data.STATUS_TRANSFER:
					if (comlogItem.boolSelectable) {
						if (comlogItem.objCallData) {
							callId = comlogItem.intIndex;
							this.transferToCall(firstCallId, callId);
							// remove selection Mode
							this.setSelectStatus(-1);
							data.cancelShownStatus();
						}
					}
					break;
				case data.STATUS_PROGKEYS_CALL :
					strNumber = comlogItem.objLogData.listContactSummary[0].officePhone;
					comlogItem.source = "history";
					this._progKeySetArgs(strNumber, comlogItem);
					break;
				
				case data.STATUS_PROGKEYS_ROUTING :
					strNumber = comlogItem.objLogData.listContactSummary[0].officePhone;
					comlogItem.source = "history";
					webapp.userservices._progKeySetNumber(strNumber, comlogItem);
					break;

				case data.STATUS_MDR_ROUTING :
					// remove selection Mode
					this.setSelectStatus(-1);
					strNumber = comlogItem.objLogData.listContactSummary[0].officePhone;
					comlogItem.source = "history";
					webapp.userservices.data.setOtherNumber(strNumber, comlogItem);
					ICTouchAPI.transitionServices.back();
					break;

				case data.STATUS_MDR_OVERFLOW :
					// remove selection Mode
					this.setSelectStatus(-1);
					strNumber = comlogItem.objLogData.listContactSummary[0].officePhone;
					comlogItem.source = "history";
					webapp.userservices.data.searchForOverflow(strNumber, comlogItem);
					ICTouchAPI.transitionServices.back();
					break;

				case data.STATUS_MDR_USER :
					// remove selection Mode
					this.setSelectStatus(-1);
					strNumber = {
						strContent : comlogItem.objLogData.listContactSummary[0].officePhone
					}
					webapp.userservices.data.setUserRouting(comlogItem,strNumber);
					ICTouchAPI.transitionServices.back();
					break;
				case data.STATUS_BASIC_ADD_ROUTING :
					ICTouchAPI.debugServices.warning("communication.controlBase - onComlogClick : Empty case STATUS_BASIC_ADD_ROUTING");
					break;
				case data.STATUS_BASIC_IMMEDIATE_ROUTING :
					ICTouchAPI.debugServices.warning("communication.controlBase - onComlogClick : Empty case STATUS_BASIC_IMMEDIATE_ROUTING");
					break;
			}
		}
		// other modes of application, load
		else
		{
			data._intLastSelected = comlogId;

			var selectedId = data.findItemById(comlogId);
			if(selectedId != null && selectedId != undefined){
			var status = selectedId.intStatus;
				if (status === data.STATUS_HOLD || status === data.STATUS_CONFERENCE_HOLD) {
				this.apiRetrieveCall(comlogId);
				} else if (status === data.STATUS_INCOMING || status === data.STATUS_CONFERENCE_INCOMING) {
				this.apiAnswerCall(comlogId);
				} else if (status === data.STATUS_FILTERED_RING || status === this.data.STATUS_FILTERED_CALL) {
					this.apiPickUpIntrudeCall(comlogId);
				}
				if (status === data.STATUS_CONFERENCE || status === data.STATUS_CONFERENCE_PARTICIPANT_MENULIST_SELECTED){
					data.boolShowVideo = false;
				} else {
					data.boolShowVideo = true;
				}
			}
		}
		comlogId=null;
	},

	/**
	 * Start a conference on OXE with 3 people.
	 */
	startConf3 : function(firstCall, secondCall) {
		if(firstCall && secondCall){
			var firstParticipant = {
				objContact:		this.data.createContactFromNumber(firstCall.displayName, firstCall.phoneNumber)
			};
			var secondParticipant = {
				objContact:		this.data.createContactFromNumber(secondCall.displayName, secondCall.phoneNumber)
			};
			var arrTmp = [];

			if(this.data.getCallParticipants(firstCall.callId) && this.data.getCallParticipants(firstCall.callId).length === 1){
				arrTmp.push(this.data.getCallParticipants(firstCall.callId)[0]);
			} else {
				arrTmp.push(firstParticipant);
			}
			if(this.data.getCallParticipants(secondCall.callId) && this.data.getCallParticipants(secondCall.callId).length === 1){
				arrTmp.push(this.data.getCallParticipants(secondCall.callId)[0]);
			} else {
				arrTmp.push(secondParticipant);
			}
			this.data.getCallsWithParticipants()[firstCall.callId] = arrTmp;
			this.data.getCallsWithParticipants()[secondCall.callId] = arrTmp;

			ICTouchAPI.APIServices.Telephony.startConference({
				params: [firstCall.callId, secondCall.callId]
			});
			if(this.mainWidget){
				this.mainWidget.setConferenceCard([firstCall.phoneNumber, secondCall.phoneNumber]);
			}
			// remove selection Mode
			this.setSelectStatus(-1);
		}
		firstCall=null;
		secondCall=null;
	},

	/**
	 * Start a conference on ICE with 3 people.
	 */
	startMergeConf : function(firstCall, secondCall) {
		if(firstCall && firstCall.objCallData && secondCall && secondCall.objCallData){
			var activeCallId;
			var holdCallId;
			// Check the order first call / second call (first arg has to be active call, second arg has to be held call)
			if (firstCall.objCallData.isHeld || firstCall.objCallData.isOnHold) {
				activeCallId = secondCall.objCallData.callId;
				holdCallId = firstCall.objCallData.callId;
			}
			else if (secondCall.objCallData.isHeld || secondCall.objCallData.isOnHold) {
				activeCallId = firstCall.objCallData.callId;
				holdCallId = secondCall.objCallData.callId;
			}

			ICTouchAPI.APIServices.Telephony.mergePhoneCalls({
				params: [activeCallId, holdCallId]
			});
			var firstParticipantNumber;
			var secondParticipantNumber;
			if(dojo.date.difference(secondCall.timer.start, firstCall.timer.start, "second") > 0){
				firstParticipantNumber = secondCall.objCallData.phoneNumber;
				secondParticipantNumber = firstCall.objCallData.phoneNumber;
			} else {
				firstParticipantNumber = firstCall.objCallData.phoneNumber;
				secondParticipantNumber = secondCall.objCallData.phoneNumber;
			}
			if(this.mainWidget){
				this.mainWidget.setConferenceCard([firstParticipantNumber,secondParticipantNumber]);
			}
		}
		firstCall=null;
		secondCall=null;
	},

	transferToCall : function (callToTransfer, destCall) {
		ICTouchAPI.APIServices.Telephony.transferPhoneCall({
			params:[callToTransfer, destCall]
		});
		callToTransfer=null;
		destCall=null;
	},

	apiDeflectToNumber : function (callToDeflect, destNumber, makeDialableNumber) {
		ICTouchAPI.debugServices.debug("webapp.communication.controlBase - apiDeflectToNumber $ input function params | callToDeflect: " + callToDeflect + " | destNumber: " + destNumber + " | makeDialableNumber: " + makeDialableNumber);

		// Convert the optional parameter 'makeDialableNumber' if required
		// (it must be a boolean for beeing used in deflectToNumber function)
		var doDialableNumber = (makeDialableNumber)?true:false;
		// Call the deflectToNumber function with the parameter makeDialableNumber
		// (true/false: call or not the numbering library to convert the phone number to a number that fits to the numbering plan)
		ICTouchAPI.APIServices.Telephony.deflectToNumber({
			params:[callToDeflect, destNumber, doDialableNumber]
		});
		callToDeflect=null;
		destNumber=null;
		makeDialableNumber=null;
	},

	apiTransferPhoneCallToNumber : function (callToTransfert, destNumber, makeDialableNumber) {
		ICTouchAPI.debugServices.debug("webapp.communication.controlBase - apiTransferPhoneCallToNumber $ input function params | callToTransfert: " + callToTransfert + " | destNumber: " + destNumber + " | makeDialableNumber: " + makeDialableNumber);
		// Convert the optional parameter 'makeDialableNumber' if required
		// (it must be a boolean for beeing used in transferPhoneCallToNumber function)
		var doDialableNumber = (makeDialableNumber)?true:false;
		// Call the transferPhoneCallToNumber function with the parameter makeDialableNumber
		// (true/false: call or not the numbering library to convert the phone number to a number that fits to the numbering plan)
		ICTouchAPI.APIServices.Telephony.transferPhoneCallToNumber({
			params:[callToTransfert, destNumber, doDialableNumber]
		});
		this.setSelectStatus(-1);
		this.data.cancelShownStatus();
		callToTransfert=null;
		destNumber=null;
		makeDialableNumber=null;
	},

	apiAddParticipant : function (callToAddParticipant, destNumber, makeDialableNumber) {
		ICTouchAPI.debugServices.debug("webapp.communication.controlBase - apiAddParticipant $ input function params | callToAddParticipant: " + callToAddParticipant + " | destNumber: " + destNumber + " | makeDialableNumber: " + makeDialableNumber);

		// Convert the optional parameter 'makeDialableNumber' if required
		// (it must be a boolean for beeing used in addParticipant function)
		var doDialableNumber = (makeDialableNumber)?true:false;
		// Call the addParticipant function with the parameter makeDialableNumber
		// (true/false: call or not the numbering library to convert the phone number to a number that fits to the numbering plan)
		ICTouchAPI.APIServices.Telephony.addParticipant({
			params:[callToAddParticipant, destNumber, doDialableNumber]
		});

		// Preload the screen
		var arrNumbers = [];
		var arrParticipants = this.data.getCallParticipants(callToAddParticipant);
		for(var i=0; i<arrParticipants.length; i++){
			if(arrParticipants[i].objContact){
				arrNumbers.push(arrParticipants[i].objContact.officePhone);
			}
		}
		arrNumbers.push(destNumber);
		if(this.mainWidget){
			this.mainWidget.setConferenceCard(arrNumbers);
		}
		// remove selection Mode
		this.setSelectStatus(-1);

		callToAddParticipant=null;
		destNumber=null;
		makeDialableNumber=null;
	},

	apiHoldCall : function (callId) {

		//Display the hold icon
		// TODO: cmazard, waiting for syport modification of the MenuList to be able to update only the call status icon without rebuild the full luist item.

		// call core with no callback, (result = waiting for event)
		ICTouchAPI.APIServices.Telephony.putOnHold({
			params: [callId]
		});
		callId=null;
	},

	apiRetrieveCall : function (callId) {
		if(this.data.getCallIdRetrieving() === null){
			this.data.setCallIdRetrieving(callId);
			// call core with no callback, (result = waiting for event)
			ICTouchAPI.APIServices.Telephony.retrieveCall({
				params: [callId]
			});
		}
		callId=null;
	},

	apiPickUpIntrudeCall : function (callId) {
		var objComLogEntry = this.data.findItemById(callId);

		var login = (this.data.getUserRole() == this.data.MANAGER_ROLE) ? objComLogEntry.objCallData.assistant : objComLogEntry.objCallData.manager;
		if(login && webapp.managerassistant) {
				var objContact = webapp.managerassistant.data.getMAByLogin(login);
				if(objContact != null)  {
					var phoneNumber = ICTouchAPI.tools.getContactPhone(objContact.objContact);
					if (phoneNumber != "") {
						var actionDone = false;
						// if status is STATUS_FILTERED_RING, the action is pickup
						if (objComLogEntry.intStatus == this.data.STATUS_FILTERED_RING) {
							if (ICTouchAPI.CapabilityServices.getCapability("Telephony", objComLogEntry.objCallData.idCapabilities, "pickUp") == ICTouchAPI.CapabilityServices.AVAILABLE) {
								ICTouchAPI.APIServices.Telephony.pickupCall({
									params:[objComLogEntry.objCallData.callRef, phoneNumber]
								});
								actionDone = true;
							}
							else {
								ICTouchAPI.debugServices.warning("webapp.communication.controlBase - apiPickUpIntrudeCall / current notification is in STATUS_FILTERED_RING state but can't call pickupCall because capability is unavailable!");
							}
						}
						// if status is STATUS_FILTERED_CALL, the action is pickup
						else if (objComLogEntry.intStatus == this.data.STATUS_FILTERED_CALL) {
							if (ICTouchAPI.CapabilityServices.getCapability("Telephony", objComLogEntry.objCallData.idCapabilities, "intrude") == ICTouchAPI.CapabilityServices.AVAILABLE) {
								ICTouchAPI.APIServices.Telephony.intrudeCall({
									params:[objComLogEntry.objCallData.callRef, login, false]
								});
								actionDone = true;
							}
							else {
								ICTouchAPI.debugServices.warning("webapp.communication.controlBase - apiPickUpIntrudeCall / current notification is in STATUS_FILTERED_CALL state but can't call intrudeCall because capability is unavailable!");
							}
						}

						if (actionDone) {
							//Remove notification context and pre build the screen using a dummy phoneCall.
							this.data.removeFromLog(callId, this.data.COMLOG_LIST_CALL, true);
							if (!this.boolPickupInitiated) {
								var phoneNumberCaller;
								if (objComLogEntry.objCallData.participantsList) {
									phoneNumberCaller = objComLogEntry.objCallData.participantsList[0].phoneNumber;
								}
								else {
									phoneNumberCaller = objComLogEntry.objCallData.phoneNumber;
								}
								this.boolPickupInitiated = true;
								this.data.addSimulatedItemInLog(phoneNumberCaller, true);
							}
						}
					}
				}
			}

		//		this.data.removeFromLog(callId, this.data.COMLOG_LIST_CALL, false);

		callId = null;
	},

	apiStartSendingVideo : function (callID){
		ICTouchAPI.debugServices.info("webapp.communication.controlBase - apiStartSendingVideo callID="+callID);
		if (this.data.getCurrentEntry() == callID && this.data.objContactCard) {
			this.data.updateVideoIcon({callId: callID, videoStatus: "VIDEO_PROCESSING"});
		}
		ICTouchAPI.APIServices.Telephony.modifyMedia({params:[callID, this.MODIF_MEDIA_VIDEO_START]});
		callID=null;
	},

	apiStopSendingVideo : function (callID){
		ICTouchAPI.debugServices.info("webapp.communication.controlBase - apiStopSendingVideo callID="+callID);

		ICTouchAPI.APIServices.Telephony.modifyMedia({params:[callID, this.MODIF_MEDIA_VIDEO_STOP]});
		callID=null;
	},

	initDeflectNumber : function (){
		// go in mode deflectTo
		this.initSelectAction(this.data.STATUS_DEFLECT_TO);
	},

	initTransferTo : function (){
		// go in mode transferTo
		this.initSelectAction(this.data.STATUS_TRANSFER_TO);
	},

	initSelectAction : function (intSelectStatus) {
		var data = webapp.communication.data;
		// get and save the callId
		var selected = data.getSelectedEntry();
		data._objFirstSelected = selected;

		// Set select mode
		this.setSelectStatus(intSelectStatus);

		// open the dialpad
		var objSearch = {
			searchType:this.getKeyPadActionFromSelectStatus()
		};
		this.showKeyPad(objSearch);

		// update the appbar (empty in selection mode)
		this.updateAppBar();
	},

	initTransfer : function (){
		// get the active calls (meaning not the filtered call, if any)
		var active_calls = this.data.getActivePhoneCalls();
		if(active_calls.length == 2){
			var firstCallId = null;
			var secondCallId = this.data.getSelectedEntry().intIndex;
			if(active_calls[0].intIndex == secondCallId){
				firstCallId = active_calls[1].intIndex;
			}
			else{
				firstCallId = active_calls[0].intIndex;
			}
			this.transferToCall(firstCallId, secondCallId);
		} else if (active_calls.length > 2) {

			// go in mode transferTo
			// Set select mode
			this.setSelectStatus(this.data.STATUS_TRANSFER);
			// get and save the callId
			var selected = this.data.getSelectedEntry();
			this.data._objFirstSelected = selected;

			//		// refresh icon in the com Log
			this.data.setShownLogs(true, false,true);

			this.data.objContactCard.toggleOpacity(true);

			// go in mode selection
			this.updateAppBar();
		}
	},

	cleanAfterKeyboardAction : function () {
		// we remove the mode select status and close keyboard if any
		this.setSelectStatus(-1);
		this.hideKeyboard(ICTouchAPI.keyboardServices.CLOSE_ACTION_NONE);
		// Cancel conference or transfert status
		this.data.cancelShownStatus();
		// update action bar to the last item selected
		this.updateAppBar();
	},

	deflectToNumberFromKeyboard : function (phoneNumber, objEntry) {
		// objEntry is an entry from the presentation list in a contact card

		// we remove the mode select status and close keyboard if any
		this.cleanAfterKeyboardAction();

		var currentSelected = this.data.getSelectedEntry();
		if (currentSelected && currentSelected.objCallData) {
			var callId = currentSelected.objCallData.callId;
			var strNumber = "";
			// Call the numbering library if the number come from a contact (search)
			// else (number entered using dialer) do not call the numbering library
			var dialableNumber = true;
			if (objEntry){
				strNumber = objEntry.strContent.replace(/\s/g,'');
				dialableNumber = false;
			}
			else{
				strNumber = phoneNumber;
				dialableNumber = true;
			}
			if (strNumber) {
				this.apiDeflectToNumber(callId, strNumber, dialableNumber);
				if (phoneNumber) { // deflect initiated by search, do a get screen to communication
					ICTouchAPI.transitionServices.getScreen({
						name: "webapp.communication.getCommunication",
						sync: true, //To avoid the timer in transitionServices and to be sure that the comm webapp is displayed now.
						params: {}
					});
				}
			}
			else {
				ICTouchAPI.debugServices.warning("webapp.communication.controlBase - deflectToNumberFromKeyboard / can't transfert to number because phone number is empty!");
				ICTouchAPI.debugServices.warning("webapp.communication.controlBase - deflectToNumberFromKeyboard $ input function params | phoneNumber: " + phoneNumber + " | objEntry: " + dojo.toJSon(objEntry));
			}
		}
		phoneNumber=null;
		objEntry=null;
	},

	transferToNumberFromKeyboard : function (phoneNumber, objEntry) {
		// objEntry is an entry from the presentation list in a contact card

		// we remove the mode select status and close keyboard if any
		this.cleanAfterKeyboardAction();

		var currentSelected = this.data.getSelectedEntry();
		if (currentSelected && currentSelected.objCallData) {
			var callId = currentSelected.objCallData.callId;
			var strNumber = "";
			// Call the numbering library if the number come from a contact (search)
			// else (number entered using dialer) do not call the numbering library
			var dialableNumber = true;
			if (objEntry){
				strNumber = objEntry.strContent.replace(/\s/g,'');
				dialableNumber = false;
			}
			else{
				strNumber = phoneNumber;
				dialableNumber = true;
			}
			if (strNumber) {
				this.apiTransferPhoneCallToNumber(callId, strNumber, dialableNumber);
				if (phoneNumber) { // transfert initiated by search, do a get screen to communication
					ICTouchAPI.transitionServices.getScreen({
						name: "webapp.communication.getCommunication",
						sync: true, //To avoid the timer in transitionServices and to be sure that the comm webapp is displayed now.
						params: {}
					});
				}
			}
			else {
				ICTouchAPI.debugServices.warning("webapp.communication.controlBase - transferToNumberFromKeyboard / can't transfert to number because phone number is empty!");
				ICTouchAPI.debugServices.warning("webapp.communication.controlBase - transferToNumberFromKeyboard $ input function params | phoneNumber: " + phoneNumber + " | objEntry: " + dojo.toJSon(objEntry));
			}
		}
		phoneNumber=null;
		objEntry=null;
	},

	startConferenceFromKeyboard : function(phoneNumber, objEntry) {
		// objEntry is an entry from the presentation list in a contact card

		// we remove the mode select status and close keyboard if any
		this.cleanAfterKeyboardAction();

		var currentSelected = this.data.getSelectedEntry();
		if (currentSelected && currentSelected.objCallData) {
			var callId = currentSelected.objCallData.callId;
			var strNumber = "";
			// Call the numbering library if the number come from a contact (search)
			// else (number entered using dialer) do not call the numbering library
			var dialableNumber = true;
			if (objEntry) {
				strNumber = objEntry.strContent.replace(/\s/g,'');
				dialableNumber = false;
			}
			else {
				strNumber = phoneNumber;
				dialableNumber = true;
			}
			if (strNumber) {
				this.apiAddParticipant(callId, strNumber, dialableNumber);
				if (phoneNumber) { // conference initiated by search, do a get screen to communication
					ICTouchAPI.transitionServices.getScreen({
						name: "webapp.communication.getCommunication",
						sync: true, //To avoid the timer in transitionServices and to be sure that the comm webapp is displayed now.
						params: {}
					});
				}
			}
			else {
				ICTouchAPI.debugServices.warning("webapp.communication.controlBase - startConferenceFromKeyboard / can't add participant because phone number is empty!");
				ICTouchAPI.debugServices.warning("webapp.communication.controlBase - startConferenceFromKeyboard $ input function params | phoneNumber: " + phoneNumber + " | objEntry: " + dojo.toJSon(objEntry));
			}
		}
		phoneNumber=null;
		objEntry=null;
	},

	// This function should be exactly the same as "mergeCalls" except that its set the status to STATUS_INIT_CONF3,
	// so that the conf-3 business function is called when a user is selected to start a conference with.
	initConf3 : function(){
		var selected = this.data.getSelectedEntry();
		var active_calls = this.data.getActivePhoneCalls();
		// Specific case of conf3 when we have only 2 current call
		if(active_calls.length == 2){
			// Automatically start conference instead of having to select it in comlog
			this.startConf3(active_calls[0].objCallData, active_calls[1].objCallData);
		} else {
			// Set select mode
			this.setSelectStatus(this.data.STATUS_INIT_CONF3);
			// get and save the callId
			this.data._objFirstSelected = dojo.clone(selected);

			// refresh icon in the com Log
			this.data.setShownLogs(true,false,false);

			this.toggleOpacityTwoThird(true);

			// go in mode selection
			this.updateAppBar();
		}
	},

	mergeCalls : function(){
		var selected = this.data.getSelectedEntry();
		var active_calls = this.data.getActivePhoneCalls();
		// Specific case of conf3 when we have only 2 current call
		if(active_calls.length == 2){
			// Automatically start conference instead of having to select it in comlog
			this.startMergeConf(active_calls[0], active_calls[1]);
		} else {
			var data = webapp.communication.data;
			// Set select mode
			this.setSelectStatus(data.STATUS_MERGE_CALLS);
			// get and save the callId
			var selected = data.getSelectedEntry();
			data._objFirstSelected = dojo.clone(selected);

			// refresh icon in the com Log
			this.data.setShownLogs(true,false,false);

			// go in mode selection
			this.updateAppBar();
		}
	},

	addParticipant : function() {
		// go in mode addParticipant
		this.initSelectAction(this.data.STATUS_ADD_PARTICIPANT);
	},

	leaveConfN : function() {
		var selected = webapp.communication.data.getSelectedEntry();
		if (selected && selected.objCallData){
			ICTouchAPI.APIServices.Telephony.leaveConferenceN({
				params: [selected.objCallData.callId]
			});
		}
	},

	stopConf : function(strConfType) {
		var context = this;
		var popupData = {
			strTitle: _("End conference", 'webapp.communication'),
			strContent : _("Are you sure you want to end the conference?", 'webapp.communication'),
			strType: "warning",
			arrPopupButtons: [{
				strButtonName: "YES_BTN",
				strButtonLabel:  _("Yes", 'ICTouchAPI'),
				strButtonIcon: "generic-ok",
				callback: function() {
					context.yesStopConfCallback(strConfType);
				}
			},

			{
				strButtonName: "NO_BTN",
				strButtonIcon: "generic-cancel",
				strButtonLabel:  _("No", 'ICTouchAPI'),
				callback: function() {
					context.noStopConfCallback();
				}
			}]
		};
		this.stopConfPopup = ICTouchAPI.popupServices.addNewPopup(popupData, "MEDIUM");
	},

	yesStopConfCallback : function(strConfType) {
		if (strConfType == '3') {
			ICTouchAPI.popupServices.removePopup(this.stopConfPopup);
			ICTouchAPI.APIServices.Telephony.stopConference({});
			this.switchBackOnNComm(2);
		}
		else if (strConfType == 'N') {
			ICTouchAPI.popupServices.removePopup(this.stopConfPopup);
			var selected = webapp.communication.data.getSelectedEntry();
			if (selected && selected.objCallData){
				ICTouchAPI.APIServices.Telephony.stopConferenceN({
					params: [selected.objCallData.callId]
				});
			}
			this.switchBackOnNComm(1);
		}
	},

	noStopConfCallback : function() {
		ICTouchAPI.popupServices.removePopup(this.stopConfPopup);
	},

	getSelectedParticipant : function() {
		var data = webapp.communication.data;
		var phoneCallId = data.getSelectedEntry().objCallData.callId;
		var arrParticipants = data.getCallParticipants(phoneCallId);
		var index;
		if(this._intStatus === this.data.STATUS_CONFERENCE_PARTICIPANT_SELECTED){
			var arrIndex = this.uiConferenceList.getSelectedItemsIndex();
			index = arrIndex[0];
		} else if(this._intStatus === this.data.STATUS_CONFERENCE_PARTICIPANT_MENULIST_SELECTED){
			var participant = data.getSelectedEntryId();
			var pID = participant.split("_");
			index = pID[1];
		} else {
			index = 0;
		}
		// only one item
		return arrParticipants[index];
	},

	removeConferenceParticipant : function () {
		var objParticipant = this.getSelectedParticipant() ;
		if (!objParticipant) {
			return;
		}

		var phoneCallId = this.data.getSelectedEntry().objCallData.callId;
		ICTouchAPI.APIServices.Telephony.dropParticipant({
			params: [objParticipant.participantId,phoneCallId]
		});
	},

	muteUnmuteParticipant : function() {
		var objParticipant = this.getSelectedParticipant() ;
		if (!objParticipant){
			return;
		}

		var phoneCallId = this.data.getSelectedEntry().objCallData.callId;
		if (!objParticipant.muted){
			ICTouchAPI.APIServices.Telephony.muteParticipant({
				params: [objParticipant.participantId,phoneCallId]
			});
			objParticipant.muted = true;
		}
		else{
			ICTouchAPI.APIServices.Telephony.unMuteParticipant({
				params: [objParticipant.participantId,phoneCallId]
			});
			objParticipant.muted = false;
		}
	},

	getCallLogFromNumber : function (number) {
		var arrCalls = webapp.communication.data.getPhoneCalls();
		for (var i in arrCalls) {
			if(arrCalls[i].objCallData) {
				if(arrCalls[i].objCallData.phoneNumber === number || arrCalls[i].objCallData.phoneNumberCan === number){
					return arrCalls[i];
				} else if(webapp.communication.data.isInActiveConference(arrCalls[i])) {
					var phoneCallId = arrCalls[i].objCallData.callId;
					var arrParticipants = webapp.communication.data.getCallParticipants(phoneCallId);
					if(arrParticipants) {
						for(var j in arrParticipants) {
							if(arrParticipants[j].phoneNumber === number || arrParticipants[j].phoneNumberCan === number) {
								return arrCalls[i];
							}
						}
					}
				}
			}
		}
		number=null;
		return null;
	},

	getContactDetailsFromConference : function () {
		if (webapp.contacts) {
			var objContact = this.getSelectedParticipant() ;
			if (!objContact){
				return;
			}
			if(objContact.objContact){
				webapp.contacts.showContact({
					intId: objContact.objContact.contactId,
					clbkBack: function() {
						ICTouchAPI.transitionServices.getScreen({
							name: "webapp.communication.getCommunication",
							params: {}
						});
					}
				});
			}
		}
	},

	onConferenceListClick : function(intIndex){
		if (webapp.communication.uiConferenceList.hasSelectedItems()){
			if(webapp.communication._intStatus === webapp.communication.data.STATUS_CONFERENCE){
				webapp.communication._intStatus = webapp.communication.data.STATUS_CONFERENCE_PARTICIPANT_SELECTED;
			} else if (webapp.communication._intStatus === webapp.communication.data.STATUS_LOG_CONFERENCE) {
				webapp.communication._intStatus = webapp.communication.data.STATUS_LOG_CONFERENCE_PARTICIPANT_SELECTED;
			}
		}
		else{
			if(webapp.communication._intStatus === webapp.communication.data.STATUS_CONFERENCE_PARTICIPANT_SELECTED || webapp.communication._intStatus === webapp.communication.data.STATUS_CONFERENCE_PARTICIPANT_MENULIST_SELECTED){
				webapp.communication._intStatus = webapp.communication.data.STATUS_CONFERENCE;
			} else if (webapp.communication._intStatus === webapp.communication.data.STATUS_LOG_CONFERENCE_PARTICIPANT_SELECTED) {
				webapp.communication._intStatus = webapp.communication.data.STATUS_LOG_CONFERENCE;
			}
		}

		this.data.setCurrentContact(null, this.data.getSelectedEntry(), intIndex);
		webapp.communication.updateAppBar();
		intIndex=null;
	},

	onContactCardClick : function(ev) {
		var selectedEntry = webapp.communication.data.getSelectedEntry();
		if( selectedEntry != undefined && selectedEntry.objCallData && selectedEntry.intStatus == webapp.communication.data.STATUS_INCOMING){
			ev.stopPropagation();
			webapp.communication.apiAnswerCall(selectedEntry.objCallData.callId);
		}
	},

	// Return the action corresponding to the current select status.
	getKeyPadActionFromSelectStatus : function(){
		var strAction = "";
		if(this._intSelectStatus == this.data.STATUS_DEFLECT_TO){
			strAction = this.DIALACTION_DEFLECT;
		} else if(this._intSelectStatus == this.data.STATUS_TRANSFER_TO){
			strAction = this.DIALACTION_TRANSFER;
		} else if(this._intSelectStatus == this.data.STATUS_ADD_PARTICIPANT){
			strAction = this.DIALACTION_CONFERENCE;
		} else if(this._intSelectStatus == this.data.STATUS_PROGKEYS_CALL) {
			strAction = this.DIALACTION_PROGKEYS_CALL;
		} else if(this._intSelectStatus == this.data.STATUS_PROGKEYS_ROUTING) {
			strAction = this.DIALACTION_PROGKEYS_ROUTING;
		} else if(this._intSelectStatus == this.data.STATUS_MDR_ROUTING) {
			strAction = this.DIALACTION_MDR_ROUTING;
		} else if(this._intSelectStatus == this.data.STATUS_MDR_OVERFLOW) {
			strAction = this.DIALACTION_MDR_OVERFLOW;
		} else if(this._intSelectStatus == this.data.STATUS_MDR_USER) {
			strAction = this.DIALACTION_MDR_USER;
		} else if(this._intSelectStatus == this.data.STATUS_BASIC_ADD_ROUTING || this._intSelectStatus == this.data.STATUS_BASIC_IMMEDIATE_ROUTING) {
			strAction = this.DIALACTION_BASIC_ROUTING;
		}
		return strAction;
	},

	// This function is called to initiate an outgoing call. It opens a keyboard or a dial-pad.
	// If the webapp search exists, it's used (else a default dial-pad is used)
	showKeyPad : function(args) {
		var data = this.data;
		var searchType = args.searchType;
		var boolInitiatedFromGUI = args.boolInitiatedFromGUI;
		var boolInitiateByName = args.boolInitiateByName;
		// The "funcOpenDialpad" function will be called is webapp search when the dial-pad is deployed,
		//	and everytime it's swtiched between dial-pad and keyboard.
		//	It set the "notify by popup" boolean to true, and calls business method initiateOutgoingCall.
		var funcOpenDialpad;
		if (this.getSelectStatus() == -1) {
			if (boolInitiatedFromGUI) {
				funcOpenDialpad = function() {
					ICTouchAPI.APIServices.Telephony.initiateOutgoingCallGUI({});
				};
			}
			else {
				funcOpenDialpad = function() {
					ICTouchAPI.APIServices.Telephony.initiateOutgoingCallBO({});
				};
			}
		}

		if(boolInitiateByName) {
			webapp.communication.data.setBoolInitiateByName(true);
		}
		// Create the "search" object that contains parameters for the webapp search
		var objSearch = {
			contactDataTypes : ["Phone"],
			secondaryInformation : "phoneNumber", // information of the contact to be displayed at the right of the contact's display name in the search results
			useDefaultCallMethod : true,
			dialpadObject : {
				funcCallbackOk : function(){
					if(!webapp.communication.data.getBoolInitiateByName()){
						var callback = objSearch.lineClickCallback;

						callback.func.apply(callback.context, [null, {
							strContent: this.getValue()
						}]);
					}else{
						webapp.communication.data.setBoolInitiateByName(false);
					}
					ICTouchAPI.transitionServices.getScreen({
						name: "webapp.communication.getCommunication",
						sync: true, //To avoid the timer in transitionServices and to be sure that the comm webapp is displayed now.
						params: {}
					});
					webapp.communication.hideKeyboard(ICTouchAPI.keyboardServices.CLOSE_ACTION_NONE);
				},
				funcCallbackKeyPress : function(){
					ICTouchAPI.APIServices.Telephony.dialKeyEnter({});
					if (!webapp.communication.data._boolDialKeyEntered) {
						webapp.communication.data._boolDialKeyEntered = true;
						webapp.communication.mainWidget.emptyContactCard();
					}
				},
				funcCallbackExit : this.funcKeypadCallbackExit,
				funcCallbackManualExit : function(){
					webapp.communication.funcKeypadCallbackExit();
					webapp.communication.resetStatus();
				},
				strOkLabel		: this._arrContextLabelsIcons[this.getSelectStatus()] ? this._arrContextLabelsIcons[this.getSelectStatus()].labelOK  : "",
				strOkIcon		: this._arrContextLabelsIcons[this.getSelectStatus()] ? this._arrContextLabelsIcons[this.getSelectStatus()].icon : "",
				numPadLengthLimit : 40
			},
			onOpenDialpad : funcOpenDialpad,
			onOpenByName : function() {
				webapp.communication.hideKeyboard(ICTouchAPI.keyboardServices.CLOSE_ACTION_NONE);
				ICTouchAPI.APIServices.Telephony.cancelOutgoingCall({});
			}
		};
		// define a right icon for the search results, for which the callback is to display the contact card
		objSearch.rightIconClickCallback = {
			neededData : "Contact",
			rightIconImage  : "contacts-card-32",
			rightIconImageRemoteContact : "contacts-contact-card-remote-32",
			context:webapp.communication,
			func: function (objContact) {
				dojo.publish("e_contact_showContact",[{
					objContact: objContact,
					clbkBack: function() {
						ICTouchAPI.transitionServices.getScreen({
							name: "webapp.search.getSearch",
							params: {}
						});
					}
				}]);
			}
		};

		if( typeof args.boolForceDialpad !== "undefined" ) {
			objSearch.boolForceDialpad = args.boolForceDialpad;
		}

		if( typeof args.boolForceByname !== "undefined" ) {
			objSearch.boolForceByname = args.boolForceByname;
		}
		var byNameObject = {
			funcCallbackOk : function(){
				if(!webapp.communication.data.getBoolInitiateByName()){
					var callback = objSearch.lineClickCallback;
					callback.func.apply(callback.context, [null, {
						strContent: this.getValue()
					}]);
				}else{
					webapp.communication.data.setBoolInitiateByName(false);
				}
				webapp.communication.hideKeyboard(ICTouchAPI.keyboardServices.CLOSE_ACTION_NONE);
			},
			funcCallbackExit : function () {
				webapp.communication.hideKeyboard(ICTouchAPI.keyboardServices.CLOSE_ACTION_NONE);
			}
		}
		// Define the callback to be called to perform the requested action (call, start conference or transfer)
		switch (searchType) {
			case this.DIALACTION_CALL:
			case this.DIALACTION_CALL_BY_NAME:
				// define the action for the search results (click on the line of on the left icon), for which the callback is to call the contact
				objSearch.lineClickCallback = {
					neededData : "phoneNumber",
					leftIconImage  : "communication-call-32",
					leftIconImageConditionnalDisplay  : "phoneNumber",
					context:webapp.communication,
					func:webapp.communication.searchForCall
				};
				// byNameObject allows to overwrite the callback of the dialpadObject if they are redefined
				objSearch.byNameObject = byNameObject;
				break;
			case this.DIALACTION_CONFERENCE:
				// define the action for the search results (click on the line of on the left icon), for which the callback is to add the contact in the conference
				objSearch.lineClickCallback = {
					neededData : "phoneNumber",
					leftIconImage  : "communication-conference-add-participant-32",
					leftIconImageConditionnalDisplay  : "phoneNumber",
					context:webapp.communication,
					func:webapp.communication.startConferenceFromKeyboard
				};
				objSearch.byNameObject = byNameObject;
				break;
			case this.DIALACTION_TRANSFER:
				// define the action for the search results (click on the line of on the left icon), for which the callback is to transfert the call to the contact
				objSearch.lineClickCallback = {
					neededData : "phoneNumber",
					leftIconImage  : "communication-deflect-to-default-32",
					leftIconImageConditionnalDisplay  : "phoneNumber",
					context:webapp.communication,
					func:webapp.communication.transferToNumberFromKeyboard
				};
				objSearch.byNameObject = byNameObject;
				break;
			case this.DIALACTION_DEFLECT:
				// define the action for the search results (click on the line of on the left icon), for which the callback is to deflect the call to the contact
				objSearch.lineClickCallback = {
					neededData : "phoneNumber",
					leftIconImage  : "communication-deflect-to-default-32",
					leftIconImageConditionnalDisplay  : "phoneNumber",
					context:webapp.communication,
					func:webapp.communication.deflectToNumberFromKeyboard
				};
				objSearch.byNameObject = byNameObject;
				objSearch.onOpenDialpad = null;
				break;
			default:
				ICTouchAPI.debugServices.warning("webapp.communication.controlBase - showKeyPad / No searchType given to showKeyPad");
		}

		// If the search webapp exists, call it with the parameters defined above
		if (typeof webapp.search !== "undefined" && !args.useDialpad) {
			webapp.search.doSearch(objSearch, null);
		}
		// Else open standard dial-pad
		else
		{
			funcOpenDialpad();
			// show numeric
			ICTouchAPI.keyboardServices.deployKeyboard(ICTouchAPI.KeyboardTypes.DIALPAD, null, objSearch.dialpadObject);
		}
		if (searchType != this.DIALACTION_CALL_BY_NAME) {
			ICTouchAPI.ledServices.activate('dialer', 'ON');
		}
		this.data._boolKeyboardDeployed = true;
		args=null;
	},

	funcKeypadCallbackExit : function(){
		webapp.communication.data.setBoolInitiateByName(false);
		webapp.communication.hideKeyboard(ICTouchAPI.keyboardServices.CLOSE_ACTION_NONE);
		if (webapp.communication.getSelectStatus() == -1) {
			ICTouchAPI.APIServices.Telephony.cancelOutgoingCall({});
		}
		if(ICTouchAPI.transitionServices.getCurrentScreenName()==="webapp.search.getSearch"){
			if(webapp.search){
				webapp.search.boolPurgeResults = true;
			}
		}
	},

	hideKeyboard : function (closeParams) {
		if (this.data._boolDialKeyEntered && this.mainWidget) {
			this.mainWidget.reloadContainer();
			webapp.communication.data._boolDialKeyEntered = false;
		}
		if( this.data._boolKeyboardDeployed ) {
			if(this.data.objContactCard){
				this.updateOngoingTimer();
			}
			ICTouchAPI.keyboardServices.closeKeyboard(closeParams);
			ICTouchAPI.ledServices.desactivate('dialer', 'ON');
			this.data._boolKeyboardDeployed = false;
		}
		closeParams=null;
	},

	searchForCall : function(phoneNumber, objPhoneEntry) {
		ICTouchAPI.debugServices.info("webapp.communication.controlBase - searchForCall");
		var number = "";
		var boolNumbering = true;
		if (objPhoneEntry !== undefined){
			number = objPhoneEntry.strContent.replace(/\s/g,'');
			boolNumbering = false;
		}
		else{
			number = phoneNumber;
			boolNumbering = true; // phone number was obtained by doing a search
		}

		if (number && this.data._boolDialKeyEntered) {
			this.data._boolDialKeyEntered = false;
		}
		// we remove the mode select status and close keyboard if any
		this.cleanAfterKeyboardAction();

		if (number) {
			this.apiCall(number, boolNumbering);
			this.hideKeyboard(ICTouchAPI.keyboardServices.CLOSE_ACTION_NONE);
			ICTouchAPI.transitionServices.getScreen({
				name: "webapp.communication.getCommunication",
				params: {}
			});
		}
		phoneNumber=null;
		objPhoneEntry=null;
	},

	resetStatus : function(){
		if (this.getSelectStatus() !== -1) {
			this.setSelectStatus(-1);
			// Cancel conference or transfert
			this.data.cancelShownStatus();
				// select automatically the first call if it exists
			var firstItem = this.data.findItemByPosition(0);
				if (firstItem) {
				this.data.selectFirst();
				}
			// update action bar to the last item selected
			this.toggleOpacityTwoThird(false);
			this.updateAppBar();
		}
	},

	toggleOpacityTwoThird : function(boolOpacity) {
		if(webapp.communication.data.objContactCard) {
			webapp.communication.data.objContactCard.toggleOpacity(boolOpacity);
		}
		if(webapp.communication.data.objConferenceWidget) {
			webapp.communication.data.objConferenceWidget.toggleOpacity(boolOpacity);
		}
		boolOpacity=null;
	},

	// send DTMF button pushed, show dialPad with specific callbacks
	sendDTMFaction : function() {
		// deploy the keyboard
		var funcSendDTMF = {
			context:this,
			func:this.sendDTMF
		};
		var funcSendDTMFRelease = {
			context:this,
			func:this.sendDTMFRelease
		};
		var funcSendDTMFClose = {
			context:this,
			func:this.sendDTMFClose
		};
		var currentCall = this.data.getSelectedEntry();
		this.data._boolKeyboardDeployed = true;
		this.data._boolDTMFKeyboardDeployed = true;
		ICTouchAPI.ledServices.activate('dialer', 'ON');
		ICTouchAPI.keyboardServices.deployKeyboard(ICTouchAPI.KeyboardTypes.DTMF, null, {
			strDefaultText: "",
			funcCallbackKeyPress : funcSendDTMF,
			funcCallbackKeyReleased : funcSendDTMFRelease,
			funcCallbackOk: funcSendDTMFClose,
			funcCallbackExit: funcSendDTMFClose,
			strExitLabel: _('Hide','ICTouchAPI'),
			strExitIcon: "generic-down"
		});
	},

	// send a DTMF Signal via the core function
	sendDTMF : function(num) {
		if(num === 'backspace' || num === '+') {
			return;
		}else if (num === '*') {
			num = 10;
		}else if (num === '#') {
			num = 11;
		}
		// call the core function DTMF
		this._lastDTMF = num;
		this._boolDTMF = true;
		ICTouchAPI.APIServices.Telephony.sendDTMF({
			params:[webapp.communication.data.getSelectedEntryId(), num]
		});
		num=null;
	},

	sendDTMFRelease : function(num) {
		if(num === 'backspace' || num === '+' || (this._lastDTMF === num && !this._boolDTMF)) {
			return;
		}
		// call the core function DTMFRelease
		var that = this;
		//setTimeout(function(){
		if(that._boolDTMF === true){
			that._boolDTMF = false;
			ICTouchAPI.APIServices.Telephony.sendDTMFRelease({});
		}
		num=null;
	//}, 50);
	},

	sendDTMFClose : function() {
		ICTouchAPI.ledServices.desactivate('dialer','ON');
		this.data._boolKeyboardDeployed = false;
		this.data._boolDTMFKeyboardDeployed = false;
	},

	initNotificationsValue : function(){
		// Register notifications
		ICTouchAPI.notificationServices.addNotification({
			strNotificationName: "OngoingCall",
			strNotificationLabel: _("OngoingCall", "webapp.communication"),
			intNotificationValue: 0,
			callStatus : null,
			boolPreferLargeNotification: true,
			callback: {
				context:this,
				func:this.onNotificationOngoing
			}
		});
	},

	setStatus : function(value) {
		this._intStatus = value;
		value=null;
	},

	getStatus : function() {
		return this._intStatus;
	},

	setSelectStatus : function(value) {
		if(this._intSelectStatus!==value) {
			this._intSelectStatus = value;
			var params = {
				selectStatus: value
			};
			var statusContext = this._arrContextLabelsIcons[value];
			if(statusContext){
				params.labelOK = statusContext.labelOK;
				params.labelCancel = statusContext.labelCancel;
				params.icon = statusContext.icon;
			}
			dojo.publish("CommunicationSelectStatusChange", [params, this.data._objFirstSelected]);
		}
		value=null;
	},

	getSelectStatus : function() {
		return this._intSelectStatus;
	},

	/**
		 * eventMute from Audio
		 * change the status of the led
		 */
	eventAudioMute : function(objEvent)
	{
		var MUTE_ON  = 5;
		var MUTE_OFF = 6;
		var VALUE_SET_OFF   = 0; // value detected = set led OFF, dont know what it is, triggerer by hookon
		var VALUE_SET_OFF_2 = 2; // value detected = set led OFF, dont know what it is, triggerer by hookon

		var LED_MUTE = 0;

		// if not right value
		if(!objEvent.name || objEvent.name!=='audioevt'){
			return;
		}

		// if value different from previous event (it is send more times than one ...)
		if(objEvent.value === this.data.objOldAudioEventValue){
			return;
		}

		// save last value treated
		this.data.objOldAudioEventValue = objEvent.value;
		objEvent=null;
	},

	checkDirectoryError : function(intReturnValue) {
		var strMessage = "";
		switch (intReturnValue) {
			case 0:	// success
				return true;
			case 3:
				strMessage = _("ERROR_DIR_MAX_REACHED", "webapp.communication");
				break;
			case -1:
				strMessage = _("ERROR_DIR_OTHER", "webapp.communication");
				break;
			case 1:
				strMessage = _("ERROR_DIR_FORBIDDEN", "webapp.communication");
				break;
			case 2:
				strMessage = _("ERROR_DIR_NOT_FOUND", "webapp.communication");
				break;
			case 4:
				strMessage = _("ERROR_DIR_ALREADY_IN_PREVIEW", "webapp.communication");
				break;
			case 5:
				strMessage = _("ERROR_DIR_NOT_IN_PREVIEW", "webapp.communication");
				break;
			default:
				// Temporary removed because of IctDirectory problems
				strMessage = _("Unknown error message", "webapp.communication");
				intReturnValue=null;
				return false;

		}
		ICTouchAPI.popupServices.errorPopup(_("Error", "ICTouchAPI"), strMessage, _("Ok", "ICTouchAPI"));
		intReturnValue=null;
		return false;
	},

	/**
		 * onProgKeyConfig
		 * for Add/Edit progkey Arguments Testing.
		 */
	onProgKeyConfig : function(objAction, domNode, parentWidget){
		if(objAction.action.indexOf("call") != -1) {
			this._onProgKeyConfigCall(objAction);
		}
		objAction=null;
		domNode=null;
		parentWidget=null;
	},
	
	_onProgKeyConfigCall : function(objAction) {
		var objSearch = {
			searchType:this.getKeyPadActionFromSelectStatus()
		};

		this.setSelectStatus(this.data.STATUS_PROGKEYS_CALL);
		this.updateAppBar();
		this.data._objFirstSelected = this.data.getSelectedEntry();
		
		// open the dialpad
		if(objAction.action == "call-dialpad") {
			objSearch.useDefaultCallMethod = true;

			this._gotProgkeysNewCallDefaultMethod({
				objSearch : objSearch,
				objAction : objAction
			});
		}else if(objAction.action == "call-search"){
			objSearch.boolInitiateByName = true;
			objSearch.boolForceByname = true;
			this._gotProgkeysNewCallDefaultMethod({
				objSearch : objSearch,
				objAction : objAction
			});
		}else if(objAction.action == "call-contacts"){
			ICTouchAPI.transitionServices.getScreen({
				name: "webapp.contacts.getContact"
			});
		}

		objAction=null;
	},
	
	onProgkeyConfigRouting : function() {
		this.setSelectStatus(this.data.STATUS_PROGKEYS_ROUTING);
		this.updateAppBar();
	},

	_gotProgkeysNewCallDefaultMethod : function(args) {
		var boolInitiateByName	= args.boolInitiateByName;
		var boolForceByname = args.objSearch.boolForceByname;
		
		if(boolInitiateByName) {
			webapp.communication.data.setBoolInitiateByName(true);
		}
		var objSearch = {
			boolLocalContactsOnly : true,
			contactDataTypes: ["Phone"],
			secondaryInformation : "phoneNumber", // information of the contact to be displayed at the right of the contact's display name in the search results
			showVoicemailButton : false,
			showAddcontactButton : false
		};
		if(!boolForceByname) {
			objSearch.dialpadObject = {
				funcCallbackOk :  function() {
					if(!webapp.communication.data.getBoolInitiateByName()){
						var callback = objSearch.lineClickCallback;
						callback.func.apply(callback.context, [null, {
							strContent: this.getValue()
						}]);
					} else {
						webapp.communication.data.setBoolInitiateByName(false);
					}
				},
				funcCallbackManualExit : function(){
					webapp.progkeys.externalBack(false);
				},
				strDefaultText	: (args.objAction.arguments) ? args.objAction.arguments.strContent : "",
				strOkLabel		: _("Add shortcut", "webapp.communication"),
				strOkIcon		: "progkeys-add",
				numPadLengthLimit : 40
			}
		};
		// define a right icon for the search results, for which the callback is to display the contact card
		objSearch.rightIconClickCallback = {
			neededData : "Contact",
			rightIconImage  : "contacts-card-32",
			rightIconImageRemoteContact : "contacts-contact-card-remote-32",
			context:webapp.communication,
			func: function (objContact) {
				dojo.publish("e_contact_showContact",[{
					objContact: objContact,
					needStealth : true,
					clbkBack: function() {
						ICTouchAPI.transitionServices.unstealth("webapp.contacts.getContact");
						/*ICTouchAPI.transitionServices.getScreen({
							name: "webapp.search.getSearch",
							params: {}
						});*/
						ICTouchAPI.transitionServices.back();
					}
				}]);
			}
		};
		if( typeof args.objSearch.boolForceDialpad !== "undefined" ) {
			objSearch.boolForceDialpad = args.objSearch.boolForceDialpad;
		}
		
		if( typeof args.objSearch.boolForceByname !== "undefined" ) {
			objSearch.boolForceByname = args.objSearch.boolForceByname;
		}

		if( typeof args.objSearch.useDefaultCallMethod !== "undefined" ) {
			objSearch.useDefaultCallMethod = args.objSearch.useDefaultCallMethod;
		}

		var byNameObject = {
			funcCallbackOk : function(){
				if(!webapp.communication.data.getBoolInitiateByName()){
					var callback = objSearch.lineClickCallback;
					callback.func.apply(callback.context, [null, {
						strContent: this.getValue()
					}]);
				} else {
					webapp.communication.data.setBoolInitiateByName(false);
				}
			},
			funcCallbackExit : function () {
				webapp.progkeys.externalBack();
			}
		}

		// define the action for the search results (click on the line of on the left icon), for which the callback is to add the contact to progkeys
		objSearch.lineClickCallback = {
			neededData : "ContactSummary",
			leftIconImage  : "progkeys-add-32",
			leftIconImageConditionnalDisplay  : "phoneNumber",
			context:webapp.communication,
			func:webapp.communication._gotProgKeySearchResult
		};
		// byNameObject allows to overwrite the callback of the dialpadObject if they are redefined
		objSearch.byNameObject = byNameObject;
		
		if(webapp.search) {
			var backFunc = function() {webapp.progkeys.externalBack();};
			webapp.search.doSearch(objSearch, backFunc);
		} else { // Else open standard dial-pad
			// show numeric
			ICTouchAPI.keyboardServices.deployKeyboard(ICTouchAPI.KeyboardTypes.DIALPAD, null, objSearch.dialpadObject);
		}
		
		args=null;
	},

	_gotProgKeySearchResult : function(objContact, objPhoneNumber) {
		var srtPhoneNumber;
		if (objContact) {
			objContact.source = "search";
		}
		else if (objPhoneNumber) {
			srtPhoneNumber = objPhoneNumber.strContent;
		}
		this._progKeySetArgs(srtPhoneNumber, objContact);
	},
	
	_progKeySetArgs : function(intPhoneNumber, objEntry) {
		this.setSelectStatus(-1);
		this.updateAppBar();

		if (objEntry) {
			var args	= {};
			var regexp		= /^#CONTACT_[0-9]*#$/;	// Vérifie la validité de l'identifiant d'un contact
			switch(objEntry.source) {
				case "contact" :
					args.source		= objEntry.source;
					args.strContent	= intPhoneNumber;
					args.contactId	= objEntry.contactId;
					break;
				case "search" :
					args.source		= objEntry.source;
					args.strContent	= objEntry.officePhone;
					args.contactId	= objEntry.contactId;
					break;
				case "history" :
					args.source		= objEntry.source;
					args.strContent	= objEntry.objLogData.listContactSummary[0].officePhone;
					if(objEntry.objLogData.contactId.match(regexp)) {
						args.contactId		= objEntry.objLogData.contactId;
					}
					break;
				default :
					args.strContent	= objEntry.strContent;
					break;
			}
			this._progKeySetNumber(args);
		} 
		else if (intPhoneNumber) {
			this._progKeySetNumber({strContent:intPhoneNumber});
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.communication.controlBase - _progKeySetArgs / intPhoneNumber and objEntry are not defined!");
		}
		
		intPhoneNumber	= null;
		objEntry = null;
	},
	
	_progKeySetNumber : function(args) {
		webapp.progkeys.setProgkeysArgumentsNextStep(args);
		args = null;
	},
	
	/**
		 * onProgKeyDisplay
		 * if cancatID is not null, display the contact image or default photo
		 */
	onProgKeyDisplay :  function(objAction, progkey) {
		if(objAction.action.indexOf("call") != -1) {
			var myDS		= ICTouchAPI.dataStoreServices.getStore('contacts');
			var objContact	= null;
			if(objAction.arguments.contactId && objAction.arguments.contactId != undefined) {
				objContact = myDS.getAt(objAction.arguments.contactId);
				progkey.image = ( objContact.photo) ?  objContact.photo : ICTouchAPI.tools.getDefaultPhotoPath("user", "50");
			} else if(objAction.arguments.strContent && objAction.arguments.strContent != undefined) {
				var arrContacts = myDS.find(["officePhone", "personalHome", "personalMobile", "officePhoneCan", "personalHomeCan", "personalMobileCan", "assistant", "personalFax"], objAction.arguments.strContent);
				if(arrContacts.length > 0) {
					objContact		= arrContacts[0];
					progkey.image = ( objContact.photo) ?  objContact.photo : ICTouchAPI.tools.getDefaultPhotoPath("user", "50");
			}
			}
		}
		objAction = null;
		progkey = null;
	},
	
	/**
		 * onProgKeyAction
		 * @return : list of Template of actions
		 */
	onProgKeyAction : function() {
		var listActions = [];
		listActions.push({
			webAppName : "communication",
			action : "call-contacts",
			type : 1,
			icon   : "communication-call",
			label : "Contacts",
			screens : ["webapp.contacts.getContact"]
		});
		listActions.push({
			webAppName : "communication",
			action : "call-search",
			type : 1,
			icon   : "communication-call",
			label : "Search local contact",
			screens : ["webapp.search.getSearch", "webapp.contacts.getContact"]
		});
		listActions.push({
			webAppName : "communication",
			action : "call-dialpad",
			type : 1,
			icon   : "communication-call",
			label : "Dialpad",
			screens : ["webapp.communication.getHistory", "webapp.contacts.getContact", "webapp.search.getSearch"]
		});

		return listActions;
	},
	
	onProgKeyClick : function(objAction) {
		// get the phone number: if objAction.arguments.strContent is undefined, the key is a DM homepageKey, use objAction.arguments
		var phoneNumber = objAction.arguments.strContent ? objAction.arguments.strContent : objAction.arguments;
		if(objAction.action.indexOf("call") != -1) {
			webapp.communication.apiCall(phoneNumber, true);
			ICTouchAPI.transitionServices.getScreen({
				name: "webapp.communication.getCommunication",
				params: {}
			});
		}
		objAction	= null;
	},
	
	onProgKeyLongPress : function(objAction) {
		if(objAction.action.indexOf("call") != -1) {
			var myDS = ICTouchAPI.dataStoreServices.getStore('contacts');
			var objContact	= null;
			if(objAction.arguments.contactId) {
				objContact = myDS.getAt(objAction.arguments.contactId);
			} else if(objAction.arguments.strContent) {
				var arrContacts = myDS.find(["officePhone", "personalHome", "personalMobile", "officePhoneCan", "personalHomeCan", "personalMobileCan", "assistant", "personalFax"], objAction.arguments.strContent);
				if(arrContacts.length > 0) {
					objContact		= arrContacts[0];
				}
			}

			if(webapp.contacts && objContact) {
				webapp.contacts.showContact({
					objContact : objContact
				});
			}
			else{
				this.onProgKeyClick(objAction);
			}
		}
		objAction	= null;
	},
	
	onDateFormatChanged: function(objSetting) {
		if (objSetting !== null) {
			this.data._dateFormat = objSetting.allowedValues[objSetting.jsValue].name;
		}
		objSetting=null;
	},

	onTimeFormatChanged: function(objSetting) {
		if (objSetting != null) {
			this.data._24hformat = objSetting.jsValue;
		}
		objSetting=null;
	},


	onUserRoleChanged : function(objSetting){
		if(objSetting){
			webapp.communication.data.setUserRole(objSetting.jsValue);
		}
	},

	doContextStatusCall : function(intPhoneNumber, doDialableNumber, objContact, objEntry) {
		if(intPhoneNumber!=null) {
			if (this.getSelectStatus() < 0) {
				if(!objContact) {
					this.mainWidget.emptyContactCard();
				}
				this.apiCall(intPhoneNumber, doDialableNumber);
			}
			else {
				var firstCallId = (this.data._objFirstSelected && this.data._objFirstSelected.objCallData) ? this.data._objFirstSelected.objCallData.callId : "";
				switch (this.getSelectStatus()) {
					case this.data.STATUS_ADD_PARTICIPANT:
						this.apiAddParticipant(firstCallId, intPhoneNumber, doDialableNumber);
						this.data.cancelShownStatus();
						break;
					case this.data.STATUS_TRANSFER_TO:
						this.apiTransferPhoneCallToNumber(firstCallId, intPhoneNumber, doDialableNumber);
						break;
					case this.data.STATUS_DEFLECT_TO:
						// remove selection Mode
						this.setSelectStatus(-1);
						this.apiDeflectToNumber(firstCallId, intPhoneNumber, doDialableNumber);
						break;
					case this.data.STATUS_PROGKEYS_CALL:
						ICTouchAPI.transitionServices.unstealth("webapp.contacts.getContact");
						objContact.source = "contact";
						this._progKeySetArgs(intPhoneNumber, objContact);
						break;
					case this.data.STATUS_PROGKEYS_ROUTING:
						ICTouchAPI.transitionServices.unstealth("webapp.contacts.getContact");
						objContact.source = "contact";
						webapp.userservices._progKeySetNumber(intPhoneNumber, objContact);
						break;
					case this.data.STATUS_MDR_ROUTING:
						ICTouchAPI.transitionServices.unstealth("webapp.contacts.getContact");
						if(!objEntry){
							objEntry = {
								strContent : intPhoneNumber
							};
						}
						objEntry.source = "contact";
						webapp.userservices.data.setOtherNumber(intPhoneNumber, objEntry);
						break;
					case this.data.STATUS_MDR_OVERFLOW:
						ICTouchAPI.transitionServices.unstealth("webapp.contacts.getContact");
						if(!objEntry){
							objEntry = {
								strContent : intPhoneNumber
							};
						}
						objEntry.source = "contact";
						webapp.userservices.data.searchForOverflow(intPhoneNumber, objEntry);
						break;
					case this.data.STATUS_MDR_USER:
						ICTouchAPI.transitionServices.unstealth("webapp.contacts.getContact");
						if(intPhoneNumber){
							webapp.userservices.data.setUserRouting(intPhoneNumber, null);
						}
						break;
					case this.data.STATUS_BASIC_ADD_ROUTING:
						if(intPhoneNumber){
							webapp.userservices.data.searchForRoutingDestination(intPhoneNumber, null);
						}
						break;
					case this.data.STATUS_BASIC_IMMEDIATE_ROUTING:
						if(intPhoneNumber){
							webapp.userservices.data.searchForImmediateRouting(intPhoneNumber, null);
						}
						break;
				}

			}
		}
		intPhoneNumber		= null;
		doDialableNumber	= null;
		objContact			= null;
		objEntry			= null;
	},

	webcamAvailableCallback : function(capability, value) {
		ICTouchAPI.debugServices.debug("webapp.communication / webcamAvailableCallback capability="+capability+" value="+value);
		if (value == ICTouchAPI.CapabilityServices.AVAILABLE) {
			this.data.boolHasVideoRights = true;
		} else {
			this.data.boolHasVideoRights = false;
		}
		// if we're viewing a contact card
		if (this.data.getContainerPath() == "webapp.communication.getContactCard" && this.data.getCurrentContact()) {
			this.data.askForReloadContainer(false);
		}
		capability=null;
		value=null;
	},

	apiOpenDoorCall: function(callId) {
		ICTouchAPI.APIServices.Telephony.openDoor({
			params:[callId],
			context:this
		});
	},
	
	updateTime: function( strTime ) {
		if(strTime != this.strCallDuration)
		{
			if( strTime && this.mainWidget)
			{
				var objTitle = this.mainWidget.container.getTitle();
				objTitle.setSecondaryLabel(strTime, 0);
			}

			this.strCallDuration = strTime;
		}

		strTime = null;
	},

	// start Timer For on going Communication
	startTimerOngoing : function () {

		// if there is already a timer running, just refresh the time of the selected ongoing call (don't recreate a new timer)
		if(this._handlerTimerOngoingCall) {
			return;
		}

		else {
			var that = this;
			var func = function () {
				that.updateOngoingTimer();
			};

			func();
			this._handlerTimerOngoingCall = setInterval(func, 1000);

			ICTouchAPI.debugServices.info("webapp.communication - startTimerOngoing");
		}
	},

	stopTimerOngoing : function () {

		// if the timer is already null, nothing to do -> return
		if(this._handlerTimerOngoingCall == null) {
			return;
		}

		else {
			clearInterval(this._handlerTimerOngoingCall);
			this._handlerTimerOngoingCall = null;
			ICTouchAPI.debugServices.info("webapp.communication - stopTimerOngoing");
		}

	},

	updateOngoingTimer : function() {

		// Update only if there is no keyboard to hide the screen.
		if( !this.data._boolKeyboardDeployed )
		{
			var selectedEntry = this.data.getSelectedEntry();
			var strTime = this.data.getStrCallDuration(selectedEntry);

			this.updateTime(strTime);
		}

	}
});
