dojo.require("webapp.communication.controlBase");
dojo.provide("webapp.communication");
dojo.declare("webapp.communication",webapp.communication.controlBase,
{

	buttonCallback : function(buttonId) {
		var data = webapp.communication.data;
		var currentCall;
		var number;
		var objContact;
		switch(buttonId)
		{
			case data.BACK:
				dojo.publish("OpenHomepage");
				break;
			case data.SEARCH:
				if (typeof webapp.search !== "undefined") {
					webapp.communication.showKeyPad({searchType: this.getKeyPadActionFromSelectStatus(), boolInitiatedFromGUI: true, boolForceByname: true, boolInitiateByName: true});
				}
				break;
			case data.CALL:
				var doDialableNumber = false;
				objContact = data.getCurrentContact();
				number = ICTouchAPI.tools.getContactPhone(objContact);

				if( number ) {
					this.apiCall(number, doDialableNumber, true);
				}
				break;			
			case data.NEW_CALL:
				this.showKeyPad({
					searchType: this.DIALACTION_CALL,
					boolInitiatedFromGUI: true
				});
				break;
			case data.ANSWER:
				// get the item id in the clickable list
				currentCall = data.getSelectedEntry();
				// get the callId
				this.apiAnswerCall(currentCall.objCallData.callId);
				break;
			case data.IGNORE:
				// get the item id in the clickable list
				currentCall = data.getSelectedEntry();
				// get the callId
				this.apiIgnoreCall(currentCall.objCallData.callId);
				break;
			case data.REJECT:
				// get the item id in the clickable list
				currentCall = data.getSelectedEntry();
				// get the callId
				this.apiRejectCall(currentCall.objCallData.callId);
				break;
			case data.END_CALL:
				var callId = null;
				this.hideKeyboard(ICTouchAPI.keyboardServices.CLOSE_ACTION_EXIT);
				if(this._intStatus === data.STATUS_CONFERENCE_PARTICIPANT_SELECTED || this._intStatus === data.STATUS_CONFERENCE_PARTICIPANT_MENULIST_SELECTED){
					var participant = this.getSelectedParticipant();
					number = participant.phoneNumber || participant.objContact.officePhone;
					callId = data.getCallIdByPhoneNumber(number);
				} else {
					// get the item id in the clickable list
					currentCall = data.getSelectedEntry();
					// get the callId
					callId = currentCall.objCallData.callId
				}
				this.apiEndCall(callId);
				this.switchBackOnNComm(1);
				break;
			case data.ADD_PARTICIPANT:
				this.addParticipant();
				break;
			case data.MERGE:
				this.mergeCalls();
				break;
			case data.CONFERENCE:
				this.initConf3();
				break;
			case data.STOP_CONFERENCE_3:
				this.stopConf('3');
				break;
			case data.LEAVE_CONFERENCE_N:
				this.leaveConfN();
				this.switchBackOnNComm(1);
				break;
			case data.STOP_CONFERENCE_N:
				this.stopConf('N');
				break;
			case data.REMOVE_PARTICIPANT:
				this.removeConferenceParticipant();
				break;
			case data.CONTACT_DETAILS:
				this.getContactDetailsFromConference();
				break;
			case data.CANCEL_INIT_CONF3:
			case data.CANCEL_TRANSFER_TO:
			case data.CANCEL_ADD_PARTICIPANT:
			case data.CANCEL:
				if( this._intSelectStatus === data.STATUS_ADD_PARTICIPANT ||
					this._intSelectStatus === data.STATUS_MERGE_CALLS ||
					this._intSelectStatus === data.STATUS_INIT_CONF3 ||
					this._intSelectStatus === data.STATUS_TRANSFER ||
					this._intSelectStatus === data.STATUS_TRANSFER_TO ||
					this._intSelectStatus === data.STATUS_DEFLECT_TO)
				{
					var oldstatus = this._intSelectStatus;
					this.resetStatus();
                    if( oldstatus === data.STATUS_ADD_PARTICIPANT ||
                        oldstatus === data.STATUS_TRANSFER_TO) {
                        if(data._intLastSelected > 0) {
                            data.refreshDetails();
                        } else {
                            data.loadDetails(data.objActiveComlog.arrItems[0].intIndex);
						}
                    }
				}
				break;
			case data.TO_DIALER:
				var objSearch = {
					searchType:this.getKeyPadActionFromSelectStatus(),
					boolInitiatedFromGUI: true
				};
				if(this._intSelectStatus == data.STATUS_DEFLECT_TO) {
					objSearch.useDialpad = true;
				}
				this.showKeyPad(objSearch);
				break;
			case data.DEFLECT_NUMBER:
				this.initDeflectNumber();
				break;
			case data.TRANSFER:
				this.initTransfer();
				break;
			case data.TRANSFER_TO:
				this.initTransferTo();
				break;
			case data.DELETE_LOG:
				this.deleteLog();
				break;
			case data.DELETE_ALL_LOG:
				this.deleteAllLogs();
				break;
			case data.HOLD:
				// get the item id in the clickable list
				currentCall = data.getSelectedEntry();
				// get the callId
				this.apiHoldCall(currentCall.objCallData.callId);
				break;
			case data.RETRIEVE:
				// get the item id in the clickable list
				currentCall = data.getSelectedEntry();
				// get the callId
				this.apiRetrieveCall(currentCall.objCallData.callId);
				break;
			case data.START_RECORDING:
				// get the item id in the clickable list
				currentCall = data.getSelectedEntry();
				// get the callId
				this.apiStartRecording(currentCall.objCallData.callId);
				break;
			case data.PAUSE_RECORDING:
				// get the item id in the clickable list
				currentCall = data.getSelectedEntry();
				// get the callId
				this.apiPauseRecording(currentCall.objCallData.callId);
				break;
			case data.RESUME_RECORDING:
				// get the item id in the clickable list
				currentCall = data.getSelectedEntry();
				// get the callId
				this.apiResumeRecording(currentCall.objCallData.callId);
				break;
			case data.STOP_RECORDING:
				// get the item id in the clickable list
				currentCall = data.getSelectedEntry();
				// get the callId
				this.apiStopRecording(currentCall.objCallData.callId);
				break;
			case data.CALL_BACK:
				// get the item id in the clickable list
				currentCall = data.getSelectedEntry();
				this.apiRequestCallBack(currentCall.objCallData.callId);
				break;			
			case data.DTMF:
				// get the callId
				this.sendDTMFaction();
				break;
			case data.CANCEL_CALL:
				// get the item id in the clickable list
				currentCall = data.getSelectedEntry();
				this.apiEndCall(currentCall.objCallData.callId);
				this.switchBackOnNComm(1);
				break;
			case data.VOICEMAIL:
				// get the item id in the clickable list
				currentCall = data.getSelectedEntry();
				this.apiOverflowToVM(currentCall.objCallData.callId);
				break;
			case data.DEFLECT_VM:
				// get the item id in the clickable list
				currentCall = data.getSelectedEntry();
				this.apiDeflectToVM(currentCall.objCallData.callId);
				break;
			case data.DEFLECT_DVA_BTN:
				// get the item id in the clickable list
				currentCall = data.getSelectedEntry();
				this.apiDeflectToDVA(currentCall.objCallData.callId);
				break;
			case data.DOORCAM_OPENDOOR:
				currentCall = data.getSelectedEntry();
				this.apiOpenDoorCall(currentCall.objCallData.callId);
				break;

			default:
				ICTouchAPI.debugServices.warning("webapp.communication.control8082 - buttonCallback / no callback is defined for this button id: " + buttonId);
				break;
		}
		buttonId=null;
	}
});

webapp.communication = new webapp.communication();
