dojo.require("webapp.communication.controlBase");
dojo.provide("webapp.communication");
dojo.declare("webapp.communication",webapp.communication.controlBase,
{
	buttonCallback : function(buttonId) {
		var currentCall;
		var data = webapp.communication.data;
		switch(buttonId)
		{
			case data.BACK:
				if (data._strContainerPath != "webapp.communication.getCommunicationLog")
					dojo.publish("OpenHomepage");
				else
				{
					data.switchContainer("getCommunicationLog", data.STATUS_EMPTY, data.getCommunicationListTitle());
				}
				break;
			case data.CALL:
				var objContact = data.getCurrentContact();
				var number = ICTouchAPI.tools.getContactPhone(objContact);
				if( number )
					this.apiCall(number);
				break;
			case data.NEW_CALL:
				this.showKeyPad({
					searchType: this.DIALACTION_CALL,
					boolInitiatedFromGUI: true
				});
				break;
			case data.ANSWER:
				// get the item id in the clickable list
				currentCall = data.getSelectedEntry();
				// get the callId
				this.apiAnswerCall(currentCall.objCallData.callId);
				break;
			case data.IGNORE:
				// get the item id in the clickable list
				currentCall = data.getSelectedEntry();
				// get the callId
				this.apiIgnoreCall(currentCall.objCallData.callId);
				break;
			case data.REJECT:
				// get the item id in the clickable list
				currentCall = data.getSelectedEntry();
				// get the callId
				this.apiRejectCall(currentCall.objCallData.callId);
				break;
			case data.END_CALL:
				// get the item id in the clickable list
				currentCall = data.getSelectedEntry();
				// get the callId
				this.apiEndCall(currentCall.objCallData.callId);
				break;

			case data.CONFERENCE:
				this.selectParticipant();
				break;

			case data.CANCEL_CONFERENCE:
				this.cancelConference();
				break;

			case data.REMOVE_PARTICIPANT:
				this.removeConferenceParticipant();
				break;

			case data.CONTACT_DETAILS:
				this.getContactDetailsFromConference();
				break;

			case data.CANCEL:
				if (this._intSelectStatus == data.STATUS_CONFERENCE_ADD_PARTICIPANT ||
					this._intSelectStatus == data.STATUS_TRANSFER_TO)
					{
					// Cancel conference or transfert
					data.loadList(); // refresh list
					// update action bar to the last item selected
					this._intSelectStatus = -1;
					this.updateAppBar();
				}
				break;

			case data.FILTER:
				webapp.communication.showFilters();
				break;

			case data.TO_DIALER:
				switch(this._intSelectStatus)
				{
					case data.STATUS_CONFERENCE_ADD_PARTICIPANT:
						this.showKeyPad({
							searchType: this.DIALACTION_CONFERENCE,
							boolInitiatedFromGUI: true
						});
						break;
					case data.STATUS_TRANSFER_TO:
						this.showKeyPad({
							searchType: this.DIALACTION_TRANSFER,
							boolInitiatedFromGUI: true
						});
						break;
				}
				break;

			case data.TRANSFER:
				this.transferTo();
				break;

			case data.DELETE_LOG:
				this.deleteLog();
				break;

			case data.DELETE_ALL_LOG:
				this.deleteAllLogs();
				break;

			case data.HOLD:
				// get the item id in the clickable list
				currentCall = data.getSelectedEntry();
				// get the callId
				this.apiHoldCall(currentCall.objCallData.callId);
				break;

			case data.RETRIEVE:
				// get the item id in the clickable list
				currentCall = data.getSelectedEntry();
				// get the callId
				this.apiRetrieveCall(currentCall.objCallData.callId);
				break;

			case data.DTMF:
				// get the item id in the clickable list
				currentCall = data.getSelectedEntry();
				this._intDtmfCall = currentCall.objCallData.callId;
				// get the callId
				this.sendDTMFaction();
				break;

			case data.ANSWER_BY_MAIL_BTN:
				//FIXME this is just for testing purposes, to be replaced by an external function that adds this button
				var emailData = webapp.email.data;
				//get current callId
				currentCall = data.getSelectedEntry();
				//ignore incoling call
				this.apiIgnoreCall(currentCall.objCallData.callId);
				//change to the zidget of Mail Edition
				ICTouchAPI.transitionServices.getScreen({
					name: "webapp.email.getEmail",
					params: {}
				});
				emailData.switchContainer("getMailEdition", emailData.STATUS_EDITION, "Mail Edition");
				break;

			default:
				console.warn("buttonCallbak : no callback is defined for this button id:"+buttonId);
		}
	}
});

webapp.communication = new webapp.communication();
