/**
 * getProgKeysPreviewContent
 * Widget(view) homepage preview content : List of progkeys (4 visibles, n scrollables)
 *
 *   domProgKeysList	{DOMNode}: DomNode for progkeys list (ul)
 *   _lstKeysButtons	{List}	 : Progkeys list
 *   _hListUpdated		{Object} : Dojo connect for list update
 */
dojo.require("webapp.progkeys.getProgKeysPreviewContentBase");
dojo.provide("webapp.progkeys.getProgKeysPreviewContent");
dojo.declare("webapp.progkeys.getProgKeysPreviewContent", webapp.progkeys.getProgKeysPreviewContentBase,
{
    
    templatePath: dojo.moduleUrl("webapp.progkeys","templates/getProgKeysPreviewContent8082.html"),
/*
	domProgKeysList			: null,
	_lstKeysButtons			: [],
	_listUpdatedHandler		: null,
	//	myFeedback			: null,

	constructor: function() {
//		this.myFeedback = ICTouchAPI.feedbackServices.initFeedback("click");
    },

	postMixInProperties : function(){
	},

	 //Create application bar, get and active filter, set the vertical scroll
	postCreate: function(){
		FXScroll.init({
			"handler" : this.domNode,
			"scrollType" : "vertical"
		});
		this.fillProgKeysList();
		this._listUpdatedHandler = this.subscribe('programmablekeys/keysListUpdated', this.progKeysListUpdated);
	},

	destroy: function() {
		this.unsubscribe(this._listUpdatedHandler);
		this.removeProgKeysList();
		this.inherited(arguments);
	},

	removeProgKeysList : function() {
		dojo.empty(this.domProgKeysList);
		for(var i=0;i<this._lstKeysButtons.length;i++) {
			this._lstKeysButtons[i].button.destroy();
			this._lstKeysButtons[i] = null;
		}
		this._lstKeysButtons = [];
		if(this._i18nizedHandlers){
			ICTouchAPI.i18nServices.unsubscribeAllI18nHandlers(this);
		}
    },

	//updates and fill the arrProgkeys array and lstProgKeys list
	fillProgKeysList : function() {
		var data = webapp.progkeys.data;
		var arrProgKeys = data.arrProgKeys["0"];
		if(this._i18nizedHandlers){
			ICTouchAPI.i18nServices.unsubscribeAllI18nHandlers(this);
		}
		this.removeProgKeysList();
		if(arrProgKeys != undefined){
			for(var i in arrProgKeys){
				if(arrProgKeys[i]) {
					this.addProgKey(arrProgKeys[i]);
				}
			}
		}
		//Show active progkeys only
		var currActiveTypes = data.lstActiveTypes;
		var dojoNodeProgKeyList = new dojo.NodeList(this.domProgKeysList);
		for(var activeType in currActiveTypes){
			dojo.forEach(dojoNodeProgKeyList.query("."+activeType), function(progKey){
				progKey.style.display="";
			});
		}
	},

	addProgKey : function(objCurrentKey) {		
		var liNode = dojo.create("li", {}, this.domGetHomepage);
		this.domProgKeysList.appendChild(liNode);
		this._createProgKey(objCurrentKey, liNode);
	},

	modifyProgKey : function(objCurrentKey) {
		var pos = objCurrentKey.position;
		if(objCurrentKey.idKey === this._lstKeysButtons[pos].idKey) {
			var objAction = webapp.progkeys.data.getActionById(objCurrentKey.idAction);
			if(objCurrentKey.icon!==this._lstKeysButtons[pos].icon || objAction.label!==this._lstKeysButtons[pos].label) {
				//Destroy old button
				this._lstKeysButtons[pos].button.destroy();
				//remove background image
				var liNode = dojo.query("li",this.domProgKeysList)[pos];
				dojo.removeClass(liNode)
				//recreate button
				this._createProgKey(objCurrentKey, liNode);
			}
		}
	},

	deleteProgKey : function(idKey) {
		var position = null;
		for(var i in this._lstKeysButtons) {
			if(this._lstKeysButtons[i].idKey === idKey) {
				position = i;
				break;
			}
		}
		if (position!=null) {
			var li = this._lstKeysButtons[position].button.domNode.parentNode;
			this._lstKeysButtons[position].button.destroy();
			this._lstKeysButtons.splice(position,1);
			dojo.destroy(li);
		}
	},

	//Callback for progkeysList update (On dojo event)
	progKeysListUpdated : function(){
		this.removeProgKeysList();
		this.fillProgKeysList();
	},
	

	//Callback for progkey selection.
    progKeySelected : function(idKey){
		if(!webapp.progkeys.data._lockProgkeysCallback) {
			var data = webapp.progkeys.data;
			var currentProgKey = data.lstProgKeys["0"][idKey];
			var currentAction = data.getActionById(currentProgKey.idAction);
			webapp[currentAction.webAppName].onProgKeyClick(currentAction);
		}
    },


	_createProgKey : function(objCurrentKey,liNode) {
		var data = webapp.progkeys.data;
		var objAction = data.getActionById(objCurrentKey.idAction);
		//Execute action on display progkey
		if(objAction && webapp[objAction.webAppName] && webapp[objAction.webAppName].onProgKeyDisplay){
			webapp[objAction.webAppName].onProgKeyDisplay(objAction, objCurrentKey);
		}
		objCurrentKey.className = ""+objAction.type;

		//Set LI class
		dojo.addClass(liNode , "progkey");
		if (objCurrentKey.className) {
			dojo.addClass(liNode, objCurrentKey.className);
		}
		// Fill item template
		var newKey = {
			strButtonLabel	: "",
			strButtonName : objCurrentKey.idKey,
			callback : dojo.hitch(this, this.progKeySelected)
		};
		if(!objCurrentKey.image){
			newKey.strButtonIcon = objCurrentKey.icon;
		}
		if (objAction.label) {
			newKey.strButtonLabel = objAction.label;
		}		
		liNode.setAttribute("idKey", objCurrentKey.idKey);
		

		//Create buttonControls
		var button = new UIElements.AppButton.ButtonControl(newKey);		
		// Add button into node
		this._lstKeysButtons[objCurrentKey.position] = {button:button,idKey:objCurrentKey.idKey,icon:objCurrentKey.icon,label:objAction.label};
		button.placeAt(liNode, "first");
		if(objCurrentKey.image){
			var image = dojo.query("span", liNode)[0];
			dojo.style(image,"backgroundImage", "url('"+objCurrentKey.image+"')");
			dojo.addClass(image, "specificIcon");
		}

		//Add target webapp skin
		if(!data._loadedSkin["webapp."+objAction.webAppName]) {
			//ICTouchAPI.skinServices.linkWebappsStyles("webapp.progkeys","webapp."+objAction.webAppName,true,false,true,false);
			data._loadedSkin["webapp."+objAction.webAppName] = true;
		}
		//Add internationalization
		if(objAction.label && webapp[objAction.webAppName]) {
			objCurrentKey.i18nlabel = _(objAction.label, "webapp."+objAction.webAppName);
			var handler = ICTouchAPI.i18nServices.i18nList(objCurrentKey, function (name, value) {
				return true;
			});
			ICTouchAPI.i18nServices.addI18nHandlers(this, handler);
		}
		else {
			objCurrentKey.i18nlabel = "";
		}
	},


	_feedBack : function(clickEvent) {
//		this.myFeedback.feedback(clickEvent);
	},

	_openProgkey:function(){
		ICTouchAPI.transitionServices.getScreen({name: "webapp.progkeys.getProgKeys", params:  {}});
	},

	_clicked : function(event){
		// Ignore event with a strange eventPhase...
		if (event.eventPhase) {
			this._openProgkey();
		}
	},

    */
});
