/**
 * getProgKeysFiltersSelectList
 * Widget(view) used for filter activation/deactivation
 *
 * _filtersListUI	{Object}	: Instanciated selectList
 * _arrItemList		{Array}		: Items for the select list
 * domSelectList	{domNode}	: Attach point for the selectlist
 */
dojo.require("webapp.progkeys.getProgKeysFiltersSelectListBase");
dojo.provide("webapp.progkeys.getProgKeysFiltersSelectList");
dojo.declare("webapp.progkeys.getProgKeysFiltersSelectList", webapp.progkeys.getProgKeysFiltersSelectListBase,
{
	templatePath	: dojo.moduleUrl("webapp.progkeys","templates/getProgKeysFiltersSelectList8082.html"),
	_filtersListUI	: {},
	domSelectList	: {},
	_arrItemList	: [],
	constructor		: function(){

	},
	postMixInProperties : function(){
		
	},
	//Get the ActionTypes list and fill the itemlist with it
	postCreate : function(){
		this._arrItemList = [];
		var lstActionTypes = webapp.progkeys.data.lstActionTypes;
		for(var i in lstActionTypes){ // i is the type
			var listItem = {};
			if(webapp.progkeys.data.lstActiveTypes[i]){
				listItem.boolSelected = true;
			}
			listItem.strLabel=webapp.progkeys.data.getStrTypeById(i);
			listItem.intIndex=i;
			this._arrItemList.push(listItem);
		}
		this._filtersListUI = new UIElements.SelectList.SelectListControl({
			arrItems: this._arrItemList,
			//strCheckedIcon : "Default",
			intContainerSize: 5,
			boolMultiselect: true,
			itemCallback: dojo.hitch(this, this.toggleFilter)
		}, this.domSelectList);
	},
	//Set a filter active/inactive
	toggleFilter : function(intIndex, boolSelected){
		webapp.progkeys.data.changeFilter(intIndex, boolSelected);
	}
});
