/**
 * getProgKeysContent
 * Main widget of the progkeys webapplication. Content of the full application mode : getProgKeys
 *
 *   domProgKeysList	{DOMNode}: DomNode for progkeys list (ul)
 *   _lstKeysButtons	{List}	 : Progkeys list
 *   _hListUpdated		{Object} : Dojo connect for list update
 *   _lstButtons		{List}	 : AppBar buttons
 *   deleteModeEnabled	{Bool}	 : is delete mode enabled
 *   modifyModeEnabled	{Bool}	 : is modify mode enabled
 *   editModeEnabled	{Bool}	 : is edit mode enabled
 */
dojo.provide("webapp.progkeys.getProgKeysContentBase");
dojo.declare("webapp.progkeys.getProgKeysContentBase", [ICTouchAPI.webWidget,  dojox.dtl._Templated],
{
	domProgKeysList			: null,
	domLeftArrow			: null,
	domRightArrow			: null,
	domNavigationBar		: null,
	objNavigationBarUI		: null,
	_lstKeysButtons			: {},
	_listUpdatedHandler		: null,
	_lstButtons				: {},
	deleteModeEnabled		: false,
    modifyModeEnabled		: false,
    moveModeEnabled			: false,
	
	/* edit mode (Actually not used) */
	_moveableEvents			: null,
	_moveableElem			: null,
	_moveableDiv			: null,
	xPos					: null,
	yPos					: null,
	srcPos					: null,
	srcNode					: null,
	position				: null,
	domContainer			: null,
	dom						: null,
	marginXLeft				: null,
	marginXRight			: null,
	marginYUp				: null,
	marginYBottom			: null,
	currentPage				: 0,
	previousPage			: 0,
	_objSpinner				: null,
	_spinnerHandler			: null,
	_selectedProgKey		: null, // selected progKey for moving
	arrHandler				: [],

	/**
	 * Constructor
	 */
    constructor: function() {
		
    },
	
	postMixInProperties : function(){
		
	},
	
	/**
	 * Create application bar, get and active filter, set the vertical scroll
	 */
	postCreate: function() {
		var data = webapp.progkeys.data;
		this._lstButtons["MODIFY"]	= data._lstInstAppButtons[data.PROGKEY_FULL][data.MODIFY];
		this._lstButtons["DELETE"]	= data._lstInstAppButtons[data.PROGKEY_FULL][data.DELETE];
		this._lstButtons["MOVE"]	= data._lstInstAppButtons[data.PROGKEY_FULL][data.MOVE];
		webapp.progkeys.currentFullWidget = this;

		// Navigation bar
		var funcDisplayCallBack	= dojo.hitch(this,this.changePage);
		this.objNavigationBarUI = new UIElements.NavigationBar.NavigationBar ({domArrowLeft:this.domLeftArrow, domArrowRight:this.domRightArrow, displayCallBack:funcDisplayCallBack, intMaxPage:6}, this.domNavigationBar);

		this.fillProgKeysList();
		
		this._listUpdatedHandler = this.subscribe('programmablekeys/keysListUpdated', this.progKeysListUpdated);
	},

	/**
	 * Destroy
	 */
	destroy: function() {
		this.unsubscribe(this._listUpdatedHandler);
		this.removeProgKeysList();
		this.inherited(arguments);
	},
	
	/**
	 * Disable active modes
	 */
    disableActiveMode : function() {
		if(this.modifyModeEnabled===true){
			this.toggleModifyMode();
		}
		if(this.deleteModeEnabled===true){
			this.toggleDeleteMode();
		}
		if(this.moveModeEnabled===true){
			this.toggleMoveMode();
		}
    },

	toggle : function(strMode,boolActive){
	    var i;
		if(strMode=="modify"  ){
			if(boolActive){
				for(i=this.currentPage*12; i<(this.currentPage+1)*12;i++){
					if(this._lstKeysButtons[i] && this._lstKeysButtons[i].boolUpdate) {
						this._lstKeysButtons[i].button.setModeIcon("generic-"+strMode);
					}
				}
			}
			else{
				for(i=this.currentPage*12; i<(this.currentPage+1)*12;i++){
					if(this._lstKeysButtons[i] && this._lstKeysButtons[i].boolUpdate) {
						this._lstKeysButtons[i].button.removeModeIcon();
					 }
				}
			}
		}

		else if(strMode=="delete" ){
			if(boolActive){
				for(i=this.currentPage*12; i<(this.currentPage+1)*12;i++){
					if(this._lstKeysButtons[i] && this._lstKeysButtons[i].boolDelete) {
					   this._lstKeysButtons[i].button.setModeIcon("generic-delete");
					}
				}
			}
			else{
				for(i=this.currentPage*12; i<(this.currentPage+1)*12;i++){
					if(this._lstKeysButtons[i] && this._lstKeysButtons[i].boolDelete) {
					  this._lstKeysButtons[i].button.removeModeIcon();
					}
				}
			}

		}
		else if(strMode=="move" ){
			if(boolActive){
				for(i=this.currentPage*12; i<(this.currentPage+1)*12;i++){
					if(this._lstKeysButtons[i] && this._lstKeysButtons[i].boolMoveable){
						this._lstKeysButtons[i].button.setModeIcon("generic-mode-"+strMode);
					}
				}
			}
			else{
				for(i=this.currentPage*12; i<(this.currentPage+1)*12;i++){
				    if(this._lstKeysButtons[i] != null && this._lstKeysButtons[i] != undefined){
						if(this._lstKeysButtons[i] && this._lstKeysButtons[i].boolMoveable){
							this._lstKeysButtons[i].button.removeModeIcon();
						}
					}
				}
			}
		}
	},
	
	/**
	 * Activate/Deactivate modify mode
	 */
    toggleModifyMode : function() {
		if(this.modifyModeEnabled === false){
			//On activation, disable other modes
			this.disableActiveMode();
			this.modifyModeEnabled	= true;
			dojo.addClass(this.domProgKeysList,"modifyMode");
			this.toggle("modify",true);
			this._lstButtons["MODIFY"].setStatusIcon("notif-on");
		} else {
			this.modifyModeEnabled	= false;
			dojo.removeClass(this.domProgKeysList,"modifyMode");
			this.toggle("modify",false);
			this._lstButtons["MODIFY"].setStatusIcon("notif-off");
		}
    },
	
	/**
	 * Activate/Deactivate delete mode
	 */
    toggleDeleteMode : function() {
		if(this.deleteModeEnabled === false){
			//On activation, disable other modes
			this.disableActiveMode();
			this.deleteModeEnabled	= true;
			//Add a mask on progkeys (opacity)
			dojo.addClass(this.domProgKeysList,"deleteMode");
			this.toggle("delete",true);
			this._lstButtons["DELETE"].setStatusIcon("notif-on");
		} else {
			this.deleteModeEnabled	= false;
			if(this._itemDeleted === true){
				this._itemDeleted	= false;
			}
			
			//Remove mask on progkeys (opacity)
			dojo.removeClass(this.domProgKeysList,"deleteMode");
			this.toggle("delete",false);
			this._lstButtons["DELETE"].setStatusIcon("notif-off");
		}

    },
	
	/**
	 * Activate/Deactivate edition mode
	 */
    toggleMoveMode : function() {
		if(this.moveModeEnabled === false){
			//On activation, disable other modes
			this.disableActiveMode();
			this.moveModeEnabled	= true;
			dojo.addClass(this.domProgKeysList,"moveMode");
			this.toggle("move",true);
			this._lstButtons["MOVE"].setStatusIcon("notif-on");
		} else {
			this.moveModeEnabled	= false;
			dojo.removeClass(this.domProgKeysList,"moveMode");
			this.toggle("move",false);
			this._lstButtons["MOVE"].setStatusIcon("notif-off");
			this._selectedProgKey	= null;
		}
    },

	/**
	 * updates and fill the arrProgkeys array and lstProgKeys list
	 */
	fillProgKeysList : function() {
		var data			= webapp.progkeys.data;
		var arrProgKeys		= data.arrProgKeys["0"];

		if(this._i18nizedHandlers){
			ICTouchAPI.i18nServices.unsubscribeAllI18nHandlers(this);
		}
		this.removeProgKeysList();
		
		// Fill all pages
		var i	= 0;	// Line
		var j	= 0;	// Page
		var k	= 0;	// Position of button in a line
		var position	= 0	// Position of button
		if(arrProgKeys != undefined) {
			for(i=0; i < 2; i++) {			// 2 lines
				for(j=0; j < 6; j++) {		// 6 pages
					for(k=0; k < 6; k++) {	// 6 buttons per lines
						position = i*6 + j*12 + k;
						this.addProgKey(arrProgKeys[position], position, "create");
					}
				}
			}
		}
		//Show active progkeys only
		var currActiveTypes = data.lstActiveTypes;
		var dojoNodeProgKeyList = new dojo.NodeList(this.domProgKeysList);
		for(var activeType in currActiveTypes){
			dojo.forEach(dojoNodeProgKeyList.query("."+activeType), function(progKey){
				progKey.style.display="";
			});
		}
		if(this.moveModeEnabled){
		    this.toggle("move",true);
		}
		this.objNavigationBarUI.goToPage(this.objNavigationBarUI.intCurrentPage);
	},
	
	removeProgKeysList : function() {
		dojo.empty(this.domProgKeysList);
		for(var i in this._lstKeysButtons) {
			if(this._lstKeysButtons[i]) {
				this._lstKeysButtons[i].button.destroy();
				delete this._lstKeysButtons[i];
			}
		}
		if(this._i18nizedHandlers){
			ICTouchAPI.i18nServices.unsubscribeAllI18nHandlers(this);
		}
    },
	
	/**
	 * Callback for progkeysList update (On dojo event)
	 */
	progKeysListUpdated : function() {
		//this.removeProgKeysList();
		this.fillProgKeysList();
	},
	
	addProgKey : function(objCurrentKey, position, action) {
		var liNode	= null;
		var idx		= null;
		if(objCurrentKey && (!action || action != "create")) {
			idx		= this._searchIdxByPosition(objCurrentKey.position);
			liNode	= this.domProgKeysList.children[idx];
		}
		
		if(!liNode) {
			liNode = dojo.create("li", {}, this.domGetHomepage);
			dojo.attr(liNode, "position", position);
			dojo.addClass(liNode, "empty");
			
			var eventHandle				= dojo.connect(liNode, "onclick", this, this._emptySpaceClick);
			this.arrHandler[position]	= eventHandle;
			
			this.domProgKeysList.appendChild(liNode);
		}
		
		if (objCurrentKey) {
			dojo.removeClass(liNode, "empty");
			this._createProgKey(objCurrentKey, liNode);
		}
	},
	
	_createProgKey : function(objCurrentKey,liNode) {
		var data = webapp.progkeys.data;
		var objAction = data.getActionById(objCurrentKey.idAction);
		
		objAction.arguments = (typeof objAction.arguments == "string") ? dojo.fromJson(objAction.arguments) : objAction.arguments;
		
		//Execute action on display progkey
		if(objAction && webapp[objAction.webAppName] && webapp[objAction.webAppName].onProgKeyDisplay && objCurrentKey.isUserRemovable == 1){
			webapp[objAction.webAppName].onProgKeyDisplay(objAction, objCurrentKey);
		}
		objCurrentKey.className = ""+objAction.type;
		
		//Set LI class
		if(objAction.action == "webapp") {
			dojo.addClass(liNode , "webapp");
		} else {
			dojo.addClass(liNode , "progkey");
		}
		
		if (objCurrentKey.className) {
			dojo.addClass(liNode, objCurrentKey.className);
		}
		
		// Fill item template
		var newKey	= {};
		
		newKey	= {
			strButtonLabel	: "",
			strButtonName : objCurrentKey.idKey,
			callback : dojo.hitch(this, this.progKeyShortPress),
			callbackLong : dojo.hitch(this, this.progKeyLongPress)
		};
		
		if(objAction.action == "routing") {
			newKey.strStatusIcon = objAction.arguments.strNotifStatus;
		}
		
		if(!objCurrentKey.image){
			newKey.strButtonIcon = objCurrentKey.icon;
		}
		
		if (objAction.label) {
			newKey.strButtonLabel = objAction.label;
		}
		
		liNode.setAttribute("idKey", objCurrentKey.idKey);
		
		//Create buttonControls
		var button = new UIElements.AppButton.ButtonControl(newKey);
		
		//Set mode
		if(this.deleteModeEnabled && objAction.action != "webapp") {
			button.setModeIcon("generic-delete");
		}
		
		if(this.modifyModeEnabled && objAction.action != "webapp") {
			button.setModeIcon("generic-modify");
		}
		if(this.moveModeEnabled && objAction.isMoveable){
		    button.setModeIcon("generic-mode-move");
		}
		
		// Add button into node
		var boolDelete	= (objAction.action != "webapp");
		var boolUpdate	= (objAction.action != "webapp");
		
		var boolMoveable = objAction.isMoveable;
		
		this._lstKeysButtons[objCurrentKey.position] = {button:button,idKey:objCurrentKey.idKey,icon:objCurrentKey.icon,label:objAction.label, boolDelete : boolDelete, boolUpdate : boolUpdate,boolMoveable : boolMoveable};
		button.placeAt(liNode, "first");
		if(objCurrentKey.image){
			var image = dojo.query("span", liNode)[0];
			dojo.style(image,"backgroundImage", "url('"+objCurrentKey.image+"')");
			dojo.addClass(image, "specificIcon");
		}
		
		//Add target webapp skin
		if(!data._loadedSkin["webapp."+objAction.webAppName]) {
			//ICTouchAPI.skinServices.linkWebappsStyles("webapp.progkeys","webapp."+objAction.webAppName,true,false,true,false);
			data._loadedSkin["webapp."+objAction.webAppName] = true;
		}
		
		//Add internationalization
		if(objAction.label && webapp[objAction.webAppName]) {
			objCurrentKey.i18nlabel = _(objAction.label, "webapp."+objAction.webAppName);
			var handler = ICTouchAPI.i18nServices.i18nList(objCurrentKey, function (name, value) {
				return true;
			});
			ICTouchAPI.i18nServices.addI18nHandlers(this, handler);
		} else {
			objCurrentKey.i18nlabel = "";
		}

	},
	
	/**
	 * Delete progkey based on id
	 */
	deleteProgKey : function(idKey) {
		var position	= null;
		
		for(var i in this._lstKeysButtons) {
			if(this._lstKeysButtons[i].idKey === idKey) {
				position = i;
				break;
			}
		}
		
		if (position!=null) {
			var liNode = this._lstKeysButtons[position].button.domNode.parentNode;
			this._lstKeysButtons[position].button.destroy();
			dojo.removeAttr(liNode, "class");
			dojo.addClass(liNode, "empty");
			dojo.removeAttr(liNode, "idKey");
			delete this._lstKeysButtons[position];
		}
	},
	
	/**
	 * Short press on progkey or emppty space
	 */
	progKeyShortPress : function(idKey) {
		var data = webapp.progkeys.data;
		if(!data._lockProgkeysCallback) {
			//Get the selected key
			var currentProgKey = data.lstProgKeys["0"][idKey];
			var currentAction = data.getActionById(currentProgKey.idAction);
			
			if(this.deleteModeEnabled === true && currentAction.action != "webapp") { //If a key is selected during delete mode
				this._funcDeleteProgKey(currentProgKey);
			} else if(this.moveModeEnabled===true && currentAction.isMoveable) { //Move mode is currently not used
				if (this._selectedProgKey !== null) {
					if(currentProgKey!=this._selectedProgKey) {
							this._funcMoveToProgKey(currentProgKey);
					}
					else {
						this._funcUnselectProgKey(currentProgKey);
					}
				} else {
					this._funcSelectProgKey(currentProgKey);
				}
			} else if(this.modifyModeEnabled===true && currentAction.action != "webapp") { //If modify mode enabled, get the Add/Edit view with selected progkey as parameter
				this._funcModifyProgKey(currentProgKey, currentAction);
			}
		}
	},
	
	/**
	 * Long press on progkey or emppty space
	 */
	progKeyLongPress : function(idKey) {
		this.progKeyShortPress(idKey);
	},
	
	/**
	 * Modify a progkey
	 */
	_funcModifyProgKey : function(currentProgKey, currentAction) {
		webapp.progkeys.setEditingProgKey(true);
		var backAddCallback = function() {webapp.progkeys.backAddCallback()};
		var endAddCallback = function(editedProgKey,editedAction) {webapp.progkeys.endAddCallback(editedProgKey,editedAction)};
		webapp.progkeys.addProgkey({backAddCallback:backAddCallback, endAddCallback:endAddCallback, progkeysWebapp:true, editedProgKey:currentProgKey, editedAction:currentAction});
	},
	
	/**
	 * Delete a progkey
	 */
	_funcDeleteProgKey : function(currentProgKey) {
		//var currentDomProgKey = e.currentTarget;
		var createdPopup = {};
		webapp.progkeys.data.currentProgKey	= currentProgKey;

		//If a progkey has to be deleted, show a popup
		var popupData = {
			strTitle: _("Delete programmable key?","webapp.progkeys"),
			strContent: _("Do you really want to delete this programmable key?","webapp.progkeys"),
			arrPopupButtons: [
				{
					strButtonLabel: _('Ok',"webapp.progkeys"),
					callback : function(){
						webapp.progkeys.data.deleteProgKey(webapp.progkeys.data.currentProgKey);
						ICTouchAPI.popupServices.removePopup(createdPopup);
					},
					strButtonIcon : 'generic-ok'
				},
				{
					strButtonLabel: _('Cancel',"webapp.progkeys"),
					callback : function(){ICTouchAPI.popupServices.removePopup(createdPopup)},
					strButtonIcon : 'generic-cancel'
				}
			]
		};
		createdPopup = ICTouchAPI.popupServices.addNewPopup(popupData);
	},

	/**
	 * Verify if we are clicking on empty space or not
	 */
	_emptySpaceClick : function(event) {
		if(this.moveModeEnabled===true) {
			if (this._selectedProgKey !== null) {
				var data    = webapp.progkeys.data;
				var position	= event.currentTarget.getAttribute("position");
				if(data.arrProgKeys[0][position] == null && this._selectedProgKey.position != position) {
					var objAction = data.getActionById(this._selectedProgKey.idAction);
					if(objAction.isMoveable) {
						this._funcMoveToEmptySpace(position);
					}
				}
			}
		}
	},
	
	createMoveSpinner : function() {
		this.destroyMoveSpinner();
		this._objSpinner = new UIElements.Spinner.SpinnerControl({strMessage : _('Move in progress...', "webapp.progkeys"), boolForeground:true}, document.body);
		this._spinnerHandler = setTimeout(dojo.hitch(this, this.destroyMoveSpinner), 1500);
	},
    
	destroyMoveSpinner : function() {
		if(this._objSpinner){
			this._objSpinner.destroy();
			this._objSpinner = null;
		}
		if(this._spinnerHandler){
			clearTimeout(this._spinnerHandler);
			this._spinnerHandler = null;
		}
	},

	/**
	 * Select the progkey "currentProgKey" before moving it and store it in "_selectedProgKey"
	 */
	_funcSelectProgKey : function(currentProgKey) {
		this._lstKeysButtons[currentProgKey.position].button.setModeIcon("generic-ok");
		this._selectedProgKey = currentProgKey;
	},

	/**
	 * Unselect the progkey "currentProgKey"
	 */
	_funcUnselectProgKey : function(currentProgKey) {
		this._lstKeysButtons[currentProgKey.position].button.setModeIcon("generic-mode-move");
		this._selectedProgKey = null;
	},

	/**
	 * Move selected progkey/webapp from the previous position defined by "_selectedProgKey.position" to specific position without progkey (empty space) defined by "position"
	 */
	_funcMoveToEmptySpace : function(position) {
		this.createMoveSpinner();
		var oldposition = this._selectedProgKey.position;
		this._selectedProgKey.position = position;
		this._selectedProgKey.oldPosition = oldposition;
		webapp.progkeys.data.arrProgKeys["0"][oldposition]=null;
		webapp.progkeys.data.arrProgKeys["0"][position]=this._selectedProgKey;
		this.updateSettingHomepageKeys(oldposition, position);
		this._lstKeysButtons[oldposition].button.destroy();
		delete this._lstKeysButtons[oldposition];
		
		// Add empty on the former place
		var idx = this._searchIdxByPosition(oldposition);
		var oldLiNode	= this.domProgKeysList.children[idx];
		dojo.removeClass(oldLiNode);
		dojo.addClass(oldLiNode, "empty");

		// Remove empty on the new place
		idx = this._searchIdxByPosition(this._selectedProgKey.position);
		var liNode	= this.domProgKeysList.children[idx];
		dojo.removeClass(liNode, "empty");

		this._createProgKey(this._selectedProgKey, liNode);
		ICTouchAPI.APIServices.ProgrammableKeys.modifyProgrammableKey({params:[this._selectedProgKey], context:webapp.progkeys, callback:webapp.progkeys.errorManager, callbackParams:null});
		this._selectedProgKey = null;
	},

	/**
	 * Move selected progkey/webapp from the previous position defined by "_selectedProgKey.position" to the new position defined by "currentProgKey.position"
	 */
	_funcMoveToProgKey : function(currentProgKey) {
	    if(currentProgKey!=this._selectedProgKey){
			this.createMoveSpinner();
			// Update positions in setting "HomepageKeys"
			this.updateSettingHomepageKeys(this._selectedProgKey.position, currentProgKey.position);

			// Delete graphically keys on their old positions
			this.deleteProgKey(currentProgKey.idKey);
			this.deleteProgKey(this._selectedProgKey.idKey);

			// Save progkeys on their new positions
			// Firstly swap positions on object
			var objSelectedProgKey = this._selectedProgKey;
			var oldPosition = objSelectedProgKey.position;
			var objCurrentProgKey = currentProgKey;
			var currentPosition = objCurrentProgKey.position;
			objCurrentProgKey.position = oldPosition;
			objCurrentProgKey.oldPosition = currentPosition;
			objSelectedProgKey.position = currentPosition;
			objSelectedProgKey.oldPosition = oldPosition;

			// Then, save it on the right place
			webapp.progkeys.data.arrProgKeys["0"][objCurrentProgKey.position] = objCurrentProgKey;
			webapp.progkeys.data.arrProgKeys["0"][objSelectedProgKey.position] = objSelectedProgKey;

			// Create graphically keys on their new positions
			var idx = this._searchIdxByPosition(objCurrentProgKey.position);
			var liNode	= this.domProgKeysList.children[idx];
			dojo.removeClass(liNode, "empty");
			this._createProgKey(objCurrentProgKey, liNode);

			idx = this._searchIdxByPosition(objSelectedProgKey.position);
			liNode	= this.domProgKeysList.children[idx];
			dojo.removeClass(liNode, "empty");
			this._createProgKey(objSelectedProgKey, liNode);

			if (webapp.progkeys.data.getActionById(objCurrentProgKey.idAction).action != "webapp") {
				// we are moving a progkey
				ICTouchAPI.APIServices.ProgrammableKeys.modifyProgrammableKey({params:[objCurrentProgKey], context:webapp.progkeys, callback:webapp.progkeys.errorManager, callbackParams:null});
			}
		
		    if (webapp.progkeys.data.getActionById(objSelectedProgKey.idAction).action != "webapp") {
				// we are moving to a progkey position
			    ICTouchAPI.APIServices.ProgrammableKeys.modifyProgrammableKey({params:[objSelectedProgKey], context:webapp.progkeys, callback:webapp.progkeys.errorManager, callbackParams:null});
			}
		}
	    this._selectedProgKey = null;
		currentProgKey = null;
	},
		
	updateSettingHomepageKeys : function(originePosition,destinationPosition){
		ICTouchAPI.settingServices.getSettingValue("HomepageKeys", this, function(setting) {
			if (setting !== null){
				if(setting.length < 72) {
					for(var i=setting.length;i<72;i++) {
						setting[i] = "";
					}
				}

				// we switch
				var aux = setting[originePosition];
				setting[originePosition] = setting[destinationPosition];
				setting[destinationPosition] = aux;
				ICTouchAPI.settingServices.setSettingValue ("HomepageKeys", setting, this, null);
			}
		});
	},

	/**
	 * Modify a progkey display
	 */
	modifyProgKey : function(objCurrentKey) {
		var pos = objCurrentKey.position;
		if(objCurrentKey.idKey === this._lstKeysButtons[pos].idKey) {
			var objAction = webapp.progkeys.data.getActionById(objCurrentKey.idAction);
			if(objCurrentKey.icon!==this._lstKeysButtons[pos].icon || objAction.label!==this._lstKeysButtons[pos].label) {
				//Destroy old button
				this._lstKeysButtons[pos].button.destroy();
				//remove background image
				var liNode = dojo.query("li[idKey="+objCurrentKey.idKey+"]", this.domProgKeysList)[0];
				dojo.removeClass(liNode)
				//recreate button
				this._createProgKey(objCurrentKey, liNode);
			}
		}
		objCurrentKey	= null;
	},

	handleChangingPagePrevious : function(){
		if(this.deleteModeEnabled){
			this.toggle("delete", false);
		}
		else if(this.modifyModeEnabled){
			this.toggle("modify",false);
		}
		else if(this.moveModeEnabled){
			this.toggle("move",false);
		}
	},
	
	handleChangingPageNext : function(){
		if(this.deleteModeEnabled){
			this.toggle("delete", true);
		}
		else if(this.modifyModeEnabled){
			this.toggle("modify",true);
		}
		else if(this.moveModeEnabled){
			this.toggle("move",true);
		}
	},

	/**
	 * Go to previous page
	 */
	previousPage : function() {
		this.handleChangingPagePrevious();
		this.objNavigationBarUI.previous();
	},
	
	/**
	 * Go to next page
	 */
	nextPage : function() {
		this.handleChangingPagePrevious();
		this.objNavigationBarUI.next();
	},
	
	changePage : function() {
		this.currentPage = this.objNavigationBarUI.intCurrentPage-1;
		this.handleChangingPageNext();
		dojo.style(this.domProgKeysList, "left", (-738*this.currentPage)+"px");
	},
	
	/**
	 * Research the index of a button according to its position
	 */
	_searchIdxByPosition : function(position) {
		var idx			= 0;
		var indice		= 0;
		var boolFound	= false;
		for(var i = 0; i < 2 && !boolFound; i++) {
			for(var j = 0; j < 6 && !boolFound; j++) {
				for(var k = 0; k < 6 && !boolFound; k++) {
					indice = i*6 + j*12 + k;
					if(position == indice) {
						boolFound = true;
					} else {
						idx++;
					}
				}
			}
		}

		position = null;
		return idx;
	},

	destroy : function(){
		if(this.domProgKeysList){
			dojo.destroy(this.domProgKeysList);
			this.domProgKeysList	= null;
		}
		if(this.domLeftArrow){
			dojo.destroy(this.domLeftArrow);
			this.domLeftArrow	= null;
		}
		if(this.domRightArrow){
			dojo.destroy(this.domRightArrow);
			this.domRightArrow	= null;
		}
		if(this._lstKeysButtons){
			dojo.destroy(this._lstKeysButtons);
			this._lstKeysButtons	= null;
		}
		if(this._listUpdatedHandler){
			dojo.destroy(this._listUpdatedHandler);
			this._listUpdatedHandler	= null;
		}
		if(this._lstButtons){
			dojo.destroy(this._lstButtons);
			this._lstButtons	= null;
		}
		if(this.deleteModeEnabled){
			dojo.destroy(this.deleteModeEnabled);
			this.deleteModeEnabled	= null;
		}
		if(this.modifyModeEnabled){
			dojo.destroy(this.modifyModeEnabled);
			this.modifyModeEnabled	= null;
		}
		if(this._moveableEvents){
			dojo.destroy(this._moveableEvents);
			this._moveableEvents	= null;
		}
		if(this._moveableElem){
			dojo.destroy(this._moveableElem);
			this._moveableElem	= null;
		}
		if(this.moveModeEnabled){
			dojo.destroy(this.moveModeEnabled);
			this.moveModeEnabled	= null;
		}
		if(this._moveableDiv){
			dojo.destroy(this._moveableDiv);
			this._moveableDiv	= null;
		}
		if(this.moveModeEnabled){
			dojo.destroy(this.moveModeEnabled);
			this.moveModeEnabled	= null;
		}
		if(this.xPos){
			dojo.destroy(this.xPos);
			this.xPos	= null;
		}
		if(this.yPos){
			dojo.destroy(this.yPos);
			this.yPos	= null;
		}
		if(this.srcPos){
			dojo.destroy(this.srcPos);
			this.srcPos	= null;
		}
		if(this.srcNode){
			dojo.destroy(this.srcNode);
			this.srcNode	= null;
		}
		if(this.position){
			dojo.destroy(this.position);
			this.position	= null;
		}
		if(this.domContainer){
			dojo.destroy(this.domContainer);
			this.domContainer	= null;
		}
		if(this.dom){
			dojo.destroy(this.dom);
			this.dom	= null;
		}
		if(this.marginXLeft){
			dojo.destroy(this.marginXLeft);
			this.marginXLeft	= null;
		}
		if(this.marginXRight){
			dojo.destroy(this.marginXRight);
			this.marginXRight	= null;
		}
		if(this.marginYUp){
			dojo.destroy(this.marginYUp);
			this.marginYUp	= null;
		}
		if(this.marginYBottom){
			dojo.destroy(this.marginYBottom);
			this.marginYBottom	= null;
		}
		if(this.currentPage){
			dojo.destroy(this.currentPage);
			this.currentPage	= null;
		}
		
		if(this.arrHandler.length > 0) {
			for(var i in this.arrHandler) {
				dojo.disconnect(this.arrHandler[i]);
			}
		}
	}
});