/**
 * getProgKeys
 * Widget(view) container for getProgKeysContent.
 *
 * fullControl {Object} : UIElement Application Mode Full
 * domProgKeys {DOMNode}: attach point for progkeysContent
 */

dojo.provide("webapp.progkeys.getProgKeysBase");
dojo.declare("webapp.progkeys.getProgKeysBase", [ICTouchAPI.webWidget,  dojox.dtl._Templated],
{
	fullControl : {},
	domProgKeys	: null,
	
    constructor : function(){
		
    },
	
	postMixInProperties : function(){
		var appBar	= ICTouchAPI.AppBarServices.getAppBar("progkeys", "getProgKeys");
		var data	= webapp.progkeys.data;
		data._lstInstAppButtons={};
		data._lstInstAppButtons[data.PROGKEY_FULL]={};
		dojo.forEach(data.getAppBarAppButtons(data.PROGKEY_FULL), function(button) {
			var objButton = new UIElements.AppButton.AppButtonControl(button);
			appBar.addActionButton(objButton);
			data._lstInstAppButtons[data.PROGKEY_FULL][objButton.strButtonName]=objButton;
		}, this);
		//Add exit button
		var backfunc = function(){
			//Disabled Active Mode when leaving progkeys webapp
			webapp.progkeys.currentFullWidget.disableActiveMode();
			ICTouchAPI.transitionServices.back();
			webapp.progkeys.reloadContext();
			//ICTouchAPI.transitionServices.getScreen({name : "webapp.settings.getSettings", params : {}});
			//dojo.publish("OpenHomepage");
		}
		
		ICTouchAPI.AppBarServices.addExitButton("progkeys", "getProgKeys",false, backfunc);
	},

	postCreate: function(){
		this.fullControl = new UIElements.ApplicationMode.FullControl({
			content : {
				name    : "webapp.progkeys.getProgKeysContent",
				params  : {}
			},
			objTitle : {
				strLabel    : _("Progkeys","webapp.progkeys")
			}
		},this.domProgKeys);
		
		ICTouchAPI.AppBarServices.setAppBar("progkeys", "getProgKeys", "getProgKeys");
		webapp.progkeys.updateAppBar();
	},

	destroy : function(){
		if(this.fullControl){
			dojo.destroy(this.fullControl);
			this.fullControl	= null;
		}
		
		if(this.domProgKeys){
			dojo.destroy(this.domProgKeys);
			this.domProgKeys	= null;
		}
	}
});