/**
 * getProgKeyEditLocation
 * Widget(view) used for progkey Location selection
 *
 * _arrLocationsList	{Array} : List of available locations
 * _arrItemList			{Array}	: Items for the select list
 * _lstItemList			{List}	: Items for the select list indexed by Id
 * _objSelectList		{Object}: SelectList widget
 * domSelectList		{DOMNode}: Attachpoint for the location list UI
 */
dojo.provide("webapp.progkeys.getProgKeyEditLocationBase");
dojo.declare("webapp.progkeys.getProgKeyEditLocationBase", [ICTouchAPI.webWidget,  dojox.dtl._Templated],
{
    _arrLocationsList	: [],
	_arrItemList		: [],
	_objSelectList		: {},
	_lstItemList		: {},
	domSelectList		: null,
	
	constructor		: function(){
		this._arrLocationsList = [];
		this._arrItemList	= [];
		this._objSelectList	= {};
		this._lstItemList	= {};
	},
	
	postMixInProperties : function(){
	},
	
	postCreate : function(){
		//Get the locationList and transform it to a SelectList argument Array
		this._arrLocationsList = webapp.progkeys.data.getLocationsList();
		for(var i=0; i < this._arrLocationsList.length; i++){
			var currLocation = this._arrLocationsList[i];
			var listItem = {};
			listItem.strLabel=_(currLocation.label, "webapp.progkeys");
			listItem.intIndex=currLocation.index;
			var editedProgKey = webapp.progkeys.editedPKKey;
			if(editedProgKey && currLocation.index === editedProgKey.type){
				listItem.boolSelected= true;
			}
			this._arrItemList.push(listItem);
			this._lstItemList[currLocation.index]= currLocation;
		}
		
		//Create the selectList
		this._objSelectList = new UIElements.SelectList.SelectListControl({
			arrItems: this._arrItemList,
			//strCheckedIcon : "Default",
			intContainerSize: 7,
			boolMultiselect: false
		}, this.domSelectList);
	},

	getList : function(){
		return this._objSelectList;
	},
	
	/**
	 * On user selection, select the Location
	 */
	getAction : function(){
		return this._arrItemList[this._objSelectList.getSelected()[0]].intIndex;
	}
});