/**
 * getProgKeyEditActionBase
 * Widget(view) used for progkey Action selection
 *
 * _arrActionsList		{Array} : List of available actions
 * _arrItemList			{Array}	: Items for the select list
 * _lstItemList			{List}	: Items for the select list indexed by Id
 * _objSelectList		{Object}: SelectList widget
 * domSelectList		{DOMNode}: Attach point for Action select list ui
 */

dojo.provide("webapp.progkeys.getProgKeyEditActionBase");
dojo.declare("webapp.progkeys.getProgKeyEditActionBase", [ICTouchAPI.webWidget,  dojox.dtl._Templated],
{
	_arrActionsList : [],
	_arrItemList	: [],
	_objSelectList	: [],
	_lstItemList	: {},
	domSelectList	: null,
	
    /**
	 * Constructor
	 */
	constructor: function() {
		this._arrActionsList = [];
		this._arrItemList	= [];
		this._objSelectList	= [];
		this._lstItemList	= {};
	},
	
	postMixInProperties : function() {
		
	},
	
	postCreate : function() {
		var j					= 0;
		var selectedIndex		= null;
		var data				= webapp.progkeys.data;
		this._arrActionsList	= data.getTemplateActionList();
		var editedAction		= data.editedPKAction;

		for(var i in this._arrActionsList) {
			var listItem		= {};
			listItem.strLabel	= _(this._arrActionsList[i].label, "webapp."+this._arrActionsList[i].webAppName);
			listItem.intIndex	= j;
			this._arrItemList.push(listItem);
			this._lstItemList[j]	=	this._arrActionsList[i];
			if(editedAction && editedAction.webappName == this._arrActionsList[i].webAppName && editedAction.action == this._arrActionsList[i].action) {
				selectedIndex = j;
			}
			j++;
			//Save action's screens
			data.objProgkeysScreen = {};
			for(var screensInd=0; screensInd<this._arrActionsList[i].screens.length; screensInd++) {
				var screenName = this._arrActionsList[i].screens[screensInd];
				data.objProgkeysScreen[screenName] = true;
			}
		}

		this._objSelectList = new UIElements.SelectList.SelectListControl({
			arrItems : this._arrItemList,
			intContainerSize : 7,
			boolMultipleSelect : false,
			boolScroll : false,
			itemCallback : dojo.hitch(this, function() {
				webapp.progkeys.currentAddWidget.nextStep();
			})
		}, this.domSelectList);
		if(selectedIndex!=null){
			this._objSelectList.selectAtIndex(selectedIndex);
		}
		ICTouchAPI.transitionServices.unstealth("webapp.progkeys.getProgKeyAdd");
	},
	
	getList : function() {
		return this._objSelectList;
	},
	
	/**
	 * On user selection, select the Action
	 */
	getAction : function() {
		return this._lstItemList[this._objSelectList.getSelected()[0]];
	},
	
	reloadInit : function() {
		var data = webapp.progkeys.data;
		if(this._arrActionsList && this._objSelectList){
			var editedAction = data.editedPKAction;
			var selectedIndex = null;
			var j = 0;
			for(var i in this._arrActionsList){
				if(editedAction.webAppName == this._arrActionsList[i].webAppName && editedAction.action == this._arrActionsList[i].action){
					selectedIndex = j;
				}
				j++;
			}
			if(selectedIndex!=null){
				this._objSelectList.selectAtIndex(selectedIndex);
			}
			ICTouchAPI.transitionServices.unstealth("webapp.progkeys.getProgKeyAdd");
		}
	},
	
	destroy : function(){
		if(this._arrActionsList){
			dojo.destroy(this._arrActionsList);
			this._arrActionsList	= null;
		}
		if(this._arrItemList){
			dojo.destroy(this._arrItemList);
			this._arrItemList	= null;
		}
		if(this._objSelectList){
			dojo.destroy(this._objSelectList);
			this._objSelectList	= null;
		}
		if(this._lstItemList){
			dojo.destroy(this._lstItemList);
			this._lstItemList	= null;
		}
		if(this.domSelectList){
			dojo.destroy(this.domSelectList);
			this.domSelectList	= null;
		}
	}
});