dojo.provide("webapp.progkeys.getProgKeyAddBase");
dojo.declare("webapp.progkeys.getProgKeyAddBase", [ICTouchAPI.webWidget,  dojox.dtl._Templated],
{
	domEditAction		: null,
	domEditArguments	: null,
	domEditLocation		: null,
	wdgSelectArguments	: null,
	wdgSelectAction		: null,
	wdgSelectLabel		: null,
	progkeysWebapp		: false,
	_currentStep		: 0,
	editedProgKey		: {},
	editedAction		: {},
	backAddCallback		: null,
	endAddCallback		: null,
	
	// list of widgets
	ACTION				: 0,
	ARGUMENTS			: 1,
	LOCATION			: 2,
	LABEL				: 3,
	
    /**
	 * Constructor
	 */
	constructor			: function() {
		//ICTouchAPI.transitionServices.stealth("webapp.progkeys.getProgKeyAdd");
	},
	
	postMixInProperties : function() {
		webapp.progkeys.currentAddWidget = this;
		var data = webapp.progkeys.data;
		
		var backFunc = dojo.hitch(this, this.back);
		var appBar = ICTouchAPI.AppBarServices.getAppBar("progkeys", "getProgKeyAdd");

		data._lstInstAppButtons={};
		data._lstInstAppButtons[data.PROGKEY_ADD]={};

		dojo.forEach(data.getAppBarAppButtons(data.PROGKEY_ADD), function(button) {
			var objButton = new UIElements.AppButton.AppButtonControl(button);
			appBar.addActionButton(objButton);
			data._lstInstAppButtons[data.PROGKEY_ADD][objButton.strButtonName]=objButton;
		}, this);
		
		ICTouchAPI.AppBarServices.addExitButton("progkeys", "getProgKeyAdd", false, backFunc);
	},
	
	postCreate : function() {
		//At widget initialization, current step is 0 : Select Action
		this.wdgSelectAction = new UIElements.ApplicationMode.FullControl({
			content : {
				name    : "webapp.progkeys.getProgKeyEditAction",
				params  : {}
			},
			objTitle : {
				strLabel    : _("Shortcut", "webapp.progkeys")
			}
		},this.domEditAction);
		ICTouchAPI.AppBarServices.updateAppBar("progkeys","getProgKeyAdd");
	},
	
	back : function() {
		switch(this._currentStep) {
			 case 0 : //If first step, return to the progkeys main screen
				ICTouchAPI.transitionServices.stealth("webapp.progkeys.getProgKeyAdd");
				if(webapp.communication) {
				webapp.communication.resetStatus();
					webapp.communication.data.setNotifyCallByPopup(false);
					webapp.progkeys.unsubscribeEvents();
				}
                this.webapp.setEditingProgKey(false);
				this.backAddCallback();
				this.reloadInit();
				break;
			case 1: //If 2nd step, return to the step
				var appBar = ICTouchAPI.AppBarServices.getAppBar("progkeys", "getProgKeyAdd");
				/*var nextPKButton = appBar.getButton("NEXT_BTN");
				nextPKButton.hide();*/
				this.initWidget(this.ARGUMENTS);
				this._currentStep--;
				this.wdgSelectAction.domNode.style.display="block";
				break;
			case 2 : //If 3rd step, return to step 2
				this.initWidget(this.LABEL);
				this._currentStep--;
				this.getArgumentsWidget();
				break;
		}
	},
	
	/**
	 * reloadInit
	 * @description : Re-Initialize widget/dom/edited progkeys. Clean the add/edit widget
	 */
	reloadInit : function() {
		webapp.progkeys.data.bAllowOtherScreen = false;
		this.initWidget(this.ACTION);
		this.initWidget(this.ARGUMENTS);
		this.initWidget(this.LABEL);
		if(this.wdgSelectAction){
			this.wdgSelectAction.domNode.style.display="block";
		}
		if(this.wdgSelectArguments){
			this.wdgSelectArguments.domNode.style.display="none";
		}
		this._currentStep = 0;

		if(this.wdgSelectAction) {
			this.wdgSelectAction.getContent().getContent().getList().unselectAll();
		}
		this.backAddCallback = null;
		this.endAddCallback = null;
		
		webapp.progkeys.reloadContext();
		
	},
	
	/**
	 * Generic function to destroy an 'add key' widget
	 */
	initWidget : function(idWidget) {
		switch(idWidget) {
			case this.ACTION :
				var appBar = ICTouchAPI.AppBarServices.getAppBar("progkeys", "getProgKeyAdd");
				/*var nextPKButton = appBar.getButton("NEXT_BTN");
				nextPKButton.hide();*/
				var backPKButton = appBar.getButton("BACK_BTN");
				backPKButton.show();
				break;
			case this.ARGUMENTS :
				if(this.domEditArguments){
					dojo.destroy(this.domEditArguments);
					this.domEditArguments	= null;
				}
				this.domEditArguments =  this._newContentDiv();
				if(this.wdgSelectArguments != null){
					this.wdgSelectArguments.destroy();
					this.wdgSelectArguments	= null;
				}
				break;
			case this.LABEL :
				if(this.wdgSelectLabel != null){
					this.wdgSelectLabel.domNode.style.display="none";
				}
				break;
			default :
				break;
		}
		
		idWidget = null;
	},
	
	/**
	 * Subfunction to load Arguments Widget
	 */
	getArgumentsWidget : function() {
		var data = webapp.progkeys.data;
		data.bAllowOtherScreen = true;
		if(data.editedPKAction.webAppName != ""){
			var appBar = ICTouchAPI.AppBarServices.getAppBar("progkeys", "getProgKeyAdd");
			/*var nextPKButton = appBar.getButton("NEXT_BTN");
			nextPKButton.hide();*/
			var backPKButton = appBar.getButton("BACK_BTN");
			backPKButton.show();
			//Hide the selectAction Widget
			this.wdgSelectAction.domNode.style.display="none";
			this._currentStep=1;
			//If webapp has a onProgKeyConfig action, call the method
			if(webapp[data.editedPKAction.webAppName] && webapp[data.editedPKAction.webAppName].onProgKeyConfig){
				if(this.wdgSelectArguments == null){
					this.wdgSelectArguments = webapp[data.editedPKAction.webAppName].onProgKeyConfig(data.editedPKAction, this.domEditArguments, this);
				}
			} else { //If selectArguments does not exists, go to the next step
				this.nextStep();
			}
		}
	},
	
	/**
	 * _newContentDiv
	 * @description : Create a new div in widget
	 */
	_newContentDiv : function(){
		var div = document.createElement("div");
		this.domNode.appendChild(div);
		return div;
	},
	
	/**
	 * Next button pressed
	 */
	nextStep : function() {
		var data = webapp.progkeys.data;
		switch(this._currentStep) {
			case 0 :	//If the current step is 0 : Select Action, Go to the step 1 : Select Arguments
				var selectedAction = this.wdgSelectAction.getContent().getContent().getAction();
				this.selectAction(selectedAction);
				this.initWidget(this.ACTION);
				this.getArgumentsWidget();
				break;
			case 1 :	//If the current step is 1 : Select Arguments, go to the step 2 : Select Location
				if(this.wdgSelectArguments) {
					this.wdgSelectArguments.domNode.style.display="none";
					var selectArgsResult = this.wdgSelectArguments.validate();
				}
				//If the validation does not return false, or if there is no widget for argument selection
				if(selectArgsResult != false || this.wdgSelectArguments === null ) {
					if(selectArgsResult) {
						data.editedPKAction.arguments = selectArgsResult;
					}
					this._currentStep++;
					this.initWidget(this.ARGUMENTS);
					this.getLabelWidget();
					data.editedPKKey.type = data.VIRTUAL;
				}
				break;
			case 2 :	//If current step is 3 : Select Label. End of creation process
				if(data.editedPKKey.type !== "") {
					if(data.editedPKKey.position == -1) {
						data.editedPKKey.position = data.searchPositionVirtualKey();
					}
					this.endAddCallback(data.editedPKKey, data.editedPKAction);
					this._currentStep=0;
					if(this.progkeysWebapp == false) {
						this.reloadInit();
					}
					this.progkeysWebapp = false;
				}
				break;
		}
	},
	
	/**
	 * selectAction : Select action for the current edited progkey
	 */
	selectAction : function(action){
		var data = webapp.progkeys.data;
		data.editedPKAction.webAppName	= action.webAppName;
		data.editedPKAction.action		= action.action;
		data.editedPKAction.type		= action.type;
		data.editedPKKey.icon			= action.icon;

		action = null;
	},
	
	getLabelWidget : function() {
		webapp.progkeys.data.bAllowOtherScreen = false;
		var appBar = ICTouchAPI.AppBarServices.getAppBar("progkeys", "getProgKeyAdd");
		/*var nextPKButton = appBar.getButton("NEXT_BTN");
		nextPKButton.hide();*/
		var backPKButton = appBar.getButton("BACK_BTN");
		backPKButton.greyTint();
		if(this.wdgSelectLabel) {
			this.wdgSelectLabel.domNode.style.display	= "";
		} else {
			this.wdgSelectLabel = new UIElements.ApplicationMode.FullControl({
				content : {
					name		: "webapp.progkeys.getProgKeyEditLabel",
					params		: {}
				},
				objTitle : {
					strLabel    : _("Shortcut - Select a Label", "webapp.progkeys")
				}
			},this.domEditLabel);
		}
		
		this.wdgSelectLabel.getContent().getContent().openKeyboard();
	},

	destroy : function(){
		if(this.domEditAction){
			dojo.destroy(this.domEditAction);
			this.domEditAction	= null;
		}
		if(this.domEditArguments){
			dojo.destroy(this.domEditArguments);
			this.domEditArguments	= null;
		}
		if(this.wdgSelectArguments){
			dojo.destroy(this.wdgSelectArguments);
			this.wdgSelectArguments	= null;
		}
		if(this.wdgSelectAction){
			dojo.destroy(this.wdgSelectAction);
			this.wdgSelectAction	= null;
		}
		if(this.wdgSelectLabel){
			dojo.destroy(this.wdgSelectLabel);
			this.wdgSelectLabel	= null;
		}
		this.inherited(arguments);
	}
});
