/*
 * Progkeys webapplication data.
 * arrProgKeys				{Array}	: Progkeys ordered by type then by visual place
 * lstProgKeys				{List}	: Progkeys ordered by type then list by id
 * lstAction				{List}	: Action list by id
 * lstActionTypes			{List}	: Action types listed by name
 * lstActiveTypes			{List}	: Activated action types
 * arrPhysicalKeys			{Array}	: Physical keys array
 * _lstAppButtons			{List}	: Action buttons listed in Array by screen name
 * _lstInstAppButtons		{List}	: Action buttons instances
 * _arrProgKeysLocations	{Array}	: Array with progkeys available locations (for key add)
 * _currEditedProgKeys		{Object}: Progkeys in edition storage (For edition / add mode)
 * PROGKEY_FULL				{int}	: Constant definition for progkey full mode
 * PROGKEY_ADD				{int}	: Constant definition for prokey add mode
 */

dojo.provide("webapp.progkeys.dataBase");
dojo.declare("webapp.progkeys.dataBase",null,{
	arrProgKeys				: [],
	lstActionTypes			: {},
	lstProgKeys				: {},
	lstActions				: {},
	lstActiveTypes			: {},
	arrPhysicalKeys			: [],
	currentProgKey			: null,
	_lstAppButtons			: {},
	_lstInstAppButtons		: {},
	_arrProgKeysLocations	: [],
	_currEditedProgKeys		: {},
	_loadedSkin				: [],
	_lockProgkeysCallback	: false,
	_intNbProgKeys			: 0,
	PROGKEY_FULL			: "FULL",
	PROGKEY_ADD				: "ADD",
	webappsLoaded			: false,
	keysListLoaded			: false,
	objProgkeysScreen		: {},
	bAllowOtherScreen		: false,
	
	/**
	 * Buttons
	 */
	ADD						: "ADD_BTN",
	MODIFY					: "MODIFY_BTN",
	DELETE					: "DELETE_BTN",
	MOVE					: "MOVE_BTN",
	RESET					: "RESET_BTN",
	//NEXT					: "NEXT_BTN",
	BACK					: "BACK_BTN",
	
	/**
	 * List of types
	 */
	NO_TYPE					: 0,
	DIRECT_CALL_KEY			: 1,
	SHORTCUT_ACCESS_KEY		: 2,
	SHORTCUT_ACTION_KEY		: 3,
	FLIP_FLOP				: 4,
	
	VIRTUAL : 0,
	PHYSICAL : 1,

	editedPKKey				: null,
	editedPKAction			: null,

	/*
	 * Constructor
	 */
	constructor: function()
	{
		this.initKeys();
		var func = dojo.hitch(webapp.progkeys, webapp.progkeys.buttonCallback);
		var arrButtons = [];
		
		/**
		 * Add button : Used for add a progkey
		 */
		var addButton = {
			strButtonName	: this.ADD,
			strButtonLabel	: _('Add', 'ICTouchAPI'),
			strButtonIcon	: 'progkeys-add',
			strStatusText	: '',
			strStatusIcon	: '',
			callback		: func
		}
		
		/**
		 * Modify button : Used for edit a progkey
		 */
		var editButton = {
			strButtonName	: this.MODIFY,
			strButtonLabel	: _('Modify', 'ICTouchAPI'),
			strButtonIcon	: 'progkeys-modify',
			strStatusText	: '',
			strStatusIcon	: 'notif-off',
			callback		: func
		}
		
		/**
		 * Delete button : Used for delete a progkey
		 */
		var deleteButton = {
			strButtonName	: this.DELETE,
			strButtonLabel	: _('Delete', 'ICTouchAPI'),
			strButtonIcon	: 'progkeys-delete',
			strStatusText	: '',
			strStatusIcon	: 'notif-off',
			callback		: func
		}
		
		/**
		 * Move button : Used for move a progkey
		 */
		var moveButton = {
			strButtonName	: this.MOVE,
			strButtonLabel	: _('Move', 'webapp.progkeys'),
			strButtonIcon	: 'progkeys-move',
			strStatusText	: '',
			strStatusIcon	: 'notif-off',
			callback		: func
		}

		/**
		 * Reset button : Used for reset the first page
		 */
		var resetButton = {
			strButtonName	: this.RESET,
			strButtonLabel	: _('Reset', 'webapp.progkeys'),
			strButtonIcon	: 'settings-device-reset-factory',
			strStatusText	: '',
			callback		: func
		}
		
		arrButtons.push(addButton, editButton, moveButton, deleteButton, resetButton);
		this._lstAppButtons[this.PROGKEY_FULL] = arrButtons;
		
		/**
		 * Next button : Used for go from one step of progkey edition or adding to another
		 */
		/*arrButtons = [];
		var nextButton = {
			strButtonName	: this.NEXT,
			strButtonLabel	: _('Next', 'ICTouchAPI'),
			strButtonIcon	: 'generic-next',
			strStatusText	: '',
			strStatusIcon	: '',
			callback		: func
		}
		arrButtons.push(nextButton);
		this._lstAppButtons[this.PROGKEY_ADD] = arrButtons;*/
	},

	initKeys : function(){
		// initializing the progkey array
		this.arrProgKeys = [];
		this.arrProgKeys[this.VIRTUAL] = [];
		for(var i=0; i <72; i++) {
			this.arrProgKeys[this.VIRTUAL][i] = null;
		}
		
		//Retrieve progkeys available actions from business module
		ICTouchAPI.APIServices.ProgrammableKeys.getAllActions({params:[], context:this, callback:this.loadedActionsList, callbackParams:null});
		//Retrieve progkeys available locations from setting
		ICTouchAPI.settingServices.getSettingValue("ProgKeysLocations", this, this.loadedLocationsList,{});
	},
	
	/**
	 * loadedLocationsList
	 * Callback function for ProgKeysLocations setting. This function registered the progkeys Locations.
	 * @param arrProgKeysLocations {Array} : Progkeys Location list. Need to be parsed from Json.
	 */
	loadedLocationsList: function(arrProgKeysLocations)
	{
		for(var i=0; i < arrProgKeysLocations.length; i++){
			this._arrProgKeysLocations.push(dojo.fromJson(arrProgKeysLocations[i]));
		}
		arrProgKeysLocations = null;
	},

	/**
	 * getAppBarAppButtons
	 * Return the buttons list for a specific screen name
	 * @param screenName {String} : Screen Name
	 * @return arrAppButtons {Array} : Appbutton Array for required screen
	 */
	getAppBarAppButtons : function(screenName){
		var appButtons = this._lstAppButtons[screenName];
		screenName = null;
		return appButtons;
	},

	/**
	 * getTemplateActionList
	 * @return arrTemplateActionList {Array} : return template actions list as Array
	 */
	getTemplateActionList : function() {
		var arrTemplateActionList = [];
		var arrNewActions;
		for(var applicationName in webapp) {
			if(webapp[applicationName].onProgKeyAction) {
				arrNewActions = webapp[applicationName].onProgKeyAction();
				for(var i in arrNewActions){
					arrTemplateActionList.push(arrNewActions[i]);
				}
			}
		}
		return arrTemplateActionList;
	},

	/**
	 * getLocationsList
	 * @return _arrProgKeysLocations {Array} : return Location list as Array
	 */
	getLocationsList : function(){
		return this._arrProgKeysLocations;
	},
	
	/**
	 * searchPositionVirtualKey
	 * return the first empty position
	 * @return maxPosition {int} : the first empty position
	 */
	searchPositionVirtualKey: function() {
		var maxPosition = 0;
		for(var i in this.arrProgKeys)
			for(var j in this.arrProgKeys[i])
				if(!this.arrProgKeys[i][j] && maxPosition == 0) {
					maxPosition = j;
				}
		maxPosition = (maxPosition == 0) ? this.arrProgKeys[0].length : maxPosition;
		return maxPosition;
	},
	
	/**
	 * LoadedActionsList
	 * Callback function for getAllActions business call. This function registered the progkeys action.
	 * @param arrProgKeysActions {Array} : Progkeys Action array. No need to be modified before register
	 */
	loadedActionsList: function(arrProgKeysActions)
	{
		this.lstActions = {};
		var iMax		= arrProgKeysActions.length;
		var objAction	= null;
		for(var i=0; i<iMax; i++) {
			objAction							= arrProgKeysActions[i];
			objAction.isMoveable				= true;
			this.lstActions[objAction.idAction] = objAction;
		}
		//Retrieve progkeys from business module
		ICTouchAPI.APIServices.ProgrammableKeys.getAllProgrammableKeys({params:[], context:this, callback:this.loadedKeysList, callbackParams:null});
		arrProgKeysActions	= null;
	},
	
	/**
	 * LoadedKeysList
	 * Callback function for getAllProgrammableKeys business call. This function registered the progkey.
	 * It also registered types and actions
	 * @param unorderedProgKeys {Array} : Progkeys list not ordered
	 */
	loadedKeysList: function(unorderedProgKeys)
	{
		for(var i in unorderedProgKeys){
			var _objCurrKey = unorderedProgKeys[i];
			// We look for the type of the key's action inside the Actions array. default : no type
			var _objCurrActionType = this.lstActions[_objCurrKey.idAction];

			//If this type is not active
			if(!this.lstActionTypes[_objCurrActionType]){
				//Activate the type (At least one progkey is available in this type)
				this.lstActionTypes[_objCurrActionType]=1;
				//Add the type to the Active Types List
				this.lstActiveTypes[_objCurrActionType]=true;
			}

			//If the type has no progkey, create array
			if(!this.arrProgKeys[_objCurrKey.type]){
				this.arrProgKeys[_objCurrKey.type]=[];
			}
			//Add current key to the corresponding type Array
			this.arrProgKeys[_objCurrKey.type][_objCurrKey.position] = _objCurrKey;

			if(!this.lstProgKeys[_objCurrKey.type]){
				this.lstProgKeys[_objCurrKey.type]={};
			}
			//Add current key to the progkeys list
			this.lstProgKeys[_objCurrKey.type][_objCurrKey.idKey]=_objCurrKey;
			
			// register button in homepage
			ICTouchAPI.tools.registerHomepageKey([	"webapp.progkeys.getProgKeys",	// webapp name
													"PROGKEYS_"+_objCurrKey.idKey,	// button name
													_objCurrKey.icon,				// button icon
													_objCurrActionType.label,		// button label
													null,							// button status icon
													function(idKey){webapp.progkeys.functionShortPressProgKey(idKey)},	// callback short press
													_objCurrKey.position,														// position
													function(idKey){webapp.progkeys.functionLongPressProgKey(idKey)}		// callback long press
												]);
		}
		unorderedProgKeys	= null;
		this.keysListLoaded = true;
		if(this.webappsLoaded) {
		this.syncProgKeysWithHomepage();
		}
	},

	syncProgKeysWithHomepage : function () {
		ICTouchAPI.debugServices.info("webapp.progkeys.dataBase - syncProgKeysWithHomepage");
		var regexProgKey		= /^PROGKEYS_[0-9]*$/g;
		var HPKeys				= webapp.homepage.data._arrKeys;
		var objProgKey			= null;
		var idProgKey			= null;
		var searchId			= null;
		var oldPosition			= null;
		var emptyPlace			= null;

		for(var i=0; (i<HPKeys.length) || (i<72); i++) {
			objProgKey = this.arrProgKeys[0][i];
			if(HPKeys[i] == null || HPKeys[i] == "") {
				if(objProgKey) {
					this.arrProgKeys["0"][i]=null;
					this.arrProgKeys["0"].push(objProgKey);
				} 
			} else {
				if((HPKeys[i]+"").match(regexProgKey)) {
					idProgKey = HPKeys[i].split("PROGKEYS_")[1];
				} else {
					idProgKey = HPKeys[i];
				}

				if (i>71) {
					if(objProgKey){
					for(var j=0; j<HPKeys.length; j++) {
						if(HPKeys[j] == null || HPKeys[j] == "") {
							emptyPlace = j;
							break;
						}
					}

					// Move to empty place
					if(this.lstProgKeys[0][idProgKey].position != null) {
						//Replace by find...?
						this.arrProgKeys["0"][this.lstProgKeys[0][idProgKey].position]=null;
					}
					this.arrProgKeys["0"][emptyPlace]=this.lstProgKeys[0][idProgKey];
					this.arrProgKeys["0"][emptyPlace].oldPosition=i;
					this.arrProgKeys["0"][emptyPlace].position=emptyPlace;
					webapp.homepage.data.moveKeys(i, emptyPlace);

					ICTouchAPI.APIServices.ProgrammableKeys.modifyProgrammableKey({params:[this.arrProgKeys["0"][emptyPlace]], context:webapp.progkeys, callback:webapp.progkeys.errorManager, callbackParams:null});
					}
				}
				else if(objProgKey) {
					if(objProgKey.idKey != idProgKey) {
						var foundKey = this.lstProgKeys[0][idProgKey];
						if(foundKey != null) {
							
							//find position
							oldPosition = null;
							for(var j=0; j<HPKeys.length; j++) {
								if((HPKeys[j]+"").match(regexProgKey)) {
									searchId = HPKeys[j].split("PROGKEYS_")[1];
								} else {
									searchId = HPKeys[j];
								}
								if(searchId == objProgKey.idKey) {
									oldPosition = j;									
									break;
								}
							}

							
							//var currentPosition = foundKey.position;
							foundKey.oldPosition = oldPosition;
							objProgKey.oldPosition = i;
							foundKey.position = i;
							objProgKey.position = oldPosition;

							// Then, save it on the right place
							this.arrProgKeys["0"][foundKey.position] = foundKey;
							this.arrProgKeys["0"][objProgKey.position] = objProgKey;

							if (webapp.progkeys.data.getActionById(foundKey.idAction).action != "webapp") {
								// we are moving a progkey
								ICTouchAPI.APIServices.ProgrammableKeys.modifyProgrammableKey({params:[foundKey], context:webapp.progkeys, callback:webapp.progkeys.errorManager, callbackParams:null});
							}

							if (webapp.progkeys.data.getActionById(objProgKey.idAction).action != "webapp") {
								// we are moving to a progkey position
								ICTouchAPI.APIServices.ProgrammableKeys.modifyProgrammableKey({params:[objProgKey], context:webapp.progkeys, callback:webapp.progkeys.errorManager, callbackParams:null});
							}	
							
							
							
						} else {
							ICTouchAPI.debugServices.warning("webapp.progkeys.dataBase - syncProgKeysWithHomepage / Homepage key not found in progkey database");
							this.arrProgKeys["0"][i]=null;
							this.arrProgKeys["0"].push(objProgKey);
							this.addHomepageKey(i);
						}
					}
				} else {
					foundKey = this.lstProgKeys[0][idProgKey];
					if(foundKey != null) {

						var oldposition = foundKey.position;
						this.arrProgKeys["0"][oldposition]=null;
						this.arrProgKeys["0"][i]=foundKey;
						this.arrProgKeys["0"][i].oldPosition=oldposition;
						this.arrProgKeys["0"][i].position=i;

						ICTouchAPI.APIServices.ProgrammableKeys.modifyProgrammableKey({params:[  webapp.progkeys.data.arrProgKeys["0"][i]], context:webapp.progkeys, callback:webapp.progkeys.errorManager, callbackParams:null});
						foundKey = null;
					}
					else {
						if(webapp.homepage.data._arrAppKeys[i] == null) {
							if (webapp.myICWall && (HPKeys[i]+"").match(/^awap_[0-9]*$/g) )	{
								ICTouchAPI.debugServices.debug("webapp.progkeys.dataBase - syncProgKeysWithHomepage / webapp myICWall is loaded and the current key (" + HPKeys[i] + ") is an awap key -> keep its position (wall not yet loaded or connection problems)");
							}
							else {
								ICTouchAPI.debugServices.warning("webapp.progkeys.dataBase - syncProgKeysWithHomepage / the key " + HPKeys[i] + " is not used anymore, clean its position");
								webapp.homepage.data._arrKeys[i] = "";
							}
						}
						else {
							ICTouchAPI.debugServices.warning("webapp.progkeys.dataBase - syncProgKeysWithHomepage / Homepage key not found in progkey database");
							this.addHomepageKey(i);
						}
					}
				}
			}
		}
		if(webapp.homepage.data._arrKeys.length > 72) {
			webapp.homepage.data._arrKeys = webapp.homepage.data._arrKeys.slice(0,72);			
		}
		if(webapp.homepage.data._arrAppKeys.length > 72) {
			webapp.homepage.data._arrAppKeys = webapp.homepage.data._arrAppKeys.slice(0,72);			
		}
		if(this.arrProgKeys[0].length > 72) {
			this.arrProgKeys[0] = this.arrProgKeys[0].slice(0,72);			
		}

		if(webapp.progkeys.currentFullWidget) {
			webapp.progkeys.currentFullWidget.fillProgKeysList();
		}
		webapp.homepage.data.saveKeys();
		if(webapp.homepage.homepageStandardView) {
			webapp.homepage.homepageStandardView.updateKeys(true);
		}
	},

	/**
	 * getActionById
	 * Return the action of a specific id
	 * @param idAction {int} : action id
	 * @return lstActions[idAction] {Action} : Action corresponding to the id in parameter
	 */
	getActionById : function(idAction) {
		return this.lstActions[idAction];
	},
	
	/**
	 * deleteProgKey
	 * Delete an action based on the id before we delete the progkey
	 * @param objProgKey {Object} : Progkey to remove
	 */
	deleteProgKey : function(objProgKey) {
		this._lockProgkeysCallback = true;
		this.currentProgKey	= null;
		// unregister button un homepage
		ICTouchAPI.tools.unregisterHomepageKey(["PROGKEYS_"+objProgKey.idKey, true]);
		
		ICTouchAPI.APIServices.ProgrammableKeys.deleteProgrammableKey({params:[objProgKey.idKey], context:this, callback:this.deleteAction, callbackParams:objProgKey});
	},
	
	/**
	 * deletedAction
	 * Delete an action based on the id
	 * @param objProgKey {Object} : Action to remove
	 */
	deleteAction : function(args, objProgKey) {
		var objAction = this.getActionById(objProgKey.idAction);
		ICTouchAPI.APIServices.ProgrammableKeys.deleteAction({params:[objAction.idAction], context:this, callback:this.deletedProgKey, callbackParams:{objProgKey : objProgKey}});
		args		= null;
		objProgKey	= null;
	},
	
	/**
	 * deletedProgKey
	 * Callback function for deleteProgrammableKey business module method
	 * @param boolDeleted	{Bool}	: Delete successfull, or not
	 * @param args			{Object}: Deleted (or not) progkey. Used for progkeys list update in case of deletion
	 */
	deletedProgKey : function(boolDeleted, args){
		if(boolDeleted === 0) {
			var keyPosition	= args.objProgKey.position;
			var arrProgKeys	= this.arrProgKeys[args.objProgKey.type];
			
			//Delete entry in prokeys array.
			arrProgKeys[keyPosition] = null;
			
			//Delete entry in progkeys list
			delete this.lstProgKeys[args.objProgKey.type][args.objProgKey.idKey];
			this.arrProgKeys[args.objProgKey.type] = arrProgKeys;
		}
		
		boolDeleted	= null;
		args		= null;
	},
	
	/**
	 * 
	 */
	removeAllProgkeys : function() {
		var objProgkey;
		for(var i in this.lstProgKeys[this.VIRTUAL]){
			objProgkey = this.lstProgKeys[this.VIRTUAL][i];

			// Remove the progkeys and action if it is a user created progkey.
			if(objProgkey && this.lstActions[objProgkey.idAction] && this.lstActions[objProgkey.idAction].isUserRemovable){
				// Remove the associated action.
				delete this.lstActions[objProgkey.idAction];

				// Remove the progkey in both arrays
				delete this.lstProgKeys[this.VIRTUAL][i];
				this.arrProgKeys[this.VIRTUAL][objProgkey.position] = null;

				// Remove the progkey graphically
				if(webapp.progkeys.currentFullWidget){
					webapp.progkeys.currentFullWidget.deleteProgKey(objProgkey.idKey);
				}

				ICTouchAPI.tools.unregisterHomepageKey(["PROGKEYS_"+objProgkey.idKey, true]);
			}
		}

		// Send the new status to homepage.
		ICTouchAPI.settingServices.getSettingValue("HomepageDefaultKeys", this, webapp.progkeys.resetFirstPage);
	},
	
	/**
	 * modifiedKeysList
	 * This function modify the progkey
	 * It also registered modified types and actions
	 * @param progKey {ProgKey} : Progkey object
	 */
	modifiedKeysList: function(progKey) {
		var oldProgKey = this.lstProgKeys[progKey.type][progKey.idKey];
		
		if(progKey.position != oldProgKey.position) { // If it is the end of Edition Mode : only position changed
			this.lstProgKeys[progKey.type][progKey.idKey] = progKey;
		} else { // Otherwise : all may change
			if(progKey.type == oldProgKey.type) { //If type didn't change, we just have to update the object
				this.lstProgKeys[progKey.type][progKey.idKey] = progKey;
				this.arrProgKeys[progKey.type][progKey.position] = progKey;
			} else { //Otherwise, as progkeys are ordered by type, we must verify
				this.arrProgKeys[oldProgKey.type].splice(progKey.position,1);
				
				//If the type has no progkey, create array
				if(!this.arrProgKeys[progKey.type]){
					this.arrProgKeys[progKey.type]=[];
				}
				//Add current key to the corresponding type Array
				this.arrProgKeys[progKey.type][progKey.position] = progKey;

				delete this.lstProgKeys[oldProgKey.type][progKey.idKey];
				//If the type has no progkey, create array
				if(!this.lstProgKeys[progKey.type]){
					this.lstProgKeys[progKey.type]={};
				}
				//Add current key to the progkeys list
				this.lstProgKeys[progKey.type][progKey.idKey]=progKey;
			}
		}
        progKey	= null;
	},
	
	addHomepageKey : function(pos) {
		var arrButtonKey	= webapp.homepage.data.getAppKey();
		var objButton		= {};
		var objProgKey		= {};
		var objAction		= {};
		var webAppName		= "";
		var isMoveable		=true; 
		var regexpProgkeys	= /^PROGKEYS_[0-9]*$/g;
		var regexpNum		= /^[0-9]*$/g;
		var strButtonName	= "";
		
		if(!this.arrProgKeys[0]) {
			this.arrProgKeys[0] = [];
		}
		if(!this.lstProgKeys[0]) {
			this.lstProgKeys[0] = [];
		}
		
		if(pos) {
			if(!this.arrProgKeys[0][pos]) {
				objButton = arrButtonKey[pos];
				if(objButton) {
					strButtonName = (objButton.strButtonName.match(regexpNum)) ? "we-"+objButton.strButtonName : objButton.strButtonName;
					if(!strButtonName.match(regexpProgkeys)) {
						objProgKey = {
							aom_addr		: "",
							aom_type		: "",
							container		: "MainContainer",
							icon			: objButton.strButtonIcon,
							idAction		: -pos,
							idDM			: "",
							idKey			: strButtonName,
							isUserRemovable : 0,
							position		: pos,
							type			: 0
						};

						var elem	= objButton.strButtonIcon.split('-');
						webAppName	= (elem[0] != 'generic') ? elem[0] : elem[1];
						if(objButton._boolMoveable==false){
							isMoveable=false;
						}

						objAction = {
							action			: "webapp",
							arguments		: objButton.callback,
							idAction		: -pos,
							idDM			: "",
							label			: objButton.strButtonLabel,
							shortLabel		: objButton.strButtonLabel,
							type			: 2,
							webAppName		: webAppName,
							isUserRemovable : 0,
							isMoveable  : isMoveable
						}

						this.arrProgKeys[objProgKey.type][objProgKey.position]	= objProgKey;
						this.lstProgKeys[objProgKey.type][objProgKey.idKey]		= objProgKey;
						this.lstActions[objAction.idAction]						= objAction;
					} else if(!this.arrProgKeys[0][pos]) {
						this.arrProgKeys[0][pos]	= null;
					}
				} else if(!this.arrProgKeys[0][pos]) {
					this.arrProgKeys[0][pos]	= null;
				}
			}
		} else {	
		for(var i in arrButtonKey) {
			if(!this.arrProgKeys[0][i]) {
				objButton = arrButtonKey[i];
				if(objButton) {
					strButtonName = (objButton.strButtonName.match(regexpNum)) ? "we-"+objButton.strButtonName : objButton.strButtonName;
					if(!strButtonName.match(regexpProgkeys)) {
						objProgKey = {
							aom_addr		: "",
							aom_type		: "",
							container		: "MainContainer",
							icon			: objButton.strButtonIcon,
							idAction		: -i,
							idDM			: "",
							idKey			: strButtonName,
							isUserRemovable : 0,
							position		: i,
							type			: 0
						};
						
						var elem	= objButton.strButtonIcon.split('-');
						webAppName	= (elem[0] != 'generic') ? elem[0] : elem[1];
						if(objButton._boolMoveable==false){
						    isMoveable=false;
						}

						objAction = {
							action			: "webapp",
							arguments		: objButton.callback,
							idAction		: -i,
							idDM			: "",
							label			: objButton.strButtonLabel,
							shortLabel		: objButton.strButtonLabel,
							type			: 2,
							webAppName		: webAppName,
							isUserRemovable : 0,
							isMoveable  : isMoveable
						}
						
						this.arrProgKeys[objProgKey.type][objProgKey.position]	= objProgKey;
						this.lstProgKeys[objProgKey.type][objProgKey.idKey]		= objProgKey;
						this.lstActions[objAction.idAction]						= objAction;
					} else if(!this.arrProgKeys[0][i]) {
						this.arrProgKeys[0][i]	= null;
					}
				} else if(!this.arrProgKeys[0][i]) {
					this.arrProgKeys[0][i]	= null;
					}
				}
			}
		}
	},
	
	getProgKeyByIdAction : function(idAction) {
		var objProgKey	= null;
		for(var i in this.lstProgKeys[0]) {
			if(this.lstProgKeys[0][i].idAction == idAction) {
				objProgKey	= this.lstProgKeys[0][i];
				break;
			}
		}
		
		return objProgKey;
	}
});
