/*
 * Control for the progkeys webapplication.
 * Progkeys webapplication manages shortcut displayed on a homepage standard.
 * Prokeys webapplication handles also action button on AOM (physical Add On Module)
 */
dojo.provide("webapp.progkeys.controlBase");
dojo.declare("webapp.progkeys.controlBase", ICTouchAPI.webApplication,
{
	currentFullWidget		: null,
	_boolIsEditingProgKey	: false,
	currentAddWidget		: null,
	_iframeShowHandler		: null,
	_comSelectStatusChangeHandler	: null,

	/**
	 * Constructor
	 */
	constructor : function() {
		ICTouchAPI.skinServices.linkWebappsStyles("UIElements.Keyboard","webapp.progkeys", true, true, true);
		this.stealthProgkeysScreen();
		dojo.subscribe("progkeys/reload", this, this._addHomepageKey);

		// add listener for contact modification. Allows to update contacts pictures in progkeys
		var myDS = ICTouchAPI.dataStoreServices.getStore('contacts');
		myDS.addEventListener(myDS.E_ITEM_UPDATED, this, this.onContactUpdated);
	},

	loaded : function() {
		ICTouchAPI.eventServices.subscribeToEvent(this, "ACTION_CREATE_NTF", this.createdActionNTF);
		ICTouchAPI.eventServices.subscribeToEvent(this, "ACTION_MODIFY_NTF", this.modifiedActionNTF);
		ICTouchAPI.eventServices.subscribeToEvent(this, "ACTION_DELETE_NTF", this.deletedActionNTF);
		ICTouchAPI.eventServices.subscribeToEvent(this, "KEY_CREATE_NTF", this.createdKeyNTF);
		ICTouchAPI.eventServices.subscribeToEvent(this, "KEY_MODIFY_NTF", this.modifiedKeyNTF);
		ICTouchAPI.eventServices.subscribeToEvent(this, "KEY_DELETE_NTF", this.deletedKeyNTF);
		ICTouchAPI.eventServices.subscribeToEvent(this, "DB_RESET_NTF", this.resetedDbNTF);

		ICTouchAPI.settingServices.subscribeToSetting(this, "ProgKeysReset", this.resetDM);
	},

	load : function() {
		this.data.webappsLoaded = true;
		if(this.data.keysListLoaded) {
			this.data.syncProgKeysWithHomepage();
		}
	},

	/**
	 * dump function
	 */
	dump : function(boolAdvancedLogs) {
		this.inherited(arguments);
		//ICTouchAPI.debugServices.dump("progkeys settings :");
		if (boolAdvancedLogs) {
			ICTouchAPI.debugServices.dump("progkeys internal variables :");
			ICTouchAPI.debugServices.dump(" - arrProgKeys: ");
			for (var i in this.data.arrProgKeys[0]) {
				if (this.data.arrProgKeys[0][i]) {
					ICTouchAPI.debugServices.dump(" -> arrProgKeys[0]["+i+"]: idKey = '" + this.data.arrProgKeys[0][i].idKey + "', idDM = '" + this.data.arrProgKeys[0][i].idDM + "', position = " + this.data.arrProgKeys[0][i].position + ", idAction = " + this.data.arrProgKeys[0][i].idAction + ", isUserRemovable = " + this.data.arrProgKeys[0][i].isUserRemovable + ", icon = '" + this.data.arrProgKeys[0][i].icon + "'");
				}
				else {
					ICTouchAPI.debugServices.dump(" -> arrProgKeys[0]["+i+"] is not defined");
				}
			}
			for (var i in this.data.lstProgKeys[0]) {
				if (this.data.lstProgKeys[0][i]) {
					ICTouchAPI.debugServices.dump(" -> lstProgKeys[0]["+i+"]: idKey = '" + this.data.lstProgKeys[0][i].idKey + "', idDM = '" + this.data.lstProgKeys[0][i].idDM + "', position = " + this.data.lstProgKeys[0][i].position + ", idAction = " + this.data.lstProgKeys[0][i].idAction + ", isUserRemovable = " + this.data.lstProgKeys[0][i].isUserRemovable + ", icon = '" + this.data.lstProgKeys[0][i].icon + ", image = '" + this.data.lstProgKeys[0][i].image + ", i18nlabel = '" + ((typeof this.data.lstProgKeys[0][i].i18nlabel === "string") ? this.data.lstProgKeys[0][i].i18nlabel : ((typeof this.data.lstProgKeys[0][i].i18nlabel === "object" && this.data.lstProgKeys[0][i].i18nlabel && this.data.lstProgKeys[0][i].i18nlabel.isI18Ned) ? this.data.lstProgKeys[0][i].i18nlabel.getTranslation() : "")) + "'");
				}
				else {
					ICTouchAPI.debugServices.dump(" -> lstProgKeys[0]["+i+"] is not defined");
				}
			}
			ICTouchAPI.debugServices.dump(" - currentFullWidget._lstKeysButtons: ");
			if (this.currentFullWidget) {
				for (var i in this.currentFullWidget._lstKeysButtons) {
					ICTouchAPI.debugServices.dump(" -> currentFullWidget._lstKeysButtons["+i+"]: idKey = '" + this.currentFullWidget._lstKeysButtons[i].idKey + "', boolDelete = " + this.currentFullWidget._lstKeysButtons[i].boolDelete + ", boolMoveable = " + this.currentFullWidget._lstKeysButtons[i].boolMoveable + ", boolUpdate = " + this.currentFullWidget._lstKeysButtons[i].boolUpdate + ", label = '" + ((typeof this.currentFullWidget._lstKeysButtons[i].label === "string") ? this.currentFullWidget._lstKeysButtons[i].label : ((typeof this.currentFullWidget._lstKeysButtons[i].label === "object" && this.currentFullWidget._lstKeysButtons[i].label && this.currentFullWidget._lstKeysButtons[i].label.isI18Ned) ? this.currentFullWidget._lstKeysButtons[i].label.getTranslation() : "")) + "', icon = '" + this.currentFullWidget._lstKeysButtons[i].icon + "'");
				}
			}
			else {
				ICTouchAPI.debugServices.dump(" -> currentFullWidget is not defined");
			}
		}
	},

	buttonCallback : function(buttonId) {
		var data = webapp.progkeys.data;
		switch(buttonId) {
			case data.ADD : //Activate the add Mode
				this.setEditingProgKey(true);
				//Get the add screen "webapp.progkeys.getProgKeyAdd"
				var context = this;
				if(this.currentFullWidget.modifyModeEnabled){
				    this.currentFullWidget.toggleModifyMode();
				}
				var backAddCallback = function() {context.backAddCallback()};
				var endAddCallback = function(editedProgKey,editedAction) {context.endAddCallback(editedProgKey,editedAction)};
				this.addProgkey({backAddCallback:backAddCallback, endAddCallback:endAddCallback, progkeysWebapp:true});
				break;
			case data.MODIFY : //Activate the modify mode
				this.currentFullWidget.toggleModifyMode();
				break;
			case data.DELETE : //Activate the delete mode
				this.currentFullWidget.toggleDeleteMode();
				break;
			case data.MOVE : //Activate the move mode
				this.currentFullWidget.toggleMoveMode();
				break;
			case data.RESET : // Reset the first page
				this.reset();
				break;
			/*case data.NEXT : // Go to the next step
				this.currentAddWidget.nextStep();
				break;*/
		}
		buttonId = null;
	},

	/**
	 * Add progkey is a public method to call screen that create progkey.
	 * @param {Object} args is an object that can contain the following values:
	 *	- editedProgKey		{Object}  : current editedProgKey. If this parameter is null, create progkey
	 *	- backAddCallback	{function}: Callback when user click back button on first screen,
	 *	- endAddCallback		{function}: Callback at end of progkey creation. this callback passe 2 parameters: editedProgKey, editedAction
	 *	- progkeysWebapp	{boolean}: set true if calling webapp is progkeys, false otherwise
	 *	- editedProgKey		{Object}  : current editedProgKey
	 *	- editedAction		{Object}  : current editedAction
	 */
	addProgkey : function (args) {
		if(args.editedProgKey!=null && args.editedAction!=null) {
			this.data.editedPKKey = args.editedProgKey;
			this.data.editedPKAction = args.editedAction;
		} else {
			this.data.editedPKKey = {
				container : "MainContainer",
				icon : "",
				type : "",
				idAction : -1,
				position : -1
			};
			this.data.editedPKAction = {
				type : 0,
				action : "",
				webAppName : "",
				arguments : "",
				label : ""
			};
		}

		if(this.currentAddWidget) {
			this.currentAddWidget.reloadInit();
			if(this.currentAddWidget.wdgSelectAction){
				this.currentAddWidget.wdgSelectAction.getContent().getContent().reloadInit();
			}
			this.currentAddWidget.progkeysWebapp = args.progkeysWebapp;
			this.currentAddWidget.backAddCallback = args.backAddCallback;
			this.currentAddWidget.endAddCallback = args.endAddCallback;
			/*if(args.editedProgKey!=null && args.editedAction!=null) {
				this.data.editedPKKey = args.editedProgKey;
				this.data.editedPKAction = args.editedAction;

			}*/
		}
		
		this.subscribeEvents();
		webapp.communication.data.setNotifyCallByPopup(true);
		ICTouchAPI.transitionServices.unstealth("webapp.progkeys.getProgKeys");
		ICTouchAPI.transitionServices.getScreen({name : "webapp.progkeys.getProgKeyAdd", params : {progkeysWebapp:args.progkeysWebapp, backAddCallback:args.backAddCallback, endAddCallback:args.endAddCallback}});
		args = null;
	},

	reloadContext : function (bDontResetComStatus) {
	    this.stealthProgkeysScreen();
	    if(webapp.communication && webapp.communication.data) {
			if(!bDontResetComStatus) {
		webapp.communication.setSelectStatus(-1);
	    }
			webapp.communication.data.setNotifyCallByPopup(false);
		}
		this.data.bAllowOtherScreen = false;
		this.unsubscribeEvents();
	},

	createdActionNTF : function(args) {
		var Action			= args.value;
		Action.isMoveable	= true;
		Action.arguments	= (typeof Action.arguments == "string") ? dojo.fromJson(Action.arguments) : Action.arguments;
		this.data.lstActions[Action.idAction] = Action;
		this.setEditingProgKey(false);
		args = null;
	},

	modifiedActionNTF : function(args) {
		var Action			= args.value;
		Action.isMoveable	= true;
		Action.arguments	= (typeof Action.arguments == "string") ? dojo.fromJson(Action.arguments) : Action.arguments;
		this.data.lstActions[Action.idAction] = Action;
		this.setEditingProgKey(false);
		args = null;
	},

	deletedActionNTF : function(args) {
		var idAction = args.value;
		delete this.data.lstActions[idAction];
		args = null;
	},

	createdKeyNTF : function(args) {
		var Key = args.value;
		this.data.loadedKeysList([Key]);
		if(this.currentFullWidget) {
			// register button in homepage
			/*ICTouchAPI.tools.registerHomepageKey([	"webapp.progkeys.getProgKeys",	// webapp name
													"PROGKEYS_"+Key.idKey,				// button name
													this.data.editedPKKey.icon,		// button icon
													this.data.editedPKAction.label,	// button label
													null,							// button status icon
													function(idKey){webapp.progkeys.functionShortPressProgKey(idKey)},		// callback short press
													this.data.editedPKKey.position,															// position
													function(idKey){webapp.progkeys.functionLongPressProgKey(idKey)}		// callback long press
												]);*/
			this.updateAppBar();
			this.currentFullWidget.objNavigationBarUI.goToPage(Math.floor(this.data.editedPKKey.position / 12)+1);
			this.currentFullWidget.changePage();
		}
		args = null;
	},

	modifiedKeyNTF : function(args) {
		var newKey = args.value;
		var oldPosition = this.data.lstProgKeys[newKey.type][newKey.idKey].oldPosition;
		this.data.modifiedKeysList(newKey);
		if(oldPosition === undefined || oldPosition === newKey.position) {
			//modify button
			if(this.currentFullWidget) {
				var objAction = webapp.progkeys.data.getActionById(newKey.idAction);
				// unregister button un homepage
				ICTouchAPI.tools.unregisterHomepageKey(["PROGKEYS_"+newKey.idKey, true]);
				var handler	= setTimeout(function() {
					// register button in homepage
					ICTouchAPI.tools.registerHomepageKey([	"webapp.progkeys.getProgKeys",	// webapp name
															"PROGKEYS_"+newKey.idKey,	// button name
															newKey.icon,				// button icon
															objAction.label,		// button label
															null,							// button status icon
															function(idKey){webapp.progkeys.functionShortPressProgKey(idKey)},	// callback short press
															newKey.position,														// position
															function(idKey){webapp.progkeys.functionLongPressProgKey(idKey)}		// callback long press
														]);
					clearTimeout(handler);
				}, 1000);

				this.currentFullWidget.modifyProgKey(newKey);
			}
		} else {
			delete this.data.lstProgKeys[newKey.type][newKey.idKey].oldPosition;
		}
		args = null;
	},

	deletedKeyNTF : function(args) {
		var idKey	= args.value;
		var data	= webapp.progkeys.data;

		if(this.currentFullWidget) {
			this.currentFullWidget.deleteProgKey(idKey);
			this.updateAppBar();
		}
		this.data._lockProgkeysCallback = false;
		args = null;
	},

	backAddCallback : function() {
		ICTouchAPI.transitionServices.getScreen({
				name : 'webapp.progkeys.getProgKeys',
				params : {}
		});
	},

	/**
	 * Save the arguments of progkey
	 */
	setProgkeysArgumentsNextStep : function (args) {
		this.currentAddWidget.boolReset = false;

		ICTouchAPI.transitionServices.getScreen({name: "webapp.progkeys.getProgKeyAdd", params: {}});
		
			this.data.editedPKAction.arguments = args;

		// make canonical number for number Phone
		ICTouchAPI.APIServices.Telephony.makeCanonicalNumber({
			params:[this.data.editedPKAction.arguments.strContent],
			context: this,
			callback: this._makeCanonicalNumber
		});
		args = null;
	},

	_makeCanonicalNumber : function(number) {
		this.data.editedPKAction.arguments.strContent	= number;

		// research contact id according to phone number
		if(this.data.editedPKAction.action == 'call') {
			this.data.editedPKAction.arguments.contactId	= this.researchContactId(number);
		}
		this.currentAddWidget.nextStep();

		number	= null;
	},

	researchContactId : function(phoneNumber) {
		var intContactId = null;

		var objContact = ICTouchAPI.dataStoreServices.getStore('contacts').find(["officePhoneCan", "personalHomeCan", "personalMobileCan", "personalFax"],phoneNumber)[0];

		if(objContact) {
			intContactId = objContact.contactId;
		}
		phoneNumber	= null;
		return intContactId;
	},

	endAddCallback : function(editedProgKey, editedAction) {
		ICTouchAPI.transitionServices.stealth("webapp.progkeys.getProgKeyAdd");
		webapp.communication.resetStatus();
		var context			= this;
		var funcCreated		= function(idAction) {context.createdAction(idAction, editedProgKey)};
		var funcModify		= function(intReturn) {context.refreshProgKeys(intReturn)};

		editedAction.arguments = dojo.toJson(editedAction.arguments);

		if(!webapp.progkeys.currentFullWidget.modifyModeEnabled) {
			ICTouchAPI.APIServices.ProgrammableKeys.addAction({params:[editedAction], context:webapp.progkeys, callback:webapp.progkeys.errorManager, callbackParams:funcCreated});
		} else {
			ICTouchAPI.APIServices.ProgrammableKeys.modifyProgrammableKey({params:[editedProgKey], context:webapp.progkeys, callback:webapp.progkeys.errorManager, callbackParams:funcModify});
			ICTouchAPI.APIServices.ProgrammableKeys.modifyAction({params:[editedAction], context:webapp.progkeys, callback:webapp.progkeys.errorManager, callbackParams:null});
		}

		editedProgKey	= null;
		editedAction	= null;
	},

	createdAction : function(idAction) {
		var data	= webapp.progkeys.data;
		if(data.editedPKKey) {
			data.editedPKKey.idAction = idAction;
			var context	= this;
			var func	= function(intReturn){context.refreshProgKeys(intReturn)}
			ICTouchAPI.APIServices.ProgrammableKeys.createProgrammableKey({params:[data.editedPKKey], context:webapp.progkeys, callback:webapp.progkeys.errorManager, callbackParams:func});
		}

		idAction		= null;
	},

	refreshProgKeys : function(intReturn) {
		if(intReturn >=0 ) {
			webapp.progkeys.currentAddWidget.reloadInit();
			ICTouchAPI.transitionServices.getScreen({
				name : 'webapp.progkeys.getProgKeys',
				params : {}
			});
		}
		intReturn	= null;
	},

	errorManager : function(intReturn, funcCallback) {
		var strMessage = "";
		switch (intReturn) {
			case -1:
				strMessage = "PK_FULL";
				break;
			/*case -2:
				strMessage = "PK_ERROR";
				break;*/
			default:
				break;
		}

		if(strMessage != ""){
			ICTouchAPI.popupServices.errorPopup(_("Error", "webapp.progkeys"), _(strMessage, "webapp.progkeys"), _("Ok", "webapp.progkeys"));
		}
		if(funcCallback){
			funcCallback(intReturn);
		}
	},

	_addHomepageKey : function() {
		this.data.addHomepageKey();
	},

	functionShortPressProgKey : function(strButtonName) {
		var data			= webapp.progkeys.data;

		// find the id of progkey
		var elem	= strButtonName.split('PROGKEYS_');
		var idKey	= elem[1];

		var currentProgKey	= data.lstProgKeys["0"][idKey];
		var currentAction	= data.getActionById(currentProgKey.idAction);

		webapp[currentAction.webAppName].onProgKeyClick(currentAction);
		strButtonName	= null;
	},

	functionLongPressProgKey : function(strButtonName) {
		var data			= webapp.progkeys.data;

		// find the id of progkey
		var elem	= strButtonName.split('PROGKEYS_');
		var idKey	= elem[1];

		var currentProgKey	= data.lstProgKeys["0"][idKey];
		var currentAction	= data.getActionById(currentProgKey.idAction);

		var arguments = (typeof currentAction.arguments == "string") ? dojo.fromJson(currentAction.arguments) : currentAction.arguments;
		if((arguments.contactId || arguments.strContent) && webapp[currentAction.webAppName].onProgKeyLongPress) { // if contactid not undefined and onProgKeyLongPress exists in webapp
			webapp[currentAction.webAppName].onProgKeyLongPress(currentAction);
		} else {
			webapp[currentAction.webAppName].onProgKeyClick(currentAction);
		}
		strButtonName	= null;
	},

	onProgkeysDisplay : function(currentKey) {
		var data		= webapp.progkeys.data;

		// find the id of progkey
		var elem	= currentKey.strButtonName.split('PROGKEYS_');
		var idKey	= elem[1];

		var currentProgKey	= data.lstProgKeys["0"][idKey];
		var currentAction	= data.getActionById(currentProgKey.idAction);

		currentAction.arguments = (typeof currentAction.arguments == "string") ? dojo.fromJson(currentAction.arguments) : currentAction.arguments;

		//Execute action on display progkey
		if(currentAction && webapp[currentAction.webAppName] && webapp[currentAction.webAppName].onProgKeyDisplay && currentProgKey.isUserRemovable == 1){
			webapp[currentAction.webAppName].onProgKeyDisplay(currentAction, currentProgKey);
		}
		// Image of button's background
		if(currentProgKey.image) {
			currentKey.imgbutton	= currentProgKey.image;
		}

		// Icon of button
		if(currentProgKey.icon) {
			currentKey.strButtonIcon	= currentProgKey.icon;
		}

		// Status icon of button
		if(currentAction.action == "routing") {
			currentKey.strStatusIcon	= currentAction.arguments.strNotifStatus;
		}

		return currentKey;
	},

	updateAppBar : function() {
		var appBar			= ICTouchAPI.AppBarServices.getAppBar("progkeys", "getProgKeys");
		var addPKButton		= appBar.getButton("ADD_BTN");

		if(addPKButton) {
			if(webapp.homepage.data.getNbAppKeys() >= 72) {
				ICTouchAPI.debugServices.debug("webapp.progkeys.controlBase - updateAppBar / number of keys (webapp.homepage.data.getNbAppKeys()) is >= 72 -> hide 'Add button'");
				addPKButton.hide();
			} else {
				ICTouchAPI.debugServices.debug("webapp.progkeys.controlBase - updateAppBar / number of keys (webapp.homepage.data.getNbAppKeys()) is < 72 -> show 'Add button'");
				addPKButton.show();
		}
		}
	},

	/**
	 * Update call progkey if contact change
	 */
	onContactUpdated : function(){
		dojo.publish('programmablekeys/keysListUpdated');
		dojo.publish("homepageStandard/reload");
	},

	/**
	 * Update progkeys display
	 */
	updateRoutingProgKeysDisplay : function(routingId) {
		var data				= webapp.progkeys.data;
		var lstAction			= data.lstActions;
		var objAction			= null;
		var objSelectedAction	= null;
		var objProgKey			= null;

		for(var i in lstAction) {
			objAction = lstAction[i];
			if(objAction.action == "routing") {
				if(objAction.arguments.routingId == routingId && objAction.arguments.strNotifStatus != 'notif-on') {
					objSelectedAction = objAction;
					break;
				}
			}
		}

		this.desactivateProgKeys(false);

		if(objSelectedAction) {
			objSelectedAction.arguments.strNotifStatus	= "notif-on";
			objSelectedAction.arguments = dojo.toJson(objSelectedAction.arguments);

			ICTouchAPI.APIServices.ProgrammableKeys.modifyAction({params:[objSelectedAction], context:webapp.progkeys, callback:webapp.progkeys.errorManager, callbackParams:null});

			// Update button display
			objProgKey	= data.getProgKeyByIdAction(objSelectedAction.idAction);
			webapp.homepage.homepageStandardView.arrObjKeys[objProgKey.position].setStatusIcon("notif-on");

			if(this.currentFullWidget){
				this.currentFullWidget._lstKeysButtons[objProgKey.position].button.setStatusIcon("notif-on");
			}
		}
		routingId	= null;
	},

	desactivateProgKeys : function() {
		var data		= webapp.progkeys.data;
		var lstAction	= data.lstActions;
		var objAction	= null;
		var objProgKey	= null;

		for(var i in lstAction) {
			objAction = lstAction[i];
			if(objAction.action == "routing") {
				if(objAction.arguments.strNotifStatus != "notif-off") {
					objAction.arguments.strNotifStatus	= "notif-off";
					objAction.arguments					= dojo.toJson(objAction.arguments);
					ICTouchAPI.APIServices.ProgrammableKeys.modifyAction({params:[objAction], context:webapp.progkeys, callback:webapp.progkeys.errorManager, callbackParams:null});

					// Update button display
					objProgKey	= data.getProgKeyByIdAction(objAction.idAction);
					webapp.homepage.homepageStandardView.arrObjKeys[objProgKey.position].setStatusIcon("notif-off");

					if(this.currentFullWidget){
						this.currentFullWidget._lstKeysButtons[objProgKey.position].button.setStatusIcon("notif-off");
					}
				}
			}
		}
	},

	  externalBack : function (doReset) {
            if(this.isEditingProgKey()) {
                if(this.currentAddWidget) {
                    if(/*!doReset &&*/ this.currentAddWidget._currentStep > 0) {
					this.currentAddWidget.back();
		    } else {
                        this.currentAddWidget._currentStep = 1;
                        this.currentAddWidget.back();
 	}
                }

                ICTouchAPI.transitionServices.getScreen({
				name : 'webapp.progkeys.getProgKeyAdd',
				params : {}
 });
            } else {
		 ICTouchAPI.transitionServices.back();
	    }
        },

        isEditingProgKey : function() {
            return this._boolIsEditingProgKey;
        },

        setEditingProgKey : function(boolIsEditingProgKey) {
            this._boolIsEditingProgKey = boolIsEditingProgKey;
	},

	reset : function() {
		//var currentDomProgKey = e.currentTarget;
		var resetPopup = {};

		//If a progkey has to be deleted, show a popup
		var popupData = {
			strTitle: _("Reset first page?","webapp.progkeys"),
			strContent: _("Do you really want to reset progkeys first page?","webapp.progkeys"),
			arrPopupButtons: [
				{
					strButtonName	: 'OK_BTN',
					strButtonLabel	: _('Ok',"webapp.progkeys"),
					callback		: function() {
						ICTouchAPI.settingServices.getSettingValue("HomepageDefaultKeys", this, webapp.progkeys.resetFirstPage);
						ICTouchAPI.popupServices.removePopup(resetPopup);
					},
					strButtonIcon	: 'generic-ok'
				},
				{
					strButtonName	: 'CANCEL_BTN',
					strButtonLabel	: _('Cancel',"webapp.progkeys"),
					callback		: function(){ICTouchAPI.popupServices.removePopup(resetPopup)},
					strButtonIcon	: 'generic-cancel'
        }
			]
		};
		resetPopup = ICTouchAPI.popupServices.addNewPopup(popupData);
	},

	resetFirstPage : function(arrDefaultKeys) {
		arrDefaultKeys			= dojo.clone(arrDefaultKeys);
		var data				= webapp.progkeys.data;
		var strButtonName		= "";
		var objProgKey			= null;
		var otherProgKey		= null;
		var intPosition			= null;
		var regexProgKey		= /^[0-9]*$/g;
		var regexWebappExt		= /^we-[0-9]*$/g;
		var elem				= [];

		var funcCallBackWebApp	= dojo.hitch (this, function () {
			dojo.publish('programmablekeys/keysListUpdated');
});

		if(arrDefaultKeys) {
			for(var i in arrDefaultKeys) {
				strButtonName	= arrDefaultKeys[i];
				if(strButtonName != "") {
					objProgKey	= data.lstProgKeys[0][strButtonName];
					if(objProgKey){
						intPosition	= objProgKey.position;
						if(intPosition != i) {	// Button isn't in the right place
							otherProgKey = data.arrProgKeys[0][i];

							objProgKey.position	= i;
							objProgKey.oldPosition = intPosition
							if(otherProgKey) {
								otherProgKey.position	= intPosition;
								otherProgKey.oldPosition	= i;
							}

							data.arrProgKeys[0][i]				= objProgKey;
							data.arrProgKeys[0][intPosition]	= otherProgKey;

							if (webapp.progkeys.data.getActionById(objProgKey.idAction).action == "webapp") {
								webapp.progkeys.data.lstProgKeys["0"][objProgKey.idKey].position = objProgKey.position;
							}

							if(otherProgKey && webapp.progkeys.data.getActionById(otherProgKey.idAction).action == "webapp") {
								webapp.progkeys.data.lstProgKeys["0"][otherProgKey.idKey].position = otherProgKey.position;
							} else if(otherProgKey && webapp.progkeys.data.getActionById(otherProgKey.idAction).action != "webapp") {
								ICTouchAPI.APIServices.ProgrammableKeys.modifyProgrammableKey({params:[otherProgKey], context:webapp.progkeys, callback:webapp.progkeys.errorManager, callbackParams:null});
							}
						}
					}
				} else {
					objProgKey = data.arrProgKeys[0][i];
					if(objProgKey) {
						if((objProgKey.idKey+"").match(regexProgKey)) {
							arrDefaultKeys[i] = "PROGKEYS_"+objProgKey.idKey;
						} else if(objProgKey.idKey.match(regexWebappExt)) {
							elem				= objProgKey.idKey.split('-');
							arrDefaultKeys[i]	= elem[1];
						} else {
							arrDefaultKeys[i] = objProgKey.idKey;
						}
					}
				}
			}
		}

		var len		= arrDefaultKeys.length;
		for(var cpt = len ; cpt < 72; cpt++) {
			objProgKey = data.arrProgKeys[0][cpt];
			if(objProgKey) {
				if((objProgKey.idKey+"").match(regexProgKey)) {
					arrDefaultKeys[cpt] = "PROGKEYS_"+objProgKey.idKey;
				} else if(objProgKey.idKey.match(regexWebappExt)) {
					elem			= objProgKey.idKey.split('-');
					arrDefaultKeys[cpt]	= elem[1];
				} else {
					arrDefaultKeys[cpt] = objProgKey.idKey;
				}
			} else {
				arrDefaultKeys[cpt] = "";
			}
		}

		ICTouchAPI.settingServices.setSettingValue ("HomepageKeys", arrDefaultKeys, this, funcCallBackWebApp);

		arrDefaultKeys	= null;
	},

	resetDM : function(objSetting) {
		if(objSetting && objSetting.value == "true") {
			ICTouchAPI.settingServices.getSettingValue("HomepageDefaultKeys", this, webapp.progkeys.resetFirstPage);
		}
		objSetting	= null;
	},
	
	resetedDbNTF : function() {
		this.data.removeAllProgkeys();
	},
	
	subscribeEvents : function() {
		if(!this._iframeShowHandler) {
			this._iframeShowHandler = dojo.subscribe("iframe.show", this, this.onIframeShow);
	}
		if(!this._comSelectStatusChangeHandler) {
			this._comSelectStatusChangeHandler = dojo.subscribe("CommunicationSelectStatusChange", this, this.onComSelectStatusChange);
		}
	},
	
	unsubscribeEvents : function() {
		if(this._iframeShowHandler) {
			dojo.unsubscribe(this._iframeShowHandler);
			this._iframeShowHandler = null;
		}
		if(this._comSelectStatusChangeHandler) {
			dojo.unsubscribe(this._comSelectStatusChangeHandler);
			this._comSelectStatusChangeHandler = null;
		}
	},
	
	onIframeShow : function(strCurrentFrameId) {
		//Look ony webapp iframe
		if(strCurrentFrameId.match("^webapp")) {						
			if(!strCurrentFrameId.match("webapp.progkeys") && (!this.data.bAllowOtherScreen || !this.data.objProgkeysScreen[strCurrentFrameId])) {
				this.reloadContext();
			}
		}
	},
	
	onComSelectStatusChange : function(objParams) {
		if(objParams.selectStatus === -1) {	
			this.reloadContext(true);
		}
	},
	
	stealthProgkeysScreen : function() {
		ICTouchAPI.transitionServices.stealth("webapp.progkeys.getProgKeys");
		ICTouchAPI.transitionServices.stealth("webapp.progkeys.getProgKeyAdd");
	},
	
});
