dojo.provide("webapp.search.getSearchContentBase");
dojo.declare("webapp.search.getSearchContentBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		_hNewItemsSubscribe : null, // handler of webapp.search.newItems event subscription
		_hEmptyListSubscribe : null, // handler of webapp.search.emptyItems event subscription
		_hManageEmptyStateVisibility : null, // handler of webapp.search.showEmptyState event subscription

		UIDataList : null,
		UIEmptyState : null,
		UILoading : null,

		postCreate:function() {
			var funcLineClick = dojo.hitch(webapp.search, webapp.search.searchLineClick);
			var funcRightIconClick = dojo.hitch(webapp.search, webapp.search.searchRightIconClick);

			this.UIDataList = new UIElements.DataList.DataListControl({
				arrItems: [],
				boolShowAdditionalContents: true,
				lineClickedCallback: funcLineClick,
				iconClickedCallback: funcRightIconClick,
			}, this.domContainer);

			this._hNewItemsSubscribe = dojo.subscribe("webapp.search.newItems",  this, function (items) {
				this.UIDataList.pushItems(items, true);
				items = null;
			});
			this._hEmptyListSubscribe = dojo.subscribe("webapp.search.emptyItems", this, function () {
				this.UIDataList.emptyItems();
				this.UIEmptyState.setVisibility(false);
			});

			// Don't use the EmptyState UI provided by the DataList, use a one defined in search in order to choose when it has to be shown
			// (it should only be displayed when there is no results, not when we don't have started a search yet)
			this.UIEmptyState = new UIElements.EmptyState.EmptyStateControl({
				strEmptyMessage: _("No search results", "webapp.search"),
				boolVisible: false
			}, this.domEmptyState);

			this._hManageEmptyStateVisibility = dojo.subscribe("webapp.search.showEmptyState",  this, function () {
				this.UIEmptyState.setVisibility(true);
			});

		},

		destroy : function(){
			if(this.UIDataList){
				dojo.unsubscribe(this._hNewItemsSubscribe);
				dojo.unsubscribe(this._hEmptyListSubscribe);
				dojo.unsubscribe(this._hManageEmptyStateVisibility);
				this.UIDataList.destroy();
			}
			this.inherited(arguments);
		}
	}
);
