dojo.provide("webapp.search.getSearchBase");
dojo.declare("webapp.search.getSearchBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		container   : null,

		constructor: function() {

			/* For transistionServices; go back to previous application */
			this.stealth();
		},

		postCreate:function() {
			var data = webapp.search.data;
			var am = new UIElements.ApplicationMode.FullControl({
				content : {
					name    : "webapp.search.getSearchContent",
					params  : {}
				},
				objTitle : {
					strLabel: data.getTitle()
				}
			}, this.mainPart);
			this.container = am.getContent();
			webapp.search.mainWidget = this;

			// System buttons
			var _arrSys = data.getAppBarSysButtons();
			for (var i in _arrSys) {
				ICTouchAPI.AppBarServices.addStaticButton("search", "getSearch", _arrSys[i]);
			}

			this._changeBackButton();

			ICTouchAPI.AppBarServices.setAppBar("search", "getSearch", "getSearch");
		},

		_changeBackButton: function() {
			var isPrevious = this.webapp.data.isPreviousHome();
			var backFunc = dojo.hitch(webapp.search, webapp.search.buttonCallback);
			ICTouchAPI.AppBarServices.addExitButton("search", "getSearch", isPrevious, backFunc);
						},

		reloadContainer : function() {
			var data = webapp.search.data;
			this.container.reload({
				objTitle: {
					strLabel: data.getTitle()
				},
				objContent: {
					name: "webapp.search.getSearchContent",
					params: {}
				}
			});
		},

		setContainerTitle : function(strTitle) {
			this.container.getTitle().changeTitle(strTitle);
		},

		destroy : function(){
			this.container.destroy();
			this.inherited(arguments);
		}
	}
	);
