dojo.provide("webapp.search.dataBase");
dojo.declare("webapp.search.dataBase",null,{
	// Member data used for object construction
	_arrAppButtons          : [],
	_arrSysButtons          : [],

	// i18n labels for the container title
	NO_SEARCH				: _("Search", "ICTouchAPI"),
	ONGOING_SEARCH			: _("Search in progress...", "webapp.search"),
	SEARCH_DONE				: _("Search completed", "webapp.search"),

	// Constant values for the button's id
	BACK                    : "BACK_BTN",
	NEW_SEARCH              : "NEW_SEARCH_BTN",
	REFINE_SEARCH           : "REFINE_SEARCH_BTN",

	// Other
	_boolDialpadByDefault		: true,
	_intMinCharacter			: 0,

	constructor : function(){
		var func = dojo.hitch( webapp.search, webapp.search.buttonCallback);
		//this._arrAppButtons[this.NEW_SEARCH] = {strButtonName: this.NEW_SEARCH, strButtonLabel: _('New', 'ICTouchAPI'), strButtonIcon: 'generic-search-by-name', callback: func};
		this._arrAppButtons[this.REFINE_SEARCH] = {strButtonName: this.REFINE_SEARCH, strButtonLabel: _('Search', 'ICTouchAPI'), strButtonIcon: 'generic-search-by-name', callback: func};

		// Register action bars in AppBarServices for child widgets
		var appBar = ICTouchAPI.AppBarServices.getAppBar("search", "getSearch");
		for (var k in this._arrAppButtons) {
			var objButton = new UIElements.AppButton.AppButtonControl(this._arrAppButtons[k]);
			this._arrAppButtons[k].objAppButton = objButton;
			appBar.addActionButton(objButton);
		}
	},

	getAppBarSysButtons : function() {
		return this._arrSysButtons;
	},

	getAppBarAppButtons : function() {
		return this._arrAppButtons;
	},

	getTitle : function() {
		//Returns default title for no ongoing search
		return this.NO_SEARCH;
	},

	isPreviousHome : function() {
		if (webapp.search.clbkBackButton && typeof webapp.search.clbkBackButton === "function")
			return false;
		else //Default "back" action,
			return true;
	},

	getIntMinCharacter : function() {
		return this._intMinCharacter;
	},

	setIntMinCharacter : function(value) {
		this._intMinCharacter = value;
	}

});
