dojo.provide("webapp.homepage.controlBase");
dojo.declare("webapp.homepage.controlBase",[ICTouchAPI.webApplication],
{

	//Homepage view
	previewControl			: null,
	homepageStandardView	: null,
	homepagePreviewView		: null,
	homepageView			: null,
	homepageEditView		: null,

	constructor : function()
	{
		// register to physicals Keys
		ICTouchAPI.eventServices.subscribeToEvent(this, "SENSKEY_HOME", function(objEvent) {
			/*Go to home page on key press (and not on key release)*/
			if(objEvent.value){
				this.senskeyHomeCallback();
			}
		});
		dojo.subscribe("OpenHomepage", this, this.openHomepage);                
		dojo.subscribe("iframe.show",this, this.onShow);

		dojo.subscribe("HomepagePreviewModeChange", this, this.previewModeChanged);
	},

	/**
	 * dump function
	 */
	dump : function(boolAdvancedLogs) {
		this.inherited(arguments);
		ICTouchAPI.debugServices.dump("homepage settings :");
		ICTouchAPI.debugServices.dump(" - HomepagePreviewMode (homepagePreviewMode): " + this.data.homepagePreviewMode);
		ICTouchAPI.debugServices.dump(" - HomepagePreviewAutoFill (homepagePreviewAutoFill): " + this.data.homepagePreviewAutoFill);
		ICTouchAPI.debugServices.dump(" - HomepageStandardAutoFill (homepageStandardAutoFill): " + this.data.homepageStandardAutoFill);
		ICTouchAPI.debugServices.dump(" - HomepageProgKeysLocalisation (extProgKeysLocalisation): " + dojo.toJson(this.data.extProgKeysLocalisation));

		if (boolAdvancedLogs) {
			ICTouchAPI.debugServices.dump("homepage internal variables :");
			ICTouchAPI.debugServices.dump(" - _arrKeys: " + this.data._arrKeys);
			ICTouchAPI.debugServices.dump(" - _arrAppKeys: ");
			for (var i in this.data._arrAppKeys) {
				if (this.data._arrAppKeys[i]) {
					ICTouchAPI.debugServices.dump(" -> _arrAppKeys["+i+"]: strButtonName = '" + this.data._arrAppKeys[i].strButtonName + "', strButtonIcon = '" + this.data._arrAppKeys[i].strButtonIcon + "', strButtonLabel = '" + ((typeof this.data._arrAppKeys[i].strButtonLabel === "string") ? this.data._arrAppKeys[i].strButtonLabel : ((typeof this.data._arrAppKeys[i].strButtonLabel === "object" && this.data._arrAppKeys[i].strButtonLabel && this.data._arrAppKeys[i].strButtonLabel.isI18Ned) ? this.data._arrAppKeys[i].strButtonLabel.getTranslation() : "")) + "'");
				}
				else {
					ICTouchAPI.debugServices.dump(" -> _arrAppKeys["+i+"] is not defined");
				}
			}
			ICTouchAPI.debugServices.dump(" - _arrButtons: " + this.data._arrButtons);
			ICTouchAPI.debugServices.dump(" - _arrAppButtons: ");
			for (var i in this.data._arrAppButtons) {
				if (this.data._arrAppButtons[i]) {
					ICTouchAPI.debugServices.dump(" -> _arrAppButtons["+i+"]: strButtonName = '" + this.data._arrAppButtons[i].strButtonName + "', progkey = " + this.data._arrAppButtons[i].progkey + ", strButtonIcon = '" + this.data._arrAppButtons[i].strButtonIcon + "', strButtonLabel = '" + ((typeof this.data._arrAppButtons[i].strButtonLabel === "string") ? this.data._arrAppButtons[i].strButtonLabel : ((typeof this.data._arrAppButtons[i].strButtonLabel === "object" && this.data._arrAppButtons[i].strButtonLabel && this.data._arrAppButtons[i].strButtonLabel.isI18Ned) ? this.data._arrAppButtons[i].strButtonLabel.getTranslation() : "")) + "'");
				}
				else {
					ICTouchAPI.debugServices.dump(" -> _arrAppButtons["+i+"] is not defined");
				}
			}
			ICTouchAPI.debugServices.dump(" - _arrPreviews: " + this.data._arrPreviews);
			ICTouchAPI.debugServices.dump(" - _arrAppPreviews: ");
			for (var i in this.data._arrAppPreviews) {
				if (this.data._arrAppPreviews[i]) {
					ICTouchAPI.debugServices.dump(" -> _arrAppPreviews["+i+"]: strWebapp = '" + this.data._arrAppPreviews[i].strWebapp + "'");
				}
				else {
					ICTouchAPI.debugServices.dump(" -> _arrAppPreviews["+i+"] is not defined");
				}
			}
		}
	},

	doSubscriptions : function(){
		if(!this.data.boolSubscriptionDone){
			this.data.boolSubscriptionDone = true;
			/*
			 * Another build of the Homepage. Used to be sure that the homepage is never launch after a webapp and to respect the button's order setting HomepageButtons
			 */
			//Buttons
			dojo.subscribe("HomepageRegisterButton",this,function(strWebapp, strButtonName, strButtonIcon, strLabel, strStatusIcon, callBack, position, arrCapabilities){
				this.registerButton(strWebapp, strButtonName, strButtonIcon, strLabel, strStatusIcon,  callBack, position, arrCapabilities);
			});

		    dojo.subscribe("HomepageUnregisterButton",this,function(strButtonName){
					this.unregisterButton(strButtonName);
			});

			//Preview containers
		dojo.subscribe("HomepageRegisterPreviewContainer",this, this.registerPreviewContainer);

		dojo.subscribe("HomepageUnregisterPreviewContainer",this, this.unregisterPreviewContainer);

			//Standard homepage buttons
			dojo.subscribe("HomepageRegisterKey",this,function(strWebapp, strButtonName, strButtonIcon, strLabel, strStatusIcon, callBack, position, callbackLong){
				this.registerKey(strWebapp, strButtonName, strButtonIcon, strLabel, strStatusIcon, callBack, position, callbackLong);
			});

			dojo.subscribe("HomepageUnregisterKey",this,function(strButtonName, boolForceDeleteKey){
				this.unregisterKey(strButtonName, boolForceDeleteKey);
			});

			dojo.subscribe("HomepageUnregisterAwapKey",this,function(strButtonName){
				this.unregisterAwapKey(strButtonName);
			});

			//change homepage status
			dojo.subscribe("HomepageChangeStatusIcon",this,function(strButtonName, strStatusIcon) {
				this.changeStatusIcon(strButtonName, strStatusIcon);
			});

			// Subscribe to a header modification
			dojo.subscribe("AddCSSInHeader", this, this.addCSSToHeader);
			dojo.subscribe("RemoveCSSInHeader", this, this.removeCSSFromHeader);
		}
	},

	/**
	 * Create all rules for apps button
	 * @param {Object}	app	The application manifest content
	 * @param {string}	url	The URL of the server to get the resource icon
	 */
	addCSSToHeader : function(app, url) {
		ICTouchAPI.debugServices.debug("webapp.homepage.controlBase / addCssToHeader() for app: " + app.name);

		var appName		= app.widget.path.split('.');
		var strAppName	= appName[0];
		var frame		= window.frames["webapp.homepage.getHomepage"];

		// Create a new CSS rule
		ICTouchAPI.skinServices.addCssRuleToFrame(frame, app.prefix + app.id + "-64", "background-image: url('" + url + "/" + strAppName + "/themes/Default/images/" + strAppName + "-application-64.png');");
		ICTouchAPI.skinServices.addCssRuleToFrame(frame, app.prefix + app.id + "-64:active", "background-image: url('" + url + "/" + strAppName + "/themes/Default/images/" + strAppName + "-application-64.active.png');");
		ICTouchAPI.skinServices.addCssRuleToFrame(frame, app.prefix + app.id + "-64.active", "background-image: url('" + url + "/" + strAppName + "/themes/Default/images/" + strAppName + "-application-64.active.png');");
		ICTouchAPI.skinServices.addCssRuleToFrame(frame, app.prefix + app.id + "-64.disabled", "background-image: url('" + url + "/" + strAppName + "/themes/Default/images/" + strAppName + "-application-64.disabled.png');");
	},

	/**
	 * Remove all rules for apps button
	 */
	removeCSSFromHeader : function(app) {
		var frame = window.frames["webapp.homepage.getHomepage"];

		ICTouchAPI.skinServices.removeCssRuleToFrame(frame,app.prefix + app.id + "-64");
		ICTouchAPI.skinServices.removeCssRuleToFrame(frame,app.prefix + app.id + "-64:active");
		ICTouchAPI.skinServices.removeCssRuleToFrame(frame,app.prefix + app.id + "-64.active");
		ICTouchAPI.skinServices.removeCssRuleToFrame(frame,app.prefix + app.id + "-64.disabled");
	},

	loaded : function(){
		//Load the previews list, and buttons list from settings
		this.data.loadPreviewsList();
		this.data.loadAppButtonsList();
		this.data.loadAppKeysList();
	},

	openHomepage : function(objEvent) {
		if(!webapp.lock|| !webapp.lock.isLocked()){
			if(objEvent && objEvent.boolPreview){
				this.previewModeChanged(true);
			}
			// show webapp homepage
			ICTouchAPI.transitionServices.getScreen({
				name: "webapp.homepage.getHomepage",
				sync: (objEvent && objEvent.sync),
				params: {}
			});
		}
	},

	senskeyHomeCallback : function() {
		if(ICTouchAPI.transitionServices.getCurrentScreenName() == "webapp.homepage.getHomepage"){
			// If we were on homepage preview, switch to standard
			if(this.data.homepagePreviewMode){
				this.previewModeChanged(false);
			}
			// If we were on homepage standard, scroll to first page
			else {
				dojo.publish("homepageStandard/changePage", [1])
			}
		}
		else {
			this.openHomepage(null);
		}
	},

	registerPreviewContainer : function(strWebapp, objWebapp) {
		var containerExist = false;
		for(var i=0; i<webapp.homepage.data._arrAppPreviews.length && !containerExist; i++){
			if (webapp.homepage.data._arrAppPreviews[i] != null) {
				if(strWebapp === webapp.homepage.data._arrAppPreviews[i].strWebapp) {
					containerExist = true;
				}
		}
		}
		if( !containerExist ) {
			var frag = document.createDocumentFragment();
			var div = dojo.create("div", { }, frag);
			var itemFind = false;

			for(var j=0; j<webapp.homepage.data._arrPreviews.length && !itemFind; j++){
				if (strWebapp === webapp.homepage.data._arrPreviews[j]) {
					itemFind=true;
					webapp.homepage.data._arrAppPreviews[j] = {strWebapp: strWebapp, objWebapp: objWebapp};
					if(this.homepagePreviewView) {
						this.homepagePreviewView.updatePreviewsList();
					}
					return div;
				}
			}
			if(!itemFind){
				webapp.homepage.data._arrAppPreviews.push({strWebapp: strWebapp, objWebapp: objWebapp});
				if(this.homepagePreviewView) {
					this.homepagePreviewView.updatePreviewsList();
				}
				return div;
			}
		}
		return null;
	},


	unregisterPreviewContainer : function(strWebapp) {
		var data = webapp.homepage.data;
		var ind = data.searchArrAppPreview(strWebapp);
		if (ind!=null) {
			data._arrAppPreviews.splice(ind, 1, null);
			if (this.homepagePreviewView) {
				//this.homepagePreviewView.destroyPreview(ind);
				this.homepagePreviewView.updatePreviewsList();
			}
		}
	},

	registerButton : function(strWebapp, strButtonName, strButtonIcon, strLabel, strStatusIcon, callBack, position, arrCapabilities, progkey)
	{
		//this.data.addWebappIcon(strWebapp);
		this.data._arrStatus[strButtonName] = strStatusIcon;
		var reload = true;
		if(!arrCapabilities) {
			arrCapabilities = [];
		}
		var button = {};
		if(progkey!==true) {
			progkey = false;
		}
		button = {
			strButtonName: strButtonName,
			strButtonLabel: strLabel,
			callback : callBack,
			strButtonIcon: strButtonIcon,
			strStatusIcon: strStatusIcon,
			arrCapabilities: arrCapabilities,
			progkey: progkey
		};
		var itemFind = false;

		for(var j=0; j<webapp.homepage.data._arrButtons.length && !itemFind; j++){
			if (strButtonName === webapp.homepage.data._arrButtons[j]) {
				//AJOUT a la position
				webapp.homepage.data._arrAppButtons[j]=button;
				itemFind=true;
				break;
			}
		}
		if(!itemFind){
			//Ajout en fin de l'appbar'
			webapp.homepage.data._arrAppButtons.push(button);
			if(this.data.homepagePreviewAutoFill===true) {
			//Ajout en fin du setting
			webapp.homepage.data._arrButtons.push(button.strButtonName);
			reload = false;
				this.data.intButtonsSettingSemaphore++;
				ICTouchAPI.settingServices.setSettingValue("HomepageButtons", this.data._arrButtons,this);
		}
		}
		// If AppBar has already been loaded then it needs to be reloaded
		if(reload===true) {
			dojo.publish("homepage/appButtonListUpdated");
		}
	},

        unregisterButton : function(strButtonName)
        {
                var j;
                var itemFind1 = false;
                var itemFind2 = false;


                for(j=0; j<webapp.homepage.data._arrButtons.length && !itemFind1; j++){
                        if (strButtonName === webapp.homepage.data._arrButtons[j]) {
                                // remove it from array
                                itemFind1=true;
                                break;
                        }
                }
                for(j=0; j<webapp.homepage.data._arrAppButtons.length && !itemFind2; j++){
                        if (webapp.homepage.data._arrAppButtons[j] &&
                            strButtonName === webapp.homepage.data._arrAppButtons[j].strButtonName) {
                                // remove it from array
                                // the AppButton UIElement is detroyed when the AppBar is updated
								webapp.homepage.data._arrAppButtons[j] = null;
                                itemFind2=true;
                                break;
                        }
                }

                if(itemFind1 || itemFind2){
                        if(this.data._arrStatus.splice[strButtonName]){
                            delete this.data._arrStatus.splice[strButtonName];
                        }
                         // If AppBar has already been loaded then it needs to be reloaded
                         dojo.publish("homepage/appButtonListUpdated");
                }
        },

	registerKey : function(strWebapp, strButtonName, strButtonIcon, strLabelId, strStatusIcon, callBack, position, callbackLong, boolMoveable)
	{
		ICTouchAPI.debugServices.debug("webapp.homepage.controlBase - registerKey / register view: " + strWebapp + ", strButtonName: " + strButtonName + ", strButtonIcon: " + strButtonIcon + ", strLabelId: " + strLabelId);
		//this.data.addWebappIcon(strWebapp);
		this.data._arrStatus[strButtonName] = strStatusIcon;
		var reload = true;
		var button = {};
		
		var strLabel = this.data.getButtonDMLabel(strLabelId);

		var boolIsMoveable	= (boolMoveable != "undefined" && boolMoveable != null) ? boolMoveable : true;

			button = {
			strButtonName: strButtonName,
			strButtonLabel: strLabel,
			callback : callBack,
			strButtonIcon: strButtonIcon,
			strStatusIcon: strStatusIcon,
			_boolMoveable: boolIsMoveable
		};
		
		if(callbackLong) {
			button.callbackLong = callbackLong;
		}

		// save strLabelId if it is not a i18n object to save the reference to the english id in the DM translations
		if (!strLabel.isI18Ned) {
			button.strLabelId = strLabelId;
			ICTouchAPI.debugServices.debug("webapp.homepage.controlBase - registerKey / label is not i18ned, save it to button.strLabelId field: " + button.strLabelId);
		}
		
		var itemFind = false;
		for(var j=0; j<webapp.homepage.data._arrKeys.length && !itemFind; j++){
			if (webapp.homepage.data._arrKeys[j] != null && strButtonName === webapp.homepage.data._arrKeys[j]) {
				//AJOUT a la position
				webapp.homepage.data._arrAppKeys[j]=button;
				itemFind=true;
				break;
			}
		}
		if(!itemFind) {
			if (position && this.data._arrKeys[position]=="") {
				ICTouchAPI.debugServices.debug("webapp.homepage.controlBase - registerKey / position is provided and void: use position " + position);
				itemFind=true;
				webapp.homepage.data._arrKeys[position] = button.strButtonName;
				webapp.homepage.data._arrAppKeys[position] = button;
				reload = false;
				ICTouchAPI.settingServices.setSettingValue("HomepageKeys", webapp.homepage.data._arrKeys,this);
			}
			else if(webapp.homepage.data.homepageStandardAutoFill===true) {
				//Search void place
				var ind = null;
				for(var i=0;i<72 && !itemFind;++i) {
					if (this.data._arrKeys[i]==null || this.data._arrKeys[i]=="") {
						//AJOUT a la position
						ind=i;
						itemFind=true;
						break;
					}
				}
				ICTouchAPI.debugServices.debug("webapp.homepage.controlBase - registerKey / position is not provided, homepageStandardAutoFill is true -> search first void place: use position " + ind);
				webapp.homepage.data._arrKeys[ind] = button.strButtonName;
				webapp.homepage.data._arrAppKeys[ind] = button;
				reload = false;
				ICTouchAPI.settingServices.setSettingValue("HomepageKeys", webapp.homepage.data._arrKeys,this);
			}
			else {
				ICTouchAPI.debugServices.debug("webapp.homepage.controlBase - registerKey / position is not provided, homepageStandardAutoFill is false -> add button at the end: " + webapp.homepage.data._arrAppKeys.length);
				//Ajout en fin du setting
				webapp.homepage.data._arrAppKeys.push(button);
			}
 		}
		if(reload===true) {
			dojo.publish("homepageStandard/reload");
		}
		dojo.publish("progkeys/reload");
	},

   	unregisterKey : function(strButtonName, boolForceDeleteKey) {
		var j;
		var itemFind1 = false;
		var itemFind2 = false;
		
		for(j=0; j<webapp.homepage.data._arrKeys.length && !itemFind1; j++) {
			if (strButtonName === webapp.homepage.data._arrKeys[j]) {
				if(boolForceDeleteKey) {
					webapp.homepage.data._arrKeys[j] = "";
				}
				itemFind1=true;
				break;
			}
		}
		
		for(j=0; j<webapp.homepage.data._arrAppKeys.length && !itemFind2; j++) {
			if (webapp.homepage.data._arrAppKeys[j] &&
				strButtonName === webapp.homepage.data._arrAppKeys[j].strButtonName) {
					webapp.homepage.data._arrAppKeys[j] = null;
					itemFind2=true;
					break;
			}
		}
		
		if(itemFind1 || itemFind2) {
			if(this.data._arrStatus.splice[strButtonName]) {
				delete this.data._arrStatus.splice[strButtonName];
			}
			if(boolForceDeleteKey) {
				ICTouchAPI.settingServices.setSettingValue("HomepageKeys", webapp.homepage.data._arrKeys,this);
			}
			 // If AppBar has already been loaded then it needs to be reloaded
			 dojo.publish("homepageStandard/reload");
		}
		dojo.publish("progkeys/reload");
	},

	changeStatusIcon : function(strButtonName, strStatusIcon) {
		var indStandard=null, indPreview=null;
		var i, iMax
		//search  homepage preview item
		iMax=this.data._arrAppButtons.length;
		for(i=0; i<iMax && indPreview==null; i++){
			if (this.data._arrAppButtons[i]!=null && strButtonName===this.data._arrAppButtons[i].strButtonName) {
				indPreview=i;
				break;
			}
		}
		if(indPreview!=null) {
			this.data._arrAppButtons[indPreview].strStatusIcon = strStatusIcon;
		}
		//search  homepage standard item
		iMax=this.data._arrAppKeys.length;
		for(i=0; i<iMax && indStandard==null; i++){
			if (this.data._arrAppKeys[i]!=null && strButtonName===this.data._arrAppKeys[i].strButtonName) {
				indStandard=i;
				break;
			}
		}
		if(indStandard!=null) {
			this.data._arrAppKeys[indStandard].strStatusIcon = strStatusIcon;
		}
		//Change button status if exist
		if (this.data.homepagePreviewMode === true) {
			var appBarHomepage = ICTouchAPI.AppBarServices.getAppBar("homepage", "getHomepage");
			var objBtn = appBarHomepage.getButton(strButtonName);
			if(objBtn!=null) {
				objBtn.setStatusIcon(strStatusIcon);
			}
		}
		else {
			if(indStandard!=null && this.homepageStandardView && this.homepageStandardView.arrObjKeys[indStandard]!=null) {
				this.homepageStandardView.arrObjKeys[indStandard].setStatusIcon(strStatusIcon);
				}
			}
		this.data._arrStatus[strButtonName] = strStatusIcon;
	},

	/**
	 * Callback
	 * When an iframe become visible (homepage)
	 */
	onShow : function(id) {
		if( id == "webapp.homepage.getHomepage" && !webapp.homepage.data.homepagePreviewMode) {
			dojo.addClass(document.getElementById(id), "slideHomepageStandard");
		}
		id = null;
	},

	unlock : function(){
		dojo.publish("unlockTransition",[true]);
		dojo.removeClass(document.getElementById("webapp.homepage.getHomepage"), "slideHomepageStandard");
	},

	previewModeChanged : function(param) {
		ICTouchAPI.debugServices.info("webapp.homepage.controlBase - previewModeChanged / begin");

		var value;
		if(param.jsValue!=undefined) {
			value = param.jsValue;
		}
		else {
			value = param;
		}

		ICTouchAPI.debugServices.debug("webapp.homepage.controlBase - previewModeChanged / param : " + (value) ? "Preview" : "Standard");

		if (value !== webapp.homepage.data.homepagePreviewMode) {
			webapp.homepage.data.homepagePreviewMode = value;
			
			if(webapp.homepage.homepageView){
				webapp.homepage.homepageView.loadHomepage(value);
			}
		}

		ICTouchAPI.debugServices.info("webapp.homepage.controlBase - previewModeChanged / end");
	}
});
dojo.require("webapp.homepage.controlBase");
dojo.provide("webapp.homepage");
dojo.declare("webapp.homepage",webapp.homepage.controlBase,
{

	constructor : function()
	{
		ICTouchAPI.tools.onLoadedWebapp("webapp.settings", this, this.overrideSetting);
	},

	overrideSetting : function()
	{
		var that = this;
		var func = function() { that.enableEditMode() };
		webapp.settings.overrideSetting("HomepageEditMode",func);
	},

	/*
	 * Enable the edition mode for the homepage : Enable Drag and Drop for previews containers and appbar.
	 */
	enableEditMode: function(){
		ICTouchAPI.transitionServices.getScreen({name : "webapp.progkeys.getProgKeys", params : {}});
	},
	/*
	 * Disable edition mode for the homepage : Disable Drag and Drop for previews containers and appbar.
	 * Save new positions in settings.
	 */
	disableEditMode: function(){
		dojo.publish("homepage/normalMode");
	},



	callbackButtonEdit : function(buttonId) {
		var data = webapp.homepage.data;
		switch(buttonId) {
			case "ADD_BTN":
				//Search an empty case
				var emptyCase = false;
				for(var i = 0; (i < 72) && (emptyCase === false); i++) {
					if(data._arrKeys[i] == null || data._arrKeys[i] === "") {
						emptyCase = true;
						break;
					}
				}
				if(emptyCase === true) {
					if(webapp.progkeys) {
						var that = this;
						var backAddCallback = function() { that.backAddCallback() };
						var endAddCallback = function(editedProgKey,editedAction) { that.endAddCallback(editedProgKey,editedAction) };
						webapp.progkeys.addProgkey({backAddCallback:backAddCallback, endAddCallback:endAddCallback, progkeysWebapp:false})
					}
					else {
						ICTouchAPI.popupServices.errorPopup(_("Error", "ICTouchAPI"), _("Missing ProgKeys webapp", "webapp.homepage"), _("Ok", "ICTouchAPI"));
					}
				} else {
					ICTouchAPI.popupServices.errorPopup(_("Error", "webapp.homepage"), _("Can't add more than 72 buttons", "webapp.homepage"), _("Ok", "webapp.homepage"));
				}
				break;
			case "DELETE_BTN":
				var deleteBtn = webapp.settings.getActionBar().getButton("DELETE_BTN");
				if(this.data.boolDeleteKey==false) {
					deleteBtn.setStatusIcon("notif-on");
					this.data.boolDeleteKey = true;
				}
				else {
					deleteBtn.setStatusIcon("notif-off");
					this.data.boolDeleteKey = false;
				}
				break;
			}
	},

	progkeySelected : function(id) {
		//search a id
		var idFound=false;
		for(var i in this.data._arrProgKeys) {
			if (this.data._arrProgKeys[i].id === id) {
				idFound = true;
				break;
			}
		}
		if(idFound) {
			var currentKey = this.data._arrProgKeys[i];
			webapp[currentKey.webAppName].onProgKeyClick(currentKey);
		}
	},

	callbackMenuEdit : function(buttonId) {
		if(this.data.boolDeleteKey==true) {
			var dPopup;
			var that = this;
			var popupData = {
				strTitle: _("Delete homepage key?","webapp.homepage"),
				strType: "warning",
				strContent: _("Do you really want to delete this homepage key?","webapp.homepage"),
				arrPopupButtons: [
				{
					strButtonLabel: _('OK', "ICTouchAPI"),
					callback : function(){
						that.deleteKey(buttonId, dPopup);
					}
				},
				{
					strButtonLabel: _('Cancel',"ICTouchAPI"),
					callback : function(){ICTouchAPI.popupServices.removePopup(dPopup)}
				}
			]
			}
			dPopup = ICTouchAPI.popupServices.addNewPopup(popupData);
		}
	},

	deleteKey : function(buttonId, dPopup) {
		var ind;
		ind = this.data.searchArrKeys(buttonId);
		this.data._arrKeys[ind] = "";
		this.data._arrAppKeys[ind] = null;
		ind = this.data.searchArrProgKeys(buttonId);
		this.data._arrProgKeys.splice(ind, 1);
		this.data.saveKeys();
		ICTouchAPI.popupServices.removePopup(dPopup);
	},



	backAddCallback : function() {
		ICTouchAPI.transitionServices.getScreen({
			name : 'webapp.settings.getSettings',
			params : {}
		});
	},

	endAddCallback : function(editedProgKey, editedAction) {
			webapp.homepage.data.SaveProgkeys(editedProgKey, editedAction);
			webapp.homepage.data.saveKeys();
			ICTouchAPI.transitionServices.getScreen({
				name : 'webapp.settings.getSettings',
				params : {}
			});
	}
});
webapp.homepage=new webapp.homepage();
dojo.provide("webapp.homepage.dataBase");
dojo.declare("webapp.homepage.dataBase",null,{


	homepagePreviewMode			: null,		//Preview or standard mode?
	homepagePreviewAutoFill		: true,
	homepageStandardAutoFill	: true,
    // Member data used for object construction
	_arrButtons				: [],
    _arrAppButtons          : [],
	// Order of keys, contains strings with idKeys. reflect of setting HomepageKeys.
	_arrKeys				: [],
	// Contains objects corresponding to idKeys from _arrKeys.
	_arrAppKeys				: [],
	// Contain DM progkeys from setting HomepageProgKeys
	_arrProgKeys			: [],
	_arrStatus				: [],
	_arrPreviews            : [],
    _arrAppPreviews         : [],
	_arrSubscribe			: [],
	boolSubscriptionDone	: false,
	buttonsComplete			: false,
	keysComplete			: false,
	progKeysComplete		: false,
	//Standard homepage button type contante
	WEBAPP					: 1,
	PROGKEYS				: 2,
        //LED
        //homeLed : null,
	// translated labels for homepage icons
	extProgKeysLocalisation : [],
	_loadedSkin				: [],
	//Semaphore for Buttons list setting
	intButtonsSettingSemaphore		: 0,

    constructor : function(){
                //this.homeLed = ICTouchAPI.feedbackServices.senskeyServices.getLED('home');
                //this.homeLed.setDelay(0,0,500);
                /*this.homeLed.addMode('STANDBY',dojo.hitch(this,function(){
                        this.homeLed.setColor('green');
                        this.homeLed.switchMode('ON');
                        this.homeLed.setCurrentMode('STANDBY');
                    }
                }));*/
                /*this.homeLed.addMode('SYSERR',dojo.hitch(this,function(){
                        this.homeLed.setColor('red');
                        this.homeLed.switchMode('ON');
                        this.homeLed.setCurrentMode('SYSERR');
                    }
                }));*/
                /*this.homeLed.addMode('ONCLICK',dojo.hitch(this,function(){
                        this.homeLed.setColor('blue');
                        this.homeLed.switchMode('ON');
                        this.homeLed.setCurrentMode('ONCLICK');
                    }
                }));*/
                /*this.homeLed.addMode('OFF_OWNER',dojo.hitch(this,function(){
                        this.homeLed.setColor('blue');
                        this.homeLed.switchMode('OFFTIMER');
                        this.homeLed.setCurrentMode('OFF_OWNER');
                    }
                }));*/
		var h;
		ICTouchAPI.settingServices.getSettingValue("HomepagePreviewMode", this, this._previewModeReceived);
		ICTouchAPI.settingServices.getSettingValue("HomepagePreviewAutoFill", this, this._homepagePreviewAutoFillReceived);
		ICTouchAPI.settingServices.getSettingValue("HomepageStandardAutoFill", this, this._homepageStandardAutoFillReceived);
		// get translated labels if any of the homepage keys HomepageProgKeysLocalisation
		ICTouchAPI.settingServices.getSettingValue("HomepageProgKeysLocalisation", this, this._getHomepageProgKeysLocalisation);
		ICTouchAPI.settingServices.getSettingValue("HomepageShowSwitchButtons", this, this._homepageShowSwitchButtons);
		this._arrAppPreviews = [];
		//this._arrAppPreviews = {};
		this._arrAppButtons = [];

		h = dojo.subscribe("homepage/appButtonListUpdated", this, function() {
				this.loadedButtonComplete();
		});
		this._arrSubscribe.push(h);

		h = dojo.subscribe("homepage/appKeyListUpdated", this, function() {
				this.loadedButtonComplete();
		});
		this._arrSubscribe.push(h);

		h = dojo.subscribe("homepage/appProgKeyListUpdated", this, function() {
				this.loadedButtonComplete();
		});
		this._arrSubscribe.push(h);
	},

	getApplicationName : function() {
		return "homepage";
	},

	_previewModeReceived : function(homepagePreviewMode) {
		if (homepagePreviewMode === false) {
			this.homepagePreviewMode = false;
        } else {
			this.homepagePreviewMode = true;
		}
	},

	_homepagePreviewAutoFillReceived : function(homepagePreviewAutoFill) {
		if (homepagePreviewAutoFill === false) {
			this.homepagePreviewAutoFill = false;
		} else {
			this.homepagePreviewAutoFill = true;
		}
	},

	_homepageStandardAutoFillReceived : function(homepageStandardAutoFill) {
		if (homepageStandardAutoFill === false) {
			this.homepageStandardAutoFill = false;
		} else {
			this.homepageStandardAutoFill = true;
		}
	},

    _getHomepageProgKeysLocalisation : function (value) {
		try {
			if(value){
				this.extProgKeysLocalisation = dojo.fromJson(value);
			}
		} catch(err) {
			//alert("Error in _getHomepageProgKeysLocalisation : "+err.description);
		}
    },

	_homepageShowSwitchButtons : function(value) {
		if(value) {
			var func = function() {				
				webapp.homepage.previewModeChanged(true);
			}
			ICTouchAPI.tools.registerHomepageKey(["webapp.homepage.getHomepage", "HOMEPAGE_PREVIEW_BTN", "generic-homepage2", _('Advanced',"webapp.homepage"), null, func]);
			func = function() {
				webapp.homepage.previewModeChanged(false);
			}
			ICTouchAPI.tools.registerHomepageButton(["webapp.homepage.getHomepage", "HOMEPAGE_STANDARD_BTN", "generic-homepage", _("Home", "ICTouchAPI"), null, func]);
		}
	},

    /**
    * Get the homepage previewsList from the setting "HomepageContainers"
    */
    loadPreviewsList : function(){
        ICTouchAPI.settingServices.getSettingValue("HomepageContainers", this, this.loadedPreviewsList, { });
    },

    /**
    * Callback for SettingsManager (loadPreviewsList) : Register homepage previewsList in data object
    */
    loadedPreviewsList : function(previewsList) {
		var initialPreviewSupervision = ["webapp.supervision.getSupFirstPreview", "webapp.supervision.getSupSecondPreview", "webapp.supervision.getSupThirdPreview"];
		if (previewsList !== undefined && previewsList !== null && previewsList.length && typeof(previewsList) !== "string") {
			this._arrPreviews = initialPreviewSupervision.concat(previewsList);
		} else {
			this._arrPreviews = initialPreviewSupervision.concat([]);
			console.warn("An error occured when trying to load setting HomepageContainers");
		}

		for(var i=0;i<this._arrPreviews.length;++i)
		{
			this._arrAppPreviews.push(null);
		}

		/*dojo.forEach(arrStrPreviews,function(strPreview){
			var objPreview=dojo.fromJson(strPreview);
			this._arrPreviews.push(objPreview);
		}, this);*/
		dojo.publish("homepage/previewsListUpdated");
    },

    getArrPreviews : function () {
        return this._arrAppPreviews;
    },

    getPreview : function (pos) {
        return this._arrAppPreviews[pos];
    },

	/*
	 * Get a list of displayable previews
	 * Constraints :
	 * - no favorite if there is supervision.
	 * - managerassistant always displayed, and in last place.
	 */
	getArrDisplayablePreviews : function() {
		var arrDisplayablePreviews = [];
		var MAPlace = this.searchArrAppPreview('webapp.managerassistant.getManagerPreview');
		var isSupervision = (this.searchArrAppPreview('webapp.supervision.getSupFirstPreview') !== null);
		var intMaxPreview = 3;
		var isMAAdded = false;

		for(var i = 0 ; i < this._arrAppPreviews.length && arrDisplayablePreviews.length < intMaxPreview ; i++){
			if(!this._arrAppPreviews[i] || (this._arrAppPreviews[i].strWebapp == "webapp.contacts.getContactPreview" && isSupervision)){
				continue;
			}
			arrDisplayablePreviews.push(this._arrAppPreviews[i]);
			if(this._arrAppPreviews[i].strWebapp == 'webapp.managerassistant.getManagerPreview'){
				isMAAdded = true;
			}
		}

		if(!isMAAdded && MAPlace !== null){
			arrDisplayablePreviews.splice(intMaxPreview - 1, 1, this._arrAppPreviews[MAPlace]);
		}

		return arrDisplayablePreviews;
	},

    /**
    * Get the homepage appButtonsList from the setting "HomepageButtons"
    */
    loadAppButtonsList : function(){
        ICTouchAPI.settingServices.getSettingValue("HomepageButtons", this, this.loadedAppButtonsListFirst, { });
		this.intButtonsSettingSemaphore = 0;
		ICTouchAPI.settingServices.subscribeToSetting(this,"HomepageButtons", this.loadedAppButtonsList);
    },

	 /**
    * Get the homepage appKeysList from the setting "HomepageButtons"
    */
    loadAppKeysList : function(){
        ICTouchAPI.settingServices.getSettingValue("HomepageKeys", this, this.loadedAppKeysListFirst, { });
        ICTouchAPI.settingServices.getSettingValue("HomepageProgKeys", this, this.loadedAppProgKeysListFirst, { });
		ICTouchAPI.settingServices.subscribeToSetting( this, "HomepageKeys", this.loadedAppKeysList);
		ICTouchAPI.settingServices.subscribeToSetting( this, "HomepageProgKeys", this.loadedAppProgKeysList);
    },

    /**
    * Callback for SettingsManager (loadAppButtonsList): Register homepage buttonsList in data object
    */
    loadedAppButtonsListFirst : function(arrStrAppButtons){
		if (arrStrAppButtons !== undefined && arrStrAppButtons !== null && arrStrAppButtons.length && typeof(arrStrAppButtons) !== "string") {
			this._arrButtons = arrStrAppButtons;
		} else {
			this._arrButtons = [];
			console.warn("An error occured when trying to load setting HomepageButtons");
		}

		for(var i=0;i<this._arrButtons.length;++i)
		{
			this._arrAppButtons.push(null);
		}
		webapp.homepage.doSubscriptions();
		this.buttonsComplete = true;
		dojo.publish("homepage/appButtonListUpdated");
    },

	loadedAppButtonsList : function(objAppButtons) {
		if(this.intButtonsSettingSemaphore > 0) {
			this.intButtonsSettingSemaphore--;
		}
		if(this.intButtonsSettingSemaphore === 0) {
		this._arrButtons = objAppButtons.jsValue;
		var arrAppButtonsTmp = new Array(this._arrButtons.length);
		var arrAppButtonsAddedTmp = [];
		var arrButtonsAddedTmp = [];
		var itemFind;
		for(var j=0; j<this._arrAppButtons.length; j++) {
			itemFind = false;
			for(var i=0;i<this._arrButtons.length && !itemFind;++i) {
				if (this._arrAppButtons[j] != null && this._arrAppButtons[j].strButtonName === this._arrButtons[i]) {
					//AJOUT a la position
					arrAppButtonsTmp[i]=this._arrAppButtons[j];
					itemFind=true;
					break;
				}
			}
			if(!itemFind  && this._arrAppButtons[j] != null && this.searchArrProgKeys(this._arrAppButtons[j].strButtonName)==null) {
				/*arrAppButtonsAddedTmp.push(this._arrAppButtons[j]);
				if (this.homepagePreviewAutoFill) {
				arrButtonsAddedTmp.push(this._arrAppButtons[j].strButtonName);
				}*/
				this._arrAppButtons[j] = null;
		}
		}
		this._arrAppButtons = arrAppButtonsTmp/*.concat(arrAppButtonsAddedTmp)*/;
		//this._arrButtons = this._arrButtons/*.concat(arrButtonsAddedTmp)*/;
		this.addProgkeysInAppbar();
		dojo.publish("homepage/appButtonListUpdated");
		}
	},


	/**
    * Callback for SettingsManager (loadAppKeysList): Register homepage KeysList in data object
    */
    loadedAppKeysListFirst : function(arrStrAppKeys) {
		if (arrStrAppKeys !== undefined && arrStrAppKeys !== null && arrStrAppKeys.length && typeof(arrStrAppKeys) !== "string") {
			this._arrKeys = this.updateOldSettings(arrStrAppKeys);
		} else {
			this._arrKeys = [];
			console.warn("An error occured when trying to load setting HomepageKeys, or there is no HomepageKey");
		}

		for(var i=0;i<this._arrKeys.length;++i)
		{
			this._arrAppKeys.push(null);
		}
		webapp.homepage.doSubscriptions();
		this.keysComplete = true;
		dojo.publish("homepage/appKeyListUpdated");
	},


	/**
    * Callback for SettingsManager (loadAppKeysList): Register homepage KeysList in data object
    */
    loadedAppKeysList : function(arrStrAppKeys) {
		var arrKeysTmp = [];
		if (arrStrAppKeys !== undefined && arrStrAppKeys !== null) {
			if(arrStrAppKeys.length && typeof(arrStrAppKeys) !== "string") {
				arrKeysTmp = this.updateOldSettings(arrStrAppKeys);
			} else if(typeof(arrStrAppKeys.value) == "string") {
				arrKeysTmp = this.updateOldSettings(arrStrAppKeys.value.split(';'));
				}
			}
		this._arrKeys = arrKeysTmp;
		this.sortArrProgKeysList();
		this.addProgkeysInStandardView();
    },


    /**
    * Callback for SettingsManager (loadAppProgKeysList): Register homepage KeysList in data object
    */
    loadedAppProgKeysListFirst : function(arrProgKeys) {
		if (arrProgKeys !== undefined && arrProgKeys !== null && arrProgKeys.length) {
			this._arrProgKeys = dojo.fromJson(arrProgKeys);
		}
		else {
			this._arrProgKeys = [];
			console.warn("An error occured when trying to load setting HomepageProgKeys");
		}
		webapp.homepage.doSubscriptions();
		this.progKeysComplete = true;
		dojo.publish("homepage/appProgKeyListUpdated");
    },


    /**
    * Callback for SettingsManager (loadAppProgKeysList): Register homepage KeysList in data object
    */
    loadedAppProgKeysList : function(arrProgKeys) {
		var arrProgKeysTmp = [];
		if (arrProgKeys !== undefined && arrProgKeys !== null) {
			if(arrProgKeys.length) {
				arrProgKeysTmp = dojo.fromJson(arrProgKeys);
			} else if(arrProgKeys.value.length) {
				arrProgKeysTmp = dojo.fromJson(arrProgKeys.value);
			}
		}
		this._arrProgKeys = arrProgKeysTmp;
		this.addProgkeysInAppbar();
		this.addProgkeysInStandardView();
		this.sortArrProgKeysList();
    },

	sortArrProgKeysList : function() {
		var arrAppKeysTmp = [];
		var arrAppKeysAddedTmp = [];
		var arrKeysAddedTmp = [];
		var itemFind;
		for(var j=0; j<this._arrAppKeys.length; j++) {
			itemFind = false;
			if (this._arrAppKeys[j] != null) {
				for(var i=0;i<this._arrKeys.length && !itemFind;++i) {
					if (this._arrAppKeys[j].strButtonName === this._arrKeys[i]) {
						//AJOUT a la position
						arrAppKeysTmp[i]=this._arrAppKeys[j];
						itemFind=true;
						break;
					}
				}
				if(!itemFind) {
					arrAppKeysAddedTmp.push(this._arrAppKeys[j]);
					if (this.homepageStandardAutoFill) {
					arrKeysAddedTmp.push(this._arrAppKeys[j].strButtonName);
					}
				}
			}
		}
		this._arrAppKeys = arrAppKeysTmp.concat(arrAppKeysAddedTmp);
		this._arrKeys = this._arrKeys.concat(arrKeysAddedTmp);
		if(webapp.homepage.homepageView) {
			webapp.homepage.homepageView.loadHomepage(this.homepagePreviewMode);
		}
		if(webapp.homepage.homepageEditView) {
			webapp.homepage.homepageEditView.reload();
		}
	},

	loadedButtonComplete : function() {
		if (this.keysComplete && this.progKeysComplete && this.buttonsComplete) {
			// Unsubscribe our events so we don't get called again
			var h;
			while(this._arrSubscribe.length) {
				h = this._arrSubscribe.pop();
				dojo.unsubscribe(h);
			}
			this.addProgkeysInAppbar();
			this.addProgkeysInStandardView();
			dojo.publish("HomepageLoaded");
		}
	},
	
    getAppBarAppButtons : function(){
		return this._arrAppButtons;
    },





	/*
	 * Find buttons with this id and return this position
	 */
	searchArrButtons : function(value) {
		value = value.toString();
		var res = null;
		if (value == null || value === "") {
			return null;
		}
		var idFound = false;
		var iMax = this._arrButtons.length;
		for(var i=0; i<iMax; i++) {
			if (this._arrButtons[i] == value) {
				idFound = true;
				res = i;
				break;
			}
		}
		if (idFound === true) {
			return parseInt(res);
		} else {
			return null;
		}
	},

	/*
	 * Find appButtons with this id and return this position
	 */
	searchArrAppButtons : function(value) {
		value = value.toString();
		var res = null;
		if (value == null || value === "") {
			return null;
		}
		var idFound = false;
		var iMax = this._arrAppButtons.length;
		for(var i=0; i<iMax; i++) {
			if( this._arrAppButtons[i] && this._arrAppButtons[i].strButtonName == value) {
				idFound = true;
				res = i;
				break;
			}
		}
		if (idFound === true) {
			return parseInt(res);
		} else {
			return null;
		}
	},

	/*
	 *	Remove not loaded webapp buttons
	 */
	cleanButtons : function() {
		for(var i=0;i<this._arrAppButtons.length;i++)	{
			if (webapp.homepage.data._arrAppButtons[i] == null) {
				webapp.homepage.data._arrAppButtons.splice(i,1);
				webapp.homepage.data._arrButtons.splice(i,1);
				i--;
			}
		}
	},

	/*
	 *	Move buttons into new positions with there names
	 */
	moveButtons : function(strSrc, strDest) {
		var i, iMax
		var srcAppButton = this.searchArrAppButtons(strSrc);
		var destAppButton = this.searchArrAppButtons(strDest);
			if(srcAppButton > destAppButton) {
					destAppButton++;
			}
			if (srcAppButton !== destAppButton) {
				AppButtonsLength = this._arrAppButtons.length;
				if(destAppButton >= AppButtonsLength) {
					destAppButton = AppButtonsLength-1;
				}
				var srcButton = this.searchArrButtons(strSrc);
				var destButton = this.searchArrButtons(strDest);
				if(srcButton > destButton) {
					destButton++;
				}
				//Save source position
				var tempButtons = this._arrButtons[srcButton];
				var tempAppButtons = this._arrAppButtons[srcAppButton];
				//Delete source position
				this._arrButtons.splice(srcButton, 1);
				this._arrAppButtons.splice(srcAppButton, 1);
				//Move buttons  to the right
				iMax = this._arrButtons.length;
				for (i = iMax - 1; i >= destButton; i--) {
					this._arrButtons[i+1] = this._arrButtons[i];
				}
				iMax = this._arrAppButtons.length;
				for(i = iMax - 1; i >= destButton; i--) {
					this._arrAppButtons[i+1] = this._arrAppButtons[i];
				}
				//Place destination at source position
				this._arrButtons[destButton] = tempButtons;
				this._arrAppButtons[destAppButton] = tempAppButtons;
			}
	},



	/*
	 * Find preview with id and return this position
	 */
	searchArrPreview : function(value) {
		value = value.toString();
		var res = null;
		if (value == null || value === "") {
			return null;
		}
		var idFound = false;
		for(var i in this._arrPreviews) {
			if (this._arrPreviews[i] === value) {
				idFound = true;
				res = i;
				break;
			}
		}
		if (idFound === true) {
			return res;
		} else {
			return null;
		}
	},

	/*
	 * Find preview with id and return this position
	 */
	searchArrAppPreview : function(value) {
		value = value.toString();
		var res = null;
		if (value == null || value === "") {
			return null;
		}
		var idFound = false;
		for(var i in this._arrAppPreviews) {
			if (this._arrAppPreviews[i] && this._arrAppPreviews[i].strWebapp === value) {
				idFound = true;
				res = i;
				break;
			}
		}
		if (idFound === true) {
			return res;
		} else {
			return null;
		}
	},

	movePreview : function(intSrc, intDest) {
		//Save source position
			var tempPreview = this._arrPreviews[intSrc];
			var tempAppPreview = this._arrAppPreviews[intSrc];
			//Delete source position
			this._arrPreviews.splice(intSrc, 1);
			this._arrAppPreviews.splice(intSrc, 1);
			//Move Preview  to the right
			var i, iMax = this._arrPreviews.length;
			for(i = iMax - 1; i >=intDest; i--) {
				this._arrPreviews[i+1] = this._arrPreviews[i];
				this._arrAppPreviews[i+1] = this._arrAppPreviews[i];
			}
			//Place destination at source position
			this._arrPreviews[intDest] = tempPreview;
			this._arrAppPreviews[intDest] = tempAppPreview;
	},


	/* Specific function for settings integrations */

	initForView : function(view) {
	},

	getActionBarAppButtonsFromView : function(view) {
		var func = function(buttonId) {webapp.homepage.callbackButtonEdit(buttonId)};
		var buttons;
		if (view === "webapp.homepage.getHomepageStandardEdit") {
			buttons = [
				{strButtonName: "ADD_BTN", strButtonLabel: _('Add', 'ICTouchAPI'), callback : func, strButtonIcon: 'generic-add'},
				{strButtonName: "DELETE_BTN", strButtonLabel: _('Delete', 'ICTouchAPI'), callback : func, strButtonIcon: 'generic-mode-delete', strStatusIcon:'notif-off'}
				];
		}
		return buttons;
	},

	initAppBarButtons : function(view) {
	},
	
	addWebappIcon : function(strWebapp) {
		var reg = /^[a-zA-Z1-9]+\.[a-zA-Z1-9]+/;
		var res = reg.exec(strWebapp);
		if(res) {
			var webappName = res[0];
			if(!this._loadedSkin[webappName]) {
				//ICTouchAPI.skinServices.linkWebappsStyles("webapp.homepage",webappName,true,false,true,false);
				this._loadedSkin[webappName] = true;
			}
		}
	},
	
	getAppKey : function() {
		return this._arrAppKeys;
	},

	getNbAppKeys : function() {
		var nbAppkeys = 0;
		for (var i in this._arrAppKeys) {
			if (this._arrAppKeys[i] != undefined) {
				++nbAppkeys;
			}
		}
		return nbAppkeys;
	},
	
	updateOldSettings : function(arrStrAppKeys){
		if(arrStrAppKeys != null){
			var found = false;
			for(var i=0;i<arrStrAppKeys.length;i++){
				if(arrStrAppKeys[i] == "COMMUNICATION_BTN") {
					arrStrAppKeys[i] = "HISTORY_BTN";
					found = true;
					break;
				}
			}
			if(found){
				ICTouchAPI.settingServices.setSettingValue("HomepageKeys", arrStrAppKeys,this);
			}
		}
		return arrStrAppKeys;
	}
});
dojo.require("webapp.homepage.dataBase");
dojo.provide("webapp.homepage.data");
dojo.declare("webapp.homepage.data",webapp.homepage.dataBase,{

	boolDeleteKey : false,

	/*
	 * Find key with this id and return this position
	 */
	searchArrKeys : function(value) {
		value = value.toString();
		var res = null;
		if (value == null || value === "") {
			return null;
		}
		var idFound = false;
		for(var i in this._arrKeys) {
			if (this._arrKeys[i] === value) {
				idFound = true;
				res = i;
				break;
			}
		}
		if (idFound === true) {
			return res;
		} else {
			return null;
		}
	},

	/*
	 * Find homepage progKey with this id and return this position
	 */
	searchArrProgKeys : function(value) {
		value = value.toString();
		if (value == null || value === "") {
			return null;
		}
		var idFound = false;
		var res = null;
		for(var i in this._arrProgKeys) {
			if (this._arrProgKeys[i] != null && this._arrProgKeys[i].id === value) {
				idFound = true;
				res = i;
				break;
			}
		}

		if (idFound === true) {
			return res;
		} else {
			return null;
		}
	},

	/*
	 *	Move keys into new positions with there names
	 */
	moveKeys : function(strSrc, strDest) {
		if ((strDest != null && strDest !== "") && (strSrc !== strDest)) {
			if (this._arrKeys[strDest] != null && this._arrKeys[strDest] !== "") {
				//Search if destination is on left or right position of the source
				//var dom = this.domCase[strDest]["case"]; // unused ?
				this.insertKeyToPosition(strSrc, strDest);
			}
			//Action if destination is void
			else {
				this._arrKeys[strDest] = this._arrKeys[strSrc];
				this._arrKeys[strSrc] = "";
				this._arrAppKeys[strDest] = this._arrAppKeys[strSrc];
				this._arrAppKeys[strSrc] = "";
			}
		}
	},


	/*
	 *	insert key into specified position. Move other buttons.
	 */
	insertKeyToPosition : function(strSrc, strDest) {
		var leftRight="l", passe=0, voidPos=null, i;
		var tempKeys, tempAppKeys;
		for(passe=0; passe<=1 && voidPos==null; passe++) {
			//Defaut: move icon to the right
			if (leftRight === "l") {
				for(i = strDest; i < 72; i++) {
					if(i === strSrc || this._arrKeys[i] == null || this._arrKeys[i] === "") {
						voidPos = i;
						break;
					}
				}
				if (voidPos != null) {
					tempKeys = this._arrKeys[strSrc];
					tempAppKeys = this._arrAppKeys[strSrc];
					//Save and Delete source
					this._arrKeys[strSrc] = "";
					this._arrAppKeys[strSrc] = null;
					for(i = voidPos; i > strDest; i--) {
						//Shift buttons in right
						this._arrKeys[i] = this._arrKeys[i-1];
						this._arrAppKeys[i] = this._arrAppKeys[i-1];
					}
					//Move source to strDest
					this._arrKeys[strDest] = tempKeys;
					this._arrAppKeys[strDest] = tempAppKeys;
				}
			}
			//no void postion in the right, move icon to the left
			else {
				for (i = strDest; i >= 0; i--) {
					if (i === strSrc || this._arrKeys[i] == null || this._arrKeys[i] === "") {
						voidPos = i;
						break;
					}
				}
				if (voidPos != null) {
					tempKeys = this._arrKeys[strSrc];
					tempAppKeys = this._arrAppKeys[strSrc];
					//Save and Delete source
					this._arrKeys[strSrc] = "";
					this._arrAppKeys[strSrc] = null;
					for(i = voidPos; i < strDest; i++) {
						//Shift buttons in right
						this._arrKeys[i] = this._arrKeys[i+1];
						this._arrAppKeys[i] = this._arrAppKeys[i+1];
					}
					//Move source to strDest
					this._arrKeys[strDest] = tempKeys;
					this._arrAppKeys[strDest] = tempAppKeys;
				}
			}
			if (voidPos == null) {
				if (leftRight === "l") {
					leftRight = "r";
				} else {
					leftRight = "l";
				}
			}
		}
	},


    //Save keys in prokeys format into homepage Keys
    SaveProgkeys : function(editedProgKeys, editedProgActions) {
		//search a new id
		var newId;
		var stop = false;
		var i;
		for (i = 1; stop === false; i++) {
			if (this.searchArrProgKeys(i) == null) {
				stop = true;
				newId = i;
			}
		}

		//Create key structure
		var key = {};
		key.id = newId.toString();
		key.icon = editedProgKeys.icon;
		key.type = editedProgActions.type;
		key.action = editedProgActions.action;
		key.webAppName = editedProgActions.webAppName;
		key.arguments = editedProgActions.arguments;
		key.label = editedProgActions.label;
		key.shortLabel = editedProgActions.shortLabel;
		//add key into keys liste and save list
		//Search an empty case
		var pos;
		for (i = 0; i < 72; i++) {
			if (this._arrKeys[i] == null || this._arrKeys[i] === "") {
				pos = i;
				break;
			}
		}
		this._arrKeys[pos] = key.id;
		this._arrProgKeys.push(key);
	},


	/*
	 * Save keys in settings database
	 */
	saveKeys : function() {
		var json = dojo.toJson(this._arrProgKeys);
		ICTouchAPI.settingServices.setSettingValue("HomepageProgKeys", json, this);
		ICTouchAPI.settingServices.setSettingValue("HomepageKeys", webapp.homepage.data._arrKeys,this);
	},


	/*
	 * get progkeysList for menuList
	 */
	getProgKeysList : function() {
		var data = webapp.homepage.data;
		var list =[];
		for (var i in data._arrProgKeys) {
			var elem = data._arrProgKeys[i];
			list.push({
				intIndex: elem.id,
				strType: "normal",
				strPrimaryContent: elem.label
				//strPicture: elem.icon,
			});
		}
		return list;
	},

	/*
	 * Add progkeys into appBar on homepage preview
	 */
	addProgkeysInAppbar : function() {
		var iMax = this._arrButtons.length;
		for(var i=0;i<iMax;i++) {
			if(this._arrButtons[i]!=null && this._arrAppButtons[i]==null) {
				var indPK = this.searchArrProgKeys(this._arrButtons[i]);
				if(indPK!=null) {
					var objPK = this._arrProgKeys[indPK];
					var callback = function(param) {webapp.homepage.progkeySelected(param);};
					webapp.homepage.registerButton("webapp."+objPK.webAppName, objPK.id, objPK.icon, _(objPK.label,"webapp.homepage"), null, callback, i, true)
				}
			}
		}
	},

	/*
	 * Add progkeys into aHomepage standard
	 */
	addProgkeysInStandardView : function() {
		var iMax			= this._arrKeys.length;
		var boolMoveable	= true;
		for(var i=0;i<iMax;i++) {
			if(this._arrKeys[i]!=null && this._arrAppKeys[i]==null) {
				var indPK = this.searchArrProgKeys(this._arrKeys[i]);
				if(indPK!=null) {
					var objPK = this._arrProgKeys[indPK];
					var callback = function(param) {
						webapp.homepage.progkeySelected(param);
					};
					if(objPK._boolMoveable != "undefined" && objPK._boolMoveable != null && objPK._boolMoveable == "false") {
						boolMoveable = false;
					}
					webapp.homepage.registerKey("webapp."+objPK.webAppName, objPK.id, objPK.icon, objPK.label, null, callback, i, callback, boolMoveable);
				}
			}
		}
	},

	// get the
	getButtonDMLabel : function (strLabel) {
		ICTouchAPI.debugServices.info("webapp.homepage.data8082 - getButtonDMLabel");
		var strLabelId = "";
		// if the object is already i18ned, return it
		if (strLabel.isI18Ned) {
			strLabelId = strLabel;
			ICTouchAPI.debugServices.debug("webapp.homepage.data8082 - getButtonDMLabel / label is a i18n label, do not check if there is a DM translation");
		}
		else if(this.extProgKeysLocalisation && this.extProgKeysLocalisation["en"] && this.extProgKeysLocalisation["en"][strLabel]){
			strLabelId = this.extProgKeysLocalisation["en"][strLabel];
			ICTouchAPI.debugServices.debug("webapp.homepage.data8082 - getButtonDMLabel / english DM translation is provided for label " + strLabel + ", use it: " + strLabelId);
		}
		else {
			strLabelId = _(strLabel,"webapp.homepage");
			ICTouchAPI.debugServices.debug("webapp.homepage.data8082 - getButtonDMLabel / no english DM translation found for label " + strLabel + ", use i18nObject");
		}
		return strLabelId;
	}

});

webapp.homepage.data = new webapp.homepage.data();
dojo.provide("webapp.homepage.getHomepageBase");
dojo.declare("webapp.homepage.getHomepageBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
    {

		boolCurrentHomepage: null,
		exclusiveIframe: true,

		constructor: function() {

		},

		postCreate:function() {
			webapp.homepage.homepageView = this;			
			this.createHomepages();
			this.loadHomepage(webapp.homepage.data.homepagePreviewMode);
			ICTouchAPI.settingServices.subscribeToSetting(webapp.homepage, "HomepagePreviewMode", webapp.homepage.previewModeChanged);			
		},


		loadHomepage:function(value) {
			if(value!=null) {
				var objAppBar = ICTouchAPI.AppBarServices.getAppBar("homepage", "getHomepage");
				//Load homepage preview
				if (value === true) {
					if(value!==this.currentHomepage) {
						//Reload appBar
						webapp.homepage.homepagePreviewView.updateAppButtonsList();
						//If exist, hide homepage standard
						if (webapp.homepage.homepageStandardView != null) {
							webapp.homepage.homepageStandardView.disableSubscribe();
							dojo.style(webapp.homepage.homepageStandardView.domNode, "display", "none");
						}
						//Reenable sunscribe
						webapp.homepage.homepagePreviewView.enableSubscribe();
						//Show homepage preview and appBar
						dojo.style(webapp.homepage.homepagePreviewView.domNode, "display", "");
						dojo.style(objAppBar.domNode, "display", "");
						this.currentHomepage = true;
						var domHomepage = document.getElementById("webapp.homepage.getHomepage");
						if(domHomepage){
							dojo.removeClass(domHomepage, "slideHomepageStandard");
					}
					}
					else {
						//Reload appBar
						webapp.homepage.homepagePreviewView.updateAppButtonsList();
					}
				}

				//Load homepage standard
				else {
					if(value!==this.currentHomepage) {						
						//Refresh homepage standard
						webapp.homepage.homepageStandardView.reload();
						//If exist, hide homepage preview and disable subscribe
						if (webapp.homepage.homepagePreviewView != null) {
							webapp.homepage.homepagePreviewView.disableSubscribe();
							dojo.style(webapp.homepage.homepagePreviewView.domNode, "display", "none");
						}
						//reenable subscribe
						webapp.homepage.homepageStandardView.enableSubscribe();
						//Show homepage standard
						dojo.style(webapp.homepage.homepageStandardView.domNode, "display", "");
						//Clear appBar
						objAppBar.removeAllActionButtons();
						dojo.style(objAppBar.domNode, "display", "none");
						this.currentHomepage = false;
						var domHomepage = document.getElementById("webapp.homepage.getHomepage");
						if(domHomepage){
							/* z-index change to allow changing page by slide on the bottom of homepage standard */
							dojo.addClass(domHomepage, "slideHomepageStandard");
					}
						
					}
					else {
						//Refresh homepage standard
						webapp.homepage.homepageStandardView.reload();
					}
				}
				//Publish an event in order to refresh buttons with status like wakeup
				dojo.publish("homepage/refreshHomepage");
			}
			else {
				var that=this;
				var func = function () {
					that.loadHomepage(webapp.homepage.data.homepagePreviewMode);
				};
				setTimeout(func, 100);
			}
		},

		createHomepages : function() {
			var	node = dojo.create("div", null, this.domGetHomepage);
			webapp.homepage.homepagePreviewView = new webapp.homepage.getHomepagePreview({}, node);
			node = dojo.create("div", null, this.domGetHomepage);
			webapp.homepage.homepageStandardView = new webapp.homepage.getHomepageStandard({}, node);
		},


    }
    );
dojo.require("webapp.homepage.getHomepageBase");
dojo.provide("webapp.homepage.getHomepage");
dojo.declare("webapp.homepage.getHomepage",
    webapp.homepage.getHomepageBase,
    {
		templatePath: dojo.moduleUrl("webapp.homepage","templates/getHomepage8082.html")

    }
    );dojo.provide("webapp.homepage.getHomepagePreviewBase");
dojo.declare("webapp.homepage.getHomepagePreviewBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		objPreview				: null,
		arrPreviewsWidget		: [],
		objAppBar				: null,
		objStandard				: null,
		arrAppDisplayedPreview	: [],
		previewList				: [],
		/* subscribe */
		_hPreviewsListUpdated	: null,
		_hAppButtonListUpdated	: null,
		_languageChanged		: null,


		constructor: function() {

		},

		postCreate:function() {
			var divNode = dojo.create("div", {}, this.domGetHomepagePreview);
			this.objPreview = webapp.homepage.previewControl = new UIElements.ApplicationMode.PreviewControl(
			{
			},divNode);
			this.updateAppButtonsList();
			this.updatePreviewsList();
		},

		enableSubscribe : function() {
			this._hPreviewsListUpdated = this.subscribe("homepage/previewsListUpdated", this.updatePreviewsList);
			this._hAppButtonListUpdated = this.subscribe("homepage/appButtonListUpdated", this.updateAppButtonsList);
			this._languageChanged = this.subscribe("languageChanged",this.applyDMTranslation);
		},

		disableSubscribe : function() {
			this.unsubscribe(this._hPreviewsListUpdated);
			this.unsubscribe(this._hAppButtonListUpdated);
			this.unsubscribe(this._languageChanged);
		},
			// set webapp homepage css for iframe
			firstLoad : function(frag, strName) {
                    var that = this;
                    var func = function(){
						ICTouchAPI.skinServices.registerHeader(this.contentDocument.head,"webapp."+strName,"webapp",this);
						this.contentDocument.body.appendChild(frag);
                        this.removeEventListener('load', func, false);
						that.previewList = that.getPreviewsList();
                    };
                    return func;
                },

       /**
		 * Register every preview container from data (Used by setting homepage mode)
		 */
		updatePreviewsList : function(){
			var that = this;

			/*
			 * Bufferize the update so we do not make more than one reload during a short time.
			 * It prevents some display problems where previews were doubled, not well destroyed... and so on.
			 */
			if(this._hUpdatePreviewList){
				clearTimeout(this._hUpdatePreviewList);
				this._hUpdatePreviewList = null;
			}
			
			
			this._hUpdatePreviewList = setTimeout(function(){that._updatePreviewsList();},700)
		},

		_updatePreviewsList : function(){
			//this.previewList = this.getPreviewsList();
			//this.destroyPreviewsList();
			var newList = this.webapp.data.getArrDisplayablePreviews();
			var item = null;

			// Remove all previews which are no more present
			for(var i=0 ; i<this.arrAppDisplayedPreview.length ; i++){
				item = this.arrAppDisplayedPreview[i];
				if(item && !this.isInArray(item.strWebapp, newList)){
					this.destroyPreview(i);
					this.arrAppDisplayedPreview.splice(i,1);
					i--;
				}
			}

			// Add new previews
			var funcAdd = function (item, idx) {
				if(item && !this.isInArray(item.strWebapp, this.arrAppDisplayedPreview)){
					var strWebapp = item.strWebapp;
					var frag = document.createDocumentFragment();
					var div = dojo.create("div", { }, frag);
					item.objWebapp.setHomepageContainer(strWebapp, div);
					this.addPreviewToList(frag, idx, strWebapp.split(".")[2], item);
				}
			};
			newList.forEach(funcAdd, this);
		},

		isInArray : function(strWebapp, arrList) {
			for(var i = 0 ; i < arrList.length ; i++){
				if(arrList[i] && arrList[i].strWebapp == strWebapp){
					return true;
				}
			}
			return false;
		},

		addPreviewToList : function(frag, pos, strName, item) {
			this.objPreview.addPreview(frag, pos, this.firstLoad(frag, strName));
			this.arrAppDisplayedPreview.splice(pos, 0, item);
			this.previewList = this.getPreviewsList();
		},

                getPreviewsList : function () {
		  return dojo.query("li.ZonePreview", this.objPreview.domNode);
                },

                destroyPreviewsList : function () {
                    for(var i=0; i<this.previewList.length; i++) {
                            dojo.destroy(this.previewList[i]);
                    }
					this.previewList = this.getPreviewsList();
                },

		destroyPreview : function(idx){
			 if(idx != undefined && idx < this.previewList.length){
				// Destroy content of iframe first
				dojo.query("iframe", this.previewList[idx]).forEach(function(iframe){
					ICTouchAPI.skinServices.unregisterHeader(iframe);
					ICTouchAPI.tools.destroyWidgets(iframe.contentDocument.body);
				})
				// Remove preview from dom
				dojo.destroy(this.previewList[idx]);
			}
			this.previewList = this.getPreviewsList();
		},


		/**
		* Register every app button from data (Used by setting homepage mode)
		*/
		updateAppButtonsList:function(){
			var objAppBar = ICTouchAPI.AppBarServices.getAppBar("homepage", "getHomepage");
			objAppBar.removeAllActionButtons();

			var arrAppButton = webapp.homepage.data.getAppBarAppButtons();
			for(var i in arrAppButton) {
				var newButton = arrAppButton[i];
				if (newButton == null || webapp.homepage.data._arrButtons[i]==null) {
				}
				else {
					if (newButton.callback == null) {
						newButton.callback = function() {
							ICTouchAPI.transitionServices.getScreen({name : newButton.strWidgetAccess, params : {}});
						};
					}
					var objButton = new UIElements.AppButton.AppButtonControl(newButton);
					//Don't remove this if, it's used to bypass a VHE Webkit bug
					if(!objAppBar.getButton(newButton.strButtonName)) {
					objAppBar.addActionButton(objButton);
				}
			}
			}
			this.applyDMTranslation();
		},


		//Change label with DM translation if exist
		applyDMTranslation : function() {
			var i;
			if(this.webapp.data.extProgKeysLocalisation) {
				var currentLocal = ICTouchAPI.i18nServices.getLocale();
				var appBar = ICTouchAPI.AppBarServices.getAppBar("homepage", "getHomepage");
				var appBarButtons = appBar.getAllButtons();
				for(i in this.webapp.data._arrAppButtons) {
					var tmpLabel;
					var button = this.webapp.data._arrAppButtons[i];
					if(button && button.strButtonLabel) {
						if (button.strButtonLabel.isI18Ned){
							tmpLabel = button.strButtonLabel.toTranslate;
						}
						else {
							tmpLabel = button.strButtonLabel;
						}
						if(this.webapp.data.extProgKeysLocalisation[currentLocal]
								&& this.webapp.data.extProgKeysLocalisation[currentLocal][tmpLabel]
								&& appBarButtons[i]!=null){
							var newLabel = this.webapp.data.extProgKeysLocalisation[currentLocal][tmpLabel];
							appBarButtons[i].attr("strButtonLabel", newLabel);
						}
					}
				}
			}
		}


	}
);
dojo.require("webapp.homepage.getHomepagePreviewBase");
dojo.provide("webapp.homepage.getHomepagePreview");
dojo.declare("webapp.homepage.getHomepagePreview",
    webapp.homepage.getHomepagePreviewBase,
    {
	_boolEditable					: false,
	_previewEdition					: null,
	_appBarEdition					: null,
	templatePath: dojo.moduleUrl("webapp.homepage","templates/getHomepagePreview8082.html"),
	/* Subscribe */
	_hEditMode						: null,
	_hNormalMode						: null,
	/* edit mode */
	 _timerEdition					: null,
	_timerEditionDuration			: 10000,
	objTimer						: null,
	/* edit mode appBar */
	_moveableEventsAppBar			: null,
	_moveableElemAppBar				: null,
	_moveableDivAppBar				: null,
	xPosAppBar						: null,
	srcNameAppBar					: null,
	srcPosAppBar					: null,
	srcNodeAppBar					: null,
	domAppBar						: null,
	domAppBarScroll					: null,
	domButtons						: null,
	hideButtons						: null,
	/* edit mode previews */
	_moveableEventsPreviews			: null,
	_moveableElemPreviews			: null,
	_moveableDivPreviews			: null,
	xPosPreviews					: null,
	srcPosPreviews					: null,
	domPreviewContainer				: null,
	domPreview						: null,
	maskDivPreview					: null,


	constructor : function()
    {

		/*for(var j=0;j < webapp.homepage.data._arrAppPreviews.length;j++){
			if (webapp.homepage.data._arrAppPreviews[j] == null) {
				webapp.homepage.data._arrAppPreviews.splice(j,1);
				j--;
			}
		}*/
    },

	enableSubscribe : function() {
		this.inherited(arguments);
		this._hEditMode = dojo.subscribe("homepage/editMode",this,this.makeEditable);
		this._hNormalMode =  dojo.subscribe("homepage/normalMode",this,this.makeUneditable);
	},

	disableSubscribe : function() {
		this.inherited(arguments);
		dojo.unsubscribe(this._hEditMode);
	    dojo.unsubscribe(this._hNormalMode);
	},


	/**
	 * This function is used by "connect" function into loop.
	 **/
	hpStopPropagation : function(e) {
			e.stopPropagation();
	},


//******************************************************************************************************
//*                                         Edit Mode                                                  *
//******************************************************************************************************


	/*
	 * Start timer. Deactivate the edition mode if user is inactive during this._timerEditionDuration(ms)
	 */
	startTimer : function() {
		clearTimeout(this._timerEdition);
		var that = this;
		var func = function () {
			that.makeUneditable();
		};
		this._timerEdition = setTimeout(func, this._timerEditionDuration);
	},
	/*
	 * Stop timer. (User activity)
	 */
	stopTimer : function() {
		clearTimeout(this._timerEdition);
	},

	/*
	 * Homepage edition mode
	 * Start the edition timer (10s of inactivity deactivate edition mode
	 */
	makeEditable : function() {
		var that = this;
		var funcStopTimer = function(){that.stopTimer()} ;
		var funcReloadTimer = function() {that.startTimer()};
		//Object Timer for the homepage.edition objects
		this.objTimer = {
			stop : funcStopTimer,
			start : funcReloadTimer
		};
		this.makeEditableAppBar();
		this.makeEditablePreview();
		this.startTimer();
		//Hide appBar external button
		var otherButtons = ICTouchAPI.AppBarServices.getAppBar("homepage", "getHomepage").arrOtherWebAppButtons;
		this.hideButtons = [];
		var iMax = otherButtons.length;
		for(var i=0; i<iMax; i++) {
			if (dojo.style(otherButtons[i], "display")!=="none" && dojo.style(otherButtons[i], "visibility")!=="hidden") {
				otherButtons[i].hide();
				this.hideButtons.push(otherButtons[i]);
			}
		}
	},

	/*
	 * Reactivate homepage normal mode.
	 */
	makeUneditable : function(reload){
		this.makeUneditableAppBar();
		this.makeUneditablePreview();
		this.objTimer.stop();
		//Reshow hidden other button
		var iMax =this.hideButtons.length;
		for(var i=0; i<iMax; i++) {
			this.hideButtons[i].show();
		}
		this.updateAppButtonsList();
		//Save keys position, reload homepage and return to settings
		if (reload !== true) {
			webapp.homepage.data.cleanButtons();
			ICTouchAPI.settingServices.setSettingValue("HomepageButtons", webapp.homepage.data._arrButtons,this);
			//ICTouchAPI.settingServices.setSettingValue("HomepageContainers", webapp.homepage.data._arrPreviews,this);
			//Display preview
			ICTouchAPI.transitionServices.getScreen({name: "webapp.settings.getSettings", params: {delay: 20}});
		}
	},




	//------------------------------------ Edit Mode for appBar ---------------------------------------

	makeEditableAppBar : function() {
		//Element to destroy at end of edit
		this._moveableDivAppBar = [];
		this._moveableElemAppBar = [];
		this._moveableEventsAppBar = [];
		//Dom
		this.domAppBar = dojo.query(".webappButtons", ICTouchAPI.AppBarServices.getAppBar("homepage", "getHomepage").domNode)[0];
		this.domButtons = dojo.query(">li", ICTouchAPI.AppBarServices.getAppBar("homepage", "getHomepage").domButtons);
		this.domAppBarScroll = ICTouchAPI.AppBarServices.getAppBar("homepage", "getHomepage").domScroll;
		//Event for timer gestion
		var event = dojo.connect(ICTouchAPI.AppBarServices.getAppBar("homepage", "getHomepage").domButtons, "onmousedown", this, this.objTimer.stop());
		this._moveableEventsAppBar.push(event);
		event = dojo.connect(ICTouchAPI.AppBarServices.getAppBar("homepage", "getHomepage").domButtons, "onmouseup", this, this.objTimer.start());
		this._moveableEventsAppBar.push(event);
		ICTouchAPI.AppBarServices.getAppBar("homepage", "getHomepage").domNode.addEventListener("mousedown",this.eventMouseDownAppBar, true);

		//Create mask div on displayed buttons and add moveable div in front
		for (var i=0; i<this.domButtons.length; i++) {
			if (dojo.style(this.domButtons[i], "display")!=="none" && dojo.style(this.domButtons[i], "visibility")!=="hidden") {
				var elt = dojo.create("div", {});
				elt.setAttribute("buttonname", this.domButtons[i].getAttribute("buttonname"));
				elt.setAttribute("position", i);
				dojo.place(elt, this.domButtons[i], "after");
				this._moveableDivAppBar.push(elt);
				elt.style.position="absolute";
				elt.style.height=this.domButtons[i].offsetHeight+"px";
				elt.style.width=this.domButtons[i].offsetWidth+"px";
				elt.style.left=this.domButtons[i].offsetLeft+"px";
				elt.style.top=this.domButtons[i].offsetTop+"px";
				elt.style.zIndex="100";
				dojo.style(elt, "z-index", "50");
				dojo.addClass(elt, "handler");

				this._moveableEventsAppBar.push(event);
				event = dojo.connect(elt,"onclick", this, this.hpStopPropagation);
				this._moveableEventsAppBar.push(event);
				var moveable = new dojo.dnd.Moveable(elt, {delay: 2 , handle: elt});
				this._moveableElemAppBar.push(moveable);
				event = dojo.connect(moveable, "onDragDetected", this, this.eventDragStartAppBar);
				this._moveableEventsAppBar.push(event);
				event = dojo.connect(moveable, "onMoving", this, this.eventMovingAppBar);
				this._moveableEventsAppBar.push(event);
				event = dojo.connect(moveable, "onMoved", this, this.eventMovedAppBar);
				this._moveableEventsAppBar.push(event);
				event = dojo.connect(moveable, "onMoveStop", this, this.eventStopMoveAppBar);
				this._moveableEventsAppBar.push(event);
			}
		}
		this.startTimer();
	},

	makeUneditableAppBar : function() {
		ICTouchAPI.AppBarServices.getAppBar("homepage", "getHomepage").domNode.removeEventListener("mousedown", this.eventMouseDownAppBar, true);
		var i;
		var IctScroll = ICTouchAPI.AppBarServices.getAppBar("homepage", "getHomepage").domScroll.IctScroll;
		IctScroll.setDisableScroll(false);
		this.objTimer.stop();
		//destroy data of dnd.move and events
		for(i in this._moveableEventsAppBar) {
			dojo.disconnect(this._moveableEventsAppBar[i]);
		}
		for(i in this._moveableElemAppBar) {
			this._moveableElemAppBar[i].destroy();
		}
		for(i in this._moveableDivAppBar) {
			dojo.destroy(this._moveableDivAppBar[i]);
		}
		this._moveableElemAppBar = null;
		this._moveableEventsAppBar = null;
		this.updateAppButtonsList();
	},


	eventMouseDownAppBar : function(ev) {
		//Disable Scroll if target element is DND handler
		if(dojo.hasClass(ev.target, "handler")) {
			var IctScroll = ICTouchAPI.AppBarServices.getAppBar("homepage", "getHomepage").domScroll.IctScroll;
			IctScroll.setDisableScroll(true);
		}
	},

	eventDragStartAppBar : function(ev) {
		this.objTimer.stop();
		ev.stopPropagation();
		var node = ev.target;
		//Store this source node
		this.srcNodeAppBar = node;
		dojo.style(node, "z-index", "200");
		this.srcNameAppBar = node.getAttribute("buttonname");
		//Hide original button and display button content on this div
		var buttonDom = this.domButtons[node.getAttribute("position")];
		node.innerHTML = buttonDom.outerHTML;
		dojo.style(buttonDom, "visibility", "hidden");
		//Add event when we leave appBar area
		var event = dojo.connect(this.domAppBar, "onmouseleave", this, this.eventMouseLeaveAppBar);
		this._moveableEventsAppBar.push(event);
	},


	eventMovingAppBar : function(ev, ev2) {
		ev2.t = 0;
	},

	eventMovedAppBar : function(ev, ev2) {
		this.xPosAppBar = ev2.l + this.domAppBarScroll.scrollLeft;
	},

	eventMouseLeaveAppBar : function(ev) {
		this.makeUneditableAppBar();
		this.makeEditableAppBar();
	},

	eventStopMoveAppBar : function (ev) {
		//re-enable scroll
		var appBar = ICTouchAPI.AppBarServices.getAppBar("homepage", "getHomepage");
		var IctScroll = appBar.domScroll.IctScroll;
		IctScroll.setDisableScroll(false);
		//search destination
		var dropPosition = this.searchCaseAppBar();
		if(dropPosition!=null && dropPosition!=="") {
			var dropName = this.domButtons[dropPosition].getAttribute("buttonname");
			webapp.homepage.data.moveButtons(this.srcNameAppBar, dropName);
		}
		//Reload appbar
		this.makeUneditableAppBar();
		this.makeEditableAppBar();
	},

	searchCaseAppBar : function() {
		var res = 0;
		var i;
		var x = this.xPosAppBar - this.domAppBarScroll.scrollLeft;
		//Compare actual position with buttons positions
		for(i = 0; i <= this.domButtons.length - 1; i++) {
			if (dojo.style(this.domButtons[i], "display")!=="none" && dojo.style(this.domButtons[i], "visibility")!=="hidden"
				&& this.srcNameAppBar!==this.domButtons[i].getAttribute("buttonname") && x>=this.domButtons[i].offsetLeft) {
				res = i;
			}
		}
		return res;
	},



	//------------------------------------ Edit Mode for previews ------------------------------------


	makeEditablePreview : function() {
		//Element to destroy after edition
		this._moveableDivPreviews = [];
		this._moveableElemPreviews = [];
		this._moveableEventsPreviews = [];
		//DOM
		this.domPreviewContainer = dojo.query("ul.MainContent_PreviewList", this.objPreview.domNode)[0];
		this.domPreview = dojo.query("li.ZonePreview", this.objPreview.domPreviewList);
		//Event to manage timer
		var event = dojo.connect(this.objPreview.domScroll, "onmousedown", this, this.objTimer.stop);
		this._moveableEventsPreviews.push(event);
		event = dojo.connect(this.objPreview.domScroll, "onmouseup", this, this.objTimer.start);
		this._moveableEventsPreviews.push(event);
		this.objPreview.domNode.addEventListener("mousedown", this.eventMouseDownPreview, true);
		//Add mask onn previews zone
		var elt = dojo.create("div", {});
		dojo.place(elt, this.domPreviewContainer, "first");
		this._moveableDivPreviews.push(elt);
		elt.style.position="absolute";
		elt.style.height="100%";
		elt.style.width=this.domPreviewContainer.scrollWidth+"px";
		elt.style.zIndex="100";
		dojo.style(elt, "z-index", "40");
		this.maskDivPreview = elt;

		//Addmask on preview
		for (var i=0; i<this.domPreview.length; i++) {
			//Create div mask in front on preview zone
			elt = dojo.create("div", {});
			dojo.place(elt, this.domPreview[i], "first");
			this._moveableDivPreviews.push(elt);
			elt.style.position="absolute";
			elt.style.height="100%";
			elt.style.width=this.domPreview[i].offsetWidth+"px";
			dojo.style(elt, "z-index", "50");
			dojo.addClass(elt, "handler");

			var iframe = dojo.query("iframe", this.domPreview[i])[0];
			event = dojo.connect(this.domPreview[i],"onclick", this, this.domPreview[i]);
			this._moveableEventsPreviews.push(event);
			//Create Moveable element
			var moveable = new dojo.dnd.Moveable(iframe, {delay: 2, handle:this.domPreview[i]});
			this._moveableElemPreviews.push(moveable);
			event = dojo.connect(moveable, "onDragDetected", this, this.eventDragStartPreview);
			this._moveableEventsPreviews.push(event);
			event = dojo.connect(moveable, "onMoving", this, this.eventMovingPreview);
			this._moveableEventsPreviews.push(event);
			event = dojo.connect(moveable, "onMoved", this, this.eventMovedPreview);
			this._moveableEventsPreviews.push(event);
			event = dojo.connect(moveable, "onMoveStop", this, this.eventStopMovePreview);
			this._moveableEventsPreviews.push(event);
		}
		this.startTimer();
	},



	makeUneditablePreview : function() {
		var i;
		this.objPreview.domNode.removeEventListener("mousedown", this.eventMouseDownPreview, true);
		var IctScroll = this.objPreview.domScroll.IctScroll;
		IctScroll.setDisableScroll(false);
		//destroy data of dnd.move and events
		for (i in this._moveableEventsPreviews) {
			dojo.disconnect(this._moveableEventsPreviews[i]);
		}
		for (i in this._moveableElemPreviews) {
			this._moveableElemPreviews[i].destroy();
		}
		for (i in this._moveableDivPreviews) {
			dojo.destroy(this._moveableDivPreviews[i]);
		}
		this._moveableElemPreviews = null;
		this._moveableEventsPreviews = null;
	},


	eventMouseDownPreview : function(ev) {
		//Disable Scroll if target element is DND handler
		if(dojo.hasClass(ev.target, "handler")) {
			var IctScroll = webapp.homepage.homepagePreviewView.objPreview.domScroll.IctScroll;
			IctScroll.setDisableScroll(true);
		}
	},

	eventDragStartPreview : function(ev) {
		//Get LI node
		var node = ev.target;
		while (node.tagName !== "LI" || dojo.hasClass(node, "ZonePreview") !== true) {
			// || node.getAttribute("widgetname")==""
			node = node.parentNode;
		}
		this.srcPosPreviews = node.getAttribute("position");
		var iframe = dojo.query("iframe", node)[0];
		dojo.style(node, "visibility", "hidden");
		dojo.style(iframe, "visibility", "visible");
		dojo.style(iframe, "background-color", dojo.style(node, "background-color"));
		//Add event when we leave preview area
		var event = dojo.connect(this.objPreview.domNode, "onmouseout", this, this.eventMouseOutPreview);
		this._moveableEventsPreviews.push(event);
		this.objTimer.stop();
	},

	eventMovingPreview: function(ev, ev2) {
		ev2.t = 0;
	},

	eventMovedPreview : function(ev, ev2) {
		this.xPosPreviews = ev2.l;
	},

	eventMouseOutPreview : function(ev) {
		if(ev.y<0 || ev.y>313) {
			this.eventStopMovePreview();
		}
	},

	eventStopMovePreview : function (ev) {
		//re-enable scroll
		var IctScroll = this.objPreview.domScroll.IctScroll;
		IctScroll.setDisableScroll(false);
		//Clean source preview
		var iframe = dojo.query("iframe", this.domPreview[this.srcPosPreviews])[0];
		iframe.removeAttribute("style");
		dojo.style(this.domPreview[this.srcPosPreviews], "visibility", "");
		//Search destination
		var destPos = this.searchCasePreview();
		if (destPos != null && destPos !== "") {
			if (this.srcPosPreviews !== destPos) {
				if(this.srcPosPreviews < destPos) {
					destPos-=1;
				}
				webapp.homepage.data.movePreview(this.srcPosPreviews, destPos);
				webapp.homepage.previewControl.movePreview(this.srcPosPreviews, destPos);
				var div = dojo.create("div", { });

				webapp.homepage.previewControl.replacePreview(destPos, this.firstLoad(destPos,div));
			}
		}

		//Reload appbar
		this.makeUneditablePreview();
		this.makeEditablePreview();
	},


	searchCasePreview : function() {
		var res = null;
		var i;
		//Compare actual position with previews positions
		if (this.srcPosPreviews !== 0 && this.xPosPreviews < this.domPreview[0].offsetLeft) {
			return 0;
		} else {
			for(i = 0; i <= this.domPreview.length-2; i++) {
				if(i !== this.srcPosPreviews) {
					if(this.xPosPreviews>=this.domPreview[i].offsetLeft && this.xPosPreviews<this.domPreview[i].offsetLeft+this.domPreview[i].offsetWidth) {
						res = i+1;
						break;
					}
				}
			}
			if(res!=null) {
				return res;
			}
			else {
				if (this.srcPosPreviews !== this.domPreview.length && this.xPosPreviews >= this.domPreview[this.domPreview.length - 1].offsetLeft) {
					return this.domPreview.length;
				}
			}
		}
		return null;
	}




});

dojo.provide("webapp.homepage.getHomepageStandardBase");
dojo.declare("webapp.homepage.getHomepageStandardBase",
	[ICTouchAPI.webWidget, dijit._Templated],
	{

		constructor : function() {
		}

	}
);
dojo.require("webapp.homepage.getHomepageStandardBase");
dojo.provide("webapp.homepage.getHomepageStandard");
dojo.declare("webapp.homepage.getHomepageStandard",	webapp.homepage.getHomepageStandardBase, {
	templatePath: dojo.moduleUrl("webapp.homepage","templates/getHomepageStandard8082.html"),

	intMaxKey					: 0,
	intMaxPage					: 6,
	/* dom and node */
	arrDomPositions				: null,
	arrObjKeys					: null,
	/* Subscribe */
	_hEditMode					: null,
	_hNormalMode				: null,
	_hReload					: null,
	_languageChanged			: null,
	_hChangePage				: null,
	/* For mode edition */
	pageWidth					: null,
	pageHeight					: null,
	locationWidth				: null,
	locationHeight				: null,
	locationMarginX				: null,
	locationMarginY				: null,
	_timerEdition				: null,
	_timerEditionDuration		: 10000,		//@TODO set to 10000
	objTimer					: null,
	_moveableEvents				: null,
	_moveableElem				: null,
	xPos						: null,
	yPos						: null,
	domKeySrc					: null,
	srcPos						: null,
	editModeEnabled				: false,
	arrowLeftOverLock			: false,
	arrowRightOverLock			: false,
	offsetX						: 0,
	domNavigationBar			: null,
	objNavigationBarUI			: null,
        isScrolling                             : false,
        lastXPos                                : 0,
        newXPos                                 : 0,


	constructor: function() {
		this.arrDomPositions = [];
		this.arrObjKeys = [];
	},


	postCreate: function() {
		var i, j, k;
		/*var css = ICTouchAPI.skinServices.getIconsCssNodes();

		for(i in css){
			this.domHomepageStandard.appendChild(css[i]);
		}*/
		//Create buttons
		for(i=0; i<2; i++) {
			for (j = 0; j < 6; j++) {
				//72 buttons
				for(k=0; k<6; k++) {
					var ind = j*12 + k + i*6;
					//Create button location
					this.arrDomPositions[ind] = [];
					var locationNode = dojo.create("li", null, this.domGetHomepageStandard);
					this.arrDomPositions[ind] = locationNode;
					locationNode.setAttribute("position", ind);
					dojo.addClass(locationNode, "homepageButton");
				}
			}
		}
		
		var funcDisplayCallBack = dojo.hitch(this,this.changePage);
		this.objNavigationBarUI = new UIElements.NavigationBar.NavigationBar ({domArrowLeft:this.divLeftArrow, domArrowRight:this.divRightArrow, displayCallBack:funcDisplayCallBack, intMaxPage:this.intMaxPage}, this.domNavigationBar);
		this.connect(this.objNavigationBarUI.domNode, "onmousedown", this.onMouseDown);
		this.connect(this.objNavigationBarUI.domNode, "onmouseup", this.onMouseUporLeave);
		this.connect(this.objNavigationBarUI.domNode, "onmouseleave", this.onMouseUporLeave);
		this.updateKeys(true);
	},
        
	postMixInProperties : function(){

	},

	enableSubscribe : function() {
		this._hEditMode = dojo.subscribe("homepage/editMode",this,this.makeEditable);
	    this._hNormalMode = dojo.subscribe("homepage/normalMode",this,this.makeUneditable);
	    this._hReload = dojo.subscribe("homepageStandard/reload",this,this.reload);
		this._languageChanged = this.subscribe("languageChanged",this.applyDMTranslation);
		this._hChangePage = dojo.subscribe("homepageStandard/changePage",this,this.onChangePageEvent);
	},

	disableSubscribe : function() {
		dojo.unsubscribe(this._hEditMode);
	    dojo.unsubscribe(this._hNormalMode);
	    dojo.unsubscribe(this._hReload);
		this.unsubscribe(this._languageChanged);
		dojo.unsubscribe(this._hChangePage);
	},

	update : function(args) {
	    this.inherited(arguments);
	},


	updateKeys: function(complete) {
		var data	= webapp.homepage.data;
		var i;
		
		//Destroy obsolete button or all buttons
		for(i in this.arrObjKeys) {
			if(this.arrObjKeys[i]!=null && (complete===true || data._arrKeys[i]==null || data._arrKeys[i]!==this.arrObjKeys[i].strButtonName)) {
				this.arrObjKeys[i].destroy();
				this.arrObjKeys[i] = null;
			}
		}

		//Add buttons
		if(data._arrKeys) {
			for(i in data._arrKeys) {
				if((data._arrKeys[i]!=null && data._arrKeys[i]!=="")) {
					//If position < 72(in 6 pages) and if a webapp button, homepageStandardAutoFill must be true
					if (i < 72) {
						//webapp buttons
						if ((data._arrAppKeys[i] != null && data._arrAppKeys[i].strButtonName != null)) {
							var currentKey;
							if(this.arrObjKeys[i]==null) {
								currentKey = data._arrAppKeys[i];
								this.placeKey(i, currentKey);
							}
							this.intMaxKey = i;
						}
					}
				}
			}
			//calcul number of page (removed to display all pages all the time)
			this.objNavigationBarUI.setMaxPage(Math.floor(this.intMaxKey/12)+1);
		}
		this.applyDMTranslation();
		this.objNavigationBarUI.goToPage(this.objNavigationBarUI.intCurrentPage);
	},
	
	placeKey : function(pos, currentKey) {
		if(currentKey.strButtonName.match(/^PROGKEYS_[0-9]*$/) && webapp.progkeys) {	// Progkeys
			currentKey = webapp.progkeys.onProgkeysDisplay(currentKey);
		}
		
		//placeKey
		var objKey = new UIElements.AppButton.ButtonControl(currentKey);
		objKey.placeAt(this.arrDomPositions[pos], "first");
		
		if(currentKey.imgbutton) {
			var image = dojo.query("span", this.arrDomPositions[pos])[0];
			dojo.style(image,"backgroundImage", "url('"+currentKey.imgbutton+"')");
			dojo.addClass(image, "specificIcon");
		}

		this.arrObjKeys[pos] = objKey;
	},

	//Change label with DM translation if exist
	applyDMTranslation : function() {
		ICTouchAPI.debugServices.info('webapp.homepage.controlBase - applyDMTranslation');
		if(this.webapp.data.extProgKeysLocalisation){
			var currentLocal = ICTouchAPI.i18nServices.getLocale();
			for(var i in this.webapp.data._arrAppKeys){
				var button = this.webapp.data._arrAppKeys[i];
				if(button && button.strButtonLabel && button.strLabelId && !button.strButtonLabel.isI18Ned){
					var label = "";
					ICTouchAPI.debugServices.debug('webapp.homepage.controlBase - applyDMTranslation / search DM translation for button.strLabelId ' + button.strLabelId + " (current locale is: " + currentLocal + ")");
					//
					if (this.webapp.data.extProgKeysLocalisation[currentLocal] && this.webapp.data.extProgKeysLocalisation[currentLocal][button.strLabelId]){
						label = this.webapp.data.extProgKeysLocalisation[currentLocal][button.strLabelId];
						ICTouchAPI.debugServices.debug('webapp.homepage.controlBase - applyDMTranslation / DM translation found for button.strLabelId ' + button.strLabelId + " in locale " + currentLocal + ", translation is: " + label);
					}
					else if (this.webapp.data.extProgKeysLocalisation["en"] && this.webapp.data.extProgKeysLocalisation["en"][button.strLabelId]){
						label = this.webapp.data.extProgKeysLocalisation["en"][button.strLabelId];
						ICTouchAPI.debugServices.debug('webapp.homepage.controlBase - applyDMTranslation / no DM translation found for button.strLabelId ' + button.strLabelId + " in locale " + currentLocal + ", use english translation: " + label);
					}
					else{
						label = button.strLabelId;
						ICTouchAPI.debugServices.debug('webapp.homepage.controlBase - applyDMTranslation / no DM translation found for button.strLabelId ' + button.strLabelId + " and no english DM translation available, use the strLabelId " + label);
					}
					ICTouchAPI.debugServices.debug('webapp.homepage.controlBase - applyDMTranslation / set computed label for button.strLabelId ' + button.strLabelId + " : " + label);
					this.arrObjKeys[i].attr("strButtonLabel", label);
				}
			}
		}
	},

	onChangePageEvent : function(intPage) {
		this.objNavigationBarUI.goToPage(intPage);
	},

	changePage : function(page) {
		//Show selected page
		this.domGetHomepageStandard.style.left = (720-(page*720)) + "px";
	},

	previousPage : function() {
		this.objNavigationBarUI.previous();
	},

	nextPage : function() {
		this.objNavigationBarUI.next();
	},
        
        onMouseDown : function (event) {
                if (this.isScrolling == false) {
                        this.isScrolling = true;
                        this.lastXPos = event.x;
                } else {
                        this.isScrolling = false;
                }
        },
        
        onMouseUporLeave : function (event) {
                if (this.isScrolling == true) {
                     if (ICTouchAPI.transitionServices.getCurrentScreenName() == "webapp.homepage.getHomepage") {
                        this.newXPos = event.x;
                        if (this.lastXPos - this.newXPos > 15) {
                                this.nextPage();
                        } else if (this.lastXPos - this.newXPos < -15) {
                                this.previousPage();
                        }
                     }
                     this.isScrolling = false;
                }
        },         

	reload : function() {
		if(this.editModeEnabled !== true) {
			this.updateKeys(true);
		}
	},

	destroy : function() {
		this.inherited(arguments);
	},





	//-------------Edit Mode----------------
	 /*
         * Homepage edition mode
         * Start the edition timer (10s of inactivity deactivate edition mode
         */
	makeEditable : function() {
		var i;
		this.pageWidth = this.domGetHomepageStandard.offsetWidth;
		this.pageHeight = this.domGetHomepageStandard.parentNode.offsetHeight;
		this.locationWidth = this.arrDomPositions[0].offsetWidth;
		this.locationHeight = this.arrDomPositions[0].offsetHeight;
		this.locationMarginX = dojo.style(this.arrDomPositions[1], "margin-left")+dojo.style(this.arrDomPositions[1], "margin-right");
		this.locationMarginY = dojo.style(this.arrDomPositions[1], "margin-top")+dojo.style(this.arrDomPositions[1], "margin-bottom");

		this.editModeEnabled = true;
		this._moveableElem = [];
		this._moveableEvents = [];
		var that = this;
		var funcStopTimer = function() {that.stopTimer()};
		var funcReloadTimer = function() {that.startTimer()};
		//Object Timer for the homepage.edition objects
		this.objTimer = {
			stop : funcStopTimer,
			start : funcReloadTimer
		};
		//Show all pages and hide node
		for(i=0; i<=35; i++) {
			dojo.style(this.arrDomPositions[i], "display", "");
		}
		//dojo.style(this.domGetHomepageStandard, "width", "300%");

		//Homepage edition
		for (i in this.arrDomPositions) {
			if (this.arrObjKeys[i]!=null) {
				//dojo.addClass(this.arrDomPositions[i].mainDiv, "handler");
				//Add event
				var moveable = new dojo.dnd.Moveable(this.arrObjKeys[i].domNode, {delay: 0, handle: this.arrObjKeys[i].domNode});
				this._moveableElem.push(moveable);
				var event = dojo.connect(moveable, "onDragDetected", this, this.eventDragStart);
				this._moveableEvents.push(event);
				event = dojo.connect(moveable, "onMoving", this, this.eventMoving);
				this._moveableEvents.push(event);
				event = dojo.connect(moveable, "onMoved", this, this.eventMoved);
				this._moveableEvents.push(event);
				event = dojo.connect(moveable, "onMoveStop", this, this.eventStopMove);
				this._moveableEvents.push(event);
				//Disable button callback
				this.arrObjKeys[i].callbackSave = this.arrObjKeys[i].callback;
				this.arrObjKeys[i].callback = null;
			}
		}
		this.objNavigationBarUI.goToPage(this.objNavigationBarUI.intCurrentPage);
		this.objTimer.start();
	},


	/*
	 * Reactivate homepage normal mode.
	 */
	makeUneditable : function(reload){
		var i;
		this.objTimer.stop();
		//Reenable button callback
		for (i in this.arrDomPositions) {
			if (this.arrObjKeys[i]!=null) {
				this.arrObjKeys[i].callback = this.arrObjKeys[i].callbackSave;
				delete (this.arrObjKeys[i].callbackSave);
			}
		}
		//destroy data of dnd.move and events
		for(i in this._moveableEvents) {
			dojo.disconnect(this._moveableEvents[i]);
		}
		for(i in this._moveableElem) {
			this._moveableElem[i].destroy();
		}
		if(this.arrObjKeys[this.srcPos]!=null) {
			this.arrObjKeys[this.srcPos].domNode.removeAttribute("style");
			this.arrObjKeys[this.srcPos].destroy();
			this.arrObjKeys[this.srcPos] = null;
		}
		this._moveableEvents = null;
		this._moveableElem = null;

		//Save keys position, reload homepage and return to settings
		if (reload !== true) {
			this.editModeEnabled = false;
			//this.reload();
			webapp.homepage.data.saveKeys();
			ICTouchAPI.transitionServices.getScreen({name: "webapp.settings.getSettings", params: {delay: 20}});
		}
	},


	eventDragStart : function(ev) {
		this.offsetX = 0;
		var node = ev.target;
		while (node.getAttribute("position") === "" || node.getAttribute("position") == null) {
			node = node.parentNode;
		}
		this.srcPos = parseInt(node.getAttribute("position"));
		this.domKeySrc = this.arrObjKeys[this.srcPos].domNode;
		dojo.style(this.domKeySrc, "z-index", "100");
		this.arrDomPositions[this.srcPos].setAttribute("action", "0");
		this.objTimer.stop();
		//Add event when we leave progkeys area
		var event = dojo.connect(this.arrObjKeys[this.srcPos].domNode, "onmouseout", this, this.eventMouseOut);
		this._moveableEvents.push(event);
	},


	eventMouseOut : function(ev) {
		ev.stopPropagation();
		if(ev.y<3 || ev.y>301) {
			this.makeUneditable(true);
			this.arrObjKeys[this.srcPos].destroy();
			this.arrObjKeys[this.srcPos] = null;
			this.updateKeys();
			this.makeEditable();
		}
	},


	eventMoving : function(ev, ev2) {
		//Top and bottom verification
		if (ev2.t < 0) {ev2.t = 0}
		else if (ev2.t > this.pageHeight-this.locationHeight+2) {ev2.t = this.pageHeight-this.locationHeight+2;}
		//Left and right verification and page change
		if (ev2.l+this.offsetX+30+this.domGetHomepageStandard.offsetLeft<=this.objNavigationBarUI.domLeftArrow.offsetLeft && !dojo.hasClass(this.objNavigationBarUI.domLeftArrow, "hide")) {
			if(this.arrowLeftOverLock!==true) {
				this.arrowLeftOverLock = true;
				this.objNavigationBarUI.previous();
				
				this.offsetX = this.offsetX-720;
			}
		}
		else {
			this.arrowLeftOverLock = false;
		}
		if(ev2.l+this.offsetX+60+this.domGetHomepageStandard.offsetLeft>=this.objNavigationBarUI.domRightArrow.offsetLeft  && !dojo.hasClass(this.objNavigationBarUI.domRightArrow, "hide")) {
			if(this.arrowRightOverLock!==true) {
				this.arrowRightOverLock = true;
				this.objNavigationBarUI.next();

				this.offsetX = this.offsetX+720;
			}
		}
		else {
			this.arrowRightOverLock = false;
		}
		ev2.l = ev2.l+this.offsetX;
	},

	eventMoved : function(ev, ev2) {
		this.xPos = ev2.l+this.offsetX;
		this.yPos = ev2.t;
	},

	eventStopMove : function (ev) {
		var destPos = this.searchlocation();
			this.makeUneditable(true);
		if(destPos!=null) {
			webapp.homepage.data.moveKeys(this.srcPos, destPos);
		}
		this.updateKeys();
			this.makeEditable();
	},


	searchlocation : function() {
		var res = null;
		for(var ind in this.arrDomPositions) {
			var dom = this.arrDomPositions[ind];
				//Check y coordonne
			if(this.domKeySrc.offsetTop >= dom.offsetTop-this.locationMarginY/2-dom.offsetHeight/2  &&  this.domKeySrc.offsetTop < dom.offsetTop+this.locationMarginY/2+dom.offsetHeight/2) {
					//Check x coordonne if placement is button
				if(this.arrObjKeys[ind] && ind!== this.srcPos) {
					if(this.domKeySrc.offsetLeft >= dom.offsetLeft-(this.locationMarginX+dom.offsetWidth)  &&  this.domKeySrc.offsetLeft < dom.offsetLeft) {
					res = ind;
					break;
				}
			}
					//Check x coordonne if placement is void
			else {
					if(this.domKeySrc.offsetLeft >= dom.offsetLeft-(this.locationMarginX+dom.offsetWidth)  &&  this.domKeySrc.offsetLeft < dom.offsetLeft+(this.locationMarginX+dom.offsetWidth)/2) {
							res = ind;
						break;
					}
				}
					}
				}
		if (res === this.srcPos) res=null;
		return parseInt(res);
	},



	/*
	 * Start timer. Deactivate the edition mode if user is inactive during this._timerEditionDuration(ms)
	 */
	startTimer : function(){
		clearTimeout(this._timerEdition);
		var that = this;
		var func = function () {
			that.makeUneditable();
		};
		this._timerEdition = setTimeout(func, this._timerEditionDuration);
	},
	/*
	 * Stop timer. (User activity)
	 */
	stopTimer : function(){
		clearTimeout(this._timerEdition);
	}



});
dojo.provide("webapp.homepage.getHomepageStandardEditBase");
dojo.declare("webapp.homepage.getHomepageStandardEditBase", [ICTouchAPI.webWidget, dijit._Templated],
{
	
	
	
	constructor : function() {
		
	}
	
});
dojo.require("webapp.homepage.getHomepageStandardEditBase");
dojo.provide("webapp.homepage.getHomepageStandardEdit");
dojo.declare("webapp.homepage.getHomepageStandardEdit", webapp.homepage.getHomepageStandardEditBase,
{
	templatePath: dojo.moduleUrl("webapp.homepage","templates/getHomepageStandardEdit8082.html"),


	_menuContainer		: null,
	_menuList			: null,
	reloadSubscribe		: null,


	constructor : function() {
	},

	postCreate : function() {
		this.reloadSubscribe = dojo.subscribe("homepageStandard/reload",this,this.reload);
		this._createMenu();
		webapp.homepage.homepageEditView = this;
	},

	destroy : function(){
		this._menuList.destroy();
		dojo.unsubscribe(this.reloadSubscribe);
		/* @TODO This line crash presentation: Container bug? */
		//this._menuContainer.destroy();
		this.inherited(arguments);
	},


	_createMenu : function() {
		var func = { context:webapp.homepage, func:webapp.homepage.callbackMenuEdit };
		var containerContent =  {
					name : "UIElements.MenuList.MenuListControl",
					params : {arrItems: webapp.homepage.data.getProgKeysList(), callback: func,autoSelectFirst: false}
		}
		if(this._menuList==null) {
			var menuDiv = dojo.create("div", { }, this.domMenuList);
			this._menuContainer = new UIElements.Container.ContainerControl(
			{
				objContent: containerContent
			}, menuDiv);
		this._menuList = this._menuContainer.getContent();
		}
		else {
			this._menuContainer.reload({objContent: containerContent});
			this._menuList = this._menuContainer.getContent();
		}
	},


	reload : function() {
		this._createMenu();
	}


});
