dojo.require("webapp.homepage.getHomepageStandardEditBase");
dojo.provide("webapp.homepage.getHomepageStandardEdit");
dojo.declare("webapp.homepage.getHomepageStandardEdit", webapp.homepage.getHomepageStandardEditBase,
{
	templatePath: dojo.moduleUrl("webapp.homepage","templates/getHomepageStandardEdit8082.html"),


	_menuContainer		: null,
	_menuList			: null,
	reloadSubscribe		: null,


	constructor : function() {
	},

	postCreate : function() {
		this.reloadSubscribe = dojo.subscribe("homepageStandard/reload",this,this.reload);
		this._createMenu();
		webapp.homepage.homepageEditView = this;
	},

	destroy : function(){
		this._menuList.destroy();
		dojo.unsubscribe(this.reloadSubscribe);
		/* @TODO This line crash presentation: Container bug? */
		//this._menuContainer.destroy();
		this.inherited(arguments);
	},


	_createMenu : function() {
		var func = { context:webapp.homepage, func:webapp.homepage.callbackMenuEdit };
		var containerContent =  {
					name : "UIElements.MenuList.MenuListControl",
					params : {arrItems: webapp.homepage.data.getProgKeysList(), callback: func,autoSelectFirst: false}
		}
		if(this._menuList==null) {
			var menuDiv = dojo.create("div", { }, this.domMenuList);
			this._menuContainer = new UIElements.Container.ContainerControl(
			{
				objContent: containerContent
			}, menuDiv);
		this._menuList = this._menuContainer.getContent();
		}
		else {
			this._menuContainer.reload({objContent: containerContent});
			this._menuList = this._menuContainer.getContent();
		}
	},


	reload : function() {
		this._createMenu();
	}


});
