dojo.require("webapp.homepage.getHomepageStandardBase");
dojo.provide("webapp.homepage.getHomepageStandard");
dojo.declare("webapp.homepage.getHomepageStandard",	webapp.homepage.getHomepageStandardBase, {
	templatePath: dojo.moduleUrl("webapp.homepage","templates/getHomepageStandard8082.html"),

	intMaxKey					: 0,
	intMaxPage					: 6,
	/* dom and node */
	arrDomPositions				: null,
	arrObjKeys					: null,
	/* Subscribe */
	_hEditMode					: null,
	_hNormalMode				: null,
	_hReload					: null,
	_languageChanged			: null,
	_hChangePage				: null,
	/* For mode edition */
	pageWidth					: null,
	pageHeight					: null,
	locationWidth				: null,
	locationHeight				: null,
	locationMarginX				: null,
	locationMarginY				: null,
	_timerEdition				: null,
	_timerEditionDuration		: 10000,		//@TODO set to 10000
	objTimer					: null,
	_moveableEvents				: null,
	_moveableElem				: null,
	xPos						: null,
	yPos						: null,
	domKeySrc					: null,
	srcPos						: null,
	editModeEnabled				: false,
	arrowLeftOverLock			: false,
	arrowRightOverLock			: false,
	offsetX						: 0,
	domNavigationBar			: null,
	objNavigationBarUI			: null,
        isScrolling                             : false,
        lastXPos                                : 0,
        newXPos                                 : 0,


	constructor: function() {
		this.arrDomPositions = [];
		this.arrObjKeys = [];
	},


	postCreate: function() {
		var i, j, k;
		/*var css = ICTouchAPI.skinServices.getIconsCssNodes();

		for(i in css){
			this.domHomepageStandard.appendChild(css[i]);
		}*/
		//Create buttons
		for(i=0; i<2; i++) {
			for (j = 0; j < 6; j++) {
				//72 buttons
				for(k=0; k<6; k++) {
					var ind = j*12 + k + i*6;
					//Create button location
					this.arrDomPositions[ind] = [];
					var locationNode = dojo.create("li", null, this.domGetHomepageStandard);
					this.arrDomPositions[ind] = locationNode;
					locationNode.setAttribute("position", ind);
					dojo.addClass(locationNode, "homepageButton");
				}
			}
		}
		
		var funcDisplayCallBack = dojo.hitch(this,this.changePage);
		this.objNavigationBarUI = new UIElements.NavigationBar.NavigationBar ({domArrowLeft:this.divLeftArrow, domArrowRight:this.divRightArrow, displayCallBack:funcDisplayCallBack, intMaxPage:this.intMaxPage}, this.domNavigationBar);
		this.connect(this.objNavigationBarUI.domNode, "onmousedown", this.onMouseDown);
		this.connect(this.objNavigationBarUI.domNode, "onmouseup", this.onMouseUporLeave);
		this.connect(this.objNavigationBarUI.domNode, "onmouseleave", this.onMouseUporLeave);
		this.updateKeys(true);
	},
        
	postMixInProperties : function(){

	},

	enableSubscribe : function() {
		this._hEditMode = dojo.subscribe("homepage/editMode",this,this.makeEditable);
	    this._hNormalMode = dojo.subscribe("homepage/normalMode",this,this.makeUneditable);
	    this._hReload = dojo.subscribe("homepageStandard/reload",this,this.reload);
		this._languageChanged = this.subscribe("languageChanged",this.applyDMTranslation);
		this._hChangePage = dojo.subscribe("homepageStandard/changePage",this,this.onChangePageEvent);
	},

	disableSubscribe : function() {
		dojo.unsubscribe(this._hEditMode);
	    dojo.unsubscribe(this._hNormalMode);
	    dojo.unsubscribe(this._hReload);
		this.unsubscribe(this._languageChanged);
		dojo.unsubscribe(this._hChangePage);
	},

	update : function(args) {
	    this.inherited(arguments);
	},


	updateKeys: function(complete) {
		var data	= webapp.homepage.data;
		var i;
		
		//Destroy obsolete button or all buttons
		for(i in this.arrObjKeys) {
			if(this.arrObjKeys[i]!=null && (complete===true || data._arrKeys[i]==null || data._arrKeys[i]!==this.arrObjKeys[i].strButtonName)) {
				this.arrObjKeys[i].destroy();
				this.arrObjKeys[i] = null;
			}
		}

		//Add buttons
		if(data._arrKeys) {
			for(i in data._arrKeys) {
				if((data._arrKeys[i]!=null && data._arrKeys[i]!=="")) {
					//If position < 72(in 6 pages) and if a webapp button, homepageStandardAutoFill must be true
					if (i < 72) {
						//webapp buttons
						if ((data._arrAppKeys[i] != null && data._arrAppKeys[i].strButtonName != null)) {
							var currentKey;
							if(this.arrObjKeys[i]==null) {
								currentKey = data._arrAppKeys[i];
								this.placeKey(i, currentKey);
							}
							this.intMaxKey = i;
						}
					}
				}
			}
			//calcul number of page (removed to display all pages all the time)
			this.objNavigationBarUI.setMaxPage(Math.floor(this.intMaxKey/12)+1);
		}
		this.applyDMTranslation();
		this.objNavigationBarUI.goToPage(this.objNavigationBarUI.intCurrentPage);
	},
	
	placeKey : function(pos, currentKey) {
		if(currentKey.strButtonName.match(/^PROGKEYS_[0-9]*$/) && webapp.progkeys) {	// Progkeys
			currentKey = webapp.progkeys.onProgkeysDisplay(currentKey);
		}
		
		//placeKey
		var objKey = new UIElements.AppButton.ButtonControl(currentKey);
		objKey.placeAt(this.arrDomPositions[pos], "first");
		
		if(currentKey.imgbutton) {
			var image = dojo.query("span", this.arrDomPositions[pos])[0];
			dojo.style(image,"backgroundImage", "url('"+currentKey.imgbutton+"')");
			dojo.addClass(image, "specificIcon");
		}

		this.arrObjKeys[pos] = objKey;
	},

	//Change label with DM translation if exist
	applyDMTranslation : function() {
		ICTouchAPI.debugServices.info('webapp.homepage.controlBase - applyDMTranslation');
		if(this.webapp.data.extProgKeysLocalisation){
			var currentLocal = ICTouchAPI.i18nServices.getLocale();
			for(var i in this.webapp.data._arrAppKeys){
				var button = this.webapp.data._arrAppKeys[i];
				if(button && button.strButtonLabel && button.strLabelId && !button.strButtonLabel.isI18Ned){
					var label = "";
					ICTouchAPI.debugServices.debug('webapp.homepage.controlBase - applyDMTranslation / search DM translation for button.strLabelId ' + button.strLabelId + " (current locale is: " + currentLocal + ")");
					//
					if (this.webapp.data.extProgKeysLocalisation[currentLocal] && this.webapp.data.extProgKeysLocalisation[currentLocal][button.strLabelId]){
						label = this.webapp.data.extProgKeysLocalisation[currentLocal][button.strLabelId];
						ICTouchAPI.debugServices.debug('webapp.homepage.controlBase - applyDMTranslation / DM translation found for button.strLabelId ' + button.strLabelId + " in locale " + currentLocal + ", translation is: " + label);
					}
					else if (this.webapp.data.extProgKeysLocalisation["en"] && this.webapp.data.extProgKeysLocalisation["en"][button.strLabelId]){
						label = this.webapp.data.extProgKeysLocalisation["en"][button.strLabelId];
						ICTouchAPI.debugServices.debug('webapp.homepage.controlBase - applyDMTranslation / no DM translation found for button.strLabelId ' + button.strLabelId + " in locale " + currentLocal + ", use english translation: " + label);
					}
					else{
						label = button.strLabelId;
						ICTouchAPI.debugServices.debug('webapp.homepage.controlBase - applyDMTranslation / no DM translation found for button.strLabelId ' + button.strLabelId + " and no english DM translation available, use the strLabelId " + label);
					}
					ICTouchAPI.debugServices.debug('webapp.homepage.controlBase - applyDMTranslation / set computed label for button.strLabelId ' + button.strLabelId + " : " + label);
					this.arrObjKeys[i].attr("strButtonLabel", label);
				}
			}
		}
	},

	onChangePageEvent : function(intPage) {
		this.objNavigationBarUI.goToPage(intPage);
	},

	changePage : function(page) {
		//Show selected page
		this.domGetHomepageStandard.style.left = (720-(page*720)) + "px";
	},

	previousPage : function() {
		this.objNavigationBarUI.previous();
	},

	nextPage : function() {
		this.objNavigationBarUI.next();
	},
        
        onMouseDown : function (event) {
                if (this.isScrolling == false) {
                        this.isScrolling = true;
                        this.lastXPos = event.x;
                } else {
                        this.isScrolling = false;
                }
        },
        
        onMouseUporLeave : function (event) {
                if (this.isScrolling == true) {
                     if (ICTouchAPI.transitionServices.getCurrentScreenName() == "webapp.homepage.getHomepage") {
                        this.newXPos = event.x;
                        if (this.lastXPos - this.newXPos > 15) {
                                this.nextPage();
                        } else if (this.lastXPos - this.newXPos < -15) {
                                this.previousPage();
                        }
                     }
                     this.isScrolling = false;
                }
        },         

	reload : function() {
		if(this.editModeEnabled !== true) {
			this.updateKeys(true);
		}
	},

	destroy : function() {
		this.inherited(arguments);
	},





	//-------------Edit Mode----------------
	 /*
         * Homepage edition mode
         * Start the edition timer (10s of inactivity deactivate edition mode
         */
	makeEditable : function() {
		var i;
		this.pageWidth = this.domGetHomepageStandard.offsetWidth;
		this.pageHeight = this.domGetHomepageStandard.parentNode.offsetHeight;
		this.locationWidth = this.arrDomPositions[0].offsetWidth;
		this.locationHeight = this.arrDomPositions[0].offsetHeight;
		this.locationMarginX = dojo.style(this.arrDomPositions[1], "margin-left")+dojo.style(this.arrDomPositions[1], "margin-right");
		this.locationMarginY = dojo.style(this.arrDomPositions[1], "margin-top")+dojo.style(this.arrDomPositions[1], "margin-bottom");

		this.editModeEnabled = true;
		this._moveableElem = [];
		this._moveableEvents = [];
		var that = this;
		var funcStopTimer = function() {that.stopTimer()};
		var funcReloadTimer = function() {that.startTimer()};
		//Object Timer for the homepage.edition objects
		this.objTimer = {
			stop : funcStopTimer,
			start : funcReloadTimer
		};
		//Show all pages and hide node
		for(i=0; i<=35; i++) {
			dojo.style(this.arrDomPositions[i], "display", "");
		}
		//dojo.style(this.domGetHomepageStandard, "width", "300%");

		//Homepage edition
		for (i in this.arrDomPositions) {
			if (this.arrObjKeys[i]!=null) {
				//dojo.addClass(this.arrDomPositions[i].mainDiv, "handler");
				//Add event
				var moveable = new dojo.dnd.Moveable(this.arrObjKeys[i].domNode, {delay: 0, handle: this.arrObjKeys[i].domNode});
				this._moveableElem.push(moveable);
				var event = dojo.connect(moveable, "onDragDetected", this, this.eventDragStart);
				this._moveableEvents.push(event);
				event = dojo.connect(moveable, "onMoving", this, this.eventMoving);
				this._moveableEvents.push(event);
				event = dojo.connect(moveable, "onMoved", this, this.eventMoved);
				this._moveableEvents.push(event);
				event = dojo.connect(moveable, "onMoveStop", this, this.eventStopMove);
				this._moveableEvents.push(event);
				//Disable button callback
				this.arrObjKeys[i].callbackSave = this.arrObjKeys[i].callback;
				this.arrObjKeys[i].callback = null;
			}
		}
		this.objNavigationBarUI.goToPage(this.objNavigationBarUI.intCurrentPage);
		this.objTimer.start();
	},


	/*
	 * Reactivate homepage normal mode.
	 */
	makeUneditable : function(reload){
		var i;
		this.objTimer.stop();
		//Reenable button callback
		for (i in this.arrDomPositions) {
			if (this.arrObjKeys[i]!=null) {
				this.arrObjKeys[i].callback = this.arrObjKeys[i].callbackSave;
				delete (this.arrObjKeys[i].callbackSave);
			}
		}
		//destroy data of dnd.move and events
		for(i in this._moveableEvents) {
			dojo.disconnect(this._moveableEvents[i]);
		}
		for(i in this._moveableElem) {
			this._moveableElem[i].destroy();
		}
		if(this.arrObjKeys[this.srcPos]!=null) {
			this.arrObjKeys[this.srcPos].domNode.removeAttribute("style");
			this.arrObjKeys[this.srcPos].destroy();
			this.arrObjKeys[this.srcPos] = null;
		}
		this._moveableEvents = null;
		this._moveableElem = null;

		//Save keys position, reload homepage and return to settings
		if (reload !== true) {
			this.editModeEnabled = false;
			//this.reload();
			webapp.homepage.data.saveKeys();
			ICTouchAPI.transitionServices.getScreen({name: "webapp.settings.getSettings", params: {delay: 20}});
		}
	},


	eventDragStart : function(ev) {
		this.offsetX = 0;
		var node = ev.target;
		while (node.getAttribute("position") === "" || node.getAttribute("position") == null) {
			node = node.parentNode;
		}
		this.srcPos = parseInt(node.getAttribute("position"));
		this.domKeySrc = this.arrObjKeys[this.srcPos].domNode;
		dojo.style(this.domKeySrc, "z-index", "100");
		this.arrDomPositions[this.srcPos].setAttribute("action", "0");
		this.objTimer.stop();
		//Add event when we leave progkeys area
		var event = dojo.connect(this.arrObjKeys[this.srcPos].domNode, "onmouseout", this, this.eventMouseOut);
		this._moveableEvents.push(event);
	},


	eventMouseOut : function(ev) {
		ev.stopPropagation();
		if(ev.y<3 || ev.y>301) {
			this.makeUneditable(true);
			this.arrObjKeys[this.srcPos].destroy();
			this.arrObjKeys[this.srcPos] = null;
			this.updateKeys();
			this.makeEditable();
		}
	},


	eventMoving : function(ev, ev2) {
		//Top and bottom verification
		if (ev2.t < 0) {ev2.t = 0}
		else if (ev2.t > this.pageHeight-this.locationHeight+2) {ev2.t = this.pageHeight-this.locationHeight+2;}
		//Left and right verification and page change
		if (ev2.l+this.offsetX+30+this.domGetHomepageStandard.offsetLeft<=this.objNavigationBarUI.domLeftArrow.offsetLeft && !dojo.hasClass(this.objNavigationBarUI.domLeftArrow, "hide")) {
			if(this.arrowLeftOverLock!==true) {
				this.arrowLeftOverLock = true;
				this.objNavigationBarUI.previous();
				
				this.offsetX = this.offsetX-720;
			}
		}
		else {
			this.arrowLeftOverLock = false;
		}
		if(ev2.l+this.offsetX+60+this.domGetHomepageStandard.offsetLeft>=this.objNavigationBarUI.domRightArrow.offsetLeft  && !dojo.hasClass(this.objNavigationBarUI.domRightArrow, "hide")) {
			if(this.arrowRightOverLock!==true) {
				this.arrowRightOverLock = true;
				this.objNavigationBarUI.next();

				this.offsetX = this.offsetX+720;
			}
		}
		else {
			this.arrowRightOverLock = false;
		}
		ev2.l = ev2.l+this.offsetX;
	},

	eventMoved : function(ev, ev2) {
		this.xPos = ev2.l+this.offsetX;
		this.yPos = ev2.t;
	},

	eventStopMove : function (ev) {
		var destPos = this.searchlocation();
			this.makeUneditable(true);
		if(destPos!=null) {
			webapp.homepage.data.moveKeys(this.srcPos, destPos);
		}
		this.updateKeys();
			this.makeEditable();
	},


	searchlocation : function() {
		var res = null;
		for(var ind in this.arrDomPositions) {
			var dom = this.arrDomPositions[ind];
				//Check y coordonne
			if(this.domKeySrc.offsetTop >= dom.offsetTop-this.locationMarginY/2-dom.offsetHeight/2  &&  this.domKeySrc.offsetTop < dom.offsetTop+this.locationMarginY/2+dom.offsetHeight/2) {
					//Check x coordonne if placement is button
				if(this.arrObjKeys[ind] && ind!== this.srcPos) {
					if(this.domKeySrc.offsetLeft >= dom.offsetLeft-(this.locationMarginX+dom.offsetWidth)  &&  this.domKeySrc.offsetLeft < dom.offsetLeft) {
					res = ind;
					break;
				}
			}
					//Check x coordonne if placement is void
			else {
					if(this.domKeySrc.offsetLeft >= dom.offsetLeft-(this.locationMarginX+dom.offsetWidth)  &&  this.domKeySrc.offsetLeft < dom.offsetLeft+(this.locationMarginX+dom.offsetWidth)/2) {
							res = ind;
						break;
					}
				}
					}
				}
		if (res === this.srcPos) res=null;
		return parseInt(res);
	},



	/*
	 * Start timer. Deactivate the edition mode if user is inactive during this._timerEditionDuration(ms)
	 */
	startTimer : function(){
		clearTimeout(this._timerEdition);
		var that = this;
		var func = function () {
			that.makeUneditable();
		};
		this._timerEdition = setTimeout(func, this._timerEditionDuration);
	},
	/*
	 * Stop timer. (User activity)
	 */
	stopTimer : function(){
		clearTimeout(this._timerEdition);
	}



});
