dojo.provide("webapp.homepage.getHomepagePreviewBase");
dojo.declare("webapp.homepage.getHomepagePreviewBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		objPreview				: null,
		arrPreviewsWidget		: [],
		objAppBar				: null,
		objStandard				: null,
		arrAppDisplayedPreview	: [],
		previewList				: [],
		/* subscribe */
		_hPreviewsListUpdated	: null,
		_hAppButtonListUpdated	: null,
		_languageChanged		: null,


		constructor: function() {

		},

		postCreate:function() {
			var divNode = dojo.create("div", {}, this.domGetHomepagePreview);
			this.objPreview = webapp.homepage.previewControl = new UIElements.ApplicationMode.PreviewControl(
			{
			},divNode);
			this.updateAppButtonsList();
			this.updatePreviewsList();
		},

		enableSubscribe : function() {
			this._hPreviewsListUpdated = this.subscribe("homepage/previewsListUpdated", this.updatePreviewsList);
			this._hAppButtonListUpdated = this.subscribe("homepage/appButtonListUpdated", this.updateAppButtonsList);
			this._languageChanged = this.subscribe("languageChanged",this.applyDMTranslation);
		},

		disableSubscribe : function() {
			this.unsubscribe(this._hPreviewsListUpdated);
			this.unsubscribe(this._hAppButtonListUpdated);
			this.unsubscribe(this._languageChanged);
		},
			// set webapp homepage css for iframe
			firstLoad : function(frag, strName) {
                    var that = this;
                    var func = function(){
						ICTouchAPI.skinServices.registerHeader(this.contentDocument.head,"webapp."+strName,"webapp",this);
						this.contentDocument.body.appendChild(frag);
                        this.removeEventListener('load', func, false);
						that.previewList = that.getPreviewsList();
                    };
                    return func;
                },

       /**
		 * Register every preview container from data (Used by setting homepage mode)
		 */
		updatePreviewsList : function(){
			var that = this;

			/*
			 * Bufferize the update so we do not make more than one reload during a short time.
			 * It prevents some display problems where previews were doubled, not well destroyed... and so on.
			 */
			if(this._hUpdatePreviewList){
				clearTimeout(this._hUpdatePreviewList);
				this._hUpdatePreviewList = null;
			}
			
			
			this._hUpdatePreviewList = setTimeout(function(){that._updatePreviewsList();},700)
		},

		_updatePreviewsList : function(){
			//this.previewList = this.getPreviewsList();
			//this.destroyPreviewsList();
			var newList = this.webapp.data.getArrDisplayablePreviews();
			var item = null;

			// Remove all previews which are no more present
			for(var i=0 ; i<this.arrAppDisplayedPreview.length ; i++){
				item = this.arrAppDisplayedPreview[i];
				if(item && !this.isInArray(item.strWebapp, newList)){
					this.destroyPreview(i);
					this.arrAppDisplayedPreview.splice(i,1);
					i--;
				}
			}

			// Add new previews
			var funcAdd = function (item, idx) {
				if(item && !this.isInArray(item.strWebapp, this.arrAppDisplayedPreview)){
					var strWebapp = item.strWebapp;
					var frag = document.createDocumentFragment();
					var div = dojo.create("div", { }, frag);
					item.objWebapp.setHomepageContainer(strWebapp, div);
					this.addPreviewToList(frag, idx, strWebapp.split(".")[2], item);
				}
			};
			newList.forEach(funcAdd, this);
		},

		isInArray : function(strWebapp, arrList) {
			for(var i = 0 ; i < arrList.length ; i++){
				if(arrList[i] && arrList[i].strWebapp == strWebapp){
					return true;
				}
			}
			return false;
		},

		addPreviewToList : function(frag, pos, strName, item) {
			this.objPreview.addPreview(frag, pos, this.firstLoad(frag, strName));
			this.arrAppDisplayedPreview.splice(pos, 0, item);
			this.previewList = this.getPreviewsList();
		},

                getPreviewsList : function () {
		  return dojo.query("li.ZonePreview", this.objPreview.domNode);
                },

                destroyPreviewsList : function () {
                    for(var i=0; i<this.previewList.length; i++) {
                            dojo.destroy(this.previewList[i]);
                    }
					this.previewList = this.getPreviewsList();
                },

		destroyPreview : function(idx){
			 if(idx != undefined && idx < this.previewList.length){
				// Destroy content of iframe first
				dojo.query("iframe", this.previewList[idx]).forEach(function(iframe){
					ICTouchAPI.skinServices.unregisterHeader(iframe);
					ICTouchAPI.tools.destroyWidgets(iframe.contentDocument.body);
				})
				// Remove preview from dom
				dojo.destroy(this.previewList[idx]);
			}
			this.previewList = this.getPreviewsList();
		},


		/**
		* Register every app button from data (Used by setting homepage mode)
		*/
		updateAppButtonsList:function(){
			var objAppBar = ICTouchAPI.AppBarServices.getAppBar("homepage", "getHomepage");
			objAppBar.removeAllActionButtons();

			var arrAppButton = webapp.homepage.data.getAppBarAppButtons();
			for(var i in arrAppButton) {
				var newButton = arrAppButton[i];
				if (newButton == null || webapp.homepage.data._arrButtons[i]==null) {
				}
				else {
					if (newButton.callback == null) {
						newButton.callback = function() {
							ICTouchAPI.transitionServices.getScreen({name : newButton.strWidgetAccess, params : {}});
						};
					}
					var objButton = new UIElements.AppButton.AppButtonControl(newButton);
					//Don't remove this if, it's used to bypass a VHE Webkit bug
					if(!objAppBar.getButton(newButton.strButtonName)) {
					objAppBar.addActionButton(objButton);
				}
			}
			}
			this.applyDMTranslation();
		},


		//Change label with DM translation if exist
		applyDMTranslation : function() {
			var i;
			if(this.webapp.data.extProgKeysLocalisation) {
				var currentLocal = ICTouchAPI.i18nServices.getLocale();
				var appBar = ICTouchAPI.AppBarServices.getAppBar("homepage", "getHomepage");
				var appBarButtons = appBar.getAllButtons();
				for(i in this.webapp.data._arrAppButtons) {
					var tmpLabel;
					var button = this.webapp.data._arrAppButtons[i];
					if(button && button.strButtonLabel) {
						if (button.strButtonLabel.isI18Ned){
							tmpLabel = button.strButtonLabel.toTranslate;
						}
						else {
							tmpLabel = button.strButtonLabel;
						}
						if(this.webapp.data.extProgKeysLocalisation[currentLocal]
								&& this.webapp.data.extProgKeysLocalisation[currentLocal][tmpLabel]
								&& appBarButtons[i]!=null){
							var newLabel = this.webapp.data.extProgKeysLocalisation[currentLocal][tmpLabel];
							appBarButtons[i].attr("strButtonLabel", newLabel);
						}
					}
				}
			}
		}


	}
);
