dojo.require("webapp.homepage.getHomepagePreviewBase");
dojo.provide("webapp.homepage.getHomepagePreview");
dojo.declare("webapp.homepage.getHomepagePreview",
    webapp.homepage.getHomepagePreviewBase,
    {
	_boolEditable					: false,
	_previewEdition					: null,
	_appBarEdition					: null,
	templatePath: dojo.moduleUrl("webapp.homepage","templates/getHomepagePreview8082.html"),
	/* Subscribe */
	_hEditMode						: null,
	_hNormalMode						: null,
	/* edit mode */
	 _timerEdition					: null,
	_timerEditionDuration			: 10000,
	objTimer						: null,
	/* edit mode appBar */
	_moveableEventsAppBar			: null,
	_moveableElemAppBar				: null,
	_moveableDivAppBar				: null,
	xPosAppBar						: null,
	srcNameAppBar					: null,
	srcPosAppBar					: null,
	srcNodeAppBar					: null,
	domAppBar						: null,
	domAppBarScroll					: null,
	domButtons						: null,
	hideButtons						: null,
	/* edit mode previews */
	_moveableEventsPreviews			: null,
	_moveableElemPreviews			: null,
	_moveableDivPreviews			: null,
	xPosPreviews					: null,
	srcPosPreviews					: null,
	domPreviewContainer				: null,
	domPreview						: null,
	maskDivPreview					: null,


	constructor : function()
    {

		/*for(var j=0;j < webapp.homepage.data._arrAppPreviews.length;j++){
			if (webapp.homepage.data._arrAppPreviews[j] == null) {
				webapp.homepage.data._arrAppPreviews.splice(j,1);
				j--;
			}
		}*/
    },

	enableSubscribe : function() {
		this.inherited(arguments);
		this._hEditMode = dojo.subscribe("homepage/editMode",this,this.makeEditable);
		this._hNormalMode =  dojo.subscribe("homepage/normalMode",this,this.makeUneditable);
	},

	disableSubscribe : function() {
		this.inherited(arguments);
		dojo.unsubscribe(this._hEditMode);
	    dojo.unsubscribe(this._hNormalMode);
	},


	/**
	 * This function is used by "connect" function into loop.
	 **/
	hpStopPropagation : function(e) {
			e.stopPropagation();
	},


//******************************************************************************************************
//*                                         Edit Mode                                                  *
//******************************************************************************************************


	/*
	 * Start timer. Deactivate the edition mode if user is inactive during this._timerEditionDuration(ms)
	 */
	startTimer : function() {
		clearTimeout(this._timerEdition);
		var that = this;
		var func = function () {
			that.makeUneditable();
		};
		this._timerEdition = setTimeout(func, this._timerEditionDuration);
	},
	/*
	 * Stop timer. (User activity)
	 */
	stopTimer : function() {
		clearTimeout(this._timerEdition);
	},

	/*
	 * Homepage edition mode
	 * Start the edition timer (10s of inactivity deactivate edition mode
	 */
	makeEditable : function() {
		var that = this;
		var funcStopTimer = function(){that.stopTimer()} ;
		var funcReloadTimer = function() {that.startTimer()};
		//Object Timer for the homepage.edition objects
		this.objTimer = {
			stop : funcStopTimer,
			start : funcReloadTimer
		};
		this.makeEditableAppBar();
		this.makeEditablePreview();
		this.startTimer();
		//Hide appBar external button
		var otherButtons = ICTouchAPI.AppBarServices.getAppBar("homepage", "getHomepage").arrOtherWebAppButtons;
		this.hideButtons = [];
		var iMax = otherButtons.length;
		for(var i=0; i<iMax; i++) {
			if (dojo.style(otherButtons[i], "display")!=="none" && dojo.style(otherButtons[i], "visibility")!=="hidden") {
				otherButtons[i].hide();
				this.hideButtons.push(otherButtons[i]);
			}
		}
	},

	/*
	 * Reactivate homepage normal mode.
	 */
	makeUneditable : function(reload){
		this.makeUneditableAppBar();
		this.makeUneditablePreview();
		this.objTimer.stop();
		//Reshow hidden other button
		var iMax =this.hideButtons.length;
		for(var i=0; i<iMax; i++) {
			this.hideButtons[i].show();
		}
		this.updateAppButtonsList();
		//Save keys position, reload homepage and return to settings
		if (reload !== true) {
			webapp.homepage.data.cleanButtons();
			ICTouchAPI.settingServices.setSettingValue("HomepageButtons", webapp.homepage.data._arrButtons,this);
			//ICTouchAPI.settingServices.setSettingValue("HomepageContainers", webapp.homepage.data._arrPreviews,this);
			//Display preview
			ICTouchAPI.transitionServices.getScreen({name: "webapp.settings.getSettings", params: {delay: 20}});
		}
	},




	//------------------------------------ Edit Mode for appBar ---------------------------------------

	makeEditableAppBar : function() {
		//Element to destroy at end of edit
		this._moveableDivAppBar = [];
		this._moveableElemAppBar = [];
		this._moveableEventsAppBar = [];
		//Dom
		this.domAppBar = dojo.query(".webappButtons", ICTouchAPI.AppBarServices.getAppBar("homepage", "getHomepage").domNode)[0];
		this.domButtons = dojo.query(">li", ICTouchAPI.AppBarServices.getAppBar("homepage", "getHomepage").domButtons);
		this.domAppBarScroll = ICTouchAPI.AppBarServices.getAppBar("homepage", "getHomepage").domScroll;
		//Event for timer gestion
		var event = dojo.connect(ICTouchAPI.AppBarServices.getAppBar("homepage", "getHomepage").domButtons, "onmousedown", this, this.objTimer.stop());
		this._moveableEventsAppBar.push(event);
		event = dojo.connect(ICTouchAPI.AppBarServices.getAppBar("homepage", "getHomepage").domButtons, "onmouseup", this, this.objTimer.start());
		this._moveableEventsAppBar.push(event);
		ICTouchAPI.AppBarServices.getAppBar("homepage", "getHomepage").domNode.addEventListener("mousedown",this.eventMouseDownAppBar, true);

		//Create mask div on displayed buttons and add moveable div in front
		for (var i=0; i<this.domButtons.length; i++) {
			if (dojo.style(this.domButtons[i], "display")!=="none" && dojo.style(this.domButtons[i], "visibility")!=="hidden") {
				var elt = dojo.create("div", {});
				elt.setAttribute("buttonname", this.domButtons[i].getAttribute("buttonname"));
				elt.setAttribute("position", i);
				dojo.place(elt, this.domButtons[i], "after");
				this._moveableDivAppBar.push(elt);
				elt.style.position="absolute";
				elt.style.height=this.domButtons[i].offsetHeight+"px";
				elt.style.width=this.domButtons[i].offsetWidth+"px";
				elt.style.left=this.domButtons[i].offsetLeft+"px";
				elt.style.top=this.domButtons[i].offsetTop+"px";
				elt.style.zIndex="100";
				dojo.style(elt, "z-index", "50");
				dojo.addClass(elt, "handler");

				this._moveableEventsAppBar.push(event);
				event = dojo.connect(elt,"onclick", this, this.hpStopPropagation);
				this._moveableEventsAppBar.push(event);
				var moveable = new dojo.dnd.Moveable(elt, {delay: 2 , handle: elt});
				this._moveableElemAppBar.push(moveable);
				event = dojo.connect(moveable, "onDragDetected", this, this.eventDragStartAppBar);
				this._moveableEventsAppBar.push(event);
				event = dojo.connect(moveable, "onMoving", this, this.eventMovingAppBar);
				this._moveableEventsAppBar.push(event);
				event = dojo.connect(moveable, "onMoved", this, this.eventMovedAppBar);
				this._moveableEventsAppBar.push(event);
				event = dojo.connect(moveable, "onMoveStop", this, this.eventStopMoveAppBar);
				this._moveableEventsAppBar.push(event);
			}
		}
		this.startTimer();
	},

	makeUneditableAppBar : function() {
		ICTouchAPI.AppBarServices.getAppBar("homepage", "getHomepage").domNode.removeEventListener("mousedown", this.eventMouseDownAppBar, true);
		var i;
		var IctScroll = ICTouchAPI.AppBarServices.getAppBar("homepage", "getHomepage").domScroll.IctScroll;
		IctScroll.setDisableScroll(false);
		this.objTimer.stop();
		//destroy data of dnd.move and events
		for(i in this._moveableEventsAppBar) {
			dojo.disconnect(this._moveableEventsAppBar[i]);
		}
		for(i in this._moveableElemAppBar) {
			this._moveableElemAppBar[i].destroy();
		}
		for(i in this._moveableDivAppBar) {
			dojo.destroy(this._moveableDivAppBar[i]);
		}
		this._moveableElemAppBar = null;
		this._moveableEventsAppBar = null;
		this.updateAppButtonsList();
	},


	eventMouseDownAppBar : function(ev) {
		//Disable Scroll if target element is DND handler
		if(dojo.hasClass(ev.target, "handler")) {
			var IctScroll = ICTouchAPI.AppBarServices.getAppBar("homepage", "getHomepage").domScroll.IctScroll;
			IctScroll.setDisableScroll(true);
		}
	},

	eventDragStartAppBar : function(ev) {
		this.objTimer.stop();
		ev.stopPropagation();
		var node = ev.target;
		//Store this source node
		this.srcNodeAppBar = node;
		dojo.style(node, "z-index", "200");
		this.srcNameAppBar = node.getAttribute("buttonname");
		//Hide original button and display button content on this div
		var buttonDom = this.domButtons[node.getAttribute("position")];
		node.innerHTML = buttonDom.outerHTML;
		dojo.style(buttonDom, "visibility", "hidden");
		//Add event when we leave appBar area
		var event = dojo.connect(this.domAppBar, "onmouseleave", this, this.eventMouseLeaveAppBar);
		this._moveableEventsAppBar.push(event);
	},


	eventMovingAppBar : function(ev, ev2) {
		ev2.t = 0;
	},

	eventMovedAppBar : function(ev, ev2) {
		this.xPosAppBar = ev2.l + this.domAppBarScroll.scrollLeft;
	},

	eventMouseLeaveAppBar : function(ev) {
		this.makeUneditableAppBar();
		this.makeEditableAppBar();
	},

	eventStopMoveAppBar : function (ev) {
		//re-enable scroll
		var appBar = ICTouchAPI.AppBarServices.getAppBar("homepage", "getHomepage");
		var IctScroll = appBar.domScroll.IctScroll;
		IctScroll.setDisableScroll(false);
		//search destination
		var dropPosition = this.searchCaseAppBar();
		if(dropPosition!=null && dropPosition!=="") {
			var dropName = this.domButtons[dropPosition].getAttribute("buttonname");
			webapp.homepage.data.moveButtons(this.srcNameAppBar, dropName);
		}
		//Reload appbar
		this.makeUneditableAppBar();
		this.makeEditableAppBar();
	},

	searchCaseAppBar : function() {
		var res = 0;
		var i;
		var x = this.xPosAppBar - this.domAppBarScroll.scrollLeft;
		//Compare actual position with buttons positions
		for(i = 0; i <= this.domButtons.length - 1; i++) {
			if (dojo.style(this.domButtons[i], "display")!=="none" && dojo.style(this.domButtons[i], "visibility")!=="hidden"
				&& this.srcNameAppBar!==this.domButtons[i].getAttribute("buttonname") && x>=this.domButtons[i].offsetLeft) {
				res = i;
			}
		}
		return res;
	},



	//------------------------------------ Edit Mode for previews ------------------------------------


	makeEditablePreview : function() {
		//Element to destroy after edition
		this._moveableDivPreviews = [];
		this._moveableElemPreviews = [];
		this._moveableEventsPreviews = [];
		//DOM
		this.domPreviewContainer = dojo.query("ul.MainContent_PreviewList", this.objPreview.domNode)[0];
		this.domPreview = dojo.query("li.ZonePreview", this.objPreview.domPreviewList);
		//Event to manage timer
		var event = dojo.connect(this.objPreview.domScroll, "onmousedown", this, this.objTimer.stop);
		this._moveableEventsPreviews.push(event);
		event = dojo.connect(this.objPreview.domScroll, "onmouseup", this, this.objTimer.start);
		this._moveableEventsPreviews.push(event);
		this.objPreview.domNode.addEventListener("mousedown", this.eventMouseDownPreview, true);
		//Add mask onn previews zone
		var elt = dojo.create("div", {});
		dojo.place(elt, this.domPreviewContainer, "first");
		this._moveableDivPreviews.push(elt);
		elt.style.position="absolute";
		elt.style.height="100%";
		elt.style.width=this.domPreviewContainer.scrollWidth+"px";
		elt.style.zIndex="100";
		dojo.style(elt, "z-index", "40");
		this.maskDivPreview = elt;

		//Addmask on preview
		for (var i=0; i<this.domPreview.length; i++) {
			//Create div mask in front on preview zone
			elt = dojo.create("div", {});
			dojo.place(elt, this.domPreview[i], "first");
			this._moveableDivPreviews.push(elt);
			elt.style.position="absolute";
			elt.style.height="100%";
			elt.style.width=this.domPreview[i].offsetWidth+"px";
			dojo.style(elt, "z-index", "50");
			dojo.addClass(elt, "handler");

			var iframe = dojo.query("iframe", this.domPreview[i])[0];
			event = dojo.connect(this.domPreview[i],"onclick", this, this.domPreview[i]);
			this._moveableEventsPreviews.push(event);
			//Create Moveable element
			var moveable = new dojo.dnd.Moveable(iframe, {delay: 2, handle:this.domPreview[i]});
			this._moveableElemPreviews.push(moveable);
			event = dojo.connect(moveable, "onDragDetected", this, this.eventDragStartPreview);
			this._moveableEventsPreviews.push(event);
			event = dojo.connect(moveable, "onMoving", this, this.eventMovingPreview);
			this._moveableEventsPreviews.push(event);
			event = dojo.connect(moveable, "onMoved", this, this.eventMovedPreview);
			this._moveableEventsPreviews.push(event);
			event = dojo.connect(moveable, "onMoveStop", this, this.eventStopMovePreview);
			this._moveableEventsPreviews.push(event);
		}
		this.startTimer();
	},



	makeUneditablePreview : function() {
		var i;
		this.objPreview.domNode.removeEventListener("mousedown", this.eventMouseDownPreview, true);
		var IctScroll = this.objPreview.domScroll.IctScroll;
		IctScroll.setDisableScroll(false);
		//destroy data of dnd.move and events
		for (i in this._moveableEventsPreviews) {
			dojo.disconnect(this._moveableEventsPreviews[i]);
		}
		for (i in this._moveableElemPreviews) {
			this._moveableElemPreviews[i].destroy();
		}
		for (i in this._moveableDivPreviews) {
			dojo.destroy(this._moveableDivPreviews[i]);
		}
		this._moveableElemPreviews = null;
		this._moveableEventsPreviews = null;
	},


	eventMouseDownPreview : function(ev) {
		//Disable Scroll if target element is DND handler
		if(dojo.hasClass(ev.target, "handler")) {
			var IctScroll = webapp.homepage.homepagePreviewView.objPreview.domScroll.IctScroll;
			IctScroll.setDisableScroll(true);
		}
	},

	eventDragStartPreview : function(ev) {
		//Get LI node
		var node = ev.target;
		while (node.tagName !== "LI" || dojo.hasClass(node, "ZonePreview") !== true) {
			// || node.getAttribute("widgetname")==""
			node = node.parentNode;
		}
		this.srcPosPreviews = node.getAttribute("position");
		var iframe = dojo.query("iframe", node)[0];
		dojo.style(node, "visibility", "hidden");
		dojo.style(iframe, "visibility", "visible");
		dojo.style(iframe, "background-color", dojo.style(node, "background-color"));
		//Add event when we leave preview area
		var event = dojo.connect(this.objPreview.domNode, "onmouseout", this, this.eventMouseOutPreview);
		this._moveableEventsPreviews.push(event);
		this.objTimer.stop();
	},

	eventMovingPreview: function(ev, ev2) {
		ev2.t = 0;
	},

	eventMovedPreview : function(ev, ev2) {
		this.xPosPreviews = ev2.l;
	},

	eventMouseOutPreview : function(ev) {
		if(ev.y<0 || ev.y>313) {
			this.eventStopMovePreview();
		}
	},

	eventStopMovePreview : function (ev) {
		//re-enable scroll
		var IctScroll = this.objPreview.domScroll.IctScroll;
		IctScroll.setDisableScroll(false);
		//Clean source preview
		var iframe = dojo.query("iframe", this.domPreview[this.srcPosPreviews])[0];
		iframe.removeAttribute("style");
		dojo.style(this.domPreview[this.srcPosPreviews], "visibility", "");
		//Search destination
		var destPos = this.searchCasePreview();
		if (destPos != null && destPos !== "") {
			if (this.srcPosPreviews !== destPos) {
				if(this.srcPosPreviews < destPos) {
					destPos-=1;
				}
				webapp.homepage.data.movePreview(this.srcPosPreviews, destPos);
				webapp.homepage.previewControl.movePreview(this.srcPosPreviews, destPos);
				var div = dojo.create("div", { });

				webapp.homepage.previewControl.replacePreview(destPos, this.firstLoad(destPos,div));
			}
		}

		//Reload appbar
		this.makeUneditablePreview();
		this.makeEditablePreview();
	},


	searchCasePreview : function() {
		var res = null;
		var i;
		//Compare actual position with previews positions
		if (this.srcPosPreviews !== 0 && this.xPosPreviews < this.domPreview[0].offsetLeft) {
			return 0;
		} else {
			for(i = 0; i <= this.domPreview.length-2; i++) {
				if(i !== this.srcPosPreviews) {
					if(this.xPosPreviews>=this.domPreview[i].offsetLeft && this.xPosPreviews<this.domPreview[i].offsetLeft+this.domPreview[i].offsetWidth) {
						res = i+1;
						break;
					}
				}
			}
			if(res!=null) {
				return res;
			}
			else {
				if (this.srcPosPreviews !== this.domPreview.length && this.xPosPreviews >= this.domPreview[this.domPreview.length - 1].offsetLeft) {
					return this.domPreview.length;
				}
			}
		}
		return null;
	}




});

