dojo.provide("webapp.homepage.getHomepageBase");
dojo.declare("webapp.homepage.getHomepageBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
    {

		boolCurrentHomepage: null,
		exclusiveIframe: true,

		constructor: function() {

		},

		postCreate:function() {
			webapp.homepage.homepageView = this;			
			this.createHomepages();
			this.loadHomepage(webapp.homepage.data.homepagePreviewMode);
			ICTouchAPI.settingServices.subscribeToSetting(webapp.homepage, "HomepagePreviewMode", webapp.homepage.previewModeChanged);			
		},


		loadHomepage:function(value) {
			if(value!=null) {
				var objAppBar = ICTouchAPI.AppBarServices.getAppBar("homepage", "getHomepage");
				//Load homepage preview
				if (value === true) {
					if(value!==this.currentHomepage) {
						//Reload appBar
						webapp.homepage.homepagePreviewView.updateAppButtonsList();
						//If exist, hide homepage standard
						if (webapp.homepage.homepageStandardView != null) {
							webapp.homepage.homepageStandardView.disableSubscribe();
							dojo.style(webapp.homepage.homepageStandardView.domNode, "display", "none");
						}
						//Reenable sunscribe
						webapp.homepage.homepagePreviewView.enableSubscribe();
						//Show homepage preview and appBar
						dojo.style(webapp.homepage.homepagePreviewView.domNode, "display", "");
						dojo.style(objAppBar.domNode, "display", "");
						this.currentHomepage = true;
						var domHomepage = document.getElementById("webapp.homepage.getHomepage");
						if(domHomepage){
							dojo.removeClass(domHomepage, "slideHomepageStandard");
					}
					}
					else {
						//Reload appBar
						webapp.homepage.homepagePreviewView.updateAppButtonsList();
					}
				}

				//Load homepage standard
				else {
					if(value!==this.currentHomepage) {						
						//Refresh homepage standard
						webapp.homepage.homepageStandardView.reload();
						//If exist, hide homepage preview and disable subscribe
						if (webapp.homepage.homepagePreviewView != null) {
							webapp.homepage.homepagePreviewView.disableSubscribe();
							dojo.style(webapp.homepage.homepagePreviewView.domNode, "display", "none");
						}
						//reenable subscribe
						webapp.homepage.homepageStandardView.enableSubscribe();
						//Show homepage standard
						dojo.style(webapp.homepage.homepageStandardView.domNode, "display", "");
						//Clear appBar
						objAppBar.removeAllActionButtons();
						dojo.style(objAppBar.domNode, "display", "none");
						this.currentHomepage = false;
						var domHomepage = document.getElementById("webapp.homepage.getHomepage");
						if(domHomepage){
							/* z-index change to allow changing page by slide on the bottom of homepage standard */
							dojo.addClass(domHomepage, "slideHomepageStandard");
					}
						
					}
					else {
						//Refresh homepage standard
						webapp.homepage.homepageStandardView.reload();
					}
				}
				//Publish an event in order to refresh buttons with status like wakeup
				dojo.publish("homepage/refreshHomepage");
			}
			else {
				var that=this;
				var func = function () {
					that.loadHomepage(webapp.homepage.data.homepagePreviewMode);
				};
				setTimeout(func, 100);
			}
		},

		createHomepages : function() {
			var	node = dojo.create("div", null, this.domGetHomepage);
			webapp.homepage.homepagePreviewView = new webapp.homepage.getHomepagePreview({}, node);
			node = dojo.create("div", null, this.domGetHomepage);
			webapp.homepage.homepageStandardView = new webapp.homepage.getHomepageStandard({}, node);
		},


    }
    );
