dojo.provide("webapp.homepage.dataBase");
dojo.declare("webapp.homepage.dataBase",null,{


	homepagePreviewMode			: null,		//Preview or standard mode?
	homepagePreviewAutoFill		: true,
	homepageStandardAutoFill	: true,
    // Member data used for object construction
	_arrButtons				: [],
    _arrAppButtons          : [],
	// Order of keys, contains strings with idKeys. reflect of setting HomepageKeys.
	_arrKeys				: [],
	// Contains objects corresponding to idKeys from _arrKeys.
	_arrAppKeys				: [],
	// Contain DM progkeys from setting HomepageProgKeys
	_arrProgKeys			: [],
	_arrStatus				: [],
	_arrPreviews            : [],
    _arrAppPreviews         : [],
	_arrSubscribe			: [],
	boolSubscriptionDone	: false,
	buttonsComplete			: false,
	keysComplete			: false,
	progKeysComplete		: false,
	//Standard homepage button type contante
	WEBAPP					: 1,
	PROGKEYS				: 2,
        //LED
        //homeLed : null,
	// translated labels for homepage icons
	extProgKeysLocalisation : [],
	_loadedSkin				: [],
	//Semaphore for Buttons list setting
	intButtonsSettingSemaphore		: 0,

    constructor : function(){
                //this.homeLed = ICTouchAPI.feedbackServices.senskeyServices.getLED('home');
                //this.homeLed.setDelay(0,0,500);
                /*this.homeLed.addMode('STANDBY',dojo.hitch(this,function(){
                        this.homeLed.setColor('green');
                        this.homeLed.switchMode('ON');
                        this.homeLed.setCurrentMode('STANDBY');
                    }
                }));*/
                /*this.homeLed.addMode('SYSERR',dojo.hitch(this,function(){
                        this.homeLed.setColor('red');
                        this.homeLed.switchMode('ON');
                        this.homeLed.setCurrentMode('SYSERR');
                    }
                }));*/
                /*this.homeLed.addMode('ONCLICK',dojo.hitch(this,function(){
                        this.homeLed.setColor('blue');
                        this.homeLed.switchMode('ON');
                        this.homeLed.setCurrentMode('ONCLICK');
                    }
                }));*/
                /*this.homeLed.addMode('OFF_OWNER',dojo.hitch(this,function(){
                        this.homeLed.setColor('blue');
                        this.homeLed.switchMode('OFFTIMER');
                        this.homeLed.setCurrentMode('OFF_OWNER');
                    }
                }));*/
		var h;
		ICTouchAPI.settingServices.getSettingValue("HomepagePreviewMode", this, this._previewModeReceived);
		ICTouchAPI.settingServices.getSettingValue("HomepagePreviewAutoFill", this, this._homepagePreviewAutoFillReceived);
		ICTouchAPI.settingServices.getSettingValue("HomepageStandardAutoFill", this, this._homepageStandardAutoFillReceived);
		// get translated labels if any of the homepage keys HomepageProgKeysLocalisation
		ICTouchAPI.settingServices.getSettingValue("HomepageProgKeysLocalisation", this, this._getHomepageProgKeysLocalisation);
		ICTouchAPI.settingServices.getSettingValue("HomepageShowSwitchButtons", this, this._homepageShowSwitchButtons);
		this._arrAppPreviews = [];
		//this._arrAppPreviews = {};
		this._arrAppButtons = [];

		h = dojo.subscribe("homepage/appButtonListUpdated", this, function() {
				this.loadedButtonComplete();
		});
		this._arrSubscribe.push(h);

		h = dojo.subscribe("homepage/appKeyListUpdated", this, function() {
				this.loadedButtonComplete();
		});
		this._arrSubscribe.push(h);

		h = dojo.subscribe("homepage/appProgKeyListUpdated", this, function() {
				this.loadedButtonComplete();
		});
		this._arrSubscribe.push(h);
	},

	getApplicationName : function() {
		return "homepage";
	},

	_previewModeReceived : function(homepagePreviewMode) {
		if (homepagePreviewMode === false) {
			this.homepagePreviewMode = false;
        } else {
			this.homepagePreviewMode = true;
		}
	},

	_homepagePreviewAutoFillReceived : function(homepagePreviewAutoFill) {
		if (homepagePreviewAutoFill === false) {
			this.homepagePreviewAutoFill = false;
		} else {
			this.homepagePreviewAutoFill = true;
		}
	},

	_homepageStandardAutoFillReceived : function(homepageStandardAutoFill) {
		if (homepageStandardAutoFill === false) {
			this.homepageStandardAutoFill = false;
		} else {
			this.homepageStandardAutoFill = true;
		}
	},

    _getHomepageProgKeysLocalisation : function (value) {
		try {
			if(value){
				this.extProgKeysLocalisation = dojo.fromJson(value);
			}
		} catch(err) {
			//alert("Error in _getHomepageProgKeysLocalisation : "+err.description);
		}
    },

	_homepageShowSwitchButtons : function(value) {
		if(value) {
			var func = function() {				
				webapp.homepage.previewModeChanged(true);
			}
			ICTouchAPI.tools.registerHomepageKey(["webapp.homepage.getHomepage", "HOMEPAGE_PREVIEW_BTN", "generic-homepage2", _('Advanced',"webapp.homepage"), null, func]);
			func = function() {
				webapp.homepage.previewModeChanged(false);
			}
			ICTouchAPI.tools.registerHomepageButton(["webapp.homepage.getHomepage", "HOMEPAGE_STANDARD_BTN", "generic-homepage", _("Home", "ICTouchAPI"), null, func]);
		}
	},

    /**
    * Get the homepage previewsList from the setting "HomepageContainers"
    */
    loadPreviewsList : function(){
        ICTouchAPI.settingServices.getSettingValue("HomepageContainers", this, this.loadedPreviewsList, { });
    },

    /**
    * Callback for SettingsManager (loadPreviewsList) : Register homepage previewsList in data object
    */
    loadedPreviewsList : function(previewsList) {
		var initialPreviewSupervision = ["webapp.supervision.getSupFirstPreview", "webapp.supervision.getSupSecondPreview", "webapp.supervision.getSupThirdPreview"];
		if (previewsList !== undefined && previewsList !== null && previewsList.length && typeof(previewsList) !== "string") {
			this._arrPreviews = initialPreviewSupervision.concat(previewsList);
		} else {
			this._arrPreviews = initialPreviewSupervision.concat([]);
			console.warn("An error occured when trying to load setting HomepageContainers");
		}

		for(var i=0;i<this._arrPreviews.length;++i)
		{
			this._arrAppPreviews.push(null);
		}

		/*dojo.forEach(arrStrPreviews,function(strPreview){
			var objPreview=dojo.fromJson(strPreview);
			this._arrPreviews.push(objPreview);
		}, this);*/
		dojo.publish("homepage/previewsListUpdated");
    },

    getArrPreviews : function () {
        return this._arrAppPreviews;
    },

    getPreview : function (pos) {
        return this._arrAppPreviews[pos];
    },

	/*
	 * Get a list of displayable previews
	 * Constraints :
	 * - no favorite if there is supervision.
	 * - managerassistant always displayed, and in last place.
	 */
	getArrDisplayablePreviews : function() {
		var arrDisplayablePreviews = [];
		var MAPlace = this.searchArrAppPreview('webapp.managerassistant.getManagerPreview');
		var isSupervision = (this.searchArrAppPreview('webapp.supervision.getSupFirstPreview') !== null);
		var intMaxPreview = 3;
		var isMAAdded = false;

		for(var i = 0 ; i < this._arrAppPreviews.length && arrDisplayablePreviews.length < intMaxPreview ; i++){
			if(!this._arrAppPreviews[i] || (this._arrAppPreviews[i].strWebapp == "webapp.contacts.getContactPreview" && isSupervision)){
				continue;
			}
			arrDisplayablePreviews.push(this._arrAppPreviews[i]);
			if(this._arrAppPreviews[i].strWebapp == 'webapp.managerassistant.getManagerPreview'){
				isMAAdded = true;
			}
		}

		if(!isMAAdded && MAPlace !== null){
			arrDisplayablePreviews.splice(intMaxPreview - 1, 1, this._arrAppPreviews[MAPlace]);
		}

		return arrDisplayablePreviews;
	},

    /**
    * Get the homepage appButtonsList from the setting "HomepageButtons"
    */
    loadAppButtonsList : function(){
        ICTouchAPI.settingServices.getSettingValue("HomepageButtons", this, this.loadedAppButtonsListFirst, { });
		this.intButtonsSettingSemaphore = 0;
		ICTouchAPI.settingServices.subscribeToSetting(this,"HomepageButtons", this.loadedAppButtonsList);
    },

	 /**
    * Get the homepage appKeysList from the setting "HomepageButtons"
    */
    loadAppKeysList : function(){
        ICTouchAPI.settingServices.getSettingValue("HomepageKeys", this, this.loadedAppKeysListFirst, { });
        ICTouchAPI.settingServices.getSettingValue("HomepageProgKeys", this, this.loadedAppProgKeysListFirst, { });
		ICTouchAPI.settingServices.subscribeToSetting( this, "HomepageKeys", this.loadedAppKeysList);
		ICTouchAPI.settingServices.subscribeToSetting( this, "HomepageProgKeys", this.loadedAppProgKeysList);
    },

    /**
    * Callback for SettingsManager (loadAppButtonsList): Register homepage buttonsList in data object
    */
    loadedAppButtonsListFirst : function(arrStrAppButtons){
		if (arrStrAppButtons !== undefined && arrStrAppButtons !== null && arrStrAppButtons.length && typeof(arrStrAppButtons) !== "string") {
			this._arrButtons = arrStrAppButtons;
		} else {
			this._arrButtons = [];
			console.warn("An error occured when trying to load setting HomepageButtons");
		}

		for(var i=0;i<this._arrButtons.length;++i)
		{
			this._arrAppButtons.push(null);
		}
		webapp.homepage.doSubscriptions();
		this.buttonsComplete = true;
		dojo.publish("homepage/appButtonListUpdated");
    },

	loadedAppButtonsList : function(objAppButtons) {
		if(this.intButtonsSettingSemaphore > 0) {
			this.intButtonsSettingSemaphore--;
		}
		if(this.intButtonsSettingSemaphore === 0) {
		this._arrButtons = objAppButtons.jsValue;
		var arrAppButtonsTmp = new Array(this._arrButtons.length);
		var arrAppButtonsAddedTmp = [];
		var arrButtonsAddedTmp = [];
		var itemFind;
		for(var j=0; j<this._arrAppButtons.length; j++) {
			itemFind = false;
			for(var i=0;i<this._arrButtons.length && !itemFind;++i) {
				if (this._arrAppButtons[j] != null && this._arrAppButtons[j].strButtonName === this._arrButtons[i]) {
					//AJOUT a la position
					arrAppButtonsTmp[i]=this._arrAppButtons[j];
					itemFind=true;
					break;
				}
			}
			if(!itemFind  && this._arrAppButtons[j] != null && this.searchArrProgKeys(this._arrAppButtons[j].strButtonName)==null) {
				/*arrAppButtonsAddedTmp.push(this._arrAppButtons[j]);
				if (this.homepagePreviewAutoFill) {
				arrButtonsAddedTmp.push(this._arrAppButtons[j].strButtonName);
				}*/
				this._arrAppButtons[j] = null;
		}
		}
		this._arrAppButtons = arrAppButtonsTmp/*.concat(arrAppButtonsAddedTmp)*/;
		//this._arrButtons = this._arrButtons/*.concat(arrButtonsAddedTmp)*/;
		this.addProgkeysInAppbar();
		dojo.publish("homepage/appButtonListUpdated");
		}
	},


	/**
    * Callback for SettingsManager (loadAppKeysList): Register homepage KeysList in data object
    */
    loadedAppKeysListFirst : function(arrStrAppKeys) {
		if (arrStrAppKeys !== undefined && arrStrAppKeys !== null && arrStrAppKeys.length && typeof(arrStrAppKeys) !== "string") {
			this._arrKeys = this.updateOldSettings(arrStrAppKeys);
		} else {
			this._arrKeys = [];
			console.warn("An error occured when trying to load setting HomepageKeys, or there is no HomepageKey");
		}

		for(var i=0;i<this._arrKeys.length;++i)
		{
			this._arrAppKeys.push(null);
		}
		webapp.homepage.doSubscriptions();
		this.keysComplete = true;
		dojo.publish("homepage/appKeyListUpdated");
	},


	/**
    * Callback for SettingsManager (loadAppKeysList): Register homepage KeysList in data object
    */
    loadedAppKeysList : function(arrStrAppKeys) {
		var arrKeysTmp = [];
		if (arrStrAppKeys !== undefined && arrStrAppKeys !== null) {
			if(arrStrAppKeys.length && typeof(arrStrAppKeys) !== "string") {
				arrKeysTmp = this.updateOldSettings(arrStrAppKeys);
			} else if(typeof(arrStrAppKeys.value) == "string") {
				arrKeysTmp = this.updateOldSettings(arrStrAppKeys.value.split(';'));
				}
			}
		this._arrKeys = arrKeysTmp;
		this.sortArrProgKeysList();
		this.addProgkeysInStandardView();
    },


    /**
    * Callback for SettingsManager (loadAppProgKeysList): Register homepage KeysList in data object
    */
    loadedAppProgKeysListFirst : function(arrProgKeys) {
		if (arrProgKeys !== undefined && arrProgKeys !== null && arrProgKeys.length) {
			this._arrProgKeys = dojo.fromJson(arrProgKeys);
		}
		else {
			this._arrProgKeys = [];
			console.warn("An error occured when trying to load setting HomepageProgKeys");
		}
		webapp.homepage.doSubscriptions();
		this.progKeysComplete = true;
		dojo.publish("homepage/appProgKeyListUpdated");
    },


    /**
    * Callback for SettingsManager (loadAppProgKeysList): Register homepage KeysList in data object
    */
    loadedAppProgKeysList : function(arrProgKeys) {
		var arrProgKeysTmp = [];
		if (arrProgKeys !== undefined && arrProgKeys !== null) {
			if(arrProgKeys.length) {
				arrProgKeysTmp = dojo.fromJson(arrProgKeys);
			} else if(arrProgKeys.value.length) {
				arrProgKeysTmp = dojo.fromJson(arrProgKeys.value);
			}
		}
		this._arrProgKeys = arrProgKeysTmp;
		this.addProgkeysInAppbar();
		this.addProgkeysInStandardView();
		this.sortArrProgKeysList();
    },

	sortArrProgKeysList : function() {
		var arrAppKeysTmp = [];
		var arrAppKeysAddedTmp = [];
		var arrKeysAddedTmp = [];
		var itemFind;
		for(var j=0; j<this._arrAppKeys.length; j++) {
			itemFind = false;
			if (this._arrAppKeys[j] != null) {
				for(var i=0;i<this._arrKeys.length && !itemFind;++i) {
					if (this._arrAppKeys[j].strButtonName === this._arrKeys[i]) {
						//AJOUT a la position
						arrAppKeysTmp[i]=this._arrAppKeys[j];
						itemFind=true;
						break;
					}
				}
				if(!itemFind) {
					arrAppKeysAddedTmp.push(this._arrAppKeys[j]);
					if (this.homepageStandardAutoFill) {
					arrKeysAddedTmp.push(this._arrAppKeys[j].strButtonName);
					}
				}
			}
		}
		this._arrAppKeys = arrAppKeysTmp.concat(arrAppKeysAddedTmp);
		this._arrKeys = this._arrKeys.concat(arrKeysAddedTmp);
		if(webapp.homepage.homepageView) {
			webapp.homepage.homepageView.loadHomepage(this.homepagePreviewMode);
		}
		if(webapp.homepage.homepageEditView) {
			webapp.homepage.homepageEditView.reload();
		}
	},

	loadedButtonComplete : function() {
		if (this.keysComplete && this.progKeysComplete && this.buttonsComplete) {
			// Unsubscribe our events so we don't get called again
			var h;
			while(this._arrSubscribe.length) {
				h = this._arrSubscribe.pop();
				dojo.unsubscribe(h);
			}
			this.addProgkeysInAppbar();
			this.addProgkeysInStandardView();
			dojo.publish("HomepageLoaded");
		}
	},
	
    getAppBarAppButtons : function(){
		return this._arrAppButtons;
    },





	/*
	 * Find buttons with this id and return this position
	 */
	searchArrButtons : function(value) {
		value = value.toString();
		var res = null;
		if (value == null || value === "") {
			return null;
		}
		var idFound = false;
		var iMax = this._arrButtons.length;
		for(var i=0; i<iMax; i++) {
			if (this._arrButtons[i] == value) {
				idFound = true;
				res = i;
				break;
			}
		}
		if (idFound === true) {
			return parseInt(res);
		} else {
			return null;
		}
	},

	/*
	 * Find appButtons with this id and return this position
	 */
	searchArrAppButtons : function(value) {
		value = value.toString();
		var res = null;
		if (value == null || value === "") {
			return null;
		}
		var idFound = false;
		var iMax = this._arrAppButtons.length;
		for(var i=0; i<iMax; i++) {
			if( this._arrAppButtons[i] && this._arrAppButtons[i].strButtonName == value) {
				idFound = true;
				res = i;
				break;
			}
		}
		if (idFound === true) {
			return parseInt(res);
		} else {
			return null;
		}
	},

	/*
	 *	Remove not loaded webapp buttons
	 */
	cleanButtons : function() {
		for(var i=0;i<this._arrAppButtons.length;i++)	{
			if (webapp.homepage.data._arrAppButtons[i] == null) {
				webapp.homepage.data._arrAppButtons.splice(i,1);
				webapp.homepage.data._arrButtons.splice(i,1);
				i--;
			}
		}
	},

	/*
	 *	Move buttons into new positions with there names
	 */
	moveButtons : function(strSrc, strDest) {
		var i, iMax
		var srcAppButton = this.searchArrAppButtons(strSrc);
		var destAppButton = this.searchArrAppButtons(strDest);
			if(srcAppButton > destAppButton) {
					destAppButton++;
			}
			if (srcAppButton !== destAppButton) {
				AppButtonsLength = this._arrAppButtons.length;
				if(destAppButton >= AppButtonsLength) {
					destAppButton = AppButtonsLength-1;
				}
				var srcButton = this.searchArrButtons(strSrc);
				var destButton = this.searchArrButtons(strDest);
				if(srcButton > destButton) {
					destButton++;
				}
				//Save source position
				var tempButtons = this._arrButtons[srcButton];
				var tempAppButtons = this._arrAppButtons[srcAppButton];
				//Delete source position
				this._arrButtons.splice(srcButton, 1);
				this._arrAppButtons.splice(srcAppButton, 1);
				//Move buttons  to the right
				iMax = this._arrButtons.length;
				for (i = iMax - 1; i >= destButton; i--) {
					this._arrButtons[i+1] = this._arrButtons[i];
				}
				iMax = this._arrAppButtons.length;
				for(i = iMax - 1; i >= destButton; i--) {
					this._arrAppButtons[i+1] = this._arrAppButtons[i];
				}
				//Place destination at source position
				this._arrButtons[destButton] = tempButtons;
				this._arrAppButtons[destAppButton] = tempAppButtons;
			}
	},



	/*
	 * Find preview with id and return this position
	 */
	searchArrPreview : function(value) {
		value = value.toString();
		var res = null;
		if (value == null || value === "") {
			return null;
		}
		var idFound = false;
		for(var i in this._arrPreviews) {
			if (this._arrPreviews[i] === value) {
				idFound = true;
				res = i;
				break;
			}
		}
		if (idFound === true) {
			return res;
		} else {
			return null;
		}
	},

	/*
	 * Find preview with id and return this position
	 */
	searchArrAppPreview : function(value) {
		value = value.toString();
		var res = null;
		if (value == null || value === "") {
			return null;
		}
		var idFound = false;
		for(var i in this._arrAppPreviews) {
			if (this._arrAppPreviews[i] && this._arrAppPreviews[i].strWebapp === value) {
				idFound = true;
				res = i;
				break;
			}
		}
		if (idFound === true) {
			return res;
		} else {
			return null;
		}
	},

	movePreview : function(intSrc, intDest) {
		//Save source position
			var tempPreview = this._arrPreviews[intSrc];
			var tempAppPreview = this._arrAppPreviews[intSrc];
			//Delete source position
			this._arrPreviews.splice(intSrc, 1);
			this._arrAppPreviews.splice(intSrc, 1);
			//Move Preview  to the right
			var i, iMax = this._arrPreviews.length;
			for(i = iMax - 1; i >=intDest; i--) {
				this._arrPreviews[i+1] = this._arrPreviews[i];
				this._arrAppPreviews[i+1] = this._arrAppPreviews[i];
			}
			//Place destination at source position
			this._arrPreviews[intDest] = tempPreview;
			this._arrAppPreviews[intDest] = tempAppPreview;
	},


	/* Specific function for settings integrations */

	initForView : function(view) {
	},

	getActionBarAppButtonsFromView : function(view) {
		var func = function(buttonId) {webapp.homepage.callbackButtonEdit(buttonId)};
		var buttons;
		if (view === "webapp.homepage.getHomepageStandardEdit") {
			buttons = [
				{strButtonName: "ADD_BTN", strButtonLabel: _('Add', 'ICTouchAPI'), callback : func, strButtonIcon: 'generic-add'},
				{strButtonName: "DELETE_BTN", strButtonLabel: _('Delete', 'ICTouchAPI'), callback : func, strButtonIcon: 'generic-mode-delete', strStatusIcon:'notif-off'}
				];
		}
		return buttons;
	},

	initAppBarButtons : function(view) {
	},
	
	addWebappIcon : function(strWebapp) {
		var reg = /^[a-zA-Z1-9]+\.[a-zA-Z1-9]+/;
		var res = reg.exec(strWebapp);
		if(res) {
			var webappName = res[0];
			if(!this._loadedSkin[webappName]) {
				//ICTouchAPI.skinServices.linkWebappsStyles("webapp.homepage",webappName,true,false,true,false);
				this._loadedSkin[webappName] = true;
			}
		}
	},
	
	getAppKey : function() {
		return this._arrAppKeys;
	},

	getNbAppKeys : function() {
		var nbAppkeys = 0;
		for (var i in this._arrAppKeys) {
			if (this._arrAppKeys[i] != undefined) {
				++nbAppkeys;
			}
		}
		return nbAppkeys;
	},
	
	updateOldSettings : function(arrStrAppKeys){
		if(arrStrAppKeys != null){
			var found = false;
			for(var i=0;i<arrStrAppKeys.length;i++){
				if(arrStrAppKeys[i] == "COMMUNICATION_BTN") {
					arrStrAppKeys[i] = "HISTORY_BTN";
					found = true;
					break;
				}
			}
			if(found){
				ICTouchAPI.settingServices.setSettingValue("HomepageKeys", arrStrAppKeys,this);
			}
		}
		return arrStrAppKeys;
	}
});
