dojo.require("webapp.homepage.dataBase");
dojo.provide("webapp.homepage.data");
dojo.declare("webapp.homepage.data",webapp.homepage.dataBase,{

	boolDeleteKey : false,

	/*
	 * Find key with this id and return this position
	 */
	searchArrKeys : function(value) {
		value = value.toString();
		var res = null;
		if (value == null || value === "") {
			return null;
		}
		var idFound = false;
		for(var i in this._arrKeys) {
			if (this._arrKeys[i] === value) {
				idFound = true;
				res = i;
				break;
			}
		}
		if (idFound === true) {
			return res;
		} else {
			return null;
		}
	},

	/*
	 * Find homepage progKey with this id and return this position
	 */
	searchArrProgKeys : function(value) {
		value = value.toString();
		if (value == null || value === "") {
			return null;
		}
		var idFound = false;
		var res = null;
		for(var i in this._arrProgKeys) {
			if (this._arrProgKeys[i] != null && this._arrProgKeys[i].id === value) {
				idFound = true;
				res = i;
				break;
			}
		}

		if (idFound === true) {
			return res;
		} else {
			return null;
		}
	},

	/*
	 *	Move keys into new positions with there names
	 */
	moveKeys : function(strSrc, strDest) {
		if ((strDest != null && strDest !== "") && (strSrc !== strDest)) {
			if (this._arrKeys[strDest] != null && this._arrKeys[strDest] !== "") {
				//Search if destination is on left or right position of the source
				//var dom = this.domCase[strDest]["case"]; // unused ?
				this.insertKeyToPosition(strSrc, strDest);
			}
			//Action if destination is void
			else {
				this._arrKeys[strDest] = this._arrKeys[strSrc];
				this._arrKeys[strSrc] = "";
				this._arrAppKeys[strDest] = this._arrAppKeys[strSrc];
				this._arrAppKeys[strSrc] = "";
			}
		}
	},


	/*
	 *	insert key into specified position. Move other buttons.
	 */
	insertKeyToPosition : function(strSrc, strDest) {
		var leftRight="l", passe=0, voidPos=null, i;
		var tempKeys, tempAppKeys;
		for(passe=0; passe<=1 && voidPos==null; passe++) {
			//Defaut: move icon to the right
			if (leftRight === "l") {
				for(i = strDest; i < 72; i++) {
					if(i === strSrc || this._arrKeys[i] == null || this._arrKeys[i] === "") {
						voidPos = i;
						break;
					}
				}
				if (voidPos != null) {
					tempKeys = this._arrKeys[strSrc];
					tempAppKeys = this._arrAppKeys[strSrc];
					//Save and Delete source
					this._arrKeys[strSrc] = "";
					this._arrAppKeys[strSrc] = null;
					for(i = voidPos; i > strDest; i--) {
						//Shift buttons in right
						this._arrKeys[i] = this._arrKeys[i-1];
						this._arrAppKeys[i] = this._arrAppKeys[i-1];
					}
					//Move source to strDest
					this._arrKeys[strDest] = tempKeys;
					this._arrAppKeys[strDest] = tempAppKeys;
				}
			}
			//no void postion in the right, move icon to the left
			else {
				for (i = strDest; i >= 0; i--) {
					if (i === strSrc || this._arrKeys[i] == null || this._arrKeys[i] === "") {
						voidPos = i;
						break;
					}
				}
				if (voidPos != null) {
					tempKeys = this._arrKeys[strSrc];
					tempAppKeys = this._arrAppKeys[strSrc];
					//Save and Delete source
					this._arrKeys[strSrc] = "";
					this._arrAppKeys[strSrc] = null;
					for(i = voidPos; i < strDest; i++) {
						//Shift buttons in right
						this._arrKeys[i] = this._arrKeys[i+1];
						this._arrAppKeys[i] = this._arrAppKeys[i+1];
					}
					//Move source to strDest
					this._arrKeys[strDest] = tempKeys;
					this._arrAppKeys[strDest] = tempAppKeys;
				}
			}
			if (voidPos == null) {
				if (leftRight === "l") {
					leftRight = "r";
				} else {
					leftRight = "l";
				}
			}
		}
	},


    //Save keys in prokeys format into homepage Keys
    SaveProgkeys : function(editedProgKeys, editedProgActions) {
		//search a new id
		var newId;
		var stop = false;
		var i;
		for (i = 1; stop === false; i++) {
			if (this.searchArrProgKeys(i) == null) {
				stop = true;
				newId = i;
			}
		}

		//Create key structure
		var key = {};
		key.id = newId.toString();
		key.icon = editedProgKeys.icon;
		key.type = editedProgActions.type;
		key.action = editedProgActions.action;
		key.webAppName = editedProgActions.webAppName;
		key.arguments = editedProgActions.arguments;
		key.label = editedProgActions.label;
		key.shortLabel = editedProgActions.shortLabel;
		//add key into keys liste and save list
		//Search an empty case
		var pos;
		for (i = 0; i < 72; i++) {
			if (this._arrKeys[i] == null || this._arrKeys[i] === "") {
				pos = i;
				break;
			}
		}
		this._arrKeys[pos] = key.id;
		this._arrProgKeys.push(key);
	},


	/*
	 * Save keys in settings database
	 */
	saveKeys : function() {
		var json = dojo.toJson(this._arrProgKeys);
		ICTouchAPI.settingServices.setSettingValue("HomepageProgKeys", json, this);
		ICTouchAPI.settingServices.setSettingValue("HomepageKeys", webapp.homepage.data._arrKeys,this);
	},


	/*
	 * get progkeysList for menuList
	 */
	getProgKeysList : function() {
		var data = webapp.homepage.data;
		var list =[];
		for (var i in data._arrProgKeys) {
			var elem = data._arrProgKeys[i];
			list.push({
				intIndex: elem.id,
				strType: "normal",
				strPrimaryContent: elem.label
				//strPicture: elem.icon,
			});
		}
		return list;
	},

	/*
	 * Add progkeys into appBar on homepage preview
	 */
	addProgkeysInAppbar : function() {
		var iMax = this._arrButtons.length;
		for(var i=0;i<iMax;i++) {
			if(this._arrButtons[i]!=null && this._arrAppButtons[i]==null) {
				var indPK = this.searchArrProgKeys(this._arrButtons[i]);
				if(indPK!=null) {
					var objPK = this._arrProgKeys[indPK];
					var callback = function(param) {webapp.homepage.progkeySelected(param);};
					webapp.homepage.registerButton("webapp."+objPK.webAppName, objPK.id, objPK.icon, _(objPK.label,"webapp.homepage"), null, callback, i, true)
				}
			}
		}
	},

	/*
	 * Add progkeys into aHomepage standard
	 */
	addProgkeysInStandardView : function() {
		var iMax			= this._arrKeys.length;
		var boolMoveable	= true;
		for(var i=0;i<iMax;i++) {
			if(this._arrKeys[i]!=null && this._arrAppKeys[i]==null) {
				var indPK = this.searchArrProgKeys(this._arrKeys[i]);
				if(indPK!=null) {
					var objPK = this._arrProgKeys[indPK];
					var callback = function(param) {
						webapp.homepage.progkeySelected(param);
					};
					if(objPK._boolMoveable != "undefined" && objPK._boolMoveable != null && objPK._boolMoveable == "false") {
						boolMoveable = false;
					}
					webapp.homepage.registerKey("webapp."+objPK.webAppName, objPK.id, objPK.icon, objPK.label, null, callback, i, callback, boolMoveable);
				}
			}
		}
	},

	// get the
	getButtonDMLabel : function (strLabel) {
		ICTouchAPI.debugServices.info("webapp.homepage.data8082 - getButtonDMLabel");
		var strLabelId = "";
		// if the object is already i18ned, return it
		if (strLabel.isI18Ned) {
			strLabelId = strLabel;
			ICTouchAPI.debugServices.debug("webapp.homepage.data8082 - getButtonDMLabel / label is a i18n label, do not check if there is a DM translation");
		}
		else if(this.extProgKeysLocalisation && this.extProgKeysLocalisation["en"] && this.extProgKeysLocalisation["en"][strLabel]){
			strLabelId = this.extProgKeysLocalisation["en"][strLabel];
			ICTouchAPI.debugServices.debug("webapp.homepage.data8082 - getButtonDMLabel / english DM translation is provided for label " + strLabel + ", use it: " + strLabelId);
		}
		else {
			strLabelId = _(strLabel,"webapp.homepage");
			ICTouchAPI.debugServices.debug("webapp.homepage.data8082 - getButtonDMLabel / no english DM translation found for label " + strLabel + ", use i18nObject");
		}
		return strLabelId;
	}

});

webapp.homepage.data = new webapp.homepage.data();
