dojo.provide("webapp.homepage.controlBase");
dojo.declare("webapp.homepage.controlBase",[ICTouchAPI.webApplication],
{

	//Homepage view
	previewControl			: null,
	homepageStandardView	: null,
	homepagePreviewView		: null,
	homepageView			: null,
	homepageEditView		: null,

	constructor : function()
	{
		// register to physicals Keys
		ICTouchAPI.eventServices.subscribeToEvent(this, "SENSKEY_HOME", function(objEvent) {
			/*Go to home page on key press (and not on key release)*/
			if(objEvent.value){
				this.senskeyHomeCallback();
			}
		});
		dojo.subscribe("OpenHomepage", this, this.openHomepage);                
		dojo.subscribe("iframe.show",this, this.onShow);

		dojo.subscribe("HomepagePreviewModeChange", this, this.previewModeChanged);
	},

	/**
	 * dump function
	 */
	dump : function(boolAdvancedLogs) {
		this.inherited(arguments);
		ICTouchAPI.debugServices.dump("homepage settings :");
		ICTouchAPI.debugServices.dump(" - HomepagePreviewMode (homepagePreviewMode): " + this.data.homepagePreviewMode);
		ICTouchAPI.debugServices.dump(" - HomepagePreviewAutoFill (homepagePreviewAutoFill): " + this.data.homepagePreviewAutoFill);
		ICTouchAPI.debugServices.dump(" - HomepageStandardAutoFill (homepageStandardAutoFill): " + this.data.homepageStandardAutoFill);
		ICTouchAPI.debugServices.dump(" - HomepageProgKeysLocalisation (extProgKeysLocalisation): " + dojo.toJson(this.data.extProgKeysLocalisation));

		if (boolAdvancedLogs) {
			ICTouchAPI.debugServices.dump("homepage internal variables :");
			ICTouchAPI.debugServices.dump(" - _arrKeys: " + this.data._arrKeys);
			ICTouchAPI.debugServices.dump(" - _arrAppKeys: ");
			for (var i in this.data._arrAppKeys) {
				if (this.data._arrAppKeys[i]) {
					ICTouchAPI.debugServices.dump(" -> _arrAppKeys["+i+"]: strButtonName = '" + this.data._arrAppKeys[i].strButtonName + "', strButtonIcon = '" + this.data._arrAppKeys[i].strButtonIcon + "', strButtonLabel = '" + ((typeof this.data._arrAppKeys[i].strButtonLabel === "string") ? this.data._arrAppKeys[i].strButtonLabel : ((typeof this.data._arrAppKeys[i].strButtonLabel === "object" && this.data._arrAppKeys[i].strButtonLabel && this.data._arrAppKeys[i].strButtonLabel.isI18Ned) ? this.data._arrAppKeys[i].strButtonLabel.getTranslation() : "")) + "'");
				}
				else {
					ICTouchAPI.debugServices.dump(" -> _arrAppKeys["+i+"] is not defined");
				}
			}
			ICTouchAPI.debugServices.dump(" - _arrButtons: " + this.data._arrButtons);
			ICTouchAPI.debugServices.dump(" - _arrAppButtons: ");
			for (var i in this.data._arrAppButtons) {
				if (this.data._arrAppButtons[i]) {
					ICTouchAPI.debugServices.dump(" -> _arrAppButtons["+i+"]: strButtonName = '" + this.data._arrAppButtons[i].strButtonName + "', progkey = " + this.data._arrAppButtons[i].progkey + ", strButtonIcon = '" + this.data._arrAppButtons[i].strButtonIcon + "', strButtonLabel = '" + ((typeof this.data._arrAppButtons[i].strButtonLabel === "string") ? this.data._arrAppButtons[i].strButtonLabel : ((typeof this.data._arrAppButtons[i].strButtonLabel === "object" && this.data._arrAppButtons[i].strButtonLabel && this.data._arrAppButtons[i].strButtonLabel.isI18Ned) ? this.data._arrAppButtons[i].strButtonLabel.getTranslation() : "")) + "'");
				}
				else {
					ICTouchAPI.debugServices.dump(" -> _arrAppButtons["+i+"] is not defined");
				}
			}
			ICTouchAPI.debugServices.dump(" - _arrPreviews: " + this.data._arrPreviews);
			ICTouchAPI.debugServices.dump(" - _arrAppPreviews: ");
			for (var i in this.data._arrAppPreviews) {
				if (this.data._arrAppPreviews[i]) {
					ICTouchAPI.debugServices.dump(" -> _arrAppPreviews["+i+"]: strWebapp = '" + this.data._arrAppPreviews[i].strWebapp + "'");
				}
				else {
					ICTouchAPI.debugServices.dump(" -> _arrAppPreviews["+i+"] is not defined");
				}
			}
		}
	},

	doSubscriptions : function(){
		if(!this.data.boolSubscriptionDone){
			this.data.boolSubscriptionDone = true;
			/*
			 * Another build of the Homepage. Used to be sure that the homepage is never launch after a webapp and to respect the button's order setting HomepageButtons
			 */
			//Buttons
			dojo.subscribe("HomepageRegisterButton",this,function(strWebapp, strButtonName, strButtonIcon, strLabel, strStatusIcon, callBack, position, arrCapabilities){
				this.registerButton(strWebapp, strButtonName, strButtonIcon, strLabel, strStatusIcon,  callBack, position, arrCapabilities);
			});

		    dojo.subscribe("HomepageUnregisterButton",this,function(strButtonName){
					this.unregisterButton(strButtonName);
			});

			//Preview containers
		dojo.subscribe("HomepageRegisterPreviewContainer",this, this.registerPreviewContainer);

		dojo.subscribe("HomepageUnregisterPreviewContainer",this, this.unregisterPreviewContainer);

			//Standard homepage buttons
			dojo.subscribe("HomepageRegisterKey",this,function(strWebapp, strButtonName, strButtonIcon, strLabel, strStatusIcon, callBack, position, callbackLong){
				this.registerKey(strWebapp, strButtonName, strButtonIcon, strLabel, strStatusIcon, callBack, position, callbackLong);
			});

			dojo.subscribe("HomepageUnregisterKey",this,function(strButtonName, boolForceDeleteKey){
				this.unregisterKey(strButtonName, boolForceDeleteKey);
			});

			dojo.subscribe("HomepageUnregisterAwapKey",this,function(strButtonName){
				this.unregisterAwapKey(strButtonName);
			});

			//change homepage status
			dojo.subscribe("HomepageChangeStatusIcon",this,function(strButtonName, strStatusIcon) {
				this.changeStatusIcon(strButtonName, strStatusIcon);
			});

			// Subscribe to a header modification
			dojo.subscribe("AddCSSInHeader", this, this.addCSSToHeader);
			dojo.subscribe("RemoveCSSInHeader", this, this.removeCSSFromHeader);
		}
	},

	/**
	 * Create all rules for apps button
	 * @param {Object}	app	The application manifest content
	 * @param {string}	url	The URL of the server to get the resource icon
	 */
	addCSSToHeader : function(app, url) {
		ICTouchAPI.debugServices.debug("webapp.homepage.controlBase / addCssToHeader() for app: " + app.name);

		var appName		= app.widget.path.split('.');
		var strAppName	= appName[0];
		var frame		= window.frames["webapp.homepage.getHomepage"];

		// Create a new CSS rule
		ICTouchAPI.skinServices.addCssRuleToFrame(frame, app.prefix + app.id + "-64", "background-image: url('" + url + "/" + strAppName + "/themes/Default/images/" + strAppName + "-application-64.png');");
		ICTouchAPI.skinServices.addCssRuleToFrame(frame, app.prefix + app.id + "-64:active", "background-image: url('" + url + "/" + strAppName + "/themes/Default/images/" + strAppName + "-application-64.active.png');");
		ICTouchAPI.skinServices.addCssRuleToFrame(frame, app.prefix + app.id + "-64.active", "background-image: url('" + url + "/" + strAppName + "/themes/Default/images/" + strAppName + "-application-64.active.png');");
		ICTouchAPI.skinServices.addCssRuleToFrame(frame, app.prefix + app.id + "-64.disabled", "background-image: url('" + url + "/" + strAppName + "/themes/Default/images/" + strAppName + "-application-64.disabled.png');");
	},

	/**
	 * Remove all rules for apps button
	 */
	removeCSSFromHeader : function(app) {
		var frame = window.frames["webapp.homepage.getHomepage"];

		ICTouchAPI.skinServices.removeCssRuleToFrame(frame,app.prefix + app.id + "-64");
		ICTouchAPI.skinServices.removeCssRuleToFrame(frame,app.prefix + app.id + "-64:active");
		ICTouchAPI.skinServices.removeCssRuleToFrame(frame,app.prefix + app.id + "-64.active");
		ICTouchAPI.skinServices.removeCssRuleToFrame(frame,app.prefix + app.id + "-64.disabled");
	},

	loaded : function(){
		//Load the previews list, and buttons list from settings
		this.data.loadPreviewsList();
		this.data.loadAppButtonsList();
		this.data.loadAppKeysList();
	},

	openHomepage : function(objEvent) {
		if(!webapp.lock|| !webapp.lock.isLocked()){
			if(objEvent && objEvent.boolPreview){
				this.previewModeChanged(true);
			}
			// show webapp homepage
			ICTouchAPI.transitionServices.getScreen({
				name: "webapp.homepage.getHomepage",
				sync: (objEvent && objEvent.sync),
				params: {}
			});
		}
	},

	senskeyHomeCallback : function() {
		if(ICTouchAPI.transitionServices.getCurrentScreenName() == "webapp.homepage.getHomepage"){
			// If we were on homepage preview, switch to standard
			if(this.data.homepagePreviewMode){
				this.previewModeChanged(false);
			}
			// If we were on homepage standard, scroll to first page
			else {
				dojo.publish("homepageStandard/changePage", [1])
			}
		}
		else {
			this.openHomepage(null);
		}
	},

	registerPreviewContainer : function(strWebapp, objWebapp) {
		var containerExist = false;
		for(var i=0; i<webapp.homepage.data._arrAppPreviews.length && !containerExist; i++){
			if (webapp.homepage.data._arrAppPreviews[i] != null) {
				if(strWebapp === webapp.homepage.data._arrAppPreviews[i].strWebapp) {
					containerExist = true;
				}
		}
		}
		if( !containerExist ) {
			var frag = document.createDocumentFragment();
			var div = dojo.create("div", { }, frag);
			var itemFind = false;

			for(var j=0; j<webapp.homepage.data._arrPreviews.length && !itemFind; j++){
				if (strWebapp === webapp.homepage.data._arrPreviews[j]) {
					itemFind=true;
					webapp.homepage.data._arrAppPreviews[j] = {strWebapp: strWebapp, objWebapp: objWebapp};
					if(this.homepagePreviewView) {
						this.homepagePreviewView.updatePreviewsList();
					}
					return div;
				}
			}
			if(!itemFind){
				webapp.homepage.data._arrAppPreviews.push({strWebapp: strWebapp, objWebapp: objWebapp});
				if(this.homepagePreviewView) {
					this.homepagePreviewView.updatePreviewsList();
				}
				return div;
			}
		}
		return null;
	},


	unregisterPreviewContainer : function(strWebapp) {
		var data = webapp.homepage.data;
		var ind = data.searchArrAppPreview(strWebapp);
		if (ind!=null) {
			data._arrAppPreviews.splice(ind, 1, null);
			if (this.homepagePreviewView) {
				//this.homepagePreviewView.destroyPreview(ind);
				this.homepagePreviewView.updatePreviewsList();
			}
		}
	},

	registerButton : function(strWebapp, strButtonName, strButtonIcon, strLabel, strStatusIcon, callBack, position, arrCapabilities, progkey)
	{
		//this.data.addWebappIcon(strWebapp);
		this.data._arrStatus[strButtonName] = strStatusIcon;
		var reload = true;
		if(!arrCapabilities) {
			arrCapabilities = [];
		}
		var button = {};
		if(progkey!==true) {
			progkey = false;
		}
		button = {
			strButtonName: strButtonName,
			strButtonLabel: strLabel,
			callback : callBack,
			strButtonIcon: strButtonIcon,
			strStatusIcon: strStatusIcon,
			arrCapabilities: arrCapabilities,
			progkey: progkey
		};
		var itemFind = false;

		for(var j=0; j<webapp.homepage.data._arrButtons.length && !itemFind; j++){
			if (strButtonName === webapp.homepage.data._arrButtons[j]) {
				//AJOUT a la position
				webapp.homepage.data._arrAppButtons[j]=button;
				itemFind=true;
				break;
			}
		}
		if(!itemFind){
			//Ajout en fin de l'appbar'
			webapp.homepage.data._arrAppButtons.push(button);
			if(this.data.homepagePreviewAutoFill===true) {
			//Ajout en fin du setting
			webapp.homepage.data._arrButtons.push(button.strButtonName);
			reload = false;
				this.data.intButtonsSettingSemaphore++;
				ICTouchAPI.settingServices.setSettingValue("HomepageButtons", this.data._arrButtons,this);
		}
		}
		// If AppBar has already been loaded then it needs to be reloaded
		if(reload===true) {
			dojo.publish("homepage/appButtonListUpdated");
		}
	},

        unregisterButton : function(strButtonName)
        {
                var j;
                var itemFind1 = false;
                var itemFind2 = false;


                for(j=0; j<webapp.homepage.data._arrButtons.length && !itemFind1; j++){
                        if (strButtonName === webapp.homepage.data._arrButtons[j]) {
                                // remove it from array
                                itemFind1=true;
                                break;
                        }
                }
                for(j=0; j<webapp.homepage.data._arrAppButtons.length && !itemFind2; j++){
                        if (webapp.homepage.data._arrAppButtons[j] &&
                            strButtonName === webapp.homepage.data._arrAppButtons[j].strButtonName) {
                                // remove it from array
                                // the AppButton UIElement is detroyed when the AppBar is updated
								webapp.homepage.data._arrAppButtons[j] = null;
                                itemFind2=true;
                                break;
                        }
                }

                if(itemFind1 || itemFind2){
                        if(this.data._arrStatus.splice[strButtonName]){
                            delete this.data._arrStatus.splice[strButtonName];
                        }
                         // If AppBar has already been loaded then it needs to be reloaded
                         dojo.publish("homepage/appButtonListUpdated");
                }
        },

	registerKey : function(strWebapp, strButtonName, strButtonIcon, strLabelId, strStatusIcon, callBack, position, callbackLong, boolMoveable)
	{
		ICTouchAPI.debugServices.debug("webapp.homepage.controlBase - registerKey / register view: " + strWebapp + ", strButtonName: " + strButtonName + ", strButtonIcon: " + strButtonIcon + ", strLabelId: " + strLabelId);
		//this.data.addWebappIcon(strWebapp);
		this.data._arrStatus[strButtonName] = strStatusIcon;
		var reload = true;
		var button = {};
		
		var strLabel = this.data.getButtonDMLabel(strLabelId);

		var boolIsMoveable	= (boolMoveable != "undefined" && boolMoveable != null) ? boolMoveable : true;

			button = {
			strButtonName: strButtonName,
			strButtonLabel: strLabel,
			callback : callBack,
			strButtonIcon: strButtonIcon,
			strStatusIcon: strStatusIcon,
			_boolMoveable: boolIsMoveable
		};
		
		if(callbackLong) {
			button.callbackLong = callbackLong;
		}

		// save strLabelId if it is not a i18n object to save the reference to the english id in the DM translations
		if (!strLabel.isI18Ned) {
			button.strLabelId = strLabelId;
			ICTouchAPI.debugServices.debug("webapp.homepage.controlBase - registerKey / label is not i18ned, save it to button.strLabelId field: " + button.strLabelId);
		}
		
		var itemFind = false;
		for(var j=0; j<webapp.homepage.data._arrKeys.length && !itemFind; j++){
			if (webapp.homepage.data._arrKeys[j] != null && strButtonName === webapp.homepage.data._arrKeys[j]) {
				//AJOUT a la position
				webapp.homepage.data._arrAppKeys[j]=button;
				itemFind=true;
				break;
			}
		}
		if(!itemFind) {
			if (position && this.data._arrKeys[position]=="") {
				ICTouchAPI.debugServices.debug("webapp.homepage.controlBase - registerKey / position is provided and void: use position " + position);
				itemFind=true;
				webapp.homepage.data._arrKeys[position] = button.strButtonName;
				webapp.homepage.data._arrAppKeys[position] = button;
				reload = false;
				ICTouchAPI.settingServices.setSettingValue("HomepageKeys", webapp.homepage.data._arrKeys,this);
			}
			else if(webapp.homepage.data.homepageStandardAutoFill===true) {
				//Search void place
				var ind = null;
				for(var i=0;i<72 && !itemFind;++i) {
					if (this.data._arrKeys[i]==null || this.data._arrKeys[i]=="") {
						//AJOUT a la position
						ind=i;
						itemFind=true;
						break;
					}
				}
				ICTouchAPI.debugServices.debug("webapp.homepage.controlBase - registerKey / position is not provided, homepageStandardAutoFill is true -> search first void place: use position " + ind);
				webapp.homepage.data._arrKeys[ind] = button.strButtonName;
				webapp.homepage.data._arrAppKeys[ind] = button;
				reload = false;
				ICTouchAPI.settingServices.setSettingValue("HomepageKeys", webapp.homepage.data._arrKeys,this);
			}
			else {
				ICTouchAPI.debugServices.debug("webapp.homepage.controlBase - registerKey / position is not provided, homepageStandardAutoFill is false -> add button at the end: " + webapp.homepage.data._arrAppKeys.length);
				//Ajout en fin du setting
				webapp.homepage.data._arrAppKeys.push(button);
			}
 		}
		if(reload===true) {
			dojo.publish("homepageStandard/reload");
		}
		dojo.publish("progkeys/reload");
	},

   	unregisterKey : function(strButtonName, boolForceDeleteKey) {
		var j;
		var itemFind1 = false;
		var itemFind2 = false;
		
		for(j=0; j<webapp.homepage.data._arrKeys.length && !itemFind1; j++) {
			if (strButtonName === webapp.homepage.data._arrKeys[j]) {
				if(boolForceDeleteKey) {
					webapp.homepage.data._arrKeys[j] = "";
				}
				itemFind1=true;
				break;
			}
		}
		
		for(j=0; j<webapp.homepage.data._arrAppKeys.length && !itemFind2; j++) {
			if (webapp.homepage.data._arrAppKeys[j] &&
				strButtonName === webapp.homepage.data._arrAppKeys[j].strButtonName) {
					webapp.homepage.data._arrAppKeys[j] = null;
					itemFind2=true;
					break;
			}
		}
		
		if(itemFind1 || itemFind2) {
			if(this.data._arrStatus.splice[strButtonName]) {
				delete this.data._arrStatus.splice[strButtonName];
			}
			if(boolForceDeleteKey) {
				ICTouchAPI.settingServices.setSettingValue("HomepageKeys", webapp.homepage.data._arrKeys,this);
			}
			 // If AppBar has already been loaded then it needs to be reloaded
			 dojo.publish("homepageStandard/reload");
		}
		dojo.publish("progkeys/reload");
	},

	changeStatusIcon : function(strButtonName, strStatusIcon) {
		var indStandard=null, indPreview=null;
		var i, iMax
		//search  homepage preview item
		iMax=this.data._arrAppButtons.length;
		for(i=0; i<iMax && indPreview==null; i++){
			if (this.data._arrAppButtons[i]!=null && strButtonName===this.data._arrAppButtons[i].strButtonName) {
				indPreview=i;
				break;
			}
		}
		if(indPreview!=null) {
			this.data._arrAppButtons[indPreview].strStatusIcon = strStatusIcon;
		}
		//search  homepage standard item
		iMax=this.data._arrAppKeys.length;
		for(i=0; i<iMax && indStandard==null; i++){
			if (this.data._arrAppKeys[i]!=null && strButtonName===this.data._arrAppKeys[i].strButtonName) {
				indStandard=i;
				break;
			}
		}
		if(indStandard!=null) {
			this.data._arrAppKeys[indStandard].strStatusIcon = strStatusIcon;
		}
		//Change button status if exist
		if (this.data.homepagePreviewMode === true) {
			var appBarHomepage = ICTouchAPI.AppBarServices.getAppBar("homepage", "getHomepage");
			var objBtn = appBarHomepage.getButton(strButtonName);
			if(objBtn!=null) {
				objBtn.setStatusIcon(strStatusIcon);
			}
		}
		else {
			if(indStandard!=null && this.homepageStandardView && this.homepageStandardView.arrObjKeys[indStandard]!=null) {
				this.homepageStandardView.arrObjKeys[indStandard].setStatusIcon(strStatusIcon);
				}
			}
		this.data._arrStatus[strButtonName] = strStatusIcon;
	},

	/**
	 * Callback
	 * When an iframe become visible (homepage)
	 */
	onShow : function(id) {
		if( id == "webapp.homepage.getHomepage" && !webapp.homepage.data.homepagePreviewMode) {
			dojo.addClass(document.getElementById(id), "slideHomepageStandard");
		}
		id = null;
	},

	unlock : function(){
		dojo.publish("unlockTransition",[true]);
		dojo.removeClass(document.getElementById("webapp.homepage.getHomepage"), "slideHomepageStandard");
	},

	previewModeChanged : function(param) {
		ICTouchAPI.debugServices.info("webapp.homepage.controlBase - previewModeChanged / begin");

		var value;
		if(param.jsValue!=undefined) {
			value = param.jsValue;
		}
		else {
			value = param;
		}

		ICTouchAPI.debugServices.debug("webapp.homepage.controlBase - previewModeChanged / param : " + (value) ? "Preview" : "Standard");

		if (value !== webapp.homepage.data.homepagePreviewMode) {
			webapp.homepage.data.homepagePreviewMode = value;
			
			if(webapp.homepage.homepageView){
				webapp.homepage.homepageView.loadHomepage(value);
			}
		}

		ICTouchAPI.debugServices.info("webapp.homepage.controlBase - previewModeChanged / end");
	}
});
