dojo.require("webapp.homepage.controlBase");
dojo.provide("webapp.homepage");
dojo.declare("webapp.homepage",webapp.homepage.controlBase,
{

	constructor : function()
	{
		ICTouchAPI.tools.onLoadedWebapp("webapp.settings", this, this.overrideSetting);
	},

	overrideSetting : function()
	{
		var that = this;
		var func = function() { that.enableEditMode() };
		webapp.settings.overrideSetting("HomepageEditMode",func);
	},

	/*
	 * Enable the edition mode for the homepage : Enable Drag and Drop for previews containers and appbar.
	 */
	enableEditMode: function(){
		ICTouchAPI.transitionServices.getScreen({name : "webapp.progkeys.getProgKeys", params : {}});
	},
	/*
	 * Disable edition mode for the homepage : Disable Drag and Drop for previews containers and appbar.
	 * Save new positions in settings.
	 */
	disableEditMode: function(){
		dojo.publish("homepage/normalMode");
	},



	callbackButtonEdit : function(buttonId) {
		var data = webapp.homepage.data;
		switch(buttonId) {
			case "ADD_BTN":
				//Search an empty case
				var emptyCase = false;
				for(var i = 0; (i < 72) && (emptyCase === false); i++) {
					if(data._arrKeys[i] == null || data._arrKeys[i] === "") {
						emptyCase = true;
						break;
					}
				}
				if(emptyCase === true) {
					if(webapp.progkeys) {
						var that = this;
						var backAddCallback = function() { that.backAddCallback() };
						var endAddCallback = function(editedProgKey,editedAction) { that.endAddCallback(editedProgKey,editedAction) };
						webapp.progkeys.addProgkey({backAddCallback:backAddCallback, endAddCallback:endAddCallback, progkeysWebapp:false})
					}
					else {
						ICTouchAPI.popupServices.errorPopup(_("Error", "ICTouchAPI"), _("Missing ProgKeys webapp", "webapp.homepage"), _("Ok", "ICTouchAPI"));
					}
				} else {
					ICTouchAPI.popupServices.errorPopup(_("Error", "webapp.homepage"), _("Can't add more than 72 buttons", "webapp.homepage"), _("Ok", "webapp.homepage"));
				}
				break;
			case "DELETE_BTN":
				var deleteBtn = webapp.settings.getActionBar().getButton("DELETE_BTN");
				if(this.data.boolDeleteKey==false) {
					deleteBtn.setStatusIcon("notif-on");
					this.data.boolDeleteKey = true;
				}
				else {
					deleteBtn.setStatusIcon("notif-off");
					this.data.boolDeleteKey = false;
				}
				break;
			}
	},

	progkeySelected : function(id) {
		//search a id
		var idFound=false;
		for(var i in this.data._arrProgKeys) {
			if (this.data._arrProgKeys[i].id === id) {
				idFound = true;
				break;
			}
		}
		if(idFound) {
			var currentKey = this.data._arrProgKeys[i];
			webapp[currentKey.webAppName].onProgKeyClick(currentKey);
		}
	},

	callbackMenuEdit : function(buttonId) {
		if(this.data.boolDeleteKey==true) {
			var dPopup;
			var that = this;
			var popupData = {
				strTitle: _("Delete homepage key?","webapp.homepage"),
				strType: "warning",
				strContent: _("Do you really want to delete this homepage key?","webapp.homepage"),
				arrPopupButtons: [
				{
					strButtonLabel: _('OK', "ICTouchAPI"),
					callback : function(){
						that.deleteKey(buttonId, dPopup);
					}
				},
				{
					strButtonLabel: _('Cancel',"ICTouchAPI"),
					callback : function(){ICTouchAPI.popupServices.removePopup(dPopup)}
				}
			]
			}
			dPopup = ICTouchAPI.popupServices.addNewPopup(popupData);
		}
	},

	deleteKey : function(buttonId, dPopup) {
		var ind;
		ind = this.data.searchArrKeys(buttonId);
		this.data._arrKeys[ind] = "";
		this.data._arrAppKeys[ind] = null;
		ind = this.data.searchArrProgKeys(buttonId);
		this.data._arrProgKeys.splice(ind, 1);
		this.data.saveKeys();
		ICTouchAPI.popupServices.removePopup(dPopup);
	},



	backAddCallback : function() {
		ICTouchAPI.transitionServices.getScreen({
			name : 'webapp.settings.getSettings',
			params : {}
		});
	},

	endAddCallback : function(editedProgKey, editedAction) {
			webapp.homepage.data.SaveProgkeys(editedProgKey, editedAction);
			webapp.homepage.data.saveKeys();
			ICTouchAPI.transitionServices.getScreen({
				name : 'webapp.settings.getSettings',
				params : {}
			});
	}
});
webapp.homepage=new webapp.homepage();
