dojo.provide("webapp.hotel.controlBase");
dojo.declare("webapp.hotel.controlBase",[ICTouchAPI.webApplication],{languageTimeout:null,constructor:function(){ICTouchAPI.eventServices.subscribeToEvent(this,"FrontdeskMessageNotification",this.notifyMessage);
ICTouchAPI.eventServices.subscribeToEvent(this,"GuestLanguage",this.notifyLanguage);
dojo.subscribe("GuestInfo",this,this.setNamesSettings);
dojo.subscribe("GuestCheckIn",this,this.notifyGuestCheckIn);
ICTouchAPI.eventServices.subscribeToEvent(this,"presentationLoaded",this._presentationLoaded);
dojo.subscribe("languageChanged",this,this.languageChanged)
},loaded:function(){ICTouchAPI.settingServices.getSetting("TelephonyCheckin",this,this._onInitCheckinState);
ICTouchAPI.settingServices.subscribeToSetting(this,"DisplayedNameCheckout",this._onDisplayedNameCheckoutChanged);
ICTouchAPI.settingServices.getSetting("DisplayedNameCheckout",this,this._onDisplayedNameCheckoutChanged);
ICTouchAPI.settingServices.subscribeToSetting(this,"DisplayedInfoCheckin",this._onDisplayedInfoCheckinChanged);
ICTouchAPI.settingServices.getSetting("DisplayedInfoCheckin",this,this._onDisplayedInfoCheckinChanged);
ICTouchAPI.settingServices.subscribeToSetting(this,"DisplayedInfoCheckout",this._onDisplayedInfoCheckoutChanged);
ICTouchAPI.settingServices.getSetting("DisplayedInfoCheckout",this,this._onDisplayedInfoCheckoutChanged);
ICTouchAPI.settingServices.subscribeToSetting(this,"DdiNumberPattern",this._onDdiNumberPatternChanged);
ICTouchAPI.settingServices.getSetting("DdiNumberPattern",this,this._onDdiNumberPatternChanged);
ICTouchAPI.settingServices.subscribeToSetting(this,"DDIRange",this._onDDIRangeChanged);
ICTouchAPI.settingServices.getSetting("DDIRange",this,this._onDDIRangeChanged);
ICTouchAPI.settingServices.subscribeToSetting(this,"RoomName",this._onObjRoomNameChanged);
ICTouchAPI.settingServices.getSetting("RoomName",this,this._onObjRoomNameChanged)
},dump:function(boolAdvancedLogs){this.inherited(arguments);
ICTouchAPI.debugServices.dump("Hotel settings :");
ICTouchAPI.debugServices.dump(" - DisplayedNameCheckout: "+this.data.getDisplayedNameCheckout());
ICTouchAPI.debugServices.dump(" - DisplayedInfoCheckin: "+this.data.getDisplayedInfoCheckin());
ICTouchAPI.debugServices.dump(" - DisplayedInfoCheckout: "+this.data.getDisplayedInfoCheckout());
ICTouchAPI.debugServices.dump(" - DdiNumberPattern: "+this.data.getDdiNumberPattern());
ICTouchAPI.debugServices.dump(" - DDIRange: "+dojo.toJson(this.data.getDDIRange()));
ICTouchAPI.debugServices.dump(" - RoomName: "+dojo.toJson(this.data.getObjRoomName()));
ICTouchAPI.debugServices.dump("boolCheckIn: "+this.data.boolCheckIn);
ICTouchAPI.debugServices.dump("Checkin state (boolCheckIn): "+this.data.boolCheckIn);
ICTouchAPI.debugServices.dump("guestName: "+this.data.guestName);
ICTouchAPI.debugServices.dump("guestNumber: "+this.data.guestNumber);
ICTouchAPI.debugServices.dump("setNumber: "+this.data.setNumber);
if(boolAdvancedLogs){ICTouchAPI.debugServices.dump("strLastFirstLineSet: "+this.data.strLastFirstLineSet);
ICTouchAPI.debugServices.dump("strLastSecondLineSet: "+this.data.strLastSecondLineSet)
}},_presentationLoaded:function(){ICTouchAPI.eventServices.unsubscribeToEvent(this,"presentationLoaded");
dojo.publish("ModeHotel")
},notifyGuestCheckIn:function(boolCheckInState){this.data.boolCheckIn=boolCheckInState;
ICTouchAPI.notificationServices.resetNotifications();
this.computeUserInfoDisplay();
dojo.publish("homepageStandard/changePage",[1]);
dojo.publish("OpenHomepage")
},setNamesSettings:function(objInfo){this.data.guestName=objInfo.guestName;
this.data.guestNumber=objInfo.guestNumber;
this.data.setNumber=objInfo.setNumber;
this.computeUserInfoDisplay()
},notifyLanguage:function(objLanguage){if(this.languageTimeout){clearTimeout(this.languageTimeout)
}var func=function(){var strLanguageCountry=objLanguage.value;
if(strLanguageCountry){ICTouchAPI.i18nServices.changeLanguage(strLanguageCountry)
}};
this.languageTimeout=setTimeout(func,10000)
},notifyMessage:function(){var objArguments=ICTouchAPI.tools.getEventArguments(arguments);
var activation=objArguments.activation||"";
var depositNumber=objArguments.depositNumber||"";
if(activation){ICTouchAPI.ledServices.activate("communication","N_HOTEL");
ICTouchAPI.notificationServices.addNotification({strNotificationName:"HotelMessageNotification",strNotificationLabel:"Message",intNotificationValue:1,callback:function(){ICTouchAPI.APIServices.Telephony.startPhoneCall({params:[depositNumber,false,true,false]})
}})
}else{ICTouchAPI.ledServices.desactivate("communication","N_HOTEL");
ICTouchAPI.notificationServices.removeNotification("HotelMessageNotification")
}},languageChanged:function(){if((this.data.boolCheckIn&&this.data.getDisplayedInfoCheckin()==2)||(!this.data.boolCheckIn&&this.data.getDisplayedInfoCheckout()==2)){var translatedRoomName=this.applyRoomNameDMTranslation();
if(translatedRoomName!=this.data.strLastSecondLineSet){ICTouchAPI.settingServices.setSettingValue("UserName",translatedRoomName);
this.data.strLastSecondLineSet=translatedRoomName
}}},computeUserInfoDisplay:function(){var strFirstLine="";
var strSecondLine="";
if(this.data.boolCheckIn){strFirstLine=this.data.guestName;
switch(this.data.getDisplayedInfoCheckin()){case 0:strSecondLine="";
break;
case 1:strSecondLine=this.data.guestNumber;
break;
case 2:strSecondLine=this.applyRoomNameDMTranslation();
break;
case 3:strSecondLine=this.computeDDINumber(this.data.guestNumber);
if(!strSecondLine){strSecondLine=this.applyRoomNameDMTranslation()
}break;
default:strSecondLine=this.data.guestNumber;
ICTouchAPI.debugServices.warning("webapp.hotel.controlBase - computeUserInfoDisplay / DisplayedInfoCheckin is not 0, 1, 2 or 3");
ICTouchAPI.debugServices.warning("webapp.hotel.controlBase - computeUserInfoDisplay / DisplayedInfoCheckin = "+this.data.getDisplayedInfoCheckin()+" -> set second line to user_number: "+strSecondLine);
break
}}else{switch(this.data.getDisplayedNameCheckout()){case 0:strFirstLine="";
break;
case 1:strFirstLine=this.data.guestName;
break;
default:strFirstLine=this.data.guestName;
ICTouchAPI.debugServices.warning("webapp.hotel.controlBase - computeUserInfoDisplay / DisplayedNameCheckout is not 0, or 1");
ICTouchAPI.debugServices.warning("webapp.hotel.controlBase - computeUserInfoDisplay / DisplayedNameCheckout = "+this.data.getDisplayedNameCheckout()+" -> set first line to room_set_name: "+strFirstLine);
break
}switch(this.data.getDisplayedInfoCheckout()){case 0:strSecondLine="";
break;
case 1:strSecondLine=this.data.guestNumber;
break;
case 2:strSecondLine=this.applyRoomNameDMTranslation();
break;
default:strSecondLine=this.data.guestNumber;
ICTouchAPI.debugServices.warning("webapp.hotel.controlBase - computeUserInfoDisplay / DisplayedInfoCheckout is not 0, 1, 2 or 3");
ICTouchAPI.debugServices.warning("webapp.hotel.controlBase - computeUserInfoDisplay / DisplayedInfoCheckout = "+this.data.getDisplayedNameCheckout()+" -> set second line to user_number: "+strSecondLine);
break
}}if(strFirstLine!=this.data.strLastFirstLineSet){ICTouchAPI.settingServices.setSettingValue("UserFirstName",strFirstLine);
this.data.strLastFirstLineSet=strFirstLine
}else{}if(strSecondLine!=this.data.strLastSecondLineSet){ICTouchAPI.settingServices.setSettingValue("UserName",strSecondLine);
this.data.strLastSecondLineSet=strSecondLine
}else{}},applyRoomNameDMTranslation:function(){var roomName="";
var arrRoomName=this.data.getObjRoomName();
if(arrRoomName){if(typeof arrRoomName==="object"){var currentLocal=ICTouchAPI.i18nServices.getLocale();
if(arrRoomName[currentLocal]){roomName=arrRoomName[currentLocal]
}else{if(arrRoomName.en){roomName=arrRoomName.en
}else{roomName=""
}}}else{if(typeof arrRoomName==="string"){roomName=arrRoomName
}}}return roomName
},computeDDINumber:function(strGuestNumber){var intGuestNumber=parseInt(strGuestNumber,10);
var arrDDIRange=this.data.getDDIRange();
var strDDIPattern=this.data.getDdiNumberPattern();
var strDDINumber="";
if(strGuestNumber&&intGuestNumber&&strDDIPattern&&typeof strDDIPattern==="string"&&arrDDIRange&&typeof arrDDIRange==="object"&&arrDDIRange.length==2&&typeof arrDDIRange[0]==="number"&&typeof arrDDIRange[1]==="number"){if(intGuestNumber>=arrDDIRange[0]&&intGuestNumber<=arrDDIRange[1]){strDDINumber=this.processDDINumberComputation(strGuestNumber,strDDIPattern)
}else{ICTouchAPI.debugServices.warning("webapp.hotel.controlBase - computeDDINumber / Guest number is not in the DDI range, not possible to compute the DDINumber. intGuestNumber: "+intGuestNumber+", arrDDIRange: "+dojo.toJson(arrDDIRange))
}}else{ICTouchAPI.debugServices.error("webapp.hotel.controlBase - computeDDINumber / Parameters given to computeDDINumber are wrong, not possible to compute the DDINumber");
ICTouchAPI.debugServices.error("webapp.hotel.controlBase - computeDDINumber / Parameters are: strGuestNumber: "+strGuestNumber+" | intGuestNumber: "+intGuestNumber+" | strDDIPattern: "+strDDIPattern+" | arrDDIRange: "+dojo.toJson(arrDDIRange))
}return strDDINumber
},processDDINumberComputation:function(strGuestNumber,strDDIPattern){var DDINumber="";
var tmp="";
var i;
var j=strGuestNumber.length-1;
for(i=strDDIPattern.length-1;
i>=0;
i--){if(strDDIPattern[i]=="*"&&j>=0){tmp=strGuestNumber[j];
j--
}else{tmp=strDDIPattern[i]
}DDINumber=tmp+DDINumber
}strGuestNumber=null;
strDDIPattern=null;
return DDINumber
},_onInitCheckinState:function(objSetting){this.data.boolCheckIn=(objSetting&&objSetting.jsValue)?true:false;
objSetting=null
},_onDisplayedNameCheckoutChanged:function(objSetting){var value=objSetting?parseInt(objSetting.jsValue,10):1;
this.data.setDisplayedNameCheckout(value);
this.computeUserInfoDisplay();
objSetting=null
},_onDisplayedInfoCheckinChanged:function(objSetting){var value=objSetting?parseInt(objSetting.jsValue,10):1;
this.data.setDisplayedInfoCheckin(value);
this.computeUserInfoDisplay();
objSetting=null
},_onDisplayedInfoCheckoutChanged:function(objSetting){var value=objSetting?parseInt(objSetting.jsValue,10):1;
this.data.setDisplayedInfoCheckout(value);
this.computeUserInfoDisplay();
objSetting=null
},_onDdiNumberPatternChanged:function(objSetting){var strDdiNumberPattern;
if(objSetting&&objSetting.jsValue&&typeof objSetting.jsValue==="string"){strDdiNumberPattern=objSetting.jsValue
}else{strDdiNumberPattern="";
ICTouchAPI.debugServices.warning("webapp.hotel.controlBase - _onDdiNumberPatternChanged / the setting DdiNumberPattern is wrongly defined")
}this.data.setDdiNumberPattern(strDdiNumberPattern);
this.computeUserInfoDisplay();
objSetting=null
},_onDDIRangeChanged:function(objSetting){var arrDDIRange;
if(objSetting&&objSetting.jsValue){arrDDIRange=dojo.fromJson(objSetting.jsValue)
}else{arrDDIRange=[];
ICTouchAPI.debugServices.warning("webapp.hotel.controlBase - _onDDIRangeChanged / the setting DDIRange is wrongly defined")
}this.data.setDDIRange(arrDDIRange);
this.computeUserInfoDisplay();
objSetting=null
},_onObjRoomNameChanged:function(objSetting){var roomName="";
if(objSetting&&objSetting.jsValue&&typeof objSetting.jsValue==="string"){if(objSetting.jsValue.match("[{}]")){roomName=dojo.fromJson(objSetting.jsValue)
}else{roomName=objSetting.jsValue
}}this.data.setObjRoomName(roomName);
this.computeUserInfoDisplay();
objSetting=null
}});
dojo.require("webapp.hotel.controlBase");
dojo.provide("webapp.hotel");
dojo.declare("webapp.hotel",webapp.hotel.controlBase,{});
webapp.hotel=new webapp.hotel();
dojo.provide("webapp.hotel.dataBase");
dojo.declare("webapp.hotel.dataBase",null,{boolCheckIn:null,guestName:"",guestNumber:"",setNumber:"",strLastFirstLineSet:"",strLastSecondLineSet:"",_intDisplayedNameCheckout:1,_intDisplayedInfoCheckin:1,_intDisplayedInfoCheckout:1,_strDdiNumberPattern:"",_arrDDIRange:[],_objRoomName:null,constructor:function(){},setDisplayedNameCheckout:function(intDisplayedNameCheckout){this._intDisplayedNameCheckout=intDisplayedNameCheckout
},getDisplayedNameCheckout:function(){return this._intDisplayedNameCheckout
},setDisplayedInfoCheckin:function(intDisplayedInfoCheckin){this._intDisplayedInfoCheckin=intDisplayedInfoCheckin
},getDisplayedInfoCheckin:function(){return this._intDisplayedInfoCheckin
},setDisplayedInfoCheckout:function(intDisplayedInfoCheckout){this._intDisplayedInfoCheckout=intDisplayedInfoCheckout
},getDisplayedInfoCheckout:function(){return this._intDisplayedInfoCheckout
},setDdiNumberPattern:function(strDdiNumberPattern){this._strDdiNumberPattern=strDdiNumberPattern
},getDdiNumberPattern:function(){return this._strDdiNumberPattern
},setDDIRange:function(arrDDIRange){if(typeof arrDDIRange==="object"&&arrDDIRange.length==2){this._arrDDIRange=arrDDIRange
}else{ICTouchAPI.debugServices.warning("webapp.hotel.dataBase - setDDIRange / the setting DDIRange is wrongly defined")
}},getDDIRange:function(){return this._arrDDIRange
},setObjRoomName:function(objRoomName){this._objRoomName=objRoomName
},getObjRoomName:function(){return this._objRoomName
}});
dojo.require("webapp.hotel.dataBase");
dojo.provide("webapp.hotel.data");
dojo.declare("webapp.hotel.data",webapp.hotel.dataBase,{});
webapp.hotel.data=new webapp.hotel.data();