/*hospitality*/
// Provide and create the hospitality webapp.
dojo.provide("webapp.hotel.controlBase");
dojo.declare("webapp.hotel.controlBase",[ICTouchAPI.webApplication],{

	languageTimeout : null,

    constructor: function(){
		// Subscribe to all the events
		ICTouchAPI.eventServices.subscribeToEvent(this, "FrontdeskMessageNotification", this.notifyMessage);
		ICTouchAPI.eventServices.subscribeToEvent(this, "GuestLanguage", this.notifyLanguage);

		dojo.subscribe("GuestInfo", this, this.setNamesSettings);
		dojo.subscribe("GuestCheckIn", this, this.notifyGuestCheckIn);

		ICTouchAPI.eventServices.subscribeToEvent(this, "presentationLoaded", this._presentationLoaded);

		dojo.subscribe("languageChanged", this, this.languageChanged);
    },

	loaded: function() {
		// Get the checkin/out state at phone init
		ICTouchAPI.settingServices.getSetting("TelephonyCheckin", this, this._onInitCheckinState);

		ICTouchAPI.settingServices.subscribeToSetting(this, "DisplayedNameCheckout", this._onDisplayedNameCheckoutChanged);
		ICTouchAPI.settingServices.getSetting("DisplayedNameCheckout", this, this._onDisplayedNameCheckoutChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "DisplayedInfoCheckin", this._onDisplayedInfoCheckinChanged);
		ICTouchAPI.settingServices.getSetting("DisplayedInfoCheckin", this, this._onDisplayedInfoCheckinChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "DisplayedInfoCheckout", this._onDisplayedInfoCheckoutChanged);
		ICTouchAPI.settingServices.getSetting("DisplayedInfoCheckout", this, this._onDisplayedInfoCheckoutChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "DdiNumberPattern", this._onDdiNumberPatternChanged);
		ICTouchAPI.settingServices.getSetting("DdiNumberPattern", this, this._onDdiNumberPatternChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "DDIRange", this._onDDIRangeChanged);
		ICTouchAPI.settingServices.getSetting("DDIRange", this, this._onDDIRangeChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "RoomName", this._onObjRoomNameChanged);
		ICTouchAPI.settingServices.getSetting("RoomName", this, this._onObjRoomNameChanged);
	},

	dump : function(boolAdvancedLogs) {
		this.inherited(arguments);
		ICTouchAPI.debugServices.dump("Hotel settings :");
		ICTouchAPI.debugServices.dump(" - DisplayedNameCheckout: " + this.data.getDisplayedNameCheckout());
		ICTouchAPI.debugServices.dump(" - DisplayedInfoCheckin: " + this.data.getDisplayedInfoCheckin());
		ICTouchAPI.debugServices.dump(" - DisplayedInfoCheckout: " + this.data.getDisplayedInfoCheckout());
		ICTouchAPI.debugServices.dump(" - DdiNumberPattern: " + this.data.getDdiNumberPattern());
		ICTouchAPI.debugServices.dump(" - DDIRange: " + dojo.toJson(this.data.getDDIRange()));
		ICTouchAPI.debugServices.dump(" - RoomName: " + dojo.toJson(this.data.getObjRoomName()));
		ICTouchAPI.debugServices.dump("boolCheckIn: " + this.data.boolCheckIn);
		ICTouchAPI.debugServices.dump("Checkin state (boolCheckIn): " + this.data.boolCheckIn);
		ICTouchAPI.debugServices.dump("guestName: " + this.data.guestName);
		ICTouchAPI.debugServices.dump("guestNumber: " + this.data.guestNumber);
		ICTouchAPI.debugServices.dump("setNumber: " + this.data.setNumber);
		if (boolAdvancedLogs) {
			ICTouchAPI.debugServices.dump("strLastFirstLineSet: " + this.data.strLastFirstLineSet);
			ICTouchAPI.debugServices.dump("strLastSecondLineSet: " + this.data.strLastSecondLineSet);
		}
	},

	_presentationLoaded:function(){
		ICTouchAPI.eventServices.unsubscribeToEvent(this,"presentationLoaded");
		dojo.publish("ModeHotel");
	},

	// GuestCheckIn event, indicates that a resetToDefault has been performed
	notifyGuestCheckIn : function(boolCheckInState) {
		ICTouchAPI.debugServices.info("webapp.hotel.controlBase - notifyGuestCheckIn");
		this.data.boolCheckIn = boolCheckInState;
		ICTouchAPI.debugServices.debug("webapp.hotel.controlBase - notifyGuestCheckIn / boolCheckInState is: " + this.data.boolCheckIn);
		ICTouchAPI.notificationServices.resetNotifications();
		// reload the userinfo display if needed (avoid problems if the event GuestCheckIn is received after the event GuestInfo
		this.computeUserInfoDisplay();
		//Go back to first page on Homepage Standard
		dojo.publish("homepageStandard/changePage",[1]);
		dojo.publish("OpenHomepage");
	},

	setNamesSettings : function(objInfo) {
		ICTouchAPI.debugServices.info("webapp.hotel.controlBase - setNamesSettings");
		ICTouchAPI.debugServices.debug("webapp.hotel.controlBase - setNamesSettings / objInfo is: " + dojo.toJson(objInfo));

		// Update class attributes
		this.data.guestName = objInfo.guestName;
		this.data.guestNumber = objInfo.guestNumber;
		this.data.setNumber = objInfo.setNumber;  // not used currently

		// Update display of userinfo area (if needed)
		this.computeUserInfoDisplay();
	},


	// Call i18nServices with the language in argument.
    notifyLanguage : function(objLanguage) {
		if(this.languageTimeout){
			clearTimeout(this.languageTimeout);
		}
		var func = function(){
			ICTouchAPI.debugServices.info("webapp.hotel.controlBase - notifyLanguage");
			var strLanguageCountry = objLanguage.value;
			// Notify the i18nServices about language change.
			if(strLanguageCountry){
				ICTouchAPI.debugServices.debug("webapp.hotel.controlBase - notifyLanguage / change language of i18nServices, new language is : " + strLanguageCountry);
				ICTouchAPI.i18nServices.changeLanguage(strLanguageCountry);
			}
		}
		this.languageTimeout = setTimeout(func,10000);
    },

	// This element contains a boolean and a deposit number
	//callback on FrontdeskMessageNotification event
	//context of the callback : webapp.hotel
   notifyMessage : function() {
		var objArguments = ICTouchAPI.tools.getEventArguments(arguments);
		var activation = objArguments.activation || "";
		var depositNumber = objArguments.depositNumber || "";

		if (activation) {
			ICTouchAPI.ledServices.activate('communication', 'N_HOTEL');
			ICTouchAPI.notificationServices.addNotification({
				strNotificationName : "HotelMessageNotification",
				strNotificationLabel: 'Message',
				intNotificationValue : 1,
				callback : function() {ICTouchAPI.APIServices.Telephony.startPhoneCall({params:[depositNumber, false, true, false]});} // false indicates it does not hide identity
			});
		} else {
			ICTouchAPI.ledServices.desactivate('communication', 'N_HOTEL');
			ICTouchAPI.notificationServices.removeNotification("HotelMessageNotification");
		}

    },

	languageChanged : function() {
		ICTouchAPI.debugServices.info("webapp.hotel.controlBase - languageChanged");
		// When the language change, if the phone is in checkin state and the setting DisplayedInfoCheckin is set to room_name, apply the DM translation
		if ((this.data.boolCheckIn && this.data.getDisplayedInfoCheckin() == 2) // phone in checkin and DisplayedInfoCheckin is set to room_name -> applyRoomNameDMTranslation
			|| (!this.data.boolCheckIn && this.data.getDisplayedInfoCheckout() == 2)) { // phone in checkout and DisplayedInfoCheckout is set to room_name -> applyRoomNameDMTranslation
			ICTouchAPI.debugServices.debug("webapp.hotel.controlBase - languageChanged / language changed and phone is in checkin with setting DisplayedInfoCheckin set to room_name, or in checkout with setting DisplayedInfoCheckout set to room_name: applyRoomNameDMTranslation");
			var translatedRoomName = this.applyRoomNameDMTranslation();
			if (translatedRoomName != this.data.strLastSecondLineSet) {
				ICTouchAPI.settingServices.setSettingValue("UserName",translatedRoomName);
				this.data.strLastSecondLineSet = translatedRoomName;
			}
		}
	},

	computeUserInfoDisplay : function() {
		ICTouchAPI.debugServices.info("webapp.hotel.controlBase - computeUserInfoDisplay");
		var strFirstLine = "";
		var strSecondLine = "";

		if (this.data.boolCheckIn) {
			ICTouchAPI.debugServices.debug("webapp.hotel.controlBase - computeUserInfoDisplay / Set first line and second line for checkin state");
			strFirstLine = this.data.guestName;
			ICTouchAPI.debugServices.debug("webapp.hotel.controlBase - computeUserInfoDisplay / First line is guestName: " + strFirstLine);
			switch (this.data.getDisplayedInfoCheckin()) {
				case 0: // 0 = nothing
					strSecondLine = "";
					ICTouchAPI.debugServices.debug("webapp.hotel.controlBase - computeUserInfoDisplay / DisplayedInfoCheckin = " + this.data.getDisplayedInfoCheckin() + " -> second line is empty");
					break;

				case 1: // 1 = user_number
					strSecondLine = this.data.guestNumber;
					ICTouchAPI.debugServices.debug("webapp.hotel.controlBase - computeUserInfoDisplay / DisplayedInfoCheckin = " + this.data.getDisplayedInfoCheckin() + " -> second line is user_number: " + strSecondLine);
					break;

				case 2: // 2 = room_name
					strSecondLine = this.applyRoomNameDMTranslation();
					ICTouchAPI.debugServices.debug("webapp.hotel.controlBase - computeUserInfoDisplay / DisplayedInfoCheckin = " + this.data.getDisplayedInfoCheckin() + " -> second line is room_name: " + strSecondLine);
					break;

				case 3: // 3 = DDI_number
					strSecondLine = this.computeDDINumber(this.data.guestNumber);
					if (!strSecondLine) { // if the computation of DDINumber failed, display room name
						strSecondLine = this.applyRoomNameDMTranslation();
					}
					ICTouchAPI.debugServices.debug("webapp.hotel.controlBase - computeUserInfoDisplay / DisplayedInfoCheckin = " + this.data.getDisplayedInfoCheckin() + " -> second line is DDI_number: " + strSecondLine);
					break;

				default: // default: 1 = user_number
					strSecondLine = this.data.guestNumber;
					ICTouchAPI.debugServices.warning("webapp.hotel.controlBase - computeUserInfoDisplay / DisplayedInfoCheckin is not 0, 1, 2 or 3");
					ICTouchAPI.debugServices.warning("webapp.hotel.controlBase - computeUserInfoDisplay / DisplayedInfoCheckin = " + this.data.getDisplayedInfoCheckin() + " -> set second line to user_number: " + strSecondLine);
					break;
			}
		}
		else {
			ICTouchAPI.debugServices.debug("webapp.hotel.controlBase - computeUserInfoDisplay / Set first line and second line for checkout state");
			switch (this.data.getDisplayedNameCheckout()) {
				case 0: // 0 = nothing
					strFirstLine = "";
					ICTouchAPI.debugServices.debug("webapp.hotel.controlBase - computeUserInfoDisplay / DisplayedNameCheckout = " + this.data.getDisplayedNameCheckout() + " -> first line is empty");
					break;

				case 1: // 1 = room_set_name
					strFirstLine = this.data.guestName;
					ICTouchAPI.debugServices.debug("webapp.hotel.controlBase - computeUserInfoDisplay / DisplayedNameCheckout = " + this.data.getDisplayedNameCheckout() + " -> second line is room_set_name: " + strSecondLine);
					break;

				default: // default: 1 = room_set_name
					strFirstLine = this.data.guestName;
					ICTouchAPI.debugServices.warning("webapp.hotel.controlBase - computeUserInfoDisplay / DisplayedNameCheckout is not 0, or 1");
					ICTouchAPI.debugServices.warning("webapp.hotel.controlBase - computeUserInfoDisplay / DisplayedNameCheckout = " + this.data.getDisplayedNameCheckout() + " -> set first line to room_set_name: " + strFirstLine);
					break;
			}

			ICTouchAPI.debugServices.debug("webapp.hotel.controlBase - computeUserInfoDisplay / First line is guestName: " + strFirstLine);
			switch (this.data.getDisplayedInfoCheckout()) {
				case 0: // 0 = nothing
					strSecondLine = "";
					ICTouchAPI.debugServices.debug("webapp.hotel.controlBase - computeUserInfoDisplay / DisplayedInfoCheckout = " + this.data.getDisplayedNameCheckout() + " -> second line is empty");
					break;

				case 1: // 1 = user_number
					strSecondLine = this.data.guestNumber;
					ICTouchAPI.debugServices.debug("webapp.hotel.controlBase - computeUserInfoDisplay / DisplayedInfoCheckout = " + this.data.getDisplayedNameCheckout() + " -> second line is user_number: " + strSecondLine);
					break;

				case 2: // 2 = room_name
					strSecondLine = this.applyRoomNameDMTranslation();
					ICTouchAPI.debugServices.debug("webapp.hotel.controlBase - computeUserInfoDisplay / DisplayedInfoCheckout = " + this.data.getDisplayedNameCheckout() + " -> second line is room_name: " + strSecondLine);
					break;

				default: // default: 1 = user_number
					strSecondLine = this.data.guestNumber;
					ICTouchAPI.debugServices.warning("webapp.hotel.controlBase - computeUserInfoDisplay / DisplayedInfoCheckout is not 0, 1, 2 or 3");
					ICTouchAPI.debugServices.warning("webapp.hotel.controlBase - computeUserInfoDisplay / DisplayedInfoCheckout = " + this.data.getDisplayedNameCheckout() + " -> set second line to user_number: " + strSecondLine);
					break;
			}
		}
		// update settings/display if needed
		if (strFirstLine != this.data.strLastFirstLineSet) {
			ICTouchAPI.debugServices.debug("webapp.hotel.controlBase - computeUserInfoDisplay / First line has changed from " + this.data.strLastFirstLineSet + " to " + strFirstLine + ", update it.");
			ICTouchAPI.settingServices.setSettingValue("UserFirstName", strFirstLine /*guestName*/);
			this.data.strLastFirstLineSet = strFirstLine;
		} else {
			ICTouchAPI.debugServices.debug("webapp.hotel.controlBase - computeUserInfoDisplay / No need to refresh first userinfo line (was " + this.data.strLastFirstLineSet + ", computation gives " + strFirstLine + "), no need to update it.");
		}
		if (strSecondLine != this.data.strLastSecondLineSet) {
			ICTouchAPI.debugServices.debug("webapp.hotel.controlBase - computeUserInfoDisplay / Second line has changed from " + this.data.strLastSecondLineSet + " to " + strSecondLine + ", update it.");
			ICTouchAPI.settingServices.setSettingValue("UserName",strSecondLine /*guestNumber*/);//+" "+setNumber);
			this.data.strLastSecondLineSet = strSecondLine;
		} else {
			ICTouchAPI.debugServices.debug("webapp.hotel.controlBase - computeUserInfoDisplay / No need to refresh second userinfo line (was " + this.data.strLastSecondLineSet + ", computation gives " + strSecondLine + "), no need to update it.");
		}
	},

	// return room name label with DM translation if exist
	applyRoomNameDMTranslation : function() {
		ICTouchAPI.debugServices.info("webapp.hotel.controlBase - applyRoomNameDMTranslation");
		var roomName = "";
		var arrRoomName = this.data.getObjRoomName();
		if(arrRoomName) {
			// manage the case of the setting RoomName beeing an object containing translations for the room name
			if (typeof arrRoomName === "object") {
				ICTouchAPI.debugServices.debug("webapp.hotel.controlBase - applyRoomNameDMTranslation / _arrRoomName is an object, use it for getting translation");
				var currentLocal = ICTouchAPI.i18nServices.getLocale();
				if(arrRoomName[currentLocal]){
					roomName = arrRoomName[currentLocal];
					ICTouchAPI.debugServices.debug("webapp.hotel.controlBase - applyRoomNameDMTranslation / currentLocal is " + currentLocal + " and translation is defined for this local, apply it: " + roomName);
				}
				else if (arrRoomName['en']) {
					roomName = arrRoomName['en'];
					ICTouchAPI.debugServices.debug("webapp.hotel.controlBase - applyRoomNameDMTranslation / currentLocal is " + currentLocal + " but no translation is defined for this local, apply english translation: " + roomName);
				}
				else {
					roomName = "";
					ICTouchAPI.debugServices.debug("webapp.hotel.controlBase - applyRoomNameDMTranslation / currentLocal is " + currentLocal + " but no translation is defined for this local and for english, define empty string: " + roomName);
				}
			}
			// manage the case of the setting RoomName beeing a simple string (no translation to use)
			else if (typeof arrRoomName === "string") {
				roomName = arrRoomName;
				ICTouchAPI.debugServices.debug("webapp.hotel.controlBase - applyRoomNameDMTranslation / _arrRoomName is a string, use it directly as room name: " + roomName);
			}
		}
		ICTouchAPI.debugServices.info("webapp.hotel.controlBase - applyRoomNameDMTranslation done $ return roomName = " + roomName);
		return roomName;
	},

	// return DDINumber if possible, otherwise return the room name
	computeDDINumber : function(strGuestNumber) {
		ICTouchAPI.debugServices.info("webapp.hotel.controlBase - computeDDINumber");
		var intGuestNumber = parseInt(strGuestNumber, 10)
		var arrDDIRange = this.data.getDDIRange();
		var strDDIPattern = this.data.getDdiNumberPattern();
		var strDDINumber = "";
		// Check data consistency
		if(strGuestNumber && intGuestNumber
			&& strDDIPattern && typeof strDDIPattern === "string"
			&& arrDDIRange && typeof arrDDIRange === "object" && arrDDIRange.length == 2 && typeof arrDDIRange[0] === "number" && typeof arrDDIRange[1] === "number") {
			// Chack that guestNumber is well in the DDI range
			if (intGuestNumber >= arrDDIRange[0] && intGuestNumber <= arrDDIRange[1]) {
				ICTouchAPI.debugServices.debug("webapp.hotel.controlBase - computeDDINumber / guestNumber: " + strGuestNumber + " is well in the DDI range (min: " + arrDDIRange[0] + ", max: " + arrDDIRange[1] + "), compute DDI number");
				strDDINumber = this.processDDINumberComputation(strGuestNumber, strDDIPattern);
			}
			else {
				ICTouchAPI.debugServices.warning("webapp.hotel.controlBase - computeDDINumber / Guest number is not in the DDI range, not possible to compute the DDINumber. intGuestNumber: " + intGuestNumber + ", arrDDIRange: " + dojo.toJson(arrDDIRange));
			}
		}
		else {
			ICTouchAPI.debugServices.error("webapp.hotel.controlBase - computeDDINumber / Parameters given to computeDDINumber are wrong, not possible to compute the DDINumber");
			ICTouchAPI.debugServices.error("webapp.hotel.controlBase - computeDDINumber / Parameters are: strGuestNumber: " + strGuestNumber + " | intGuestNumber: " + intGuestNumber + " | strDDIPattern: " + strDDIPattern + " | arrDDIRange: " + dojo.toJson(arrDDIRange));
		}
		ICTouchAPI.debugServices.info("webapp.hotel.controlBase - computeDDINumber done $ return strDDINumber = " + strDDINumber);
		return strDDINumber;
	},

	processDDINumberComputation : function(strGuestNumber, strDDIPattern) {
		var DDINumber = "";
		var tmp = "";
		var i;
		var j = strGuestNumber.length-1;
		for (i = strDDIPattern.length-1 ; i >= 0 ; i--) {
			if (strDDIPattern[i] == '*' && j>=0) {
				tmp = strGuestNumber[j];
				j--;
			}
			else {
				tmp = strDDIPattern[i];
			}
			DDINumber = tmp + DDINumber;
		}
		strGuestNumber = null;
		strDDIPattern = null;
		return DDINumber;
	},

	_onInitCheckinState: function(objSetting) {
		this.data.boolCheckIn = (objSetting && objSetting.jsValue) ? true : false;
		objSetting = null;
	},

	_onDisplayedNameCheckoutChanged : function(objSetting) {
		// Create default for room_set_name when not available
		var value = objSetting ? parseInt(objSetting.jsValue, 10) : 1;
		this.data.setDisplayedNameCheckout(value);
		// reload the userinfo display if needed
		this.computeUserInfoDisplay();
		objSetting = null;
	},

	_onDisplayedInfoCheckinChanged : function(objSetting) {
		// Create default for user_number when not available
		var value = objSetting ? parseInt(objSetting.jsValue, 10) : 1;
		this.data.setDisplayedInfoCheckin(value);
		// reload the userinfo display if needed
		this.computeUserInfoDisplay();
		objSetting = null;
	},

	_onDisplayedInfoCheckoutChanged : function(objSetting) {
		// Create default for user_number when not available
		var value = objSetting ? parseInt(objSetting.jsValue, 10) : 1;
		this.data.setDisplayedInfoCheckout(value);
		// reload the userinfo display if needed
		this.computeUserInfoDisplay();
		objSetting = null;
	},

	_onDdiNumberPatternChanged : function(objSetting) {
		// Create default for empty string when not available
		var strDdiNumberPattern;
		if (objSetting && objSetting.jsValue && typeof objSetting.jsValue === "string") {
			strDdiNumberPattern = objSetting.jsValue;
		}
		else {
			strDdiNumberPattern = "";
			ICTouchAPI.debugServices.warning("webapp.hotel.controlBase - _onDdiNumberPatternChanged / the setting DdiNumberPattern is wrongly defined");
		}
		this.data.setDdiNumberPattern(strDdiNumberPattern);
		// reload the userinfo display if needed
		this.computeUserInfoDisplay();
		objSetting = null;
	},

	_onDDIRangeChanged : function(objSetting) {
		// Create default for empty array when not available
		var arrDDIRange;
		if (objSetting && objSetting.jsValue) {
			arrDDIRange = dojo.fromJson(objSetting.jsValue);
		}
		else {
			arrDDIRange = [];
			ICTouchAPI.debugServices.warning("webapp.hotel.controlBase - _onDDIRangeChanged / the setting DDIRange is wrongly defined");
		}
		this.data.setDDIRange(arrDDIRange);
		// reload the userinfo display if needed
		this.computeUserInfoDisplay();
		objSetting = null;
	},

	_onObjRoomNameChanged : function(objSetting) {
		// Create default for empty object when not available
		var roomName = "";
		if (objSetting && objSetting.jsValue && typeof objSetting.jsValue === "string") {
			if (objSetting.jsValue.match("[{}]")) { // setting is an object containg the DM translations, parse it
				roomName = dojo.fromJson(objSetting.jsValue);
			}
			else { // setting is a string, use it directy for display
				roomName = objSetting.jsValue;
			}
		}
		this.data.setObjRoomName(roomName);
		// reload the userinfo display if needed
		this.computeUserInfoDisplay();
		objSetting = null;
	}

});

