dojo.provide("webapp.contacts.controlBase");
dojo.declare("webapp.contacts.controlBase", ICTouchAPI.webApplication,
{
	arrRegisteredContainers : [],
	intIdContainer			: 0,
	overriddenParams		: null,
	currentStatus			: 0,
	deletePopUp				: null,
	displayName             : "",
	contactId               : null,
	collaborationId         : null,

	// Widgets
	mainWidget				: null,
	contactList				: null,
	contactsPK				: null,

	constructor : function() {
		ICTouchAPI.skinServices.linkWebappsStyles("UIElements.Keyboard","webapp.contacts", true, true, true);

		ICTouchAPI.tools.registerHomepageButton(["webapp.contacts.getContact", "CONTACT_BTN", "contacts-application", _('ContactsBtn','webapp.contacts'),"",function(){webapp.contacts.onContactsEnter()}]);
		ICTouchAPI.tools.registerHomepageKey(["webapp.contacts.getContact", "CONTACT_BTN", "contacts-application", _('ContactsBtn','webapp.contacts'),"",function(){webapp.contacts.onContactsEnter()}]);

		ICTouchAPI.tools.registerHomepageKey(["webapp.contacts.getContact", "CONTACTS_FAVORITES_BTN", "contacts-favorites-application", _('FavoritesBtn','webapp.contacts'),"",function(){webapp.contacts.onFavoritesEnter()}]);

		// suscribe to module IctDirectory events
		var myDS = ICTouchAPI.dataStoreServices.getStore('contacts');
		myDS.addEventListener(myDS.E_ITEM_ADDED,   this, this.OnContactReceiveDetails);
		myDS.addEventListener(myDS.E_ITEM_UPDATED, this, this.OnContactReceiveDetails);
		myDS.addEventListener(myDS.E_ITEM_REMOVED, this, this.OnContactDeleted);
		myDS.addEventListener(myDS.E_DATA_LOADED, this, this.OnContactSynchro);

		ICTouchAPI.eventServices.subscribeToEvent(this, "DIR_CONTACT_DB_FULL", this.onContactDbFull);
		ICTouchAPI.eventServices.subscribeToEvent(this, "IM_EVENT_GET_COLLABID_RESULT", this.handleGetCollaborationId);

		//link css to userinfo for the presence icons
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.userinfo","webapp.contacts");

		this.intIdContainer = 0;
		ICTouchAPI.settingServices.subscribeToSetting(this, "EnableContactsPreview", this._registerHomePageContainer);
		this.loadEnablePreview();

		dojo.subscribe("e_contact_showContact", this, this.showContact);
		dojo.subscribe("e_contact_editContact", this, this.editContact);

		dojo.subscribe("iframe.show", this, this.onShow);
		dojo.subscribe("iframe.hide", this, this.onHide);
	},

	loaded : function(){
		ICTouchAPI.settingServices.subscribeToSetting(this, "EnableContactsPictureInMenu", this.onEnableContactsPictureInMenu);
		ICTouchAPI.settingServices.getSetting("EnableContactsPictureInMenu", this, this.onEnableContactsPictureInMenu);
		
		ICTouchAPI.settingServices.subscribeToSetting(this, "IMAvailable", this.onIMAvailableChanged);
		ICTouchAPI.settingServices.getSetting("IMAvailable", this, this.onIMAvailableChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "TelephonyPresenceAvailable", this.onTelephonyPresenceAvailableChanged);
		ICTouchAPI.settingServices.getSetting("TelephonyPresenceAvailable", this, this.onTelephonyPresenceAvailableChanged);
		dojo.subscribe("InBuddyList",this,this.inBuddyList);
		ICTouchAPI.settingServices.getSetting("EnableAddContactButton",this, this.onEnabledAdd);

	},

    onShow : function(strCurrentFrameId) {
        if (strCurrentFrameId === "webapp.contacts.getContact" && this.data.getContainerPath() !== "webapp.contacts.getContactEdition") {
			ICTouchAPI.debugServices.debug("webapp.contacts.controlBase - onShow / strCurrentFrameId is getContact and the container path is not getContactEdition: call loadDetails");
            this.data.loadDetails(this.data.intDisplayedContactId);
        }
    },

	onEnabledAdd : function(objSetting){
		if(objSetting && objSetting.jsValue === false){
			webapp.contacts.data.onHotelMode(true);
		}
		else if(! objSetting || objSetting.jsValue === true){
			webapp.contacts.data.onHotelMode(false);
        }
    }, 

	onHide : function(strCurrentFrameId){
		if(strCurrentFrameId == "webapp.contacts.getContact"){
			this.data._removePreviousRemoteContact(true);
		}
	},

	onFavoritesEnter : function(intIndex){
		if(intIndex !== undefined){
			this.data.setIntSelectFavoriteId(intIndex);
		}

		ICTouchAPI.transitionServices.getScreen({
			name: "webapp.contacts.getContact",
			params: {},
			sync: false
		});

		if(this.contactList){
			// Select the title + execute callback
			this.contactList.selectTitleById(this.data.menuIds.FAVORITE);
			if(intIndex){
				this.data.objFavoriteList.selectItemByIndex(intIndex, true)
			}
		} else {
			this.data.setTabToLoad(this.data.menuIds.FAVORITE);
		}
	},

	onContactsEnter : function() {
		ICTouchAPI.transitionServices.getScreen({
			name: "webapp.contacts.getContact",
			params: {},
			sync: false 
		});
		if(this.contactList){
			// Select the title + execute callback
			this.contactList.selectTitleById(this.data.menuIds.CONTACT);
		}
	},

	inBuddyList : function(boolIsInBuddyList){
		webapp.contacts.data.boolIsInBuddyList=boolIsInBuddyList;
	},

	//ENABLE PREVIEW
	loadEnablePreview:function(){
		ICTouchAPI.settingServices.getSetting("EnableContactsPreview", this, this._registerHomePageContainer);
	},

	_registerHomePageContainer : function(objSetting){
		if (objSetting){
			if(objSetting.jsValue == true){
				ICTouchAPI.tools.registerHomepageContainer(["webapp.contacts.getContactPreview", this]);
			}else{
				ICTouchAPI.tools.unregisterHomepageContainer(["webapp.contacts.getContactPreview"]);
			}
		}

	},
	//END OF ENABLE PREVIEW

	onEnableContactsPictureInMenu : function(objSetting){
		if(objSetting){
			this.data.boolPictureInMenu = objSetting.jsValue;
		}
	},

	onTelephonyPresenceAvailableChanged : function(objSetting) {
		if(objSetting){
			this.data.boolTelephonyPresenceAvailable = objSetting.jsValue;
		}
	},

	onIMAvailableChanged : function(objSetting) {
		if(objSetting){
			this.data.boolIMPresenceAvailable = objSetting.jsValue;
		}
	},

	//adds an external capability, for other webapps to be able to add buttons to the webapp Contact
	addButton : function(button) {
		var objButton = new UIElements.AppButton.AppButtonControl(button);

		ICTouchAPI.AppBarServices.addOtherWebAppButton("contacts","contactsstatus"+this.data.STATUS_HOME, objButton);

		return objButton;
	},

	load: function() {
		//help
		var widgetsTab = [];
		for(var i=0; i<this.data.NB_STATUS; i++) {
			widgetsTab.push("contactsstatus"+i);
		}
		dojo.publish("needHelpEvent",["contacts",widgetsTab]);

		if(webapp.communication) {
			this.data.arrComSelectStatus[-1] = {label: "Call", icon: "communication-call"};
			this.data.arrComSelectStatus[webapp.communication.data.STATUS_ADD_PARTICIPANT] = {label: "Add", icon: "communication-conference-add-participant"};
			this.data.arrComSelectStatus[webapp.communication.data.STATUS_TRANSFER_TO] = {label: "Transfer to", icon: "communication-deflect-to-default"};
			this.data.arrComSelectStatus[webapp.communication.data.STATUS_DEFLECT_TO] = {label: "Default deflect", icon: "communication-transfer-to"};
			this.data.arrComSelectStatus[webapp.communication.data.STATUS_PROGKEYS_CALL] = {label: _("Add shortcut", "webapp.communication"), icon: "progkeys-add"};
			this.data.arrComSelectStatus[webapp.communication.data.STATUS_PROGKEYS_ROUTING] = {label: _("Add shortcut", "webapp.communication"), icon: "progkeys-add"};
			this.data.arrComSelectStatus[webapp.communication.data.STATUS_MDR_ROUTING] = {label: "Ok", icon: "generic-ok"};
			this.data.arrComSelectStatus[webapp.communication.data.STATUS_MDR_OVERFLOW] = {label: "Ok", icon: "generic-ok"};
			this.data.arrComSelectStatus[webapp.communication.data.STATUS_MDR_USER] = {label: "Ok", icon: "generic-ok"};
			this.data.arrComSelectStatus[webapp.communication.data.STATUS_BASIC_ADD_ROUTING] = {label: "Ok", icon: "generic-ok"};
			this.data.arrComSelectStatus[webapp.communication.data.STATUS_BASIC_IMMEDIATE_ROUTING] = {label: "Ok", icon: "generic-ok"};
			dojo.subscribe("CommunicationSelectStatusChange", this, this.onComSelectStatusChange);
		}
	},

	setHomepageContainer : function (strWebapp, div) {
		this.previewContainer = new this.getContactPreview({ }, div);
		// load the preview contact
		this.data.loadPreviewList();
	},

	buttonCallback : function(buttonId) {
		//var data = webapp.contacts.data;
		switch(buttonId)
		{
			case this.data.BACK:
				switch(this.data.strContainerPath)
				{
					case "webapp.contacts.getContactEdition" :
                        this.onSaveContact();
						break;
					default :
						if (this.overriddenParams && this.overriddenParams.clbkBack) {
							this.overriddenParams.clbkBack();
							delete this.overriddenParams.clbkBack;
						} else {
							dojo.publish("OpenHomepage");
						}
						break;
				}
				break;
			case this.data.INPREVIEW_BTN:
				this.manageInPreview();
				break;
			case this.data.CREATE_BTN:
				this.data.objLastViewedContact = dojo.clone(this.data.objCurrentContact);
				this.data.objCurrentContact = this.data.createEmptyContact();
				this.data.deselectSafe();
				this.data.switchContainer("getContactEdition", this.data.STATUS_EDITION, _("Add new contact", "webapp.contacts"));
				break;
			case this.data.EDIT_BTN:
				this._editCurrentContact();
				break;
			case this.data.DELETE_BTN:
				this.loadDeletePopup();
				break;
			case this.data.COPY_BTN:
				this.onCopyContact();
				break;
			/*case this.data.SAVE_CONTACT_BTN :
				console.log(this.data.objCurrentContact);
				this.onSaveContact(this.data.objCurrentContact);
				break;*/
			case this.data.CALL_BTN:
				var number = ICTouchAPI.tools.getContactPhone(this.data.objCurrentContact);
				if(number && webapp.communication) {
					//webapp.communication.mainWidget.emptyContactCard();
					webapp.communication.doContextStatusCall(number, true, this.data.objCurrentContact);
					if(this.currentStatus == this.data.STATUS_MDR_ROUTING || this.currentStatus == this.data.STATUS_MDR_OVERFLOW || this.currentStatus == this.data.STATUS_MDR_USER){
						if(this.mainWidget) {
							this.updateAppBar(this.data.STATUS_HOME);
							this.mainWidget.reloadContainer();
						}
						ICTouchAPI.transitionServices.back();
					}else{
						ICTouchAPI.transitionServices.getScreen({name: "webapp.communication.getCommunication",params: {}});
					}
				}
				break;
			case this.data.SEARCH_BTN:
				var objSearch = {
					contactDataTypes: [],
					secondaryInformation : "phoneNumber", // information of the contact to be displayed at the right of the contact's display name in the search results
					// define a right icon for the search results, for which the callback is to display the contact card
					rightIconClickCallback: {
						neededData : "Contact",
						rightIconImage  : "contacts-card-32",
						rightIconImageRemoteContact : "contacts-contact-card-remote-32",
						context:webapp.contacts,
						func:webapp.contacts.onContactFound
					}
					//boolForceByname : true
				};
				if (webapp.communication) {
					// define the action for the search results (click on the line of on the left icon), for which the callback is to call the contact
					objSearch.lineClickCallback = {
						neededData : "phoneNumber",
						leftIconImage  : "communication-call-32",
						leftIconImageConditionnalDisplay  : "phoneNumber",
						context:webapp.communication,
						func: function (strNumber) {
							webapp.communication.apiCall(strNumber, true);
						}
					}
				}
				else {
					// define the action for the search results (click on the line of on the left icon), no communication available -> display the contact card
					objSearch.lineClickCallback = {
						neededData : "Contact",
						context:webapp.contacts,
						func:webapp.contacts.onContactFound
					}
				}

				if (webapp.search) {
					webapp.search.doSearch(objSearch, function() {
						ICTouchAPI.transitionServices.getScreen({
							name: "webapp.contacts.getContact",
							params: {}
						});
					});
				}
				break;
			default :
				ICTouchAPI.debugServices.warning("webapp.contacts.controlBase - buttonCallback / No callback is associated with this button! (id: buttonId = " + buttonId + ")");
				break;
		}
	},

	//callback of the event IM_GET_COLLABID_RESULT
	handleGetCollaborationId: function() {
		var arrArguments=ICTouchAPI.tools.getEventArguments(arguments);
		var collId=arrArguments["collaborationId"];
		var loginName=arrArguments["login"];
		//if we have a good collaborationID then assign it to the contact and show the add button
		if (collId) {
			//if we have the right collId , then assign it to the contact
			if (this.data.objCurrentContact.loginName == loginName) {
				this.data.objCurrentContact.collaborationId = collId;
				if(this.mainWidget){
					this.mainWidget.reloadContainer();
				}
			}
			}
	},

	onContactFound : function(objContact)
	{
		this.showContact({
			objContact: objContact,
			clbkBack: function() {
				ICTouchAPI.transitionServices.getScreen({
					name: "webapp.search.getSearch",
					params: {}
				});
			}
		});
	},

	onContactDbFull : function() {
		this.data.objCurrentContact = null;
		this.mainWidget.reloadMenu();
	},

	onCreateContact : function(status){
		if (status != 0) {
			if(this.data._boolChangeScreen===true) {
				this.data._boolChangeScreen = false;
				dojo.publish("unlockTransition",[false]);
			}
			this.checkError(status);
		}
		else {
			if(this.data._boolChangeScreen===true) {
				this.data._boolChangeScreen = false;
				dojo.publish("unlockTransition",[true]);
			}
		}
	},

	onModifyContact : function(status){
		if (status != 0) {
			if(this.data._boolChangeScreen===true) {
				this.data._boolChangeScreen = false;
				dojo.publish("unlockTransition",[false]);
			}
			this.checkError(status);
		}
		else {
			if(this.data._boolChangeScreen===true) {
				this.data._boolChangeScreen = false;
				dojo.publish("unlockTransition",[true]);
			}
		}
	},

	onCancelSaveContact : function(){
		if(this.data._boolChangeScreen===true) {
			this.data._boolChangeScreen = false;
			dojo.publish("unlockTransition",[true]);
		}
	},

	selectSafeAfterCancelSaveContact : function(){
		// if a contact was previously selected when creation is canceled, refresh it in 2/3
		if (this.data.objLastViewedContact && this.data.objLastViewedContact.contactId) {
			this.data.selectSafeByIndex(this.data.objLastViewedContact.contactId, false);
			this.data.loadDetails(this.data.objLastViewedContact.contactId);
		}
		// if no contact was previously selected, select the first one
		else {
			// reset objCurrentContact (for the case there is no contacts)
			this.data.objCurrentContact = undefined;
			this.data.objCurrentEditedContact = undefined;
			if (this.data.objContactList && this.data.objContactList.arrItems[0] && this.data.objContactList.arrItems[0].objContact.contactId) {
				this.data.selectContactByPosition(0,false);
				this.data.loadDetails(this.data.objContactList.arrItems[0].objContact.contactId);
			}
			else {
				this.data.loadDetails(undefined);
			}
		}
		this.data.switchContainer("getContactCard", this.data.STATUS_HOME);
	},

	onDeleteContact : function(status){
		if (status != 0) {
			this.checkError(status);
		}
	},

	onContactPreviewCreated :function(idContact) {
		this.data.updateContactInPreview(idContact.value, true);
	//webapp.contacts.data.intSelectContactId = idContact.value;
	//this.data.loadContactList();
	},

	onContactPreviewDeleted :function(idContact) {
		this.data.updateContactInPreview(idContact.value, false);
	},

	/**
	 * When click on copy button
	 */
	onCopyContact : function ()	{
		this.data.objCurrentContact.isRemote = false; // contact will now be not remote
		this.data.objCurrentContact.isPrivate = 1; // contact will now be private
		this.data.objCurrentContact.isPreviewed = 0; // contact will be added as not previewed
		this.data.objCurrentContact.type = ICTouchAPI.tools.enumContactType.LOCAL; // contact type will now be local
		ICTouchAPI.APIServices.IctDirectory.createLocalContact({
			params:["createContactReqId", this.data.objCurrentContact],
			context:this,
			callback: this.onCreateContact
		});
		// Remove the remote contact
		this.data._removePreviousRemoteContactById(this.data.objCurrentContact.contactId);
		this.data.switchContainer("getContactCard",this.data.current_status);
	},

	/**
	 * When saving contact
	 * return:
	 *  1 if the contact has been modified and saved
	 *  0 if the contact has not been modified and saving was canceled
	 *  -1 if the contact saving has failed
	 */
	onSaveContact : function (boolNoRefresh)	{
		// before saving, check is the contact was edited
		// use compareObjects to check if the contact is empty before trying to save it
		if (ICTouchAPI.tools.compareObjects(this.data.objCurrentEditedContact, this.data.createEmptyContact()) ||
			ICTouchAPI.tools.compareObjects(this.data.objCurrentEditedContact, this.data.objLastViewedContact)) {
			if (!boolNoRefresh) {
			// if a contact was previously selected when creation is canceled, refresh it in 2/3
			this.selectSafeAfterCancelSaveContact();
				}
			// unlock the screen to allow switching to another webapp
			this.onCancelSaveContact();
			return 0; // return 0:
		}
		// The contact is modified, save the changes
		else {
			// check if the name of the contact has been filled before trying to save it
			if (!this.data.objCurrentEditedContact.name || this.data.objCurrentEditedContact.name.trim().length < 1) {
				this.checkError(10);
				if(this.data._boolChangeScreen===true) {
					this.data._boolChangeScreen = false;
					dojo.publish("unlockTransition",[false]);
				}
				return -1;
			}
			//Check if entered emails are valid
			var expMailValid=new RegExp("^[A-Z0-9._%-]+@[A-Z0-9.-]+\\.[A-Z]+$","i");
			if((this.data.objCurrentEditedContact.email && !expMailValid.test(this.data.objCurrentEditedContact.email)) || 
				(this.data.objCurrentEditedContact.personalEmail && !expMailValid.test(this.data.objCurrentEditedContact.personalEmail))) {				
				this.checkError(11);
				if(this.data._boolChangeScreen===true) {					
					this.data._boolChangeScreen = false;
					dojo.publish("unlockTransition",[false]);
				}
				return -1;
			}

			// Création du Spinner
			this.createSaveSpinner();

			// if not a new contact, modify else create
			if (this.data.objCurrentEditedContact.contactId != -1) {
				ICTouchAPI.APIServices.IctDirectory.modifyLocalContact({
					params:["modifyContactReqId", this.data.objCurrentEditedContact],
					context:this,
					callback:this.onModifyContact
				});
				//modify also th LastViewedContact
				this.data.objLastViewedContact = dojo.clone(this.data.objCurrentEditedContact);
			}
			else {
				this.data.objCurrentEditedContact.isPrivate = 1; // created contact is private (added in local directory)
				this.data.objCurrentEditedContact.isPreviewed = (this.data.getDisplayedMenu() == this.data.menuIds.FAVORITE ? 1 : 0 ); // contact is added as not previewed
				this.data.objCurrentEditedContact.type = ICTouchAPI.tools.enumContactType.LOCAL; // contact type is local
				// crms00287809 V.Vyskocil
				if(!this.data.objCurrentEditedContact.firstName) {
					this.data.objCurrentEditedContact.firstName='';
				}
				// crms00287809 end
				ICTouchAPI.APIServices.IctDirectory.createLocalContact({
					params:["createContactReqId", this.data.objCurrentEditedContact],
					context:this,
					callback: this.onCreateContact
				});
			}
			this.data.objCurrentContact = this.data.objCurrentEditedContact;
			this.data.objCurrentEditedContact = null;
			// return to the ContactCard in all case
			//this.data.switchContainer("getContactCard", this.data.current_status);
			this.data.strContainerPath = 'webapp.contacts.getContactCard';
			if (!boolNoRefresh) {
				webapp.contacts.data.loadDetails(webapp.contacts.data.objCurrentContact.contactId);
			}
			return 1;
		}
	},

    createSaveSpinner : function() {
		this.destroySaveSpinner();
		this._objSpinner = new UIElements.Spinner.SpinnerControl({strMessage : _('Save in progress...', "webapp.contacts"), boolForeground:true}, document.body);
		this._spinnerHandler = setTimeout(dojo.hitch(this, this.destroySaveSpinner), 1000);
	},

	destroySaveSpinner : function() {
		if(this._objSpinner){
			this._objSpinner.destroy();
			this._objSpinner = null;
		}
		if(this._spinnerHandler){
			clearTimeout(this._spinnerHandler);
			this._spinnerHandler = null;
		}
	},

	createFavoriteSpinner : function() {
		this.destroyFavoriteSpinner();
		this._objFavoriteSpinner = new UIElements.Spinner.SpinnerControl({strMessage : _("Please wait...", "ICTouchAPI"), boolForeground:true}, document.body);
		this._favoriteSpinnerHandler = setTimeout(dojo.hitch(this, this.spinnerTimeout), 8000);
	},
	
	spinnerTimeout : function() {
		// Deactivate the spinner
		this.destroyFavoriteSpinner();
		
		// Reload the button
		if (this._newPreviewContactId == this.data.objCurrentContact.contactId && this.data.objInPreviewBtnUI) {
			this.data.objCurrentContact.isPreviewed = !this.data.objCurrentContact.isPreviewed;
			(this.data.objCurrentContact.isPreviewed) ? this.data.objInPreviewBtnUI.setStatusIcon("notif-on") : this.data.objInPreviewBtnUI.setStatusIcon("notif-off");
		}
	},

	destroyFavoriteSpinner : function() {
		if(!this._destroyFavoriteSpinnerHandler){
			this._destroyFavoriteSpinnerHandler = setTimeout(dojo.hitch(this, this._destroyFavoriteSpinner), 1500);
		}
	},
	
	_destroyFavoriteSpinner : function() {
		if(this._objFavoriteSpinner){
			this._objFavoriteSpinner.destroy();
			this._objFavoriteSpinner = null;
		}
		if(this._favoriteSpinnerHandler){
			clearTimeout(this._favoriteSpinnerHandler);
			this._favoriteSpinnerHandler = null;
		}
		
		this._destroyFavoriteSpinnerHandler = null;
		
		// Also clear the stored contactId
		this._newPreviewContactId = null;
	},

	registerContainer : function(webappName) {
		var id = this.intIdContainer++;
		this.arrRegisteredContainers[id] = webappName;
		return id;
	},

	//manage the button InPreview
	manageInPreview : function() {
		// Activate spinner
		this.createFavoriteSpinner();
		
		// Save the current contact id
		this._newPreviewContactId = this.data.objCurrentContact.contactId;
		
		// Manually update the Favorite button status
		if (this.data.objInPreviewBtnUI) {
			(this.data.objCurrentContact.isPreviewed) ? this.data.objInPreviewBtnUI.setStatusIcon("notif-off") : this.data.objInPreviewBtnUI.setStatusIcon("notif-on");
		}
		
		if (this.data.objCurrentContact.isPreviewed)
		{
			ICTouchAPI.APIServices.IctDirectory.removeContactFromPreview({
				params: ["AddContactInPreviewReqID", this.data.objCurrentContact.contactId],
				context: this,
				callback: function(status) {
					if (status != 0) this.checkError(status);
				}
			});
		}
		else
		{
			ICTouchAPI.APIServices.IctDirectory.addContactToPreview({
				params: ["AddContactInPreviewReqID", this.data.objCurrentContact.contactId],
				context: this,
				callback: function(status) {
					if (status != 0) this.checkError(status);
				}
			});			
		}
		this.data.objCurrentContact.isPreviewed = !this.data.objCurrentContact.isPreviewed;
	},

	onPresentationListClick : function(objEntry) {
		// If callback is overriden, call it (example: search by name callback)
		if(objEntry.strId=="collaborationId"&&webapp.instantmessaging){
			if(webapp.contacts.data.boolIsInBuddyList){
			    webapp.instantmessaging.prepareToSendIm(this.data.objCurrentContact);
		    }
		}
		if (this.overriddenParams && this.overriddenParams.clbkContactCardClick) {
			this.overriddenParams.clbkContactCardClick(objEntry);
		}
		else {
			dojo.publish("ContactDataClicked" + objEntry.strType, [objEntry, this.data.objCurrentContact]);
		}
	},

	//Callback for the click on a contact in the Contact List
	onContactListClick : function(contactId) {
		ICTouchAPI.debugServices.debug("webapp.contacts.controlBase - onContactListClick $ input function params | contactId: " + contactId);
		var path = this.data.getContainerPath();
		if(path == "webapp.contacts.getContactEdition" && this.data.objCurrentEditedContact) {
			// When leaving the getContactEdition, save the modifications done on the contact
			// (and ask to not refresh, the selected contact in 1/3 will be selected instead)
			ICTouchAPI.debugServices.debug("webapp.contacts.controlBase - onContactListClick / current mode is contact edition, call onSaveContact");
			if (this.onSaveContact(true) == -1) {
				ICTouchAPI.debugServices.debug("webapp.contacts.controlBase - onContactListClick / onSaveContact failed, reselect previous selected entry");
				// saving failed, reselect previous 1/3 entry and return
				if (this.data.objCurrentEditedContact.contactId == -1) { // creating a new contact, unselect 1/3
					this.data.deselectSafe();
				}
				else {
					this.data.selectSafeByIndex(this.data.objCurrentEditedContact.contactId, false);
				}
			}
			else {
				ICTouchAPI.debugServices.debug("webapp.contacts.controlBase - onContactListClick / onSaveContact succeeded, call loadDetails");
				this.data.loadDetails(contactId);
				this.data.switchContainer("getContactCard", this.data.STATUS_HOME);
			}
		}
		else{
			ICTouchAPI.debugServices.debug("webapp.contacts.controlBase - onContactListClick / current mode is not contact edition, call loadDetails");
		this.data.loadDetails(contactId);
		}
	},

	loadDeletePopup : function() {
		var context = this;
		var popupData = {
			strTitle: _("Delete contact ?", 'webapp.contacts'),
			strContent : _("Do you want to delete this contact ?", 'webapp.contacts'),
			strType: "warning",
			arrPopupButtons: [{
				strButtonName: "YES_BTN",
				strButtonIcon: "generic-ok",
				strButtonLabel:  _("Yes", 'ICTouchAPI'),
				callback: function() {
					context.yesDeleteCallback();
				}
			},

			{
				strButtonName: "NO_BTN",
				strButtonIcon: "generic-cancel",
				strButtonLabel:  _("No", 'ICTouchAPI'),
				callback: function() {
					context.noDeleteCallback();
				}
			}]
		};
		this.deletePopUp = ICTouchAPI.popupServices.addNewPopup(popupData, "MEDIUM");
	},

	yesDeleteCallback: function() {
		ICTouchAPI.popupServices.removePopup(this.deletePopUp);
		// no callback wait event
		ICTouchAPI.APIServices.IctDirectory.deleteLocalContact({
			params:["deleteContactReqId", this.data.objCurrentContact.contactId],
			context:this,
			callback:this.onDeleteContact
		});
	},

	noDeleteCallback: function() {
		ICTouchAPI.popupServices.removePopup(this.deletePopUp);
	},

	/**
	 * CONTACT_CREATED or CONTACT_UPDATE Event callback
	 */
	onContactCreatedOrUpdated: function(contactId) {
		ICTouchAPI.debugServices.debug("webapp.contacts.controlBase - onContactCreatedOrUpdated / On Contact created");
		this.data.intSelectContactId = contactId.value;

		ICTouchAPI.APIServices.IctDirectory.getContactById({
			params:[contactId.value],
			context:this,
			callback:this.OnContactReceiveDetails
		});

	//this.data.loadContactList();
	},

	OnContactReceiveDetails: function(objContactDetails, objContactChanges) {
		ICTouchAPI.debugServices.debug("webapp.contacts.controlBase - OnContactReceiveDetails / objContactDetails: " + dojo.toJson(objContactDetails));
		if(objContactDetails.type !== ICTouchAPI.tools.enumContactType.CACHED){
			var onlyPresenceChanged = false;
			if(objContactChanges){
				onlyPresenceChanged = true;
				for(var i in objContactChanges){
					if(i != "telephonyPresence" && i != "IMPresence"){
						onlyPresenceChanged = false;
						break;
					}
				}
			}
			if(onlyPresenceChanged){
				this.data.updatePresenceInList(objContactDetails, objContactChanges);
			} else {
				this.data.updateContactInList(objContactDetails);
			}
			if(objContactDetails.contactId == this._newPreviewContactId){
				this.destroyFavoriteSpinner();
			}
		}
	},

	/**
	 * CONTACT_DELETED Event callback
	 */
	OnContactDeleted: function(contactId) {
		// Delete it only if we find it.
		if(this.data.objContactList && this.data.objContactList.findItem("intIndex",contactId)){
			this.data.deleteContactInList(contactId);
		}
	},

	/**
	 * CONTACT_Synchro Event callback
	 */
	OnContactSynchro: function(contacts) {
		this.data.synchronizeContact(contacts);
		contacts=null;
	},

	//general function to handle error Popups
	checkError : function(status) {
		var strMessage = "";
		switch (status) {
			case 1:
				strMessage = _("The contact is not local", "webapp.contacts");
				break;
			case 2:
				strMessage = _("Contact not found", "webapp.contacts");
				break;
			case 3:
				strMessage = _("Maximum number of contact reached", "webapp.contacts");
				break;
			case 4:
				strMessage = _("Contact is already in preview", "webapp.contacts");
				break;
			case 5:
				strMessage = _("Contact was not in preview", "webapp.contacts");
				break;
			case 6:
				strMessage = _("Synchronization process on going: contacts are read-only", "webapp.contacts");
				break;
			case 7:
				strMessage = _("IM address already used by another contact", "webapp.contacts");
				break;
			case 10:
				strMessage = _("You must provide at least a last name", "webapp.contacts");
				break;
			case 11:
				strMessage = _("Invalid email address", "webapp.contacts");
				break;
			case -1:
				strMessage = _("An error occured", "webapp.contacts");
				break;
			default:
				strMessage = _("Unknown error message", "webapp.contacts");
				break;
		}
		if (strMessage != "") {
			ICTouchAPI.popupServices.errorPopup(_("Error", "ICTouchAPI"), strMessage, _("OK", "ICTouchAPI"), status)
			return true;
		}
		return false;
	},

	/**
	 * onProgKeyConfig
	 * for Add/Edit progkey Arguments Testing.
	 */
	onProgKeyConfig : function(objAction){
		this._onProgKeyConfig(objAction);
		return null;
	},

	_onProgKeyConfig : function (objAction) {
		if(objAction.action == "display-card") {

			var oldList = this.data.objContactList;
			if(this.data.objContactPKList){
				this.data.objContactPKList.deselect();
			}
			if(objAction.arguments){
				this.data.pkContactID = objAction.arguments;
				if(this.data.objContactPKList){
					this.data.objContactPKList.selectItemByIndex(this.data.pkContactID, true);
				}
			}
			ICTouchAPI.transitionServices.getScreen({
				name: "webapp.contacts.getContactProgKey",
				params: {}
			});

			this.data.objContactList = oldList;
				}
	},

	_progKeySetArgs : function(contactId) {
		if (contactId && contactId!=null) {
			// We notify progkeys that he doesn't have to reset the display and variables this time
			webapp.progkeys.setProgkeysArgumentsNextStep(contactId);
			webapp.contacts.data.pkContactID = null;
		}
	},
	
	/**
	 * onProgKeyAction
	 * @return : list of Template of actions
	 */
	/*onProgKeyAction : function() {
		var listActions = [];
		listActions.push({
			webAppName : "contacts",
			action : "display-card",
			type : 1,
			icon : "contacts-card",
			label : "Display contact card"
		});
		return listActions;
	},*/

	onProgKeyClick : function(objAction) {
		if(objAction.action == "display-card") {
			this.showContact({
				intId:objAction.arguments
			});
		}
	},

	onProgKeyDisplay :  function(objAction, progkey) {
		if(objAction.action == "display-card") {
			var myDS = ICTouchAPI.dataStoreServices.getStore('contacts');
			var objContact = myDS.getAt(objAction.arguments)
			progkey.image = ( objContact.photo) ?  objContact.photo : ICTouchAPI.tools.getDefaultPhotoPath("user", "50");
		}
	},

	_editCurrentContact : function() {
		//var data = webapp.contacts.data;
		this.data.objLastViewedContact = dojo.clone(this.data.objCurrentContact);
		this.data.setContactId(this.data.objCurrentContact.contactId);
		this.data.switchContainer("getContactEdition", this.data.STATUS_EDITION, _("Edit contact", "webapp.contacts"));
	},

	/*********************************************************************
	 * Public methods
	 *********************************************************************/
	/**
	 * showContact method can be called to display the contact card of a given contact.
	 * @param {Object} args is an object that can contain the following values:
	 *   - intId: if provided, the contact card of the given contact id will be loaded. Only local contacts can be loaded in this way.
	 *   - objContact: if the whole contact object is given, it will be directly displayed as is.
	 *   - clbkContactCardClick: callback to override behavior when the user clicks on an entry of the contact card (like phone number)
	 *   - clbkBack: callback to override behavior when the user clicks on the "BACK" button.
	 */
	showContact: function(args) {
		this.overriddenParams = args;
		ICTouchAPI.transitionServices.getScreen({
			name: "webapp.contacts.getContact",
			params: {},
			sync : true
		});
		if(args.needStealth && args.needStealth == true){
			ICTouchAPI.transitionServices.stealth("webapp.contacts.getContact");
		}

		if(this.contactList){
			// Select the title + execute callback
			this.contactList.selectTitleById(this.data.menuIds.CONTACT);
		}

		if (args.intId != undefined && args.intId != null) {
			this.data.intSelectContactId = args.intId;
			this.data.objContactList.selectItemByIndex(this.data.intSelectContactId, true);
		}
		else if (args.objContact && args.objContact.contactId) {
			// Check if the contact is local (in the directory -> LOCAL = 0, DM = 3, MA = 5),
			// or if it is remote, (UDA = 1, BUDDY = 2, ICS = 4)
			// if type of contact is not local or DM, it is a remote contact (UDA,...), add it to the list and display it with the alternate style
			if (args.objContact.type != ICTouchAPI.tools.enumContactType.LOCAL && args.objContact.type != ICTouchAPI.tools.enumContactType.DM && args.objContact.type != ICTouchAPI.tools.enumContactType.MA) {
				args.objContact.isRemote = true;	// add "remote" flag
				args.objContact.isPreviewed = 0;    // don't display the remote contact in preview

				//remove last remote contact from the contact list so that only one remote contact is displayed after a new search
				//(this remove the remote contact added to the list from a previous search)
				this.data._removePreviousRemoteContact();

				this.data._pushContactInList(args.objContact, false, true);
			}
			// Update the current selected contactId
			this.data.intSelectContactId = args.objContact.contactId;
			this.data.objContactList.selectItemByIndex(this.data.intSelectContactId, true);

		}
	},

	/**
	 * editContact method can be called to display the contact card edition interface.
	 * @param {Object} args is an object that can contain the following values:
	 *   - intId: if provided, the corresponding contact will be edited. Else it's going to be created.
	 *   - objContact: can be used to pre-fill / override values.
	 *   - clbkBack: callback to override behavior when the user clicks on the "BACK" button.
	 */
	editContact: function(args) {
		ICTouchAPI.debugServices.debug("webapp.contacts.controlBase - editContact $ input function params | args: " + dojo.toJson(args));
		//var data = webapp.contacts.data;
		this.overriddenParams = args;
		if (args.intId !== undefined && args.intId !== null) {
			// Try fo find the contact in list (= udpate)
			var myDS = ICTouchAPI.dataStoreServices.getStore('contacts');
			var contact = myDS.getAt(args.intId);
			if(contact) {
				this.data.intSelectContactId = args.intId;
				// If the objContactList menu list exists, scroll to this item (else it will be done
				// at the creation of the menu list)
				ICTouchAPI.transitionServices.getScreen({
					name: "webapp.contacts.getContact",
					params: {},
					sync : true
				});

				if(this.contactList){
					// Select the title + execute callback
					this.contactList.selectTitleById(this.data.menuIds.CONTACT);
				}
				if (this.data.objContactList) {
					this.data.objContactList.selectItemByIndex(this.data.intSelectContactId, false);
				}
				this.data.objCurrentContact = contact;
				this._editCurrentContact();
				return;
			}
		}
		// Else, create contact
		ICTouchAPI.transitionServices.getScreen({
			name: "webapp.contacts.getContact",
			params: {},
			sync : true
		});

		if(this.contactList){
			// Select the title + execute callback
			this.contactList.selectTitleById(this.data.menuIds.CONTACT);
		}
		this.data.objLastViewedContact = dojo.clone(this.data.objCurrentContact);
		this.data.objCurrentContact = dojo.clone(args.objContact);
		this.data.setContactId(-1);
		//deselect of menulist item
		if(webapp.contacts.data.objContactList != null){
			webapp.contacts.data.objContactList.deselect();
		}
		//if this is a dummy contact, erase the name
			/*if (this.data.objCurrentContact.contactId == -1) {
			this.data.objCurrentContact.name = "";
			}*/
		this.data.switchContainer("getContactEdition", this.data.STATUS_EDITION, _("Add new contact", "webapp.contacts"));
	},

	unlock : function(WebappName) {
		var path = this.data.getContainerPath();
		if(path == "webapp.contacts.getContactEdition") {
			if (webapp.screensaver) {
				var currentScreenSaver = webapp.screensaver.data.getCurrentScreensaverScreen();
			}
			if(WebappName == currentScreenSaver){
				dojo.publish("unlockTransition",[true]);
			}
			else if (WebappName == "webapp.lock.getLock" || WebappName == "webapp.userservices.getUserService" ||
				WebappName == "webapp.homepage.getHomepage" || WebappName == "webapp.communication.getCommunication"){
				//dojo.publish("unlockTransition",[true]);
			this.data._boolChangeScreen = true;
				// When leaving the getContactEdition, save the modifications done on the contact
				if(ICTouchAPI.keyboardServices.isKeyboardDisplayed()){
					ICTouchAPI.keyboardServices.closeKeyboard(ICTouchAPI.keyboardServices.CLOSE_ACTION_NONE);
				}
				if(ICTouchAPI.tools.compareObjects(this.data.objCurrentEditedContact, this.data.createEmptyContact()) ||
					ICTouchAPI.tools.compareObjects(this.data.objCurrentEditedContact, this.data.objLastViewedContact)){
					this.onCancelSaveContact();
					this.selectSafeAfterCancelSaveContact();
				}
				else if (this.data.objCurrentEditedContact && this.data.objCurrentEditedContact.name) {
					this.onSaveContact();
				}
				else {
					this.onCancelSaveContact();
					this.selectSafeAfterCancelSaveContact();
				}
			}
			else{
				this.data._boolChangeScreen = true;
				// When leaving the getContactEdition, save the modifications done on the contact
				if(ICTouchAPI.keyboardServices.isKeyboardDisplayed()){
					ICTouchAPI.keyboardServices.closeKeyboard(ICTouchAPI.keyboardServices.CLOSE_ACTION_OK);
				}
				this.onSaveContact();
			}
		}else{
			dojo.publish("unlockTransition",[true]);
		}
	},

	onComSelectStatusChange : function(params) {
		var selectStatus = params.selectStatus;
		this.data.intComSelectStatus = selectStatus;
	    if(webapp.communication && webapp.communication.isSelectStatusProgkey()) {
			this.data.current_status = this.data.STATUS_PROGKEY_ADD;
		}else if(webapp.communication && webapp.communication.isSelectStatusMDR()){
			ICTouchAPI.debugServices.error("STATUS MDR");
			this.data.current_status = this.data.STATUS_MDR_ROUTING;
		}else{
			this.data.current_status = this.data.STATUS_HOME;
	    }
		if(this.data.arrComSelectStatus[selectStatus] != null) {
			var icon = this.data.arrComSelectStatus[selectStatus].icon;
			var label = this.data.arrComSelectStatus[selectStatus].label;
		    var appBar = ICTouchAPI.AppBarServices._getAppBarWidget("contacts", "contactsstatus"+this.data.current_status);
			if(appBar!=null) {
				var btnCall = appBar.getButton(this.data.CALL_BTN);
				if(btnCall) {
					btnCall.attr("strButtonIcon", icon);
					if (label && label.isI18Ned) {                                            
		                            btnCall.setButtonLabel(label);
		                        }
	                                else {
						btnCall.setButtonLabel(_(label,"webapp.contacts"));
					}
				}
			}
			if(webapp.contacts.mainWidget && this.data.getContainerPath()=="webapp.contacts.getContactCard") {
				webapp.contacts.mainWidget.reloadContainer();
			}
		}
	}
});
dojo.require("webapp.contacts.controlBase");
dojo.provide("webapp.contacts");
dojo.declare("webapp.contacts", webapp.contacts.controlBase,
{
	});
webapp.contacts=new webapp.contacts();
dojo.provide("webapp.contacts.dataBase");
dojo.declare("webapp.contacts.dataBase",null,{
	_arrContactAddresses		: [],
	_arrAppButtons 				: [],
	_arrInfoList				: [],
	intSelectContactId			: null,
	intSelectFavoriteId			: null,
	intDisplayedContactId		: null,
	objCurrentContact			: null,
	objLastViewedContact		: null,
	objCurrentEditedContact		: null,
	objInPreviewBtnUI			: null,
	objContactList				: null,
	objFavoriteList				: null,
	objPreviewList                          : null,
	arrWidgetsData				: [],
	intCurrentWidget			: 0,
	strContainerPath			: "",
	strTitle					: "",
	newContactId				: -1,
	nrOfContacts				: null,
	photoPath					: "",
	currentContactDisplayName	: "",
    intCptPhoneNumber           : 0,
	_boolNumberingDone			: false,
	objBackPopup				: null,
	_boolChangeScreen			: false,

	showOnlyFavorites			: false,
	intComSelectStatus			: -1,
	arrComSelectStatus			: {},

	_intDisplayedMenu			: null,

	// Variable to set before first load of contact application to specify which tab it should open.
	// By default (constructor), it is contacts tab.
	_intTabToLoad				: "",

	// Graphical settings values
	boolPictureInMenu			: false,
	boolTelephonyPresenceAvailable : null,
	boolIMPresenceAvailable : null,
	boolIsInBuddyList		:null,

	// Static map of title translations, only used in getContactTitle
	_arrTitleTranslation: [
		"No contacts",
		"No favorites"
	],

	// Constant values for the button's id
    CALL_BTN: "CALL_BTN",
	BACK: "BACK_BTN",
	CREATE_BTN : "CREATE_BTN",
	NEWCALL_BTN : "NEWCALL_BTN",
	INVITE_BTN : "INVITE_BTN",
	COPY_BTN : "COPY_BTN",
	EDIT_BTN : "EDIT_BTN",
	DELETE_BTN : "DELETE_BTN",
	SEARCH_BTN : "SEARCH_BTN",
	ADD_ADRESS_BTN : "ADD_ADRESS_BTN",
	ADD_BTN : "ADD_BTN",
	INPREVIEW_BTN : "IN_PREVIEW_BTN",
	ADD_CONTACT : "ADD_CONTACT",
	NEXT : "NEXT_BTN",

	//STATUS
	STATUS_HOME			: 0,
	STATUS_EDITION		: 1,
	STATUS_MR_SCREEN	: 2,
	STATUS_PROGKEYS		: 3,
	STATUS_PROGKEY_ADD	: 4,
	STATUS_MDR_ROUTING	: 5,
	NB_STATUS			: 6,

	current_status			: 0,

	// Widgets
	WIDGET_SHOW:        0,
	WIDGET_EDIT:        1,
	WIDGET_ADDRESS:     2,

	//Filters
	COMLOG_FILTERED:	2,
	COMLOG_FILTER_ALL:	8,

	// Number of favorites/contacts
	_intFavoriteNumber	: 0,
	_intContactNumber	: 0,

	// Lists Ids
	menuIds: {
		"FAVORITE"	: 0,
		"CONTACT"	: 1
	},

	constructor : function() {
		this.setTabToLoad(this.menuIds.CONTACT);
	},

	getContactListTitle : function(){
		return [
			this.getFavoriteTitle(),
			{
				strIcon: "contacts-tabs-contacts-32",
				strLabel : _('Contacts', 'webapp.contacts'),
				strLabelBottom: '(' + this.getIntContactNumber() + ')',
				intIndex : this.menuIds.CONTACT
			}
		]
	},

	getFavoriteTitle : function() {
		return {
			strIcon: "contacts-tabs-favorites-32",
			strLabel : _('FavoritesShortTtl', 'webapp.contacts'),
			strLabelBottom: '(' + this.getIntFavoriteNumber() + ')',
			intIndex : this.menuIds.FAVORITE
		}
	},

	//manages the display of several butons
	checkContactSelected : function(){
        this.intCptPhoneNumber=0;

		//if there are no contacts then disable a few buttons
		var appBar = ICTouchAPI.AppBarServices._getAppBarWidget("contacts", "contactsstatus"+this.STATUS_HOME);
		var btnCall = appBar.getButton(this.CALL_BTN);
		var btnCopy = appBar.getButton(this.COPY_BTN);
		var btnDelete = appBar.getButton(this.DELETE_BTN);
		var btnEdit = appBar.getButton(this.EDIT_BTN);
		var btnPreview = appBar.getButton(this.INPREVIEW_BTN);
		var btnAdd = appBar.getButton(this.CREATE_BTN);
		appBar = ICTouchAPI.AppBarServices._getAppBarWidget("contacts", "contactsstatus"+this.STATUS_PROGKEY_ADD);
		var btnAddToFav = appBar.getButton(this.CALL_BTN);
		appBar = ICTouchAPI.AppBarServices._getAppBarWidget("contacts", "contactsstatus"+this.STATUS_MDR_ROUTING);
		var btnSelectForMDR = appBar.getButton(this.CALL_BTN);

		if(this.getHotelMode()){
			btnAdd.hide();
		}
		else{
			btnAdd.show();
		}
		if (this.objCurrentContact == null) {
			btnCall.hide();
			btnCopy.hide();
			btnDelete.hide();
			btnEdit.hide();
			btnPreview.hide();
			btnAddToFav.hide();
			btnSelectForMDR.hide();
		}
		else {
            ICTouchAPI.tools.getContactPhone(this.objCurrentContact);
            if(this.objCurrentContact.officePhone){
                this.intCptPhoneNumber++;
            }
            if(this.objCurrentContact.personalHome){
                this.intCptPhoneNumber++;
            }
            if(this.objCurrentContact.personalMobile){
                this.intCptPhoneNumber++;
            }
			if(this.objCurrentContact.personalFax){
                this.intCptPhoneNumber++;
            }

            if(this.intCptPhoneNumber==1){

                btnCall.show();
				btnAddToFav.show();
				btnSelectForMDR.show();

            }
            else{
                btnCall.hide();
				btnAddToFav.hide();
				btnSelectForMDR.hide();
            }
			if(!this.getHotelMode()){
				if (this.objCurrentContact.type == ICTouchAPI.tools.enumContactType.LOCAL) {
					btnCopy.hide();
					btnDelete.show();
					btnEdit.show();
					btnPreview.show();
				} else if(this.objCurrentContact.type == ICTouchAPI.tools.enumContactType.DM){
					btnCopy.hide();
					btnDelete.hide();
					btnEdit.hide();
					btnPreview.show();
				} else if(this.objCurrentContact.type == ICTouchAPI.tools.enumContactType.MA) {
					btnCopy.hide();
					btnDelete.hide();
					btnEdit.hide();
					btnPreview.hide();
				} else { // All distant contacts
					btnCopy.show();
					btnDelete.hide();
					btnEdit.hide();
					btnPreview.hide();
				}
			}else{
				btnCopy.hide();
				btnDelete.hide();
				btnEdit.hide();
				btnPreview.hide();
			}
		}
		if(this.strContainerPath != 'webapp.contacts.getContactEdition') {
			//display the contact Card
			this.switchContainer("getContactCard", this.current_status);
		}
	},

	// check if all the fields of the given objContact are empty
	createEmptyContact : function(){
       return {contactId: -1, miscMap:{}};
	},

	getContactAddresses : function(){
		return this._arrContactAddresses;
	},

	getContainerPath : function(){
		return this.arrWidgetsData[webapp.contacts.currentStatus].container;
	},

	getAppBarAppButtons : function(){
		return this.arrWidgetsData[webapp.contacts.currentStatus].buttons;
	},

	getCurrentContact : function(){
		return this.objCurrentContact;
	},

	getFormatedPhoto : function(strPicture){
		var picture;
		if(this.boolPictureInMenu){
			picture = (strPicture) ? strPicture : ICTouchAPI.tools.getDefaultPhotoPath("user", "50");
		} else {
			picture = undefined;
		}
		return picture;
	},

	getFormatedImPresence : function(strPresence, boolWithoutSize){
		if(ICTouchAPI.presenceServices.isIMPresenceAvailable()){
			return ICTouchAPI.tools.getPresenceIconPath(strPresence, !boolWithoutSize && '32');
		} else {
			return undefined;
		}
	},

	getFormatedTelephonyPresence : function(strPresence, boolWithoutSize){
		if(ICTouchAPI.presenceServices.isTelephonyPresenceAvailable() && strPresence){
			return ICTouchAPI.tools.getTelephonyPresenceIconPath(strPresence, !boolWithoutSize && '32');
		} else {
			return undefined;
		}
	},

	//simillar to a refresh function, it is the starting point to a new refresh of the contact list
	loadContactList : function() {
		// Get all contacts
		this.loadedContactList(ICTouchAPI.dataStoreServices.getStore('contacts').getList());

	},

	loadPreviewList : function() {
		var tmp=[];
		ICTouchAPI.dataStoreServices.getStore('contacts').getList().forEach(function(obj) {
			if(obj.isPreviewed) tmp.push(obj);
		},this);
		this._loadedPreviewList(tmp);
	},

	//callback for the getLocalContacts bussines function
	loadedContactList: function(_arrOriginal) {
		var arrContacts = [];
		var arrFavorites = [];
		var item;

		if (this.objContactList) {
			var contact;
			//Build the list Items
			for (var i = 0; i < _arrOriginal.length; i++) {
				contact = _arrOriginal[i];
				if(contact.type !== ICTouchAPI.tools.enumContactType.CACHED){
					item = this.formatContactForMenuList(contact);
					arrContacts.push(item);

					if (contact.isPreviewed){
						arrFavorites.push(dojo.clone(item));
					}
				}
			}

			arrContacts.sort(this.compareListItems);
			arrFavorites.sort(this.compareListItems);

			//Insert all items in one time
			this.insertItemsInList(0, arrContacts);
			
			//Insert all items in one time
			this.insertItemsInFavorites(0, arrFavorites);

			//Select the item
			if (arrContacts.length == 0) {
				//No item: empty card
				this.setIntSelectContactId(0);
				this.objCurrentContact = null;
				this.switchContainer("getContactCard", this.current_status);
			} else {
				if(this.objContactPKList && this.pkContactID) { 
					this.objContactPKList.selectItemByIndex(this.pkContactID, true);
				}
			}

			// Set both length for title
			this.setIntContactNumber(arrContacts.length);
			this.setIntFavoriteNumber(arrFavorites.length);
		}
	},

	_loadedPreviewList:function(_arrPreview){
		//add the list of review Contacts
		var arrItems = [];
		var item;

		if (this.objPreviewList) {
			var contact;
			//Build the list Items
			for (var i = 0; i < _arrPreview.length; i++) {
				contact = _arrPreview[i];
				if(contact.type !== ICTouchAPI.tools.enumContactType.CACHED){
					item = this.formatContactForMenuList(contact);
					arrItems.push(item);
				}
			}

			arrItems.sort(this.compareListItems);

			//Insert all items in one time
			this.objPreviewList.insertItems(0,arrItems);

			this.setIntFavoriteNumber(arrItems.length);
		}
	},

	_pushContactInList: function(objContact, boolPK, boolNormal) {
		var contact = this.formatContactForMenuList(objContact);
		if(this.objContactList && boolNormal){
			this.objContactList.pushItem(contact, true);
		}
		if(this.objContactPKList && boolPK){
			this.objContactPKList.pushItem(contact, true);
		}
		this.increaseIntContactNumber();
	},

	_removePreviousRemoteContact: function(boolSelectFirst) {
		if(this.objContactList) {
			var remoteContact = this.objContactList.findItem('isRemote', true);
			if (remoteContact && remoteContact.objContact && remoteContact.objContact.contactId) {
				this.removeItemByIntIndexInList(remoteContact.objContact.contactId, true);
				if(boolSelectFirst){
					this.selectContactByPosition(0, true);
				}
			}
		}
	},

	_removePreviousRemoteContactById: function(remodeContactId) {
		if(this.objContactList) {
			var remoteContact = this.objContactList.findItem('isRemote', true);
			if (remoteContact && remoteContact.objContact && remoteContact.objContact.contactId && remoteContact.objContact.contactId == remodeContactId) {
				this.removeItemByIntIndexInList(remoteContact.objContact.contactId, true);
			}
		}
	},

	loadDetails: function(contactId) {
		var objContactToLoad;
		if(this.getDisplayedMenu() == this.menuIds.CONTACT){
			objContactToLoad = this.objContactList.findItem("intIndex", contactId);
			this.setIntSelectContactId((objContactToLoad) ? contactId : null);
		} else if(this.getDisplayedMenu() == this.menuIds.FAVORITE){
			objContactToLoad = this.objFavoriteList.findItem("intIndex", contactId);
			this.setIntSelectFavoriteId((objContactToLoad) ? contactId : null);
		}
		if(objContactToLoad){
			this.objCurrentContact = objContactToLoad.objContact;
		} else {
			this.objCurrentContact = null;
			ICTouchAPI.debugServices.warning("webapp.contacts.dataBase - loadDetails $ no contact found for contactId: " + contactId);
		}
		this.intDisplayedContactId = contactId;
		if(this.objContactList){
			this.checkContactSelected();
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.contacts.dataBase - loadDetails / this.objContactList does not exist.");
		}
	},

	//gets the list of details of the current contact
	getInfoList:function(){
		return ICTouchAPI.tools.getContactPresentationList(
			this.objCurrentContact,
			webapp.contacts,
			webapp.contacts.onPresentationListClick,
			"webapp.contacts",
			this.arrComSelectStatus[this.intComSelectStatus].icon
		);
	},

	getContactTitle : function() {
		var strTitle = this._strTitle || ICTouchAPI.tools.getContactDisplayName(this.objCurrentContact);

		if (!strTitle) {
			var index = this.showOnlyFavorites ? 1 : 0;
			strTitle = _(this._arrTitleTranslation[index], "webapp.contacts");
		}
		return strTitle;
	},

	// set a new content for the container of the contact and call an update of the appBar
	switchContainer: function(pageName, status, pageTitle) {
		ICTouchAPI.debugServices.info("webapp.contacts.dataBase - switchContainer $ input function params | pageName: " + pageName + " | status: " + " | pageTitle: " + ((pageTitle && pageTitle.isI18Ned) ? pageTitle.toString():pageTitle));
		this.strContainerPath = "webapp.contacts."+pageName;
		// No pageTitle means default title
		this._strTitle = pageTitle || null;
		if (webapp.contacts.mainWidget) {
			this.updateAppBar(status);
			webapp.contacts.mainWidget.reloadContainer();
		}
	},

	// set the appBar corresponding to the status
	updateAppBar: function(status) {
		// set the status
		webapp.contacts.currentStatus = status;

		// Register appBar according to state
		ICTouchAPI.AppBarServices.setAppBar("contacts", "contactsstatus"+status, "getContact");
	},

	setContactId : function(intId)
	{
		this.objCurrentContact.contactId = intId;
	},

	// This function is called when clicked on "add contact" button in webapp communication
	onAddCallback:function() {
		if (webapp.history) {
			var objContact = webapp.history.data.getCurrentContact();
			ICTouchAPI.debugServices.debug("webapp.contacts.dataBase - onAddCallback / add contact using current contact ok communication webapp: " + dojo.toJson(objContact));

			webapp.contacts.data._boolNumberingDone = false;

			webapp.contacts.editContact({
				objContact: objContact,
				clbkBack: function() {
					ICTouchAPI.transitionServices.getScreen({
						name: "webapp.communication.getHistory",
						params: {}
					})
				}
			});
		}
	},

	getContactCardFromCommunication : function () {
		if(webapp.communication){
			var objContact = webapp.communication.getSelectedParticipant() ;
			if (!objContact){
				return;
			}
			if(objContact.objContact){
				webapp.contacts.showContact({
					intId: objContact.objContact.contactId,
					clbkBack: function() {
						ICTouchAPI.transitionServices.getScreen({
							name: "webapp.communication.getCommunication",
							params: {}
						});
					}
				});
			}
		}
	},

	updatePresenceInList : function(objContactDetails, objContactChanges) {
		var contact;
		// Check if we have the contact currently displayed in a list.
		if(this.objContactList){
			contact = this.objContactList.findItem("intIndex", objContactDetails.contactId);
		} else if (this.objPreviewList){
			contact = this.objPreviewList.findItem("intIndex", objContactDetails.contactId);
		}
		if(contact){
			var objContact = this.formatContactForMenuList(objContactDetails);
			var isPreviewed = contact.pPreview;
			// Refresh presence in 2/3 if it is the selected contact and if contact view was already loaded.
			if(webapp.contacts.mainWidget && this.objCurrentContact && this.objCurrentContact.contactId == objContactDetails.contactId){
				webapp.contacts.mainWidget.container.setTitleLeftIcon(this.getFormatedTelephonyPresence(objContactChanges.telephonyPresence, true));
			}
			// Refresh 1/3 if required
			if(this.objContactList){
				this.updateItemInList(objContact);
			}
			// Refresh preview if required
			if (isPreviewed) {
				this.updateContactInFavoriteList(objContact);
			}
		}
	},

	formatContactForMenuList : function(objContact) {
		var contact = {}

		contact.intIndex = objContact.contactId,
		contact.objContact = objContact;
		contact.strPrimaryContent = ICTouchAPI.tools.getContactDisplayName(objContact);
		contact.isRemote = objContact.isRemote;
		contact.pPreview = objContact.isPreviewed;
		contact.pName = objContact.name;
		contact.pFirstName = objContact.firstName;
		contact.strPicture = this.getFormatedPhoto(objContact.photo);
		contact.objIconLeft = objContact.telephonyPresence ? {icon: this.getFormatedTelephonyPresence(objContact.telephonyPresence)} : null ;


		objContact = null;
		return contact;
	},

	updateContactInList:function(newContactList) {
		ICTouchAPI.debugServices.debug("webapp.contacts.dataBase - updateContactInList $ input function params | newContactList: " + dojo.toJson(newContactList));
		var contact;
		if(this.objContactList){
			contact = this.objContactList.findItem("intIndex", newContactList.contactId);
		} else if (this.objPreviewList){
			contact = this.objPreviewList.findItem("intIndex", newContactList.contactId);
		}
		var objContact = this.formatContactForMenuList(newContactList);
		if(contact) {
			// if contact exists, update the contact
			ICTouchAPI.debugServices.debug("webapp.contacts.dataBase - updateContactInList / contact exists");
			var isPreviewed = contact.pPreview;
			var name = contact.pName;
			var firstName = contact.pFirstName;
			ICTouchAPI.debugServices.debug("webapp.contacts.dataBase - updateContactInList / isPreviewed: " + isPreviewed + " | newContactList.isPreviewed: " + newContactList.isPreviewed);
			if(newContactList.isPreviewed == isPreviewed) {
				ICTouchAPI.debugServices.debug("webapp.contacts.dataBase - updateContactInList / preview didn't change");
				// if preview didn't change
				if(newContactList.name==name && newContactList.firstName==firstName) {
					ICTouchAPI.debugServices.debug("webapp.contacts.dataBase - updateContactInList / name didn't change");
					this.updateContactInFavoriteList(objContact);

					// if name didn't change, order does not change, just update info
					this.updateItemInList(objContact);
					//edit
					if(this.intDisplayedContactId == newContactList.contactId){
						this.selectSafeByIndex(this.intDisplayedContactId,true,-4);
					}
					ICTouchAPI.debugServices.debug("webapp.contacts.dataBase - updateContactInList / name did change");
				} else {
					ICTouchAPI.debugServices.debug("webapp.contacts.dataBase - updateContactInList / name did change");
					// if name did change, remove + insert
					this.removeItemByIntIndexInList(newContactList.contactId,true);
					this.addItemInContactList(objContact);
					
					// Remove + insert in favorite + preview
					if(isPreviewed){
						this.removeContactFromFavoriteList(newContactList.contactId, false);
						this.addContactInFavoriteList(objContact);
					}
					ICTouchAPI.debugServices.debug("webapp.contacts.dataBase - updateContactInList / existing in preview updating with: " + dojo.toJson(contact));
					ICTouchAPI.debugServices.debug("webapp.contacts.dataBase - updateContactInList / Contact updated: " + dojo.toJson(newContactList) + " | " + dojo.toJson(this.objContactList.findItem("intIndex", newContactList.contactId)));
				}
			} else {
				ICTouchAPI.debugServices.debug("webapp.contacts.dataBase - updateContactInList / preview did change");
				// if preview did change
				this.updateItemInList(objContact);
				if(newContactList.isPreviewed) {
					// false to true
					if(this.intDisplayedContactId == newContactList.contactId){
						this.objInPreviewBtnUI.setStatusIcon("notif-on");
					}
					ICTouchAPI.debugServices.debug("webapp.contacts.dataBase - updateContactInList / unknown in preview creating from: " + dojo.toJson(newContactList));
					this.addContactInFavoriteList(objContact);
				} else {
					// true to false
					ICTouchAPI.debugServices.debug("webapp.contacts.dataBase - updateContactInList / Contact removed from preview: " + newContactList.contactId);
					this.removeContactFromFavoriteList(newContactList.contactId);
					if(this.intDisplayedContactId == newContactList.contactId){
						this.objInPreviewBtnUI.setStatusIcon("notif-off");
					}
				}
			}
		} else {
			ICTouchAPI.debugServices.debug("webapp.contacts.dataBase - updateContactInList / contact doesn't exist");
			// if contact doesn't exist, Add the contact
			this.addItemInContactList(objContact);

			if(newContactList.isPreviewed) {
				this.addContactInFavoriteList(objContact);
			}
		}

		newContactList = null;
	},

	addItemInContactList : function(objContactToAdd){
		if(this.objContactList){
			// get menu list place to insert item
			var insertIdx = this.objContactList._DONT_USE_locateItem(["name","firstName"], [objContactToAdd.pName,objContactToAdd.pFirstName]);
			// if no place is found, insert on the end
			if(insertIdx==-1){
				insertIdx=this.objContactList.length;
			}

			this.insertItemsInList(insertIdx, [objContactToAdd]);

			// Refresh information if needed
			if(!this.intSelectContactId){
				this.intSelectContactId = objContactToAdd.objContact.contactId;
					this.selectSafeByIndex(this.intSelectContactId,true);
			}

			this.increaseIntContactNumber();

		}
	},

	addContactInFavoriteList : function(objContactToAdd) {
		var insertIdx;
		// Try to add in favorite list
		if(this.objFavoriteList){
			insertIdx = this.objFavoriteList._DONT_USE_locateItem(["name","firstName"], [objContactToAdd.pName,objContactToAdd.pFirstName]);
			if(insertIdx == -1){
				 insertIdx = this.objFavoriteList.arrItems.length;
			}
			this.objFavoriteList.insertItems(insertIdx,	[dojo.clone(objContactToAdd)]);
			if(this.getDisplayedMenu() == this.menuIds.FAVORITE){
				this.objFavoriteList.selectItemByPosition(insertIdx, true);
			}
		}
		// Try to add in preview list
		if(this.objPreviewList){
			insertIdx = this.objPreviewList._DONT_USE_locateItem(["name","firstName"], [objContactToAdd.pName,objContactToAdd.pFirstName]);
			if(insertIdx == -1){
				 insertIdx = this.objPreviewList.arrItems.length;
			}
			this.objPreviewList.insertItems(insertIdx,	[dojo.clone(objContactToAdd)]);
		}
		this.increaseIntFavoriteNumber();
	},


	updateContactInFavoriteList : function(objContactToUpdate) {
		if(this.objFavoriteList){
			this.objFavoriteList.updateItem(objContactToUpdate);
		}
		if(this.objPreviewList){
			this.objPreviewList.updateItem(objContactToUpdate);
		}
	},

	removeContactFromFavoriteList : function(contactId, overrideBSelect) {
		var bSelect = (this.getDisplayedMenu() == this.menuIds.FAVORITE);
		var objContact = null;
		if(typeof overrideBSelect !== "undefined"){
			bSelect = overrideBSelect;
		}
		if (this.objPreviewList) {
			objContact = this.objPreviewList.removeItemByIntIndex(contactId, true);
		}
		if (this.objFavoriteList) {
			if(contactId == this.getIntSelectFavoriteId()){
				this.setIntSelectFavoriteId(null);
			}
			objContact = this.objFavoriteList.removeItemByIntIndex(contactId, !bSelect);
			if(this.objFavoriteList.arrItems.length == 0 && bSelect){
				this.setIntSelectFavoriteId(null);
				if(this.getDisplayedMenu() == this.menuIds.FAVORITE){
					this.loadDetails(null);
				}
			}
		}
		if(objContact){
			this.decreaseIntFavoriteNumber();
		}
	},

	selectSafeByIndex : function(contactId,boolClick,doNotScroll){
		if(this.getDisplayedMenu() == this.menuIds.FAVORITE){
			if(this.objFavoriteList){
				this.objFavoriteList.selectItemByIndex(contactId, boolClick,doNotScroll);
			}
		} else if(this.getDisplayedMenu() == this.menuIds.CONTACT && this.objContactList){
			this.objContactList.selectItemByIndex(contactId, boolClick,doNotScroll);
		}

	},

	//we check if the objcontactList exists in this function
	deselectSafe : function(){
		if(this.objContactList){
			this.objContactList.deselect();
		}
	},

	//we check if the objcontactList exists in this function
	selectContactByPosition : function(intPosition,boolClick){
		if(this.objContactList){
			this.objContactList.selectItemByPosition(intPosition, boolClick);
		}
	},

	deleteContactInList: function(contactId) {
		this.intSelectContactId = -1;
		this.objCurrentContact = null;
		this.switchContainer("getContactCard", webapp.contacts.data.current_status);
		this.removeItemByIntIndexInList(contactId);
		this.removeContactFromFavoriteList(contactId);
		// If there is no more contacts in the list, refresh the appbar
		if (this.objContactList && this.objContactList.arrItems.length == 0) {
			this.checkContactSelected();
		}
	},
	
	//Sort items of a list
	compareListItems : function(item1,item2) {
		var id1 = item1.pName + item1.pFirstName;
		var id2 = item2.pName + item2.pFirstName;

		id1 = id1.toLowerCase();
		id2 = id2.toLowerCase();

		if (id2 > id1) {
			return -1;
		}
		else if (id2 < id1) {
			return 1;
		}

		return 0;
	},

	synchronizeContact: function(contacts) {
		var previewList = [];
		var contact;

		if (this.objContactList && this.objFavoriteList) {

			//Refresh the contact list
			this.objContactList.emptyItems();
			this.objFavoriteList.emptyItems();
			this.intSelectContactId = 0; //Reset the current selected contact 
			this.intSelectFavoriteId = 0; //Reset the current selected favorite
			this.loadedContactList(contacts);
		}

		// manage contacts in preview list, if exists
		if (this.objPreviewList) {
			//refresh the preview list
			this.objPreviewList.emptyItems();
			// get the list of favorites contacts ('isPreviewed')
			for (var i=0; i<contacts.length; i++) {
				contact = contacts[i];
                                if (contact.isPreviewed) {
					previewList.push(contact);
                                }
			}
			this._loadedPreviewList(previewList);
			} 
		contacts=null;
		previewList=null;
		contact=null;
	},

	updateContactInPreview: function(contactId, toAdd) {

		// Update the led accordingly to the action done
		if(this.objInPreviewBtnUI) {
			toAdd ? this.objInPreviewBtnUI.setStatusIcon("notif-on") : this.objInPreviewBtnUI.setStatusIcon("notif-off");
		}

		if (this.objContactList) {
			var contact = this.objContactList.findItem("intIndex", contactId);
			var objcontact = this.formatContactForMenuList(contact);
			if (this.objPreviewList) {
				this.objPreviewList.updateItem(objcontact);
				ICTouchAPI.debugServices.debug("webapp.contacts.dataBase - updateContactInPreview / Contact updated in preview: " + dojo.toJson(objcontact) + " | " + dojo.toJson(this.objPreviewList.findItem("intIndex", contactId)));
			}
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.contacts.dataBase - updateContactInPreview / this.objContactList does not exist.");
		}
	},

	removeItemByIntIndexInList : function(id, boolDoNotSelectNext){
		if (id == this.intSelectContactId) {
			this.intSelectContactId = null;
		}
		if(this.objContactList){
			this.objContactList.removeItemByIntIndex(id,boolDoNotSelectNext);
		}
		if(this.objContactPKList){
			this.objContactPKList.removeItemByIntIndex(id,true);
		}
		this.decreaseIntContactNumber();
	},

	insertItemsInList : function(intPosition, arrItems){
		if(this.objContactList){
			this.objContactList.insertItems(intPosition,arrItems);
		}
		if(this.objContactPKList){
			this.objContactPKList.insertItems(intPosition,arrItems);
		}
	},

	insertItemsInFavorites : function(intPosition, arrItems) {
		if(this.objFavoriteList){
			this.objFavoriteList.insertItems(intPosition,arrItems);
		}
	},

	updateItemInList : function(objContact){
		if(this.objContactList){
			this.objContactList.updateItem(objContact);
		}
		if(this.objContactPKList){
			this.objContactPKList.updateItem(objContact);
		}
	},

	refreshContactListTitle : function() {
		if(webapp.contacts.contactList){
			webapp.contacts.contactList.getTitle().updateContent(this.getContactListTitle());
		}
	},

	refreshPreviewTitle : function() {
		if(webapp.contacts.favoriteContainer){
			webapp.contacts.favoriteContainer.getTitle().updateContent([this.getFavoriteTitle()]);
		}
	},

	switchMenu : function(intIndex, bForce) {
		// Check if that menu was not already displayed and if the view is loaded
		if((this._intDisplayedMenu !== intIndex || bForce) && webapp.contacts.contactList){
			var contactIdToLoad;
			webapp.contacts.contactList.getContent().hideList(this.getDisplayedMenu());
			webapp.contacts.contactList.getContent().showList(intIndex);
			this.setDisplayedMenu(intIndex);

			if(intIndex == this.menuIds.CONTACT){
				contactIdToLoad = this.getIntSelectContactId();
				if(!contactIdToLoad && this.objContactList.arrItems[0]){
					this.objContactList.selectItemByPosition(0, true);
				} else {
					this.objContactList.selectItemByIndex(contactIdToLoad, true);
				}
			} else if(intIndex == this.menuIds.FAVORITE){
				contactIdToLoad = this.getIntSelectFavoriteId();
				if(!contactIdToLoad && this.objFavoriteList.arrItems[0]){
					this.objFavoriteList.selectItemByPosition(0, true);
				} else {
					this.objFavoriteList.selectItemByIndex(contactIdToLoad, true);
				}
			}
		} else {
			this.setDisplayedMenu(intIndex);
		}
	},

	getDisplayedMenu : function() {
		return this._intDisplayedMenu;
	},

	setDisplayedMenu : function(intIndex) {
		this._intDisplayedMenu = intIndex;
		intIndex = null;
	},

	setIntSelectFavoriteId : function(intIndex) {
		this.intSelectFavoriteId = intIndex;

		intIndex = null;
	},

	setIntSelectContactId : function(intIndex) {
		this.intSelectContactId = intIndex;

		intIndex = null;
	},

	getIntSelectFavoriteId : function() {
		return this.intSelectFavoriteId;
	},

	getIntSelectContactId : function() {
		return this.intSelectContactId;
	},

	getIntContactNumber : function() {
		return this._intContactNumber;
	},

	setIntContactNumber : function(intContactNumber) {
		if(this._intContactNumber !== intContactNumber){
			this._intContactNumber = intContactNumber;

			// Change corresponding title
			this.refreshContactListTitle();
		}
	},

	increaseIntContactNumber : function() {
		this.setIntContactNumber(this.getIntContactNumber() +1);
	},

	decreaseIntContactNumber : function() {
		var newIntContactNumber = this.getIntContactNumber() -1;
		if(newIntContactNumber < 0){
			newIntContactNumber = 0;
		}
		this.setIntContactNumber(newIntContactNumber);
	},

	getIntFavoriteNumber : function() {
		return this._intFavoriteNumber;
	},

	setIntFavoriteNumber : function(intFavoriteNumber) {
		if(this._intFavoriteNumber !== intFavoriteNumber){
			this._intFavoriteNumber = intFavoriteNumber;

			// Change corresponding titles
			this.refreshContactListTitle();
			this.refreshPreviewTitle();
		}
	},

	increaseIntFavoriteNumber : function() {
		this.setIntFavoriteNumber(this.getIntFavoriteNumber() +1);
	},

	decreaseIntFavoriteNumber : function() {
		var newIntFavoriteNumber = this.getIntFavoriteNumber() -1;
		if(newIntFavoriteNumber < 0){
			newIntFavoriteNumber = 0;
		}
		this.setIntFavoriteNumber(newIntFavoriteNumber);
	},

	setTabToLoad : function(intTabId) {
		this._intTabToLoad = intTabId;
	},

	getTabToLoad : function() {
		return this._intTabToLoad;
	}

});
dojo.require("webapp.contacts.dataBase");
dojo.provide("webapp.contacts.data");
dojo.declare("webapp.contacts.data",webapp.contacts.dataBase,{

	_arrAllButtons				: [],
	_arrAppBarSkeleton			: [],
	hotelMode					: false,


	constructor : function(){
		var func = dojo.hitch( webapp.contacts, webapp.contacts.buttonCallback );

		this._arrAllButtons[this.CALL_BTN] = {strButtonName : this.CALL_BTN, strButtonLabel :_("Call","webapp.contacts"),callback : func,strButtonIcon: 'communication-call'};
		this._arrAllButtons[this.SEARCH_BTN] = {strButtonName : this.SEARCH_BTN, strButtonLabel :_("Search", "ICTouchAPI"),callback : func,strButtonIcon: 'generic-search-by-name'};
		this._arrAllButtons[this.INPREVIEW_BTN] = {strButtonName: this.INPREVIEW_BTN,strButtonLabel: _('FavoritesBtn','webapp.contacts'),callback : func,strButtonIcon: 'contacts-favorites-application',strStatusIcon:'notif-off'};
		this._arrAllButtons[this.CREATE_BTN] = {strButtonName : this.CREATE_BTN, strButtonLabel :_("New", "ICTouchAPI"),callback : func,strButtonIcon: 'contacts-add'};
		this._arrAllButtons[this.COPY_BTN] = {strButtonName : this.COPY_BTN, strButtonLabel :_("Copy", "webapp.contacts"),callback : func,strButtonIcon: 'generic-save'};
		this._arrAllButtons[this.EDIT_BTN] = {strButtonName : this.EDIT_BTN, strButtonLabel :_("Edit", "webapp.contacts"),callback : func,strButtonIcon: 'contacts-modify'};
		this._arrAllButtons[this.DELETE_BTN] = {strButtonName : this.DELETE_BTN, strButtonLabel :_("Delete", "ICTouchAPI"),callback : func,strButtonIcon: 'contacts-delete'};
		//this._arrAllButtons[this.SAVE_CONTACT_BTN] = {strButtonName: this.SAVE_CONTACT_BTN,	strButtonLabel: _("Save Contact", "webapp.contacts"),callback : func,strButtonIcon: 'generic-save'};


		this._arrAppBarSkeleton[this.STATUS_HOME] = [this.CALL_BTN,this.SEARCH_BTN,this.INPREVIEW_BTN,"WHITE_LIST_ADD_BTN","WHITE_LIST_REMOVE_BTN",this.CREATE_BTN,this.COPY_BTN,"IM",this.EDIT_BTN,this.DELETE_BTN/*,this.CONTACTLOG_BTN*/,"ADD_TO_BUDDYLIST","REMOVE_FROM_BUDDYLIST","MODIFY_DISPLAY_NAME","MAGNIFY","homepageBtnHelp"];
		this._arrAppBarSkeleton[this.STATUS_EDITION] = [/*this.SAVE_CONTACT_BTN*/,"MAGNIFY","homepageBtnHelp"];
		this._arrAppBarSkeleton[this.STATUS_MR_SCREEN] = [];
		this._arrAppBarSkeleton[this.STATUS_PROGKEYS] = [this.NEXT];
		this._arrAppBarSkeleton[this.STATUS_PROGKEY_ADD] = [this.CALL_BTN,"MAGNIFY","homepageBtnHelp"];
		this._arrAppBarSkeleton[this.STATUS_MDR_ROUTING] = [this.CALL_BTN,"MAGNIFY","homepageBtnHelp"];
		var backFunc={
			context: webapp.contacts,
			func: webapp.contacts.buttonCallback,
			param: this.BACK
		};

		for(var i in this._arrAppBarSkeleton){
			var appBar = ICTouchAPI.AppBarServices.createAppBar("contacts","contactsstatus"+i , this._arrAppBarSkeleton[i]);
			// Create the static back button
			ICTouchAPI.AppBarServices.addExitButton("contacts","contactsstatus"+i, true, backFunc);
			for(var j in this._arrAppBarSkeleton[i]){
				var currentBtn = this._arrAppBarSkeleton[i][j];
				//Button from communication webapp
				if(this._arrAllButtons[currentBtn]){
					var objButton = new UIElements.AppButton.AppButtonControl(this._arrAllButtons[currentBtn]);
					if (this._arrAllButtons[currentBtn].strButtonName === this.INPREVIEW_BTN){
						this.objInPreviewBtnUI = objButton;
					}
					appBar.addAppButton(objButton,false);
				//Button from other webapps
				}else{
					appBar.addAppButton(currentBtn,false);
				}
			}
			appBar.buildDom();
		}

		ICTouchAPI.AppBarServices.createAppBar("contacts","getContactProgKey", []);




		this.arrWidgetsData[this.STATUS_HOME] = {
			container: "webapp.contacts.getContactCard",
			buttons: []
		};
		this.arrWidgetsData[this.STATUS_EDITION] = {
			container: "webapp.contacts.getContactEdition",
			buttons: []
		};
		this.arrWidgetsData[this.STATUS_MR_SCREEN] = {
			container: "webapp.contacts.getContactList",
			buttons: []
		};
		this.arrWidgetsData[this.STATUS_PROGKEYS] = {
			container: "webapp.contacts.getContactList",
			buttons: []
		};
		this.arrWidgetsData[this.STATUS_PROGKEY_ADD] = {
			container: "webapp.contacts.getContactCard",
			buttons: []
		};
		this.arrWidgetsData[this.STATUS_MDR_ROUTING] = {
			container: "webapp.contacts.getContactCard",
			buttons: []
		};

		this._contactListTitle=_("Address book", "webapp.contacts");

		// Check if the webapp communication is already loaded before adding the buttons
		// "Add contact" and "Edit contact" to the webapp communication
		if (webapp.communication) {
			this._addContactButtonsToCommunication();
		}
		// If the webapp communication is not loaded yet, subscribe to the event
		// "webapp.communication.loaded" emitted after the creation of the
		// communication view (posteCreate of getCommunicationBase)
		else {
			dojo.subscribe("webapp.communication.loaded", this, function() {
				this._addContactButtonsToCommunication();
			});
		}
	},

	onHotelMode: function(boolOnHotelMode){
		this.setHotelMode(boolOnHotelMode);
		var i;
		if(webapp.history && webapp.history.data){
			var objContact = webapp.history.data.getCurrentContact();
			var tabStatus = [webapp.history.data.STATUS_LOG,webapp.history.data.STATUS_LOG_CONFERENCE_PARTICIPANT_SELECTED,webapp.history.data.STATUS_LOG_CONFERENCE_PARTICIPANT_MENULIST_SELECTED];
			for(i in tabStatus){
				this.onManageHistoryButtonsEvent(objContact, tabStatus[i]);//manage communication buttons
			}
		}
		this.checkContactSelected();//manage contact buttons
	},

	getHotelMode:function() {
		return this.hotelMode;
	},

	setHotelMode:function(_b){
		this.hotelMode = _b;
	},

	/* _addContactButtonsToCommunication
     * Add the buttons "Add Contact" and "Edit Contact" to the communication webapp,
     * Subscribe to the event "ManageExternalButtonsCom" to manage the display of the buttons (show/hide).
     * */
	_addContactButtonsToCommunication:function() {
		dojo.subscribe("ManageExternalButtonsHistory", this, this.onManageHistoryButtonsEvent);
		dojo.subscribe("HideContactButtons", null, dojo.hitch(this, this.onHideButtonsEvent));
		//add 2 buttons to the communication webapp
		var addButton = {
			strButtonName: this.ADD_CONTACT,
			strButtonLabel:  _('Add', 'ICTouchAPI'),
			strButtonIcon: 'contacts-add',
			callback: this.onAddCallback
		};

		webapp.history.addButtonForStatus(webapp.history.data.STATUS_LOG, addButton);
		webapp.history.addButtonForStatus(webapp.history.data.STATUS_LOG_CONFERENCE_PARTICIPANT_SELECTED, addButton);
		webapp.history.addButtonForStatus(webapp.history.data.STATUS_LOG_CONFERENCE_PARTICIPANT_MENULIST_SELECTED, addButton);

	},
	
	onManageHistoryButtonsEvent : function(objContact, status) {
		var numAppBar = webapp.history.data.getNumAppBarFromStatus(status);
		var appBar = ICTouchAPI.AppBarServices._getAppBarWidget("communication", "historystatus"+numAppBar);
		var btnAdd = appBar.getButton(this.ADD_CONTACT);

		this._hideOrShowButton(objContact, btnAdd)
	},

	/*
	 * @private
	 */
	_hideOrShowButton : function(objContact, objAddButton) {
		if(objAddButton && typeof objAddButton !== "string"){
			var contact = null;
			if(this.getHotelMode()){
					if (objAddButton) {
						objAddButton.hide();
				}
			}else{
				// try to find the contact in the dataStore to know if it the contact is already
				// in the list (edit contact) or if it is a new contact (add contact)
				// Test if it isn't an empty contact card
				if (objContact && objContact.contactId && !objContact.contactFromNumber) {
					contact = ICTouchAPI.dataStoreServices.getStore('contacts').getAt(objContact.contactId);
				}
				// hide the button "add contact" if the contact is local or if it is an anonymous contact
				if ((contact && contact.type !== ICTouchAPI.tools.enumContactType.CACHED) || (objContact && objContact.officePhone == "anonymous")) {
						if (objAddButton) {
							objAddButton.hide();
					}
				}
				else {
						if (objAddButton) {
							objAddButton.show();
					}
				}
			}
		}
	}
});

webapp.contacts.data=new webapp.contacts.data();
dojo.provide("webapp.contacts.getContactBase");
dojo.declare("webapp.contacts.getContactBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		container       : null,

		_lastBackState	: [],

		constructor : function() {
			this._lastBackState = [];
		},

		reloadContainer : function() {
			var data = webapp.contacts.data;
			var strPresenceTitle = "";
			var objCurrentContact = data.getCurrentContact();
			if(objCurrentContact){
				strPresenceTitle = data.getFormatedTelephonyPresence(objCurrentContact.telephonyPresence, true);
			}
			//Title
			var objTitle = {
				strLabel: data.getContactTitle(),
				strLeftIcon: strPresenceTitle
			};
			this.container.reload({
				objTitle: objTitle,
				objContent: {
					name: data.getContainerPath(),
					params: {}
				}
			});
			this._changeBackButton();
		},

		reloadMenu: function() {
			var data = webapp.contacts.data;
			webapp.contacts.contactList.reload({
				objTitle: {
					arrItems : data.getContactListTitle()
				},
				objContent: {
					name: "webapp.contacts.getContactList",
					params: {}
				}
			});
		},

		postCreate: function() {
			this._changeBackButton();
			this.subscribe("iframe.show", this._iframeChange);
		},

		_iframeChange: function(id) {
			if (id === this.declaredClass) {
				this._changeBackButton();
			}
		},

		_changeBackButton: function() {
			var data = this.webapp.data;
			var status = this.webapp.currentStatus;

			var isProgkey = webapp.communication && webapp.communication.isSelectStatusProgkey();
			var isMDR = webapp.communication && webapp.communication.isSelectStatusMDR();
			var backFunc;
			var isBack = false;
			if(!isProgkey && !isMDR) {
				var isPreviousHome = (status === data.STATUS_HOME) && !(this.webapp.overriddenParams && this.webapp.overriddenParams.clbkBack);
				if (!this._lastBackState[status] || this._lastBackState[status] !== isPreviousHome) {
					//Back button
					backFunc = {
						context: this.webapp,
						func: this.webapp.buttonCallback,
						param: data.BACK
					};
				}
				this._lastBackState[status] = isPreviousHome;
				isBack = isPreviousHome;
			} else {
				if(isProgkey){
					backFunc = {
						context: this.webapp,
						func: function(){
							if(webapp.progkeys) {
								webapp.progkeys.externalBack();
							} else {
								ICTouchAPI.transitionServices.back();
							}
						},
						param: data.BACK
					};
					this._lastBackState[status] = false;
					isBack = false;
				}else if(isMDR){
					backFunc = {
						context: this.webapp,
						func: function(){
							if(webapp.userservices.data.getContainerPath() == "webapp.userservices.getProfileDetails"){
								webapp.userservices._setOtherNumber("");
							}else if(webapp.userservices.data.getContainerPath() == "webapp.userservices.getOverflowContent"){
								webapp.userservices.data.loadOverflowDetails();
							}
							webapp.contacts.currentStatus = webapp.contacts.data.STATUS_HOME;
							ICTouchAPI.transitionServices.back();
						},
						param: data.BACK
					};
					this._lastBackState[status] = false;
					isBack = false;
				}
			}
			if(backFunc){
				ICTouchAPI.AppBarServices.addExitButton("contacts", "contactsstatus" + status, isBack, backFunc);
			}
		},

		onShow : function() {
			var data = webapp.contacts.data;
			ICTouchAPI.debugServices.debug("webapp.contacts.getContactBase - onShow / On Show for id: " + data.intSelectContactId);
			data.objContactList.selectItemByIndex(data.intSelectContactId, true);
		},

		onHide : function() {
			webapp.contacts.overriddenParams = null;
		}
	}
	);
dojo.require("webapp.contacts.getContactBase");
dojo.provide("webapp.contacts.getContact");
dojo.declare("webapp.contacts.getContact",
	webapp.contacts.getContactBase,
	{
		templatePath	: dojo.moduleUrl("webapp.contacts","templates/getContact8082.html"),

		postCreate:function() {

			var data = webapp.contacts.data;
			var am = new UIElements.ApplicationMode.ThirdControl(
			{
				menu : {
					name    : "webapp.contacts.getContactList",
					params  : {}
				},
				container : {
					name    : data.getContainerPath(),
					params  : {}
				},
				objMenuTitle : {
					arrItems: data.getContactListTitle(),
					clickTitleCallback : function(intIndex) {
						webapp.contacts.data.switchMenu(intIndex);
					}
				},
				objContainerTitle : {
					strLabel: ""
				}
			}, this.domContact);
			this.container = am.getContainer();
			webapp.contacts.mainWidget = this;
			webapp.contacts.contactList = am.getMenu();

			// load the MenuList
			data.loadContactList();
			
			// Auto select the contact tab
			am.getMenu().selectTitleById(this.webapp.data.getTabToLoad(), false);

			dojo.publish("webapp.contacts.loaded");

			this.inherited(arguments);
		}
	});
/*Contact Webapplication*/
dojo.provide("webapp.contacts.getContactListBase");
dojo.declare("webapp.contacts.getContactListBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		domContactListTitle: null,
		domContactList: null,
		domFavoriteList: null,

		postCreate : function() {
			var data = webapp.contacts.data;
			var func;

			func = dojo.hitch(webapp.contacts, webapp.contacts.onContactListClick);
			// create an empty MenuList
			data.objContactList = new UIElements.MenuList.MenuListControl({
				arrItems: [],
				callback: func,
				showEmptyState: true
			}, this.domContactList);

			// create an empty MenuList
			data.objFavoriteList = new UIElements.MenuList.MenuListControl({
				arrItems: [],
				callback: func,
				showEmptyState: true
			}, this.domFavoriteList);

			this.hideList(this.webapp.data.menuIds.CONTACT);
			this.hideList(this.webapp.data.menuIds.FAVORITE);

		},

		getDomItem : function(intIndex){
			var domItem = null;
			if(intIndex === this.webapp.data.menuIds.CONTACT){
				domItem = this.webapp.data.objContactList.domNode;
			} else if(intIndex === this.webapp.data.menuIds.FAVORITE) {
				domItem = this.webapp.data.objFavoriteList.domNode;
			}

			intIndex = null;
			return domItem;
		},

		hideList : function(intIndex) {
			var domItem = this.getDomItem(intIndex);
			if(domItem){
				dojo.style(domItem, "display", "none");
			}
			intIndex = null;
		},

		showList : function(intIndex) {
			var domItem = this.getDomItem(intIndex);
			if(domItem){
				dojo.style(domItem, "display", "block");
			}
			intIndex = null;
		}

	}
	);
/*Contact Webapplication*/
dojo.require("webapp.contacts.getContactListBase");
dojo.provide("webapp.contacts.getContactList");
dojo.declare("webapp.contacts.getContactList", 
	webapp.contacts.getContactListBase,
	{
		templatePath: dojo.moduleUrl("webapp.contacts","templates/getContactList8082.html")
	});
dojo.provide("webapp.contacts.getContactCardBase");
dojo.declare("webapp.contacts.getContactCardBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		_arrContainers				: [],

		// Contact header data
		strContactName				: "",
		strContactFirstname			: "",
		boolPresenceInfo			: false,
		strContactPhotoPath			: "",
		strPresencePhotoPath		: "",
		strContactCompany			: "",
		strContactPosition			: "",
		strContactLocation			: "",
		boolHasBusinessInformation	: false,
		domPresenceIcon				: null,
		domEmptyState				: null,
		scroll					: null,
		objEmptyState					: null,
		objContactLabel					: _("Contacts folder is empty", "webapp.contacts"),
		objFavoriteLabel					: _("Favorites folder is empty", "webapp.contacts"),

		constructor: function() {
			var objContact = webapp.contacts.data.objCurrentContact;
			if (objContact) {
			var defaultPhoto = ICTouchAPI.tools.getDefaultPhotoPath("user", "100");
				this.strContactPhotoPath = (objContact.photo) ? objContact.photo : defaultPhoto;
				this.strContactCompany = (objContact.miscMap && objContact.miscMap['company']) ? objContact.miscMap['company'] : "";
				this.strContactPosition = (objContact.miscMap && objContact.miscMap['job']) ? objContact.miscMap['job'] : "";
				this.strContactLocation = (objContact.miscMap && objContact.miscMap['city']) ? objContact.miscMap['city'] : "";
                this.strContactLocation += (objContact.miscMap && objContact.miscMap['country']) ? " - "+objContact.miscMap['country'] : "";
			}
		},

		postMixInProperties : function() {
			// Only show businessInformation if one of these is non null
			this.boolHasBusinessInformation =
			this.strContactCompany.length > 0 ||
			this.strContactPosition.length > 0 ||
			this.strContactLocation.length > 0;
		},

		postCreate: function() {
			this.buildInfosList();

			this.scroll = FXScroll.init({
				"handler" : this.domNode,
				"easing" : true,
				"scrollType" : "vertical"
			});

			dojo.publish("ManageExternalButtonsContact", [webapp.contacts.data.objCurrentContact, webapp.contacts.data.STATUS_HOME]);

			// EmptyState is only visible when there is no contact card to display
			if (!this.webapp.data.objCurrentContact) {
				var label;
				if (this.webapp.data.getDisplayedMenu() === this.webapp.data.menuIds.FAVORITE) {
					label = this.objFavoriteLabel;
				}
				else {
					label = this.objContactLabel;
				}
				this.objEmptyState = new UIElements.EmptyState.EmptyStateControl({
					boolVisible: true,
					strEmptyMessage: label
				}, this.domEmptyState);
			}
		},

		destroy: function() {
			if (this.objEmptyState) {
				this.objEmptyState.destroy();
				delete this.objEmptyState;
			}
			this.inherited(arguments);
		},

		/**
		 * Build the contact info list
		 * - create the data
		 * - create the UIElement
		 */
		buildInfosList: function () {
			var data = webapp.contacts.data;
			var objContact = data.objCurrentContact;
			if(!objContact)
				return;
			//change the status of the button In Preview accordingly
			if (data.objInPreviewBtnUI) {
				(objContact.isPreviewed) ? data.objInPreviewBtnUI.setStatusIcon("notif-on") : data.objInPreviewBtnUI.setStatusIcon("notif-off");
			}

			// build UI
			new UIElements.PresentationList.PresentationListControl({
				arrItems : data.getInfoList(),
				boolScroll : false,
				boolShowIcon: true,
				boolShowLabel: true,
                strDisplay:'contactcard'
			}, this.domContactDetails);
		}
	}
	);
dojo.require("webapp.contacts.getContactCardBase");
dojo.provide("webapp.contacts.getContactCard");
dojo.declare("webapp.contacts.getContactCard", 
	webapp.contacts.getContactCardBase,
	{
		templatePath: dojo.moduleUrl("webapp.contacts","templates/getContactCard8082.html")
	}
	);
/*Webapplication: Contact - Widget: Preview*/
dojo.provide("webapp.contacts.getContactPreviewBase");
dojo.declare("webapp.contacts.getContactPreviewBase",
	[ICTouchAPI.webWidget, dijit._Templated],
	{
		domContent: null,
		favoriteContainer: null,

		postMixInProperties:function(){
		},

		postCreate:function() {

			var data = webapp.contacts.data;

			/* Create an empty MenuList */
			data.objPreviewList = new UIElements.MenuList.MenuListControl({
				arrItems: [],
				boolPreview : true,
				showEmptyState: true,
				boolNotSelectable: true,
				callback: function(intIndex) {
					webapp.contacts.onFavoritesEnter(intIndex);
				}
			}, null);

			/* Create the ContainerControl and pass it the MenuList */
			webapp.contacts.favoriteContainer = new UIElements.Container.ContainerControl({
				objTitle: this.webapp.data.getFavoriteTitle(),
				objContent: {
					obj : data.objPreviewList
				}
			}, this.domContent);
		},

		destroy : function(){
			var data = this.webapp.data;
			if(data.objPreviewList) {
				data.objPreviewList.destroy();
				delete data.objPreviewList;
			}
			if(webapp.contacts.favoriteContainer){
				webapp.contacts.favoriteContainer.destroy();
				delete webapp.contacts.favoriteContainer;
			}
			this.inherited(arguments);
		},

		_clicked:function(){
			webapp.contacts.onFavoritesEnter();
		}

	});
/*Webapplication: Contact - Widget: Preview*/
dojo.require("webapp.contacts.getContactPreviewBase");
dojo.provide("webapp.contacts.getContactPreview");
dojo.declare("webapp.contacts.getContactPreview",
	webapp.contacts.getContactPreviewBase,
	{
		templatePath: dojo.moduleUrl("webapp.contacts","templates/getContactPreview8082.html")
	}
	);
dojo.provide("webapp.contacts.getContactEditionBase");
dojo.declare("webapp.contacts.getContactEditionBase",
	[ICTouchAPI.webWidget, dijit._Templated],
	{
		_arrPresentationListEntries	: [],
		domContent : null,

		postCreate : function() {
			var data = webapp.contacts.data;
			this._arrPresentationListEntries = [];
			data.objCurrentEditedContact = dojo.clone(data.objCurrentContact);

			//initialize the object miscMap
			if (data.objCurrentEditedContact.miscMap == undefined)
				data.objCurrentEditedContact.miscMap = {};

			// Contact keys and labels are given in tools.js
			// keys must correspond to defaults keys from a contact
			var arrKeys = ICTouchAPI.tools.getContactFieldLabels();

			for (var key in arrKeys)
			{
				var item = arrKeys[key];
				var strInput, funcCallback;
				if(item.id != "collaborationId"){
					if (item.misc) {	// true if the key is from the miscMap
						strInput = (data.objCurrentEditedContact.miscMap[key]) ? data.objCurrentEditedContact.miscMap[key] : "";
						funcCallback = function(strContent) {
							data.objCurrentEditedContact.miscMap[this.strKey] = strContent;
						};
					}
					else {
						strInput = (data.objCurrentEditedContact[key]) ? data.objCurrentEditedContact[key] : "";
						funcCallback = function(strContent) {
							data.objCurrentEditedContact[this.strKey] = strContent;
						};
					}
					this._arrPresentationListEntries.push({
						strLabel: _(item.label, "webapp.contacts"),
						objContent :  new UIElements.InputField.InputFieldControl({
							keyboardType: (item.type == "Phone" || item.type == "Fax" || item.type == "otherPhone") ? ((item.type == "otherPhone") ? ICTouchAPI.KeyboardTypes.NUM : ICTouchAPI.KeyboardTypes.DIALPAD) : ICTouchAPI.KeyboardTypes.ALPHANUM,
							strInputText: strInput,
							strInputTitle : _(item.label, "webapp.contacts"),
							isMultiLines: false,
							strKey: key, //saves the Key of the field for the callback
							funcCallback: funcCallback
						})
					});
				}
			}
			new UIElements.PresentationList.PresentationListControl({
				arrItems: this._arrPresentationListEntries,
				boolShowLabel: true
			}, this.domContent);
		}
	});
dojo.require("webapp.contacts.getContactEditionBase");
dojo.provide("webapp.contacts.getContactEdition");
dojo.declare("webapp.contacts.getContactEdition",
	webapp.contacts.getContactEditionBase,
	{
		templatePath: dojo.moduleUrl("webapp.contacts","templates/getContactEdition8082.html")
	}
	);
dojo.provide("webapp.contacts.getContactProgKeyBase");
dojo.declare("webapp.contacts.getContactProgKeyBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{

		postCreate:function() {
			ICTouchAPI.transitionServices.stealth("webapp.contacts.getContactProgKey");			
			webapp.contacts.contactsPK = new UIElements.ApplicationMode.FullControl(
			{
				content : {
					name    : "UIElements.Container.ContainerControl",
					params  : {
						objTitle: {
							strLabel: _("Contacts", "webapp.contacts")
						},
						objContent: {
							name: "webapp.contacts.getContactProgKeyList",
							params: {}
						}
					}
				}
			},this.domContactProgKey);

			this.createStaticButton();
			this.createActionButton();


		},

		createStaticButton : function(){
			var backFunc = function(){
				if(webapp.progkeys.currentAddWidget) {
					webapp.progkeys.currentAddWidget.back();
				}
				webapp.contacts.data.pkContactID = null;
				ICTouchAPI.transitionServices.back();
			};
			ICTouchAPI.AppBarServices.addExitButton("contacts","contactsstatus"+webapp.contacts.data.STATUS_PROGKEYS,false, backFunc);


		},

		createActionButton : function(){
			var nextFunc = dojo.hitch(webapp.contacts, function(){
				webapp.contacts._progKeySetArgs(webapp.contacts.data.pkContactID);
			});

			var nextStepButton = {
				strButtonName: this.webapp.data.NEXT,
				strButtonLabel: _('Next', 'ICTouchAPI'),
				strButtonIcon: 'generic-next',
				strStatusText:'',
				strStatusIcon:'',
				callback: nextFunc
			};
			var objButton = new UIElements.AppButton.AppButtonControl(nextStepButton);

			var appBarCPK = ICTouchAPI.AppBarServices._getAppBarWidget("contacts","contactsstatus"+webapp.contacts.data.STATUS_PROGKEYS);
			appBarCPK.addActionButton(objButton);
			ICTouchAPI.AppBarServices.setAppBar("contacts","contactsstatus"+webapp.contacts.data.STATUS_PROGKEYS, "getContactProgKey");
		},

		startup : function(){

		}

	});
dojo.require("webapp.contacts.getContactProgKeyBase");
dojo.provide("webapp.contacts.getContactProgKey");
dojo.declare("webapp.contacts.getContactProgKey",
	webapp.contacts.getContactProgKeyBase,
	{
		templatePath	: dojo.moduleUrl("webapp.contacts","templates/getContactProgKey8082.html"),
	});
dojo.provide("webapp.contacts.getContactProgKeyListBase");
dojo.declare("webapp.contacts.getContactProgKeyListBase",
	[ICTouchAPI.webWidget, dijit._Templated],
	{		
		domContactProgKeyList: null,

		postCreate : function() {
			var data = webapp.contacts.data;
			var func;
			
			func = dojo.hitch(webapp.contacts, function(contactId){
				webapp.contacts.data.pkContactID = contactId;
			});
			// create an empty MenuList
			data.objContactPKList = new UIElements.MenuList.MenuListControl({
				arrItems: [],
				callback: func,
				autoSelectFirst: false
			}, this.domContactProgKeyList);

		// load the MenuList
		data.loadContactList();
	}


	
});
dojo.require("webapp.contacts.getContactProgKeyListBase");
dojo.provide("webapp.contacts.getContactProgKeyList");
dojo.declare("webapp.contacts.getContactProgKeyList",
	webapp.contacts.getContactProgKeyListBase,
	{
		templatePath: dojo.moduleUrl("webapp.contacts","templates/getContactProgKeyList8082.html")
	});
