/*Webapplication: Contact - Widget: Preview*/
dojo.provide("webapp.contacts.getContactPreviewBase");
dojo.declare("webapp.contacts.getContactPreviewBase",
	[ICTouchAPI.webWidget, dijit._Templated],
	{
		domContent: null,
		favoriteContainer: null,

		postMixInProperties:function(){
		},

		postCreate:function() {

			var data = webapp.contacts.data;

			/* Create an empty MenuList */
			data.objPreviewList = new UIElements.MenuList.MenuListControl({
				arrItems: [],
				boolPreview : true,
				showEmptyState: true,
				boolNotSelectable: true,
				callback: function(intIndex) {
					webapp.contacts.onFavoritesEnter(intIndex);
				}
			}, null);

			/* Create the ContainerControl and pass it the MenuList */
			webapp.contacts.favoriteContainer = new UIElements.Container.ContainerControl({
				objTitle: this.webapp.data.getFavoriteTitle(),
				objContent: {
					obj : data.objPreviewList
				}
			}, this.domContent);
		},

		destroy : function(){
			var data = this.webapp.data;
			if(data.objPreviewList) {
				data.objPreviewList.destroy();
				delete data.objPreviewList;
			}
			if(webapp.contacts.favoriteContainer){
				webapp.contacts.favoriteContainer.destroy();
				delete webapp.contacts.favoriteContainer;
			}
			this.inherited(arguments);
		},

		_clicked:function(){
			webapp.contacts.onFavoritesEnter();
		}

	});
