/*Contact Webapplication*/
dojo.provide("webapp.contacts.getContactListBase");
dojo.declare("webapp.contacts.getContactListBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		domContactListTitle: null,
		domContactList: null,
		domFavoriteList: null,

		postCreate : function() {
			var data = webapp.contacts.data;
			var func;

			func = dojo.hitch(webapp.contacts, webapp.contacts.onContactListClick);
			// create an empty MenuList
			data.objContactList = new UIElements.MenuList.MenuListControl({
				arrItems: [],
				callback: func,
				showEmptyState: true
			}, this.domContactList);

			// create an empty MenuList
			data.objFavoriteList = new UIElements.MenuList.MenuListControl({
				arrItems: [],
				callback: func,
				showEmptyState: true
			}, this.domFavoriteList);

			this.hideList(this.webapp.data.menuIds.CONTACT);
			this.hideList(this.webapp.data.menuIds.FAVORITE);

		},

		getDomItem : function(intIndex){
			var domItem = null;
			if(intIndex === this.webapp.data.menuIds.CONTACT){
				domItem = this.webapp.data.objContactList.domNode;
			} else if(intIndex === this.webapp.data.menuIds.FAVORITE) {
				domItem = this.webapp.data.objFavoriteList.domNode;
			}

			intIndex = null;
			return domItem;
		},

		hideList : function(intIndex) {
			var domItem = this.getDomItem(intIndex);
			if(domItem){
				dojo.style(domItem, "display", "none");
			}
			intIndex = null;
		},

		showList : function(intIndex) {
			var domItem = this.getDomItem(intIndex);
			if(domItem){
				dojo.style(domItem, "display", "block");
			}
			intIndex = null;
		}

	}
	);
