dojo.provide("webapp.contacts.getContactEditionBase");
dojo.declare("webapp.contacts.getContactEditionBase",
	[ICTouchAPI.webWidget, dijit._Templated],
	{
		_arrPresentationListEntries	: [],
		domContent : null,

		postCreate : function() {
			var data = webapp.contacts.data;
			this._arrPresentationListEntries = [];
			data.objCurrentEditedContact = dojo.clone(data.objCurrentContact);

			//initialize the object miscMap
			if (data.objCurrentEditedContact.miscMap == undefined)
				data.objCurrentEditedContact.miscMap = {};

			// Contact keys and labels are given in tools.js
			// keys must correspond to defaults keys from a contact
			var arrKeys = ICTouchAPI.tools.getContactFieldLabels();

			for (var key in arrKeys)
			{
				var item = arrKeys[key];
				var strInput, funcCallback;
				if(item.id != "collaborationId"){
					if (item.misc) {	// true if the key is from the miscMap
						strInput = (data.objCurrentEditedContact.miscMap[key]) ? data.objCurrentEditedContact.miscMap[key] : "";
						funcCallback = function(strContent) {
							data.objCurrentEditedContact.miscMap[this.strKey] = strContent;
						};
					}
					else {
						strInput = (data.objCurrentEditedContact[key]) ? data.objCurrentEditedContact[key] : "";
						funcCallback = function(strContent) {
							data.objCurrentEditedContact[this.strKey] = strContent;
						};
					}
					this._arrPresentationListEntries.push({
						strLabel: _(item.label, "webapp.contacts"),
						objContent :  new UIElements.InputField.InputFieldControl({
							keyboardType: (item.type == "Phone" || item.type == "Fax" || item.type == "otherPhone") ? ((item.type == "otherPhone") ? ICTouchAPI.KeyboardTypes.NUM : ICTouchAPI.KeyboardTypes.DIALPAD) : ICTouchAPI.KeyboardTypes.ALPHANUM,
							strInputText: strInput,
							strInputTitle : _(item.label, "webapp.contacts"),
							isMultiLines: false,
							strKey: key, //saves the Key of the field for the callback
							funcCallback: funcCallback
						})
					});
				}
			}
			new UIElements.PresentationList.PresentationListControl({
				arrItems: this._arrPresentationListEntries,
				boolShowLabel: true
			}, this.domContent);
		}
	});
