dojo.provide("webapp.contacts.getContactCardBase");
dojo.declare("webapp.contacts.getContactCardBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		_arrContainers				: [],

		// Contact header data
		strContactName				: "",
		strContactFirstname			: "",
		boolPresenceInfo			: false,
		strContactPhotoPath			: "",
		strPresencePhotoPath		: "",
		strContactCompany			: "",
		strContactPosition			: "",
		strContactLocation			: "",
		boolHasBusinessInformation	: false,
		domPresenceIcon				: null,
		domEmptyState				: null,
		scroll					: null,
		objEmptyState					: null,
		objContactLabel					: _("Contacts folder is empty", "webapp.contacts"),
		objFavoriteLabel					: _("Favorites folder is empty", "webapp.contacts"),

		constructor: function() {
			var objContact = webapp.contacts.data.objCurrentContact;
			if (objContact) {
			var defaultPhoto = ICTouchAPI.tools.getDefaultPhotoPath("user", "100");
				this.strContactPhotoPath = (objContact.photo) ? objContact.photo : defaultPhoto;
				this.strContactCompany = (objContact.miscMap && objContact.miscMap['company']) ? objContact.miscMap['company'] : "";
				this.strContactPosition = (objContact.miscMap && objContact.miscMap['job']) ? objContact.miscMap['job'] : "";
				this.strContactLocation = (objContact.miscMap && objContact.miscMap['city']) ? objContact.miscMap['city'] : "";
                this.strContactLocation += (objContact.miscMap && objContact.miscMap['country']) ? " - "+objContact.miscMap['country'] : "";
			}
		},

		postMixInProperties : function() {
			// Only show businessInformation if one of these is non null
			this.boolHasBusinessInformation =
			this.strContactCompany.length > 0 ||
			this.strContactPosition.length > 0 ||
			this.strContactLocation.length > 0;
		},

		postCreate: function() {
			this.buildInfosList();

			this.scroll = FXScroll.init({
				"handler" : this.domNode,
				"easing" : true,
				"scrollType" : "vertical"
			});

			dojo.publish("ManageExternalButtonsContact", [webapp.contacts.data.objCurrentContact, webapp.contacts.data.STATUS_HOME]);

			// EmptyState is only visible when there is no contact card to display
			if (!this.webapp.data.objCurrentContact) {
				var label;
				if (this.webapp.data.getDisplayedMenu() === this.webapp.data.menuIds.FAVORITE) {
					label = this.objFavoriteLabel;
				}
				else {
					label = this.objContactLabel;
				}
				this.objEmptyState = new UIElements.EmptyState.EmptyStateControl({
					boolVisible: true,
					strEmptyMessage: label
				}, this.domEmptyState);
			}
		},

		destroy: function() {
			if (this.objEmptyState) {
				this.objEmptyState.destroy();
				delete this.objEmptyState;
			}
			this.inherited(arguments);
		},

		/**
		 * Build the contact info list
		 * - create the data
		 * - create the UIElement
		 */
		buildInfosList: function () {
			var data = webapp.contacts.data;
			var objContact = data.objCurrentContact;
			if(!objContact)
				return;
			//change the status of the button In Preview accordingly
			if (data.objInPreviewBtnUI) {
				(objContact.isPreviewed) ? data.objInPreviewBtnUI.setStatusIcon("notif-on") : data.objInPreviewBtnUI.setStatusIcon("notif-off");
			}

			// build UI
			new UIElements.PresentationList.PresentationListControl({
				arrItems : data.getInfoList(),
				boolScroll : false,
				boolShowIcon: true,
				boolShowLabel: true,
                strDisplay:'contactcard'
			}, this.domContactDetails);
		}
	}
	);
