dojo.provide("webapp.contacts.getContactBase");
dojo.declare("webapp.contacts.getContactBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		container       : null,

		_lastBackState	: [],

		constructor : function() {
			this._lastBackState = [];
		},

		reloadContainer : function() {
			var data = webapp.contacts.data;
			var strPresenceTitle = "";
			var objCurrentContact = data.getCurrentContact();
			if(objCurrentContact){
				strPresenceTitle = data.getFormatedTelephonyPresence(objCurrentContact.telephonyPresence, true);
			}
			//Title
			var objTitle = {
				strLabel: data.getContactTitle(),
				strLeftIcon: strPresenceTitle
			};
			this.container.reload({
				objTitle: objTitle,
				objContent: {
					name: data.getContainerPath(),
					params: {}
				}
			});
			this._changeBackButton();
		},

		reloadMenu: function() {
			var data = webapp.contacts.data;
			webapp.contacts.contactList.reload({
				objTitle: {
					arrItems : data.getContactListTitle()
				},
				objContent: {
					name: "webapp.contacts.getContactList",
					params: {}
				}
			});
		},

		postCreate: function() {
			this._changeBackButton();
			this.subscribe("iframe.show", this._iframeChange);
		},

		_iframeChange: function(id) {
			if (id === this.declaredClass) {
				this._changeBackButton();
			}
		},

		_changeBackButton: function() {
			var data = this.webapp.data;
			var status = this.webapp.currentStatus;

			var isProgkey = webapp.communication && webapp.communication.isSelectStatusProgkey();
			var isMDR = webapp.communication && webapp.communication.isSelectStatusMDR();
			var backFunc;
			var isBack = false;
			if(!isProgkey && !isMDR) {
				var isPreviousHome = (status === data.STATUS_HOME) && !(this.webapp.overriddenParams && this.webapp.overriddenParams.clbkBack);
				if (!this._lastBackState[status] || this._lastBackState[status] !== isPreviousHome) {
					//Back button
					backFunc = {
						context: this.webapp,
						func: this.webapp.buttonCallback,
						param: data.BACK
					};
				}
				this._lastBackState[status] = isPreviousHome;
				isBack = isPreviousHome;
			} else {
				if(isProgkey){
					backFunc = {
						context: this.webapp,
						func: function(){
							if(webapp.progkeys) {
								webapp.progkeys.externalBack();
							} else {
								ICTouchAPI.transitionServices.back();
							}
						},
						param: data.BACK
					};
					this._lastBackState[status] = false;
					isBack = false;
				}else if(isMDR){
					backFunc = {
						context: this.webapp,
						func: function(){
							if(webapp.userservices.data.getContainerPath() == "webapp.userservices.getProfileDetails"){
								webapp.userservices._setOtherNumber("");
							}else if(webapp.userservices.data.getContainerPath() == "webapp.userservices.getOverflowContent"){
								webapp.userservices.data.loadOverflowDetails();
							}
							webapp.contacts.currentStatus = webapp.contacts.data.STATUS_HOME;
							ICTouchAPI.transitionServices.back();
						},
						param: data.BACK
					};
					this._lastBackState[status] = false;
					isBack = false;
				}
			}
			if(backFunc){
				ICTouchAPI.AppBarServices.addExitButton("contacts", "contactsstatus" + status, isBack, backFunc);
			}
		},

		onShow : function() {
			var data = webapp.contacts.data;
			ICTouchAPI.debugServices.debug("webapp.contacts.getContactBase - onShow / On Show for id: " + data.intSelectContactId);
			data.objContactList.selectItemByIndex(data.intSelectContactId, true);
		},

		onHide : function() {
			webapp.contacts.overriddenParams = null;
		}
	}
	);
