dojo.provide("webapp.contacts.dataBase");
dojo.declare("webapp.contacts.dataBase",null,{
	_arrContactAddresses		: [],
	_arrAppButtons 				: [],
	_arrInfoList				: [],
	intSelectContactId			: null,
	intSelectFavoriteId			: null,
	intDisplayedContactId		: null,
	objCurrentContact			: null,
	objLastViewedContact		: null,
	objCurrentEditedContact		: null,
	objInPreviewBtnUI			: null,
	objContactList				: null,
	objFavoriteList				: null,
	objPreviewList                          : null,
	arrWidgetsData				: [],
	intCurrentWidget			: 0,
	strContainerPath			: "",
	strTitle					: "",
	newContactId				: -1,
	nrOfContacts				: null,
	photoPath					: "",
	currentContactDisplayName	: "",
    intCptPhoneNumber           : 0,
	_boolNumberingDone			: false,
	objBackPopup				: null,
	_boolChangeScreen			: false,

	showOnlyFavorites			: false,
	intComSelectStatus			: -1,
	arrComSelectStatus			: {},

	_intDisplayedMenu			: null,

	// Variable to set before first load of contact application to specify which tab it should open.
	// By default (constructor), it is contacts tab.
	_intTabToLoad				: "",

	// Graphical settings values
	boolPictureInMenu			: false,
	boolTelephonyPresenceAvailable : null,
	boolIMPresenceAvailable : null,
	boolIsInBuddyList		:null,

	// Static map of title translations, only used in getContactTitle
	_arrTitleTranslation: [
		"No contacts",
		"No favorites"
	],

	// Constant values for the button's id
    CALL_BTN: "CALL_BTN",
	BACK: "BACK_BTN",
	CREATE_BTN : "CREATE_BTN",
	NEWCALL_BTN : "NEWCALL_BTN",
	INVITE_BTN : "INVITE_BTN",
	COPY_BTN : "COPY_BTN",
	EDIT_BTN : "EDIT_BTN",
	DELETE_BTN : "DELETE_BTN",
	SEARCH_BTN : "SEARCH_BTN",
	ADD_ADRESS_BTN : "ADD_ADRESS_BTN",
	ADD_BTN : "ADD_BTN",
	INPREVIEW_BTN : "IN_PREVIEW_BTN",
	ADD_CONTACT : "ADD_CONTACT",
	NEXT : "NEXT_BTN",

	//STATUS
	STATUS_HOME			: 0,
	STATUS_EDITION		: 1,
	STATUS_MR_SCREEN	: 2,
	STATUS_PROGKEYS		: 3,
	STATUS_PROGKEY_ADD	: 4,
	STATUS_MDR_ROUTING	: 5,
	NB_STATUS			: 6,

	current_status			: 0,

	// Widgets
	WIDGET_SHOW:        0,
	WIDGET_EDIT:        1,
	WIDGET_ADDRESS:     2,

	//Filters
	COMLOG_FILTERED:	2,
	COMLOG_FILTER_ALL:	8,

	// Number of favorites/contacts
	_intFavoriteNumber	: 0,
	_intContactNumber	: 0,

	// Lists Ids
	menuIds: {
		"FAVORITE"	: 0,
		"CONTACT"	: 1
	},

	constructor : function() {
		this.setTabToLoad(this.menuIds.CONTACT);
	},

	getContactListTitle : function(){
		return [
			this.getFavoriteTitle(),
			{
				strIcon: "contacts-tabs-contacts-32",
				strLabel : _('Contacts', 'webapp.contacts'),
				strLabelBottom: '(' + this.getIntContactNumber() + ')',
				intIndex : this.menuIds.CONTACT
			}
		]
	},

	getFavoriteTitle : function() {
		return {
			strIcon: "contacts-tabs-favorites-32",
			strLabel : _('FavoritesShortTtl', 'webapp.contacts'),
			strLabelBottom: '(' + this.getIntFavoriteNumber() + ')',
			intIndex : this.menuIds.FAVORITE
		}
	},

	//manages the display of several butons
	checkContactSelected : function(){
        this.intCptPhoneNumber=0;

		//if there are no contacts then disable a few buttons
		var appBar = ICTouchAPI.AppBarServices._getAppBarWidget("contacts", "contactsstatus"+this.STATUS_HOME);
		var btnCall = appBar.getButton(this.CALL_BTN);
		var btnCopy = appBar.getButton(this.COPY_BTN);
		var btnDelete = appBar.getButton(this.DELETE_BTN);
		var btnEdit = appBar.getButton(this.EDIT_BTN);
		var btnPreview = appBar.getButton(this.INPREVIEW_BTN);
		var btnAdd = appBar.getButton(this.CREATE_BTN);
		appBar = ICTouchAPI.AppBarServices._getAppBarWidget("contacts", "contactsstatus"+this.STATUS_PROGKEY_ADD);
		var btnAddToFav = appBar.getButton(this.CALL_BTN);
		appBar = ICTouchAPI.AppBarServices._getAppBarWidget("contacts", "contactsstatus"+this.STATUS_MDR_ROUTING);
		var btnSelectForMDR = appBar.getButton(this.CALL_BTN);

		if(this.getHotelMode()){
			btnAdd.hide();
		}
		else{
			btnAdd.show();
		}
		if (this.objCurrentContact == null) {
			btnCall.hide();
			btnCopy.hide();
			btnDelete.hide();
			btnEdit.hide();
			btnPreview.hide();
			btnAddToFav.hide();
			btnSelectForMDR.hide();
		}
		else {
            ICTouchAPI.tools.getContactPhone(this.objCurrentContact);
            if(this.objCurrentContact.officePhone){
                this.intCptPhoneNumber++;
            }
            if(this.objCurrentContact.personalHome){
                this.intCptPhoneNumber++;
            }
            if(this.objCurrentContact.personalMobile){
                this.intCptPhoneNumber++;
            }
			if(this.objCurrentContact.personalFax){
                this.intCptPhoneNumber++;
            }

            if(this.intCptPhoneNumber==1){

                btnCall.show();
				btnAddToFav.show();
				btnSelectForMDR.show();

            }
            else{
                btnCall.hide();
				btnAddToFav.hide();
				btnSelectForMDR.hide();
            }
			if(!this.getHotelMode()){
				if (this.objCurrentContact.type == ICTouchAPI.tools.enumContactType.LOCAL) {
					btnCopy.hide();
					btnDelete.show();
					btnEdit.show();
					btnPreview.show();
				} else if(this.objCurrentContact.type == ICTouchAPI.tools.enumContactType.DM){
					btnCopy.hide();
					btnDelete.hide();
					btnEdit.hide();
					btnPreview.show();
				} else if(this.objCurrentContact.type == ICTouchAPI.tools.enumContactType.MA) {
					btnCopy.hide();
					btnDelete.hide();
					btnEdit.hide();
					btnPreview.hide();
				} else { // All distant contacts
					btnCopy.show();
					btnDelete.hide();
					btnEdit.hide();
					btnPreview.hide();
				}
			}else{
				btnCopy.hide();
				btnDelete.hide();
				btnEdit.hide();
				btnPreview.hide();
			}
		}
		if(this.strContainerPath != 'webapp.contacts.getContactEdition') {
			//display the contact Card
			this.switchContainer("getContactCard", this.current_status);
		}
	},

	// check if all the fields of the given objContact are empty
	createEmptyContact : function(){
       return {contactId: -1, miscMap:{}};
	},

	getContactAddresses : function(){
		return this._arrContactAddresses;
	},

	getContainerPath : function(){
		return this.arrWidgetsData[webapp.contacts.currentStatus].container;
	},

	getAppBarAppButtons : function(){
		return this.arrWidgetsData[webapp.contacts.currentStatus].buttons;
	},

	getCurrentContact : function(){
		return this.objCurrentContact;
	},

	getFormatedPhoto : function(strPicture){
		var picture;
		if(this.boolPictureInMenu){
			picture = (strPicture) ? strPicture : ICTouchAPI.tools.getDefaultPhotoPath("user", "50");
		} else {
			picture = undefined;
		}
		return picture;
	},

	getFormatedImPresence : function(strPresence, boolWithoutSize){
		if(ICTouchAPI.presenceServices.isIMPresenceAvailable()){
			return ICTouchAPI.tools.getPresenceIconPath(strPresence, !boolWithoutSize && '32');
		} else {
			return undefined;
		}
	},

	getFormatedTelephonyPresence : function(strPresence, boolWithoutSize){
		if(ICTouchAPI.presenceServices.isTelephonyPresenceAvailable() && strPresence){
			return ICTouchAPI.tools.getTelephonyPresenceIconPath(strPresence, !boolWithoutSize && '32');
		} else {
			return undefined;
		}
	},

	//simillar to a refresh function, it is the starting point to a new refresh of the contact list
	loadContactList : function() {
		// Get all contacts
		this.loadedContactList(ICTouchAPI.dataStoreServices.getStore('contacts').getList());

	},

	loadPreviewList : function() {
		var tmp=[];
		ICTouchAPI.dataStoreServices.getStore('contacts').getList().forEach(function(obj) {
			if(obj.isPreviewed) tmp.push(obj);
		},this);
		this._loadedPreviewList(tmp);
	},

	//callback for the getLocalContacts bussines function
	loadedContactList: function(_arrOriginal) {
		var arrContacts = [];
		var arrFavorites = [];
		var item;

		if (this.objContactList) {
			var contact;
			//Build the list Items
			for (var i = 0; i < _arrOriginal.length; i++) {
				contact = _arrOriginal[i];
				if(contact.type !== ICTouchAPI.tools.enumContactType.CACHED){
					item = this.formatContactForMenuList(contact);
					arrContacts.push(item);

					if (contact.isPreviewed){
						arrFavorites.push(dojo.clone(item));
					}
				}
			}

			arrContacts.sort(this.compareListItems);
			arrFavorites.sort(this.compareListItems);

			//Insert all items in one time
			this.insertItemsInList(0, arrContacts);
			
			//Insert all items in one time
			this.insertItemsInFavorites(0, arrFavorites);

			//Select the item
			if (arrContacts.length == 0) {
				//No item: empty card
				this.setIntSelectContactId(0);
				this.objCurrentContact = null;
				this.switchContainer("getContactCard", this.current_status);
			} else {
				if(this.objContactPKList && this.pkContactID) { 
					this.objContactPKList.selectItemByIndex(this.pkContactID, true);
				}
			}

			// Set both length for title
			this.setIntContactNumber(arrContacts.length);
			this.setIntFavoriteNumber(arrFavorites.length);
		}
	},

	_loadedPreviewList:function(_arrPreview){
		//add the list of review Contacts
		var arrItems = [];
		var item;

		if (this.objPreviewList) {
			var contact;
			//Build the list Items
			for (var i = 0; i < _arrPreview.length; i++) {
				contact = _arrPreview[i];
				if(contact.type !== ICTouchAPI.tools.enumContactType.CACHED){
					item = this.formatContactForMenuList(contact);
					arrItems.push(item);
				}
			}

			arrItems.sort(this.compareListItems);

			//Insert all items in one time
			this.objPreviewList.insertItems(0,arrItems);

			this.setIntFavoriteNumber(arrItems.length);
		}
	},

	_pushContactInList: function(objContact, boolPK, boolNormal) {
		var contact = this.formatContactForMenuList(objContact);
		if(this.objContactList && boolNormal){
			this.objContactList.pushItem(contact, true);
		}
		if(this.objContactPKList && boolPK){
			this.objContactPKList.pushItem(contact, true);
		}
		this.increaseIntContactNumber();
	},

	_removePreviousRemoteContact: function(boolSelectFirst) {
		if(this.objContactList) {
			var remoteContact = this.objContactList.findItem('isRemote', true);
			if (remoteContact && remoteContact.objContact && remoteContact.objContact.contactId) {
				this.removeItemByIntIndexInList(remoteContact.objContact.contactId, true);
				if(boolSelectFirst){
					this.selectContactByPosition(0, true);
				}
			}
		}
	},

	_removePreviousRemoteContactById: function(remodeContactId) {
		if(this.objContactList) {
			var remoteContact = this.objContactList.findItem('isRemote', true);
			if (remoteContact && remoteContact.objContact && remoteContact.objContact.contactId && remoteContact.objContact.contactId == remodeContactId) {
				this.removeItemByIntIndexInList(remoteContact.objContact.contactId, true);
			}
		}
	},

	loadDetails: function(contactId) {
		var objContactToLoad;
		if(this.getDisplayedMenu() == this.menuIds.CONTACT){
			objContactToLoad = this.objContactList.findItem("intIndex", contactId);
			this.setIntSelectContactId((objContactToLoad) ? contactId : null);
		} else if(this.getDisplayedMenu() == this.menuIds.FAVORITE){
			objContactToLoad = this.objFavoriteList.findItem("intIndex", contactId);
			this.setIntSelectFavoriteId((objContactToLoad) ? contactId : null);
		}
		if(objContactToLoad){
			this.objCurrentContact = objContactToLoad.objContact;
		} else {
			this.objCurrentContact = null;
			ICTouchAPI.debugServices.warning("webapp.contacts.dataBase - loadDetails $ no contact found for contactId: " + contactId);
		}
		this.intDisplayedContactId = contactId;
		if(this.objContactList){
			this.checkContactSelected();
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.contacts.dataBase - loadDetails / this.objContactList does not exist.");
		}
	},

	//gets the list of details of the current contact
	getInfoList:function(){
		return ICTouchAPI.tools.getContactPresentationList(
			this.objCurrentContact,
			webapp.contacts,
			webapp.contacts.onPresentationListClick,
			"webapp.contacts",
			this.arrComSelectStatus[this.intComSelectStatus].icon
		);
	},

	getContactTitle : function() {
		var strTitle = this._strTitle || ICTouchAPI.tools.getContactDisplayName(this.objCurrentContact);

		if (!strTitle) {
			var index = this.showOnlyFavorites ? 1 : 0;
			strTitle = _(this._arrTitleTranslation[index], "webapp.contacts");
		}
		return strTitle;
	},

	// set a new content for the container of the contact and call an update of the appBar
	switchContainer: function(pageName, status, pageTitle) {
		ICTouchAPI.debugServices.info("webapp.contacts.dataBase - switchContainer $ input function params | pageName: " + pageName + " | status: " + " | pageTitle: " + ((pageTitle && pageTitle.isI18Ned) ? pageTitle.toString():pageTitle));
		this.strContainerPath = "webapp.contacts."+pageName;
		// No pageTitle means default title
		this._strTitle = pageTitle || null;
		if (webapp.contacts.mainWidget) {
			this.updateAppBar(status);
			webapp.contacts.mainWidget.reloadContainer();
		}
	},

	// set the appBar corresponding to the status
	updateAppBar: function(status) {
		// set the status
		webapp.contacts.currentStatus = status;

		// Register appBar according to state
		ICTouchAPI.AppBarServices.setAppBar("contacts", "contactsstatus"+status, "getContact");
	},

	setContactId : function(intId)
	{
		this.objCurrentContact.contactId = intId;
	},

	// This function is called when clicked on "add contact" button in webapp communication
	onAddCallback:function() {
		if (webapp.history) {
			var objContact = webapp.history.data.getCurrentContact();
			ICTouchAPI.debugServices.debug("webapp.contacts.dataBase - onAddCallback / add contact using current contact ok communication webapp: " + dojo.toJson(objContact));

			webapp.contacts.data._boolNumberingDone = false;

			webapp.contacts.editContact({
				objContact: objContact,
				clbkBack: function() {
					ICTouchAPI.transitionServices.getScreen({
						name: "webapp.communication.getHistory",
						params: {}
					})
				}
			});
		}
	},

	getContactCardFromCommunication : function () {
		if(webapp.communication){
			var objContact = webapp.communication.getSelectedParticipant() ;
			if (!objContact){
				return;
			}
			if(objContact.objContact){
				webapp.contacts.showContact({
					intId: objContact.objContact.contactId,
					clbkBack: function() {
						ICTouchAPI.transitionServices.getScreen({
							name: "webapp.communication.getCommunication",
							params: {}
						});
					}
				});
			}
		}
	},

	updatePresenceInList : function(objContactDetails, objContactChanges) {
		var contact;
		// Check if we have the contact currently displayed in a list.
		if(this.objContactList){
			contact = this.objContactList.findItem("intIndex", objContactDetails.contactId);
		} else if (this.objPreviewList){
			contact = this.objPreviewList.findItem("intIndex", objContactDetails.contactId);
		}
		if(contact){
			var objContact = this.formatContactForMenuList(objContactDetails);
			var isPreviewed = contact.pPreview;
			// Refresh presence in 2/3 if it is the selected contact and if contact view was already loaded.
			if(webapp.contacts.mainWidget && this.objCurrentContact && this.objCurrentContact.contactId == objContactDetails.contactId){
				webapp.contacts.mainWidget.container.setTitleLeftIcon(this.getFormatedTelephonyPresence(objContactChanges.telephonyPresence, true));
			}
			// Refresh 1/3 if required
			if(this.objContactList){
				this.updateItemInList(objContact);
			}
			// Refresh preview if required
			if (isPreviewed) {
				this.updateContactInFavoriteList(objContact);
			}
		}
	},

	formatContactForMenuList : function(objContact) {
		var contact = {}

		contact.intIndex = objContact.contactId,
		contact.objContact = objContact;
		contact.strPrimaryContent = ICTouchAPI.tools.getContactDisplayName(objContact);
		contact.isRemote = objContact.isRemote;
		contact.pPreview = objContact.isPreviewed;
		contact.pName = objContact.name;
		contact.pFirstName = objContact.firstName;
		contact.strPicture = this.getFormatedPhoto(objContact.photo);
		contact.objIconLeft = objContact.telephonyPresence ? {icon: this.getFormatedTelephonyPresence(objContact.telephonyPresence)} : null ;


		objContact = null;
		return contact;
	},

	updateContactInList:function(newContactList) {
		ICTouchAPI.debugServices.debug("webapp.contacts.dataBase - updateContactInList $ input function params | newContactList: " + dojo.toJson(newContactList));
		var contact;
		if(this.objContactList){
			contact = this.objContactList.findItem("intIndex", newContactList.contactId);
		} else if (this.objPreviewList){
			contact = this.objPreviewList.findItem("intIndex", newContactList.contactId);
		}
		var objContact = this.formatContactForMenuList(newContactList);
		if(contact) {
			// if contact exists, update the contact
			ICTouchAPI.debugServices.debug("webapp.contacts.dataBase - updateContactInList / contact exists");
			var isPreviewed = contact.pPreview;
			var name = contact.pName;
			var firstName = contact.pFirstName;
			ICTouchAPI.debugServices.debug("webapp.contacts.dataBase - updateContactInList / isPreviewed: " + isPreviewed + " | newContactList.isPreviewed: " + newContactList.isPreviewed);
			if(newContactList.isPreviewed == isPreviewed) {
				ICTouchAPI.debugServices.debug("webapp.contacts.dataBase - updateContactInList / preview didn't change");
				// if preview didn't change
				if(newContactList.name==name && newContactList.firstName==firstName) {
					ICTouchAPI.debugServices.debug("webapp.contacts.dataBase - updateContactInList / name didn't change");
					this.updateContactInFavoriteList(objContact);

					// if name didn't change, order does not change, just update info
					this.updateItemInList(objContact);
					//edit
					if(this.intDisplayedContactId == newContactList.contactId){
						this.selectSafeByIndex(this.intDisplayedContactId,true,-4);
					}
					ICTouchAPI.debugServices.debug("webapp.contacts.dataBase - updateContactInList / name did change");
				} else {
					ICTouchAPI.debugServices.debug("webapp.contacts.dataBase - updateContactInList / name did change");
					// if name did change, remove + insert
					this.removeItemByIntIndexInList(newContactList.contactId,true);
					this.addItemInContactList(objContact);
					
					// Remove + insert in favorite + preview
					if(isPreviewed){
						this.removeContactFromFavoriteList(newContactList.contactId, false);
						this.addContactInFavoriteList(objContact);
					}
					ICTouchAPI.debugServices.debug("webapp.contacts.dataBase - updateContactInList / existing in preview updating with: " + dojo.toJson(contact));
					ICTouchAPI.debugServices.debug("webapp.contacts.dataBase - updateContactInList / Contact updated: " + dojo.toJson(newContactList) + " | " + dojo.toJson(this.objContactList.findItem("intIndex", newContactList.contactId)));
				}
			} else {
				ICTouchAPI.debugServices.debug("webapp.contacts.dataBase - updateContactInList / preview did change");
				// if preview did change
				this.updateItemInList(objContact);
				if(newContactList.isPreviewed) {
					// false to true
					if(this.intDisplayedContactId == newContactList.contactId){
						this.objInPreviewBtnUI.setStatusIcon("notif-on");
					}
					ICTouchAPI.debugServices.debug("webapp.contacts.dataBase - updateContactInList / unknown in preview creating from: " + dojo.toJson(newContactList));
					this.addContactInFavoriteList(objContact);
				} else {
					// true to false
					ICTouchAPI.debugServices.debug("webapp.contacts.dataBase - updateContactInList / Contact removed from preview: " + newContactList.contactId);
					this.removeContactFromFavoriteList(newContactList.contactId);
					if(this.intDisplayedContactId == newContactList.contactId){
						this.objInPreviewBtnUI.setStatusIcon("notif-off");
					}
				}
			}
		} else {
			ICTouchAPI.debugServices.debug("webapp.contacts.dataBase - updateContactInList / contact doesn't exist");
			// if contact doesn't exist, Add the contact
			this.addItemInContactList(objContact);

			if(newContactList.isPreviewed) {
				this.addContactInFavoriteList(objContact);
			}
		}

		newContactList = null;
	},

	addItemInContactList : function(objContactToAdd){
		if(this.objContactList){
			// get menu list place to insert item
			var insertIdx = this.objContactList._DONT_USE_locateItem(["name","firstName"], [objContactToAdd.pName,objContactToAdd.pFirstName]);
			// if no place is found, insert on the end
			if(insertIdx==-1){
				insertIdx=this.objContactList.length;
			}

			this.insertItemsInList(insertIdx, [objContactToAdd]);

			// Refresh information if needed
			if(!this.intSelectContactId){
				this.intSelectContactId = objContactToAdd.objContact.contactId;
					this.selectSafeByIndex(this.intSelectContactId,true);
			}

			this.increaseIntContactNumber();

		}
	},

	addContactInFavoriteList : function(objContactToAdd) {
		var insertIdx;
		// Try to add in favorite list
		if(this.objFavoriteList){
			insertIdx = this.objFavoriteList._DONT_USE_locateItem(["name","firstName"], [objContactToAdd.pName,objContactToAdd.pFirstName]);
			if(insertIdx == -1){
				 insertIdx = this.objFavoriteList.arrItems.length;
			}
			this.objFavoriteList.insertItems(insertIdx,	[dojo.clone(objContactToAdd)]);
			if(this.getDisplayedMenu() == this.menuIds.FAVORITE){
				this.objFavoriteList.selectItemByPosition(insertIdx, true);
			}
		}
		// Try to add in preview list
		if(this.objPreviewList){
			insertIdx = this.objPreviewList._DONT_USE_locateItem(["name","firstName"], [objContactToAdd.pName,objContactToAdd.pFirstName]);
			if(insertIdx == -1){
				 insertIdx = this.objPreviewList.arrItems.length;
			}
			this.objPreviewList.insertItems(insertIdx,	[dojo.clone(objContactToAdd)]);
		}
		this.increaseIntFavoriteNumber();
	},


	updateContactInFavoriteList : function(objContactToUpdate) {
		if(this.objFavoriteList){
			this.objFavoriteList.updateItem(objContactToUpdate);
		}
		if(this.objPreviewList){
			this.objPreviewList.updateItem(objContactToUpdate);
		}
	},

	removeContactFromFavoriteList : function(contactId, overrideBSelect) {
		var bSelect = (this.getDisplayedMenu() == this.menuIds.FAVORITE);
		var objContact = null;
		if(typeof overrideBSelect !== "undefined"){
			bSelect = overrideBSelect;
		}
		if (this.objPreviewList) {
			objContact = this.objPreviewList.removeItemByIntIndex(contactId, true);
		}
		if (this.objFavoriteList) {
			if(contactId == this.getIntSelectFavoriteId()){
				this.setIntSelectFavoriteId(null);
			}
			objContact = this.objFavoriteList.removeItemByIntIndex(contactId, !bSelect);
			if(this.objFavoriteList.arrItems.length == 0 && bSelect){
				this.setIntSelectFavoriteId(null);
				if(this.getDisplayedMenu() == this.menuIds.FAVORITE){
					this.loadDetails(null);
				}
			}
		}
		if(objContact){
			this.decreaseIntFavoriteNumber();
		}
	},

	selectSafeByIndex : function(contactId,boolClick,doNotScroll){
		if(this.getDisplayedMenu() == this.menuIds.FAVORITE){
			if(this.objFavoriteList){
				this.objFavoriteList.selectItemByIndex(contactId, boolClick,doNotScroll);
			}
		} else if(this.getDisplayedMenu() == this.menuIds.CONTACT && this.objContactList){
			this.objContactList.selectItemByIndex(contactId, boolClick,doNotScroll);
		}

	},

	//we check if the objcontactList exists in this function
	deselectSafe : function(){
		if(this.objContactList){
			this.objContactList.deselect();
		}
	},

	//we check if the objcontactList exists in this function
	selectContactByPosition : function(intPosition,boolClick){
		if(this.objContactList){
			this.objContactList.selectItemByPosition(intPosition, boolClick);
		}
	},

	deleteContactInList: function(contactId) {
		this.intSelectContactId = -1;
		this.objCurrentContact = null;
		this.switchContainer("getContactCard", webapp.contacts.data.current_status);
		this.removeItemByIntIndexInList(contactId);
		this.removeContactFromFavoriteList(contactId);
		// If there is no more contacts in the list, refresh the appbar
		if (this.objContactList && this.objContactList.arrItems.length == 0) {
			this.checkContactSelected();
		}
	},
	
	//Sort items of a list
	compareListItems : function(item1,item2) {
		var id1 = item1.pName + item1.pFirstName;
		var id2 = item2.pName + item2.pFirstName;

		id1 = id1.toLowerCase();
		id2 = id2.toLowerCase();

		if (id2 > id1) {
			return -1;
		}
		else if (id2 < id1) {
			return 1;
		}

		return 0;
	},

	synchronizeContact: function(contacts) {
		var previewList = [];
		var contact;

		if (this.objContactList && this.objFavoriteList) {

			//Refresh the contact list
			this.objContactList.emptyItems();
			this.objFavoriteList.emptyItems();
			this.intSelectContactId = 0; //Reset the current selected contact 
			this.intSelectFavoriteId = 0; //Reset the current selected favorite
			this.loadedContactList(contacts);
		}

		// manage contacts in preview list, if exists
		if (this.objPreviewList) {
			//refresh the preview list
			this.objPreviewList.emptyItems();
			// get the list of favorites contacts ('isPreviewed')
			for (var i=0; i<contacts.length; i++) {
				contact = contacts[i];
                                if (contact.isPreviewed) {
					previewList.push(contact);
                                }
			}
			this._loadedPreviewList(previewList);
			} 
		contacts=null;
		previewList=null;
		contact=null;
	},

	updateContactInPreview: function(contactId, toAdd) {

		// Update the led accordingly to the action done
		if(this.objInPreviewBtnUI) {
			toAdd ? this.objInPreviewBtnUI.setStatusIcon("notif-on") : this.objInPreviewBtnUI.setStatusIcon("notif-off");
		}

		if (this.objContactList) {
			var contact = this.objContactList.findItem("intIndex", contactId);
			var objcontact = this.formatContactForMenuList(contact);
			if (this.objPreviewList) {
				this.objPreviewList.updateItem(objcontact);
				ICTouchAPI.debugServices.debug("webapp.contacts.dataBase - updateContactInPreview / Contact updated in preview: " + dojo.toJson(objcontact) + " | " + dojo.toJson(this.objPreviewList.findItem("intIndex", contactId)));
			}
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.contacts.dataBase - updateContactInPreview / this.objContactList does not exist.");
		}
	},

	removeItemByIntIndexInList : function(id, boolDoNotSelectNext){
		if (id == this.intSelectContactId) {
			this.intSelectContactId = null;
		}
		if(this.objContactList){
			this.objContactList.removeItemByIntIndex(id,boolDoNotSelectNext);
		}
		if(this.objContactPKList){
			this.objContactPKList.removeItemByIntIndex(id,true);
		}
		this.decreaseIntContactNumber();
	},

	insertItemsInList : function(intPosition, arrItems){
		if(this.objContactList){
			this.objContactList.insertItems(intPosition,arrItems);
		}
		if(this.objContactPKList){
			this.objContactPKList.insertItems(intPosition,arrItems);
		}
	},

	insertItemsInFavorites : function(intPosition, arrItems) {
		if(this.objFavoriteList){
			this.objFavoriteList.insertItems(intPosition,arrItems);
		}
	},

	updateItemInList : function(objContact){
		if(this.objContactList){
			this.objContactList.updateItem(objContact);
		}
		if(this.objContactPKList){
			this.objContactPKList.updateItem(objContact);
		}
	},

	refreshContactListTitle : function() {
		if(webapp.contacts.contactList){
			webapp.contacts.contactList.getTitle().updateContent(this.getContactListTitle());
		}
	},

	refreshPreviewTitle : function() {
		if(webapp.contacts.favoriteContainer){
			webapp.contacts.favoriteContainer.getTitle().updateContent([this.getFavoriteTitle()]);
		}
	},

	switchMenu : function(intIndex, bForce) {
		// Check if that menu was not already displayed and if the view is loaded
		if((this._intDisplayedMenu !== intIndex || bForce) && webapp.contacts.contactList){
			var contactIdToLoad;
			webapp.contacts.contactList.getContent().hideList(this.getDisplayedMenu());
			webapp.contacts.contactList.getContent().showList(intIndex);
			this.setDisplayedMenu(intIndex);

			if(intIndex == this.menuIds.CONTACT){
				contactIdToLoad = this.getIntSelectContactId();
				if(!contactIdToLoad && this.objContactList.arrItems[0]){
					this.objContactList.selectItemByPosition(0, true);
				} else {
					this.objContactList.selectItemByIndex(contactIdToLoad, true);
				}
			} else if(intIndex == this.menuIds.FAVORITE){
				contactIdToLoad = this.getIntSelectFavoriteId();
				if(!contactIdToLoad && this.objFavoriteList.arrItems[0]){
					this.objFavoriteList.selectItemByPosition(0, true);
				} else {
					this.objFavoriteList.selectItemByIndex(contactIdToLoad, true);
				}
			}
		} else {
			this.setDisplayedMenu(intIndex);
		}
	},

	getDisplayedMenu : function() {
		return this._intDisplayedMenu;
	},

	setDisplayedMenu : function(intIndex) {
		this._intDisplayedMenu = intIndex;
		intIndex = null;
	},

	setIntSelectFavoriteId : function(intIndex) {
		this.intSelectFavoriteId = intIndex;

		intIndex = null;
	},

	setIntSelectContactId : function(intIndex) {
		this.intSelectContactId = intIndex;

		intIndex = null;
	},

	getIntSelectFavoriteId : function() {
		return this.intSelectFavoriteId;
	},

	getIntSelectContactId : function() {
		return this.intSelectContactId;
	},

	getIntContactNumber : function() {
		return this._intContactNumber;
	},

	setIntContactNumber : function(intContactNumber) {
		if(this._intContactNumber !== intContactNumber){
			this._intContactNumber = intContactNumber;

			// Change corresponding title
			this.refreshContactListTitle();
		}
	},

	increaseIntContactNumber : function() {
		this.setIntContactNumber(this.getIntContactNumber() +1);
	},

	decreaseIntContactNumber : function() {
		var newIntContactNumber = this.getIntContactNumber() -1;
		if(newIntContactNumber < 0){
			newIntContactNumber = 0;
		}
		this.setIntContactNumber(newIntContactNumber);
	},

	getIntFavoriteNumber : function() {
		return this._intFavoriteNumber;
	},

	setIntFavoriteNumber : function(intFavoriteNumber) {
		if(this._intFavoriteNumber !== intFavoriteNumber){
			this._intFavoriteNumber = intFavoriteNumber;

			// Change corresponding titles
			this.refreshContactListTitle();
			this.refreshPreviewTitle();
		}
	},

	increaseIntFavoriteNumber : function() {
		this.setIntFavoriteNumber(this.getIntFavoriteNumber() +1);
	},

	decreaseIntFavoriteNumber : function() {
		var newIntFavoriteNumber = this.getIntFavoriteNumber() -1;
		if(newIntFavoriteNumber < 0){
			newIntFavoriteNumber = 0;
		}
		this.setIntFavoriteNumber(newIntFavoriteNumber);
	},

	setTabToLoad : function(intTabId) {
		this._intTabToLoad = intTabId;
	},

	getTabToLoad : function() {
		return this._intTabToLoad;
	}

});
