dojo.require("webapp.contacts.dataBase");
dojo.provide("webapp.contacts.data");
dojo.declare("webapp.contacts.data",webapp.contacts.dataBase,{

	_arrAllButtons				: [],
	_arrAppBarSkeleton			: [],
	hotelMode					: false,


	constructor : function(){
		var func = dojo.hitch( webapp.contacts, webapp.contacts.buttonCallback );

		this._arrAllButtons[this.CALL_BTN] = {strButtonName : this.CALL_BTN, strButtonLabel :_("Call","webapp.contacts"),callback : func,strButtonIcon: 'communication-call'};
		this._arrAllButtons[this.SEARCH_BTN] = {strButtonName : this.SEARCH_BTN, strButtonLabel :_("Search", "ICTouchAPI"),callback : func,strButtonIcon: 'generic-search-by-name'};
		this._arrAllButtons[this.INPREVIEW_BTN] = {strButtonName: this.INPREVIEW_BTN,strButtonLabel: _('FavoritesBtn','webapp.contacts'),callback : func,strButtonIcon: 'contacts-favorites-application',strStatusIcon:'notif-off'};
		this._arrAllButtons[this.CREATE_BTN] = {strButtonName : this.CREATE_BTN, strButtonLabel :_("New", "ICTouchAPI"),callback : func,strButtonIcon: 'contacts-add'};
		this._arrAllButtons[this.COPY_BTN] = {strButtonName : this.COPY_BTN, strButtonLabel :_("Copy", "webapp.contacts"),callback : func,strButtonIcon: 'generic-save'};
		this._arrAllButtons[this.EDIT_BTN] = {strButtonName : this.EDIT_BTN, strButtonLabel :_("Edit", "webapp.contacts"),callback : func,strButtonIcon: 'contacts-modify'};
		this._arrAllButtons[this.DELETE_BTN] = {strButtonName : this.DELETE_BTN, strButtonLabel :_("Delete", "ICTouchAPI"),callback : func,strButtonIcon: 'contacts-delete'};
		//this._arrAllButtons[this.SAVE_CONTACT_BTN] = {strButtonName: this.SAVE_CONTACT_BTN,	strButtonLabel: _("Save Contact", "webapp.contacts"),callback : func,strButtonIcon: 'generic-save'};


		this._arrAppBarSkeleton[this.STATUS_HOME] = [this.CALL_BTN,this.SEARCH_BTN,this.INPREVIEW_BTN,"WHITE_LIST_ADD_BTN","WHITE_LIST_REMOVE_BTN",this.CREATE_BTN,this.COPY_BTN,"IM",this.EDIT_BTN,this.DELETE_BTN/*,this.CONTACTLOG_BTN*/,"ADD_TO_BUDDYLIST","REMOVE_FROM_BUDDYLIST","MODIFY_DISPLAY_NAME","MAGNIFY","homepageBtnHelp"];
		this._arrAppBarSkeleton[this.STATUS_EDITION] = [/*this.SAVE_CONTACT_BTN*/,"MAGNIFY","homepageBtnHelp"];
		this._arrAppBarSkeleton[this.STATUS_MR_SCREEN] = [];
		this._arrAppBarSkeleton[this.STATUS_PROGKEYS] = [this.NEXT];
		this._arrAppBarSkeleton[this.STATUS_PROGKEY_ADD] = [this.CALL_BTN,"MAGNIFY","homepageBtnHelp"];
		this._arrAppBarSkeleton[this.STATUS_MDR_ROUTING] = [this.CALL_BTN,"MAGNIFY","homepageBtnHelp"];
		var backFunc={
			context: webapp.contacts,
			func: webapp.contacts.buttonCallback,
			param: this.BACK
		};

		for(var i in this._arrAppBarSkeleton){
			var appBar = ICTouchAPI.AppBarServices.createAppBar("contacts","contactsstatus"+i , this._arrAppBarSkeleton[i]);
			// Create the static back button
			ICTouchAPI.AppBarServices.addExitButton("contacts","contactsstatus"+i, true, backFunc);
			for(var j in this._arrAppBarSkeleton[i]){
				var currentBtn = this._arrAppBarSkeleton[i][j];
				//Button from communication webapp
				if(this._arrAllButtons[currentBtn]){
					var objButton = new UIElements.AppButton.AppButtonControl(this._arrAllButtons[currentBtn]);
					if (this._arrAllButtons[currentBtn].strButtonName === this.INPREVIEW_BTN){
						this.objInPreviewBtnUI = objButton;
					}
					appBar.addAppButton(objButton,false);
				//Button from other webapps
				}else{
					appBar.addAppButton(currentBtn,false);
				}
			}
			appBar.buildDom();
		}

		ICTouchAPI.AppBarServices.createAppBar("contacts","getContactProgKey", []);




		this.arrWidgetsData[this.STATUS_HOME] = {
			container: "webapp.contacts.getContactCard",
			buttons: []
		};
		this.arrWidgetsData[this.STATUS_EDITION] = {
			container: "webapp.contacts.getContactEdition",
			buttons: []
		};
		this.arrWidgetsData[this.STATUS_MR_SCREEN] = {
			container: "webapp.contacts.getContactList",
			buttons: []
		};
		this.arrWidgetsData[this.STATUS_PROGKEYS] = {
			container: "webapp.contacts.getContactList",
			buttons: []
		};
		this.arrWidgetsData[this.STATUS_PROGKEY_ADD] = {
			container: "webapp.contacts.getContactCard",
			buttons: []
		};
		this.arrWidgetsData[this.STATUS_MDR_ROUTING] = {
			container: "webapp.contacts.getContactCard",
			buttons: []
		};

		this._contactListTitle=_("Address book", "webapp.contacts");

		// Check if the webapp communication is already loaded before adding the buttons
		// "Add contact" and "Edit contact" to the webapp communication
		if (webapp.communication) {
			this._addContactButtonsToCommunication();
		}
		// If the webapp communication is not loaded yet, subscribe to the event
		// "webapp.communication.loaded" emitted after the creation of the
		// communication view (posteCreate of getCommunicationBase)
		else {
			dojo.subscribe("webapp.communication.loaded", this, function() {
				this._addContactButtonsToCommunication();
			});
		}
	},

	onHotelMode: function(boolOnHotelMode){
		this.setHotelMode(boolOnHotelMode);
		var i;
		if(webapp.history && webapp.history.data){
			var objContact = webapp.history.data.getCurrentContact();
			var tabStatus = [webapp.history.data.STATUS_LOG,webapp.history.data.STATUS_LOG_CONFERENCE_PARTICIPANT_SELECTED,webapp.history.data.STATUS_LOG_CONFERENCE_PARTICIPANT_MENULIST_SELECTED];
			for(i in tabStatus){
				this.onManageHistoryButtonsEvent(objContact, tabStatus[i]);//manage communication buttons
			}
		}
		this.checkContactSelected();//manage contact buttons
	},

	getHotelMode:function() {
		return this.hotelMode;
	},

	setHotelMode:function(_b){
		this.hotelMode = _b;
	},

	/* _addContactButtonsToCommunication
     * Add the buttons "Add Contact" and "Edit Contact" to the communication webapp,
     * Subscribe to the event "ManageExternalButtonsCom" to manage the display of the buttons (show/hide).
     * */
	_addContactButtonsToCommunication:function() {
		dojo.subscribe("ManageExternalButtonsHistory", this, this.onManageHistoryButtonsEvent);
		dojo.subscribe("HideContactButtons", null, dojo.hitch(this, this.onHideButtonsEvent));
		//add 2 buttons to the communication webapp
		var addButton = {
			strButtonName: this.ADD_CONTACT,
			strButtonLabel:  _('Add', 'ICTouchAPI'),
			strButtonIcon: 'contacts-add',
			callback: this.onAddCallback
		};

		webapp.history.addButtonForStatus(webapp.history.data.STATUS_LOG, addButton);
		webapp.history.addButtonForStatus(webapp.history.data.STATUS_LOG_CONFERENCE_PARTICIPANT_SELECTED, addButton);
		webapp.history.addButtonForStatus(webapp.history.data.STATUS_LOG_CONFERENCE_PARTICIPANT_MENULIST_SELECTED, addButton);

	},
	
	onManageHistoryButtonsEvent : function(objContact, status) {
		var numAppBar = webapp.history.data.getNumAppBarFromStatus(status);
		var appBar = ICTouchAPI.AppBarServices._getAppBarWidget("communication", "historystatus"+numAppBar);
		var btnAdd = appBar.getButton(this.ADD_CONTACT);

		this._hideOrShowButton(objContact, btnAdd)
	},

	/*
	 * @private
	 */
	_hideOrShowButton : function(objContact, objAddButton) {
		if(objAddButton && typeof objAddButton !== "string"){
			var contact = null;
			if(this.getHotelMode()){
					if (objAddButton) {
						objAddButton.hide();
				}
			}else{
				// try to find the contact in the dataStore to know if it the contact is already
				// in the list (edit contact) or if it is a new contact (add contact)
				// Test if it isn't an empty contact card
				if (objContact && objContact.contactId && !objContact.contactFromNumber) {
					contact = ICTouchAPI.dataStoreServices.getStore('contacts').getAt(objContact.contactId);
				}
				// hide the button "add contact" if the contact is local or if it is an anonymous contact
				if ((contact && contact.type !== ICTouchAPI.tools.enumContactType.CACHED) || (objContact && objContact.officePhone == "anonymous")) {
						if (objAddButton) {
							objAddButton.hide();
					}
				}
				else {
						if (objAddButton) {
							objAddButton.show();
					}
				}
			}
		}
	}
});

webapp.contacts.data=new webapp.contacts.data();
