dojo.require("webapp.contacts.dataBase");
dojo.provide("webapp.contacts.data");
dojo.declare("webapp.contacts.data",webapp.contacts.dataBase,{

	constructor : function(){
		var func = dojo.hitch( webapp.contacts, webapp.contacts.buttonCallback );

		this.arrWidgetsData[this.STATUS_MR_SCREEN] = {
			container: "webapp.contacts.getContactList",
			buttons: [  {
				strButtonName: this.CREATE_BTN,
				strButtonLabel: _("Add", "ICTouchAPI"),
				callback : func,
				strButtonIcon: 'app-64px-info'
			},

			{
				strButtonName: this.NEWCALL_BTN,
				strButtonLabel: _("New Call", "webapp.contacts"),
				callback : func,
				strButtonIcon: 'app-64px-info'
			},

			{
				strButtonName: this.INVITE_BTN,
				strButtonLabel: _("Invite", "webapp.contacts"),
				callback : func,
				strButtonIcon: 'app-64px-info'
			},

			{
				strButtonName: this.SEARCH_BTN,
				strButtonLabel: _("Search", "ICTouchAPI"),
				callback : func,
				strButtonIcon: 'app-64px-info'
			},
			]
		};
		this.arrWidgetsData[this.STATUS_EDITION] = {
			container: "webapp.contacts.getContactEdition",
			buttons: [{
				strButtonName: this.SAVE_CONTACT_BTN,
				strButtonLabel: _("Save Contact", "webapp.contacts"),
				callback : func,
				strButtonIcon: 'app-64px-info'
			},

			{
				strButtonName: this.ADD_ADRESS_BTN,
				strButtonLabel: _("Add Address", "webapp.contacts"),
				callback : func,
				strButtonIcon: 'app-64px-info'
			},

			]
		};
		this.arrWidgetsData[this.STATUS_HOME] = {
			container: "webapp.contacts.getContactCard",
			buttons: [
			{
				strButtonName: this.COPY_BTN,
				strButtonLabel: _("Copy", "webapp.contacts"),
				callback : func,
				strButtonIcon: 'app-64px-info'
			},

			{
				strButtonName: this.EDIT_BTN,
				strButtonLabel: _("Edit", "webapp.contacts"),
				callback : func,
				strButtonIcon: 'app-64px-info'
			},

			{
				strButtonName: this.DELETE_BTN,
				strButtonLabel: _("Delete", "ICTouchAPI"),
				callback : func,
				strButtonIcon: 'app-64px-info'
			},
			]
		};
		for (var j = 0; j < this.NB_STATUS; j++)
		{
			var appBar = ICTouchAPI.AppBarServices._getAppBarWidget("contacts","contactsstatus"+j);
			for (var k in this.arrWidgetsData[j].buttons)
			{
				var objButton = new UIElements.AppButton.AppButtonControl(this.arrWidgetsData[j]. buttons[k]);
				appBar.addActionButton(objButton);
			}
		}

		this._contactListTitle=_('ContactsShortTtl', 'webapp.contacts');
	},

	switchContainer: function(pageName, status, pageTitle) {
		this.strContainerPath = "webapp.contacts."+pageName;
		if(pageTitle)
			this._strTitle = pageTitle;
		this.updateAppBar(status);
		webapp.contacts.mainWidget.reloadContainer();
	},

	getContactTitle : function() {
		if (this.strContainerPath != "webapp.contacts.getContactList")
		{
			var strContactName = (this.objCurrentContact && this.objCurrentContact.name) ? this.objCurrentContact.name : "";
			var strContactFirstname = (this.objCurrentContact && this.objCurrentContact.firstName) ? this.objCurrentContact.firstName : "";
			return strContactName + " " + strContactFirstname;
		}
		else
		{
			return _("Contacts", "webapp.contacts");
		}

	}

});

webapp.contacts.data=new webapp.contacts.data();
