dojo.provide("webapp.contacts.controlBase");
dojo.declare("webapp.contacts.controlBase", ICTouchAPI.webApplication,
{
	arrRegisteredContainers : [],
	intIdContainer			: 0,
	overriddenParams		: null,
	currentStatus			: 0,
	deletePopUp				: null,
	displayName             : "",
	contactId               : null,
	collaborationId         : null,

	// Widgets
	mainWidget				: null,
	contactList				: null,
	contactsPK				: null,

	constructor : function() {
		ICTouchAPI.skinServices.linkWebappsStyles("UIElements.Keyboard","webapp.contacts", true, true, true);

		ICTouchAPI.tools.registerHomepageButton(["webapp.contacts.getContact", "CONTACT_BTN", "contacts-application", _('ContactsBtn','webapp.contacts'),"",function(){webapp.contacts.onContactsEnter()}]);
		ICTouchAPI.tools.registerHomepageKey(["webapp.contacts.getContact", "CONTACT_BTN", "contacts-application", _('ContactsBtn','webapp.contacts'),"",function(){webapp.contacts.onContactsEnter()}]);

		ICTouchAPI.tools.registerHomepageKey(["webapp.contacts.getContact", "CONTACTS_FAVORITES_BTN", "contacts-favorites-application", _('FavoritesBtn','webapp.contacts'),"",function(){webapp.contacts.onFavoritesEnter()}]);

		// suscribe to module IctDirectory events
		var myDS = ICTouchAPI.dataStoreServices.getStore('contacts');
		myDS.addEventListener(myDS.E_ITEM_ADDED,   this, this.OnContactReceiveDetails);
		myDS.addEventListener(myDS.E_ITEM_UPDATED, this, this.OnContactReceiveDetails);
		myDS.addEventListener(myDS.E_ITEM_REMOVED, this, this.OnContactDeleted);
		myDS.addEventListener(myDS.E_DATA_LOADED, this, this.OnContactSynchro);

		ICTouchAPI.eventServices.subscribeToEvent(this, "DIR_CONTACT_DB_FULL", this.onContactDbFull);
		ICTouchAPI.eventServices.subscribeToEvent(this, "IM_EVENT_GET_COLLABID_RESULT", this.handleGetCollaborationId);

		//link css to userinfo for the presence icons
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.userinfo","webapp.contacts");

		this.intIdContainer = 0;
		ICTouchAPI.settingServices.subscribeToSetting(this, "EnableContactsPreview", this._registerHomePageContainer);
		this.loadEnablePreview();

		dojo.subscribe("e_contact_showContact", this, this.showContact);
		dojo.subscribe("e_contact_editContact", this, this.editContact);

		dojo.subscribe("iframe.show", this, this.onShow);
		dojo.subscribe("iframe.hide", this, this.onHide);
	},

	loaded : function(){
		ICTouchAPI.settingServices.subscribeToSetting(this, "EnableContactsPictureInMenu", this.onEnableContactsPictureInMenu);
		ICTouchAPI.settingServices.getSetting("EnableContactsPictureInMenu", this, this.onEnableContactsPictureInMenu);
		
		ICTouchAPI.settingServices.subscribeToSetting(this, "IMAvailable", this.onIMAvailableChanged);
		ICTouchAPI.settingServices.getSetting("IMAvailable", this, this.onIMAvailableChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "TelephonyPresenceAvailable", this.onTelephonyPresenceAvailableChanged);
		ICTouchAPI.settingServices.getSetting("TelephonyPresenceAvailable", this, this.onTelephonyPresenceAvailableChanged);
		dojo.subscribe("InBuddyList",this,this.inBuddyList);
		ICTouchAPI.settingServices.getSetting("EnableAddContactButton",this, this.onEnabledAdd);

	},

    onShow : function(strCurrentFrameId) {
        if (strCurrentFrameId === "webapp.contacts.getContact" && this.data.getContainerPath() !== "webapp.contacts.getContactEdition") {
			ICTouchAPI.debugServices.debug("webapp.contacts.controlBase - onShow / strCurrentFrameId is getContact and the container path is not getContactEdition: call loadDetails");
            this.data.loadDetails(this.data.intDisplayedContactId);
        }
    },

	onEnabledAdd : function(objSetting){
		if(objSetting && objSetting.jsValue === false){
			webapp.contacts.data.onHotelMode(true);
		}
		else if(! objSetting || objSetting.jsValue === true){
			webapp.contacts.data.onHotelMode(false);
        }
    }, 

	onHide : function(strCurrentFrameId){
		if(strCurrentFrameId == "webapp.contacts.getContact"){
			this.data._removePreviousRemoteContact(true);
		}
	},

	onFavoritesEnter : function(intIndex){
		if(intIndex !== undefined){
			this.data.setIntSelectFavoriteId(intIndex);
		}

		ICTouchAPI.transitionServices.getScreen({
			name: "webapp.contacts.getContact",
			params: {},
			sync: false
		});

		if(this.contactList){
			// Select the title + execute callback
			this.contactList.selectTitleById(this.data.menuIds.FAVORITE);
			if(intIndex){
				this.data.objFavoriteList.selectItemByIndex(intIndex, true)
			}
		} else {
			this.data.setTabToLoad(this.data.menuIds.FAVORITE);
		}
	},

	onContactsEnter : function() {
		ICTouchAPI.transitionServices.getScreen({
			name: "webapp.contacts.getContact",
			params: {},
			sync: false 
		});
		if(this.contactList){
			// Select the title + execute callback
			this.contactList.selectTitleById(this.data.menuIds.CONTACT);
		}
	},

	inBuddyList : function(boolIsInBuddyList){
		webapp.contacts.data.boolIsInBuddyList=boolIsInBuddyList;
	},

	//ENABLE PREVIEW
	loadEnablePreview:function(){
		ICTouchAPI.settingServices.getSetting("EnableContactsPreview", this, this._registerHomePageContainer);
	},

	_registerHomePageContainer : function(objSetting){
		if (objSetting){
			if(objSetting.jsValue == true){
				ICTouchAPI.tools.registerHomepageContainer(["webapp.contacts.getContactPreview", this]);
			}else{
				ICTouchAPI.tools.unregisterHomepageContainer(["webapp.contacts.getContactPreview"]);
			}
		}

	},
	//END OF ENABLE PREVIEW

	onEnableContactsPictureInMenu : function(objSetting){
		if(objSetting){
			this.data.boolPictureInMenu = objSetting.jsValue;
		}
	},

	onTelephonyPresenceAvailableChanged : function(objSetting) {
		if(objSetting){
			this.data.boolTelephonyPresenceAvailable = objSetting.jsValue;
		}
	},

	onIMAvailableChanged : function(objSetting) {
		if(objSetting){
			this.data.boolIMPresenceAvailable = objSetting.jsValue;
		}
	},

	//adds an external capability, for other webapps to be able to add buttons to the webapp Contact
	addButton : function(button) {
		var objButton = new UIElements.AppButton.AppButtonControl(button);

		ICTouchAPI.AppBarServices.addOtherWebAppButton("contacts","contactsstatus"+this.data.STATUS_HOME, objButton);

		return objButton;
	},

	load: function() {
		//help
		var widgetsTab = [];
		for(var i=0; i<this.data.NB_STATUS; i++) {
			widgetsTab.push("contactsstatus"+i);
		}
		dojo.publish("needHelpEvent",["contacts",widgetsTab]);

		if(webapp.communication) {
			this.data.arrComSelectStatus[-1] = {label: "Call", icon: "communication-call"};
			this.data.arrComSelectStatus[webapp.communication.data.STATUS_ADD_PARTICIPANT] = {label: "Add", icon: "communication-conference-add-participant"};
			this.data.arrComSelectStatus[webapp.communication.data.STATUS_TRANSFER_TO] = {label: "Transfer to", icon: "communication-deflect-to-default"};
			this.data.arrComSelectStatus[webapp.communication.data.STATUS_DEFLECT_TO] = {label: "Default deflect", icon: "communication-transfer-to"};
			this.data.arrComSelectStatus[webapp.communication.data.STATUS_PROGKEYS_CALL] = {label: _("Add shortcut", "webapp.communication"), icon: "progkeys-add"};
			this.data.arrComSelectStatus[webapp.communication.data.STATUS_PROGKEYS_ROUTING] = {label: _("Add shortcut", "webapp.communication"), icon: "progkeys-add"};
			this.data.arrComSelectStatus[webapp.communication.data.STATUS_MDR_ROUTING] = {label: "Ok", icon: "generic-ok"};
			this.data.arrComSelectStatus[webapp.communication.data.STATUS_MDR_OVERFLOW] = {label: "Ok", icon: "generic-ok"};
			this.data.arrComSelectStatus[webapp.communication.data.STATUS_MDR_USER] = {label: "Ok", icon: "generic-ok"};
			this.data.arrComSelectStatus[webapp.communication.data.STATUS_BASIC_ADD_ROUTING] = {label: "Ok", icon: "generic-ok"};
			this.data.arrComSelectStatus[webapp.communication.data.STATUS_BASIC_IMMEDIATE_ROUTING] = {label: "Ok", icon: "generic-ok"};
			dojo.subscribe("CommunicationSelectStatusChange", this, this.onComSelectStatusChange);
		}
	},

	setHomepageContainer : function (strWebapp, div) {
		this.previewContainer = new this.getContactPreview({ }, div);
		// load the preview contact
		this.data.loadPreviewList();
	},

	buttonCallback : function(buttonId) {
		//var data = webapp.contacts.data;
		switch(buttonId)
		{
			case this.data.BACK:
				switch(this.data.strContainerPath)
				{
					case "webapp.contacts.getContactEdition" :
                        this.onSaveContact();
						break;
					default :
						if (this.overriddenParams && this.overriddenParams.clbkBack) {
							this.overriddenParams.clbkBack();
							delete this.overriddenParams.clbkBack;
						} else {
							dojo.publish("OpenHomepage");
						}
						break;
				}
				break;
			case this.data.INPREVIEW_BTN:
				this.manageInPreview();
				break;
			case this.data.CREATE_BTN:
				this.data.objLastViewedContact = dojo.clone(this.data.objCurrentContact);
				this.data.objCurrentContact = this.data.createEmptyContact();
				this.data.deselectSafe();
				this.data.switchContainer("getContactEdition", this.data.STATUS_EDITION, _("Add new contact", "webapp.contacts"));
				break;
			case this.data.EDIT_BTN:
				this._editCurrentContact();
				break;
			case this.data.DELETE_BTN:
				this.loadDeletePopup();
				break;
			case this.data.COPY_BTN:
				this.onCopyContact();
				break;
			/*case this.data.SAVE_CONTACT_BTN :
				console.log(this.data.objCurrentContact);
				this.onSaveContact(this.data.objCurrentContact);
				break;*/
			case this.data.CALL_BTN:
				var number = ICTouchAPI.tools.getContactPhone(this.data.objCurrentContact);
				if(number && webapp.communication) {
					//webapp.communication.mainWidget.emptyContactCard();
					webapp.communication.doContextStatusCall(number, true, this.data.objCurrentContact);
					if(this.currentStatus == this.data.STATUS_MDR_ROUTING || this.currentStatus == this.data.STATUS_MDR_OVERFLOW || this.currentStatus == this.data.STATUS_MDR_USER){
						if(this.mainWidget) {
							this.updateAppBar(this.data.STATUS_HOME);
							this.mainWidget.reloadContainer();
						}
						ICTouchAPI.transitionServices.back();
					}else{
						ICTouchAPI.transitionServices.getScreen({name: "webapp.communication.getCommunication",params: {}});
					}
				}
				break;
			case this.data.SEARCH_BTN:
				var objSearch = {
					contactDataTypes: [],
					secondaryInformation : "phoneNumber", // information of the contact to be displayed at the right of the contact's display name in the search results
					// define a right icon for the search results, for which the callback is to display the contact card
					rightIconClickCallback: {
						neededData : "Contact",
						rightIconImage  : "contacts-card-32",
						rightIconImageRemoteContact : "contacts-contact-card-remote-32",
						context:webapp.contacts,
						func:webapp.contacts.onContactFound
					}
					//boolForceByname : true
				};
				if (webapp.communication) {
					// define the action for the search results (click on the line of on the left icon), for which the callback is to call the contact
					objSearch.lineClickCallback = {
						neededData : "phoneNumber",
						leftIconImage  : "communication-call-32",
						leftIconImageConditionnalDisplay  : "phoneNumber",
						context:webapp.communication,
						func: function (strNumber) {
							webapp.communication.apiCall(strNumber, true);
						}
					}
				}
				else {
					// define the action for the search results (click on the line of on the left icon), no communication available -> display the contact card
					objSearch.lineClickCallback = {
						neededData : "Contact",
						context:webapp.contacts,
						func:webapp.contacts.onContactFound
					}
				}

				if (webapp.search) {
					webapp.search.doSearch(objSearch, function() {
						ICTouchAPI.transitionServices.getScreen({
							name: "webapp.contacts.getContact",
							params: {}
						});
					});
				}
				break;
			default :
				ICTouchAPI.debugServices.warning("webapp.contacts.controlBase - buttonCallback / No callback is associated with this button! (id: buttonId = " + buttonId + ")");
				break;
		}
	},

	//callback of the event IM_GET_COLLABID_RESULT
	handleGetCollaborationId: function() {
		var arrArguments=ICTouchAPI.tools.getEventArguments(arguments);
		var collId=arrArguments["collaborationId"];
		var loginName=arrArguments["login"];
		//if we have a good collaborationID then assign it to the contact and show the add button
		if (collId) {
			//if we have the right collId , then assign it to the contact
			if (this.data.objCurrentContact.loginName == loginName) {
				this.data.objCurrentContact.collaborationId = collId;
				if(this.mainWidget){
					this.mainWidget.reloadContainer();
				}
			}
			}
	},

	onContactFound : function(objContact)
	{
		this.showContact({
			objContact: objContact,
			clbkBack: function() {
				ICTouchAPI.transitionServices.getScreen({
					name: "webapp.search.getSearch",
					params: {}
				});
			}
		});
	},

	onContactDbFull : function() {
		this.data.objCurrentContact = null;
		this.mainWidget.reloadMenu();
	},

	onCreateContact : function(status){
		if (status != 0) {
			if(this.data._boolChangeScreen===true) {
				this.data._boolChangeScreen = false;
				dojo.publish("unlockTransition",[false]);
			}
			this.checkError(status);
		}
		else {
			if(this.data._boolChangeScreen===true) {
				this.data._boolChangeScreen = false;
				dojo.publish("unlockTransition",[true]);
			}
		}
	},

	onModifyContact : function(status){
		if (status != 0) {
			if(this.data._boolChangeScreen===true) {
				this.data._boolChangeScreen = false;
				dojo.publish("unlockTransition",[false]);
			}
			this.checkError(status);
		}
		else {
			if(this.data._boolChangeScreen===true) {
				this.data._boolChangeScreen = false;
				dojo.publish("unlockTransition",[true]);
			}
		}
	},

	onCancelSaveContact : function(){
		if(this.data._boolChangeScreen===true) {
			this.data._boolChangeScreen = false;
			dojo.publish("unlockTransition",[true]);
		}
	},

	selectSafeAfterCancelSaveContact : function(){
		// if a contact was previously selected when creation is canceled, refresh it in 2/3
		if (this.data.objLastViewedContact && this.data.objLastViewedContact.contactId) {
			this.data.selectSafeByIndex(this.data.objLastViewedContact.contactId, false);
			this.data.loadDetails(this.data.objLastViewedContact.contactId);
		}
		// if no contact was previously selected, select the first one
		else {
			// reset objCurrentContact (for the case there is no contacts)
			this.data.objCurrentContact = undefined;
			this.data.objCurrentEditedContact = undefined;
			if (this.data.objContactList && this.data.objContactList.arrItems[0] && this.data.objContactList.arrItems[0].objContact.contactId) {
				this.data.selectContactByPosition(0,false);
				this.data.loadDetails(this.data.objContactList.arrItems[0].objContact.contactId);
			}
			else {
				this.data.loadDetails(undefined);
			}
		}
		this.data.switchContainer("getContactCard", this.data.STATUS_HOME);
	},

	onDeleteContact : function(status){
		if (status != 0) {
			this.checkError(status);
		}
	},

	onContactPreviewCreated :function(idContact) {
		this.data.updateContactInPreview(idContact.value, true);
	//webapp.contacts.data.intSelectContactId = idContact.value;
	//this.data.loadContactList();
	},

	onContactPreviewDeleted :function(idContact) {
		this.data.updateContactInPreview(idContact.value, false);
	},

	/**
	 * When click on copy button
	 */
	onCopyContact : function ()	{
		this.data.objCurrentContact.isRemote = false; // contact will now be not remote
		this.data.objCurrentContact.isPrivate = 1; // contact will now be private
		this.data.objCurrentContact.isPreviewed = 0; // contact will be added as not previewed
		this.data.objCurrentContact.type = ICTouchAPI.tools.enumContactType.LOCAL; // contact type will now be local
		ICTouchAPI.APIServices.IctDirectory.createLocalContact({
			params:["createContactReqId", this.data.objCurrentContact],
			context:this,
			callback: this.onCreateContact
		});
		// Remove the remote contact
		this.data._removePreviousRemoteContactById(this.data.objCurrentContact.contactId);
		this.data.switchContainer("getContactCard",this.data.current_status);
	},

	/**
	 * When saving contact
	 * return:
	 *  1 if the contact has been modified and saved
	 *  0 if the contact has not been modified and saving was canceled
	 *  -1 if the contact saving has failed
	 */
	onSaveContact : function (boolNoRefresh)	{
		// before saving, check is the contact was edited
		// use compareObjects to check if the contact is empty before trying to save it
		if (ICTouchAPI.tools.compareObjects(this.data.objCurrentEditedContact, this.data.createEmptyContact()) ||
			ICTouchAPI.tools.compareObjects(this.data.objCurrentEditedContact, this.data.objLastViewedContact)) {
			if (!boolNoRefresh) {
			// if a contact was previously selected when creation is canceled, refresh it in 2/3
			this.selectSafeAfterCancelSaveContact();
				}
			// unlock the screen to allow switching to another webapp
			this.onCancelSaveContact();
			return 0; // return 0:
		}
		// The contact is modified, save the changes
		else {
			// check if the name of the contact has been filled before trying to save it
			if (!this.data.objCurrentEditedContact.name || this.data.objCurrentEditedContact.name.trim().length < 1) {
				this.checkError(10);
				if(this.data._boolChangeScreen===true) {
					this.data._boolChangeScreen = false;
					dojo.publish("unlockTransition",[false]);
				}
				return -1;
			}
			//Check if entered emails are valid
			var expMailValid=new RegExp("^[A-Z0-9._%-]+@[A-Z0-9.-]+\\.[A-Z]+$","i");
			if((this.data.objCurrentEditedContact.email && !expMailValid.test(this.data.objCurrentEditedContact.email)) || 
				(this.data.objCurrentEditedContact.personalEmail && !expMailValid.test(this.data.objCurrentEditedContact.personalEmail))) {				
				this.checkError(11);
				if(this.data._boolChangeScreen===true) {					
					this.data._boolChangeScreen = false;
					dojo.publish("unlockTransition",[false]);
				}
				return -1;
			}

			// Création du Spinner
			this.createSaveSpinner();

			// if not a new contact, modify else create
			if (this.data.objCurrentEditedContact.contactId != -1) {
				ICTouchAPI.APIServices.IctDirectory.modifyLocalContact({
					params:["modifyContactReqId", this.data.objCurrentEditedContact],
					context:this,
					callback:this.onModifyContact
				});
				//modify also th LastViewedContact
				this.data.objLastViewedContact = dojo.clone(this.data.objCurrentEditedContact);
			}
			else {
				this.data.objCurrentEditedContact.isPrivate = 1; // created contact is private (added in local directory)
				this.data.objCurrentEditedContact.isPreviewed = (this.data.getDisplayedMenu() == this.data.menuIds.FAVORITE ? 1 : 0 ); // contact is added as not previewed
				this.data.objCurrentEditedContact.type = ICTouchAPI.tools.enumContactType.LOCAL; // contact type is local
				// crms00287809 V.Vyskocil
				if(!this.data.objCurrentEditedContact.firstName) {
					this.data.objCurrentEditedContact.firstName='';
				}
				// crms00287809 end
				ICTouchAPI.APIServices.IctDirectory.createLocalContact({
					params:["createContactReqId", this.data.objCurrentEditedContact],
					context:this,
					callback: this.onCreateContact
				});
			}
			this.data.objCurrentContact = this.data.objCurrentEditedContact;
			this.data.objCurrentEditedContact = null;
			// return to the ContactCard in all case
			//this.data.switchContainer("getContactCard", this.data.current_status);
			this.data.strContainerPath = 'webapp.contacts.getContactCard';
			if (!boolNoRefresh) {
				webapp.contacts.data.loadDetails(webapp.contacts.data.objCurrentContact.contactId);
			}
			return 1;
		}
	},

    createSaveSpinner : function() {
		this.destroySaveSpinner();
		this._objSpinner = new UIElements.Spinner.SpinnerControl({strMessage : _('Save in progress...', "webapp.contacts"), boolForeground:true}, document.body);
		this._spinnerHandler = setTimeout(dojo.hitch(this, this.destroySaveSpinner), 1000);
	},

	destroySaveSpinner : function() {
		if(this._objSpinner){
			this._objSpinner.destroy();
			this._objSpinner = null;
		}
		if(this._spinnerHandler){
			clearTimeout(this._spinnerHandler);
			this._spinnerHandler = null;
		}
	},

	createFavoriteSpinner : function() {
		this.destroyFavoriteSpinner();
		this._objFavoriteSpinner = new UIElements.Spinner.SpinnerControl({strMessage : _("Please wait...", "ICTouchAPI"), boolForeground:true}, document.body);
		this._favoriteSpinnerHandler = setTimeout(dojo.hitch(this, this.spinnerTimeout), 8000);
	},
	
	spinnerTimeout : function() {
		// Deactivate the spinner
		this.destroyFavoriteSpinner();
		
		// Reload the button
		if (this._newPreviewContactId == this.data.objCurrentContact.contactId && this.data.objInPreviewBtnUI) {
			this.data.objCurrentContact.isPreviewed = !this.data.objCurrentContact.isPreviewed;
			(this.data.objCurrentContact.isPreviewed) ? this.data.objInPreviewBtnUI.setStatusIcon("notif-on") : this.data.objInPreviewBtnUI.setStatusIcon("notif-off");
		}
	},

	destroyFavoriteSpinner : function() {
		if(!this._destroyFavoriteSpinnerHandler){
			this._destroyFavoriteSpinnerHandler = setTimeout(dojo.hitch(this, this._destroyFavoriteSpinner), 1500);
		}
	},
	
	_destroyFavoriteSpinner : function() {
		if(this._objFavoriteSpinner){
			this._objFavoriteSpinner.destroy();
			this._objFavoriteSpinner = null;
		}
		if(this._favoriteSpinnerHandler){
			clearTimeout(this._favoriteSpinnerHandler);
			this._favoriteSpinnerHandler = null;
		}
		
		this._destroyFavoriteSpinnerHandler = null;
		
		// Also clear the stored contactId
		this._newPreviewContactId = null;
	},

	registerContainer : function(webappName) {
		var id = this.intIdContainer++;
		this.arrRegisteredContainers[id] = webappName;
		return id;
	},

	//manage the button InPreview
	manageInPreview : function() {
		// Activate spinner
		this.createFavoriteSpinner();
		
		// Save the current contact id
		this._newPreviewContactId = this.data.objCurrentContact.contactId;
		
		// Manually update the Favorite button status
		if (this.data.objInPreviewBtnUI) {
			(this.data.objCurrentContact.isPreviewed) ? this.data.objInPreviewBtnUI.setStatusIcon("notif-off") : this.data.objInPreviewBtnUI.setStatusIcon("notif-on");
		}
		
		if (this.data.objCurrentContact.isPreviewed)
		{
			ICTouchAPI.APIServices.IctDirectory.removeContactFromPreview({
				params: ["AddContactInPreviewReqID", this.data.objCurrentContact.contactId],
				context: this,
				callback: function(status) {
					if (status != 0) this.checkError(status);
				}
			});
		}
		else
		{
			ICTouchAPI.APIServices.IctDirectory.addContactToPreview({
				params: ["AddContactInPreviewReqID", this.data.objCurrentContact.contactId],
				context: this,
				callback: function(status) {
					if (status != 0) this.checkError(status);
				}
			});			
		}
		this.data.objCurrentContact.isPreviewed = !this.data.objCurrentContact.isPreviewed;
	},

	onPresentationListClick : function(objEntry) {
		// If callback is overriden, call it (example: search by name callback)
		if(objEntry.strId=="collaborationId"&&webapp.instantmessaging){
			if(webapp.contacts.data.boolIsInBuddyList){
			    webapp.instantmessaging.prepareToSendIm(this.data.objCurrentContact);
		    }
		}
		if (this.overriddenParams && this.overriddenParams.clbkContactCardClick) {
			this.overriddenParams.clbkContactCardClick(objEntry);
		}
		else {
			dojo.publish("ContactDataClicked" + objEntry.strType, [objEntry, this.data.objCurrentContact]);
		}
	},

	//Callback for the click on a contact in the Contact List
	onContactListClick : function(contactId) {
		ICTouchAPI.debugServices.debug("webapp.contacts.controlBase - onContactListClick $ input function params | contactId: " + contactId);
		var path = this.data.getContainerPath();
		if(path == "webapp.contacts.getContactEdition" && this.data.objCurrentEditedContact) {
			// When leaving the getContactEdition, save the modifications done on the contact
			// (and ask to not refresh, the selected contact in 1/3 will be selected instead)
			ICTouchAPI.debugServices.debug("webapp.contacts.controlBase - onContactListClick / current mode is contact edition, call onSaveContact");
			if (this.onSaveContact(true) == -1) {
				ICTouchAPI.debugServices.debug("webapp.contacts.controlBase - onContactListClick / onSaveContact failed, reselect previous selected entry");
				// saving failed, reselect previous 1/3 entry and return
				if (this.data.objCurrentEditedContact.contactId == -1) { // creating a new contact, unselect 1/3
					this.data.deselectSafe();
				}
				else {
					this.data.selectSafeByIndex(this.data.objCurrentEditedContact.contactId, false);
				}
			}
			else {
				ICTouchAPI.debugServices.debug("webapp.contacts.controlBase - onContactListClick / onSaveContact succeeded, call loadDetails");
				this.data.loadDetails(contactId);
				this.data.switchContainer("getContactCard", this.data.STATUS_HOME);
			}
		}
		else{
			ICTouchAPI.debugServices.debug("webapp.contacts.controlBase - onContactListClick / current mode is not contact edition, call loadDetails");
		this.data.loadDetails(contactId);
		}
	},

	loadDeletePopup : function() {
		var context = this;
		var popupData = {
			strTitle: _("Delete contact ?", 'webapp.contacts'),
			strContent : _("Do you want to delete this contact ?", 'webapp.contacts'),
			strType: "warning",
			arrPopupButtons: [{
				strButtonName: "YES_BTN",
				strButtonIcon: "generic-ok",
				strButtonLabel:  _("Yes", 'ICTouchAPI'),
				callback: function() {
					context.yesDeleteCallback();
				}
			},

			{
				strButtonName: "NO_BTN",
				strButtonIcon: "generic-cancel",
				strButtonLabel:  _("No", 'ICTouchAPI'),
				callback: function() {
					context.noDeleteCallback();
				}
			}]
		};
		this.deletePopUp = ICTouchAPI.popupServices.addNewPopup(popupData, "MEDIUM");
	},

	yesDeleteCallback: function() {
		ICTouchAPI.popupServices.removePopup(this.deletePopUp);
		// no callback wait event
		ICTouchAPI.APIServices.IctDirectory.deleteLocalContact({
			params:["deleteContactReqId", this.data.objCurrentContact.contactId],
			context:this,
			callback:this.onDeleteContact
		});
	},

	noDeleteCallback: function() {
		ICTouchAPI.popupServices.removePopup(this.deletePopUp);
	},

	/**
	 * CONTACT_CREATED or CONTACT_UPDATE Event callback
	 */
	onContactCreatedOrUpdated: function(contactId) {
		ICTouchAPI.debugServices.debug("webapp.contacts.controlBase - onContactCreatedOrUpdated / On Contact created");
		this.data.intSelectContactId = contactId.value;

		ICTouchAPI.APIServices.IctDirectory.getContactById({
			params:[contactId.value],
			context:this,
			callback:this.OnContactReceiveDetails
		});

	//this.data.loadContactList();
	},

	OnContactReceiveDetails: function(objContactDetails, objContactChanges) {
		ICTouchAPI.debugServices.debug("webapp.contacts.controlBase - OnContactReceiveDetails / objContactDetails: " + dojo.toJson(objContactDetails));
		if(objContactDetails.type !== ICTouchAPI.tools.enumContactType.CACHED){
			var onlyPresenceChanged = false;
			if(objContactChanges){
				onlyPresenceChanged = true;
				for(var i in objContactChanges){
					if(i != "telephonyPresence" && i != "IMPresence"){
						onlyPresenceChanged = false;
						break;
					}
				}
			}
			if(onlyPresenceChanged){
				this.data.updatePresenceInList(objContactDetails, objContactChanges);
			} else {
				this.data.updateContactInList(objContactDetails);
			}
			if(objContactDetails.contactId == this._newPreviewContactId){
				this.destroyFavoriteSpinner();
			}
		}
	},

	/**
	 * CONTACT_DELETED Event callback
	 */
	OnContactDeleted: function(contactId) {
		// Delete it only if we find it.
		if(this.data.objContactList && this.data.objContactList.findItem("intIndex",contactId)){
			this.data.deleteContactInList(contactId);
		}
	},

	/**
	 * CONTACT_Synchro Event callback
	 */
	OnContactSynchro: function(contacts) {
		this.data.synchronizeContact(contacts);
		contacts=null;
	},

	//general function to handle error Popups
	checkError : function(status) {
		var strMessage = "";
		switch (status) {
			case 1:
				strMessage = _("The contact is not local", "webapp.contacts");
				break;
			case 2:
				strMessage = _("Contact not found", "webapp.contacts");
				break;
			case 3:
				strMessage = _("Maximum number of contact reached", "webapp.contacts");
				break;
			case 4:
				strMessage = _("Contact is already in preview", "webapp.contacts");
				break;
			case 5:
				strMessage = _("Contact was not in preview", "webapp.contacts");
				break;
			case 6:
				strMessage = _("Synchronization process on going: contacts are read-only", "webapp.contacts");
				break;
			case 7:
				strMessage = _("IM address already used by another contact", "webapp.contacts");
				break;
			case 10:
				strMessage = _("You must provide at least a last name", "webapp.contacts");
				break;
			case 11:
				strMessage = _("Invalid email address", "webapp.contacts");
				break;
			case -1:
				strMessage = _("An error occured", "webapp.contacts");
				break;
			default:
				strMessage = _("Unknown error message", "webapp.contacts");
				break;
		}
		if (strMessage != "") {
			ICTouchAPI.popupServices.errorPopup(_("Error", "ICTouchAPI"), strMessage, _("OK", "ICTouchAPI"), status)
			return true;
		}
		return false;
	},

	/**
	 * onProgKeyConfig
	 * for Add/Edit progkey Arguments Testing.
	 */
	onProgKeyConfig : function(objAction){
		this._onProgKeyConfig(objAction);
		return null;
	},

	_onProgKeyConfig : function (objAction) {
		if(objAction.action == "display-card") {

			var oldList = this.data.objContactList;
			if(this.data.objContactPKList){
				this.data.objContactPKList.deselect();
			}
			if(objAction.arguments){
				this.data.pkContactID = objAction.arguments;
				if(this.data.objContactPKList){
					this.data.objContactPKList.selectItemByIndex(this.data.pkContactID, true);
				}
			}
			ICTouchAPI.transitionServices.getScreen({
				name: "webapp.contacts.getContactProgKey",
				params: {}
			});

			this.data.objContactList = oldList;
				}
	},

	_progKeySetArgs : function(contactId) {
		if (contactId && contactId!=null) {
			// We notify progkeys that he doesn't have to reset the display and variables this time
			webapp.progkeys.setProgkeysArgumentsNextStep(contactId);
			webapp.contacts.data.pkContactID = null;
		}
	},
	
	/**
	 * onProgKeyAction
	 * @return : list of Template of actions
	 */
	/*onProgKeyAction : function() {
		var listActions = [];
		listActions.push({
			webAppName : "contacts",
			action : "display-card",
			type : 1,
			icon : "contacts-card",
			label : "Display contact card"
		});
		return listActions;
	},*/

	onProgKeyClick : function(objAction) {
		if(objAction.action == "display-card") {
			this.showContact({
				intId:objAction.arguments
			});
		}
	},

	onProgKeyDisplay :  function(objAction, progkey) {
		if(objAction.action == "display-card") {
			var myDS = ICTouchAPI.dataStoreServices.getStore('contacts');
			var objContact = myDS.getAt(objAction.arguments)
			progkey.image = ( objContact.photo) ?  objContact.photo : ICTouchAPI.tools.getDefaultPhotoPath("user", "50");
		}
	},

	_editCurrentContact : function() {
		//var data = webapp.contacts.data;
		this.data.objLastViewedContact = dojo.clone(this.data.objCurrentContact);
		this.data.setContactId(this.data.objCurrentContact.contactId);
		this.data.switchContainer("getContactEdition", this.data.STATUS_EDITION, _("Edit contact", "webapp.contacts"));
	},

	/*********************************************************************
	 * Public methods
	 *********************************************************************/
	/**
	 * showContact method can be called to display the contact card of a given contact.
	 * @param {Object} args is an object that can contain the following values:
	 *   - intId: if provided, the contact card of the given contact id will be loaded. Only local contacts can be loaded in this way.
	 *   - objContact: if the whole contact object is given, it will be directly displayed as is.
	 *   - clbkContactCardClick: callback to override behavior when the user clicks on an entry of the contact card (like phone number)
	 *   - clbkBack: callback to override behavior when the user clicks on the "BACK" button.
	 */
	showContact: function(args) {
		this.overriddenParams = args;
		ICTouchAPI.transitionServices.getScreen({
			name: "webapp.contacts.getContact",
			params: {},
			sync : true
		});
		if(args.needStealth && args.needStealth == true){
			ICTouchAPI.transitionServices.stealth("webapp.contacts.getContact");
		}

		if(this.contactList){
			// Select the title + execute callback
			this.contactList.selectTitleById(this.data.menuIds.CONTACT);
		}

		if (args.intId != undefined && args.intId != null) {
			this.data.intSelectContactId = args.intId;
			this.data.objContactList.selectItemByIndex(this.data.intSelectContactId, true);
		}
		else if (args.objContact && args.objContact.contactId) {
			// Check if the contact is local (in the directory -> LOCAL = 0, DM = 3, MA = 5),
			// or if it is remote, (UDA = 1, BUDDY = 2, ICS = 4)
			// if type of contact is not local or DM, it is a remote contact (UDA,...), add it to the list and display it with the alternate style
			if (args.objContact.type != ICTouchAPI.tools.enumContactType.LOCAL && args.objContact.type != ICTouchAPI.tools.enumContactType.DM && args.objContact.type != ICTouchAPI.tools.enumContactType.MA) {
				args.objContact.isRemote = true;	// add "remote" flag
				args.objContact.isPreviewed = 0;    // don't display the remote contact in preview

				//remove last remote contact from the contact list so that only one remote contact is displayed after a new search
				//(this remove the remote contact added to the list from a previous search)
				this.data._removePreviousRemoteContact();

				this.data._pushContactInList(args.objContact, false, true);
			}
			// Update the current selected contactId
			this.data.intSelectContactId = args.objContact.contactId;
			this.data.objContactList.selectItemByIndex(this.data.intSelectContactId, true);

		}
	},

	/**
	 * editContact method can be called to display the contact card edition interface.
	 * @param {Object} args is an object that can contain the following values:
	 *   - intId: if provided, the corresponding contact will be edited. Else it's going to be created.
	 *   - objContact: can be used to pre-fill / override values.
	 *   - clbkBack: callback to override behavior when the user clicks on the "BACK" button.
	 */
	editContact: function(args) {
		ICTouchAPI.debugServices.debug("webapp.contacts.controlBase - editContact $ input function params | args: " + dojo.toJson(args));
		//var data = webapp.contacts.data;
		this.overriddenParams = args;
		if (args.intId !== undefined && args.intId !== null) {
			// Try fo find the contact in list (= udpate)
			var myDS = ICTouchAPI.dataStoreServices.getStore('contacts');
			var contact = myDS.getAt(args.intId);
			if(contact) {
				this.data.intSelectContactId = args.intId;
				// If the objContactList menu list exists, scroll to this item (else it will be done
				// at the creation of the menu list)
				ICTouchAPI.transitionServices.getScreen({
					name: "webapp.contacts.getContact",
					params: {},
					sync : true
				});

				if(this.contactList){
					// Select the title + execute callback
					this.contactList.selectTitleById(this.data.menuIds.CONTACT);
				}
				if (this.data.objContactList) {
					this.data.objContactList.selectItemByIndex(this.data.intSelectContactId, false);
				}
				this.data.objCurrentContact = contact;
				this._editCurrentContact();
				return;
			}
		}
		// Else, create contact
		ICTouchAPI.transitionServices.getScreen({
			name: "webapp.contacts.getContact",
			params: {},
			sync : true
		});

		if(this.contactList){
			// Select the title + execute callback
			this.contactList.selectTitleById(this.data.menuIds.CONTACT);
		}
		this.data.objLastViewedContact = dojo.clone(this.data.objCurrentContact);
		this.data.objCurrentContact = dojo.clone(args.objContact);
		this.data.setContactId(-1);
		//deselect of menulist item
		if(webapp.contacts.data.objContactList != null){
			webapp.contacts.data.objContactList.deselect();
		}
		//if this is a dummy contact, erase the name
			/*if (this.data.objCurrentContact.contactId == -1) {
			this.data.objCurrentContact.name = "";
			}*/
		this.data.switchContainer("getContactEdition", this.data.STATUS_EDITION, _("Add new contact", "webapp.contacts"));
	},

	unlock : function(WebappName) {
		var path = this.data.getContainerPath();
		if(path == "webapp.contacts.getContactEdition") {
			if (webapp.screensaver) {
				var currentScreenSaver = webapp.screensaver.data.getCurrentScreensaverScreen();
			}
			if(WebappName == currentScreenSaver){
				dojo.publish("unlockTransition",[true]);
			}
			else if (WebappName == "webapp.lock.getLock" || WebappName == "webapp.userservices.getUserService" ||
				WebappName == "webapp.homepage.getHomepage" || WebappName == "webapp.communication.getCommunication"){
				//dojo.publish("unlockTransition",[true]);
			this.data._boolChangeScreen = true;
				// When leaving the getContactEdition, save the modifications done on the contact
				if(ICTouchAPI.keyboardServices.isKeyboardDisplayed()){
					ICTouchAPI.keyboardServices.closeKeyboard(ICTouchAPI.keyboardServices.CLOSE_ACTION_NONE);
				}
				if(ICTouchAPI.tools.compareObjects(this.data.objCurrentEditedContact, this.data.createEmptyContact()) ||
					ICTouchAPI.tools.compareObjects(this.data.objCurrentEditedContact, this.data.objLastViewedContact)){
					this.onCancelSaveContact();
					this.selectSafeAfterCancelSaveContact();
				}
				else if (this.data.objCurrentEditedContact && this.data.objCurrentEditedContact.name) {
					this.onSaveContact();
				}
				else {
					this.onCancelSaveContact();
					this.selectSafeAfterCancelSaveContact();
				}
			}
			else{
				this.data._boolChangeScreen = true;
				// When leaving the getContactEdition, save the modifications done on the contact
				if(ICTouchAPI.keyboardServices.isKeyboardDisplayed()){
					ICTouchAPI.keyboardServices.closeKeyboard(ICTouchAPI.keyboardServices.CLOSE_ACTION_OK);
				}
				this.onSaveContact();
			}
		}else{
			dojo.publish("unlockTransition",[true]);
		}
	},

	onComSelectStatusChange : function(params) {
		var selectStatus = params.selectStatus;
		this.data.intComSelectStatus = selectStatus;
	    if(webapp.communication && webapp.communication.isSelectStatusProgkey()) {
			this.data.current_status = this.data.STATUS_PROGKEY_ADD;
		}else if(webapp.communication && webapp.communication.isSelectStatusMDR()){
			ICTouchAPI.debugServices.error("STATUS MDR");
			this.data.current_status = this.data.STATUS_MDR_ROUTING;
		}else{
			this.data.current_status = this.data.STATUS_HOME;
	    }
		if(this.data.arrComSelectStatus[selectStatus] != null) {
			var icon = this.data.arrComSelectStatus[selectStatus].icon;
			var label = this.data.arrComSelectStatus[selectStatus].label;
		    var appBar = ICTouchAPI.AppBarServices._getAppBarWidget("contacts", "contactsstatus"+this.data.current_status);
			if(appBar!=null) {
				var btnCall = appBar.getButton(this.data.CALL_BTN);
				if(btnCall) {
					btnCall.attr("strButtonIcon", icon);
					if (label && label.isI18Ned) {                                            
		                            btnCall.setButtonLabel(label);
		                        }
	                                else {
						btnCall.setButtonLabel(_(label,"webapp.contacts"));
					}
				}
			}
			if(webapp.contacts.mainWidget && this.data.getContainerPath()=="webapp.contacts.getContactCard") {
				webapp.contacts.mainWidget.reloadContainer();
			}
		}
	}
});
