dojo.require("webapp.contacts.controlBase");
dojo.provide("webapp.contacts");
dojo.declare("webapp.contacts", webapp.contacts.controlBase,
{

	load: function() {
		webapp.contacts.data.loadContactList();
	},

	buttonCallback : function(buttonId) {
		var data = webapp.contacts.data;
		switch(buttonId)
		{
			case data.BACK:
				switch(data.strContainerPath)
				{
					case "webapp.contacts.getContactCard" :
						data.switchContainer("getContactList", data.STATUS_MR_SCREEN, "Contact List");
						break;
					case "webapp.contacts.getContactEdition" :
						data.switchContainer("getContactList", data.STATUS_MR_SCREEN, "Contact List");
						break;
					case "webapp.contacts.getContactList" :
						dojo.publish("OpenHomepage");
						break;
					default :
						data.switchContainer("getContactCard", data.STATUS_HOME, "Contact Card");
						break;
				}
				break;
			case data.CREATE_BTN :
				webapp.contacts.data.newContactId = -1;
				webapp.contacts.data.objCurrentContact = {};
				data.switchContainer("getContactEdition", data.STATUS_EDITION, "Add new Contact");
				break;
			case data.EDIT_BTN :
				webapp.contacts.data.setContactId(webapp.contacts.data.objCurrentContact.contactId);
				data.switchContainer("getContactEdition", data.STATUS_EDITION, "Add new Contact");
				break;
			case data.DELETE_BTN:
				this.loadDeletePopup();
				break;
			case data.COPY_BTN:
				ICTouchAPI.APIServices.IctDirectory.copyContactToLocal({
					params:this
				})
				break;
			case data.ADD_BTN :
				break;
			case data.SAVE_CONTACT_BTN :
				var func = dojo.hitch(webapp.contacts, webapp.contacts.getContactEdition.onSaveNewContact);
				func();
				break;
			default :
				console.log("No callback is associated with this button!");
				break;
		}
	}
});
webapp.contacts=new webapp.contacts();
