#!/bin/sh
################################################################################
# input: CTL file from customer on USB key
#        ALU default certificat in /config/fab/cert/cert.pem
#        ALU default private key in /config/fab/cert/pkey.pem
#        CA certificate from ALU PKI /etc/trust_store/ALU/Wired_Phones.pem
# output: signed CTL.xml file on USB key
################################################################################
############
# CHANGELOG
#===========
# 2010/11/26    CRMS00276670    Claire Dechriste
#               error during CTL signature verification on some CTL files
#
# 2011/01/10    crms00285849    Claire Dechriste
#               CTL signature check robustness

CTL_USB=$(getICTinfo CTL UNSIGNED)
CTL_USB_SIGNED=$(getICTinfo CTL SIGNED)
MOUNT_POINT="/mnt/removable/usb_disk"
CTL=$MOUNT_POINT/$CTL_USB
#CRMS00276670 +
CTL_UNIX="/var/tmp/ctlunix.pem"
CTL_TMP="/var/tmp/ctltosign.pem"
CTL_SIGNED=$MOUNT_POINT/$CTL_USB_SIGNED
CA_ICT="/etc/trust_store/ALU/Wired_Phones.pem"
SIG="/var/tmp/CTL.pem.sig"
SIG_B64="/var/tmp/CTL.pem.sig.b64"
mountLockFile="/tmp/.mountedFlash"
#CRMS00276670 -

exec  >> /dev/console 2>&1
[[ -f /tmp/debug.lib_settings ]] && set -x

exit_ko()
{
        displaypopup -t 4 -l error CTL_sign KO
	echo "CTL_sign KO"
	exit 1
}

exit_ok()
{
        displaypopup -t 4 -l information CTL_sign OK
	echo "CTL_sign OK"
	exit 0
}

# verify that the usb key is mounted.
if [ ! -f $mountLockFile ]
then
   echo "USB key not mounted"
   exit_ko
fi

# verify the presence of the file on the usb key
[ -f $CTL ] || { echo "$CTL does not exist";  exit_ko; }

rm -f $CTL_SIGNED 2>/dev/null

#CRMS00276670 +
## Generate the signature
##crms238256
#pkey=$(getICTinfo PKI ALU_PKEY)
#if test "X"$pkey == "X"  || test  ! -f $pkey
#    then
#        echo "No private key found"
#        displaypopup -t 4 -l error CTL_sign KO: no pkey found
#        exit 1
#fi
#openssl dgst -sha1 -sign $pkey -out $SIG $CTL
#openssl enc -base64 -in $SIG -out $SIG_B64
#CRMS00276670 -

# Create XML
touch $CTL_SIGNED
[ $? -ne 0 ] && { echo "cannot write on USB key"; exit_ko; }

echo "<trust_store_info>" >> $CTL_SIGNED
echo "<cert>" >> $CTL_SIGNED
#crms238256
cert=$(getICTinfo PKI ALU_CERT)
if test "X"$cert == "X"  || test  ! -f $cert
    then
        echo "No certificate found"
        displaypopup -t 4 -l error CTL_sign KO: no cert found
        exit 1
fi

cat $cert >> $CTL_SIGNED
echo "</cert>" >> $CTL_SIGNED
echo "<CA_ICT>" >> $CTL_SIGNED
cat $CA_ICT >> $CTL_SIGNED
echo "</CA_ICT>">> $CTL_SIGNED
echo "<CTL>">> $CTL_SIGNED


#CRMS00276670 +
#remove ^M
tr -d "\015" <$CTL   >$CTL_UNIX
#crms00285849
echo "" >>$CTL_UNIX
#remove empty lines
sed '/^$/d' <$CTL_UNIX >$CTL_TMP
cat $CTL_TMP >> $CTL_SIGNED

#Generate the signature
#crms238256
pkey=$(getICTinfo PKI ALU_PKEY)
if test "X"$pkey == "X"  || test  ! -f $pkey
    then
        echo "No private key found"
        displaypopup -t 4 -l error CTL_sign KO: no pkey found
        exit 1
fi
openssl dgst -sha1 -sign $pkey -out $SIG $CTL_TMP
openssl enc -base64 -in $SIG -out $SIG_B64
#CRMS00276670 -

echo "<signature encodage=\"base64\">" >> $CTL_SIGNED

cat $SIG_B64 >> $CTL_SIGNED
echo "</signature>">> $CTL_SIGNED
echo "</CTL>">> $CTL_SIGNED
echo "</trust_store_info>" >> $CTL_SIGNED
echo "Signed CTL generated: $CTL_SIGNED"

#CRMS00276670 +
rm -f $CTL_UNIX 2>/dev/null
rm -f $CTL_TMP 2>/dev/null
#CRMS00276670 -

rm -f $SIG 2>/dev/null
rm -f $SIG_B64 2>/dev/null

exit_ok

