dojo.provide("webapp.screensaver.controlBase");

dojo.declare("webapp.screensaver.controlBase",ICTouchAPI.webApplication,
{
	uiScreensaver: null,
	presentationLoaded : null,

	screensaversView : "slideshowScreensaver",

	constructor : function() {
		ICTouchAPI.eventServices.subscribeToEvent(this, "SHOW_POPUP_EVENT", this._showPopUp);
	},

	loaded: function() {
        dojo.subscribe("setScreensaverZindex",this,this._setScreensaverZindex);

		ICTouchAPI.settingServices.subscribeToSetting(this, "ScreensaverSlideshowDelay", this._onScreensaverSlideshowDelay);
        ICTouchAPI.settingServices.getSetting("ScreensaverSlideshowDelay", this, this._onScreensaverSlideshowDelay);
		
		ICTouchAPI.settingServices.subscribeToSetting(this, "ScreenSaverEnabled", this._onScreenSaverEnabled);
        ICTouchAPI.settingServices.getSetting("ScreenSaverEnabled", this, this._onScreenSaverEnabled);

		ICTouchAPI.settingServices.subscribeToSetting(this, "EnableVoicemailScreensaver", this._onEnableVoicemailScreensaver);
		ICTouchAPI.settingServices.getSetting("EnableVoicemailScreensaver", this, this._onEnableVoicemailScreensaver);

		ICTouchAPI.settingServices.subscribeToSetting(this, "ScreensaverSlideshowList", this._onScreensaverSlideshowList);
		/* getSetting for ScreensaverSlideshowList is done in data, to manage Demo Mode */

		ICTouchAPI.settingServices.subscribeToSetting(this, "ScreenSaversListChoice", this._onScreenSaversListChoiceChanged);
		ICTouchAPI.settingServices.getSetting("ScreenSaversListChoice", this, this._onScreenSaversListChoiceChanged);

		ICTouchAPI.settingServices.subscribeToSetting(this, "ScreensaverBackToHomepageWhenOut", this._onScreensaverBackToHomepageChanged);
		ICTouchAPI.settingServices.getSetting("ScreensaverBackToHomepageWhenOut", this, this._onScreensaverBackToHomepageChanged);
		
        //Checking the demoType setting
		ICTouchAPI.settingServices.getSetting("CurrentDemoMode", this, this._demoModeReceived);
        ICTouchAPI.settingServices.getSetting("CurrentDemoType", this, this._demoTypeReceived);

		/*
         * 	WRK : crms_00202034 : the subscriptions
         * 	WRK : crms00239484 : those subscriptions listen events which will not be sent before the GreenManager catch the
         * 	presentationLoaded event which is sent from the ICTouchAPI.initWidgets function on the
         * 	unload of the initialization webapp.
         *
         * 	note : it's useless to try to delay the subscription and to synchronize it on the presentationLoaded event notification
         * 	as long as the Screensaver_On and Screensaver_Off are delayed by the GreenManager
        */
		ICTouchAPI.eventServices.subscribeToEvent(this, "Screensaver_On", this._screensaverOnReceived);
		ICTouchAPI.eventServices.subscribeToEvent(this, "Screensaver_Off", this._screensaverOffReceived);
		ICTouchAPI.eventServices.subscribeToEvent(this, "notifyVoiceMailCountChanged", this._voicemailCountChanged);
		ICTouchAPI.eventServices.subscribeToEvent(this, "FrontdeskMessageNotification", this._frontDeskMessageCountChanged);
		ICTouchAPI.eventServices.subscribeToEvent(this, "presentationLoaded", this._presentationLoaded);
		/*End of crms00239484*/
		
        dojo.subscribe("phoneLocked",this,this._reloadScreenSaver);
		dojo.subscribe("customExitForScreensaverVVM", this.data, this.data.setCustomExitForVVM);

		ICTouchAPI.APIServices.Comlog.count({params:[0,7], context:this, callback:this._gotVmCount});
    },

	dump : function(boolAdvancedLogs) {
		this.inherited(arguments);
		ICTouchAPI.debugServices.dump("Screensaver settings :");
		ICTouchAPI.debugServices.dump(" - ScreensaverSlideshowDelay (intDelay): " + this.data.getSlideshowDelay());
		ICTouchAPI.debugServices.dump(" - ScreenSaverEnabled (screenSaverEnabled): " + this.data.getScreenSaverEnabled());
		ICTouchAPI.debugServices.dump(" - EnableVoicemailScreensaver (voicemailScreensaverEnabled): " + this.data.getVoicemailScreensaverEnabled());
		ICTouchAPI.debugServices.dump(" - ScreensaverSlideshowList (arrSlideshowFullpath/arrVoicemailSlideshow): " + this.data.getSlideshowList());
		ICTouchAPI.debugServices.dump(" - ScreenSaversListChoice (screensaverWebapp): " + this.data.getScreensaverWebapp());
		ICTouchAPI.debugServices.dump(" - ScreensaverBackToHomepageWhenOut (boolAutoBackToHomepage): " + this.data.getAutoBackToHomepage());
		ICTouchAPI.debugServices.dump(" - CurrentDemoMode (demoMode): " + this.data.getDemoMode());
		ICTouchAPI.debugServices.dump("Screensaver internal variables :");
		ICTouchAPI.debugServices.dump(" - screensaverWebapp: " + this.data.screensaverWebapp);
		ICTouchAPI.debugServices.dump(" - Current screensaver screen (getCurrentScreensaverScreen): " + this.data.getCurrentScreensaverScreen());
		ICTouchAPI.debugServices.dump(" - screensaverZIndex: " + this.data.getScreensaverZIndex());
		ICTouchAPI.debugServices.dump(" - arrSlideshow: " + this.data.arrSlideshow);
		ICTouchAPI.debugServices.dump(" - arrSlideshowFullpath: " + this.data.arrSlideshowFullpath);
		ICTouchAPI.debugServices.dump(" - arrVoicemailSlideshow: " + this.data.arrVoicemailSlideshow);
		ICTouchAPI.debugServices.dump(" - unreadVoicemail: " + this.data.unreadVoicemail);
		ICTouchAPI.debugServices.dump(" - unreadMessage: " + this.data.unreadMessage);
		ICTouchAPI.debugServices.dump(" - demoTypeIdleSet: " + this.data.demoTypeIdleSet);
		ICTouchAPI.debugServices.dump(" - IsActiveScreensaver (_boolIsActiveScreensaver): " + this.data.getIsActiveScreensaver());
		if (boolAdvancedLogs) {
			ICTouchAPI.debugServices.dump("loadedScreensaverDone: " + this.data.loadedScreensaverDone);
			ICTouchAPI.debugServices.dump("loadedSlideshowListDone: " + this.data.loadedSlideshowListDone);
			ICTouchAPI.debugServices.dump("loadedSlideshowDelayDone: " + this.data.loadedSlideshowDelayDone);
			ICTouchAPI.debugServices.dump("loadedScreenSaverEnabledDone: " + this.data.loadedScreenSaverEnabledDone);
		}
	},

	getApplicationName : function(){
		return "webapp.screensaver";
	},

	launchScreensaver: function() {
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - launchScreensaver");
		//Build screensaver screen
		ICTouchAPI.transitionServices.getScreen({
			name : this.data.getCurrentScreensaverScreen(),
			params:  {},
			position: "FullScreen",
			zindex : this.data.getScreensaverZIndex()
		});
		this.data.setIsActiveScreensaver(true);
		//Launch onScreensaverOn function(if exist) of the current screensaver webapp
		if(typeof(webapp[this.data.getScreensaverWebapp()].onScreensaverOn)==="function") {
			webapp[this.data.getScreensaverWebapp()].onScreensaverOn();
		}
	},

	destroyScreensaver: function() {
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - destroyScreensaver");
		// Sometimes, we leave screensaver by a getScreen (i.e. incomming call), so when this function is called, we are no more in screensaver.
		// Call the back only if we still are
		if(ICTouchAPI.transitionServices.getCurrentScreenName() == this.data.getCurrentScreensaverScreen()){
			if(!this.data.customExit){
				if(webapp.lock && webapp.lock.isLocked()){
					ICTouchAPI.transitionServices.getScreen({
						name: "webapp.lock.getLock",
						params:  {},
						position: "FullScreen"
					});
				}else{
					if(this.data.getAutoBackToHomepage()){
						dojo.publish("OpenHomepage");
					} else {
						ICTouchAPI.transitionServices.back();
					}
				}
			}else{
				if(webapp.lock){
					if(webapp.lock.isLocked()){
						ICTouchAPI.transitionServices.back();
					}else{
						dojo.publish("OpenHomepage");
					}
					dojo.publish("resetCustomExit",["screensaver"]);
				}
			}
		}
		this.data.setIsActiveScreensaver(false);
		//Launch onScreensaverOff function(if exist) of the current screensaver webapp
		if(typeof(webapp[this.data.getScreensaverWebapp()].onScreensaverOff)==="function") {
			webapp[this.data.getScreensaverWebapp()].onScreensaverOff();
		}
	},

	updateScreensaverSlideshow : function(){
		if (this.uiScreensaver){
			this.uiScreensaver.updateSlideshow(this.data.getSlideshowList());
		}
	},

	onScreensaverOn : function() {
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - onScreensaverOn");
		if(this.uiScreensaver!=null) {
			this.uiScreensaver.launchSlideshow();
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.screensaver.controlBase - onScreensaverOn / this.uiScreensaver is null");
		}
	},

	onScreensaverOff : function() {
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - onScreensaverOff");
		if(this.uiScreensaver!=null) {
			this.uiScreensaver.stopSlideshow();
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.screensaver.controlBase - onScreensaverOff / this.uiScreensaver is null");
		}
	},

	_setScreensaverOn: function() {
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - _setScreensaverOn");
		ICTouchAPI.APIServices.GreenManager.setScreensaverState({
			params: ["true"],
			context: this
		});
	},

	_setScreensaverOff: function() {
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - _setScreensaverOff");
		ICTouchAPI.APIServices.GreenManager.setScreensaverState({
			params: ["false"],
			context: this
		});
	},

	_showPopUp: function() {
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - _showPopUp");
		this._setScreensaverOff();
	},

	_setScreensaverZindex: function(zIndex){
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - _setScreensaverZindex");
		if(zIndex && typeof (zIndex) == "string") {
			ICTouchAPI.debugServices.debug("webapp.screensaver.controlBase - _setScreensaverZindex / previous value: " + this.data.getScreensaverZIndex());
			ICTouchAPI.debugServices.debug("webapp.screensaver.controlBase - _setScreensaverZindex / new value: " + zIndex);
			this.data.setScreensaverZIndex(zIndex);
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.screensaver.controlBase - _setScreensaverZindex / zIndex is not defined or is not a string: " + zIndex);
		}
	},

	// WRK : crms_00202230
	_onScreensaverSlideshowDelay: function(slideshowDelaySetting) {
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - _onScreensaverSlideshowDelay");
		if (slideshowDelaySetting) {
			ICTouchAPI.debugServices.debug("webapp.screensaver.controlBase - _onScreensaverSlideshowDelay / previous value: " + this.data.getSlideshowDelay());
			ICTouchAPI.debugServices.debug("webapp.screensaver.controlBase - _onScreensaverSlideshowDelay / new value: " + slideshowDelaySetting.jsValue);
			this.data.setSlideshowDelay(slideshowDelaySetting.jsValue);
			dojo.publish("screensaver.delay", [slideshowDelaySetting.jsValue]);
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.screensaver.controlBase - _onScreensaverSlideshowDelay / slideshowDelaySetting is not defined: " + slideshowDelaySetting);
		}
	},

	// WRK : crms_00202034
	_onScreenSaverEnabled: function(screenSaverEnabledSetting) {
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - _onScreenSaverEnabled");
		if (screenSaverEnabledSetting) {
			ICTouchAPI.debugServices.debug("webapp.screensaver.controlBase - _onScreenSaverEnabled / previous value: " + this.data.getScreenSaverEnabled());
			ICTouchAPI.debugServices.debug("webapp.screensaver.controlBase - _onScreenSaverEnabled / new value: " + screenSaverEnabledSetting.jsValue);
			this.data.setScreenSaverEnabled(screenSaverEnabledSetting.jsValue);
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.screensaver.controlBase - _onScreenSaverEnabled / screenSaverEnabledSetting is not defined: " + screenSaverEnabledSetting);
		}
	},

	_onEnableVoicemailScreensaver : function(vmSetting) {
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - _onEnableVoicemailScreensaver");
		if (vmSetting) {
			ICTouchAPI.debugServices.debug("webapp.screensaver.controlBase - _onEnableVoicemailScreensaver / previous value: " + this.data.getVoicemailScreensaverEnabled());
			ICTouchAPI.debugServices.debug("webapp.screensaver.controlBase - _onEnableVoicemailScreensaver / new value: " + vmSetting.jsValue);
			this.data.setVoicemailScreensaverEnabled(vmSetting.jsValue);
			this.updateScreensaverSlideshow();
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.screensaver.controlBase - _onEnableVoicemailScreensaver / vmSetting is not defined: " + vmSetting);
		}
	},

	_onScreensaverSlideshowList: function(slideshowList) {
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - ScreensaverSlideshowList");
		if (slideshowList) {
			ICTouchAPI.debugServices.debug("webapp.screensaver.controlBase - ScreensaverSlideshowList / previous slideshowList: " + this.data.arrSlideshow);
			ICTouchAPI.debugServices.debug("webapp.screensaver.controlBase - ScreensaverSlideshowList / new slideshowList: " + [slideshowList.jsValue]);
			this.data.setSlideshowList(slideshowList.jsValue);
			this.updateScreensaverSlideshow();
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.screensaver.controlBase - ScreensaverSlideshowList / slideshowList is not defined: " + slideshowList);
		}
	},

	_onScreenSaversListChoiceChanged : function(screen){
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - _onScreenSaversListChoiceChanged");
		this.data.setScreensaverWebapp(screen);
	},

	_demoModeReceived : function(demoMode) {
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - _demoModeReceived");
		if (demoMode) {
			ICTouchAPI.debugServices.debug("webapp.screensaver.controlBase - _demoModeReceived / value of demoMode is: " + demoMode.jsValue);
			this.data.setDemoMode(demoMode.jsValue);
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.screensaver.controlBase - _demoModeReceived / demoMode is not defined: " + demoMode);
		}
	},

	/**
	 * Method called during the creation, when the demoType setting is received
	 * @params {Object} objSetting : demoType setting
	 */
	_demoTypeReceived : function(objSetting){
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - _demoTypeReceived");
		if(objSetting){
			this.data._setDemoType(objSetting.jsValue);
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.screensaver.controlBase - _demoTypeReceived / objSetting is not defined: " + objSetting);
		}
	},
	
	// Used in demoMode only
	_checkDataLoadedLaunchScreensaver : function() {
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - _checkDataLoadedLaunchScreensaver");
		var myself = dojo.hitch(this, this._checkDataLoadedLaunchScreensaver);
		if (!(webapp.screensaver.data.loadedScreensaverDone	&& webapp.screensaver.data.loadedSlideshowListDone && webapp.screensaver.data.loadedSlideshowDelayDone)) {
			setTimeout(myself, 500);
		}
		else {
			this._setScreensaverOn();
			webapp.screensaver.launchScreensaver();
		}
	},

	_screensaverOnReceived: function() {
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - _screensaverOnReceived");
		dojo.publish("requestCustomVVMExit",["screensaver"]);
		webapp.screensaver.launchScreensaver();
	},

	_screensaverOffReceived: function() {
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - _screensaverOffReceived");
		if (!webapp.screensaver.data.getDemoMode() || webapp.screensaver.data.demoTypeIdleSet) {
			webapp.screensaver.destroyScreensaver();
		}
	},

	_voicemailCountChanged : function(notif) {
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - _voicemailCountChanged");
		if(notif.value>0){
			if(this.data.unreadVoicemail !== true){
				this.data.unreadVoicemail = true;
				this.updateScreensaverSlideshow();
			}
		}else{
			if(this.data.unreadVoicemail !== false){
				this.data.unreadVoicemail = false;
				this.updateScreensaverSlideshow();
			}
		}
	},

	_gotVmCount : function(count){
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - _gotVmCount");
		if (count >0 && this.data.unreadVoicemail !== true){
			this.data.unreadVoicemail = true;
			this.updateScreensaverSlideshow();
		}
	},

	_frontDeskMessageCountChanged : function(){
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - _frontDeskMessageCountChanged");
		var objArguments = ICTouchAPI.tools.getEventArguments(arguments);
		var activation = objArguments.activation || "";
		if(activation){
			if(this.data.unreadMessage !== true){
				this.data.unreadMessage = true;
				this.updateScreensaverSlideshow();
			}
		}
		else{
			if(this.data.unreadMessage !== false){
				this.data.unreadMessage = false;
				this.updateScreensaverSlideshow();
			}
		}

	},

	/**
     * Method called when the presentationLoaded event is caught
     */
	_presentationLoaded : function(){
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - _presentationLoaded");
		webapp.screensaver.presentationLoaded = true;
		ICTouchAPI.eventServices.unsubscribeToEvent(this,"presentationLoaded");
	},

	_reloadScreenSaver:function(){
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - _reloadScreenSaver");
		if(this.data.getIsActiveScreensaver()) {
			var func = function() {webapp.screensaver.launchScreensaver();};
			setTimeout(func,100);
		}
	},

	unlock : function(){
		if(this.data.getDemoMode()===true && this.data.demoTypeIdleSet!==true) {
			dojo.publish("unlockTransition",[false]);
		}
		else {
			dojo.publish("unlockTransition",[true]);
		}
	},

	_onScreensaverBackToHomepageChanged : function(objSettingBackToHomepage) {
		if(objSettingBackToHomepage){
			this.data.setAutoBackToHomepage(objSettingBackToHomepage.jsValue);
		}
		objSettingBackToHomepage = null;
	}
});
/*
 * The defaultScreensaverBase view can be loaded by other webapps before loading the screensaver webapp
 * To avoid overriding webapp.screensaver object and delete webapp.screensaver.defaultScreensaverBase,
 * if it exists we save it and add it again to the new webapp.screensaver object
 */
var obj= null;
if (webapp.screensaver.defaultScreensaverBase){
	obj = webapp.screensaver.defaultScreensaverBase;
}

dojo.require("webapp.screensaver.controlBase");
dojo.provide("webapp.screensaver");
dojo.declare("webapp.screensaver",webapp.screensaver.controlBase,
{

});

webapp.screensaver = new webapp.screensaver();

/*
 * save again the defaultScreensaverBase view if existing
 */
if (obj){
	webapp.screensaver.defaultScreensaverBase= obj;
}dojo.provide("webapp.screensaver.dataBase");
dojo.declare("webapp.screensaver.dataBase",null,{

	screensaverWebapp : "screensaver",

	screensaverZIndex :		"20000",

	arrSlideshow : null,
	arrSlideshowFullpath: null,
	arrVoicemailSlideshow: [],

	intDelay: 60,
	screenSaverEnabled: true,
	boolAutoBackToHomepage: false,

	voicemailScreensaverEnabled : false,
	unreadVoicemail : false,
	unreadMessage : false,

	loadedScreensaverDone: false,
	loadedSlideshowListDone:false,
	loadedSlideshowDelayDone:false,
	loadedScreenSaverEnabledDone: false,
	demoMode: false,
	demoTypeIdleSet : false,

	_boolIsActiveScreensaver: false,
	customExit : false,

	constructor : function() {
		this.arrSlideshow = new Array();
		this.arrSlideshowFullpath = new Array();

		this.arrVoicemailSlideshow = ["webapp/screensaver/themes/Default/images/voicemail_1.jpg",
		"webapp/screensaver/themes/Default/images/voicemail_2.jpg"];
	},

	buildSlideshowFullPathArray : function(){
		this.arrSlideshowFullpath = [];
		if (this.arrSlideshow.length != 0){
			for (var i = 0; i < this.arrSlideshow.length; i++) {
				if (this.arrSlideshow[i].indexOf("/") === -1){
					this.arrSlideshowFullpath[i] = "webapp/screensaver/themes/Default/images/" + this.arrSlideshow[i];
				}
				else{
					this.arrSlideshowFullpath[i] = this.arrSlideshow[i];
				}
			}
		}
	},

	setScreensaverZIndex: function(zIndex) {
		this.screensaverZIndex = zIndex;
	},

	getScreensaverZIndex: function() {
		return this.screensaverZIndex;
	},

	getCurrentScreensaverScreen : function(){
		return "webapp."+this.getScreensaverWebapp()+"."+webapp[this.getScreensaverWebapp()].screensaversView;
	},

	setSlideshowDelay: function(delay) {
		this.intDelay = delay;
		this.loadedSlideshowDelayDone = true;
	},

	getSlideshowDelay: function() {
		return this.intDelay;
	},

	// WRK : crms_00202034
	setScreenSaverEnabled: function(screenSaverEnabled) {
		this.screenSaverEnabled = screenSaverEnabled;
		this.loadedScreenSaverEnabledDone = true;
	},

	getScreenSaverEnabled: function() {
		return this.screenSaverEnabled;
	},

	setVoicemailScreensaverEnabled : function(voicemailScreensaverEnabled){
		this.voicemailScreensaverEnabled = voicemailScreensaverEnabled;
	},

	getVoicemailScreensaverEnabled : function(){
		return this.voicemailScreensaverEnabled;
	},

	setSlideshowList: function(slideshowList) {
		this.arrSlideshow = slideshowList;
		this.buildSlideshowFullPathArray();
		this.loadedSlideshowListDone = true;
	},

	getSlideshowList : function(){
		if (this.getVoicemailScreensaverEnabled() && (this.unreadVoicemail || this.unreadMessage)){
			return this.arrVoicemailSlideshow;
		}
		else{
			return this.arrSlideshowFullpath;
		}
	},

	setScreensaverWebapp: function(screensaverSetting) {
		if( screensaverSetting ) {	// Note: screensaver can be undefined(?) or null
			this.screensaverWebapp = screensaverSetting.allowedValues[screensaverSetting.jsValue].id;
			this.loadedScreensaverDone = true;
		}
	},

	getScreensaverWebapp: function() {
		return this.screensaverWebapp;
	},

	setIsActiveScreensaver : function(boolActive){
		this._boolIsActiveScreensaver = boolActive;
	},

	getIsActiveScreensaver : function(){
		return this._boolIsActiveScreensaver;
	},



	/* Manage Demo Mode */
	setDemoMode : function(demoMode){
		this.demoMode = demoMode;
	},

	getDemoMode : function(){
		return this.demoMode;
	},
	/**
	 * Method called during the creation, when the demoType setting is received
	 * @params {Object} objSetting : demoType setting
	 */
	_setDemoType : function(demoTypeValue){
		ICTouchAPI.debugServices.info("webapp.screensaver.database - _setDemoType");
		if(this.getDemoMode()){
			ICTouchAPI.debugServices.debug("webapp.screensaver.database - _setDemoType / demoTypeValue is: " + demoTypeValue);
			if(demoTypeValue == 0){
				//this verification is done meant to be done after the controlBase
				//so if we actually are in demoMode true, the demoMode should be launched on the boot
				//but user can leave it
				this.demoTypeIdleSet = true;
				//We build the screensaver to be displayed
				ICTouchAPI.settingServices.getSettingValue("ScreensaverSlideshowList", this, this._loadedSlideshowList);
			}else if(demoTypeValue == 1){
				//we load the picture from the USB device
				this.loadFromUSBDevice();
			}else{
				//demoType = slideshow : we load the standard screensaver
				ICTouchAPI.settingServices.getSettingValue("ScreensaverSlideshowList", this, this._loadedSlideshowList);
			}
			webapp.screensaver.checkDataLoadedLaunchScreensaver();
		}else{
			//demoMode = false : we load the standard screensaver
			ICTouchAPI.settingServices.getSettingValue("ScreensaverSlideshowList", this, this._loadedSlideshowList);
		}
	},

	_loadedSlideshowList: function(slideshowList) {
		if (slideshowList) {
			this.arrSlideshow = slideshowList;
			this.buildSlideshowFullPathArray();
			this.loadedSlideshowListDone = true;
		}
	},

	/**
	 * Method called to count the number MAX of picture to be loaded
	 */
	loadFromUSBDevice : function(){
		//create / empty the pictures array
		this.arrSlideshow = [];

		//count the number MAX of picture to be loaded
		ICTouchAPI.APIServices.FileManager.getFilesInCategorySize({
			context: this,
			params: ["Picture"],
			callback: this.loadingFromUSBDevice
		});
	},

	/**
	 * Method called to laod the pictures stored on an USB device
	 * @params {integer} nb : number max of pictures to be loaded from the device
	 */
	loadingFromUSBDevice : function(nb){
		ICTouchAPI.APIServices.FileManager.getFilesWithFilter({
			params:["Picture",0,nb,"","1"], //"TYPE", min, max, "extension(jpg,gif...)", "0:userspace|1:USB"
			context:this,
			callback:this.loadedFromUSBDevice
		});
	},

	/**
	 * Callback done once we get all the images from usb
	 * @params {Array of Object} slideshowList : list of the files stored on the USB device
	 */
	loadedFromUSBDevice : function(slideshowList){
		//If we got any files
		if(slideshowList) {
			this.arrSlideshowFullpath = new Array(this.arrSlideshow.length);
			//we clean the list ...
			this.arrSlideshow = slideshowList;
			for (var i = 0; i < this.arrSlideshow.length; i++) {
				// ... keeping only the URL on the pictures
				this.arrSlideshowFullpath[i] = this.arrSlideshow[i].url;
			}

		}
		//we notify the end of the load
		this.loadedSlideshowListDone = true;
	},

	setAutoBackToHomepage : function(boolValue) {
		this.boolAutoBackToHomepage = boolValue;
		boolValue = null;
	},

	getAutoBackToHomepage : function() {
		return this.boolAutoBackToHomepage;
	},

	setCustomExitForVVM : function(boolExit){
		this.customExit = boolExit;
	}
});
dojo.require("webapp.screensaver.dataBase");
dojo.provide("webapp.screensaver.data");
dojo.declare("webapp.screensaver.data",webapp.screensaver.dataBase,{

});

webapp.screensaver.data=new webapp.screensaver.data();
dojo.provide("webapp.screensaver.defaultScreensaverBase");

dojo.declare("webapp.screensaver.defaultScreensaverBase",
	[ICTouchAPI.webWidget, dijit._Templated],
	{

		_currentIdx			: 0,
		_delay				: 2000,
		_handler			: null,
		_handlerInterval	: null,
		_handlerImg			: null,
		_handlerError		: null,
		arrSlideshow		: [],
		currentImageDisplayed	: 0,

		slideshowLaunched : false,


		constructor: function() {
			this._delay = webapp.screensaver.data.getSlideshowDelay();

			// This block of instructions blocks the possibility the select anything in the webApp
			var ffalse = function() {
				return false;
			};
			var ftrue = function() {
				return true;
			};
			document.onselectstart = ffalse;
			document.onmousedown = ffalse;
			document.onclick = ftrue;
			// Makes this widget stealth to the transitionServices so no back() would swap back to it.
			this.stealth();
			this.initScreensaver();
		},

		destroy: function() {
			this.clearTimers();
			this.removeImagesInDom();
		},

		postCreate: function() {
			this.subscribe("screensaver.delay", this.updateDelay);
			this._currentIdx = 0;
			this.launchSlideshow();
		},

		launchSlideshow : function() {
			ICTouchAPI.debugServices.info("webapp.screensaver.defaultScreensaverBase - launchSlideshow");
			if (this.slideshowLaunched){
				ICTouchAPI.debugServices.warning("webapp.screensaver.defaultScreensaverBase - launchSlideshow / Screensaver already launched (slideshowLaunched = " + this.slideshowLaunched + "), exit");
				return;
			}
			if (this.arrSlideshow.length == 0){
				ICTouchAPI.debugServices.warning("webapp.screensaver.defaultScreensaverBase - launchSlideshow / No images in arrSlideshow (arrSlideshow = " + this.arrSlideshow + "), return");
				return;
			}

			this.slideshowLaunched = true;			
			this.prepareNextImage();

			var that = this;
			var funcNextImage = function () {
				that.startSlideShow();
				clearTimeout(this._handler);
				that._handler = null;
			}
			this._handler = setTimeout(funcNextImage, 250);
		},

		stopSlideshow : function() {
			ICTouchAPI.debugServices.info("webapp.screensaver.defaultScreensaverBase - stopSlideshow");
			this.slideshowLaunched = false;
			this.clearTimers();
			this.removeImagesInDom();
		},

		removeImagesInDom : function(){
			ICTouchAPI.debugServices.info("webapp.screensaver.defaultScreensaverBase - removeImagesInDom");
			// Clean domContainer (remove all images when exiting screensaver, to free memory)
			while (this.domContainer.hasChildNodes()) {
				this.domContainer.removeChild(this.domContainer.firstChild);
			}
		},

		clearTimers : function(){
			ICTouchAPI.debugServices.info("webapp.screensaver.defaultScreensaverBase - clearTimers");
			if(this._handlerImg){
				dojo.disconnect(this._handlerImg);
				this._handlerImg = null;
			}
			if(this._handlerError){
				dojo.disconnect(this._handlerError);
				this.handlerError = null;
			}
			if(this._handler) {
				clearTimeout(this._handler);
				this._handler = null;
			}
			if(this._handlerInterval) {
				clearInterval(this._handlerInterval);
				this._handlerInterval = null;
			}
		},


		updateSlideshow : function(newSlideshow){
			ICTouchAPI.debugServices.info("webapp.screensaver.defaultScreensaverBase - updateSlideshow");
			ICTouchAPI.debugServices.debug("webapp.screensaver.defaultScreensaverBase - updateSlideshow / preview slideshow: " + this.arrSlideshow);
			ICTouchAPI.debugServices.debug("webapp.screensaver.defaultScreensaverBase - updateSlideshow / new slideshow: " + newSlideshow);
			this.arrSlideshow = newSlideshow;
		},


		updateDelay : function(delay){
			ICTouchAPI.debugServices.info("webapp.screensaver.defaultScreensaverBase - updateDelay");
			ICTouchAPI.debugServices.debug("webapp.screensaver.defaultScreensaverBase - updateDelay / preview delay: " + this._delay);
			ICTouchAPI.debugServices.debug("webapp.screensaver.defaultScreensaverBase - updateDelay / new delay: " + delay);
			this._delay = delay;
		},


		startSlideShow: function() {
			ICTouchAPI.debugServices.info("webapp.screensaver.defaultScreensaverBase - startSlideShow");
			/* Trick to avoid a bug: in IctWebClient, the second time the screensaver is lauched the div domContainer is not visible.
			Problem not reproduced with chrome 19, but reproduced with chromimum 8 -> seems to be a webkit bug */
			dojo.style(this.domContainer, "display", "block");
			
			var that = this;
			var func = function () {
				that._updateDisplay();
			}
			this._handlerInterval = setInterval(func, this._delay*1000);
			func();
		},


		_updateDisplay: function() {
			var currentImage = this.domContainer.getElementsByClassName('ScreensaverImage'+this.currentImageDisplayed);
			var hiddenImage = this.domContainer.getElementsByClassName('ScreensaverImage'+((this.currentImageDisplayed == 0) ? 1 : 0));
			this.currentImageDisplayed = (this.currentImageDisplayed == 0) ? 1 : 0;
			if (hiddenImage && hiddenImage[0]) {
				dojo.style(hiddenImage[0],"display","block");
			}
			if (currentImage && currentImage[0]) {
				this.domContainer.removeChild(currentImage[0]);
				currentImage[0] = null;
				currentImage = null;
			}
			this.prepareNextImage();
		},


		prepareNextImage: function() {
			var imgidx = this._currentIdx % this.arrSlideshow.length;
			this._currentIdx = (this._currentIdx+1);

			var img = new Image();
			img.src = this.arrSlideshow[imgidx];//+"?random="+Math.floor(Math.random()*65536);

			this._handlerImg = dojo.connect(img, "onload", this, this.onLoadGetDimensions);
			this._handlerError = dojo.connect(img,"onerror",this,this.onError);
		},

		onLoadGetDimensions: function(event) {
			dojo.disconnect(this._handlerImg);
			dojo.disconnect(this._handlerError);
			this._handlerError=null;
			this._handlerImg=null;
			var img = event.target;
			var w = img.width;
			var h = img.height;
			var width, height, top, left;

			if(w>800 || h>480) {
				var ratio = w/h;
				if(w/800 >= h/480) {
					width = 800;
					height = width/ratio;
				}
				else {
					height = 480;
					width = height*ratio;
				}
			}
			else {
				width = w;
				height = h;
			}

			top = (480-height)/2;
			left = (800-width)/2;

			dojo.place("<img id='ScreensaverImage" + ((this.currentImageDisplayed == 0) ? 1 : 0) + " 'class='ScreensaverImage" + ((this.currentImageDisplayed == 0) ? 1 : 0) + "' src='" + img.src + "' style='display: none; top: "+top+"px; left: "+left+"px; width: "+width+"px; height: " +height+"px'>",this.domContainer,"last");
		},

		onError : function(){
			ICTouchAPI.debugServices.error("webapp.screensaver.defaultScreensaverBase - onError / cannot load image : " + (this.arrSlideshow && this.arrSlideshow[(this._currentIdx-1) % this.arrSlideshow.length]));
			dojo.disconnect(this._handlerImg);
			dojo.disconnect(this._handlerError);
			this._handlerImg = null;
			this.handlerError = null;
		}
	});
dojo.require("webapp.screensaver.defaultScreensaverBase");
dojo.provide("webapp.screensaver.defaultScreensaver");
dojo.declare("webapp.screensaver.defaultScreensaver",
	webapp.screensaver.defaultScreensaverBase,
	{
		templatePath	: dojo.moduleUrl("webapp.screensaver","templates/defaultScreensaver8082.html"),
	});
dojo.require("webapp.screensaver.defaultScreensaverBase");
dojo.provide("webapp.screensaver.slideshowScreensaverBase");
dojo.declare("webapp.screensaver.slideshowScreensaverBase",
	webapp.screensaver.defaultScreensaverBase,
	{

	initScreensaver : function(){
		this.webapp.uiScreensaver = this;
		this.arrSlideshow = webapp.screensaver.data.getSlideshowList();
	}

}
);

dojo.require("webapp.screensaver.slideshowScreensaverBase");
dojo.provide("webapp.screensaver.slideshowScreensaver");
dojo.declare("webapp.screensaver.slideshowScreensaver",
	webapp.screensaver.slideshowScreensaverBase,
	{
		templatePath	: dojo.moduleUrl("webapp.screensaver","templates/slideshowScreensaver8082.html"),
	}
);

