dojo.provide("webapp.screensaver.defaultScreensaverBase");

dojo.declare("webapp.screensaver.defaultScreensaverBase",
	[ICTouchAPI.webWidget, dijit._Templated],
	{

		_currentIdx			: 0,
		_delay				: 2000,
		_handler			: null,
		_handlerInterval	: null,
		_handlerImg			: null,
		_handlerError		: null,
		arrSlideshow		: [],
		currentImageDisplayed	: 0,

		slideshowLaunched : false,


		constructor: function() {
			this._delay = webapp.screensaver.data.getSlideshowDelay();

			// This block of instructions blocks the possibility the select anything in the webApp
			var ffalse = function() {
				return false;
			};
			var ftrue = function() {
				return true;
			};
			document.onselectstart = ffalse;
			document.onmousedown = ffalse;
			document.onclick = ftrue;
			// Makes this widget stealth to the transitionServices so no back() would swap back to it.
			this.stealth();
			this.initScreensaver();
		},

		destroy: function() {
			this.clearTimers();
			this.removeImagesInDom();
		},

		postCreate: function() {
			this.subscribe("screensaver.delay", this.updateDelay);
			this._currentIdx = 0;
			this.launchSlideshow();
		},

		launchSlideshow : function() {
			ICTouchAPI.debugServices.info("webapp.screensaver.defaultScreensaverBase - launchSlideshow");
			if (this.slideshowLaunched){
				ICTouchAPI.debugServices.warning("webapp.screensaver.defaultScreensaverBase - launchSlideshow / Screensaver already launched (slideshowLaunched = " + this.slideshowLaunched + "), exit");
				return;
			}
			if (this.arrSlideshow.length == 0){
				ICTouchAPI.debugServices.warning("webapp.screensaver.defaultScreensaverBase - launchSlideshow / No images in arrSlideshow (arrSlideshow = " + this.arrSlideshow + "), return");
				return;
			}

			this.slideshowLaunched = true;			
			this.prepareNextImage();

			var that = this;
			var funcNextImage = function () {
				that.startSlideShow();
				clearTimeout(this._handler);
				that._handler = null;
			}
			this._handler = setTimeout(funcNextImage, 250);
		},

		stopSlideshow : function() {
			ICTouchAPI.debugServices.info("webapp.screensaver.defaultScreensaverBase - stopSlideshow");
			this.slideshowLaunched = false;
			this.clearTimers();
			this.removeImagesInDom();
		},

		removeImagesInDom : function(){
			ICTouchAPI.debugServices.info("webapp.screensaver.defaultScreensaverBase - removeImagesInDom");
			// Clean domContainer (remove all images when exiting screensaver, to free memory)
			while (this.domContainer.hasChildNodes()) {
				this.domContainer.removeChild(this.domContainer.firstChild);
			}
		},

		clearTimers : function(){
			ICTouchAPI.debugServices.info("webapp.screensaver.defaultScreensaverBase - clearTimers");
			if(this._handlerImg){
				dojo.disconnect(this._handlerImg);
				this._handlerImg = null;
			}
			if(this._handlerError){
				dojo.disconnect(this._handlerError);
				this.handlerError = null;
			}
			if(this._handler) {
				clearTimeout(this._handler);
				this._handler = null;
			}
			if(this._handlerInterval) {
				clearInterval(this._handlerInterval);
				this._handlerInterval = null;
			}
		},


		updateSlideshow : function(newSlideshow){
			ICTouchAPI.debugServices.info("webapp.screensaver.defaultScreensaverBase - updateSlideshow");
			ICTouchAPI.debugServices.debug("webapp.screensaver.defaultScreensaverBase - updateSlideshow / preview slideshow: " + this.arrSlideshow);
			ICTouchAPI.debugServices.debug("webapp.screensaver.defaultScreensaverBase - updateSlideshow / new slideshow: " + newSlideshow);
			this.arrSlideshow = newSlideshow;
		},


		updateDelay : function(delay){
			ICTouchAPI.debugServices.info("webapp.screensaver.defaultScreensaverBase - updateDelay");
			ICTouchAPI.debugServices.debug("webapp.screensaver.defaultScreensaverBase - updateDelay / preview delay: " + this._delay);
			ICTouchAPI.debugServices.debug("webapp.screensaver.defaultScreensaverBase - updateDelay / new delay: " + delay);
			this._delay = delay;
		},


		startSlideShow: function() {
			ICTouchAPI.debugServices.info("webapp.screensaver.defaultScreensaverBase - startSlideShow");
			/* Trick to avoid a bug: in IctWebClient, the second time the screensaver is lauched the div domContainer is not visible.
			Problem not reproduced with chrome 19, but reproduced with chromimum 8 -> seems to be a webkit bug */
			dojo.style(this.domContainer, "display", "block");
			
			var that = this;
			var func = function () {
				that._updateDisplay();
			}
			this._handlerInterval = setInterval(func, this._delay*1000);
			func();
		},


		_updateDisplay: function() {
			var currentImage = this.domContainer.getElementsByClassName('ScreensaverImage'+this.currentImageDisplayed);
			var hiddenImage = this.domContainer.getElementsByClassName('ScreensaverImage'+((this.currentImageDisplayed == 0) ? 1 : 0));
			this.currentImageDisplayed = (this.currentImageDisplayed == 0) ? 1 : 0;
			if (hiddenImage && hiddenImage[0]) {
				dojo.style(hiddenImage[0],"display","block");
			}
			if (currentImage && currentImage[0]) {
				this.domContainer.removeChild(currentImage[0]);
				currentImage[0] = null;
				currentImage = null;
			}
			this.prepareNextImage();
		},


		prepareNextImage: function() {
			var imgidx = this._currentIdx % this.arrSlideshow.length;
			this._currentIdx = (this._currentIdx+1);

			var img = new Image();
			img.src = this.arrSlideshow[imgidx];//+"?random="+Math.floor(Math.random()*65536);

			this._handlerImg = dojo.connect(img, "onload", this, this.onLoadGetDimensions);
			this._handlerError = dojo.connect(img,"onerror",this,this.onError);
		},

		onLoadGetDimensions: function(event) {
			dojo.disconnect(this._handlerImg);
			dojo.disconnect(this._handlerError);
			this._handlerError=null;
			this._handlerImg=null;
			var img = event.target;
			var w = img.width;
			var h = img.height;
			var width, height, top, left;

			if(w>800 || h>480) {
				var ratio = w/h;
				if(w/800 >= h/480) {
					width = 800;
					height = width/ratio;
				}
				else {
					height = 480;
					width = height*ratio;
				}
			}
			else {
				width = w;
				height = h;
			}

			top = (480-height)/2;
			left = (800-width)/2;

			dojo.place("<img id='ScreensaverImage" + ((this.currentImageDisplayed == 0) ? 1 : 0) + " 'class='ScreensaverImage" + ((this.currentImageDisplayed == 0) ? 1 : 0) + "' src='" + img.src + "' style='display: none; top: "+top+"px; left: "+left+"px; width: "+width+"px; height: " +height+"px'>",this.domContainer,"last");
		},

		onError : function(){
			ICTouchAPI.debugServices.error("webapp.screensaver.defaultScreensaverBase - onError / cannot load image : " + (this.arrSlideshow && this.arrSlideshow[(this._currentIdx-1) % this.arrSlideshow.length]));
			dojo.disconnect(this._handlerImg);
			dojo.disconnect(this._handlerError);
			this._handlerImg = null;
			this.handlerError = null;
		}
	});
