dojo.provide("webapp.screensaver.dataBase");
dojo.declare("webapp.screensaver.dataBase",null,{

	screensaverWebapp : "screensaver",

	screensaverZIndex :		"20000",

	arrSlideshow : null,
	arrSlideshowFullpath: null,
	arrVoicemailSlideshow: [],

	intDelay: 60,
	screenSaverEnabled: true,
	boolAutoBackToHomepage: false,

	voicemailScreensaverEnabled : false,
	unreadVoicemail : false,
	unreadMessage : false,

	loadedScreensaverDone: false,
	loadedSlideshowListDone:false,
	loadedSlideshowDelayDone:false,
	loadedScreenSaverEnabledDone: false,
	demoMode: false,
	demoTypeIdleSet : false,

	_boolIsActiveScreensaver: false,
	customExit : false,

	constructor : function() {
		this.arrSlideshow = new Array();
		this.arrSlideshowFullpath = new Array();

		this.arrVoicemailSlideshow = ["webapp/screensaver/themes/Default/images/voicemail_1.jpg",
		"webapp/screensaver/themes/Default/images/voicemail_2.jpg"];
	},

	buildSlideshowFullPathArray : function(){
		this.arrSlideshowFullpath = [];
		if (this.arrSlideshow.length != 0){
			for (var i = 0; i < this.arrSlideshow.length; i++) {
				if (this.arrSlideshow[i].indexOf("/") === -1){
					this.arrSlideshowFullpath[i] = "webapp/screensaver/themes/Default/images/" + this.arrSlideshow[i];
				}
				else{
					this.arrSlideshowFullpath[i] = this.arrSlideshow[i];
				}
			}
		}
	},

	setScreensaverZIndex: function(zIndex) {
		this.screensaverZIndex = zIndex;
	},

	getScreensaverZIndex: function() {
		return this.screensaverZIndex;
	},

	getCurrentScreensaverScreen : function(){
		return "webapp."+this.getScreensaverWebapp()+"."+webapp[this.getScreensaverWebapp()].screensaversView;
	},

	setSlideshowDelay: function(delay) {
		this.intDelay = delay;
		this.loadedSlideshowDelayDone = true;
	},

	getSlideshowDelay: function() {
		return this.intDelay;
	},

	// WRK : crms_00202034
	setScreenSaverEnabled: function(screenSaverEnabled) {
		this.screenSaverEnabled = screenSaverEnabled;
		this.loadedScreenSaverEnabledDone = true;
	},

	getScreenSaverEnabled: function() {
		return this.screenSaverEnabled;
	},

	setVoicemailScreensaverEnabled : function(voicemailScreensaverEnabled){
		this.voicemailScreensaverEnabled = voicemailScreensaverEnabled;
	},

	getVoicemailScreensaverEnabled : function(){
		return this.voicemailScreensaverEnabled;
	},

	setSlideshowList: function(slideshowList) {
		this.arrSlideshow = slideshowList;
		this.buildSlideshowFullPathArray();
		this.loadedSlideshowListDone = true;
	},

	getSlideshowList : function(){
		if (this.getVoicemailScreensaverEnabled() && (this.unreadVoicemail || this.unreadMessage)){
			return this.arrVoicemailSlideshow;
		}
		else{
			return this.arrSlideshowFullpath;
		}
	},

	setScreensaverWebapp: function(screensaverSetting) {
		if( screensaverSetting ) {	// Note: screensaver can be undefined(?) or null
			this.screensaverWebapp = screensaverSetting.allowedValues[screensaverSetting.jsValue].id;
			this.loadedScreensaverDone = true;
		}
	},

	getScreensaverWebapp: function() {
		return this.screensaverWebapp;
	},

	setIsActiveScreensaver : function(boolActive){
		this._boolIsActiveScreensaver = boolActive;
	},

	getIsActiveScreensaver : function(){
		return this._boolIsActiveScreensaver;
	},



	/* Manage Demo Mode */
	setDemoMode : function(demoMode){
		this.demoMode = demoMode;
	},

	getDemoMode : function(){
		return this.demoMode;
	},
	/**
	 * Method called during the creation, when the demoType setting is received
	 * @params {Object} objSetting : demoType setting
	 */
	_setDemoType : function(demoTypeValue){
		ICTouchAPI.debugServices.info("webapp.screensaver.database - _setDemoType");
		if(this.getDemoMode()){
			ICTouchAPI.debugServices.debug("webapp.screensaver.database - _setDemoType / demoTypeValue is: " + demoTypeValue);
			if(demoTypeValue == 0){
				//this verification is done meant to be done after the controlBase
				//so if we actually are in demoMode true, the demoMode should be launched on the boot
				//but user can leave it
				this.demoTypeIdleSet = true;
				//We build the screensaver to be displayed
				ICTouchAPI.settingServices.getSettingValue("ScreensaverSlideshowList", this, this._loadedSlideshowList);
			}else if(demoTypeValue == 1){
				//we load the picture from the USB device
				this.loadFromUSBDevice();
			}else{
				//demoType = slideshow : we load the standard screensaver
				ICTouchAPI.settingServices.getSettingValue("ScreensaverSlideshowList", this, this._loadedSlideshowList);
			}
			webapp.screensaver.checkDataLoadedLaunchScreensaver();
		}else{
			//demoMode = false : we load the standard screensaver
			ICTouchAPI.settingServices.getSettingValue("ScreensaverSlideshowList", this, this._loadedSlideshowList);
		}
	},

	_loadedSlideshowList: function(slideshowList) {
		if (slideshowList) {
			this.arrSlideshow = slideshowList;
			this.buildSlideshowFullPathArray();
			this.loadedSlideshowListDone = true;
		}
	},

	/**
	 * Method called to count the number MAX of picture to be loaded
	 */
	loadFromUSBDevice : function(){
		//create / empty the pictures array
		this.arrSlideshow = [];

		//count the number MAX of picture to be loaded
		ICTouchAPI.APIServices.FileManager.getFilesInCategorySize({
			context: this,
			params: ["Picture"],
			callback: this.loadingFromUSBDevice
		});
	},

	/**
	 * Method called to laod the pictures stored on an USB device
	 * @params {integer} nb : number max of pictures to be loaded from the device
	 */
	loadingFromUSBDevice : function(nb){
		ICTouchAPI.APIServices.FileManager.getFilesWithFilter({
			params:["Picture",0,nb,"","1"], //"TYPE", min, max, "extension(jpg,gif...)", "0:userspace|1:USB"
			context:this,
			callback:this.loadedFromUSBDevice
		});
	},

	/**
	 * Callback done once we get all the images from usb
	 * @params {Array of Object} slideshowList : list of the files stored on the USB device
	 */
	loadedFromUSBDevice : function(slideshowList){
		//If we got any files
		if(slideshowList) {
			this.arrSlideshowFullpath = new Array(this.arrSlideshow.length);
			//we clean the list ...
			this.arrSlideshow = slideshowList;
			for (var i = 0; i < this.arrSlideshow.length; i++) {
				// ... keeping only the URL on the pictures
				this.arrSlideshowFullpath[i] = this.arrSlideshow[i].url;
			}

		}
		//we notify the end of the load
		this.loadedSlideshowListDone = true;
	},

	setAutoBackToHomepage : function(boolValue) {
		this.boolAutoBackToHomepage = boolValue;
		boolValue = null;
	},

	getAutoBackToHomepage : function() {
		return this.boolAutoBackToHomepage;
	},

	setCustomExitForVVM : function(boolExit){
		this.customExit = boolExit;
	}
});
