dojo.provide("webapp.screensaver.controlBase");

dojo.declare("webapp.screensaver.controlBase",ICTouchAPI.webApplication,
{
	uiScreensaver: null,
	presentationLoaded : null,

	screensaversView : "slideshowScreensaver",

	constructor : function() {
		ICTouchAPI.eventServices.subscribeToEvent(this, "SHOW_POPUP_EVENT", this._showPopUp);
	},

	loaded: function() {
        dojo.subscribe("setScreensaverZindex",this,this._setScreensaverZindex);

		ICTouchAPI.settingServices.subscribeToSetting(this, "ScreensaverSlideshowDelay", this._onScreensaverSlideshowDelay);
        ICTouchAPI.settingServices.getSetting("ScreensaverSlideshowDelay", this, this._onScreensaverSlideshowDelay);
		
		ICTouchAPI.settingServices.subscribeToSetting(this, "ScreenSaverEnabled", this._onScreenSaverEnabled);
        ICTouchAPI.settingServices.getSetting("ScreenSaverEnabled", this, this._onScreenSaverEnabled);

		ICTouchAPI.settingServices.subscribeToSetting(this, "EnableVoicemailScreensaver", this._onEnableVoicemailScreensaver);
		ICTouchAPI.settingServices.getSetting("EnableVoicemailScreensaver", this, this._onEnableVoicemailScreensaver);

		ICTouchAPI.settingServices.subscribeToSetting(this, "ScreensaverSlideshowList", this._onScreensaverSlideshowList);
		/* getSetting for ScreensaverSlideshowList is done in data, to manage Demo Mode */

		ICTouchAPI.settingServices.subscribeToSetting(this, "ScreenSaversListChoice", this._onScreenSaversListChoiceChanged);
		ICTouchAPI.settingServices.getSetting("ScreenSaversListChoice", this, this._onScreenSaversListChoiceChanged);

		ICTouchAPI.settingServices.subscribeToSetting(this, "ScreensaverBackToHomepageWhenOut", this._onScreensaverBackToHomepageChanged);
		ICTouchAPI.settingServices.getSetting("ScreensaverBackToHomepageWhenOut", this, this._onScreensaverBackToHomepageChanged);
		
        //Checking the demoType setting
		ICTouchAPI.settingServices.getSetting("CurrentDemoMode", this, this._demoModeReceived);
        ICTouchAPI.settingServices.getSetting("CurrentDemoType", this, this._demoTypeReceived);

		/*
         * 	WRK : crms_00202034 : the subscriptions
         * 	WRK : crms00239484 : those subscriptions listen events which will not be sent before the GreenManager catch the
         * 	presentationLoaded event which is sent from the ICTouchAPI.initWidgets function on the
         * 	unload of the initialization webapp.
         *
         * 	note : it's useless to try to delay the subscription and to synchronize it on the presentationLoaded event notification
         * 	as long as the Screensaver_On and Screensaver_Off are delayed by the GreenManager
        */
		ICTouchAPI.eventServices.subscribeToEvent(this, "Screensaver_On", this._screensaverOnReceived);
		ICTouchAPI.eventServices.subscribeToEvent(this, "Screensaver_Off", this._screensaverOffReceived);
		ICTouchAPI.eventServices.subscribeToEvent(this, "notifyVoiceMailCountChanged", this._voicemailCountChanged);
		ICTouchAPI.eventServices.subscribeToEvent(this, "FrontdeskMessageNotification", this._frontDeskMessageCountChanged);
		ICTouchAPI.eventServices.subscribeToEvent(this, "presentationLoaded", this._presentationLoaded);
		/*End of crms00239484*/
		
        dojo.subscribe("phoneLocked",this,this._reloadScreenSaver);
		dojo.subscribe("customExitForScreensaverVVM", this.data, this.data.setCustomExitForVVM);

		ICTouchAPI.APIServices.Comlog.count({params:[0,7], context:this, callback:this._gotVmCount});
    },

	dump : function(boolAdvancedLogs) {
		this.inherited(arguments);
		ICTouchAPI.debugServices.dump("Screensaver settings :");
		ICTouchAPI.debugServices.dump(" - ScreensaverSlideshowDelay (intDelay): " + this.data.getSlideshowDelay());
		ICTouchAPI.debugServices.dump(" - ScreenSaverEnabled (screenSaverEnabled): " + this.data.getScreenSaverEnabled());
		ICTouchAPI.debugServices.dump(" - EnableVoicemailScreensaver (voicemailScreensaverEnabled): " + this.data.getVoicemailScreensaverEnabled());
		ICTouchAPI.debugServices.dump(" - ScreensaverSlideshowList (arrSlideshowFullpath/arrVoicemailSlideshow): " + this.data.getSlideshowList());
		ICTouchAPI.debugServices.dump(" - ScreenSaversListChoice (screensaverWebapp): " + this.data.getScreensaverWebapp());
		ICTouchAPI.debugServices.dump(" - ScreensaverBackToHomepageWhenOut (boolAutoBackToHomepage): " + this.data.getAutoBackToHomepage());
		ICTouchAPI.debugServices.dump(" - CurrentDemoMode (demoMode): " + this.data.getDemoMode());
		ICTouchAPI.debugServices.dump("Screensaver internal variables :");
		ICTouchAPI.debugServices.dump(" - screensaverWebapp: " + this.data.screensaverWebapp);
		ICTouchAPI.debugServices.dump(" - Current screensaver screen (getCurrentScreensaverScreen): " + this.data.getCurrentScreensaverScreen());
		ICTouchAPI.debugServices.dump(" - screensaverZIndex: " + this.data.getScreensaverZIndex());
		ICTouchAPI.debugServices.dump(" - arrSlideshow: " + this.data.arrSlideshow);
		ICTouchAPI.debugServices.dump(" - arrSlideshowFullpath: " + this.data.arrSlideshowFullpath);
		ICTouchAPI.debugServices.dump(" - arrVoicemailSlideshow: " + this.data.arrVoicemailSlideshow);
		ICTouchAPI.debugServices.dump(" - unreadVoicemail: " + this.data.unreadVoicemail);
		ICTouchAPI.debugServices.dump(" - unreadMessage: " + this.data.unreadMessage);
		ICTouchAPI.debugServices.dump(" - demoTypeIdleSet: " + this.data.demoTypeIdleSet);
		ICTouchAPI.debugServices.dump(" - IsActiveScreensaver (_boolIsActiveScreensaver): " + this.data.getIsActiveScreensaver());
		if (boolAdvancedLogs) {
			ICTouchAPI.debugServices.dump("loadedScreensaverDone: " + this.data.loadedScreensaverDone);
			ICTouchAPI.debugServices.dump("loadedSlideshowListDone: " + this.data.loadedSlideshowListDone);
			ICTouchAPI.debugServices.dump("loadedSlideshowDelayDone: " + this.data.loadedSlideshowDelayDone);
			ICTouchAPI.debugServices.dump("loadedScreenSaverEnabledDone: " + this.data.loadedScreenSaverEnabledDone);
		}
	},

	getApplicationName : function(){
		return "webapp.screensaver";
	},

	launchScreensaver: function() {
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - launchScreensaver");
		//Build screensaver screen
		ICTouchAPI.transitionServices.getScreen({
			name : this.data.getCurrentScreensaverScreen(),
			params:  {},
			position: "FullScreen",
			zindex : this.data.getScreensaverZIndex()
		});
		this.data.setIsActiveScreensaver(true);
		//Launch onScreensaverOn function(if exist) of the current screensaver webapp
		if(typeof(webapp[this.data.getScreensaverWebapp()].onScreensaverOn)==="function") {
			webapp[this.data.getScreensaverWebapp()].onScreensaverOn();
		}
	},

	destroyScreensaver: function() {
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - destroyScreensaver");
		// Sometimes, we leave screensaver by a getScreen (i.e. incomming call), so when this function is called, we are no more in screensaver.
		// Call the back only if we still are
		if(ICTouchAPI.transitionServices.getCurrentScreenName() == this.data.getCurrentScreensaverScreen()){
			if(!this.data.customExit){
				if(webapp.lock && webapp.lock.isLocked()){
					ICTouchAPI.transitionServices.getScreen({
						name: "webapp.lock.getLock",
						params:  {},
						position: "FullScreen"
					});
				}else{
					if(this.data.getAutoBackToHomepage()){
						dojo.publish("OpenHomepage");
					} else {
						ICTouchAPI.transitionServices.back();
					}
				}
			}else{
				if(webapp.lock){
					if(webapp.lock.isLocked()){
						ICTouchAPI.transitionServices.back();
					}else{
						dojo.publish("OpenHomepage");
					}
					dojo.publish("resetCustomExit",["screensaver"]);
				}
			}
		}
		this.data.setIsActiveScreensaver(false);
		//Launch onScreensaverOff function(if exist) of the current screensaver webapp
		if(typeof(webapp[this.data.getScreensaverWebapp()].onScreensaverOff)==="function") {
			webapp[this.data.getScreensaverWebapp()].onScreensaverOff();
		}
	},

	updateScreensaverSlideshow : function(){
		if (this.uiScreensaver){
			this.uiScreensaver.updateSlideshow(this.data.getSlideshowList());
		}
	},

	onScreensaverOn : function() {
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - onScreensaverOn");
		if(this.uiScreensaver!=null) {
			this.uiScreensaver.launchSlideshow();
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.screensaver.controlBase - onScreensaverOn / this.uiScreensaver is null");
		}
	},

	onScreensaverOff : function() {
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - onScreensaverOff");
		if(this.uiScreensaver!=null) {
			this.uiScreensaver.stopSlideshow();
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.screensaver.controlBase - onScreensaverOff / this.uiScreensaver is null");
		}
	},

	_setScreensaverOn: function() {
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - _setScreensaverOn");
		ICTouchAPI.APIServices.GreenManager.setScreensaverState({
			params: ["true"],
			context: this
		});
	},

	_setScreensaverOff: function() {
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - _setScreensaverOff");
		ICTouchAPI.APIServices.GreenManager.setScreensaverState({
			params: ["false"],
			context: this
		});
	},

	_showPopUp: function() {
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - _showPopUp");
		this._setScreensaverOff();
	},

	_setScreensaverZindex: function(zIndex){
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - _setScreensaverZindex");
		if(zIndex && typeof (zIndex) == "string") {
			ICTouchAPI.debugServices.debug("webapp.screensaver.controlBase - _setScreensaverZindex / previous value: " + this.data.getScreensaverZIndex());
			ICTouchAPI.debugServices.debug("webapp.screensaver.controlBase - _setScreensaverZindex / new value: " + zIndex);
			this.data.setScreensaverZIndex(zIndex);
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.screensaver.controlBase - _setScreensaverZindex / zIndex is not defined or is not a string: " + zIndex);
		}
	},

	// WRK : crms_00202230
	_onScreensaverSlideshowDelay: function(slideshowDelaySetting) {
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - _onScreensaverSlideshowDelay");
		if (slideshowDelaySetting) {
			ICTouchAPI.debugServices.debug("webapp.screensaver.controlBase - _onScreensaverSlideshowDelay / previous value: " + this.data.getSlideshowDelay());
			ICTouchAPI.debugServices.debug("webapp.screensaver.controlBase - _onScreensaverSlideshowDelay / new value: " + slideshowDelaySetting.jsValue);
			this.data.setSlideshowDelay(slideshowDelaySetting.jsValue);
			dojo.publish("screensaver.delay", [slideshowDelaySetting.jsValue]);
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.screensaver.controlBase - _onScreensaverSlideshowDelay / slideshowDelaySetting is not defined: " + slideshowDelaySetting);
		}
	},

	// WRK : crms_00202034
	_onScreenSaverEnabled: function(screenSaverEnabledSetting) {
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - _onScreenSaverEnabled");
		if (screenSaverEnabledSetting) {
			ICTouchAPI.debugServices.debug("webapp.screensaver.controlBase - _onScreenSaverEnabled / previous value: " + this.data.getScreenSaverEnabled());
			ICTouchAPI.debugServices.debug("webapp.screensaver.controlBase - _onScreenSaverEnabled / new value: " + screenSaverEnabledSetting.jsValue);
			this.data.setScreenSaverEnabled(screenSaverEnabledSetting.jsValue);
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.screensaver.controlBase - _onScreenSaverEnabled / screenSaverEnabledSetting is not defined: " + screenSaverEnabledSetting);
		}
	},

	_onEnableVoicemailScreensaver : function(vmSetting) {
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - _onEnableVoicemailScreensaver");
		if (vmSetting) {
			ICTouchAPI.debugServices.debug("webapp.screensaver.controlBase - _onEnableVoicemailScreensaver / previous value: " + this.data.getVoicemailScreensaverEnabled());
			ICTouchAPI.debugServices.debug("webapp.screensaver.controlBase - _onEnableVoicemailScreensaver / new value: " + vmSetting.jsValue);
			this.data.setVoicemailScreensaverEnabled(vmSetting.jsValue);
			this.updateScreensaverSlideshow();
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.screensaver.controlBase - _onEnableVoicemailScreensaver / vmSetting is not defined: " + vmSetting);
		}
	},

	_onScreensaverSlideshowList: function(slideshowList) {
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - ScreensaverSlideshowList");
		if (slideshowList) {
			ICTouchAPI.debugServices.debug("webapp.screensaver.controlBase - ScreensaverSlideshowList / previous slideshowList: " + this.data.arrSlideshow);
			ICTouchAPI.debugServices.debug("webapp.screensaver.controlBase - ScreensaverSlideshowList / new slideshowList: " + [slideshowList.jsValue]);
			this.data.setSlideshowList(slideshowList.jsValue);
			this.updateScreensaverSlideshow();
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.screensaver.controlBase - ScreensaverSlideshowList / slideshowList is not defined: " + slideshowList);
		}
	},

	_onScreenSaversListChoiceChanged : function(screen){
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - _onScreenSaversListChoiceChanged");
		this.data.setScreensaverWebapp(screen);
	},

	_demoModeReceived : function(demoMode) {
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - _demoModeReceived");
		if (demoMode) {
			ICTouchAPI.debugServices.debug("webapp.screensaver.controlBase - _demoModeReceived / value of demoMode is: " + demoMode.jsValue);
			this.data.setDemoMode(demoMode.jsValue);
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.screensaver.controlBase - _demoModeReceived / demoMode is not defined: " + demoMode);
		}
	},

	/**
	 * Method called during the creation, when the demoType setting is received
	 * @params {Object} objSetting : demoType setting
	 */
	_demoTypeReceived : function(objSetting){
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - _demoTypeReceived");
		if(objSetting){
			this.data._setDemoType(objSetting.jsValue);
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.screensaver.controlBase - _demoTypeReceived / objSetting is not defined: " + objSetting);
		}
	},
	
	// Used in demoMode only
	_checkDataLoadedLaunchScreensaver : function() {
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - _checkDataLoadedLaunchScreensaver");
		var myself = dojo.hitch(this, this._checkDataLoadedLaunchScreensaver);
		if (!(webapp.screensaver.data.loadedScreensaverDone	&& webapp.screensaver.data.loadedSlideshowListDone && webapp.screensaver.data.loadedSlideshowDelayDone)) {
			setTimeout(myself, 500);
		}
		else {
			this._setScreensaverOn();
			webapp.screensaver.launchScreensaver();
		}
	},

	_screensaverOnReceived: function() {
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - _screensaverOnReceived");
		dojo.publish("requestCustomVVMExit",["screensaver"]);
		webapp.screensaver.launchScreensaver();
	},

	_screensaverOffReceived: function() {
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - _screensaverOffReceived");
		if (!webapp.screensaver.data.getDemoMode() || webapp.screensaver.data.demoTypeIdleSet) {
			webapp.screensaver.destroyScreensaver();
		}
	},

	_voicemailCountChanged : function(notif) {
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - _voicemailCountChanged");
		if(notif.value>0){
			if(this.data.unreadVoicemail !== true){
				this.data.unreadVoicemail = true;
				this.updateScreensaverSlideshow();
			}
		}else{
			if(this.data.unreadVoicemail !== false){
				this.data.unreadVoicemail = false;
				this.updateScreensaverSlideshow();
			}
		}
	},

	_gotVmCount : function(count){
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - _gotVmCount");
		if (count >0 && this.data.unreadVoicemail !== true){
			this.data.unreadVoicemail = true;
			this.updateScreensaverSlideshow();
		}
	},

	_frontDeskMessageCountChanged : function(){
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - _frontDeskMessageCountChanged");
		var objArguments = ICTouchAPI.tools.getEventArguments(arguments);
		var activation = objArguments.activation || "";
		if(activation){
			if(this.data.unreadMessage !== true){
				this.data.unreadMessage = true;
				this.updateScreensaverSlideshow();
			}
		}
		else{
			if(this.data.unreadMessage !== false){
				this.data.unreadMessage = false;
				this.updateScreensaverSlideshow();
			}
		}

	},

	/**
     * Method called when the presentationLoaded event is caught
     */
	_presentationLoaded : function(){
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - _presentationLoaded");
		webapp.screensaver.presentationLoaded = true;
		ICTouchAPI.eventServices.unsubscribeToEvent(this,"presentationLoaded");
	},

	_reloadScreenSaver:function(){
		ICTouchAPI.debugServices.info("webapp.screensaver.controlBase - _reloadScreenSaver");
		if(this.data.getIsActiveScreensaver()) {
			var func = function() {webapp.screensaver.launchScreensaver();};
			setTimeout(func,100);
		}
	},

	unlock : function(){
		if(this.data.getDemoMode()===true && this.data.demoTypeIdleSet!==true) {
			dojo.publish("unlockTransition",[false]);
		}
		else {
			dojo.publish("unlockTransition",[true]);
		}
	},

	_onScreensaverBackToHomepageChanged : function(objSettingBackToHomepage) {
		if(objSettingBackToHomepage){
			this.data.setAutoBackToHomepage(objSettingBackToHomepage.jsValue);
		}
		objSettingBackToHomepage = null;
	}
});
